/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.core.ParameterNameDiscoverer;

public class PrioritizedParameterNameDiscoverer
implements ParameterNameDiscoverer {
    private final List<ParameterNameDiscoverer> parameterNameDiscoverers = new ArrayList<ParameterNameDiscoverer>(2);

    public void addDiscoverer(ParameterNameDiscoverer pnd) {
        this.parameterNameDiscoverers.add(pnd);
    }

    @Override
    public @Nullable String @Nullable [] getParameterNames(Method method) {
        for (ParameterNameDiscoverer pnd : this.parameterNameDiscoverers) {
            @Nullable String[] result = pnd.getParameterNames(method);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public @Nullable String @Nullable [] getParameterNames(Constructor<?> ctor) {
        for (ParameterNameDiscoverer pnd : this.parameterNameDiscoverers) {
            @Nullable String[] result = pnd.getParameterNames(ctor);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

