/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper;

import com.ghostchu.peerbanhelper.CrashManager;
import com.ghostchu.peerbanhelper.DownloaderServerImpl;
import com.ghostchu.peerbanhelper.ExternalSwitch;
import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.alert.AlertLevel;
import com.ghostchu.peerbanhelper.alert.AlertManager;
import com.ghostchu.peerbanhelper.database.Database;
import com.ghostchu.peerbanhelper.downloader.DownloaderManager;
import com.ghostchu.peerbanhelper.event.program.PBHServerStartedEvent;
import com.ghostchu.peerbanhelper.exchange.ExchangeMap;
import com.ghostchu.peerbanhelper.gui.TaskbarState;
import com.ghostchu.peerbanhelper.module.ModuleManager;
import com.ghostchu.peerbanhelper.module.impl.background.SQLiteOptimizerModule;
import com.ghostchu.peerbanhelper.module.impl.monitor.ActiveMonitoringModule;
import com.ghostchu.peerbanhelper.module.impl.monitor.PeerRecodingServiceModule;
import com.ghostchu.peerbanhelper.module.impl.monitor.SessionAnalyseServiceModule;
import com.ghostchu.peerbanhelper.module.impl.monitor.SwarmTrackingModule;
import com.ghostchu.peerbanhelper.module.impl.rule.AntiVampire;
import com.ghostchu.peerbanhelper.module.impl.rule.AutoRangeBan;
import com.ghostchu.peerbanhelper.module.impl.rule.BtnNetworkOnline;
import com.ghostchu.peerbanhelper.module.impl.rule.ClientNameBlacklist;
import com.ghostchu.peerbanhelper.module.impl.rule.ExpressionRule;
import com.ghostchu.peerbanhelper.module.impl.rule.IPBlackList;
import com.ghostchu.peerbanhelper.module.impl.rule.IPBlackRuleList;
import com.ghostchu.peerbanhelper.module.impl.rule.IdleConnectionDosProtection;
import com.ghostchu.peerbanhelper.module.impl.rule.MultiDialingBlocker;
import com.ghostchu.peerbanhelper.module.impl.rule.PeerIdBlacklist;
import com.ghostchu.peerbanhelper.module.impl.rule.PeerNameBlackRuleList;
import com.ghostchu.peerbanhelper.module.impl.rule.ProgressCheatBlocker;
import com.ghostchu.peerbanhelper.module.impl.webapi.BlockListController;
import com.ghostchu.peerbanhelper.module.impl.webapi.PBHAlertController;
import com.ghostchu.peerbanhelper.module.impl.webapi.PBHAsyncTaskController;
import com.ghostchu.peerbanhelper.module.impl.webapi.PBHAuthenticateController;
import com.ghostchu.peerbanhelper.module.impl.webapi.PBHAutoStunController;
import com.ghostchu.peerbanhelper.module.impl.webapi.PBHBanController;
import com.ghostchu.peerbanhelper.module.impl.webapi.PBHChartController;
import com.ghostchu.peerbanhelper.module.impl.webapi.PBHDownloaderController;
import com.ghostchu.peerbanhelper.module.impl.webapi.PBHEasterEggController;
import com.ghostchu.peerbanhelper.module.impl.webapi.PBHGeneralController;
import com.ghostchu.peerbanhelper.module.impl.webapi.PBHLabController;
import com.ghostchu.peerbanhelper.module.impl.webapi.PBHLogsController;
import com.ghostchu.peerbanhelper.module.impl.webapi.PBHMetadataController;
import com.ghostchu.peerbanhelper.module.impl.webapi.PBHMetricsController;
import com.ghostchu.peerbanhelper.module.impl.webapi.PBHOOBEController;
import com.ghostchu.peerbanhelper.module.impl.webapi.PBHPeerController;
import com.ghostchu.peerbanhelper.module.impl.webapi.PBHPlusController;
import com.ghostchu.peerbanhelper.module.impl.webapi.PBHPushController;
import com.ghostchu.peerbanhelper.module.impl.webapi.PBHTorrentController;
import com.ghostchu.peerbanhelper.module.impl.webapi.PBHUtilitiesController;
import com.ghostchu.peerbanhelper.module.impl.webapi.RuleSubController;
import com.ghostchu.peerbanhelper.platform.Platform;
import com.ghostchu.peerbanhelper.platform.impl.win32.workingset.jna.WorkingSetManagerFactory;
import com.ghostchu.peerbanhelper.platform.types.EcoQosAPI;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.ipdb.IPDBManager;
import com.ghostchu.peerbanhelper.web.JavalinWebContainer;
import com.ghostchu.simplereloadlib.ReloadResult;
import com.ghostchu.simplereloadlib.Reloadable;
import io.javalin.util.JavalinBindException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.util.Locale;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PeerBanHelper
implements Reloadable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PeerBanHelper.class);
    @Autowired
    private DownloaderManager downloaderManager;
    @Autowired
    private DownloaderServerImpl downloaderServer;
    private int httpdPort;
    @Autowired
    private Database databaseManager;
    @Autowired
    private ModuleManager moduleManager;
    @Autowired
    private JavalinWebContainer webContainer;
    @Autowired
    private AlertManager alertManager;
    @Autowired
    private CrashManager crashManager;
    @Autowired
    private IPDBManager iPDBManager;

    public PeerBanHelper() {
        this.reloadConfig();
    }

    private void reloadConfig() {
        this.httpdPort = ExternalSwitch.parseInt("pbh.port", Main.getMainConfig().getInt("server.http"));
    }

    public ReloadResult reloadModule() throws Exception {
        this.reloadConfig();
        this.moduleManager.reloadModuleStates();
        return super.reloadModule();
    }

    public void start() {
        this.loadPlatformFeatures();
        this.checkKnownCrashes();
        Main.getReloadManager().register((Reloadable)this);
        this.postCompatibilityCheck();
        this.registerModules();
        this.sendSnapshotAlert();
        this.downloaderServer.load();
        this.downloaderServer.loadBanListToMemory();
        Main.getGuiManager().taskbarControl().updateProgress(null, TaskbarState.OFF, 0.0f);
        this.crashManager.putRunningFlag();
        Main.getEventBus().post((Object)new PBHServerStartedEvent());
        this.registerHttpServer();
        Main.getGuiManager().onPBHFullyStarted(this);
        if (this.webContainer.getToken() == null || this.webContainer.getToken().isBlank()) {
            for (int i = 0; i < 50; ++i) {
                log.error(TextManager.tlUI(Lang.PBH_OOBE_REQUIRED, "http://127.0.0.1:" + this.webContainer.javalin().port()));
            }
            Main.getGuiManager().openUrlInBrowser("http://127.0.0.1:" + this.webContainer.javalin().port());
        }
        String os = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        System.gc();
        Thread.startVirtualThread(() -> {
            if (os.startsWith("win")) {
                WorkingSetManagerFactory.trimMemory();
            }
        });
        this.runTestCode();
    }

    private void loadPlatformFeatures() {
        Platform platform = Main.getPlatform();
        if (platform == null) {
            return;
        }
        EcoQosAPI ecoQosAPI = platform.getEcoQosAPI();
        if (ecoQosAPI != null && Main.getMainConfig().getBoolean("performance.windows-ecoqos-api")) {
            ecoQosAPI.apply();
        }
    }

    private void checkKnownCrashes() {
        RuntimeMXBean bean;
        this.crashManager.checkCrashRecovery();
        String os = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if (os.startsWith("win") && Main.getGuiManager().isGuiAvailable() && !(bean = ManagementFactory.getRuntimeMXBean()).getVmVendor().contains("JetBrains") && !this.alertManager.identifierAlertExistsIncludeRead("incompatibility-jre-windows-liberica")) {
            this.alertManager.publishAlert(false, AlertLevel.WARN, "incompatibility-jre-windows-liberica", new TranslationComponent(Lang.JBR_REQUIRED_TITLE), new TranslationComponent(Lang.JBR_REQUIRED_DESCRIPTION, bean.getVmVendor(), bean.getVmVersion()));
            Main.getGuiManager().createDialog(Level.WARN, TextManager.tlUI(new TranslationComponent(Lang.JBR_REQUIRED_TITLE)), TextManager.tlUI(new TranslationComponent(Lang.JBR_REQUIRED_DESCRIPTION, bean.getVmVendor(), bean.getVmVersion())), () -> {});
        }
    }

    private void postCompatibilityCheck() {
        if (ExternalSwitch.parseBoolean("pbh.forceBitnessCheckFail")) {
            ExchangeMap.UNSUPPORTED_PLATFORM = true;
            ExchangeMap.GUI_DISPLAY_FLAGS.add(new ExchangeMap.DisplayFlag("unsupported-platform", 10, TextManager.tlUI(Lang.TITLE_INCOMPATIBLE_PLATFORM, new Object[0])));
            log.warn(TextManager.tlUI(Lang.INCOMPATIBLE_BITNESS_LOG, new Object[0]));
            if (!this.alertManager.identifierAlertExistsIncludeRead("incomaptible-bitness")) {
                this.alertManager.publishAlert(false, AlertLevel.WARN, "incomaptible-bitness", new TranslationComponent(Lang.INCOMPATIBLE_BITNESS_TITLE), new TranslationComponent(Lang.INCOMPATIBLE_BITNESS_DESCRIPTION));
                Main.getGuiManager().createNotification(Level.WARN, TextManager.tlUI(Lang.INCOMPATIBLE_BITNESS_TITLE, new Object[0]), TextManager.tlUI(Lang.INCOMPATIBLE_BITNESS_DESCRIPTION, new Object[0]));
            }
        }
        if (ExternalSwitch.parseBoolean("pbh.app-v")) {
            ExchangeMap.GUI_DISPLAY_FLAGS.add(new ExchangeMap.DisplayFlag("app-v", 10, TextManager.tlUI(Lang.TITLE_APP_V_CONTAINER, new Object[0])));
        }
    }

    private void runTestCode() {
        if (!Main.getMeta().isSnapshotOrBeta()) {
            return;
        }
        ExchangeMap.GUI_DISPLAY_FLAGS.add(new ExchangeMap.DisplayFlag("debug-mode", 20, TextManager.tlUI(Lang.GUI_TITLE_DEBUG, new Object[0])));
    }

    private void sendSnapshotAlert() {
        if (Main.getMeta().isSnapshotOrBeta()) {
            this.alertManager.publishAlert(false, AlertLevel.INFO, "unstable-alert", new TranslationComponent(Lang.ALERT_SNAPSHOT), new TranslationComponent(Lang.ALERT_SNAPSHOT_DESCRIPTION));
        } else {
            this.alertManager.markAlertAsRead("unstable-alert");
        }
    }

    public void shutdown() {
        this.downloaderServer.close();
        this.moduleManager.unregisterAll();
        this.databaseManager.close();
        try {
            this.downloaderManager.close();
        }
        catch (Exception e) {
            log.warn("Unable to safe shutdown downloader manager", (Throwable)e);
        }
        Main.getReloadManager().unregister((Reloadable)this);
        log.info(TextManager.tlUI(Lang.SHUTDOWN_DONE, new Object[0]));
    }

    private void registerHttpServer() {
        block4: {
            String token = ExternalSwitch.parse("pbh.apiToken", Main.getMainConfig().getString("server.token"));
            String host = ExternalSwitch.parse("pbh.serverAddress", Main.getMainConfig().getString("server.address"));
            if (host.equals("0.0.0.0") || host.equals("::") || host.equals("localhost")) {
                host = null;
            }
            try {
                this.webContainer.start(host, this.httpdPort, token);
            }
            catch (JavalinBindException e) {
                if (e.getMessage().contains("Port already in use")) {
                    log.error(TextManager.tlUI(Lang.JAVALIN_PORT_IN_USE, this.httpdPort));
                    throw new JavalinBindException(TextManager.tlUI(Lang.JAVALIN_PORT_IN_USE, this.httpdPort), (Throwable)e);
                }
                if (!e.getMessage().contains("require elevated privileges")) break block4;
                log.error(TextManager.tlUI(Lang.JAVALIN_PORT_REQUIRE_PRIVILEGES, new Object[0]));
                throw new JavalinBindException(TextManager.tlUI(Lang.JAVALIN_PORT_REQUIRE_PRIVILEGES, this.httpdPort), (Throwable)e);
            }
        }
    }

    private void registerModules() {
        log.info(TextManager.tlUI(Lang.WAIT_FOR_MODULES_STARTUP, new Object[0]));
        this.moduleManager.register(PBHAsyncTaskController.class);
        this.moduleManager.register(PBHGeneralController.class);
        this.moduleManager.register(IPBlackList.class);
        this.moduleManager.register(PeerIdBlacklist.class);
        this.moduleManager.register(ClientNameBlacklist.class);
        this.moduleManager.register(ExpressionRule.class);
        this.moduleManager.register(ProgressCheatBlocker.class);
        this.moduleManager.register(MultiDialingBlocker.class);
        this.moduleManager.register(AutoRangeBan.class);
        this.moduleManager.register(BtnNetworkOnline.class);
        this.moduleManager.register(BlockListController.class);
        this.moduleManager.register(IPBlackRuleList.class);
        if (ExternalSwitch.parseBoolean("pbh.modules.peerclientnameblackrulelist.testing", false)) {
            this.moduleManager.register(PeerNameBlackRuleList.class);
        }
        this.moduleManager.register(PBHMetricsController.class);
        this.moduleManager.register(PBHBanController.class);
        this.moduleManager.register(PBHMetadataController.class);
        this.moduleManager.register(PBHDownloaderController.class);
        this.moduleManager.register(RuleSubController.class);
        this.moduleManager.register(PBHAuthenticateController.class);
        this.moduleManager.register(ActiveMonitoringModule.class);
        this.moduleManager.register(PBHPlusController.class);
        this.moduleManager.register(PBHOOBEController.class);
        this.moduleManager.register(PBHChartController.class);
        this.moduleManager.register(PBHTorrentController.class);
        this.moduleManager.register(PBHPeerController.class);
        this.moduleManager.register(PBHAlertController.class);
        this.moduleManager.register(PBHLogsController.class);
        this.moduleManager.register(PBHPushController.class);
        this.moduleManager.register(PBHLabController.class);
        this.moduleManager.register(PBHEasterEggController.class);
        this.moduleManager.register(PBHUtilitiesController.class);
        this.moduleManager.register(SQLiteOptimizerModule.class);
        this.moduleManager.register(SwarmTrackingModule.class);
        this.moduleManager.register(PBHAutoStunController.class);
        this.moduleManager.register(IdleConnectionDosProtection.class);
        this.moduleManager.register(SessionAnalyseServiceModule.class);
        this.moduleManager.register(PeerRecodingServiceModule.class);
        this.moduleManager.register(AntiVampire.class);
    }

    @Deprecated(forRemoval=true)
    public IPDBManager.IPDBResponse queryIPDB(InetAddress address) {
        return this.iPDBManager.queryIPDB(address);
    }

    @Nullable
    public JavalinWebContainer getWebContainer() {
        return this.webContainer;
    }

    @Generated
    public DownloaderManager getDownloaderManager() {
        return this.downloaderManager;
    }

    @Generated
    public DownloaderServerImpl getDownloaderServer() {
        return this.downloaderServer;
    }

    @Generated
    public int getHttpdPort() {
        return this.httpdPort;
    }
}

