/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.btn.ability.impl;

import com.ghostchu.peerbanhelper.btn.BtnNetwork;
import com.ghostchu.peerbanhelper.btn.ability.AbstractBtnAbility;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.json.JsonUtil;
import com.google.common.net.InetAddresses;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.spotify.futures.CompletableFutures;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import lombok.Generated;
import okhttp3.Dns;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BtnAbilityHeartBeat
extends AbstractBtnAbility {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BtnAbilityHeartBeat.class);
    private final BtnNetwork btnNetwork;
    private final long interval;
    private final long randomInitialDelay;
    private final String endpoint;
    private final boolean multiIf;
    private final boolean powCaptcha;
    private String lastResult = "No information";

    public BtnAbilityHeartBeat(BtnNetwork btnNetwork, JsonObject ability) {
        this.btnNetwork = btnNetwork;
        this.interval = ability.get("interval").getAsLong();
        this.endpoint = ability.get("endpoint").getAsString();
        this.multiIf = ability.get("multi_if").getAsBoolean();
        this.randomInitialDelay = ability.get("random_initial_delay").getAsLong();
        this.powCaptcha = ability.has("pow_captcha") && ability.get("pow_captcha").getAsBoolean();
    }

    @Override
    public String getName() {
        return "BtnAbilityHeartBeat";
    }

    @Override
    public TranslationComponent getDisplayName() {
        return new TranslationComponent(Lang.BTN_HEARTBEAT_TITLE);
    }

    @Override
    public TranslationComponent getDescription() {
        return new TranslationComponent(Lang.BTN_HEARTBEAT_DESCRIPTION, this.lastResult);
    }

    @Override
    public void load() {
        this.setLastStatus(true, new TranslationComponent(Lang.BTN_STAND_BY));
        this.btnNetwork.getScheduler().scheduleWithFixedDelay(this::sendHeartBeat, ThreadLocalRandom.current().nextLong(this.randomInitialDelay), this.interval, TimeUnit.MILLISECONDS);
        this.lastResult = "Scheduled";
    }

    private void sendHeartBeat() {
        if (this.multiIf) {
            this.sendHeartBeatMultiIf();
        } else {
            this.sendHeartBeatDefaultIf();
        }
    }

    private void sendHeartBeatDefaultIf() {
        this.lastResult = "Requesting as default interface";
        RequestBody body = RequestBody.create((String)JsonUtil.standard().toJson(Map.of("ifaddr", "default")), (MediaType)MediaType.parse((String)"application/json"));
        Request.Builder request = new Request.Builder().url(this.endpoint).post(body);
        if (this.powCaptcha) {
            this.btnNetwork.gatherAndSolveCaptchaBlocking(request, "heartbeat");
        }
        try (Response resp = this.btnNetwork.getHttpUtil().newBuilder().build().newCall(request.build()).execute();){
            String responseBody = resp.body().string();
            if (!resp.isSuccessful()) {
                this.setLastStatus(true, new TranslationComponent(Lang.BTN_HEARTBEAT_FAILED));
                this.lastResult = "default -> Failed: " + resp.code() + " - " + responseBody;
            } else {
                this.setLastStatus(true, new TranslationComponent(Lang.BTN_HEARTBEAT_SUCCESS));
                ServerResponse data = (ServerResponse)JsonUtil.standard().fromJson(resp.body().charStream(), ServerResponse.class);
                this.lastResult = data != null && data.getExternalIp() != null ? "default -> " + data.getExternalIp() : "default -> No External IP returned";
            }
        }
        catch (IOException | JSONException e) {
            this.lastResult = "default -> Failed: " + e.getClass().getName() + ": " + e.getMessage();
            this.setLastStatus(true, new TranslationComponent(Lang.BTN_HEARTBEAT_FAILED));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendHeartBeatMultiIf() {
        List futures = Collections.synchronizedList(new ArrayList());
        AtomicBoolean anySuccess = new AtomicBoolean(false);
        ArrayList<String> ifNets = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface netif = interfaces.nextElement();
                Enumeration<InetAddress> addrs = netif.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress addr = addrs.nextElement();
                    String ip2 = addr.getHostAddress();
                    ifNets.add(ip2);
                }
            }
        }
        catch (SocketException exception) {
            log.warn("No interfaces found", (Throwable)exception);
        }
        Map result = Collections.synchronizedMap(new TreeMap());
        ifNets.forEach(ip -> {
            futures.add(CompletableFuture.runAsync(() -> this.requestHeartbeat((String)ip, true, result, anySuccess), Executors.newVirtualThreadPerTaskExecutor()));
            futures.add(CompletableFuture.runAsync(() -> this.requestHeartbeat((String)ip, false, result, anySuccess), Executors.newVirtualThreadPerTaskExecutor()));
        });
        this.lastResult = "Waiting for all heartbeat requests to complete";
        try {
            CompletableFutures.allAsList(futures).get(30L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            log.warn("Heartbeat request timed out");
        }
        catch (InterruptedException | ExecutionException e) {
            log.warn("Heartbeat request failed", (Throwable)e);
        }
        finally {
            futures.forEach(future -> {
                if (!future.isDone() && !future.isCompletedExceptionally()) {
                    future.cancel(true);
                }
            });
        }
        if (anySuccess.get()) {
            this.setLastStatus(true, new TranslationComponent(Lang.BTN_HEARTBEAT_SUCCESS));
        } else {
            this.setLastStatus(false, new TranslationComponent(Lang.BTN_HEARTBEAT_FAILED));
        }
        StringBuilder builder = new StringBuilder();
        for (String ip3 : new LinkedHashSet(result.values())) {
            builder.append(ip3).append("  \n");
        }
        this.lastResult = builder.toString();
    }

    private void requestHeartbeat(String ip, boolean useProxy, Map<String, String> result, AtomicBoolean anySuccess) {
        OkHttpClient client = this.createHttpClient(ip, useProxy);
        RequestBody body = RequestBody.create((String)JsonUtil.standard().toJson(Map.of("ifaddr", ip)), (MediaType)MediaType.parse((String)"application/json"));
        Request.Builder request = new Request.Builder().url(this.endpoint).post(body);
        if (this.powCaptcha) {
            this.btnNetwork.gatherAndSolveCaptchaBlocking(request, "heartbeat");
        }
        try (Response resp = client.newCall(request.build()).execute();){
            String responseBody = resp.body().string();
            if (!resp.isSuccessful()) {
                result.put(ip, "Failed: " + resp.code() + ": " + responseBody);
            } else {
                ServerResponse data = (ServerResponse)JsonUtil.standard().fromJson(responseBody, ServerResponse.class);
                if (data != null && data.getExternalIp() != null) {
                    result.put(ip, data.getExternalIp());
                    anySuccess.set(true);
                } else {
                    result.put(ip, "Failed: No external IP returned");
                }
            }
        }
        catch (IOException | JSONException e) {
            result.put(ip, "Failed: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private OkHttpClient createHttpClient(final String ifNet, boolean useProxy) {
        X509TrustManager trustManager;
        InetAddress localAddress;
        try {
            localAddress = InetAddresses.forString((String)ifNet);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid local IP address: " + ifNet, e);
        }
        boolean isIPv4 = localAddress instanceof Inet4Address;
        OkHttpClient.Builder builder = this.btnNetwork.getHttpClient().newBuilder().dns(hostname -> {
            List allAddresses = Dns.SYSTEM.lookup(hostname);
            ArrayList<InetAddress> filteredAddresses = new ArrayList<InetAddress>();
            for (InetAddress address : allAddresses) {
                boolean targetIsIPv4 = address instanceof Inet4Address;
                if (isIPv4 != targetIsIPv4) continue;
                filteredAddresses.add(address);
            }
            if (filteredAddresses.isEmpty()) {
                return allAddresses;
            }
            return filteredAddresses;
        }).socketFactory(new SocketFactory(this){
            private final SocketFactory defaultFactory;
            {
                Objects.requireNonNull(this$0);
                this.defaultFactory = SocketFactory.getDefault();
            }

            private Socket createAndBindSocket(InetAddress targetAddress) throws IOException {
                if (localAddress instanceof Inet4Address != targetAddress instanceof Inet4Address) {
                    throw new IOException("Address family mismatch: cannot bind " + (localAddress instanceof Inet4Address ? "IPv4" : "IPv6") + " local address to " + (targetAddress instanceof Inet4Address ? "IPv4" : "IPv6") + " target");
                }
                Socket socket = new Socket();
                try {
                    socket.bind(new InetSocketAddress(localAddress, 0));
                }
                catch (IOException e) {
                    throw new IOException("Failed to bind to local IP address: " + ifNet, e);
                }
                return socket;
            }

            @Override
            public Socket createSocket() throws IOException {
                return this.defaultFactory.createSocket();
            }

            @Override
            public Socket createSocket(String host, int port) throws IOException {
                InetAddress address = InetAddress.getByName(host);
                Socket socket = this.createAndBindSocket(address);
                socket.connect(new InetSocketAddress(address, port));
                return socket;
            }

            @Override
            public Socket createSocket(InetAddress address, int port) throws IOException {
                Socket socket = this.createAndBindSocket(address);
                socket.connect(new InetSocketAddress(address, port));
                return socket;
            }

            @Override
            public Socket createSocket(String host, int port, InetAddress clientAddress, int clientPort) throws IOException {
                return this.defaultFactory.createSocket(host, port, clientAddress, clientPort);
            }

            @Override
            public Socket createSocket(InetAddress address, int port, InetAddress clientAddress, int clientPort) throws IOException {
                return this.defaultFactory.createSocket(address, port, clientAddress, clientPort);
            }
        });
        if (!useProxy) {
            builder.proxy(Proxy.NO_PROXY);
        }
        if ((trustManager = this.btnNetwork.getHttpClient().x509TrustManager()) != null) {
            final SSLSocketFactory originalSslFactory = this.btnNetwork.getHttpClient().sslSocketFactory();
            builder.sslSocketFactory(new SSLSocketFactory(this){
                {
                    Objects.requireNonNull(this$0);
                }

                @Override
                public String[] getDefaultCipherSuites() {
                    return originalSslFactory.getDefaultCipherSuites();
                }

                @Override
                public String[] getSupportedCipherSuites() {
                    return originalSslFactory.getSupportedCipherSuites();
                }

                private Socket createAndBindSocket(InetAddress targetAddress) throws IOException {
                    if (localAddress instanceof Inet4Address != targetAddress instanceof Inet4Address) {
                        throw new IOException("SSL: Address family mismatch: cannot bind " + (localAddress instanceof Inet4Address ? "IPv4" : "IPv6") + " local address to " + (targetAddress instanceof Inet4Address ? "IPv4" : "IPv6") + " target");
                    }
                    Socket socket = new Socket();
                    try {
                        socket.bind(new InetSocketAddress(localAddress, 0));
                    }
                    catch (IOException e) {
                        throw new IOException("SSL: Failed to bind to local IP address: " + ifNet, e);
                    }
                    return socket;
                }

                @Override
                public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
                    return originalSslFactory.createSocket(s, host, port, autoClose);
                }

                @Override
                public Socket createSocket(String host, int port) throws IOException {
                    InetAddress address = InetAddress.getByName(host);
                    Socket socket = this.createAndBindSocket(address);
                    socket.connect(new InetSocketAddress(address, port));
                    return originalSslFactory.createSocket(socket, host, port, true);
                }

                @Override
                public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
                    return originalSslFactory.createSocket(host, port, localHost, localPort);
                }

                @Override
                public Socket createSocket(InetAddress address, int port) throws IOException {
                    Socket socket = this.createAndBindSocket(address);
                    socket.connect(new InetSocketAddress(address, port));
                    return originalSslFactory.createSocket(socket, address.getHostAddress(), port, true);
                }

                @Override
                public Socket createSocket(InetAddress address, int port, InetAddress localAddress2, int localPort) throws IOException {
                    return originalSslFactory.createSocket(address, port, localAddress2, localPort);
                }
            }, this.btnNetwork.getHttpClient().x509TrustManager());
        }
        return builder.build();
    }

    @Override
    public void unload() {
    }

    static class ServerResponse {
        @SerializedName(value="external_ip")
        private String externalIp;

        @Generated
        public ServerResponse(String externalIp) {
            this.externalIp = externalIp;
        }

        @Generated
        public String getExternalIp() {
            return this.externalIp;
        }

        @Generated
        public void setExternalIp(String externalIp) {
            this.externalIp = externalIp;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ServerResponse)) {
                return false;
            }
            ServerResponse other = (ServerResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$externalIp = this.getExternalIp();
            String other$externalIp = other.getExternalIp();
            return !(this$externalIp == null ? other$externalIp != null : !this$externalIp.equals(other$externalIp));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ServerResponse;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $externalIp = this.getExternalIp();
            result = result * 59 + ($externalIp == null ? 43 : $externalIp.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BtnAbilityHeartBeat.ServerResponse(externalIp=" + this.getExternalIp() + ")";
        }
    }
}

