/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.btn.ping.legacy;

import com.ghostchu.peerbanhelper.database.table.PeerRecordEntity;
import com.ghostchu.peerbanhelper.util.InfoHashUtil;
import com.google.gson.annotations.SerializedName;
import java.sql.Timestamp;
import lombok.Generated;

public final class LegacyBtnPeerHistory {
    @SerializedName(value="ip_address")
    private String ipAddress;
    @SerializedName(value="port")
    private int port;
    @SerializedName(value="peer_id")
    private String peerId;
    @SerializedName(value="client_name")
    private String clientName;
    @SerializedName(value="torrent_identifier")
    private String torrentIdentifier;
    @SerializedName(value="torrent_is_private")
    private boolean torrentIsPrivate;
    @SerializedName(value="torrent_size")
    private long torrentSize;
    @SerializedName(value="downloaded")
    private long downloaded;
    @SerializedName(value="downloaded_offset")
    private long downloadedOffset;
    @SerializedName(value="uploaded")
    private long uploaded;
    @SerializedName(value="uploaded_offset")
    private long uploadedOffset;
    @SerializedName(value="first_time_seen")
    private Timestamp firstTimeSeen;
    @SerializedName(value="last_time_seen")
    private Timestamp lastTimeSeen;
    @SerializedName(value="peer_flag")
    private String peerFlag;

    public static LegacyBtnPeerHistory from(PeerRecordEntity peer) {
        LegacyBtnPeerHistory btnPeer = new LegacyBtnPeerHistory();
        btnPeer.setIpAddress(peer.getAddress());
        btnPeer.setPeerId(peer.getPeerId());
        btnPeer.setClientName(peer.getClientName());
        String hashedId = InfoHashUtil.getHashedIdentifier(peer.getTorrent().getInfoHash());
        btnPeer.setTorrentIdentifier(hashedId);
        btnPeer.setTorrentSize(peer.getTorrent().getSize());
        btnPeer.setDownloaded(peer.getDownloaded());
        btnPeer.setDownloadedOffset(peer.getDownloadedOffset());
        btnPeer.setUploaded(peer.getUploaded());
        btnPeer.setUploadedOffset(peer.getUploadedOffset());
        btnPeer.setFirstTimeSeen(peer.getFirstTimeSeen());
        btnPeer.setLastTimeSeen(peer.getLastTimeSeen());
        btnPeer.setPeerFlag(peer.getLastFlags() == null ? null : peer.getLastFlags());
        return btnPeer;
    }

    @Generated
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public String getPeerId() {
        return this.peerId;
    }

    @Generated
    public String getClientName() {
        return this.clientName;
    }

    @Generated
    public String getTorrentIdentifier() {
        return this.torrentIdentifier;
    }

    @Generated
    public boolean isTorrentIsPrivate() {
        return this.torrentIsPrivate;
    }

    @Generated
    public long getTorrentSize() {
        return this.torrentSize;
    }

    @Generated
    public long getDownloaded() {
        return this.downloaded;
    }

    @Generated
    public long getDownloadedOffset() {
        return this.downloadedOffset;
    }

    @Generated
    public long getUploaded() {
        return this.uploaded;
    }

    @Generated
    public long getUploadedOffset() {
        return this.uploadedOffset;
    }

    @Generated
    public Timestamp getFirstTimeSeen() {
        return this.firstTimeSeen;
    }

    @Generated
    public Timestamp getLastTimeSeen() {
        return this.lastTimeSeen;
    }

    @Generated
    public String getPeerFlag() {
        return this.peerFlag;
    }

    @Generated
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    @Generated
    public void setPort(int port) {
        this.port = port;
    }

    @Generated
    public void setPeerId(String peerId) {
        this.peerId = peerId;
    }

    @Generated
    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    @Generated
    public void setTorrentIdentifier(String torrentIdentifier) {
        this.torrentIdentifier = torrentIdentifier;
    }

    @Generated
    public void setTorrentIsPrivate(boolean torrentIsPrivate) {
        this.torrentIsPrivate = torrentIsPrivate;
    }

    @Generated
    public void setTorrentSize(long torrentSize) {
        this.torrentSize = torrentSize;
    }

    @Generated
    public void setDownloaded(long downloaded) {
        this.downloaded = downloaded;
    }

    @Generated
    public void setDownloadedOffset(long downloadedOffset) {
        this.downloadedOffset = downloadedOffset;
    }

    @Generated
    public void setUploaded(long uploaded) {
        this.uploaded = uploaded;
    }

    @Generated
    public void setUploadedOffset(long uploadedOffset) {
        this.uploadedOffset = uploadedOffset;
    }

    @Generated
    public void setFirstTimeSeen(Timestamp firstTimeSeen) {
        this.firstTimeSeen = firstTimeSeen;
    }

    @Generated
    public void setLastTimeSeen(Timestamp lastTimeSeen) {
        this.lastTimeSeen = lastTimeSeen;
    }

    @Generated
    public void setPeerFlag(String peerFlag) {
        this.peerFlag = peerFlag;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LegacyBtnPeerHistory)) {
            return false;
        }
        LegacyBtnPeerHistory other = (LegacyBtnPeerHistory)o;
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.isTorrentIsPrivate() != other.isTorrentIsPrivate()) {
            return false;
        }
        if (this.getTorrentSize() != other.getTorrentSize()) {
            return false;
        }
        if (this.getDownloaded() != other.getDownloaded()) {
            return false;
        }
        if (this.getDownloadedOffset() != other.getDownloadedOffset()) {
            return false;
        }
        if (this.getUploaded() != other.getUploaded()) {
            return false;
        }
        if (this.getUploadedOffset() != other.getUploadedOffset()) {
            return false;
        }
        String this$ipAddress = this.getIpAddress();
        String other$ipAddress = other.getIpAddress();
        if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
            return false;
        }
        String this$peerId = this.getPeerId();
        String other$peerId = other.getPeerId();
        if (this$peerId == null ? other$peerId != null : !this$peerId.equals(other$peerId)) {
            return false;
        }
        String this$clientName = this.getClientName();
        String other$clientName = other.getClientName();
        if (this$clientName == null ? other$clientName != null : !this$clientName.equals(other$clientName)) {
            return false;
        }
        String this$torrentIdentifier = this.getTorrentIdentifier();
        String other$torrentIdentifier = other.getTorrentIdentifier();
        if (this$torrentIdentifier == null ? other$torrentIdentifier != null : !this$torrentIdentifier.equals(other$torrentIdentifier)) {
            return false;
        }
        Timestamp this$firstTimeSeen = this.getFirstTimeSeen();
        Timestamp other$firstTimeSeen = other.getFirstTimeSeen();
        if (this$firstTimeSeen == null ? other$firstTimeSeen != null : !((Object)this$firstTimeSeen).equals(other$firstTimeSeen)) {
            return false;
        }
        Timestamp this$lastTimeSeen = this.getLastTimeSeen();
        Timestamp other$lastTimeSeen = other.getLastTimeSeen();
        if (this$lastTimeSeen == null ? other$lastTimeSeen != null : !((Object)this$lastTimeSeen).equals(other$lastTimeSeen)) {
            return false;
        }
        String this$peerFlag = this.getPeerFlag();
        String other$peerFlag = other.getPeerFlag();
        return !(this$peerFlag == null ? other$peerFlag != null : !this$peerFlag.equals(other$peerFlag));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        result = result * 59 + (this.isTorrentIsPrivate() ? 79 : 97);
        long $torrentSize = this.getTorrentSize();
        result = result * 59 + (int)($torrentSize >>> 32 ^ $torrentSize);
        long $downloaded = this.getDownloaded();
        result = result * 59 + (int)($downloaded >>> 32 ^ $downloaded);
        long $downloadedOffset = this.getDownloadedOffset();
        result = result * 59 + (int)($downloadedOffset >>> 32 ^ $downloadedOffset);
        long $uploaded = this.getUploaded();
        result = result * 59 + (int)($uploaded >>> 32 ^ $uploaded);
        long $uploadedOffset = this.getUploadedOffset();
        result = result * 59 + (int)($uploadedOffset >>> 32 ^ $uploadedOffset);
        String $ipAddress = this.getIpAddress();
        result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
        String $peerId = this.getPeerId();
        result = result * 59 + ($peerId == null ? 43 : $peerId.hashCode());
        String $clientName = this.getClientName();
        result = result * 59 + ($clientName == null ? 43 : $clientName.hashCode());
        String $torrentIdentifier = this.getTorrentIdentifier();
        result = result * 59 + ($torrentIdentifier == null ? 43 : $torrentIdentifier.hashCode());
        Timestamp $firstTimeSeen = this.getFirstTimeSeen();
        result = result * 59 + ($firstTimeSeen == null ? 43 : ((Object)$firstTimeSeen).hashCode());
        Timestamp $lastTimeSeen = this.getLastTimeSeen();
        result = result * 59 + ($lastTimeSeen == null ? 43 : ((Object)$lastTimeSeen).hashCode());
        String $peerFlag = this.getPeerFlag();
        result = result * 59 + ($peerFlag == null ? 43 : $peerFlag.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LegacyBtnPeerHistory(ipAddress=" + this.getIpAddress() + ", port=" + this.getPort() + ", peerId=" + this.getPeerId() + ", clientName=" + this.getClientName() + ", torrentIdentifier=" + this.getTorrentIdentifier() + ", torrentIsPrivate=" + this.isTorrentIsPrivate() + ", torrentSize=" + this.getTorrentSize() + ", downloaded=" + this.getDownloaded() + ", downloadedOffset=" + this.getDownloadedOffset() + ", uploaded=" + this.getUploaded() + ", uploadedOffset=" + this.getUploadedOffset() + ", firstTimeSeen=" + String.valueOf(this.getFirstTimeSeen()) + ", lastTimeSeen=" + String.valueOf(this.getLastTimeSeen()) + ", peerFlag=" + this.getPeerFlag() + ")";
    }

    @Generated
    public LegacyBtnPeerHistory(String ipAddress, int port, String peerId, String clientName, String torrentIdentifier, boolean torrentIsPrivate, long torrentSize, long downloaded, long downloadedOffset, long uploaded, long uploadedOffset, Timestamp firstTimeSeen, Timestamp lastTimeSeen, String peerFlag) {
        this.ipAddress = ipAddress;
        this.port = port;
        this.peerId = peerId;
        this.clientName = clientName;
        this.torrentIdentifier = torrentIdentifier;
        this.torrentIsPrivate = torrentIsPrivate;
        this.torrentSize = torrentSize;
        this.downloaded = downloaded;
        this.downloadedOffset = downloadedOffset;
        this.uploaded = uploaded;
        this.uploadedOffset = uploadedOffset;
        this.firstTimeSeen = firstTimeSeen;
        this.lastTimeSeen = lastTimeSeen;
        this.peerFlag = peerFlag;
    }

    @Generated
    public LegacyBtnPeerHistory() {
    }
}

