/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.platform.impl.win32.workingset;

import com.ghostchu.peerbanhelper.platform.impl.win32.workingset.jna.WorkingSetManagerFactory;
import com.ghostchu.peerbanhelper.util.lab.Experiments;
import com.ghostchu.peerbanhelper.util.lab.Laboratory;
import com.sun.management.GarbageCollectionNotificationInfo;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.management.NotificationEmitter;
import javax.management.openmbean.CompositeData;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PBHWin32MemoryManagement {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PBHWin32MemoryManagement.class);
    private final ScheduledExecutorService service = Executors.newScheduledThreadPool(1);
    private final Pattern gcKeyword = Pattern.compile(".*(Full|Old|MarkSweep|Tenured|CMS|G1|ZGC|Shenandoah).*");
    private long lastRun = 0L;

    public PBHWin32MemoryManagement(Laboratory laboratory) {
        try {
            if (!WorkingSetManagerFactory.isSupported() || !laboratory.isExperimentActivated(Experiments.WIN32_EMPTY_WORKING_SET.getExperiment())) {
                return;
            }
            log.debug("PBHWin32MemoryManagement initialized, hooking memory management.");
            this.hookMemoryManagement();
            this.service.scheduleWithFixedDelay(this::runJob, 1L, 10L, TimeUnit.MINUTES);
            log.debug("PBHWin32MemoryManagement scheduled to run every 10 minutes.");
        }
        catch (Throwable e) {
            log.warn("Failed to initialize PBHWin32MemoryManagement, memory management may not work properly.", e);
        }
    }

    private void hookMemoryManagement() {
        List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gcBean : gcBeans) {
            if (!(gcBean instanceof NotificationEmitter)) continue;
            NotificationEmitter emitter = (NotificationEmitter)((Object)gcBean);
            emitter.addNotificationListener((notification, handback) -> {
                if (notification.getType().equals("com.sun.management.gc.notification")) {
                    boolean isFullGc;
                    GarbageCollectionNotificationInfo info = GarbageCollectionNotificationInfo.from((CompositeData)notification.getUserData());
                    boolean bl = isFullGc = "end of major GC".equals(info.getGcAction()) || this.gcKeyword.matcher(info.getGcName()).matches() || "end of cycle".equals(info.getGcAction());
                    if (isFullGc) {
                        this.releaseMemory();
                    }
                }
            }, null, null);
        }
    }

    private void runJob() {
        System.gc();
        this.service.schedule(this::releaseMemory, 10L, TimeUnit.SECONDS);
    }

    private void releaseMemory() {
        if (System.currentTimeMillis() - this.lastRun > 60000L) {
            return;
        }
        log.debug("Releasing memory by emptying working set.");
        WorkingSetManagerFactory.trimMemory();
        this.lastRun = System.currentTimeMillis();
    }
}

