/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.logger;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import com.ghostchu.peerbanhelper.ExternalSwitch;
import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.event.program.logger.NewLogEntryCreatedEvent;
import com.ghostchu.peerbanhelper.util.logger.LogEntry;
import com.google.common.collect.EvictingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public final class JListAppender
extends AppenderBase<ILoggingEvent> {
    public static final EvictingQueue<LogEntry> logEntryDeque = EvictingQueue.create((int)ExternalSwitch.parseInt("pbh.logger.logEntryDeque.size", 200));
    public static final AtomicBoolean allowWriteLogEntryDeque = new AtomicBoolean(true);
    public static final EvictingQueue<LogEntry> ringDeque = EvictingQueue.create((int)ExternalSwitch.parseInt("pbh.logger.ringDeque.size", 100));
    private static final AtomicLong seq = new AtomicLong(0L);
    private PatternLayout layout;
    private static final ThrowableProxyConverter converter = new ThrowableProxyConverter();

    public JListAppender() {
        converter.start();
    }

    protected void append(ILoggingEvent eventObject) {
        if (this.layout == null) {
            PatternLayout layout = new PatternLayout();
            layout.setPattern("[%d{HH:mm:ss}] [%t/%level]: %msg%n");
            layout.setContext(this.getContext());
            layout.start();
            this.layout = layout;
        }
        String formattedMessage = this.layout.doLayout(eventObject);
        org.slf4j.event.Level slf4jLevel = org.slf4j.event.Level.INFO;
        if (eventObject.getLevel() == Level.WARN) {
            slf4jLevel = org.slf4j.event.Level.WARN;
        } else if (eventObject.getLevel() == Level.ERROR) {
            slf4jLevel = org.slf4j.event.Level.ERROR;
        } else if (eventObject.getLevel() == Level.DEBUG) {
            slf4jLevel = org.slf4j.event.Level.DEBUG;
        } else if (eventObject.getLevel() == Level.TRACE) {
            slf4jLevel = org.slf4j.event.Level.TRACE;
        } else if (eventObject.getLevel() == Level.OFF) {
            return;
        }
        long seqNumber = seq.incrementAndGet();
        if (allowWriteLogEntryDeque.get()) {
            LogEntry postAccessLog = new LogEntry(eventObject.getTimeStamp(), eventObject.getThreadName(), slf4jLevel, formattedMessage.trim(), seqNumber);
            logEntryDeque.add((Object)postAccessLog);
        }
        LogEntry rawLog = new LogEntry(eventObject.getTimeStamp(), eventObject.getThreadName(), slf4jLevel, formattedMessage.startsWith("[") ? StringUtils.substringAfter((String)formattedMessage.trim(), (String)": ") : formattedMessage.trim(), seqNumber);
        ringDeque.add((Object)rawLog);
        Main.getEventBus().post((Object)new NewLogEntryCreatedEvent(rawLog));
    }

    @Generated
    public static AtomicLong getSeq() {
        return seq;
    }
}

