/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.rule.matcher;

import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.rule.AbstractJsonMatcher;
import com.ghostchu.peerbanhelper.util.rule.MatchResult;
import com.ghostchu.peerbanhelper.util.rule.MatchResultEnum;
import com.google.gson.JsonObject;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public final class StringLengthMatcher
extends AbstractJsonMatcher {
    private final int min;
    private final int max;
    private MatchResult hit;
    private MatchResult miss;

    public StringLengthMatcher(JsonObject syntax) {
        super(syntax);
        this.min = syntax.get("min").getAsInt();
        this.max = syntax.get("max").getAsInt();
        this.hit = new MatchResult(MatchResultEnum.TRUE, new TranslationComponent(Lang.MATCH_STRING_LENGTH, "Hit-Min-" + this.min + ", Max-" + this.max));
        this.miss = new MatchResult(MatchResultEnum.DEFAULT, new TranslationComponent(Lang.MATCH_STRING_LENGTH, "Hit-Min-" + this.min + ", Max-" + this.max));
        if (syntax.has("hit")) {
            this.hit = new MatchResult(MatchResultEnum.valueOf(syntax.get("hit").getAsString()), new TranslationComponent(Lang.MATCH_STRING_LENGTH, "Hit-Min-" + this.min + ", Max-" + this.max));
        }
        if (syntax.has("miss")) {
            this.miss = new MatchResult(MatchResultEnum.valueOf(syntax.get("miss").getAsString()), new TranslationComponent(Lang.MATCH_STRING_LENGTH, "Miss-Min-" + this.min + ", Max-" + this.max));
        }
    }

    @Override
    @NotNull
    public MatchResult match0(@NotNull String content) {
        int length = content.length();
        return length >= this.min && length <= this.max ? this.hit : this.miss;
    }

    @Override
    public TranslationComponent matcherName() {
        return new TranslationComponent(Lang.MATCH_STRING_LENGTH, "Min-" + this.min + ", Max-" + this.max);
    }

    @Override
    public String matcherIdentifier() {
        return "peerbanhelper:stringlengthmatcher";
    }

    @Override
    public String metadata() {
        return String.format("min: %d, max: %d", this.min, this.max);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringLengthMatcher)) {
            return false;
        }
        StringLengthMatcher other = (StringLengthMatcher)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.min != other.min) {
            return false;
        }
        if (this.max != other.max) {
            return false;
        }
        MatchResult this$hit = this.hit;
        MatchResult other$hit = other.hit;
        if (this$hit == null ? other$hit != null : !((Object)this$hit).equals(other$hit)) {
            return false;
        }
        MatchResult this$miss = this.miss;
        MatchResult other$miss = other.miss;
        return !(this$miss == null ? other$miss != null : !((Object)this$miss).equals(other$miss));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StringLengthMatcher;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.min;
        result = result * 59 + this.max;
        MatchResult $hit = this.hit;
        result = result * 59 + ($hit == null ? 43 : ((Object)$hit).hashCode());
        MatchResult $miss = this.miss;
        result = result * 59 + ($miss == null ? 43 : ((Object)$miss).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "StringLengthMatcher(super=" + super.toString() + ", min=" + this.min + ", max=" + this.max + ", hit=" + String.valueOf(this.hit) + ", miss=" + String.valueOf(this.miss) + ")";
    }
}

