/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.table;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;
import com.j256.ormlite.misc.IOUtils;
import com.j256.ormlite.stmt.StatementBuilder;
import com.j256.ormlite.support.CompiledStatement;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.support.DatabaseResults;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SchemaUtils {
    private static Logger logger = LoggerFactory.getLogger(SchemaUtils.class);
    private static final FieldType[] noFieldTypes = new FieldType[0];

    private SchemaUtils() {
    }

    public static <T> int createSchema(ConnectionSource connectionSource, Class<T> dataClass) throws SQLException {
        Object dao = DaoManager.createDao(connectionSource, dataClass);
        return SchemaUtils.doCreateSchema(connectionSource, dao.getTableInfo().getSchemaName(), false);
    }

    public static int createSchema(Dao<?, ?> dao) throws SQLException {
        return SchemaUtils.doCreateSchema(dao.getConnectionSource(), dao.getTableInfo().getSchemaName(), false);
    }

    public static <T> int createSchemaIfNotExists(ConnectionSource connectionSource, Class<T> dataClass) throws SQLException {
        Object dao = DaoManager.createDao(connectionSource, dataClass);
        return SchemaUtils.doCreateSchema(dao.getConnectionSource(), dao.getTableInfo().getSchemaName(), true);
    }

    public static <T> int createSchema(ConnectionSource connectionSource, String schemaName) throws SQLException {
        return SchemaUtils.doCreateSchema(connectionSource, schemaName, false);
    }

    public static <T> int createSchemaIfNotExists(ConnectionSource connectionSource, String schemaName) throws SQLException {
        return SchemaUtils.doCreateSchema(connectionSource, schemaName, true);
    }

    public static <T> List<String> getCreateSchemaStatements(DatabaseType databaseType, String schemaName) {
        ArrayList<String> statementList = new ArrayList<String>();
        SchemaUtils.addCreateSchemaStatements(databaseType, schemaName, statementList, statementList, false, false);
        return statementList;
    }

    public static <T, ID> int dropSchema(ConnectionSource connectionSource, Class<T> dataClass, boolean ignoreErrors) throws SQLException {
        Object dao = DaoManager.createDao(connectionSource, dataClass);
        return SchemaUtils.dropSchema(dao.getConnectionSource(), dao.getTableInfo().getSchemaName(), ignoreErrors);
    }

    public static <T, ID> int dropSchema(ConnectionSource connectionSource, String schemaName, boolean ignoreErrors) throws SQLException {
        DatabaseType databaseType = connectionSource.getDatabaseType();
        return SchemaUtils.doDropSchema(databaseType, connectionSource, schemaName, ignoreErrors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T, ID> int doDropSchema(DatabaseType databaseType, ConnectionSource connectionSource, String schemaName, boolean ignoreErrors) throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        SchemaUtils.addDropSchemaStatements(databaseType, schemaName, statements, true);
        DatabaseConnection connection = connectionSource.getReadWriteConnection(schemaName);
        try {
            int n = SchemaUtils.doStatements(connection, "drop", statements, ignoreErrors, databaseType.isCreateSchemaReturnsNegative(), false);
            return n;
        }
        finally {
            connectionSource.releaseConnection(connection);
        }
    }

    private static <T, ID> void addDropSchemaStatements(DatabaseType databaseType, String schemaName, List<String> statements, boolean logDetails) {
        StringBuilder sb = new StringBuilder(64);
        if (logDetails) {
            logger.info("dropping schema '{}'", (Object)schemaName);
        }
        sb.append("DROP SCHEMA ");
        databaseType.appendEscapedEntityName(sb, schemaName);
        sb.append(' ');
        statements.add(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T, ID> int doCreateSchema(ConnectionSource connectionSource, String schemaName, boolean ifNotExists) throws SQLException {
        DatabaseType databaseType = connectionSource.getDatabaseType();
        ArrayList<String> statements = new ArrayList<String>();
        ArrayList<String> queriesAfter = new ArrayList<String>();
        SchemaUtils.addCreateSchemaStatements(databaseType, schemaName, statements, queriesAfter, ifNotExists, true);
        DatabaseConnection connection = connectionSource.getReadWriteConnection(schemaName);
        try {
            int stmtC = SchemaUtils.doStatements(connection, "create", statements, false, databaseType.isCreateSchemaReturnsNegative(), databaseType.isCreateSchemaReturnsZero());
            int n = stmtC += SchemaUtils.doCreateTestQueries(connection, databaseType, queriesAfter);
            return n;
        }
        finally {
            connectionSource.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int doStatements(DatabaseConnection connection, String label, Collection<String> statements, boolean ignoreErrors, boolean returnsNegative, boolean expectingZero) throws SQLException {
        int stmtC = 0;
        for (String statement : statements) {
            int rowC = 0;
            CompiledStatement compiledStmt = null;
            try {
                compiledStmt = connection.compileStatement(statement, StatementBuilder.StatementType.EXECUTE, noFieldTypes, -1, false);
                rowC = compiledStmt.runExecute();
                logger.info("executed {} schema statement changed {} rows: {}", (Object)label, (Object)rowC, (Object)statement);
            }
            catch (SQLException e) {
                try {
                    if (!ignoreErrors) {
                        throw new SQLException("SQL statement failed: " + statement, e);
                    }
                    logger.info("ignoring {} error '{}' for statement: {}", (Object)label, (Object)e, (Object)statement);
                }
                catch (Throwable throwable) {
                    IOUtils.closeThrowSqlException(compiledStmt, "compiled statement");
                    throw throwable;
                }
                IOUtils.closeThrowSqlException(compiledStmt, "compiled statement");
            }
            IOUtils.closeThrowSqlException(compiledStmt, "compiled statement");
            if (rowC < 0) {
                if (!returnsNegative) {
                    throw new SQLException("SQL statement " + statement + " updated " + rowC + " rows, we were expecting >= 0");
                }
            } else if (rowC > 0 && expectingZero) {
                throw new SQLException("SQL statement updated " + rowC + " rows, we were expecting == 0: " + statement);
            }
            ++stmtC;
        }
        return stmtC;
    }

    private static int doCreateTestQueries(DatabaseConnection connection, DatabaseType databaseType, List<String> queriesAfter) throws SQLException {
        int stmtC = 0;
        for (String query : queriesAfter) {
            CompiledStatement compiledStmt = null;
            try {
                compiledStmt = connection.compileStatement(query, StatementBuilder.StatementType.SELECT, noFieldTypes, -1, false);
                DatabaseResults results = compiledStmt.runQuery(null);
                int rowC = 0;
                boolean isThereMore = results.first();
                while (isThereMore) {
                    ++rowC;
                    isThereMore = results.next();
                }
                logger.info("executing create schema after-query got {} results: {}", rowC, (Object)query);
            }
            catch (SQLException e) {
                try {
                    throw new SQLException("executing create schema after-query failed: " + query, e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeThrowSqlException(compiledStmt, "compiled statement");
                    throw throwable;
                }
            }
            IOUtils.closeThrowSqlException(compiledStmt, "compiled statement");
            ++stmtC;
        }
        return stmtC;
    }

    private static <T, ID> void addCreateSchemaStatements(DatabaseType databaseType, String schemaName, List<String> statements, List<String> queriesAfter, boolean ifNotExists, boolean logDetails) {
        StringBuilder sb = new StringBuilder(256);
        if (logDetails) {
            logger.info("creating schema '{}'", (Object)schemaName);
        }
        sb.append("CREATE SCHEMA ");
        if (ifNotExists && databaseType.isCreateIfNotExistsSupported()) {
            sb.append("IF NOT EXISTS ");
        }
        databaseType.appendEscapedEntityName(sb, schemaName);
        databaseType.appendCreateSchemaSuffix(sb);
        statements.add(sb.toString());
    }
}

