/*
 * Decompiled with CFR 0.152.
 */
package com.maxmind.db;

import com.maxmind.db.Buffer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;

final class SingleBuffer
implements Buffer {
    private final ByteBuffer buffer;

    SingleBuffer(ByteBuffer buffer) {
        this.buffer = buffer.asReadOnlyBuffer();
    }

    @Override
    public long capacity() {
        return this.buffer.capacity();
    }

    @Override
    public long position() {
        return this.buffer.position();
    }

    @Override
    public SingleBuffer position(long newPosition) {
        this.buffer.position((int)newPosition);
        return this;
    }

    @Override
    public long limit() {
        return this.buffer.limit();
    }

    @Override
    public SingleBuffer limit(long newLimit) {
        this.buffer.limit((int)newLimit);
        return this;
    }

    @Override
    public byte get() {
        return this.buffer.get();
    }

    @Override
    public SingleBuffer get(byte[] dst) {
        this.buffer.get(dst);
        return this;
    }

    @Override
    public byte get(long index) {
        return this.buffer.get((int)index);
    }

    @Override
    public double getDouble() {
        return this.buffer.getDouble();
    }

    @Override
    public float getFloat() {
        return this.buffer.getFloat();
    }

    @Override
    public SingleBuffer duplicate() {
        return new SingleBuffer(this.buffer.duplicate());
    }

    @Override
    public String decode(CharsetDecoder decoder) throws CharacterCodingException {
        return decoder.decode(this.buffer).toString();
    }

    public static SingleBuffer wrap(byte[] array) {
        return new SingleBuffer(ByteBuffer.wrap(array));
    }

    public static SingleBuffer mapFromChannel(FileChannel channel) throws IOException {
        MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
        return new SingleBuffer(buffer);
    }
}

