/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.btn;

import com.ghostchu.peerbanhelper.btn.BtnRuleset;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.IPAddressUtil;
import com.ghostchu.peerbanhelper.util.rule.AbstractMatcher;
import com.ghostchu.peerbanhelper.util.rule.MatchResult;
import com.ghostchu.peerbanhelper.util.rule.MatchResultEnum;
import com.ghostchu.peerbanhelper.util.rule.Rule;
import com.ghostchu.peerbanhelper.util.rule.RuleParser;
import com.ghostchu.peerbanhelper.util.rule.matcher.IPMatcher;
import com.ghostchu.peerbanhelper.util.scriptengine.CompiledScript;
import com.ghostchu.peerbanhelper.util.scriptengine.ScriptEngine;
import inet.ipaddr.format.util.DualIPv4v6AssociativeTries;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BtnRulesetParsed {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BtnRulesetParsed.class);
    private final ScriptEngine scriptEngine;
    private String version;
    private Map<String, List<Rule>> peerIdRules;
    private Map<String, List<Rule>> clientNameRules;
    private Map<String, IPMatcher> ipRules;
    private Map<String, List<Rule>> portRules;
    private Map<String, CompiledScript> scriptRules;

    public BtnRulesetParsed(ScriptEngine scriptEngine, BtnRuleset btnRuleset, boolean scriptExecute) {
        this.scriptEngine = scriptEngine;
        this.version = btnRuleset.getVersion();
        this.ipRules = this.parseIPRule(btnRuleset.getIpRules());
        this.portRules = this.parsePortRule(btnRuleset.getPortRules());
        this.peerIdRules = this.parseRule(btnRuleset.getPeerIdRules());
        this.clientNameRules = this.parseRule(btnRuleset.getClientNameRules());
        this.scriptRules = scriptExecute ? this.compileScripts(btnRuleset.getScriptRules()) : new HashMap();
    }

    private Map<String, CompiledScript> compileScripts(Map<String, String> scriptRules) {
        HashMap<String, CompiledScript> scripts = new HashMap<String, CompiledScript>();
        log.info(TextManager.tlUI(Lang.BTN_RULES_SCRIPT_COMPILING, scriptRules.size()));
        long startAt = System.currentTimeMillis();
        scriptRules.forEach((name, content) -> {
            try {
                CompiledScript script = this.scriptEngine.compileScript(null, (String)name, (String)content);
                if (script != null) {
                    scripts.put((String)name, script);
                }
            }
            catch (Exception e) {
                log.error("Unable to load BTN script {}", name, (Object)e);
            }
        });
        log.info(TextManager.tlUI(Lang.BTN_RULES_SCRIPT_COMPILED, scripts.size(), System.currentTimeMillis() - startAt));
        return scripts;
    }

    private Map<String, List<Rule>> parsePortRule(Map<String, List<Integer>> portRules) {
        HashMap<String, List<Rule>> rules = new HashMap<String, List<Rule>>();
        portRules.forEach((k, v) -> {
            ArrayList<1> addresses = new ArrayList<1>();
            Iterator i$ = v.iterator();
            while (i$.hasNext()) {
                final int s = (Integer)i$.next();
                addresses.add(new AbstractMatcher(this){
                    final /* synthetic */ BtnRulesetParsed this$0;
                    {
                        BtnRulesetParsed btnRulesetParsed = this$0;
                        Objects.requireNonNull(btnRulesetParsed);
                        this.this$0 = btnRulesetParsed;
                    }

                    @Override
                    @NotNull
                    public MatchResult match0(@NotNull String content) {
                        boolean hit = Integer.parseInt(content) == s;
                        return hit ? new MatchResult(MatchResultEnum.TRUE, new TranslationComponent(Lang.MATCH_CONDITION_PORT_MATCH)) : new MatchResult(MatchResultEnum.DEFAULT, new TranslationComponent("Port seems OK"));
                    }

                    @Override
                    public String metadata() {
                        return String.valueOf(s);
                    }

                    @Override
                    public TranslationComponent matcherName() {
                        return new TranslationComponent(Lang.BTN_PORT_RULE, this.this$0.version);
                    }

                    @Override
                    public String matcherIdentifier() {
                        return "btn-exception:port";
                    }
                });
            }
            rules.put((String)k, (List<Rule>)addresses);
        });
        return rules;
    }

    public Map<String, IPMatcher> parseIPRule(Map<String, List<String>> raw) {
        HashMap<String, IPMatcher> rules = new HashMap<String, IPMatcher>();
        raw.forEach((k, v) -> {
            DualIPv4v6AssociativeTries tries = new DualIPv4v6AssociativeTries();
            v.stream().map(IPAddressUtil::getIPAddress).forEach(arg_0 -> ((DualIPv4v6AssociativeTries)tries).add(arg_0));
            rules.put((String)k, new IPMatcher(this.version, (String)k, List.of(tries)));
        });
        return rules;
    }

    public Map<String, List<Rule>> parseRule(Map<String, List<String>> raw) {
        HashMap<String, List<Rule>> rules = new HashMap<String, List<Rule>>();
        raw.forEach((k, v) -> rules.put((String)k, RuleParser.parse(v)));
        return rules;
    }

    public long size() {
        return this.peerIdRules.values().stream().mapToLong(List::size).sum() + this.clientNameRules.values().stream().mapToLong(List::size).sum() + this.ipRules.values().stream().mapToLong(IPMatcher::size).sum() + this.portRules.values().stream().mapToLong(List::size).sum() + (long)this.scriptRules.size();
    }

    @Generated
    public ScriptEngine getScriptEngine() {
        return this.scriptEngine;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public Map<String, List<Rule>> getPeerIdRules() {
        return this.peerIdRules;
    }

    @Generated
    public Map<String, List<Rule>> getClientNameRules() {
        return this.clientNameRules;
    }

    @Generated
    public Map<String, IPMatcher> getIpRules() {
        return this.ipRules;
    }

    @Generated
    public Map<String, List<Rule>> getPortRules() {
        return this.portRules;
    }

    @Generated
    public Map<String, CompiledScript> getScriptRules() {
        return this.scriptRules;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setPeerIdRules(Map<String, List<Rule>> peerIdRules) {
        this.peerIdRules = peerIdRules;
    }

    @Generated
    public void setClientNameRules(Map<String, List<Rule>> clientNameRules) {
        this.clientNameRules = clientNameRules;
    }

    @Generated
    public void setIpRules(Map<String, IPMatcher> ipRules) {
        this.ipRules = ipRules;
    }

    @Generated
    public void setPortRules(Map<String, List<Rule>> portRules) {
        this.portRules = portRules;
    }

    @Generated
    public void setScriptRules(Map<String, CompiledScript> scriptRules) {
        this.scriptRules = scriptRules;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BtnRulesetParsed)) {
            return false;
        }
        BtnRulesetParsed other = (BtnRulesetParsed)o;
        ScriptEngine this$scriptEngine = this.getScriptEngine();
        ScriptEngine other$scriptEngine = other.getScriptEngine();
        if (this$scriptEngine == null ? other$scriptEngine != null : !this$scriptEngine.equals(other$scriptEngine)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        Map<String, List<Rule>> this$peerIdRules = this.getPeerIdRules();
        Map<String, List<Rule>> other$peerIdRules = other.getPeerIdRules();
        if (this$peerIdRules == null ? other$peerIdRules != null : !((Object)this$peerIdRules).equals(other$peerIdRules)) {
            return false;
        }
        Map<String, List<Rule>> this$clientNameRules = this.getClientNameRules();
        Map<String, List<Rule>> other$clientNameRules = other.getClientNameRules();
        if (this$clientNameRules == null ? other$clientNameRules != null : !((Object)this$clientNameRules).equals(other$clientNameRules)) {
            return false;
        }
        Map<String, IPMatcher> this$ipRules = this.getIpRules();
        Map<String, IPMatcher> other$ipRules = other.getIpRules();
        if (this$ipRules == null ? other$ipRules != null : !((Object)this$ipRules).equals(other$ipRules)) {
            return false;
        }
        Map<String, List<Rule>> this$portRules = this.getPortRules();
        Map<String, List<Rule>> other$portRules = other.getPortRules();
        if (this$portRules == null ? other$portRules != null : !((Object)this$portRules).equals(other$portRules)) {
            return false;
        }
        Map<String, CompiledScript> this$scriptRules = this.getScriptRules();
        Map<String, CompiledScript> other$scriptRules = other.getScriptRules();
        return !(this$scriptRules == null ? other$scriptRules != null : !((Object)this$scriptRules).equals(other$scriptRules));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ScriptEngine $scriptEngine = this.getScriptEngine();
        result = result * 59 + ($scriptEngine == null ? 43 : $scriptEngine.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        Map<String, List<Rule>> $peerIdRules = this.getPeerIdRules();
        result = result * 59 + ($peerIdRules == null ? 43 : ((Object)$peerIdRules).hashCode());
        Map<String, List<Rule>> $clientNameRules = this.getClientNameRules();
        result = result * 59 + ($clientNameRules == null ? 43 : ((Object)$clientNameRules).hashCode());
        Map<String, IPMatcher> $ipRules = this.getIpRules();
        result = result * 59 + ($ipRules == null ? 43 : ((Object)$ipRules).hashCode());
        Map<String, List<Rule>> $portRules = this.getPortRules();
        result = result * 59 + ($portRules == null ? 43 : ((Object)$portRules).hashCode());
        Map<String, CompiledScript> $scriptRules = this.getScriptRules();
        result = result * 59 + ($scriptRules == null ? 43 : ((Object)$scriptRules).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BtnRulesetParsed(scriptEngine=" + String.valueOf(this.getScriptEngine()) + ", version=" + this.getVersion() + ", peerIdRules=" + String.valueOf(this.getPeerIdRules()) + ", clientNameRules=" + String.valueOf(this.getClientNameRules()) + ", ipRules=" + String.valueOf(this.getIpRules()) + ", portRules=" + String.valueOf(this.getPortRules()) + ", scriptRules=" + String.valueOf(this.getScriptRules()) + ")";
    }
}

