/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.btn.ping;

import com.ghostchu.peerbanhelper.database.table.HistoryEntity;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.util.InfoHashUtil;
import com.google.gson.annotations.SerializedName;
import java.sql.Timestamp;
import lombok.Generated;

public final class BtnBan {
    @SerializedName(value="ban_at")
    private Timestamp banAt;
    @SerializedName(value="peer_ip")
    private String peerIp;
    @SerializedName(value="peer_port")
    private int peerPort;
    @SerializedName(value="peer_id")
    private String peerId;
    @SerializedName(value="peer_client_name")
    private String peerClientName;
    @SerializedName(value="peer_progress")
    private double peerProgress;
    @SerializedName(value="peer_flag")
    private String peerFlag;
    @SerializedName(value="torrent_identifier")
    private String torrentIdentifier;
    @SerializedName(value="torrent_is_private")
    private boolean torrentIsPrivate;
    @SerializedName(value="torrent_size")
    private long torrentSize;
    @SerializedName(value="from_peer_traffic")
    private long fromPeerTraffic;
    @SerializedName(value="to_peer_traffic")
    private long toPeerTraffic;
    @SerializedName(value="downloader_progress")
    private double downloaderProgress;
    @SerializedName(value="module")
    private String module;
    @SerializedName(value="rule")
    private String rule;
    @SerializedName(value="description")
    private String description;
    @SerializedName(value="structured_data")
    private String structuredData;

    public static BtnBan from(HistoryEntity historyEntity) {
        BtnBan btnBan = new BtnBan();
        btnBan.setModule(historyEntity.getRule().getModule().getName());
        btnBan.setRule(TextManager.tlUI(historyEntity.getRule().getRule()));
        btnBan.setDescription(TextManager.tlUI(historyEntity.getDescription()));
        btnBan.setPeerIp(historyEntity.getIp());
        btnBan.setPeerPort(historyEntity.getPort());
        btnBan.setPeerId(historyEntity.getPeerId());
        btnBan.setPeerClientName(historyEntity.getPeerClientName());
        btnBan.setTorrentIdentifier(InfoHashUtil.getHashedIdentifier(historyEntity.getTorrent().getInfoHash()));
        btnBan.setTorrentIsPrivate(Boolean.TRUE.equals(historyEntity.getTorrent().getPrivateTorrent()));
        btnBan.setTorrentSize(historyEntity.getTorrent().getSize());
        btnBan.setFromPeerTraffic(historyEntity.getPeerDownloaded());
        btnBan.setToPeerTraffic(historyEntity.getPeerUploaded());
        btnBan.setPeerProgress(historyEntity.getPeerProgress());
        btnBan.setDownloaderProgress(historyEntity.getDownloaderProgress());
        btnBan.setPeerFlag(historyEntity.getFlags() == null ? null : historyEntity.getFlags());
        btnBan.setBanAt(historyEntity.getBanAt());
        btnBan.setStructuredData(historyEntity.getStructuredData());
        return btnBan;
    }

    @Generated
    public Timestamp getBanAt() {
        return this.banAt;
    }

    @Generated
    public String getPeerIp() {
        return this.peerIp;
    }

    @Generated
    public int getPeerPort() {
        return this.peerPort;
    }

    @Generated
    public String getPeerId() {
        return this.peerId;
    }

    @Generated
    public String getPeerClientName() {
        return this.peerClientName;
    }

    @Generated
    public double getPeerProgress() {
        return this.peerProgress;
    }

    @Generated
    public String getPeerFlag() {
        return this.peerFlag;
    }

    @Generated
    public String getTorrentIdentifier() {
        return this.torrentIdentifier;
    }

    @Generated
    public boolean isTorrentIsPrivate() {
        return this.torrentIsPrivate;
    }

    @Generated
    public long getTorrentSize() {
        return this.torrentSize;
    }

    @Generated
    public long getFromPeerTraffic() {
        return this.fromPeerTraffic;
    }

    @Generated
    public long getToPeerTraffic() {
        return this.toPeerTraffic;
    }

    @Generated
    public double getDownloaderProgress() {
        return this.downloaderProgress;
    }

    @Generated
    public String getModule() {
        return this.module;
    }

    @Generated
    public String getRule() {
        return this.rule;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getStructuredData() {
        return this.structuredData;
    }

    @Generated
    public void setBanAt(Timestamp banAt) {
        this.banAt = banAt;
    }

    @Generated
    public void setPeerIp(String peerIp) {
        this.peerIp = peerIp;
    }

    @Generated
    public void setPeerPort(int peerPort) {
        this.peerPort = peerPort;
    }

    @Generated
    public void setPeerId(String peerId) {
        this.peerId = peerId;
    }

    @Generated
    public void setPeerClientName(String peerClientName) {
        this.peerClientName = peerClientName;
    }

    @Generated
    public void setPeerProgress(double peerProgress) {
        this.peerProgress = peerProgress;
    }

    @Generated
    public void setPeerFlag(String peerFlag) {
        this.peerFlag = peerFlag;
    }

    @Generated
    public void setTorrentIdentifier(String torrentIdentifier) {
        this.torrentIdentifier = torrentIdentifier;
    }

    @Generated
    public void setTorrentIsPrivate(boolean torrentIsPrivate) {
        this.torrentIsPrivate = torrentIsPrivate;
    }

    @Generated
    public void setTorrentSize(long torrentSize) {
        this.torrentSize = torrentSize;
    }

    @Generated
    public void setFromPeerTraffic(long fromPeerTraffic) {
        this.fromPeerTraffic = fromPeerTraffic;
    }

    @Generated
    public void setToPeerTraffic(long toPeerTraffic) {
        this.toPeerTraffic = toPeerTraffic;
    }

    @Generated
    public void setDownloaderProgress(double downloaderProgress) {
        this.downloaderProgress = downloaderProgress;
    }

    @Generated
    public void setModule(String module) {
        this.module = module;
    }

    @Generated
    public void setRule(String rule) {
        this.rule = rule;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setStructuredData(String structuredData) {
        this.structuredData = structuredData;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BtnBan)) {
            return false;
        }
        BtnBan other = (BtnBan)o;
        if (this.getPeerPort() != other.getPeerPort()) {
            return false;
        }
        if (Double.compare(this.getPeerProgress(), other.getPeerProgress()) != 0) {
            return false;
        }
        if (this.isTorrentIsPrivate() != other.isTorrentIsPrivate()) {
            return false;
        }
        if (this.getTorrentSize() != other.getTorrentSize()) {
            return false;
        }
        if (this.getFromPeerTraffic() != other.getFromPeerTraffic()) {
            return false;
        }
        if (this.getToPeerTraffic() != other.getToPeerTraffic()) {
            return false;
        }
        if (Double.compare(this.getDownloaderProgress(), other.getDownloaderProgress()) != 0) {
            return false;
        }
        Timestamp this$banAt = this.getBanAt();
        Timestamp other$banAt = other.getBanAt();
        if (this$banAt == null ? other$banAt != null : !((Object)this$banAt).equals(other$banAt)) {
            return false;
        }
        String this$peerIp = this.getPeerIp();
        String other$peerIp = other.getPeerIp();
        if (this$peerIp == null ? other$peerIp != null : !this$peerIp.equals(other$peerIp)) {
            return false;
        }
        String this$peerId = this.getPeerId();
        String other$peerId = other.getPeerId();
        if (this$peerId == null ? other$peerId != null : !this$peerId.equals(other$peerId)) {
            return false;
        }
        String this$peerClientName = this.getPeerClientName();
        String other$peerClientName = other.getPeerClientName();
        if (this$peerClientName == null ? other$peerClientName != null : !this$peerClientName.equals(other$peerClientName)) {
            return false;
        }
        String this$peerFlag = this.getPeerFlag();
        String other$peerFlag = other.getPeerFlag();
        if (this$peerFlag == null ? other$peerFlag != null : !this$peerFlag.equals(other$peerFlag)) {
            return false;
        }
        String this$torrentIdentifier = this.getTorrentIdentifier();
        String other$torrentIdentifier = other.getTorrentIdentifier();
        if (this$torrentIdentifier == null ? other$torrentIdentifier != null : !this$torrentIdentifier.equals(other$torrentIdentifier)) {
            return false;
        }
        String this$module = this.getModule();
        String other$module = other.getModule();
        if (this$module == null ? other$module != null : !this$module.equals(other$module)) {
            return false;
        }
        String this$rule = this.getRule();
        String other$rule = other.getRule();
        if (this$rule == null ? other$rule != null : !this$rule.equals(other$rule)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$structuredData = this.getStructuredData();
        String other$structuredData = other.getStructuredData();
        return !(this$structuredData == null ? other$structuredData != null : !this$structuredData.equals(other$structuredData));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPeerPort();
        long $peerProgress = Double.doubleToLongBits(this.getPeerProgress());
        result = result * 59 + (int)($peerProgress >>> 32 ^ $peerProgress);
        result = result * 59 + (this.isTorrentIsPrivate() ? 79 : 97);
        long $torrentSize = this.getTorrentSize();
        result = result * 59 + (int)($torrentSize >>> 32 ^ $torrentSize);
        long $fromPeerTraffic = this.getFromPeerTraffic();
        result = result * 59 + (int)($fromPeerTraffic >>> 32 ^ $fromPeerTraffic);
        long $toPeerTraffic = this.getToPeerTraffic();
        result = result * 59 + (int)($toPeerTraffic >>> 32 ^ $toPeerTraffic);
        long $downloaderProgress = Double.doubleToLongBits(this.getDownloaderProgress());
        result = result * 59 + (int)($downloaderProgress >>> 32 ^ $downloaderProgress);
        Timestamp $banAt = this.getBanAt();
        result = result * 59 + ($banAt == null ? 43 : ((Object)$banAt).hashCode());
        String $peerIp = this.getPeerIp();
        result = result * 59 + ($peerIp == null ? 43 : $peerIp.hashCode());
        String $peerId = this.getPeerId();
        result = result * 59 + ($peerId == null ? 43 : $peerId.hashCode());
        String $peerClientName = this.getPeerClientName();
        result = result * 59 + ($peerClientName == null ? 43 : $peerClientName.hashCode());
        String $peerFlag = this.getPeerFlag();
        result = result * 59 + ($peerFlag == null ? 43 : $peerFlag.hashCode());
        String $torrentIdentifier = this.getTorrentIdentifier();
        result = result * 59 + ($torrentIdentifier == null ? 43 : $torrentIdentifier.hashCode());
        String $module = this.getModule();
        result = result * 59 + ($module == null ? 43 : $module.hashCode());
        String $rule = this.getRule();
        result = result * 59 + ($rule == null ? 43 : $rule.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $structuredData = this.getStructuredData();
        result = result * 59 + ($structuredData == null ? 43 : $structuredData.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BtnBan(banAt=" + String.valueOf(this.getBanAt()) + ", peerIp=" + this.getPeerIp() + ", peerPort=" + this.getPeerPort() + ", peerId=" + this.getPeerId() + ", peerClientName=" + this.getPeerClientName() + ", peerProgress=" + this.getPeerProgress() + ", peerFlag=" + this.getPeerFlag() + ", torrentIdentifier=" + this.getTorrentIdentifier() + ", torrentIsPrivate=" + this.isTorrentIsPrivate() + ", torrentSize=" + this.getTorrentSize() + ", fromPeerTraffic=" + this.getFromPeerTraffic() + ", toPeerTraffic=" + this.getToPeerTraffic() + ", downloaderProgress=" + this.getDownloaderProgress() + ", module=" + this.getModule() + ", rule=" + this.getRule() + ", description=" + this.getDescription() + ", structuredData=" + this.getStructuredData() + ")";
    }

    @Generated
    public BtnBan(Timestamp banAt, String peerIp, int peerPort, String peerId, String peerClientName, double peerProgress, String peerFlag, String torrentIdentifier, boolean torrentIsPrivate, long torrentSize, long fromPeerTraffic, long toPeerTraffic, double downloaderProgress, String module, String rule, String description, String structuredData) {
        this.banAt = banAt;
        this.peerIp = peerIp;
        this.peerPort = peerPort;
        this.peerId = peerId;
        this.peerClientName = peerClientName;
        this.peerProgress = peerProgress;
        this.peerFlag = peerFlag;
        this.torrentIdentifier = torrentIdentifier;
        this.torrentIsPrivate = torrentIsPrivate;
        this.torrentSize = torrentSize;
        this.fromPeerTraffic = fromPeerTraffic;
        this.toPeerTraffic = toPeerTraffic;
        this.downloaderProgress = downloaderProgress;
        this.module = module;
        this.rule = rule;
        this.description = description;
        this.structuredData = structuredData;
    }

    @Generated
    public BtnBan() {
    }
}

