/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.btn.ping.legacy;

import com.ghostchu.peerbanhelper.bittorrent.peer.Peer;
import com.ghostchu.peerbanhelper.bittorrent.torrent.Torrent;
import com.ghostchu.peerbanhelper.util.InfoHashUtil;
import com.ghostchu.peerbanhelper.wrapper.PeerWrapper;
import com.ghostchu.peerbanhelper.wrapper.TorrentWrapper;
import com.google.gson.annotations.SerializedName;
import lombok.Generated;

public final class LegacyBtnPeer {
    @SerializedName(value="ip_address")
    private String ipAddress;
    @SerializedName(value="peer_port")
    private int peerPort;
    @SerializedName(value="peer_id")
    private String peerId;
    @SerializedName(value="client_name")
    private String clientName;
    @SerializedName(value="torrent_identifier")
    private String torrentIdentifier;
    @SerializedName(value="torrent_is_private")
    private boolean torrentIsPrivate;
    @SerializedName(value="torrent_size")
    private long torrentSize;
    @SerializedName(value="downloaded")
    private long downloaded;
    @SerializedName(value="rt_download_speed")
    private long rtDownloadSpeed;
    @SerializedName(value="uploaded")
    private long uploaded;
    @SerializedName(value="rt_upload_speed")
    private long rtUploadSpeed;
    @SerializedName(value="peer_progress")
    private double peerProgress;
    @SerializedName(value="downloader_progress")
    private double downloaderProgress;
    @SerializedName(value="peer_flag")
    private String peerFlag;

    public static LegacyBtnPeer from(Torrent torrent, Peer peer) {
        return LegacyBtnPeer.from(new TorrentWrapper(torrent), new PeerWrapper(peer));
    }

    public static LegacyBtnPeer from(TorrentWrapper torrent, PeerWrapper peer) {
        LegacyBtnPeer btnPeer = new LegacyBtnPeer();
        btnPeer.setIpAddress(peer.getAddress().getIp());
        btnPeer.setPeerPort(peer.getAddress().getPort());
        btnPeer.setPeerId(peer.getId());
        btnPeer.setClientName(peer.getClientName());
        String hashedId = InfoHashUtil.getHashedIdentifier(torrent.getHash());
        btnPeer.setTorrentIdentifier(hashedId);
        btnPeer.setTorrentIsPrivate(torrent.isPrivateTorrent());
        btnPeer.setTorrentSize(torrent.getSize());
        btnPeer.setDownloaded(peer.getDownloaded());
        btnPeer.setRtDownloadSpeed(peer.getDownloadSpeed());
        btnPeer.setUploaded(peer.getUploaded());
        btnPeer.setRtUploadSpeed(peer.getUploadSpeed());
        btnPeer.setPeerProgress(peer.getProgress());
        btnPeer.setDownloaderProgress(torrent.getProgress());
        btnPeer.setPeerFlag(peer.getFlags() == null ? null : peer.getFlags());
        return btnPeer;
    }

    @Generated
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Generated
    public int getPeerPort() {
        return this.peerPort;
    }

    @Generated
    public String getPeerId() {
        return this.peerId;
    }

    @Generated
    public String getClientName() {
        return this.clientName;
    }

    @Generated
    public String getTorrentIdentifier() {
        return this.torrentIdentifier;
    }

    @Generated
    public boolean isTorrentIsPrivate() {
        return this.torrentIsPrivate;
    }

    @Generated
    public long getTorrentSize() {
        return this.torrentSize;
    }

    @Generated
    public long getDownloaded() {
        return this.downloaded;
    }

    @Generated
    public long getRtDownloadSpeed() {
        return this.rtDownloadSpeed;
    }

    @Generated
    public long getUploaded() {
        return this.uploaded;
    }

    @Generated
    public long getRtUploadSpeed() {
        return this.rtUploadSpeed;
    }

    @Generated
    public double getPeerProgress() {
        return this.peerProgress;
    }

    @Generated
    public double getDownloaderProgress() {
        return this.downloaderProgress;
    }

    @Generated
    public String getPeerFlag() {
        return this.peerFlag;
    }

    @Generated
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    @Generated
    public void setPeerPort(int peerPort) {
        this.peerPort = peerPort;
    }

    @Generated
    public void setPeerId(String peerId) {
        this.peerId = peerId;
    }

    @Generated
    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    @Generated
    public void setTorrentIdentifier(String torrentIdentifier) {
        this.torrentIdentifier = torrentIdentifier;
    }

    @Generated
    public void setTorrentIsPrivate(boolean torrentIsPrivate) {
        this.torrentIsPrivate = torrentIsPrivate;
    }

    @Generated
    public void setTorrentSize(long torrentSize) {
        this.torrentSize = torrentSize;
    }

    @Generated
    public void setDownloaded(long downloaded) {
        this.downloaded = downloaded;
    }

    @Generated
    public void setRtDownloadSpeed(long rtDownloadSpeed) {
        this.rtDownloadSpeed = rtDownloadSpeed;
    }

    @Generated
    public void setUploaded(long uploaded) {
        this.uploaded = uploaded;
    }

    @Generated
    public void setRtUploadSpeed(long rtUploadSpeed) {
        this.rtUploadSpeed = rtUploadSpeed;
    }

    @Generated
    public void setPeerProgress(double peerProgress) {
        this.peerProgress = peerProgress;
    }

    @Generated
    public void setDownloaderProgress(double downloaderProgress) {
        this.downloaderProgress = downloaderProgress;
    }

    @Generated
    public void setPeerFlag(String peerFlag) {
        this.peerFlag = peerFlag;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LegacyBtnPeer)) {
            return false;
        }
        LegacyBtnPeer other = (LegacyBtnPeer)o;
        if (this.getPeerPort() != other.getPeerPort()) {
            return false;
        }
        if (this.isTorrentIsPrivate() != other.isTorrentIsPrivate()) {
            return false;
        }
        if (this.getTorrentSize() != other.getTorrentSize()) {
            return false;
        }
        if (this.getDownloaded() != other.getDownloaded()) {
            return false;
        }
        if (this.getRtDownloadSpeed() != other.getRtDownloadSpeed()) {
            return false;
        }
        if (this.getUploaded() != other.getUploaded()) {
            return false;
        }
        if (this.getRtUploadSpeed() != other.getRtUploadSpeed()) {
            return false;
        }
        if (Double.compare(this.getPeerProgress(), other.getPeerProgress()) != 0) {
            return false;
        }
        if (Double.compare(this.getDownloaderProgress(), other.getDownloaderProgress()) != 0) {
            return false;
        }
        String this$ipAddress = this.getIpAddress();
        String other$ipAddress = other.getIpAddress();
        if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
            return false;
        }
        String this$peerId = this.getPeerId();
        String other$peerId = other.getPeerId();
        if (this$peerId == null ? other$peerId != null : !this$peerId.equals(other$peerId)) {
            return false;
        }
        String this$clientName = this.getClientName();
        String other$clientName = other.getClientName();
        if (this$clientName == null ? other$clientName != null : !this$clientName.equals(other$clientName)) {
            return false;
        }
        String this$torrentIdentifier = this.getTorrentIdentifier();
        String other$torrentIdentifier = other.getTorrentIdentifier();
        if (this$torrentIdentifier == null ? other$torrentIdentifier != null : !this$torrentIdentifier.equals(other$torrentIdentifier)) {
            return false;
        }
        String this$peerFlag = this.getPeerFlag();
        String other$peerFlag = other.getPeerFlag();
        return !(this$peerFlag == null ? other$peerFlag != null : !this$peerFlag.equals(other$peerFlag));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPeerPort();
        result = result * 59 + (this.isTorrentIsPrivate() ? 79 : 97);
        long $torrentSize = this.getTorrentSize();
        result = result * 59 + (int)($torrentSize >>> 32 ^ $torrentSize);
        long $downloaded = this.getDownloaded();
        result = result * 59 + (int)($downloaded >>> 32 ^ $downloaded);
        long $rtDownloadSpeed = this.getRtDownloadSpeed();
        result = result * 59 + (int)($rtDownloadSpeed >>> 32 ^ $rtDownloadSpeed);
        long $uploaded = this.getUploaded();
        result = result * 59 + (int)($uploaded >>> 32 ^ $uploaded);
        long $rtUploadSpeed = this.getRtUploadSpeed();
        result = result * 59 + (int)($rtUploadSpeed >>> 32 ^ $rtUploadSpeed);
        long $peerProgress = Double.doubleToLongBits(this.getPeerProgress());
        result = result * 59 + (int)($peerProgress >>> 32 ^ $peerProgress);
        long $downloaderProgress = Double.doubleToLongBits(this.getDownloaderProgress());
        result = result * 59 + (int)($downloaderProgress >>> 32 ^ $downloaderProgress);
        String $ipAddress = this.getIpAddress();
        result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
        String $peerId = this.getPeerId();
        result = result * 59 + ($peerId == null ? 43 : $peerId.hashCode());
        String $clientName = this.getClientName();
        result = result * 59 + ($clientName == null ? 43 : $clientName.hashCode());
        String $torrentIdentifier = this.getTorrentIdentifier();
        result = result * 59 + ($torrentIdentifier == null ? 43 : $torrentIdentifier.hashCode());
        String $peerFlag = this.getPeerFlag();
        result = result * 59 + ($peerFlag == null ? 43 : $peerFlag.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LegacyBtnPeer(ipAddress=" + this.getIpAddress() + ", peerPort=" + this.getPeerPort() + ", peerId=" + this.getPeerId() + ", clientName=" + this.getClientName() + ", torrentIdentifier=" + this.getTorrentIdentifier() + ", torrentIsPrivate=" + this.isTorrentIsPrivate() + ", torrentSize=" + this.getTorrentSize() + ", downloaded=" + this.getDownloaded() + ", rtDownloadSpeed=" + this.getRtDownloadSpeed() + ", uploaded=" + this.getUploaded() + ", rtUploadSpeed=" + this.getRtUploadSpeed() + ", peerProgress=" + this.getPeerProgress() + ", downloaderProgress=" + this.getDownloaderProgress() + ", peerFlag=" + this.getPeerFlag() + ")";
    }

    @Generated
    public LegacyBtnPeer(String ipAddress, int peerPort, String peerId, String clientName, String torrentIdentifier, boolean torrentIsPrivate, long torrentSize, long downloaded, long rtDownloadSpeed, long uploaded, long rtUploadSpeed, double peerProgress, double downloaderProgress, String peerFlag) {
        this.ipAddress = ipAddress;
        this.peerPort = peerPort;
        this.peerId = peerId;
        this.clientName = clientName;
        this.torrentIdentifier = torrentIdentifier;
        this.torrentIsPrivate = torrentIsPrivate;
        this.torrentSize = torrentSize;
        this.downloaded = downloaded;
        this.rtDownloadSpeed = rtDownloadSpeed;
        this.uploaded = uploaded;
        this.rtUploadSpeed = rtUploadSpeed;
        this.peerProgress = peerProgress;
        this.downloaderProgress = downloaderProgress;
        this.peerFlag = peerFlag;
    }

    @Generated
    public LegacyBtnPeer() {
    }
}

