/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.configuration.pf4j;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.platform.Platform;
import com.ghostchu.peerbanhelper.platform.types.MalwareScanner;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import org.pf4j.ExtensionFactory;
import org.pf4j.PluginManager;
import org.pf4j.PluginRuntimeException;
import org.pf4j.PluginState;
import org.pf4j.PluginStateEvent;
import org.pf4j.PluginWrapper;
import org.pf4j.spring.ExtensionsInjector;
import org.pf4j.spring.SpringExtensionFactory;
import org.pf4j.spring.SpringPluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class PBHSpringPluginManager
extends SpringPluginManager
implements ApplicationContextAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PBHSpringPluginManager.class);
    private ApplicationContext applicationContext;

    public PBHSpringPluginManager() {
    }

    public PBHSpringPluginManager(Path ... pluginsRoots) {
        super(pluginsRoots);
    }

    public PBHSpringPluginManager(List<Path> pluginsRoots) {
        super(pluginsRoots);
    }

    @Override
    protected ExtensionFactory createExtensionFactory() {
        return new SpringExtensionFactory((PluginManager)this);
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    @PostConstruct
    public void init() {
        this.loadPlugins();
        this.startPlugins();
        AbstractAutowireCapableBeanFactory beanFactory = (AbstractAutowireCapableBeanFactory)this.applicationContext.getAutowireCapableBeanFactory();
        ExtensionsInjector extensionsInjector = new ExtensionsInjector(this, beanFactory);
        extensionsInjector.injectExtensions();
    }

    public void loadPlugins() {
        log.debug("Lookup plugins in '{}'", (Object)this.pluginsRoots);
        if (this.pluginsRoots.isEmpty()) {
            log.warn("No plugins roots configured");
            return;
        }
        this.pluginsRoots.forEach(path -> {
            if (Files.notExists(path, new LinkOption[0]) || !Files.isDirectory(path, new LinkOption[0])) {
                log.warn("No '{}' root", path);
            }
        });
        List pluginPaths = this.pluginRepository.getPluginPaths();
        if (pluginPaths.isEmpty()) {
            log.info("No plugins");
            return;
        }
        log.debug("Found {} possible plugins: {}", (Object)pluginPaths.size(), (Object)pluginPaths);
        for (Path pluginPath : pluginPaths) {
            try {
                this.loadPluginFromPath(pluginPath);
            }
            catch (PluginRuntimeException e) {
                log.error("Cannot load plugin '{}'", (Object)pluginPath, (Object)e);
            }
        }
        this.resolvePlugins();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPlugins() {
        for (PluginWrapper pluginWrapper : this.resolvedPlugins) {
            PluginState pluginState = pluginWrapper.getPluginState();
            if (pluginState.isDisabled() || pluginState.isStarted()) continue;
            try {
                log.info("Start plugin '{}'", (Object)this.getPluginLabel(pluginWrapper.getDescriptor()));
                pluginWrapper.getPlugin().start();
                pluginWrapper.setPluginState(PluginState.STARTED);
                pluginWrapper.setFailedException(null);
                this.startedPlugins.add(pluginWrapper);
            }
            catch (Throwable e) {
                pluginWrapper.setPluginState(PluginState.FAILED);
                pluginWrapper.setFailedException(e);
                log.error("Unable to start plugin '{}'", (Object)this.getPluginLabel(pluginWrapper.getDescriptor()), (Object)e);
            }
            finally {
                this.firePluginStateEvent(new PluginStateEvent((PluginManager)this, pluginWrapper, pluginState));
            }
        }
    }

    public void stopPlugins() {
        Collections.reverse(this.startedPlugins);
        Iterator itr = this.startedPlugins.iterator();
        while (itr.hasNext()) {
            PluginWrapper pluginWrapper = (PluginWrapper)itr.next();
            PluginState pluginState = pluginWrapper.getPluginState();
            if (pluginState.isStarted()) {
                try {
                    log.info("Stop plugin '{}'", (Object)this.getPluginLabel(pluginWrapper.getDescriptor()));
                    pluginWrapper.getPlugin().stop();
                    pluginWrapper.setPluginState(PluginState.STOPPED);
                    itr.remove();
                    this.firePluginStateEvent(new PluginStateEvent((PluginManager)this, pluginWrapper, pluginState));
                }
                catch (Throwable e) {
                    log.error("Unable to stop plugin '{}'", (Object)this.getPluginLabel(pluginWrapper.getDescriptor()), (Object)e);
                }
                continue;
            }
            log.debug("Plugin '{}' is not started, nothing to stop", (Object)this.getPluginLabel(pluginWrapper.getDescriptor()));
        }
    }

    protected PluginWrapper loadPluginFromPath(Path pluginPath) {
        Platform platform = Main.getPlatform();
        if (platform != null) {
            try (MalwareScanner scanner = platform.getMalwareScanner();){
                File file;
                if (scanner != null && scanner.isMalicious(file = pluginPath.toFile())) {
                    throw new PluginRuntimeException(TextManager.tlUI(Lang.MALWARE_SCANNER_DETECTED, "[JavaPlugin", pluginPath.toAbsolutePath()));
                }
            }
            catch (PluginRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                log.debug("Malware scan failed for plugin '{}': Unable to close scanner", (Object)pluginPath, (Object)e);
            }
        }
        return super.loadPluginFromPath(pluginPath);
    }
}

