/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.database.dao.impl;

import com.ghostchu.peerbanhelper.database.dao.AbstractPBHDao;
import com.ghostchu.peerbanhelper.database.table.AlertEntity;
import com.ghostchu.peerbanhelper.util.query.Page;
import com.ghostchu.peerbanhelper.util.query.Pageable;
import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class AlertDao
extends AbstractPBHDao<AlertEntity, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlertDao.class);

    public AlertDao(@Autowired ConnectionSource database) throws SQLException {
        super(database, AlertEntity.class);
    }

    public Page<AlertEntity> getUnreadAlerts(Pageable pageable) throws SQLException {
        return this.queryByPaging(this.queryBuilder().orderBy("createAt", false).where().isNull("readAt").queryBuilder(), pageable);
    }

    public List<AlertEntity> getUnreadAlertsUnPaged() throws SQLException {
        return this.queryBuilder().orderBy("createAt", false).where().isNull("readAt").queryBuilder().query();
    }

    public boolean identifierAlertExists(String identifier) throws SQLException {
        return this.queryForFirst(this.queryBuilder().where().eq("identifier", (Object)new SelectArg((Object)identifier)).and().isNull("readAt").prepare()) != null;
    }

    public boolean identifierAlertExistsIncludeRead(String identifier) throws SQLException {
        return this.queryForFirst(this.queryBuilder().where().eq("identifier", (Object)new SelectArg((Object)identifier)).prepare()) != null;
    }

    public int deleteOldAlerts(Timestamp before) throws SQLException {
        DeleteBuilder builder = this.deleteBuilder();
        builder.setWhere(this.queryBuilder().where().lt("createAt", (Object)before).and().isNotNull("readAt"));
        return builder.delete();
    }

    public void markAllAsRead() throws SQLException {
        List alerts = this.queryBuilder().where().isNull("readAt").query();
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        for (AlertEntity alert : alerts) {
            alert.setReadAt(ts);
            this.update(alert);
        }
    }

    public void markAsRead(String identifier) throws SQLException {
        this.update(this.updateBuilder().updateColumnValue("identifier", (Object)new SelectArg((Object)identifier)).updateColumnValue("readAt", (Object)new Timestamp(System.currentTimeMillis())).prepare());
    }
}

