/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.database.dao.impl.tmp;

import com.ghostchu.peerbanhelper.ExternalSwitch;
import com.ghostchu.peerbanhelper.bittorrent.peer.Peer;
import com.ghostchu.peerbanhelper.bittorrent.torrent.Torrent;
import com.ghostchu.peerbanhelper.database.dao.AbstractPBHDao;
import com.ghostchu.peerbanhelper.database.table.tmp.TrackedSwarmEntity;
import com.ghostchu.peerbanhelper.downloader.Downloader;
import com.ghostchu.peerbanhelper.util.query.Page;
import com.ghostchu.peerbanhelper.util.query.Pageable;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class TrackedSwarmDao
extends AbstractPBHDao<TrackedSwarmEntity, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TrackedSwarmDao.class);
    private final Cache<@NotNull CacheKey, @NotNull TrackedSwarmEntity> cache = CacheBuilder.newBuilder().maximumSize((long)ExternalSwitch.parseInt("pbh.module.swarm-tracking-module.cache-size", 1000)).expireAfterAccess(3L, TimeUnit.MINUTES).removalListener(notification -> {
        TrackedSwarmEntity v = (TrackedSwarmEntity)notification.getValue();
        try {
            this.createOrUpdate(v);
        }
        catch (SQLException e) {
            log.error("Unable flush back to database for swarm tracking {}", (Object)v, (Object)e);
        }
    }).softValues().build();

    public TrackedSwarmDao(@Autowired ConnectionSource source) throws SQLException {
        super(source, TrackedSwarmEntity.class);
    }

    public Page<TrackedSwarmEntity> getPendingSubmitTrackedPeers(Pageable pageable, long idAfterThan) throws SQLException {
        QueryBuilder queryBuilder = this.queryBuilder().where().gt("id", (Object)idAfterThan).queryBuilder().orderBy("id", true);
        return this.queryByPaging(queryBuilder, pageable);
    }

    public void syncPeers(@NotNull Downloader downloader, @NotNull Torrent torrent, Peer peer) throws ExecutionException {
        CacheKey cacheKey = new CacheKey(peer.getPeerAddress().getAddress().toNormalizedString(), peer.getPeerAddress().getPort(), torrent.getHash(), downloader.getId());
        TrackedSwarmEntity cachedEntity = (TrackedSwarmEntity)this.cache.get((Object)cacheKey, () -> {
            TrackedSwarmEntity lastData = (TrackedSwarmEntity)this.queryBuilder().where().eq("ip", (Object)cacheKey.ip).and().eq("port", (Object)cacheKey.port).and().eq("infoHash", (Object)cacheKey.infoHash).and().eq("downloader", (Object)cacheKey.downloader).queryForFirst();
            return Objects.requireNonNullElseGet(lastData, () -> new TrackedSwarmEntity(null, peer.getPeerAddress().getAddress().toNormalizedString(), peer.getPeerAddress().getPort(), torrent.getHash(), torrent.isPrivate(), torrent.getSize(), downloader.getId(), torrent.getProgress(), peer.getPeerId(), peer.getClientName(), peer.getProgress(), 0L, 0L, peer.getUploadSpeed(), 0L, 0L, peer.getDownloadSpeed(), peer.getFlags() == null ? "" : peer.getFlags().getLtStdString(), new Timestamp(System.currentTimeMillis()), new Timestamp(System.currentTimeMillis()), peer.getDownloadSpeed(), peer.getUploadSpeed()));
        });
        long newDownloaded = peer.getDownloaded() >= cachedEntity.getDownloadedOffset() ? peer.getDownloaded() - cachedEntity.getDownloadedOffset() : peer.getDownloaded();
        long newUploaded = peer.getUploaded() >= cachedEntity.getUploadedOffset() ? peer.getUploaded() - cachedEntity.getUploadedOffset() : peer.getUploaded();
        cachedEntity.setDownloaded(cachedEntity.getDownloaded() + newDownloaded);
        cachedEntity.setUploaded(cachedEntity.getUploaded() + newUploaded);
        cachedEntity.setDownloadedOffset(peer.getDownloaded());
        cachedEntity.setUploadedOffset(peer.getUploaded());
        cachedEntity.setClientName(peer.getClientName());
        cachedEntity.setPeerId(peer.getPeerId());
        cachedEntity.setLastFlags(peer.getFlags() == null ? "" : peer.getFlags().getLtStdString());
        cachedEntity.setLastTimeSeen(new Timestamp(System.currentTimeMillis()));
        cachedEntity.setDownloadSpeedMax(Math.max(peer.getDownloadSpeed(), cachedEntity.getDownloadSpeedMax()));
        cachedEntity.setUploadSpeedMax(Math.max(peer.getUploadSpeed(), cachedEntity.getUploadSpeedMax()));
    }

    public void flushAll() {
        try {
            this.callBatchTasks(() -> {
                for (TrackedSwarmEntity value : this.cache.asMap().values()) {
                    try {
                        this.createOrUpdate(value);
                    }
                    catch (SQLException e) {
                        log.error("Unable flush back to database for TrackedSwarm: {}", (Object)value, (Object)e);
                    }
                }
                return null;
            });
        }
        catch (SQLException e) {
            log.error("Unable to flush all tracked swarm cache to database", (Throwable)e);
        }
    }

    record CacheKey(String ip, int port, String infoHash, String downloader) {
    }
}

