/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.downloader.impl.bitcomet;

import com.ghostchu.peerbanhelper.alert.AlertManager;
import com.ghostchu.peerbanhelper.bittorrent.peer.Peer;
import com.ghostchu.peerbanhelper.bittorrent.peer.PeerImpl;
import com.ghostchu.peerbanhelper.bittorrent.torrent.Torrent;
import com.ghostchu.peerbanhelper.bittorrent.torrent.TorrentImpl;
import com.ghostchu.peerbanhelper.bittorrent.tracker.Tracker;
import com.ghostchu.peerbanhelper.bittorrent.tracker.TrackerImpl;
import com.ghostchu.peerbanhelper.downloader.AbstractDownloader;
import com.ghostchu.peerbanhelper.downloader.DownloaderFeatureFlag;
import com.ghostchu.peerbanhelper.downloader.DownloaderLoginResult;
import com.ghostchu.peerbanhelper.downloader.DownloaderSpeedLimiter;
import com.ghostchu.peerbanhelper.downloader.DownloaderStatistics;
import com.ghostchu.peerbanhelper.downloader.impl.bitcomet.BCEndpoint;
import com.ghostchu.peerbanhelper.downloader.impl.bitcomet.crypto.BCAESTool;
import com.ghostchu.peerbanhelper.downloader.impl.bitcomet.resp.BCConfigSetResponse;
import com.ghostchu.peerbanhelper.downloader.impl.bitcomet.resp.BCConnectionConfigResponse;
import com.ghostchu.peerbanhelper.downloader.impl.bitcomet.resp.BCDeviceTokenResult;
import com.ghostchu.peerbanhelper.downloader.impl.bitcomet.resp.BCIpFilterResponse;
import com.ghostchu.peerbanhelper.downloader.impl.bitcomet.resp.BCLoginResponse;
import com.ghostchu.peerbanhelper.downloader.impl.bitcomet.resp.BCStatisticsValueListResponse;
import com.ghostchu.peerbanhelper.downloader.impl.bitcomet.resp.BCTaskListResponse;
import com.ghostchu.peerbanhelper.downloader.impl.bitcomet.resp.BCTaskPeersResponse;
import com.ghostchu.peerbanhelper.downloader.impl.bitcomet.resp.BCTaskTorrentResponse;
import com.ghostchu.peerbanhelper.downloader.impl.bitcomet.resp.BCTaskTrackersResponse;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.ByteUtil;
import com.ghostchu.peerbanhelper.util.HTTPUtil;
import com.ghostchu.peerbanhelper.util.json.JsonUtil;
import com.ghostchu.peerbanhelper.util.traversal.NatAddressProvider;
import com.ghostchu.peerbanhelper.wrapper.BanMetadata;
import com.ghostchu.peerbanhelper.wrapper.PeerAddress;
import com.google.common.net.HostAndPort;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.spotify.futures.CompletableFutures;
import com.vdurmont.semver4j.Semver;
import inet.ipaddr.IPAddress;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import okhttp3.ConnectionPool;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.bspfsystems.yamlconfiguration.configuration.ConfigurationSection;
import org.bspfsystems.yamlconfiguration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BitComet
extends AbstractDownloader {
    private static final Logger log = LoggerFactory.getLogger(BitComet.class);
    private static final UUID clientId = UUID.nameUUIDFromBytes("PeerBanHelper".getBytes(StandardCharsets.UTF_8));
    private final String apiEndpoint;
    private final OkHttpClient httpClient;
    private final Config config;
    private String deviceToken;
    private String serverId;
    private Semver serverVersion;
    private String serverName;
    private final ExecutorService parallelService = Executors.newWorkStealingPool();

    public BitComet(String id, Config config, AlertManager alertManager, HTTPUtil httpUtil, NatAddressProvider natAddressProvider) {
        super(id, alertManager, natAddressProvider);
        BCAESTool.init();
        this.config = config;
        this.apiEndpoint = config.getEndpoint();
        OkHttpClient.Builder builder = httpUtil.newBuilderForDownloader().connectionPool(new ConnectionPool(this.getMaxConcurrentPeerRequestSlots() + 10, 5L, TimeUnit.MINUTES)).connectTimeout(Duration.of(10L, ChronoUnit.SECONDS)).readTimeout(Duration.of(30L, ChronoUnit.SECONDS)).writeTimeout(Duration.of(30L, ChronoUnit.SECONDS)).addInterceptor(chain -> {
            Request originalRequest = chain.request();
            Request newRequest = originalRequest.newBuilder().header("Content-Type", "application/json").header("Client-Type", "BitComet WebUI").header("User-Agent", "PeerBanHelper BitComet Adapter").build();
            return chain.proceed(newRequest);
        });
        httpUtil.disableSSLVerify(builder, !config.isVerifySsl());
        this.httpClient = builder.build();
    }

    @Override
    @NotNull
    public String getName() {
        return this.config.getName();
    }

    public static BitComet loadFromConfig(String id, ConfigurationSection section, AlertManager alertManager, HTTPUtil httpUtil, NatAddressProvider natAddressProvider) {
        Config config = Config.readFromYaml(section, id);
        return new BitComet(id, config, alertManager, httpUtil, natAddressProvider);
    }

    public static BitComet loadFromConfig(String id, JsonObject section, AlertManager alertManager, HTTPUtil httpUtil, NatAddressProvider natAddressProvider) {
        Config config = (Config)JsonUtil.getGson().fromJson((JsonElement)section, Config.class);
        return new BitComet(id, config, alertManager, httpUtil, natAddressProvider);
    }

    private static PeerAddress parseAddress(String address, int port, int listenPort) {
        address = address.trim();
        HostAndPort hostAndPort = HostAndPort.fromString((String)address);
        return new PeerAddress(hostAndPort.getHost(), hostAndPort.getPortOrDefault(port), hostAndPort.getHost());
    }

    @Override
    @NotNull
    public List<DownloaderFeatureFlag> getFeatureFlags() {
        ArrayList<DownloaderFeatureFlag> flags = new ArrayList<DownloaderFeatureFlag>(2);
        flags.add(DownloaderFeatureFlag.UNBAN_IP);
        flags.add(DownloaderFeatureFlag.LIVE_UPDATE_BT_PROTOCOL_PORT);
        if (this.serverVersion.isGreaterThanOrEqualTo("2.20")) {
            flags.add(DownloaderFeatureFlag.TRAFFIC_STATS);
        }
        return flags;
    }

    @Override
    @NotNull
    public JsonObject saveDownloaderJson() {
        return JsonUtil.getGson().toJsonTree((Object)this.config).getAsJsonObject();
    }

    @Override
    @NotNull
    public YamlConfiguration saveDownloader() {
        return this.config.saveToYaml();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DownloaderLoginResult login0() throws Exception {
        if (this.isLoggedIn()) {
            return new DownloaderLoginResult(DownloaderLoginResult.Status.SUCCESS, new TranslationComponent(Lang.STATUS_TEXT_OK));
        }
        HashMap<String, String> loginAttemptCred = new HashMap<String, String>();
        loginAttemptCred.put("username", this.config.getUsername());
        loginAttemptCred.put("password", this.config.getPassword());
        String aesEncrypted = BCAESTool.credential(JsonUtil.standard().toJson(loginAttemptCred), clientId.toString());
        HashMap<String, String> loginJsonObject = new HashMap<String, String>();
        loginJsonObject.put("authentication", aesEncrypted);
        loginJsonObject.put("client_id", clientId.toString());
        RequestBody requestBody = RequestBody.create((String)JsonUtil.standard().toJson(loginJsonObject), (MediaType)MediaType.get((String)"application/json"));
        Request request = new Request.Builder().url(this.apiEndpoint + BCEndpoint.USER_LOGIN.getEndpoint()).post(requestBody).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                DownloaderLoginResult downloaderLoginResult = new DownloaderLoginResult(DownloaderLoginResult.Status.EXCEPTION, new TranslationComponent(Lang.DOWNLOADER_LOGIN_EXCEPTION, response.code() + " " + response.body().string()));
                return downloaderLoginResult;
            }
            BCLoginResponse loginResponse = (BCLoginResponse)JsonUtil.standard().fromJson(response.body().string(), BCLoginResponse.class);
            if (loginResponse.getErrorCode().equalsIgnoreCase("PASSWORD_ERROR")) {
                DownloaderLoginResult downloaderLoginResult = new DownloaderLoginResult(DownloaderLoginResult.Status.INCORRECT_CREDENTIAL, new TranslationComponent(Lang.DOWNLOADER_LOGIN_EXCEPTION, loginResponse));
                return downloaderLoginResult;
            }
            if (!loginResponse.getErrorCode().equalsIgnoreCase("ok")) {
                DownloaderLoginResult downloaderLoginResult = new DownloaderLoginResult(DownloaderLoginResult.Status.EXCEPTION, new TranslationComponent(Lang.DOWNLOADER_LOGIN_EXCEPTION, loginResponse));
                return downloaderLoginResult;
            }
            boolean bcVerAcceptable = false;
            Semver bcSemver = new Semver(loginResponse.getVersion(), Semver.SemverType.LOOSE);
            if (bcSemver.getMajor() > 2) {
                bcVerAcceptable = true;
            } else if (bcSemver.getMajor() == 2 && bcSemver.getMinor() >= 18) {
                bcVerAcceptable = true;
            }
            if (!bcVerAcceptable) {
                DownloaderLoginResult downloaderLoginResult = new DownloaderLoginResult(DownloaderLoginResult.Status.MISSING_COMPONENTS, new TranslationComponent(Lang.DOWNLOADER_BC_VERSION_UNACCEPTABLE, "2.18"));
                return downloaderLoginResult;
            }
            HashMap<String, String> inviteTokenRetrievePayload = new HashMap<String, String>();
            inviteTokenRetrievePayload.put("device_id", clientId.toString());
            inviteTokenRetrievePayload.put("device_name", "PeerBanHelper - BitComet Adapter");
            inviteTokenRetrievePayload.put("invite_token", loginResponse.getInviteToken());
            inviteTokenRetrievePayload.put("platform", "webui");
            RequestBody deviceTokenRequestBody = RequestBody.create((String)JsonUtil.standard().toJson(inviteTokenRetrievePayload), (MediaType)MediaType.get((String)"application/json"));
            Request deviceTokenRequest = new Request.Builder().url(this.apiEndpoint + BCEndpoint.GET_DEVICE_TOKEN.getEndpoint()).post(deviceTokenRequestBody).header("Authorization", "Bearer " + loginResponse.getInviteToken()).build();
            try (Response deviceTokenResponse = this.httpClient.newCall(deviceTokenRequest).execute();){
                if (!deviceTokenResponse.isSuccessful()) {
                    DownloaderLoginResult downloaderLoginResult = new DownloaderLoginResult(DownloaderLoginResult.Status.EXCEPTION, new TranslationComponent(Lang.DOWNLOADER_LOGIN_EXCEPTION, deviceTokenResponse.code() + " " + deviceTokenResponse.body().string()));
                    return downloaderLoginResult;
                }
                BCDeviceTokenResult deviceTokenResult = (BCDeviceTokenResult)JsonUtil.standard().fromJson(deviceTokenResponse.body().string(), BCDeviceTokenResult.class);
                this.deviceToken = deviceTokenResult.getDeviceToken();
                this.serverId = deviceTokenResult.getServerId();
                this.serverVersion = new Semver(deviceTokenResult.getVersion(), Semver.SemverType.LOOSE);
                this.serverName = deviceTokenResult.getServerName();
                if (this.queryNeedReConfigureIpFilter()) {
                    this.enableIpFilter();
                }
            }
            DownloaderLoginResult downloaderLoginResult = new DownloaderLoginResult(DownloaderLoginResult.Status.SUCCESS, new TranslationComponent(Lang.STATUS_TEXT_OK));
            return downloaderLoginResult;
        }
        catch (Exception e) {
            return new DownloaderLoginResult(DownloaderLoginResult.Status.EXCEPTION, new TranslationComponent(Lang.DOWNLOADER_LOGIN_IO_EXCEPTION, e.getClass().getName() + ": " + e.getMessage()));
        }
    }

    @Override
    @NotNull
    public String getEndpoint() {
        return this.apiEndpoint;
    }

    @Override
    @NotNull
    public String getType() {
        return "BitComet";
    }

    @Override
    public boolean isPaused() {
        return this.config.isPaused();
    }

    @Override
    public void setPaused(boolean paused) {
        super.setPaused(paused);
        this.config.setPaused(paused);
    }

    public boolean isLoggedIn() {
        try {
            this.queryNeedReConfigureIpFilter();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean queryNeedReConfigureIpFilter() throws IOException {
        RequestBody requestBody = RequestBody.create((String)"{}", (MediaType)MediaType.get((String)"application/json"));
        Request request = new Request.Builder().url(this.apiEndpoint + BCEndpoint.GET_IP_FILTER_CONFIG.getEndpoint()).post(requestBody).header("Authorization", "Bearer " + this.deviceToken).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IllegalStateException("Not a excepted statusCode while query the IPFilter status");
            }
            BCIpFilterResponse resp = (BCIpFilterResponse)JsonUtil.standard().fromJson(response.body().string(), BCIpFilterResponse.class);
            boolean isBlacklistMode = false;
            if (resp.getIpFilterConfig().getFilterMode() != null) {
                isBlacklistMode = "blacklist".equals(resp.getIpFilterConfig().getFilterMode());
            }
            boolean bl = resp.getIpFilterConfig().getEnableIpFilter() == false || !isBlacklistMode;
            return bl;
        }
    }

    private void enableIpFilter() throws IOException {
        HashMap<String, Object> settings = new HashMap<String, Object>(this){
            final /* synthetic */ BitComet this$0;
            {
                BitComet bitComet = this$0;
                Objects.requireNonNull(bitComet);
                this.this$0 = bitComet;
                this.put("ip_filter_config", new HashMap<Object, Object>(this){
                    final /* synthetic */ 1 this$1;
                    {
                        1 v0 = this$1;
                        Objects.requireNonNull(v0);
                        this.this$1 = v0;
                        this.put("enable_ipfilter", true);
                        this.put("ipfilter_mode", "blacklist");
                    }
                });
            }
        };
        RequestBody requestBody = RequestBody.create((String)JsonUtil.standard().toJson((Object)settings), (MediaType)MediaType.get((String)"application/json"));
        Request request = new Request.Builder().url(this.apiEndpoint + BCEndpoint.SET_IP_FILTER_CONFIG.getEndpoint()).post(requestBody).header("Authorization", "Bearer " + this.deviceToken).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                log.error(TextManager.tlUI(Lang.DOWNLOADER_BC_CONFIG_IP_FILTER_FAILED, new Object[0]));
                return;
            }
            BCConfigSetResponse configResp = (BCConfigSetResponse)JsonUtil.standard().fromJson(response.body().string(), BCConfigSetResponse.class);
            if ("ok".equalsIgnoreCase(configResp.getErrorCode())) {
                log.info(TextManager.tlUI(Lang.DOWNLOADER_BC_CONFIG_IP_FILTER_SUCCESS, new Object[0]));
            } else {
                log.error(TextManager.tlUI(Lang.DOWNLOADER_BC_CONFIG_IP_FILTER_FAILED, new Object[0]));
            }
        }
    }

    @Override
    @NotNull
    public List<Torrent> getTorrents() {
        HashMap<String, Object> requirements = new HashMap<String, Object>();
        requirements.put("state_group", "ACTIVE");
        requirements.put("sort_key", "");
        requirements.put("sort_order", "unsorted");
        requirements.put("tag_filter", "ALL");
        requirements.put("task_type", "ALL");
        requirements.put("start", 0);
        requirements.put("limit", 0x7FFFFFFE);
        return this.fetchTorrents(requirements, !this.config.isIgnorePrivate());
    }

    @Override
    @NotNull
    public List<Torrent> getAllTorrents() {
        HashMap<String, Object> requirements = new HashMap<String, Object>();
        requirements.put("state_group", "ALL");
        requirements.put("sort_key", "");
        requirements.put("sort_order", "unsorted");
        requirements.put("tag_filter", "ALL");
        requirements.put("task_type", "ALL");
        requirements.put("start", 0);
        requirements.put("limit", 0x7FFFFFFE);
        return this.fetchTorrents(requirements, true);
    }

    public List<Torrent> fetchTorrents(Map<String, Object> requirements, boolean includePrivate) {
        List<Torrent> list;
        block9: {
            RequestBody requestBody = RequestBody.create((String)JsonUtil.standard().toJson(requirements), (MediaType)MediaType.get((String)"application/json"));
            Request request = new Request.Builder().url(this.apiEndpoint + BCEndpoint.GET_TASK_LIST.getEndpoint()).post(requestBody).header("Authorization", "Bearer " + this.deviceToken).build();
            Response response = this.httpClient.newCall(request).execute();
            try {
                if (!response.isSuccessful()) {
                    throw new IllegalStateException(TextManager.tlUI(Lang.DOWNLOADER_BC_FAILED_REQUEST_TORRENT_LIST, response.code(), response.body().string()));
                }
                BCTaskListResponse taskListResponse = (BCTaskListResponse)JsonUtil.standard().fromJson(response.body().string(), BCTaskListResponse.class);
                Semaphore semaphore = new Semaphore(3);
                List torrentResponses = (List)CompletableFutures.allAsList(taskListResponse.getTasks().stream().filter(t -> t.getType().equals("BT")).map(torrent -> CompletableFuture.supplyAsync(() -> {
                    try {
                        BCTaskTorrentResponse bCTaskTorrentResponse;
                        block16: {
                            Response taskResponse;
                            block14: {
                                BCTaskTorrentResponse bCTaskTorrentResponse2;
                                block15: {
                                    semaphore.acquire();
                                    HashMap<String, String> taskIds = new HashMap<String, String>();
                                    taskIds.put("task_id", String.valueOf(torrent.getTaskId()));
                                    RequestBody taskRequestBody = RequestBody.create((String)JsonUtil.standard().toJson(taskIds), (MediaType)MediaType.get((String)"application/json"));
                                    Request taskRequest = new Request.Builder().url(this.apiEndpoint + BCEndpoint.GET_TASK_SUMMARY.getEndpoint()).post(taskRequestBody).header("Authorization", "Bearer " + this.deviceToken).build();
                                    taskResponse = this.httpClient.newCall(taskRequest).execute();
                                    try {
                                        if (taskResponse.isSuccessful()) break block14;
                                        log.warn(TextManager.tlUI(Lang.DOWNLOADER_BITCOMET_UNABLE_FETCH_TASK_SUMMARY, new Object[0]));
                                        bCTaskTorrentResponse2 = null;
                                        if (taskResponse == null) break block15;
                                    }
                                    catch (Throwable t$) {
                                        try {
                                            if (taskResponse != null) {
                                                try {
                                                    taskResponse.close();
                                                }
                                                catch (Throwable x2) {
                                                    t$.addSuppressed(x2);
                                                }
                                            }
                                            throw t$;
                                        }
                                        catch (IOException | InterruptedException e) {
                                            log.warn(TextManager.tlUI(Lang.DOWNLOADER_BITCOMET_UNABLE_FETCH_TASK_SUMMARY, new Object[0]), (Throwable)e);
                                            if (e instanceof InterruptedException) {
                                                Thread.currentThread().interrupt();
                                            }
                                            BCTaskTorrentResponse bCTaskTorrentResponse3 = null;
                                            return bCTaskTorrentResponse3;
                                        }
                                    }
                                    taskResponse.close();
                                }
                                return bCTaskTorrentResponse2;
                            }
                            bCTaskTorrentResponse = (BCTaskTorrentResponse)JsonUtil.standard().fromJson(taskResponse.body().string(), BCTaskTorrentResponse.class);
                            if (taskResponse == null) break block16;
                            taskResponse.close();
                        }
                        return bCTaskTorrentResponse;
                    }
                    finally {
                        semaphore.release();
                    }
                }, this.parallelService)).toList()).join();
                list = torrentResponses.stream().filter(Objects::nonNull).map(torrent -> new TorrentImpl(Long.toString(torrent.getTask().getTaskId()), torrent.getTask().getTaskName(), torrent.getTaskDetail().getInfohash() != null ? torrent.getTaskDetail().getInfohash() : torrent.getTaskDetail().getInfohashV2(), torrent.getTaskDetail().getTotalSize(), torrent.getTask().getSelectedDownloadedSize(), (double)torrent.getTaskStatus().getDownloadPermillage() / 1000.0, torrent.getTask().getUploadRate(), torrent.getTask().getDownloadRate(), torrent.getTaskDetail().getTorrentPrivate())).filter(torrent -> includePrivate || !torrent.isPrivate()).collect(Collectors.toList());
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            response.close();
        }
        return list;
    }

    @Override
    @NotNull
    public List<Tracker> getTrackers(@NotNull Torrent torrent) {
        List<Tracker> list;
        block9: {
            HashMap<String, String> requirements = new HashMap<String, String>();
            requirements.put("task_id", torrent.getId());
            requirements.put("max_count", String.valueOf(Integer.MAX_VALUE));
            RequestBody requestBody = RequestBody.create((String)JsonUtil.standard().toJson(requirements), (MediaType)MediaType.get((String)"application/json"));
            Request request = new Request.Builder().url(this.apiEndpoint + BCEndpoint.GET_TASK_TRACKERS.getEndpoint()).post(requestBody).header("Authorization", "Bearer " + this.deviceToken).build();
            Response response = this.httpClient.newCall(request).execute();
            try {
                if (!response.isSuccessful()) {
                    throw new IllegalStateException(TextManager.tlUI(Lang.DOWNLOADER_BC_FAILED_REQUEST_PEERS_LIST_IN_TORRENT, response.code(), response.body().string()));
                }
                BCTaskTrackersResponse trackers = (BCTaskTrackersResponse)JsonUtil.standard().fromJson(response.body().string(), BCTaskTrackersResponse.class);
                list = trackers.getTrackers().stream().filter(t -> t.getName().startsWith("http") || t.getName().startsWith("udp") || t.getName().startsWith("ws")).map(t -> new TrackerImpl(t.getName())).toList();
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            response.close();
        }
        return list;
    }

    @Override
    public void setTrackers(@NotNull Torrent torrent, @NotNull List<Tracker> trackers) {
    }

    @Override
    @NotNull
    public DownloaderStatistics getStatistics() {
        long totalUploaded = 0L;
        long totalDownloaded = 0L;
        HashMap<String, List<String>> body = new HashMap<String, List<String>>();
        body.put("token_list", List.of("${G_TOTAL_DOWNLOAD_AUTO}", "${G_TOTAL_UPLOAD_AUTO}", "${G_SESSION_DOWNLOAD_AUTO}", "${G_SESSION_UPLOAD_AUTO}", "${G_TOTAL_DOWNLOAD_BYTE}", "${G_TOTAL_UPLOAD_BYTE}", "${G_SESSION_DOWNLOAD_BYTE}", "${G_SESSION_UPLOAD_BYTE}"));
        RequestBody requestBody = RequestBody.create((String)JsonUtil.standard().toJson(body), (MediaType)MediaType.get((String)"application/json"));
        Request request = new Request.Builder().url(this.apiEndpoint + BCEndpoint.GET_STATISTICS_LIST.getEndpoint()).post(requestBody).header("Authorization", "Bearer " + this.deviceToken).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            String respBody = response.body().string();
            if (!response.isSuccessful()) {
                throw new IllegalStateException(TextManager.tlUI(Lang.DOWNLOADER_BC_FAILED_REQUEST_STATISTICS_LIST, response.code(), respBody));
            }
            BCStatisticsValueListResponse valueList = (BCStatisticsValueListResponse)JsonUtil.standard().fromJson(respBody, BCStatisticsValueListResponse.class);
            for (BCStatisticsValueListResponse.ValueListDTO valueListDTO : valueList.getValueList()) {
                if (this.serverVersion.isGreaterThanOrEqualTo("2.20")) {
                    switch (valueListDTO.getToken()) {
                        case "${G_TOTAL_DOWNLOAD_BYTE}": {
                            totalDownloaded = Long.parseLong(valueListDTO.getValue());
                            break;
                        }
                        case "${G_TOTAL_UPLOAD_BYTE}": {
                            totalUploaded = Long.parseLong(valueListDTO.getValue());
                        }
                    }
                    continue;
                }
                switch (valueListDTO.getToken()) {
                    case "${G_TOTAL_DOWNLOAD_AUTO}": {
                        totalDownloaded = this.readHumanReadableValue(valueListDTO.getValue());
                        break;
                    }
                    case "${G_TOTAL_UPLOAD_AUTO}": {
                        totalUploaded = this.readHumanReadableValue(valueListDTO.getValue());
                    }
                }
            }
        }
        catch (Exception e) {
            log.warn("Failed to fetch BitComet statistics", (Throwable)e);
            throw new IllegalStateException(TextManager.tlUI(Lang.DOWNLOADER_BC_FAILED_REQUEST_STATISTICS_LIST, "N/A", "N/A", e));
        }
        return new DownloaderStatistics(totalUploaded, totalDownloaded);
    }

    private long readHumanReadableValue(String value) {
        String unit;
        double number;
        String[] parts = value.split(" ");
        if (parts.length != 2) {
            return 0L;
        }
        try {
            number = Double.parseDouble(parts[0]);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
        return switch (unit = parts[1].toUpperCase()) {
            case "B" -> (long)number;
            case "KB" -> (long)(number * 1024.0);
            case "MB" -> (long)(number * 1024.0 * 1024.0);
            case "GB" -> (long)(number * 1024.0 * 1024.0 * 1024.0);
            case "TB" -> (long)(number * 1024.0 * 1024.0 * 1024.0 * 1024.0);
            case "PB" -> (long)(number * 1024.0 * 1024.0 * 1024.0 * 1024.0 * 1024.0);
            case "EB" -> (long)(number * 1024.0 * 1024.0 * 1024.0 * 1024.0 * 1024.0 * 1024.0);
            case "ZB" -> (long)(number * 1024.0 * 1024.0 * 1024.0 * 1024.0 * 1024.0 * 1024.0 * 1024.0);
            default -> 0L;
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public List<Peer> getPeers(@NotNull Torrent torrent) {
        HashMap<String, Object> requirements = new HashMap<String, Object>();
        requirements.put("groups", List.of("peers_connected"));
        requirements.put("task_id", torrent.getId());
        requirements.put("max_count", String.valueOf(Integer.MAX_VALUE));
        RequestBody requestBody = RequestBody.create((String)JsonUtil.standard().toJson(requirements), (MediaType)MediaType.get((String)"application/json"));
        Request request = new Request.Builder().url(this.apiEndpoint + BCEndpoint.GET_TASK_PEERS.getEndpoint()).post(requestBody).header("Authorization", "Bearer " + this.deviceToken).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IllegalStateException(TextManager.tlUI(Lang.DOWNLOADER_BC_FAILED_REQUEST_PEERS_LIST_IN_TORRENT, response.code(), response.body().string()));
            }
            BCTaskPeersResponse peers = (BCTaskPeersResponse)JsonUtil.standard().fromJson(response.body().string(), BCTaskPeersResponse.class);
            if (peers.getPeers() == null) {
                List<Peer> list2 = Collections.emptyList();
                return list2;
            }
            boolean noGroupField = peers.getPeers().stream().noneMatch(dto -> dto.getGroup() != null);
            Stream<Object> stream = peers.getPeers().stream();
            if (!noGroupField) {
                stream = stream.filter(dto -> dto.getGroup().equals("connected") || dto.getGroup().equals("connected_peers") || dto.getGroup().equals("peers_connected"));
            }
            List<Peer> list = stream.map(peer -> new PeerImpl(this.natTranslate(BitComet.parseAddress(peer.getIp(), peer.getRemotePort(), peer.getListenPort())), ByteUtil.hexToByteArray(peer.getPeerId()), peer.getClientType(), peer.getDlRate(), peer.getDlSize() != null ? peer.getDlSize() : -1L, peer.getUpRate(), peer.getUpSize() != null ? peer.getUpSize() : -1L, (double)peer.getPermillage() / 1000.0, null, peer.getDlRate() <= 0L && peer.getUpRate() <= 0L)).collect(Collectors.toList());
            return list;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void setBanList(@NotNull Collection<IPAddress> fullList, @Nullable Collection<BanMetadata> added, @Nullable Collection<BanMetadata> removed, boolean applyFullList) {
        if (removed != null && !removed.isEmpty()) {
            this.unbanPeers(removed.stream().map(meta -> meta.getPeer().getAddress().toString()).toList());
        }
        this.setBanListFull(fullList);
    }

    private void setBanListFull(Collection<IPAddress> peerAddresses) {
        String banStr = peerAddresses.stream().map(ipAddr -> this.remapBanListAddress((IPAddress)ipAddr).toNormalizedString()).collect(Collectors.joining("\n"));
        this.operateBanListLegacy("replace", banStr);
    }

    private void unbanPeers(List<String> peerAddresses) {
        HashMap<String, Object> banListSettings = new HashMap<String, Object>();
        banListSettings.put("ip_list", peerAddresses);
        banListSettings.put("unban_range", "unban_peers_in_all_tasks");
        RequestBody requestBody = RequestBody.create((String)JsonUtil.standard().toJson(banListSettings), (MediaType)MediaType.get((String)"application/json"));
        Request request = new Request.Builder().url(this.apiEndpoint + BCEndpoint.TASK_UNBAN_PEERS.getEndpoint()).post(requestBody).header("Authorization", "Bearer " + this.deviceToken).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                log.error(TextManager.tlUI(Lang.DOWNLOADER_BC_FAILED_SAVE_BANLIST, this.getName(), this.apiEndpoint, response.code(), "HTTP ERROR (unban_peers)", response.body().string()));
                throw new IllegalStateException("Save BitComet banlist error: statusCode=" + response.code());
            }
        }
        catch (Exception e) {
            log.error(TextManager.tlUI(Lang.DOWNLOADER_BC_FAILED_SAVE_BANLIST, this.getName(), this.apiEndpoint, "N/A", e.getClass().getName(), e.getMessage()), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private void operateBanListLegacy(String mode, String content) {
        HashMap<String, String> banListSettings = new HashMap<String, String>();
        banListSettings.put("import_type", mode);
        banListSettings.put("data_type", "data_file");
        banListSettings.put("content_base64", Base64.getEncoder().encodeToString(content.getBytes(StandardCharsets.UTF_8)));
        RequestBody requestBody = RequestBody.create((String)JsonUtil.standard().toJson(banListSettings), (MediaType)MediaType.get((String)"application/json"));
        Request request = new Request.Builder().url(this.apiEndpoint + BCEndpoint.IP_FILTER_UPLOAD.getEndpoint()).post(requestBody).header("Authorization", "Bearer " + this.deviceToken).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                log.error(TextManager.tlUI(Lang.DOWNLOADER_BC_FAILED_SAVE_BANLIST, this.getName(), this.apiEndpoint, response.code(), "HTTP ERROR", response.body().string()));
                throw new IllegalStateException("Save BitComet banlist error: statusCode=" + response.code());
            }
        }
        catch (Exception e) {
            log.error(TextManager.tlUI(Lang.DOWNLOADER_BC_FAILED_SAVE_BANLIST, this.getName(), this.apiEndpoint, "N/A", e.getClass().getName(), e.getMessage()), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void close() {
        if (!this.parallelService.isShutdown()) {
            this.parallelService.shutdownNow();
        }
    }

    @Override
    public int getMaxConcurrentPeerRequestSlots() {
        return 4;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DownloaderSpeedLimiter getSpeedLimiter() {
        try {
            HashMap map = new HashMap();
            RequestBody requestBody = RequestBody.create((String)JsonUtil.standard().toJson(map), (MediaType)MediaType.get((String)"application/json"));
            Request request = new Request.Builder().url(this.apiEndpoint + BCEndpoint.GET_CONNECTION_CONFIG.getEndpoint()).post(requestBody).header("Authorization", "Bearer " + this.deviceToken).build();
            try (Response response = this.httpClient.newCall(request).execute();){
                if (!response.isSuccessful()) {
                    log.error(TextManager.tlUI(Lang.DOWNLOADER_FAILED_RETRIEVE_SPEED_LIMITER, this.getName(), response.code() + " " + response.body().string()));
                    DownloaderSpeedLimiter downloaderSpeedLimiter2 = null;
                    return downloaderSpeedLimiter2;
                }
                BCConnectionConfigResponse configResp = (BCConnectionConfigResponse)JsonUtil.standard().fromJson(response.body().string(), BCConnectionConfigResponse.class);
                if (!"ok".equalsIgnoreCase(configResp.getErrorCode())) {
                    log.error(TextManager.tlUI(Lang.DOWNLOADER_FAILED_RETRIEVE_SPEED_LIMITER, this.getName(), configResp.getErrorMessage()));
                }
                DownloaderSpeedLimiter downloaderSpeedLimiter = new DownloaderSpeedLimiter(configResp.getConnectionConfig().getMaxUploadSpeed().intValue(), configResp.getConnectionConfig().getMaxDownloadSpeed().intValue());
                return downloaderSpeedLimiter;
            }
        }
        catch (Exception e) {
            log.error(TextManager.tlUI(Lang.DOWNLOADER_FAILED_RETRIEVE_SPEED_LIMITER, this.getName(), e.getClass().getName() + ": " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    @Override
    public void setSpeedLimiter(@NotNull DownloaderSpeedLimiter speedLimiter) {
        try {
            HashMap map = new HashMap();
            HashMap<String, Long> connectionConfig = new HashMap<String, Long>();
            connectionConfig.put("max_download_speed", speedLimiter.isDownloadUnlimited() ? 0L : speedLimiter.download());
            connectionConfig.put("max_upload_speed", speedLimiter.isUploadUnlimited() ? 0L : speedLimiter.upload());
            map.put("connection_config", connectionConfig);
            RequestBody requestBody = RequestBody.create((String)JsonUtil.standard().toJson(map), (MediaType)MediaType.get((String)"application/json"));
            Request request = new Request.Builder().url(this.apiEndpoint + BCEndpoint.SET_CONNECTION_CONFIG.getEndpoint()).post(requestBody).header("Authorization", "Bearer " + this.deviceToken).build();
            try (Response response = this.httpClient.newCall(request).execute();){
                if (!response.isSuccessful()) {
                    log.error(TextManager.tlUI(Lang.DOWNLOADER_FAILED_SET_SPEED_LIMITER, this.getName(), response.code() + " " + response.body().string()));
                    return;
                }
                BCConfigSetResponse configResp = (BCConfigSetResponse)JsonUtil.standard().fromJson(response.body().string(), BCConfigSetResponse.class);
                if (!"ok".equalsIgnoreCase(configResp.getErrorCode())) {
                    log.error(TextManager.tlUI(Lang.DOWNLOADER_FAILED_SET_SPEED_LIMITER, this.getName(), configResp.getErrorMessage()));
                }
            }
        }
        catch (Exception e) {
            log.error(TextManager.tlUI(Lang.DOWNLOADER_FAILED_SET_SPEED_LIMITER, this.getName(), e.getClass().getName() + ": " + e.getMessage()), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getBTProtocolPort() {
        try {
            HashMap map = new HashMap();
            RequestBody requestBody = RequestBody.create((String)JsonUtil.standard().toJson(map), (MediaType)MediaType.get((String)"application/json"));
            Request request = new Request.Builder().url(this.apiEndpoint + BCEndpoint.GET_CONNECTION_CONFIG.getEndpoint()).post(requestBody).header("Authorization", "Bearer " + this.deviceToken).build();
            try (Response response = this.httpClient.newCall(request).execute();){
                if (!response.isSuccessful()) {
                    log.error(TextManager.tlUI(Lang.DOWNLOADER_FAILED_RETRIEVE_BT_PROTOCOL_PORT, this.getName(), response.code() + " " + response.body().string()));
                    int n2 = -1;
                    return n2;
                }
                BCConnectionConfigResponse configResp = (BCConnectionConfigResponse)JsonUtil.standard().fromJson(response.body().string(), BCConnectionConfigResponse.class);
                if (!"ok".equalsIgnoreCase(configResp.getErrorCode())) {
                    log.error(TextManager.tlUI(Lang.DOWNLOADER_FAILED_RETRIEVE_SPEED_LIMITER, this.getName(), configResp.getErrorMessage()));
                }
                int n = configResp.getConnectionConfig().getListenPortTcp();
                return n;
            }
        }
        catch (Exception e) {
            log.error(TextManager.tlUI(Lang.DOWNLOADER_FAILED_RETRIEVE_BT_PROTOCOL_PORT, this.getName(), e.getClass().getName() + ": " + e.getMessage()), (Throwable)e);
            return -1;
        }
    }

    @Override
    public void setBTProtocolPort(final int port) {
        HashMap<String, Object> settings = new HashMap<String, Object>(this){
            final /* synthetic */ BitComet this$0;
            {
                BitComet bitComet = this$0;
                Objects.requireNonNull(bitComet);
                this.this$0 = bitComet;
                this.put("connection_config", new HashMap<Object, Object>(this){
                    final /* synthetic */ 2 this$1;
                    {
                        2 v0 = this$1;
                        Objects.requireNonNull(v0);
                        this.this$1 = v0;
                        this.put("enable_listen_tcp", true);
                        this.put("listen_port_tcp", port);
                    }
                });
            }
        };
        RequestBody requestBody = RequestBody.create((String)JsonUtil.standard().toJson((Object)settings), (MediaType)MediaType.get((String)"application/json"));
        Request request = new Request.Builder().url(this.apiEndpoint + BCEndpoint.SET_CONNECTION_CONFIG.getEndpoint()).post(requestBody).header("Authorization", "Bearer " + this.deviceToken).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                log.error(TextManager.tlUI(Lang.DOWNLOADER_BC_CONFIG_IP_FILTER_FAILED, new Object[0]));
                return;
            }
            String json = response.body().string();
            BCConfigSetResponse configResp = (BCConfigSetResponse)JsonUtil.standard().fromJson(json, BCConfigSetResponse.class);
            if (!"ok".equalsIgnoreCase(configResp.getErrorCode())) {
                log.error(TextManager.tlUI(Lang.DOWNLOADER_FAILED_SAVE_BT_PROTOCOL_PORT, new Object[0]));
                throw new IllegalStateException("Failed to save BitComet BT Protocol Port: " + configResp.getErrorMessage());
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to save BitComet BT Protocol Port", e);
        }
    }

    public static class Config {
        private String name;
        private String type;
        private String endpoint;
        private String username;
        private String password;
        private boolean incrementBan;
        private boolean verifySsl;
        private boolean ignorePrivate;
        private boolean paused;

        public static Config readFromYaml(ConfigurationSection section, String alternativeName) {
            Config config = new Config();
            config.setType("bitcomet");
            config.setName(section.getString("name", alternativeName));
            config.setEndpoint(section.getString("endpoint"));
            if (config.getEndpoint().endsWith("/")) {
                config.setEndpoint(config.getEndpoint().substring(0, config.getEndpoint().length() - 1));
            }
            config.setUsername(section.getString("username", ""));
            config.setPassword(section.getString("password", ""));
            config.setIncrementBan(section.getBoolean("increment-ban", true));
            config.setVerifySsl(section.getBoolean("verify-ssl", true));
            config.setIgnorePrivate(section.getBoolean("ignore-private", false));
            config.setPaused(section.getBoolean("paused", false));
            return config;
        }

        public YamlConfiguration saveToYaml() {
            YamlConfiguration section = new YamlConfiguration();
            section.set("type", (Object)"bitcomet");
            section.set("name", (Object)this.name);
            section.set("endpoint", (Object)this.endpoint);
            section.set("username", (Object)this.username);
            section.set("password", (Object)this.password);
            section.set("increment-ban", (Object)this.incrementBan);
            section.set("verify-ssl", (Object)this.verifySsl);
            section.set("ignore-private", (Object)this.ignorePrivate);
            section.set("paused", (Object)this.paused);
            return section;
        }

        @Generated
        public Config() {
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getEndpoint() {
            return this.endpoint;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public String getPassword() {
            return this.password;
        }

        @Generated
        public boolean isIncrementBan() {
            return this.incrementBan;
        }

        @Generated
        public boolean isVerifySsl() {
            return this.verifySsl;
        }

        @Generated
        public boolean isIgnorePrivate() {
            return this.ignorePrivate;
        }

        @Generated
        public boolean isPaused() {
            return this.paused;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Generated
        public void setUsername(String username) {
            this.username = username;
        }

        @Generated
        public void setPassword(String password) {
            this.password = password;
        }

        @Generated
        public void setIncrementBan(boolean incrementBan) {
            this.incrementBan = incrementBan;
        }

        @Generated
        public void setVerifySsl(boolean verifySsl) {
            this.verifySsl = verifySsl;
        }

        @Generated
        public void setIgnorePrivate(boolean ignorePrivate) {
            this.ignorePrivate = ignorePrivate;
        }

        @Generated
        public void setPaused(boolean paused) {
            this.paused = paused;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isIncrementBan() != other.isIncrementBan()) {
                return false;
            }
            if (this.isVerifySsl() != other.isVerifySsl()) {
                return false;
            }
            if (this.isIgnorePrivate() != other.isIgnorePrivate()) {
                return false;
            }
            if (this.isPaused() != other.isPaused()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$endpoint = this.getEndpoint();
            String other$endpoint = other.getEndpoint();
            if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            return !(this$password == null ? other$password != null : !this$password.equals(other$password));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isIncrementBan() ? 79 : 97);
            result = result * 59 + (this.isVerifySsl() ? 79 : 97);
            result = result * 59 + (this.isIgnorePrivate() ? 79 : 97);
            result = result * 59 + (this.isPaused() ? 79 : 97);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $endpoint = this.getEndpoint();
            result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BitComet.Config(name=" + this.getName() + ", type=" + this.getType() + ", endpoint=" + this.getEndpoint() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", incrementBan=" + this.isIncrementBan() + ", verifySsl=" + this.isVerifySsl() + ", ignorePrivate=" + this.isIgnorePrivate() + ", paused=" + this.isPaused() + ")";
        }
    }
}

