/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.gui.impl.swing;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.extras.FlatSVGIcon;
import com.ghostchu.peerbanhelper.ExternalSwitch;
import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.PeerBanHelper;
import com.ghostchu.peerbanhelper.event.gui.PBHGuiElementPeriodUpdateEvent;
import com.ghostchu.peerbanhelper.event.gui.PBHLookAndFeelNeedReloadEvent;
import com.ghostchu.peerbanhelper.exchange.ExchangeMap;
import com.ghostchu.peerbanhelper.gui.ProgressDialog;
import com.ghostchu.peerbanhelper.gui.TaskbarControl;
import com.ghostchu.peerbanhelper.gui.TaskbarState;
import com.ghostchu.peerbanhelper.gui.impl.GuiImpl;
import com.ghostchu.peerbanhelper.gui.impl.console.ConsoleGuiImpl;
import com.ghostchu.peerbanhelper.gui.impl.swing.SwingTaskbarControl;
import com.ghostchu.peerbanhelper.gui.impl.swing.SwingTray;
import com.ghostchu.peerbanhelper.gui.impl.swing.mainwindow.SwingMainWindow;
import com.ghostchu.peerbanhelper.gui.impl.swing.mainwindow.component.LogsTab;
import com.ghostchu.peerbanhelper.gui.impl.swing.theme.PBHFlatLafTheme;
import com.ghostchu.peerbanhelper.gui.impl.swing.theme.impl.MacOSLafTheme;
import com.ghostchu.peerbanhelper.gui.impl.swing.theme.impl.PBHPlusTheme;
import com.ghostchu.peerbanhelper.gui.impl.swing.theme.impl.StandardLafTheme;
import com.ghostchu.peerbanhelper.gui.impl.swing.theme.impl.UnsupportedPlatformTheme;
import com.ghostchu.peerbanhelper.gui.impl.swing.toolwindow.SwingProgressDialog;
import com.ghostchu.peerbanhelper.util.CommonUtil;
import com.ghostchu.peerbanhelper.util.logger.JListAppender;
import com.ghostchu.peerbanhelper.util.logger.LogEntry;
import com.jthemedetecor.OsThemeDetector;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Taskbar;
import java.awt.TrayIcon;
import java.net.URI;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public final class SwingGuiImpl
extends ConsoleGuiImpl
implements GuiImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SwingGuiImpl.class);
    private final boolean silentStart;
    private SwingMainWindow mainWindow;
    private PBHFlatLafTheme pbhFlatLafTheme = new StandardLafTheme();
    private SwingTaskbarControl swingTaskbarControl;
    private final Icon icon = new FlatSVGIcon(Main.class.getResource("/assets/icon/common/alert.svg"));

    public SwingGuiImpl(String[] args) {
        super(args);
        this.silentStart = Arrays.stream(args).anyMatch(s -> s.equalsIgnoreCase("silent"));
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("apple.awt.application.name", "PeerBanHelper");
        System.setProperty("apple.awt.application.appearance", "system");
        if (System.getProperty("os.name").contains("Linux")) {
            JFrame.setDefaultLookAndFeelDecorated(true);
            JDialog.setDefaultLookAndFeelDecorated(true);
        }
    }

    @Override
    public boolean isGuiAvailable() {
        return Desktop.isDesktopSupported();
    }

    private void setUIFont(String fontName) {
        Enumeration keys = UIManager.getLookAndFeelDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (!(value instanceof FontUIResource)) continue;
            FontUIResource fontUIResource = (FontUIResource)value;
            UIManager.put(key, this.getFont(fontName, -1, -1, fontUIResource));
        }
    }

    private void updateGuiStuff() {
        if (Main.getServer().getDownloaderServer().isGlobalPaused()) {
            this.taskbarControl().updateProgress(this.mainWindow, TaskbarState.PAUSED, 1.0f);
        } else {
            this.taskbarControl().updateProgress(this.mainWindow, TaskbarState.OFF, -1.0f);
        }
        Main.getEventBus().post((Object)new PBHGuiElementPeriodUpdateEvent());
    }

    @Override
    public String getName() {
        return "SWING";
    }

    @Override
    public boolean supportInteractive() {
        return true;
    }

    @Override
    public void createYesNoDialog(Level level, String title, String description, @Nullable Runnable yesEvent, @Nullable Runnable noEvent) {
        int msgType = -1;
        if (level == Level.INFO) {
            msgType = 1;
        }
        if (level == Level.WARN) {
            msgType = 2;
        }
        if (level == Level.ERROR) {
            msgType = 0;
        }
        if (Taskbar.isTaskbarSupported() && Taskbar.getTaskbar().isSupported(Taskbar.Feature.USER_ATTENTION_WINDOW)) {
            Taskbar.getTaskbar().requestWindowUserAttention(this.mainWindow);
        }
        int finalMsgType = msgType;
        SwingUtilities.invokeLater(() -> {
            int result = JOptionPane.showOptionDialog(null, description, title, 0, finalMsgType, null, null, 1);
            if (result == 0) {
                if (yesEvent != null) {
                    yesEvent.run();
                }
            } else if (result == 1 && noEvent != null) {
                noEvent.run();
            }
        });
    }

    @Override
    public void openUrlInBrowser(String url) {
        this.openWebpage(URI.create(url));
    }

    @Override
    public void setup() {
        super.setup();
        this.setupSwingDefaultFonts();
        Main.getEventBus().register((Object)this);
        try {
            OsThemeDetector detector = OsThemeDetector.getDetector();
            detector.registerListener(this::updateTheme);
            this.updateTheme(detector.isDark());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.createMainWindow();
    }

    @Override
    public boolean isDarkMode() {
        return OsThemeDetector.getDetector().isDark();
    }

    private void setupSwingDefaultFonts() {
    }

    @Override
    public void onPBHFullyStarted(PeerBanHelper server) {
        CommonUtil.getScheduler().scheduleWithFixedDelay(this::updateGuiStuff, 0L, 1L, TimeUnit.SECONDS);
    }

    private void updateTheme(Boolean isDark) {
        this.pbhFlatLafTheme = new StandardLafTheme();
        if (ExternalSwitch.parseBoolean("pbh.gui.macos-theme", true) && System.getProperty("os.name").contains("Mac")) {
            this.pbhFlatLafTheme = new MacOSLafTheme();
        }
        if (ExternalSwitch.parseBoolean("pbh.gui.pbhplus-theme", false) && ExchangeMap.PBH_PLUS_ACTIVATED) {
            this.pbhFlatLafTheme = new PBHPlusTheme();
        }
        if (ExchangeMap.UNSUPPORTED_PLATFORM && ExternalSwitch.parseBoolean("pbh.gui.useIncompatiblePlatformTheme", false)) {
            this.pbhFlatLafTheme = new UnsupportedPlatformTheme();
        }
        if (ExternalSwitch.parse("pbh.gui.theme-light") != null && ExternalSwitch.parse("pbh.gui.theme-dark") != null) {
            this.pbhFlatLafTheme = new PBHFlatLafTheme(this){
                {
                    Objects.requireNonNull(this$0);
                }

                @Override
                public void applyDark() {
                    try {
                        UIManager.setLookAndFeel(ExternalSwitch.parse("pbh.gui.theme-dark"));
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                        log.error("Failed to apply user customized dark theme", (Throwable)e);
                    }
                }

                @Override
                public void applyLight() {
                    try {
                        UIManager.setLookAndFeel(ExternalSwitch.parse("pbh.gui.theme-light"));
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                        log.error("Failed to apply user customized light theme", (Throwable)e);
                    }
                }
            };
        }
        if (isDark.booleanValue()) {
            this.pbhFlatLafTheme.applyDark();
        } else {
            this.pbhFlatLafTheme.applyLight();
        }
        Main.getEventBus().post((Object)new PBHLookAndFeelNeedReloadEvent(isDark));
        FlatLaf.updateUILater();
    }

    private Font getFont(String fontName, int style, int size, Font currentFont) {
        Font testFont;
        if (currentFont == null) {
            return null;
        }
        String resultName = fontName == null ? currentFont.getName() : ((testFont = new Font(fontName, 0, 10)).canDisplay('a') && testFont.canDisplay('1') ? fontName : currentFont.getName());
        Font font = new Font(resultName, style >= 0 ? style : currentFont.getStyle(), size >= 0 ? size : currentFont.getSize());
        boolean isMac = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font fontWithFallback = isMac ? new Font(font.getFamily(), font.getStyle(), font.getSize()) : new StyleContext().getFont(font.getFamily(), font.getStyle(), font.getSize());
        return fontWithFallback instanceof FontUIResource ? fontWithFallback : new FontUIResource(fontWithFallback);
    }

    @Override
    public void createMainWindow() {
        this.mainWindow = new SwingMainWindow(this);
        this.swingTaskbarControl = new SwingTaskbarControl(this.mainWindow);
        this.initLoggerRedirection();
    }

    @Override
    public ProgressDialog createProgressDialog(String title, String description, String buttonText, Runnable buttonEvent, boolean allowCancel) {
        return new SwingProgressDialog(title, description, buttonText, buttonEvent, allowCancel);
    }

    @Override
    public TaskbarControl taskbarControl() {
        if (this.swingTaskbarControl != null) {
            return this.swingTaskbarControl;
        }
        return super.taskbarControl();
    }

    public boolean openWebpage(URI uri) {
        Desktop desktop = Desktop.getDesktop();
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(uri);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private void initLoggerRedirection() {
        JScrollPane scrollPane = this.mainWindow.getTab(LogsTab.class).getLoggerScrollPane();
        JList<LogEntry> logList = this.mainWindow.getTab(LogsTab.class).getLoggerTextList();
        BoundedRangeModel scrollModel = scrollPane.getVerticalScrollBar().getModel();
        AtomicBoolean autoScroll = new AtomicBoolean(true);
        scrollModel.addChangeListener(e -> {
            int max = scrollModel.getMaximum();
            int extent = scrollModel.getExtent();
            int current = scrollModel.getValue();
            autoScroll.set(current + extent == max);
        });
        int maxSize = ExternalSwitch.parseInt("pbh.gui.logs.maxSize", 300);
        JListAppender.allowWriteLogEntryDeque.set(true);
        CommonUtil.getScheduler().scheduleWithFixedDelay(() -> SwingUtilities.invokeLater(() -> {
            DefaultListModel model = (DefaultListModel)logList.getModel();
            while (!JListAppender.logEntryDeque.isEmpty()) {
                LogEntry logEntry = (LogEntry)JListAppender.logEntryDeque.poll();
                if (logEntry == null) {
                    return;
                }
                model.addElement(logEntry);
            }
            while (model.size() > maxSize) {
                model.removeElementAt(0);
            }
            if (autoScroll.get()) {
                logList.ensureIndexIsVisible(model.getSize() - 1);
            }
        }), 0L, 10L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void sync() {
        super.sync();
    }

    public void setColorTheme(Class<?> clazz) {
        if (clazz.getName().equals(UIManager.getLookAndFeel().getClass().getName())) {
            return;
        }
        try {
            UIManager.setLookAndFeel(clazz.getName());
        }
        catch (Exception ex) {
            log.info("Failed to setup UI theme", (Throwable)ex);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void createDialog(Level level, String title, String description, Runnable clickEvent) {
        int msgType = -1;
        if (level == Level.INFO) {
            msgType = 1;
        }
        if (level == Level.WARN) {
            msgType = 2;
        }
        if (level == Level.ERROR) {
            msgType = 0;
        }
        if (Taskbar.isTaskbarSupported() && Taskbar.getTaskbar().isSupported(Taskbar.Feature.USER_ATTENTION_WINDOW)) {
            Taskbar.getTaskbar().requestWindowUserAttention(this.mainWindow);
        }
        int finalMsgType = msgType;
        SwingUtilities.invokeLater(() -> {
            JOptionPane.showMessageDialog(null, description, title, finalMsgType);
            clickEvent.run();
        });
    }

    @Override
    public void createNotification(Level level, String title, String description) {
        SwingTray swingTray = this.mainWindow.getTrayMenu().getSwingTrayDialog();
        if (swingTray != null) {
            TrayIcon icon = swingTray.getTrayIcon();
            if (swingTray.getTrayIcon() != null) {
                if (level.equals((Object)Level.WARN)) {
                    icon.displayMessage(title, description, TrayIcon.MessageType.WARNING);
                } else if (level.equals((Object)Level.ERROR)) {
                    icon.displayMessage(title, description, TrayIcon.MessageType.ERROR);
                } else {
                    icon.displayMessage(title, description, TrayIcon.MessageType.INFO);
                }
                return;
            }
        }
        super.createNotification(level, title, description);
    }

    @Generated
    public SwingMainWindow getMainWindow() {
        return this.mainWindow;
    }

    @Generated
    public Icon getIcon() {
        return this.icon;
    }

    @Generated
    public boolean isSilentStart() {
        return this.silentStart;
    }

    @Generated
    public PBHFlatLafTheme getPbhFlatLafTheme() {
        return this.pbhFlatLafTheme;
    }

    @Generated
    public SwingTaskbarControl getSwingTaskbarControl() {
        return this.swingTaskbarControl;
    }
}

