/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.gui.impl.swing.mainwindow.component;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.event.program.PBHServerStartedEvent;
import com.ghostchu.peerbanhelper.exchange.ExchangeMap;
import com.ghostchu.peerbanhelper.gui.impl.swing.mainwindow.SwingMainWindow;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.util.CommonUtil;
import com.google.common.eventbus.Subscribe;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;

public class WindowTitle {
    private final SwingMainWindow parent;

    public WindowTitle(SwingMainWindow parent) {
        this.parent = parent;
        parent.setTitle(TextManager.tlUI(Lang.GUI_TITLE_LOADING, Main.getMeta().getVersion(), Main.getMeta().getAbbrev()));
        Main.getEventBus().register((Object)this);
    }

    @Subscribe
    public void onPBHFullyStarted(PBHServerStartedEvent event) {
        CommonUtil.getScheduler().scheduleAtFixedRate(() -> {
            StringBuilder builder = new StringBuilder();
            builder.append(TextManager.tlUI(Lang.GUI_TITLE_LOADED, "Swing UI\u00b2", Main.getMeta().getVersion(), Main.getMeta().getAbbrev()));
            StringJoiner joiner = new StringJoiner("", " [", "]");
            joiner.setEmptyValue("");
            ExchangeMap.GUI_DISPLAY_FLAGS.forEach(flag -> joiner.add(flag.getContent()));
            String newTitle = builder.append(joiner).toString();
            if (this.parent.getTitle().equals(newTitle)) {
                return;
            }
            SwingUtilities.invokeLater(() -> this.parent.setTitle(newTitle));
        }, 0L, 3L, TimeUnit.SECONDS);
    }
}

