/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.gui.impl.swing.toolwindow;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.gui.ProgressDialog;
import com.ghostchu.peerbanhelper.gui.TaskbarState;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public final class SwingProgressDialog
implements ProgressDialog {
    private final JProgressBar progressBar = new JProgressBar();
    private final JFrame frame = new JFrame("Unknown Title");
    private final JLabel descriptionLabel = new JLabel("Unknown Description");
    private final JLabel commentLabel = new JLabel("");
    private final JButton stopButton;
    private float progress;

    public SwingProgressDialog(String title, String description, String buttonText, Runnable buttonEvent, boolean allowCancel) {
        this.setTitle(title);
        this.frame.setDefaultCloseOperation(0);
        this.frame.setSize(400, 200);
        this.frame.setLayout(new BorderLayout(10, 10));
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new FlowLayout(0));
        JLabel iconLabel = new JLabel(UIManager.getIcon("OptionPane.informationIcon"));
        topPanel.add(iconLabel);
        this.setDescription("<html>" + description + "</html>");
        this.descriptionLabel.setLayout(new FlowLayout(0));
        this.descriptionLabel.setVerticalAlignment(1);
        this.descriptionLabel.setPreferredSize(new Dimension(350, 80));
        topPanel.add(this.descriptionLabel);
        this.setProgressDisplayIndeterminate(true);
        Main.getGuiManager().taskbarControl().updateProgress(this.frame, TaskbarState.INDETERMINATE, 0.0f);
        this.stopButton = new JButton(buttonText);
        if (!allowCancel) {
            this.stopButton.setEnabled(false);
        }
        this.stopButton.addActionListener(e -> {
            if (buttonEvent != null) {
                buttonEvent.run();
            }
        });
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        bottomPanel.add((Component)this.commentLabel, "North");
        bottomPanel.add((Component)this.progressBar, "Center");
        bottomPanel.add((Component)this.stopButton, "East");
        this.frame.add((Component)topPanel, "North");
        this.frame.add((Component)bottomPanel, "South");
        this.frame.pack();
        this.frame.setVisible(false);
    }

    @Override
    public void updateProgress(float progress) {
        this.progress = progress;
        SwingUtilities.invokeLater(() -> {
            this.progressBar.setValue((int)(progress * 100.0f));
            Main.getGuiManager().taskbarControl().updateProgress(this.frame, TaskbarState.NORMAL, progress);
        });
    }

    @Override
    public void show() {
        SwingUtilities.invokeLater(() -> this.frame.setVisible(true));
    }

    @Override
    public void close() {
        SwingUtilities.invokeLater(() -> this.frame.setVisible(false));
        Main.getGuiManager().taskbarControl().updateProgress(this.frame, TaskbarState.OFF, -1.0f);
    }

    @Override
    public void setTitle(String title) {
        SwingUtilities.invokeLater(() -> this.frame.setTitle(title));
    }

    @Override
    public void setDescription(String description) {
        SwingUtilities.invokeLater(() -> this.descriptionLabel.setText(description));
    }

    @Override
    public void setButtonText(String buttonText) {
        SwingUtilities.invokeLater(() -> this.stopButton.setText(buttonText));
    }

    @Override
    public void setButtonEvent(Runnable buttonEvent) {
        SwingUtilities.invokeLater(() -> {
            this.stopButton.removeActionListener(this.stopButton.getActionListeners()[0]);
            this.stopButton.addActionListener(e -> {
                if (buttonEvent != null) {
                    buttonEvent.run();
                }
            });
        });
    }

    @Override
    public void setAllowCancel(boolean allowCancel) {
        SwingUtilities.invokeLater(() -> this.stopButton.setEnabled(allowCancel));
    }

    @Override
    public void setProgressDisplayIndeterminate(boolean indeterminate) {
        SwingUtilities.invokeLater(() -> {
            this.progressBar.setIndeterminate(indeterminate);
            this.progressBar.setStringPainted(!indeterminate);
            Main.getGuiManager().taskbarControl().updateProgress(this.frame, indeterminate ? TaskbarState.INDETERMINATE : TaskbarState.NORMAL, this.progress * 100.0f);
        });
    }

    @Override
    public void setComment(String comment) {
        SwingUtilities.invokeLater(() -> this.commentLabel.setText(comment));
    }
}

