/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.background;

import com.ghostchu.peerbanhelper.database.dao.impl.TorrentDao;
import com.ghostchu.peerbanhelper.module.AbstractFeatureModule;
import com.ghostchu.simplereloadlib.ReloadResult;
import com.ghostchu.simplereloadlib.Reloadable;
import java.sql.SQLException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public final class SQLiteOptimizerModule
extends AbstractFeatureModule
implements Reloadable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SQLiteOptimizerModule.class);
    private final TorrentDao torrentDao;
    private ScheduledExecutorService pool;

    public SQLiteOptimizerModule(TorrentDao torrentDao) {
        this.torrentDao = torrentDao;
    }

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    @NotNull
    public String getName() {
        return "Background SQLite Database Optimizer";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "background-sqlite-database-optimizer";
    }

    @Override
    public void onEnable() {
        this.pool = Executors.newScheduledThreadPool(1, Thread.ofVirtual().factory());
        this.pool.scheduleWithFixedDelay(this::runOptimizeTask, 1L, 1L, TimeUnit.HOURS);
    }

    private void runOptimizeTask() {
        try {
            this.torrentDao.executeRaw("PRAGMA optimize;", new String[0]);
        }
        catch (SQLException e) {
            log.warn("Failed to perform period SQLite database optimization", (Throwable)e);
        }
    }

    public ReloadResult reloadModule() throws Exception {
        return super.reloadModule();
    }

    @Override
    public void onDisable() {
        if (this.pool != null) {
            this.pool.shutdownNow();
        }
    }
}

