/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.rule;

import com.ghostchu.peerbanhelper.ExternalSwitch;
import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.bittorrent.peer.Peer;
import com.ghostchu.peerbanhelper.bittorrent.peer.PeerFlag;
import com.ghostchu.peerbanhelper.bittorrent.torrent.Torrent;
import com.ghostchu.peerbanhelper.downloader.Downloader;
import com.ghostchu.peerbanhelper.module.AbstractRuleFeatureModule;
import com.ghostchu.peerbanhelper.module.BatchMonitorFeatureModule;
import com.ghostchu.peerbanhelper.module.CheckResult;
import com.ghostchu.peerbanhelper.module.PeerAction;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.wrapper.StructuredData;
import com.ghostchu.simplereloadlib.ReloadResult;
import com.ghostchu.simplereloadlib.Reloadable;
import com.google.common.net.HostAndPort;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public final class IdleConnectionDosProtection
extends AbstractRuleFeatureModule
implements Reloadable,
BatchMonitorFeatureModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IdleConnectionDosProtection.class);
    private final Map<HostAndPort, ConnectionInfo> idleConnections = new ConcurrentHashMap<HostAndPort, ConnectionInfo>();
    private long banDuration;
    private long maxAllowedIdleTime;
    private long idleSpeedThreshold;
    private boolean resetOnStatusChange;
    private double minStatusChangePercentage;
    private ProtectionMode protectionMode;

    @Override
    @NotNull
    public String getName() {
        return "Idle Connection DoS Protection";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "idle-connection-dos-protection";
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public void onEnable() {
        this.reloadConfig();
        Main.getReloadManager().register((Reloadable)this);
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }

    @Override
    public void onDisable() {
        Main.getReloadManager().unregister((Reloadable)this);
    }

    public ReloadResult reloadModule() throws Exception {
        this.reloadConfig();
        return super.reloadModule();
    }

    public void reloadConfig() {
        this.banDuration = this.getConfig().getLong("ban-duration", 0L);
        this.maxAllowedIdleTime = this.getConfig().getLong("max-allowed-idle-time");
        this.idleSpeedThreshold = this.getConfig().getLong("idle-speed-threshold");
        this.minStatusChangePercentage = this.getConfig().getDouble("min-status-change-percentage");
        this.resetOnStatusChange = this.getConfig().getBoolean("reset-on-status-change");
        this.protectionMode = ProtectionMode.fromCode(this.getConfig().getInt("protect-mode", 0));
    }

    @Override
    @NotNull
    public CheckResult shouldBanPeer(@NotNull Torrent torrent, @NotNull Peer peer, @NotNull Downloader downloader) {
        if (this.protectionMode == ProtectionMode.ALWAYS_SEEDING && !torrent.isSeeding()) {
            return this.pass();
        }
        PeerFlag flags = peer.getFlags();
        if (this.protectionMode == ProtectionMode.DETERMINED_BY_PEER_FLAGS && !torrent.isSeeding()) {
            if (flags == null) {
                return this.pass();
            }
            if ((flags.isInteresting() || flags.isRemoteInterested()) && ExternalSwitch.parseBoolean("pbh.module.idle-connection-dos-protection.ignore-if-any-interested", true)) {
                return this.pass();
            }
        }
        HostAndPort hostAndPort = HostAndPort.fromParts((String)peer.getPeerAddress().getIp(), (int)peer.getPeerAddress().getPort());
        if (peer.getUploadSpeed() > this.idleSpeedThreshold || peer.getDownloadSpeed() > this.idleSpeedThreshold) {
            this.idleConnections.remove(hostAndPort);
            return this.pass();
        }
        ConnectionInfo info = this.idleConnections.getOrDefault(hostAndPort, new ConnectionInfo(System.currentTimeMillis(), peer.getProgress(), peer.getUploaded(), peer.getDownloaded(), 0));
        long computedAvgUploadSpeed = (peer.getUploaded() - info.getUploaded()) / (System.currentTimeMillis() - info.getIdleStartTime() + 1L);
        long computedAvgDownloadSpeed = (peer.getDownloaded() - info.getDownloaded()) / (System.currentTimeMillis() - info.getIdleStartTime() + 1L);
        double percentageChange = Math.abs(peer.getProgress() * 100.0 - info.getPercentage());
        if (computedAvgUploadSpeed > this.idleSpeedThreshold || computedAvgDownloadSpeed > this.idleSpeedThreshold) {
            this.idleConnections.remove(hostAndPort);
            return this.pass();
        }
        if (this.resetOnStatusChange && percentageChange >= this.minStatusChangePercentage) {
            this.idleConnections.remove(hostAndPort);
            return this.pass();
        }
        long alreadyIdled = System.currentTimeMillis() - info.getIdleStartTime();
        if (alreadyIdled > this.maxAllowedIdleTime) {
            this.idleConnections.remove(hostAndPort);
            return new CheckResult(this.getClass(), PeerAction.BAN, this.banDuration, new TranslationComponent(Lang.MODULE_ICDP_RULE_TITLE), new TranslationComponent(Lang.MODULE_ICDP_RULE_DESCRIPTION, hostAndPort.toString()), new StructuredData<String, String>().add("ip", peer.getPeerAddress().toString()).add("idle_type", "timeout").add("idle_start", (String)((Object)Long.valueOf(info.getIdleStartTime()))).add("last_percentage", (String)((Object)Double.valueOf(info.getPercentage()))).add("last_uploaded", (String)((Object)Long.valueOf(info.getUploaded()))).add("last_downloaded", (String)((Object)Long.valueOf(info.getDownloaded()))).add("percentage", (String)((Object)Double.valueOf(peer.getProgress()))).add("uploaded", (String)((Object)Long.valueOf(peer.getUploaded()))).add("downloaded", (String)((Object)Long.valueOf(peer.getDownloaded()))).add("upload_speed", (String)((Object)Long.valueOf(peer.getUploadSpeed()))).add("download_speed", (String)((Object)Long.valueOf(peer.getDownloadSpeed()))));
        }
        this.idleConnections.put(hostAndPort, info);
        return this.pass();
    }

    @Override
    public void onPeersRetrieved(@NotNull Map<Downloader, Map<Torrent, List<Peer>>> peers) {
        List<HostAndPort> allPeers = peers.values().stream().flatMap(map -> map.values().stream()).flatMap(Collection::stream).map(peer -> HostAndPort.fromParts((String)peer.getPeerAddress().getIp(), (int)peer.getPeerAddress().getPort())).toList();
        int count = this.idleConnections.size();
        this.idleConnections.entrySet().removeIf(entry -> {
            HostAndPort hostAndPort = (HostAndPort)entry.getKey();
            if (!allPeers.contains(hostAndPort)) {
                ((ConnectionInfo)entry.getValue()).setNotHitCounter(((ConnectionInfo)entry.getValue()).getNotHitCounter() + 1);
            }
            return ((ConnectionInfo)entry.getValue()).getNotHitCounter() > 5;
        });
    }

    static enum ProtectionMode {
        DETERMINED_BY_PEER_FLAGS(0),
        ALWAYS_SEEDING(1),
        ALWAYS_SEEDING_AND_DOWNLOADING(2);

        private final int code;

        private ProtectionMode(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static ProtectionMode fromCode(int code) {
            for (ProtectionMode mode : ProtectionMode.values()) {
                if (mode.code != code) continue;
                return mode;
            }
            return DETERMINED_BY_PEER_FLAGS;
        }
    }

    static class ConnectionInfo {
        private long idleStartTime;
        private double percentage;
        private long uploaded;
        private long downloaded;
        private int notHitCounter;

        @Generated
        public long getIdleStartTime() {
            return this.idleStartTime;
        }

        @Generated
        public double getPercentage() {
            return this.percentage;
        }

        @Generated
        public long getUploaded() {
            return this.uploaded;
        }

        @Generated
        public long getDownloaded() {
            return this.downloaded;
        }

        @Generated
        public int getNotHitCounter() {
            return this.notHitCounter;
        }

        @Generated
        public void setIdleStartTime(long idleStartTime) {
            this.idleStartTime = idleStartTime;
        }

        @Generated
        public void setPercentage(double percentage) {
            this.percentage = percentage;
        }

        @Generated
        public void setUploaded(long uploaded) {
            this.uploaded = uploaded;
        }

        @Generated
        public void setDownloaded(long downloaded) {
            this.downloaded = downloaded;
        }

        @Generated
        public void setNotHitCounter(int notHitCounter) {
            this.notHitCounter = notHitCounter;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConnectionInfo)) {
                return false;
            }
            ConnectionInfo other = (ConnectionInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getIdleStartTime() != other.getIdleStartTime()) {
                return false;
            }
            if (Double.compare(this.getPercentage(), other.getPercentage()) != 0) {
                return false;
            }
            if (this.getUploaded() != other.getUploaded()) {
                return false;
            }
            if (this.getDownloaded() != other.getDownloaded()) {
                return false;
            }
            return this.getNotHitCounter() == other.getNotHitCounter();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ConnectionInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $idleStartTime = this.getIdleStartTime();
            result = result * 59 + (int)($idleStartTime >>> 32 ^ $idleStartTime);
            long $percentage = Double.doubleToLongBits(this.getPercentage());
            result = result * 59 + (int)($percentage >>> 32 ^ $percentage);
            long $uploaded = this.getUploaded();
            result = result * 59 + (int)($uploaded >>> 32 ^ $uploaded);
            long $downloaded = this.getDownloaded();
            result = result * 59 + (int)($downloaded >>> 32 ^ $downloaded);
            result = result * 59 + this.getNotHitCounter();
            return result;
        }

        @Generated
        public String toString() {
            return "IdleConnectionDosProtection.ConnectionInfo(idleStartTime=" + this.getIdleStartTime() + ", percentage=" + this.getPercentage() + ", uploaded=" + this.getUploaded() + ", downloaded=" + this.getDownloaded() + ", notHitCounter=" + this.getNotHitCounter() + ")";
        }

        @Generated
        public ConnectionInfo(long idleStartTime, double percentage, long uploaded, long downloaded, int notHitCounter) {
            this.idleStartTime = idleStartTime;
            this.percentage = percentage;
            this.uploaded = uploaded;
            this.downloaded = downloaded;
            this.notHitCounter = notHitCounter;
        }
    }
}

