/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.pbhplus.backend;

import com.ghostchu.peerbanhelper.pbhplus.backend.BasicLicenseBackend;
import com.ghostchu.peerbanhelper.pbhplus.bean.License;
import com.ghostchu.peerbanhelper.pbhplus.data.LicenseStatus;
import com.ghostchu.peerbanhelper.pbhplus.validator.LicenseRevokeValidator;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RevolvableLicenseBackend
extends BasicLicenseBackend {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RevolvableLicenseBackend.class);
    private final Set<License> revokedLicenses = Collections.synchronizedSet(new LinkedHashSet());
    private final ScheduledExecutorService sched = Executors.newScheduledThreadPool(1, Thread.ofPlatform().name("License Revoke Checker").factory());
    private final List<LicenseRevokeValidator> revokeValidators;

    public RevolvableLicenseBackend(List<LicenseRevokeValidator> revokeValidators) {
        this.revokeValidators = revokeValidators;
        this.sched.scheduleWithFixedDelay(this::checkRevokedLicenses, 0L, 1L, TimeUnit.DAYS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void checkRevokedLicenses() {
        try (ExecutorService executor = Executors.newVirtualThreadPerTaskExecutor();){
            Set revoked = Collections.synchronizedSet(new HashSet());
            for (LicenseRevokeValidator validator : this.revokeValidators) {
                executor.submit(() -> revoked.addAll(validator.checkRevoked(this.licenses.values())));
            }
            Set<License> set = this.revokedLicenses;
            synchronized (set) {
                this.revokedLicenses.clear();
                this.revokedLicenses.addAll(revoked);
            }
        }
        catch (Exception e) {
            log.debug("Error checking revoked licenses: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean checkRevokedLicense(License license) {
        ExecutorService executor = Executors.newVirtualThreadPerTaskExecutor();
        try {
            Set revoked = Collections.synchronizedSet(new HashSet());
            for (LicenseRevokeValidator validator : this.revokeValidators) {
                executor.submit(() -> revoked.addAll(validator.checkRevoked(this.licenses.values())));
            }
            Set<License> set = this.revokedLicenses;
            synchronized (set) {
                this.revokedLicenses.clear();
                this.revokedLicenses.addAll(revoked);
            }
            boolean bl = revoked.contains(license);
            if (executor != null) {
                executor.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (executor != null) {
                    try {
                        executor.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                log.debug("Error checking revoked licenses: {}", (Object)e.getMessage(), (Object)e);
                return false;
            }
        }
    }

    @Override
    @NotNull
    public LicenseStatus getLicenseStatus(@NotNull License license) {
        if (this.revokedLicenses.contains(license)) {
            return LicenseStatus.REVOKED;
        }
        if (!this.licenses.containsValue(license) && this.checkRevokedLicense(license)) {
            return LicenseStatus.REVOKED;
        }
        return super.getLicenseStatus(license);
    }

    @Override
    public void setLicenses(@NotNull Map<String, License> in) {
        super.setLicenses(in);
    }
}

