/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.push;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.util.HTTPUtil;
import com.ghostchu.peerbanhelper.util.push.AbstractPushProvider;
import com.ghostchu.peerbanhelper.util.push.PushManager;
import com.ghostchu.peerbanhelper.util.push.PushProvider;
import com.ghostchu.peerbanhelper.util.push.impl.BarkPushProvider;
import com.ghostchu.peerbanhelper.util.push.impl.GotifyPushProvider;
import com.ghostchu.peerbanhelper.util.push.impl.PushDeerPushProvider;
import com.ghostchu.peerbanhelper.util.push.impl.PushPlusPushProvider;
import com.ghostchu.peerbanhelper.util.push.impl.ServerChanPushProvider;
import com.ghostchu.peerbanhelper.util.push.impl.SmtpPushProvider;
import com.ghostchu.peerbanhelper.util.push.impl.TelegramPushProvider;
import com.ghostchu.simplereloadlib.ReloadResult;
import com.ghostchu.simplereloadlib.Reloadable;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.bspfsystems.yamlconfiguration.configuration.ConfigurationSection;
import org.bspfsystems.yamlconfiguration.configuration.MemoryConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public final class PushManagerImpl
implements Reloadable,
PushManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PushManagerImpl.class);
    private final List<PushProvider> providerList = new ArrayList<PushProvider>();
    private final HTTPUtil httpUtil;

    public PushManagerImpl(HTTPUtil httpUtil) {
        this.httpUtil = httpUtil;
        this.reloadConfig();
    }

    @Override
    public PushProvider createPushProvider(String name, String type, ConfigurationSection section) {
        name = name.replace(".", "-");
        AbstractPushProvider provider = null;
        switch (type.toLowerCase(Locale.ROOT)) {
            case "pushplus": {
                provider = PushPlusPushProvider.loadFromYaml(name, section, this.httpUtil);
                break;
            }
            case "serverchan": {
                provider = ServerChanPushProvider.loadFromYaml(name, section, this.httpUtil);
                break;
            }
            case "smtp": {
                provider = SmtpPushProvider.loadFromYaml(name, section);
                break;
            }
            case "telegram": {
                provider = TelegramPushProvider.loadFromYaml(name, section, this.httpUtil);
                break;
            }
            case "bark": {
                provider = BarkPushProvider.loadFromYaml(name, section, this.httpUtil);
                break;
            }
            case "pushdeer": {
                provider = PushDeerPushProvider.loadFromYaml(name, section, this.httpUtil);
                break;
            }
            case "gotify": {
                provider = GotifyPushProvider.loadFromYaml(name, section, this.httpUtil);
            }
        }
        return provider;
    }

    @Override
    public PushProvider createPushProvider(String name, String type, JsonObject jsonObject) {
        AbstractPushProvider provider = null;
        switch (type.toLowerCase(Locale.ROOT)) {
            case "pushplus": {
                provider = PushPlusPushProvider.loadFromJson(name, jsonObject, this.httpUtil);
                break;
            }
            case "serverchan": {
                provider = ServerChanPushProvider.loadFromJson(name, jsonObject, this.httpUtil);
                break;
            }
            case "smtp": {
                provider = SmtpPushProvider.loadFromJson(name, jsonObject);
                break;
            }
            case "telegram": {
                provider = TelegramPushProvider.loadFromJson(name, jsonObject, this.httpUtil);
                break;
            }
            case "bark": {
                provider = BarkPushProvider.loadFromJson(name, jsonObject, this.httpUtil);
                break;
            }
            case "pushdeer": {
                provider = PushDeerPushProvider.loadFromJson(name, jsonObject, this.httpUtil);
                break;
            }
            case "gotify": {
                provider = GotifyPushProvider.loadFromJson(name, jsonObject, this.httpUtil);
            }
        }
        return provider;
    }

    private void reloadConfig() {
        ArrayList registered = new ArrayList();
        ConfigurationSection config = Main.getMainConfig().getConfigurationSection("push-notification");
        if (config == null) {
            return;
        }
        config.getKeys(false).forEach(provider -> {
            try {
                ConfigurationSection section = config.getConfigurationSection(provider);
                registered.add(this.createPushProvider((String)provider, section.getString("type"), section));
            }
            catch (Exception e) {
                log.error("Unable to load Push Provider: {}", provider, (Object)e);
            }
        });
        this.providerList.clear();
        this.providerList.addAll(registered);
    }

    @Override
    public boolean addPushProvider(PushProvider provider) {
        return this.providerList.add(provider);
    }

    @Override
    public boolean removePushProvider(PushProvider provider) {
        return this.providerList.remove(provider);
    }

    @Override
    public void savePushProviders() throws IOException {
        MemoryConfiguration clientSection = new MemoryConfiguration();
        for (PushProvider pushProvider : this.providerList) {
            clientSection.set(pushProvider.getName(), (Object)pushProvider.saveYaml());
        }
        Main.getMainConfig().set("push-notification", (Object)clientSection);
        Main.getMainConfig().save(Main.getMainConfigFile());
    }

    @Override
    public boolean pushMessage(String title, String description) {
        AtomicBoolean anySuccess = new AtomicBoolean(false);
        this.providerList.forEach(pushProvider -> {
            try {
                if (pushProvider.push(title, description)) {
                    anySuccess.set(true);
                }
            }
            catch (Exception e) {
                log.error(TextManager.tlUI(Lang.UNABLE_TO_PUSH_ALERT_VIA, pushProvider.getClass().getName()), (Throwable)e);
            }
        });
        return anySuccess.get();
    }

    public ReloadResult reloadModule() throws Exception {
        this.reloadConfig();
        return super.reloadModule();
    }

    @Override
    @Generated
    public List<PushProvider> getProviderList() {
        return this.providerList;
    }
}

