/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.push.impl;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.ghostchu.peerbanhelper.util.HTTPUtil;
import com.ghostchu.peerbanhelper.util.json.JsonUtil;
import com.ghostchu.peerbanhelper.util.push.AbstractPushProvider;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Objects;
import lombok.Generated;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.bspfsystems.yamlconfiguration.configuration.ConfigurationSection;
import org.bspfsystems.yamlconfiguration.file.YamlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PushPlusPushProvider
extends AbstractPushProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PushPlusPushProvider.class);
    private final Config config;
    private final String name;
    private final HTTPUtil httpUtil;

    public PushPlusPushProvider(String name, Config config, HTTPUtil httpUtil) {
        this.name = name;
        this.config = config;
        this.httpUtil = httpUtil;
    }

    @Override
    public JsonObject saveJson() {
        return JsonUtil.readObject(JsonUtil.standard().toJson((Object)this.config));
    }

    @Override
    public ConfigurationSection saveYaml() {
        YamlConfiguration section = new YamlConfiguration();
        section.set("type", (Object)"pushplus");
        section.set("token", (Object)this.config.getToken());
        section.set("topic", (Object)this.config.getTopic());
        section.set("channel", (Object)this.config.getChannel());
        return section;
    }

    public static PushPlusPushProvider loadFromJson(String name, JsonObject json, HTTPUtil httpUtil) {
        return new PushPlusPushProvider(name, (Config)JsonUtil.getGson().fromJson((JsonElement)json, Config.class), httpUtil);
    }

    public static PushPlusPushProvider loadFromYaml(String name, ConfigurationSection section, HTTPUtil httpUtil) {
        String token = section.getString("token", "");
        String topic = section.getString("topic", "");
        String channel = section.getString("channel", "");
        if (topic.isBlank()) {
            topic = null;
        }
        if (channel.isBlank()) {
            channel = null;
        }
        Config config = new Config(token, topic, channel);
        return new PushPlusPushProvider(name, config, httpUtil);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getConfigType() {
        return "pushplus";
    }

    @Override
    public boolean push(final String title, final String content) {
        HashMap<String, Object> args = new HashMap<String, Object>(this){
            final /* synthetic */ PushPlusPushProvider this$0;
            {
                PushPlusPushProvider pushPlusPushProvider = this$0;
                Objects.requireNonNull(pushPlusPushProvider);
                this.this$0 = pushPlusPushProvider;
                this.put("token", this.this$0.config.getToken());
                if (this.this$0.config.getTopic() != null) {
                    this.put("topic", this.this$0.config.getTopic());
                }
                if (this.this$0.config.getChannel() != null) {
                    this.put("channel", this.this$0.config.getChannel());
                }
                this.put("title", title);
                this.put("content", content);
                this.put("template", "markdown");
            }
        };
        RequestBody requestBody = RequestBody.create((String)JsonUtil.getGson().toJson((Object)args), (MediaType)MediaType.parse((String)"application/json"));
        Request request = new Request.Builder().url("https://www.pushplus.plus/send").post(requestBody).header("Content-Type", "application/json").build();
        try (Response response = this.httpUtil.newBuilder().build().newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IllegalStateException("HTTP Failed while sending push messages to PushPlus: " + response.body().string());
            }
            String responseBody = response.body().string();
            PushPlusResponse ppr = (PushPlusResponse)JsonUtil.getGson().fromJson(responseBody, PushPlusResponse.class);
            if (ppr.getCode() != 200) {
                throw new IllegalStateException("HTTP Failed while sending push messages to PushPlus: " + ppr.getMsg());
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to send push message to PushPlus", e);
        }
        return true;
    }

    public static class Config {
        private String token;
        private String topic;
        private String channel;

        @Generated
        public Config(String token, String topic, String channel) {
            this.token = token;
            this.topic = topic;
            this.channel = channel;
        }

        @Generated
        public String getToken() {
            return this.token;
        }

        @Generated
        public String getTopic() {
            return this.topic;
        }

        @Generated
        public String getChannel() {
            return this.channel;
        }

        @Generated
        public void setToken(String token) {
            this.token = token;
        }

        @Generated
        public void setTopic(String topic) {
            this.topic = topic;
        }

        @Generated
        public void setChannel(String channel) {
            this.channel = channel;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$token = this.getToken();
            String other$token = other.getToken();
            if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
                return false;
            }
            String this$topic = this.getTopic();
            String other$topic = other.getTopic();
            if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
                return false;
            }
            String this$channel = this.getChannel();
            String other$channel = other.getChannel();
            return !(this$channel == null ? other$channel != null : !this$channel.equals(other$channel));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $token = this.getToken();
            result = result * 59 + ($token == null ? 43 : $token.hashCode());
            String $topic = this.getTopic();
            result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
            String $channel = this.getChannel();
            result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PushPlusPushProvider.Config(token=" + this.getToken() + ", topic=" + this.getTopic() + ", channel=" + this.getChannel() + ")";
        }
    }

    public static class PushPlusResponse {
        @JsonProperty(value="code")
        private Integer code;
        @JsonProperty(value="msg")
        private String msg;

        @Generated
        public PushPlusResponse() {
        }

        @Generated
        public Integer getCode() {
            return this.code;
        }

        @Generated
        public String getMsg() {
            return this.msg;
        }

        @Generated
        public void setCode(Integer code) {
            this.code = code;
        }

        @Generated
        public void setMsg(String msg) {
            this.msg = msg;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PushPlusResponse)) {
                return false;
            }
            PushPlusResponse other = (PushPlusResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$code = this.getCode();
            Integer other$code = other.getCode();
            if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
                return false;
            }
            String this$msg = this.getMsg();
            String other$msg = other.getMsg();
            return !(this$msg == null ? other$msg != null : !this$msg.equals(other$msg));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PushPlusResponse;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
            String $msg = this.getMsg();
            result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PushPlusPushProvider.PushPlusResponse(code=" + this.getCode() + ", msg=" + this.getMsg() + ")";
        }
    }
}

