/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.push.impl;

import com.ghostchu.peerbanhelper.util.json.JsonUtil;
import com.ghostchu.peerbanhelper.util.push.AbstractPushProvider;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import lombok.Generated;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.bspfsystems.yamlconfiguration.configuration.ConfigurationSection;
import org.bspfsystems.yamlconfiguration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SmtpPushProvider
extends AbstractPushProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SmtpPushProvider.class);
    private final Config config;
    private final String name;

    public SmtpPushProvider(String name, Config config) {
        this.name = name;
        this.config = config;
    }

    public static SmtpPushProvider loadFromJson(String name, JsonObject json) {
        return new SmtpPushProvider(name, (Config)JsonUtil.getGson().fromJson((JsonElement)json, Config.class));
    }

    public static SmtpPushProvider loadFromYaml(String name, ConfigurationSection section) {
        boolean auth = section.getBoolean("auth");
        String username = section.getString("username");
        String password = section.getString("password");
        String sender = section.getString("sender");
        String senderName = section.getString("name", "PeerBanHelper");
        List receivers = section.getStringList("receiver");
        String encryption = section.getString("encryption", "SSLTLS");
        boolean sendPartial = section.getBoolean("sendPartial", true);
        Config config = new Config(section.getString("host"), section.getInt("port"), auth, username, password, sender, senderName, receivers, encryption, sendPartial);
        return new SmtpPushProvider(name, config);
    }

    @Override
    public JsonObject saveJson() {
        return JsonUtil.readObject(JsonUtil.standard().toJson((Object)this.config));
    }

    @Override
    public ConfigurationSection saveYaml() {
        YamlConfiguration section = new YamlConfiguration();
        section.set("type", (Object)"smtp");
        section.set("host", (Object)this.config.getHost());
        section.set("port", (Object)this.config.getPort());
        section.set("auth", (Object)this.config.isAuth());
        section.set("username", (Object)this.config.getUsername());
        section.set("password", (Object)this.config.getPassword());
        section.set("sender", (Object)this.config.getSender());
        section.set("name", (Object)this.config.getSenderName());
        section.set("receiver", this.config.getReceivers());
        section.set("encryption", (Object)this.config.getEncryption());
        section.set("sendPartial", (Object)this.config.isSendPartial());
        return section;
    }

    public String sendMail(List<String> email, String subject, String text) throws EmailException {
        HtmlEmail mail = new HtmlEmail();
        mail.setAuthentication(this.config.getUsername(), this.config.getPassword());
        mail.setCharset("UTF-8");
        mail.setHostName(this.config.getHost());
        mail.setSmtpPort(this.config.getPort());
        try {
            switch (Encryption.valueOf(this.config.getEncryption()).ordinal()) {
                case 1: {
                    mail.setStartTLSEnabled(true);
                    break;
                }
                case 2: {
                    mail.setStartTLSEnabled(true);
                    mail.setStartTLSRequired(true);
                    break;
                }
                case 3: {
                    mail.setSSLOnConnect(true);
                }
            }
        }
        catch (Exception e) {
            log.error("Unable to load mail encryption type: {}, it's valid?", (Object)this.config.getEncryption(), (Object)e);
        }
        mail.setSendPartial(this.config.isSendPartial());
        mail.setSubject(subject);
        mail.setContent((Object)this.markdown2Html(text), "text/html");
        mail.setFrom(this.config.getSender(), this.config.getSenderName(), "UTF-8");
        mail.setTo(email.stream().map(str -> {
            try {
                return new InternetAddress(str);
            }
            catch (AddressException exception) {
                log.warn("The email address [{}] is invalid", str, (Object)exception);
                return null;
            }
        }).filter(Objects::nonNull).toList());
        return mail.send();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getConfigType() {
        return "smtp";
    }

    @Override
    public boolean push(String title, String content) {
        try {
            this.sendMail(this.config.getReceivers(), title, content);
            return true;
        }
        catch (EmailException e) {
            log.warn("Unable to push message via SMTP", (Throwable)e);
            return false;
        }
    }

    public static class Config {
        private String host;
        private int port;
        private boolean auth;
        private String username;
        private String password;
        private String sender;
        private String senderName;
        @NotNull
        private List<String> receivers;
        private String encryption;
        private boolean sendPartial;

        @Generated
        public Config(String host, int port, boolean auth, String username, String password, String sender, String senderName, @NotNull List<String> receivers, String encryption, boolean sendPartial) {
            if (receivers == null) {
                throw new NullPointerException("receivers is marked non-null but is null");
            }
            this.host = host;
            this.port = port;
            this.auth = auth;
            this.username = username;
            this.password = password;
            this.sender = sender;
            this.senderName = senderName;
            this.receivers = receivers;
            this.encryption = encryption;
            this.sendPartial = sendPartial;
        }

        @Generated
        public String getHost() {
            return this.host;
        }

        @Generated
        public int getPort() {
            return this.port;
        }

        @Generated
        public boolean isAuth() {
            return this.auth;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public String getPassword() {
            return this.password;
        }

        @Generated
        public String getSender() {
            return this.sender;
        }

        @Generated
        public String getSenderName() {
            return this.senderName;
        }

        @NotNull
        @Generated
        public List<String> getReceivers() {
            return this.receivers;
        }

        @Generated
        public String getEncryption() {
            return this.encryption;
        }

        @Generated
        public boolean isSendPartial() {
            return this.sendPartial;
        }

        @Generated
        public void setHost(String host) {
            this.host = host;
        }

        @Generated
        public void setPort(int port) {
            this.port = port;
        }

        @Generated
        public void setAuth(boolean auth) {
            this.auth = auth;
        }

        @Generated
        public void setUsername(String username) {
            this.username = username;
        }

        @Generated
        public void setPassword(String password) {
            this.password = password;
        }

        @Generated
        public void setSender(String sender) {
            this.sender = sender;
        }

        @Generated
        public void setSenderName(String senderName) {
            this.senderName = senderName;
        }

        @Generated
        public void setReceivers(@NotNull List<String> receivers) {
            if (receivers == null) {
                throw new NullPointerException("receivers is marked non-null but is null");
            }
            this.receivers = receivers;
        }

        @Generated
        public void setEncryption(String encryption) {
            this.encryption = encryption;
        }

        @Generated
        public void setSendPartial(boolean sendPartial) {
            this.sendPartial = sendPartial;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPort() != other.getPort()) {
                return false;
            }
            if (this.isAuth() != other.isAuth()) {
                return false;
            }
            if (this.isSendPartial() != other.isSendPartial()) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            String this$sender = this.getSender();
            String other$sender = other.getSender();
            if (this$sender == null ? other$sender != null : !this$sender.equals(other$sender)) {
                return false;
            }
            String this$senderName = this.getSenderName();
            String other$senderName = other.getSenderName();
            if (this$senderName == null ? other$senderName != null : !this$senderName.equals(other$senderName)) {
                return false;
            }
            List<String> this$receivers = this.getReceivers();
            List<String> other$receivers = other.getReceivers();
            if (this$receivers == null ? other$receivers != null : !((Object)this$receivers).equals(other$receivers)) {
                return false;
            }
            String this$encryption = this.getEncryption();
            String other$encryption = other.getEncryption();
            return !(this$encryption == null ? other$encryption != null : !this$encryption.equals(other$encryption));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPort();
            result = result * 59 + (this.isAuth() ? 79 : 97);
            result = result * 59 + (this.isSendPartial() ? 79 : 97);
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            String $sender = this.getSender();
            result = result * 59 + ($sender == null ? 43 : $sender.hashCode());
            String $senderName = this.getSenderName();
            result = result * 59 + ($senderName == null ? 43 : $senderName.hashCode());
            List<String> $receivers = this.getReceivers();
            result = result * 59 + ($receivers == null ? 43 : ((Object)$receivers).hashCode());
            String $encryption = this.getEncryption();
            result = result * 59 + ($encryption == null ? 43 : $encryption.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SmtpPushProvider.Config(host=" + this.getHost() + ", port=" + this.getPort() + ", auth=" + this.isAuth() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", sender=" + this.getSender() + ", senderName=" + this.getSenderName() + ", receivers=" + String.valueOf(this.getReceivers()) + ", encryption=" + this.getEncryption() + ", sendPartial=" + this.isSendPartial() + ")";
        }
    }

    public static enum Encryption {
        NONE,
        STARTTLS,
        ENFORCE_STARTTLS,
        SSLTLS;

    }
}

