/*
 * Decompiled with CFR 0.152.
 */
package raccoonfink.deluge.responses;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.json.JSONException;
import org.json.JSONObject;
import raccoonfink.deluge.DelugeException;
import raccoonfink.deluge.Statistics;
import raccoonfink.deluge.Torrent;
import raccoonfink.deluge.responses.DelugeResponse;

public final class UIResponse
extends DelugeResponse {
    private boolean m_connected = false;
    private Statistics m_statistics;
    private final Set<Torrent> m_torrents = new TreeSet<Torrent>();

    public UIResponse(Integer httpResponseCode, JSONObject response) throws DelugeException {
        super(httpResponseCode, response);
        if (response == null) {
            return;
        }
        try {
            JSONObject result = response.getJSONObject("result");
            this.m_connected = result.optBoolean("connected");
            this.m_statistics = new Statistics(result.getJSONObject("stats"));
            JSONObject torrents = result.optJSONObject("torrents");
            if (torrents != null) {
                Iterator it = torrents.keys();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    this.m_torrents.add(new Torrent(key, torrents.getJSONObject(key)));
                }
            }
        }
        catch (JSONException e) {
            throw new DelugeException(e);
        }
    }

    public boolean isConnected() {
        return this.m_connected;
    }

    public Statistics getStatistics() {
        return this.m_statistics;
    }

    public Set<Torrent> getTorrents() {
        return this.m_torrents;
    }

    @Override
    public JSONObject toResponseJSON() throws JSONException {
        JSONObject ret = super.toResponseJSON();
        ret.put("connected", this.m_connected);
        ret.put("statistics", (Object)this.m_statistics.toJSON());
        JSONObject torrents = new JSONObject();
        ret.put("torrents", (Object)torrents);
        for (Torrent torrent : this.m_torrents) {
            torrents.put(torrent.getKey(), (Object)torrent.toJSON());
        }
        return ret;
    }
}

