/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.nativex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.hint.ConditionalHint;
import org.springframework.aot.hint.ExecutableHint;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.FieldHint;
import org.springframework.aot.hint.JdkProxyHint;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.MemberHint;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.TypeHint;
import org.springframework.aot.hint.TypeReference;

class ReflectionHintsAttributes {
    private static final Comparator<JdkProxyHint> JDK_PROXY_HINT_COMPARATOR = (left, right) -> {
        String leftSignature = left.getProxiedInterfaces().stream().map(TypeReference::getCanonicalName).collect(Collectors.joining(","));
        String rightSignature = right.getProxiedInterfaces().stream().map(TypeReference::getCanonicalName).collect(Collectors.joining(","));
        return leftSignature.compareTo(rightSignature);
    };

    ReflectionHintsAttributes() {
    }

    public List<Map<String, Object>> reflection(RuntimeHints hints) {
        ArrayList<Map<String, Object>> reflectionHints = new ArrayList<Map<String, Object>>();
        reflectionHints.addAll(hints.reflection().typeHints().sorted(Comparator.comparing(TypeHint::getType)).map(this::toAttributes).toList());
        reflectionHints.addAll(hints.proxies().jdkProxyHints().sorted(JDK_PROXY_HINT_COMPARATOR).map(this::toAttributes).toList());
        return reflectionHints;
    }

    public List<Map<String, Object>> jni(RuntimeHints hints) {
        ArrayList<Map<String, Object>> jniHints = new ArrayList<Map<String, Object>>();
        jniHints.addAll(hints.jni().typeHints().sorted(Comparator.comparing(TypeHint::getType)).map(this::toAttributes).toList());
        return jniHints;
    }

    private Map<String, Object> toAttributes(TypeHint hint) {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        attributes.put("type", hint.getType());
        this.handleCondition(attributes, hint);
        this.handleCategories(attributes, hint.getMemberCategories());
        this.handleFields(attributes, hint.fields());
        this.handleExecutables(attributes, Stream.concat(hint.constructors(), hint.methods()).sorted().toList());
        return attributes;
    }

    private void handleCondition(Map<String, Object> attributes, ConditionalHint hint) {
        if (hint.getReachableType() != null) {
            attributes.put("condition", Map.of("typeReached", hint.getReachableType()));
        }
    }

    private void handleFields(Map<String, Object> attributes, Stream<FieldHint> fields) {
        this.addIfNotEmpty(attributes, "fields", fields.sorted(Comparator.comparing(MemberHint::getName, String::compareToIgnoreCase)).map(fieldHint -> Map.of("name", fieldHint.getName())).toList());
    }

    private void handleExecutables(Map<String, Object> attributes, List<ExecutableHint> hints) {
        this.addIfNotEmpty(attributes, "methods", hints.stream().filter(h -> h.getMode().equals((Object)ExecutableMode.INVOKE)).map(this::toAttributes).toList());
    }

    private Map<String, Object> toAttributes(ExecutableHint hint) {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        attributes.put("name", hint.getName());
        attributes.put("parameterTypes", hint.getParameterTypes());
        return attributes;
    }

    private void handleCategories(Map<String, Object> attributes, Set<MemberCategory> categories) {
        categories.stream().sorted().forEach(category -> {
            switch (category) {
                case ACCESS_PUBLIC_FIELDS: 
                case PUBLIC_FIELDS: {
                    attributes.put("allPublicFields", true);
                    break;
                }
                case ACCESS_DECLARED_FIELDS: 
                case DECLARED_FIELDS: {
                    attributes.put("allDeclaredFields", true);
                    break;
                }
                case INVOKE_PUBLIC_CONSTRUCTORS: {
                    attributes.put("allPublicConstructors", true);
                    break;
                }
                case INVOKE_DECLARED_CONSTRUCTORS: {
                    attributes.put("allDeclaredConstructors", true);
                    break;
                }
                case INVOKE_PUBLIC_METHODS: {
                    attributes.put("allPublicMethods", true);
                    break;
                }
                case INVOKE_DECLARED_METHODS: {
                    attributes.put("allDeclaredMethods", true);
                    break;
                }
                case PUBLIC_CLASSES: {
                    attributes.put("allPublicClasses", true);
                    break;
                }
                case DECLARED_CLASSES: {
                    attributes.put("allDeclaredClasses", true);
                    break;
                }
                case UNSAFE_ALLOCATED: {
                    attributes.put("unsafeAllocated", true);
                }
            }
        });
    }

    private void addIfNotEmpty(Map<String, Object> attributes, String name, @Nullable Object value) {
        Collection collection;
        if (value != null && value instanceof Collection && !(collection = (Collection)value).isEmpty()) {
            attributes.put(name, value);
        }
    }

    private Map<String, Object> toAttributes(JdkProxyHint hint) {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        this.handleCondition(attributes, hint);
        attributes.put("type", Map.of("proxy", hint.getProxiedInterfaces()));
        return attributes;
    }
}

