PHDRS
{
  text PT_LOAD FLAGS(5) FILEHDR PHDRS;
  dynamic PT_DYNAMIC FLAGS(4);
  note PT_NOTE FLAGS(4);
  eh_frame 0x6474e550;
  replay PT_NULL;
}
SECTIONS
{
  rr_page_start = 3 * 65536;
  . = SIZEOF_HEADERS;
  .eh_frame_hdr   : { *(.eh_frame_hdr) *(.eh_frame_entry .eh_frame_entry.*) } :text :eh_frame
  .eh_frame       : { KEEP (*(.eh_frame)) *(.eh_frame.*) } :text :eh_frame
  .note.gnu.build-id  : { *(.note.gnu.build-id) } :text :note
  .note.gnu.property : { *(.note.gnu.property) } :text :note
  .hash           : { *(.hash) } :text
  .gnu.hash       : { *(.gnu.hash) } :text
  .dynsym         : { *(.dynsym) } :text
  .dynstr         : { *(.dynstr) } :text
  .dynamic        : { *(.dynamic) } :text :dynamic
  .gnu.version    : { *(.gnu.version) } :text
  .gnu.version_d  : { *(.gnu.version_d) } :text
  .gnu.version_r  : { *(.gnu.version_r) } :text
  .got            : { *(.got) } :text
  .got.plt        : { *(.got.plt) } :text
  . = rr_page_start - 2 * 65536;
  /* This space in .sh_placeholder is reserved for the section table
     symtab/strtab, which ordinarily go after the text sections,
     but we need to have before the rr page.
     We move it there in a post-processing step, since linker
     scripts can't specify these locations for legacy reasons */
  .sh_placeholder : { *(.sh_placeholder) } :text
  . = rr_page_start - 65536;
  .plt       : { *(.plt) } :text
  .vdso.text : { *(.vdso.text) } :text
  . = rr_page_start;
  .record.text : { *(.record.text) } :text
  . = rr_page_start + 65536;
  .replay.text : { *(.replay.text) } :replay
  /DISCARD/ : { *(.debug_* ) }
}

VERSION {
  LINUX_2.6.39 {
    global:
      __kernel_clock_getres; __kernel_rt_sigreturn; __kernel_gettimeofday; __kernel_clock_gettime;
  };
}
