window.search = Object.assign(window.search, JSON.parse('{"doc_urls":["index.html#rust-style-guide","index.html#motivation---why-use-a-formatting-tool","index.html#the-default-rust-style","index.html#bugs","index.html#formatting-conventions","index.html#indentation-and-line-width","index.html#trailing-commas","index.html#blank-lines","index.html#trailing-whitespace","index.html#sorting","index.html#module-level-items","index.html#statements","index.html#expressions","index.html#types","index.html#comments","index.html#attributes","index.html#small-items","index.html#non-formatting-conventions","index.html#cargotoml-conventions","index.html#principles-used-for-deciding-these-guidelines","items.html#items","items.html#function-definitions","items.html#tuples-and-tuple-structs","items.html#single-line","items.html#enums","items.html#structs-and-unions","items.html#tuple-structs","items.html#traits","items.html#impls","items.html#extern-crate","items.html#modules","items.html#macro_rules","items.html#generics","items.html#where-clauses","items.html#type-aliases","items.html#associated-types","items.html#extern-items","items.html#imports-use-statements","items.html#large-list-imports","items.html#ordering-of-imports","items.html#ordering-list-import","items.html#normalisation","items.html#nested-imports","items.html#mergingun-merging-imports","statements.html#statements","statements.html#let-statements","statements.html#else-blocks-let-else-statements","statements.html#macros-in-statement-position","statements.html#expressions-in-statement-position","expressions.html#expressions","expressions.html#blocks","expressions.html#closures","expressions.html#struct-literals","expressions.html#unit-literals","expressions.html#tuple-literals","expressions.html#tuple-struct-literals","expressions.html#enum-literals","expressions.html#array-literals","expressions.html#array-accesses-indexing-and-slicing","expressions.html#unary-operations","expressions.html#binary-operations","expressions.html#casts-as","expressions.html#control-flow","expressions.html#function-calls","expressions.html#single-line-calls","expressions.html#multi-line-calls","expressions.html#method-calls","expressions.html#macro-uses","expressions.html#format-string-macros","expressions.html#chains-of-fields-and-method-calls","expressions.html#multi-line-elements","expressions.html#control-flow-expressions","expressions.html#single-line-if-else","expressions.html#match","expressions.html#line-breaking","expressions.html#combinable-expressions","expressions.html#ranges","expressions.html#hexadecimal-literals","expressions.html#patterns","types.html#types-and-bounds","types.html#single-line-formatting","types.html#line-breaks","types.html#precise-capturing-bounds","advice.html#other-style-advice","advice.html#expressions","advice.html#names","advice.html#modules","cargo.html#cargotoml-conventions","cargo.html#formatting-conventions","cargo.html#metadata-conventions","principles.html#guiding-principles-and-rationale","editions.html#rust-style-editions","editions.html#rust-next-style-edition","editions.html#rust-2024-style-edition","editions.html#rust-201520182021-style-edition","nightly.html#nightly","nightly.html#frontmatter"],"index":{"documentStore":{"docInfo":{"0":{"body":0,"breadcrumbs":4,"title":3},"1":{"body":92,"breadcrumbs":5,"title":4},"10":{"body":0,"breadcrumbs":4,"title":3},"11":{"body":0,"breadcrumbs":2,"title":1},"12":{"body":0,"breadcrumbs":2,"title":1},"13":{"body":0,"breadcrumbs":2,"title":1},"14":{"body":169,"breadcrumbs":2,"title":1},"15":{"body":76,"breadcrumbs":2,"title":1},"16":{"body":69,"breadcrumbs":3,"title":2},"17":{"body":0,"breadcrumbs":4,"title":3},"18":{"body":0,"breadcrumbs":3,"title":2},"19":{"body":0,"breadcrumbs":5,"title":4},"2":{"body":53,"breadcrumbs":4,"title":3},"20":{"body":70,"breadcrumbs":2,"title":1},"21":{"body":66,"breadcrumbs":3,"title":2},"22":{"body":12,"breadcrumbs":4,"title":3},"23":{"body":13,"breadcrumbs":3,"title":2},"24":{"body":84,"breadcrumbs":2,"title":1},"25":{"body":98,"breadcrumbs":3,"title":2},"26":{"body":83,"breadcrumbs":3,"title":2},"27":{"body":89,"breadcrumbs":2,"title":1},"28":{"body":54,"breadcrumbs":2,"title":1},"29":{"body":10,"breadcrumbs":3,"title":2},"3":{"body":60,"breadcrumbs":2,"title":1},"30":{"body":20,"breadcrumbs":2,"title":1},"31":{"body":9,"breadcrumbs":2,"title":1},"32":{"body":116,"breadcrumbs":2,"title":1},"33":{"body":145,"breadcrumbs":2,"title":1},"34":{"body":122,"breadcrumbs":3,"title":2},"35":{"body":19,"breadcrumbs":3,"title":2},"36":{"body":25,"breadcrumbs":3,"title":2},"37":{"body":21,"breadcrumbs":4,"title":3},"38":{"body":57,"breadcrumbs":4,"title":3},"39":{"body":59,"breadcrumbs":3,"title":2},"4":{"body":0,"breadcrumbs":3,"title":2},"40":{"body":39,"breadcrumbs":4,"title":3},"41":{"body":27,"breadcrumbs":2,"title":1},"42":{"body":35,"breadcrumbs":3,"title":2},"43":{"body":25,"breadcrumbs":4,"title":3},"44":{"body":0,"breadcrumbs":2,"title":1},"45":{"body":180,"breadcrumbs":2,"title":1},"46":{"body":224,"breadcrumbs":3,"title":2},"47":{"body":21,"breadcrumbs":4,"title":3},"48":{"body":43,"breadcrumbs":4,"title":3},"49":{"body":0,"breadcrumbs":2,"title":1},"5":{"body":51,"breadcrumbs":4,"title":3},"50":{"body":152,"breadcrumbs":2,"title":1},"51":{"body":78,"breadcrumbs":2,"title":1},"52":{"body":72,"breadcrumbs":3,"title":2},"53":{"body":8,"breadcrumbs":3,"title":2},"54":{"body":47,"breadcrumbs":3,"title":2},"55":{"body":21,"breadcrumbs":4,"title":3},"56":{"body":25,"breadcrumbs":3,"title":2},"57":{"body":96,"breadcrumbs":3,"title":2},"58":{"body":53,"breadcrumbs":5,"title":4},"59":{"body":18,"breadcrumbs":3,"title":2},"6":{"body":39,"breadcrumbs":3,"title":2},"60":{"body":100,"breadcrumbs":3,"title":2},"61":{"body":79,"breadcrumbs":2,"title":1},"62":{"body":27,"breadcrumbs":3,"title":2},"63":{"body":52,"breadcrumbs":3,"title":2},"64":{"body":27,"breadcrumbs":4,"title":3},"65":{"body":39,"breadcrumbs":4,"title":3},"66":{"body":13,"breadcrumbs":3,"title":2},"67":{"body":44,"breadcrumbs":3,"title":2},"68":{"body":47,"breadcrumbs":4,"title":3},"69":{"body":82,"breadcrumbs":5,"title":4},"7":{"body":24,"breadcrumbs":3,"title":2},"70":{"body":60,"breadcrumbs":4,"title":3},"71":{"body":220,"breadcrumbs":4,"title":3},"72":{"body":30,"breadcrumbs":3,"title":2},"73":{"body":189,"breadcrumbs":2,"title":1},"74":{"body":168,"breadcrumbs":3,"title":2},"75":{"body":92,"breadcrumbs":3,"title":2},"76":{"body":46,"breadcrumbs":2,"title":1},"77":{"body":21,"breadcrumbs":3,"title":2},"78":{"body":12,"breadcrumbs":2,"title":1},"79":{"body":0,"breadcrumbs":4,"title":2},"8":{"body":25,"breadcrumbs":3,"title":2},"80":{"body":121,"breadcrumbs":5,"title":3},"81":{"body":78,"breadcrumbs":4,"title":2},"82":{"body":34,"breadcrumbs":5,"title":3},"83":{"body":0,"breadcrumbs":4,"title":2},"84":{"body":21,"breadcrumbs":3,"title":1},"85":{"body":48,"breadcrumbs":3,"title":1},"86":{"body":4,"breadcrumbs":3,"title":1},"87":{"body":0,"breadcrumbs":4,"title":2},"88":{"body":215,"breadcrumbs":4,"title":2},"89":{"body":105,"breadcrumbs":4,"title":2},"9":{"body":273,"breadcrumbs":2,"title":1},"90":{"body":82,"breadcrumbs":6,"title":3},"91":{"body":134,"breadcrumbs":6,"title":3},"92":{"body":9,"breadcrumbs":7,"title":4},"93":{"body":59,"breadcrumbs":7,"title":4},"94":{"body":17,"breadcrumbs":7,"title":4},"95":{"body":69,"breadcrumbs":3,"title":1},"96":{"body":67,"breadcrumbs":3,"title":1}},"docs":{"0":{"body":"","breadcrumbs":"Introduction » Rust Style Guide","id":"0","title":"Rust Style Guide"},"1":{"body":"Formatting code is a mostly mechanical task which takes both time and mental\\neffort. By using an automatic formatting tool, a programmer is relieved of\\nthis task and can concentrate on more important things. Furthermore, by sticking to an established style guide (such as this one),\\nprogrammers don’t need to formulate ad hoc style rules, nor do they need to\\ndebate with other programmers what style rules should be used, saving time,\\ncommunication overhead, and mental energy. Humans comprehend information through pattern matching. By ensuring that all\\nRust code has similar formatting, less mental effort is required to comprehend a\\nnew project, lowering the barrier to entry for new developers. Thus, there are productivity benefits to using a formatting tool (such as rustfmt), and even larger benefits by using a community-consistent\\nformatting, typically by using a formatting tool’s default settings.","breadcrumbs":"Introduction » Motivation - why use a formatting tool?","id":"1","title":"Motivation - why use a formatting tool?"},"10":{"body":"","breadcrumbs":"Introduction » Module-level items","id":"10","title":"Module-level items"},"11":{"body":"","breadcrumbs":"Introduction » Statements","id":"11","title":"Statements"},"12":{"body":"","breadcrumbs":"Introduction » Expressions","id":"12","title":"Expressions"},"13":{"body":"","breadcrumbs":"Introduction » Types","id":"13","title":"Types"},"14":{"body":"The following guidelines for comments are recommendations only, a mechanical\\nformatter might skip formatting of comments. Prefer line comments ( //) to block comments ( /* ... */). When using line comments, put a single space after the opening sigil. When using single-line block comments, put a single space after the opening\\nsigil and before the closing sigil. For multi-line block comments, put a\\nnewline after the opening sigil, and a newline before the closing sigil. Prefer to put a comment on its own line. Where a comment follows code, put a\\nsingle space before it. Where a block comment appears inline, use surrounding\\nwhitespace as if it were an identifier or keyword. Examples: #![allow(unused)] fn main() {\\n// A comment on an item.\\nstruct Foo { ... } fn foo() {} // A comment after an item. pub fn foo(/* a comment before an argument */ x: T) {...} } Comments should usually be complete sentences. Start with a capital letter, end\\nwith a period ( .). An inline block comment may be treated as a note without\\npunctuation. Source lines which are entirely a comment should be limited to 80 characters\\nin length (including comment sigils, but excluding indentation) or the maximum\\nwidth of the line (including comment sigils and indentation), whichever is\\nsmaller: #![allow(unused)] fn main() {\\n// This comment goes up to the ................................. 80 char margin. { // This comment is .............................................. 80 chars wide.\\n} { { { { { { // This comment is limited by the ......................... 100 char margin. } } } } }\\n} } Doc comments Prefer line comments ( ///) to block comments ( /** ... */). Prefer outer doc comments ( /// or /** ... */), only use inner doc comments\\n( //! and /*! ... */) to write module-level or crate-level documentation. Put doc comments before attributes.","breadcrumbs":"Introduction » Comments","id":"14","title":"Comments"},"15":{"body":"Put each attribute on its own line, indented to the level of the item.\\nIn the case of inner attributes ( #!), indent it to the level of the inside of\\nthe item. Prefer outer attributes, where possible. For attributes with argument lists, format like functions. #![allow(unused)] fn main() {\\n#[repr(C)]\\n#[foo(foo, bar)]\\n#[long_multi_line_attribute( split, across, lines,\\n)]\\nstruct CRepr { #![repr(C)] x: f32, y: f32,\\n} } For attributes with an equal sign, put a single space before and after the =,\\ne.g., #[foo = 42]. There must only be a single derive attribute. Note for tool authors: if\\ncombining multiple derive attributes into a single attribute, the ordering of\\nthe derived names must generally be preserved for correctness: #[derive(Foo)] #[derive(Bar)] struct Baz; must be formatted to #[derive(Foo, Bar)] struct Baz;.","breadcrumbs":"Introduction » Attributes","id":"15","title":"Attributes"},"16":{"body":"In many places in this guide we specify formatting that depends on a code\\nconstruct being small. For example, single-line vs multi-line struct\\nliterals: #![allow(unused)] fn main() {\\n// Normal formatting\\nFoo { f1: an_expression, f2: another_expression(),\\n} // \\"small\\" formatting\\nFoo { f1, f2 } } We leave it to individual tools to decide on exactly what small means. In\\nparticular, tools are free to use different definitions in different\\ncircumstances. Some suitable heuristics are the size of the item (in characters) or the\\ncomplexity of an item (for example, that all components must be simple names,\\nnot more complex sub-expressions). For more discussion on suitable heuristics,\\nsee this issue.","breadcrumbs":"Introduction » small items","id":"16","title":"small items"},"17":{"body":"","breadcrumbs":"Introduction » Non-formatting conventions","id":"17","title":"Non-formatting conventions"},"18":{"body":"","breadcrumbs":"Introduction » Cargo.toml conventions","id":"18","title":"Cargo.toml conventions"},"19":{"body":"","breadcrumbs":"Introduction » Principles used for deciding these guidelines","id":"19","title":"Principles used for deciding these guidelines"},"2":{"body":"The Rust Style Guide defines the default Rust style, and recommends that\\ndevelopers and tools follow the default Rust style. Tools such as rustfmt use\\nthe style guide as a reference for the default style. Everything in this style\\nguide, whether or not it uses language such as “must” or the imperative mood\\nsuch as “insert a space …” or “break the line after …”, refers to the\\ndefault style. This should not be interpreted as forbidding developers from following a\\nnon-default style, or forbidding tools from adding any particular configuration\\noptions.","breadcrumbs":"Introduction » The default Rust style","id":"2","title":"The default Rust style"},"20":{"body":"Items consist of the set of things permitted at the top level of a module.\\nHowever, Rust also allows some items to appear within some other types of\\nitems, such as within a function. The same formatting conventions apply whether\\nan item appears at module level or within another item. extern crate statements must be first in a file. They must be ordered\\nalphabetically. use statements, and module declarations ( mod foo;, not mod { ... })\\nmust come before other items. Put imports before module declarations.\\nVersion-sort each, except that self and super must come before any other\\nnames. Don’t automatically move module declarations annotated with #[macro_use],\\nsince that might change semantics.","breadcrumbs":"Items » Items","id":"20","title":"Items"},"21":{"body":"In Rust, people often find functions by searching for fn [function-name], so\\nthe formatting of function definitions must enable this. The proper ordering and spacing is: #![allow(unused)] fn main() {\\n[pub] [unsafe] [extern [\\"ABI\\"]] fn foo(arg1: i32, arg2: i32) -> i32 { ...\\n} } Avoid comments within the signature itself. If the function signature does not fit on one line, then break after the opening\\nparenthesis and before the closing parenthesis and put each argument on its own\\nblock-indented line. For example, #![allow(unused)] fn main() {\\nfn foo( arg1: i32, arg2: i32,\\n) -> i32 { ...\\n} } Note the trailing comma on the last argument.","breadcrumbs":"Items » Function definitions","id":"21","title":"Function definitions"},"22":{"body":"Write the type list as you would a parameter list to a function. Build a tuple or tuple struct as you would call a function.","breadcrumbs":"Items » Tuples and tuple structs","id":"22","title":"Tuples and tuple structs"},"23":{"body":"#![allow(unused)] fn main() {\\nstruct Bar(Type1, Type2); let x = Bar(11, 22);\\nlet y = (11, 22, 33); }","breadcrumbs":"Items » Single-line","id":"23","title":"Single-line"},"24":{"body":"In the declaration, put each variant on its own line, block indented. Format each variant accordingly as either a struct (but without the struct\\nkeyword), a tuple struct, or an identifier (which doesn’t require special\\nformatting): #![allow(unused)] fn main() {\\nenum FooBar { First(u32), Second, Error { err: Box<Error>, line: u32, },\\n} } If a struct variant is small, format it on one\\nline. In this case, do not use a trailing comma for the field list, but do put\\nspaces around each brace: #![allow(unused)] fn main() {\\nenum FooBar { Error { err: Box<Error>, line: u32 },\\n} } In an enum with multiple struct variants, if any struct variant is written on\\nmultiple lines, use the multi-line formatting for all struct variants. However,\\nsuch a situation might be an indication that you should factor out the fields\\nof the variant into their own struct.","breadcrumbs":"Items » Enums","id":"24","title":"Enums"},"25":{"body":"Struct names follow on the same line as the struct keyword, with the opening\\nbrace on the same line when it fits within the right margin. All struct fields\\nare indented once and end with a trailing comma. The closing brace is not\\nindented and appears on its own line. #![allow(unused)] fn main() {\\nstruct Foo { a: A, b: B,\\n} } If and only if the type of a field does not fit within the right margin, it is\\npulled down to its own line and indented again. #![allow(unused)] fn main() {\\nstruct Foo { a: A, long_name: LongType,\\n} } Prefer using a unit struct (e.g., struct Foo;) to an empty struct (e.g., struct Foo(); or struct Foo {}, these only exist to simplify code\\ngeneration), but if you must use an empty struct, keep it on one line with no\\nspace between the braces: struct Foo(); or struct Foo {}. The same guidelines are used for untagged union declarations. #![allow(unused)] fn main() {\\nunion Foo { a: A, b: B, long_name: LongType,\\n} }","breadcrumbs":"Items » Structs and Unions","id":"25","title":"Structs and Unions"},"26":{"body":"Put the whole struct on one line if possible. Separate types within the\\nparentheses using a comma and space. Don’t use a trailing comma for a\\nsingle-line tuple struct. Don’t put spaces around the parentheses or semicolon: #![allow(unused)] fn main() {\\npub struct Foo(String, u8); } Prefer unit structs to empty tuple structs (these only exist to simplify code\\ngeneration), e.g., struct Foo; rather than struct Foo();. For more than a few fields (in particular if the tuple struct does not fit on\\none line), prefer a proper struct with named fields. For a multi-line tuple struct, block-format the fields with a field on each\\nline and a trailing comma: #![allow(unused)] fn main() {\\npub struct Foo( String, u8,\\n); }","breadcrumbs":"Items » Tuple structs","id":"26","title":"Tuple structs"},"27":{"body":"Use block-indent for trait items. If there are no items, format the trait (including its {})\\non a single line. Otherwise, break after the opening brace and before\\nthe closing brace: #![allow(unused)] fn main() {\\ntrait Foo {} pub trait Bar { ...\\n} } If the trait has bounds, put a space after the colon but not before,\\nand put spaces around each +, e.g., #![allow(unused)] fn main() {\\ntrait Foo: Debug + Bar {} } Prefer not to line-break in the bounds if possible (consider using a where\\nclause). Prefer to break between bounds than to break any individual bound. If\\nyou must break the bounds, put each bound (including the first) on its own\\nblock-indented line, break before the + and put the opening brace on its own\\nline: #![allow(unused)] fn main() {\\npub trait IndexRanges: Index<Range<usize>, Output=Self> + Index<RangeTo<usize>, Output=Self> + Index<RangeFrom<usize>, Output=Self> + Index<RangeFull, Output=Self>\\n{ ...\\n} }","breadcrumbs":"Items » Traits","id":"27","title":"Traits"},"28":{"body":"Use block-indent for impl items. If there are no items, format the impl\\n(including its {}) on a single line. Otherwise, break after the opening brace\\nand before the closing brace: #![allow(unused)] fn main() {\\nimpl Foo {} impl Bar for Foo { ...\\n} } Avoid line-breaking in the signature if possible. If a line break is required in\\na non-inherent impl, break immediately before for, block indent the concrete type\\nand put the opening brace on its own line: #![allow(unused)] fn main() {\\nimpl Bar for Foo\\n{ ...\\n} }","breadcrumbs":"Items » Impls","id":"28","title":"Impls"},"29":{"body":"extern crate foo; Use spaces around keywords, no spaces around the semicolon.","breadcrumbs":"Items » Extern crate","id":"29","title":"Extern crate"},"3":{"body":"If the style guide differs from rustfmt, that may represent a bug in rustfmt,\\nor a bug in the style guide; either way, please report it to the style team or\\nthe rustfmt team or both, for investigation and fix. If implementing a new formatting tool based on the style guide and default Rust\\nstyle, please test it on the corpus of existing Rust code, and avoid causing\\nwidespread breakage. The implementation and testing of such a tool may surface\\nbugs in either the style guide or rustfmt, as well as bugs in the tool itself. We typically resolve bugs in a fashion that avoids widespread breakage.","breadcrumbs":"Introduction » Bugs","id":"3","title":"Bugs"},"30":{"body":"#![allow(unused)] fn main() {\\nmod foo {\\n} } #![allow(unused)] fn main() {\\nmod foo; } Use spaces around keywords and before the opening brace, no spaces around the\\nsemicolon.","breadcrumbs":"Items » Modules","id":"30","title":"Modules"},"31":{"body":"Use {} for the full definition of the macro. #![allow(unused)] fn main() {\\nmacro_rules! foo {\\n} }","breadcrumbs":"Items » macro_rules!","id":"31","title":"macro_rules!"},"32":{"body":"Prefer to put a generics clause on one line. Break other parts of an item\\ndeclaration rather than line-breaking a generics clause. If a generics clause is\\nlarge enough to require line-breaking, prefer a where clause instead. Do not put spaces before or after < nor before >. Only put a space after > if it is followed by a word or opening brace, not an opening parenthesis.\\nPut a space after each comma. Do not use a trailing comma for a single-line\\ngenerics clause. #![allow(unused)] fn main() {\\nfn foo<T: Display, U: Debug>(x: Vec<T>, y: Vec<U>) ... impl<T: Display, U: Debug> SomeType<T, U> { ... } If the generics clause must be formatted across multiple lines, put each\\nparameter on its own block-indented line, break after the opening < and\\nbefore the closing >, and use a trailing comma. #![allow(unused)] fn main() {\\nfn foo< T: Display, U: Debug,\\n>(x: Vec<T>, y: Vec<U>) ... } If an associated type is bound in a generic type, put spaces around the =: #![allow(unused)] fn main() {\\n<T: Example<Item = u32>> } Prefer to use single-letter names for generic parameters.","breadcrumbs":"Items » Generics","id":"32","title":"Generics"},"33":{"body":"These rules apply for where clauses on any item. If immediately following a closing bracket of any kind, write the keyword where on the same line, with a space before it. Otherwise, put where on a new line at the same indentation level. Put each\\ncomponent of a where clause on its own line, block-indented. Use a trailing\\ncomma, unless the clause is terminated with a semicolon. If the where clause\\nis followed by a block (or assignment), start that block on a new line.\\nExamples: #![allow(unused)] fn main() {\\nfn function<T, U>(args)\\nwhere T: Bound, U: AnotherBound,\\n{ body\\n} fn foo<T>( args\\n) -> ReturnType\\nwhere T: Bound,\\n{ body\\n} fn foo<T, U>( args,\\n) where T: Bound, U: AnotherBound,\\n{ body\\n} fn foo<T, U>( args\\n) -> ReturnType\\nwhere T: Bound, U: AnotherBound; // Note, no trailing comma. // Note that where clauses on `type` aliases are not enforced and should not\\n// be used.\\ntype Foo<T>\\nwhere T: Bound\\n= Bar<T>; } If a where clause is very short, prefer using an inline bound on the type\\nparameter. If a component of a where clause does not fit and contains +, break it\\nbefore each + and block-indent the continuation lines. Put each bound on its\\nown line. E.g., #![allow(unused)] fn main() {\\nimpl<T: ?Sized, Idx> IndexRanges<Idx> for T\\nwhere T: Index<Range<Idx>, Output = Self::Output> + Index<RangeTo<Idx>, Output = Self::Output> + Index<RangeFrom<Idx>, Output = Self::Output> + Index<RangeInclusive<Idx>, Output = Self::Output> + Index<RangeToInclusive<Idx>, Output = Self::Output> + Index<RangeFull>, }","breadcrumbs":"Items » where clauses","id":"33","title":"where clauses"},"34":{"body":"Keep type aliases on one line when they fit. If necessary to break the line, do\\nso before the =, and block-indent the right-hand side: #![allow(unused)] fn main() {\\npub type Foo = Bar<T>; // If multi-line is required\\ntype VeryLongType<T, U: SomeBound> = AnEvenLongerType<T, U, Foo<T>>; } When there is a trailing where clause after the type, and no where clause\\npresent before the type, break before the = and indent. Then break before the where keyword and format the clauses normally, e.g., #![allow(unused)] fn main() {\\n// With only a trailing where clause\\ntype VeryLongType<T, U> = AnEvenLongerType<T, U, Foo<T>>\\nwhere T: U::AnAssociatedType, U: SomeBound; } When there is a where clause before the type, format it normally, and break\\nafter the last clause. Do not indent before the = to leave it visually\\ndistinct from the indented clauses that precede it. If there is additionally a where clause after the type, break before the where keyword and format the\\nclauses normally. #![allow(unused)] fn main() {\\n// With only a preceding where clause.\\ntype WithPrecedingWC<T, U>\\nwhere T: U::AnAssociatedType, U: SomeBound,\\n= AnEvenLongerType<T, U, Foo<T>>; // Or with both a preceding and trailing where clause.\\ntype WithPrecedingWC<T, U>\\nwhere T: U::AnAssociatedType, U: SomeBound,\\n= AnEvenLongerType<T, U, Foo<T>>\\nwhere T: U::AnAssociatedType2, U: SomeBound2; }","breadcrumbs":"Items » Type aliases","id":"34","title":"Type aliases"},"35":{"body":"Format associated types like type aliases. Where an associated type has a\\nbound, put a space after the colon but not before: #![allow(unused)] fn main() {\\npub type Foo: Bar; }","breadcrumbs":"Items » Associated types","id":"35","title":"Associated types"},"36":{"body":"When writing extern items (such as extern \\"C\\" fn), always specify the ABI.\\nFor example, write extern \\"C\\" fn foo ... or unsafe extern \\"C\\" { ...}\\nand avoid extern fn foo ... and unsafe extern { ... }.","breadcrumbs":"Items » extern items","id":"36","title":"extern items"},"37":{"body":"Format imports on one line where possible. Don’t put spaces around braces. #![allow(unused)] fn main() {\\nuse a::b::c;\\nuse a::b::d::*;\\nuse a::b::{foo, bar, baz}; }","breadcrumbs":"Items » Imports ( use statements)","id":"37","title":"Imports ( use statements)"},"38":{"body":"Prefer to use multiple imports rather than a multi-line import. However, tools\\nshould not split imports by default. If an import does require multiple lines (either because a list of single names\\ndoes not fit within the max width, or because of the rules for nested imports\\nbelow), then break after the opening brace and before the closing brace, use a\\ntrailing comma, and block indent the names. #![allow(unused)] fn main() {\\n// Prefer\\nfoo::{long, list, of, imports};\\nfoo::{more, imports}; // If necessary\\nfoo::{ long, list, of, imports, more, imports, // Note trailing comma\\n}; }","breadcrumbs":"Items » Large list imports","id":"38","title":"Large list imports"},"39":{"body":"A group of imports is a set of imports on the same or sequential lines. One or\\nmore blank lines or other items (e.g., a function) separate groups of imports. Within a group of imports, imports must be version-sorted. Groups of imports\\nmust not be merged or re-ordered. E.g., input: #![allow(unused)] fn main() {\\nuse d;\\nuse c; use b;\\nuse a; } output: #![allow(unused)] fn main() {\\nuse c;\\nuse d; use a;\\nuse b; } Because of macro_use, attributes must also start a new group and prevent\\nre-ordering.","breadcrumbs":"Items » Ordering of imports","id":"39","title":"Ordering of imports"},"4":{"body":"","breadcrumbs":"Introduction » Formatting conventions","id":"4","title":"Formatting conventions"},"40":{"body":"Names in a list import must be version-sorted, except that: self and super always come first if present, and groups and glob imports always come last if present. This applies recursively. For example, a::* comes before b::a but a::b\\ncomes before a::*. E.g., use foo::bar::{a, b::c, b::d, b::d::{x, y, z}, b::{self, r, s}};.","breadcrumbs":"Items » Ordering list import","id":"40","title":"Ordering list import"},"41":{"body":"Tools must make the following normalisations, recursively: use a::self; -> use a; use a::{}; -> (nothing) use a::{b}; -> use a::b; Tools must not otherwise merge or un-merge import lists or adjust glob imports\\n(without an explicit option).","breadcrumbs":"Items » Normalisation","id":"41","title":"Normalisation"},"42":{"body":"If there are any nested imports in a list import, then use the multi-line form,\\neven if the import fits on one line. Each nested import must be on its own line,\\nbut non-nested imports must be grouped on as few lines as possible. For example, #![allow(unused)] fn main() {\\nuse a::b::{ x, y, z, u::{...}, w::{...},\\n}; }","breadcrumbs":"Items » Nested imports","id":"42","title":"Nested imports"},"43":{"body":"An example: #![allow(unused)] fn main() {\\n// Un-merged\\nuse a::b;\\nuse a::c::d; // Merged\\nuse a::{b, c::d}; } Tools must not merge or un-merge imports by default. They may offer merging or\\nun-merging as an option.","breadcrumbs":"Items » Merging/un-merging imports","id":"43","title":"Merging/un-merging imports"},"44":{"body":"","breadcrumbs":"Statements » Statements","id":"44","title":"Statements"},"45":{"body":"Put a space after the : and on both sides of the = (if they are present).\\nDon’t put a space before the semicolon. #![allow(unused)] fn main() {\\n// A comment.\\nlet pattern: Type = expr; let pattern;\\nlet pattern: Type;\\nlet pattern = expr; } If possible, format the declaration on a single line. If not possible, then try\\nsplitting after the =, if the declaration fits on two lines. Block-indent the\\nexpression. #![allow(unused)] fn main() {\\nlet pattern: Type = expr; } If the first line still does not fit on a single line, split after the :, and\\nuse block indentation. If the type requires multiple lines, even after\\nline-breaking after the :, then place the first line on the same line as the :, subject to the combining rules. #![allow(unused)] fn main() {\\nlet pattern: Type = expr; } e.g, #![allow(unused)] fn main() {\\nlet Foo { f: abcd, g: qwer,\\n}: Foo<Bar> = Foo { f, g }; let (abcd, defg): Baz =\\n{ ... } } If the expression covers multiple lines, if the first line of the expression\\nfits in the remaining space, it stays on the same line as the =, and the rest\\nof the expression is not further indented. If the first line does not fit, then\\nput the expression on subsequent lines, block indented. If the expression is a\\nblock and the type or pattern cover multiple lines, put the opening brace on a\\nnew line and not indented (this provides separation for the interior of the\\nblock from the type); otherwise, the opening brace follows the =. Examples: #![allow(unused)] fn main() {\\nlet foo = Foo { f: abcd, g: qwer,\\n}; let foo = ALongName { f: abcd, g: qwer, }; let foo: Type = { an_expression(); ...\\n}; let foo: ALongType =\\n{ an_expression(); ...\\n}; let Foo { f: abcd, g: qwer,\\n}: Foo<Bar> = Foo { f: blimblimblim, g: blamblamblam,\\n}; let Foo { f: abcd, g: qwer,\\n}: Foo<Bar> = foo( blimblimblim, blamblamblam,\\n); }","breadcrumbs":"Statements » Let statements","id":"45","title":"Let statements"},"46":{"body":"A let statement can contain an else component, making it a let-else statement.\\nIn this case, always apply the same formatting rules to the components preceding\\nthe else block (i.e. the let pattern: Type = initializer_expr portion)\\nas described for other let statements. Format the entire let-else statement on a single line if all the following are\\ntrue: the entire statement is short the else block contains only a single-line expression and no statements the else block contains no comments the let statement components preceding the else block can be formatted on a single line #![allow(unused)] fn main() {\\nlet Some(1) = opt else { return }; } Otherwise, the let-else statement requires some line breaks. If breaking a let-else statement across multiple lines, never break between the else and the {, and always break before the }. If the let statement components preceding the else can be formatted on a\\nsingle line, but the let-else does not qualify to be placed entirely on a\\nsingle line, put the else { on the same line as the initializer expression,\\nwith a space between them, then break the line after the {. Indent the\\nclosing } to match the let, and indent the contained block one step\\nfurther. #![allow(unused)] fn main() {\\nlet Some(1) = opt else { return;\\n}; let Some(1) = opt else { // nope return\\n}; } If the let statement components preceding the else can be formatted on a\\nsingle line, but the else { does not fit on the same line, break the line\\nbefore the else. #![allow(unused)] fn main() { let Some(x) = some_really_really_really_really_really_really_really_really_really_long_name else { return; }; } If the initializer expression is multi-line, put the else keyword and opening\\nbrace of the block (i.e. else {) on the same line as the end of the\\ninitializer expression, with a space between them, if and only if all the\\nfollowing are true: The initializer expression ends with one or more closing\\nparentheses, square brackets, and/or braces There is nothing else on that line That line has the same indentation level as the initial let keyword. For example: #![allow(unused)] fn main() {\\nlet Some(x) = y.foo( \\"abc\\", fairly_long_identifier, \\"def\\", \\"123456\\", \\"string\\", \\"cheese\\",\\n) else { bar()\\n} } Otherwise, put the else keyword and opening brace on the next line after the\\nend of the initializer expression, with the else keyword at the same\\nindentation level as the let keyword. For example: fn main() { let Some(x) = abcdef() .foo( \\"abc\\", some_really_really_really_long_ident, \\"ident\\", \\"123456\\", ) .bar() .baz() .qux(\\"fffffffffffffffff\\") else { return }; let Some(aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa) = bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb else { return; }; let LongStructName(AnotherStruct { multi, line, pattern, }) = slice.as_ref() else { return; }; let LongStructName(AnotherStruct { multi, line, pattern, }) = multi_line_function_call( arg1, arg2, arg3, arg4, ) else { return; };\\n}","breadcrumbs":"Statements » else blocks (let-else statements)","id":"46","title":"else blocks (let-else statements)"},"47":{"body":"For a macro use in statement position, use parentheses or square brackets as\\ndelimiters, and terminate it with a semicolon. Do not put spaces around the\\nname, !, the delimiters, or the ;. #![allow(unused)] fn main() {\\n// A comment.\\na_macro!(...); }","breadcrumbs":"Statements » Macros in statement position","id":"47","title":"Macros in statement position"},"48":{"body":"Do not put space between the expression and the semicolon. <expr>; Terminate all expressions in statement position with a semicolon, unless they\\nend with a block or are used as the value for a block. E.g., #![allow(unused)] fn main() {\\n{ an_expression(); expr_as_value()\\n} return foo(); loop { break;\\n} } Use a semicolon where an expression has void type, even if it could be\\npropagated. E.g., #![allow(unused)] fn main() {\\nfn foo() { ... } fn bar() { foo();\\n} }","breadcrumbs":"Statements » Expressions in statement position","id":"48","title":"Expressions in statement position"},"49":{"body":"","breadcrumbs":"Expressions » Expressions","id":"49","title":"Expressions"},"5":{"body":"Use spaces, not tabs. Each level of indentation must be 4 spaces (that is, all indentation\\noutside of string literals and comments must be a multiple of 4). The maximum width for a line is 100 characters. Block indent Prefer block indent over visual indent: #![allow(unused)] fn main() {\\n// Block indent\\na_function_call( foo, bar,\\n); // Visual indent\\na_function_call(foo, bar); } This makes for smaller diffs (e.g., if a_function_call is renamed in the above\\nexample) and less rightward drift.","breadcrumbs":"Introduction » Indentation and line width","id":"5","title":"Indentation and line width"},"50":{"body":"A block expression must have a newline after the initial { and before the\\nterminal }, unless it qualifies to be written as a single line based on\\nanother style rule. A keyword before the block (such as unsafe or async) must be on the same\\nline as the opening brace, with a single space between the keyword and the\\nopening brace. Indent the contents of the block. #![allow(unused)] fn main() {\\nfn block_as_stmt() { a_call(); { a_call_inside_a_block(); // a comment in a block the_value }\\n} fn block_as_expr() { let foo = { a_call_inside_a_block(); // a comment in a block the_value };\\n} fn unsafe_block_as_stmt() { a_call(); unsafe { a_call_inside_a_block(); // a comment in a block the_value }\\n} } If a block has an attribute, put it on its own line before the block: #![allow(unused)] fn main() {\\nfn block_as_stmt() { #[an_attribute] { #![an_inner_attribute] // a comment in a block the_value }\\n} } Avoid writing comments on the same lines as either of the braces. Write an empty block as {}. Write a block on a single line if: it is either used in expression position (not statement position) or is an\\nunsafe block in statement position, it contains a single-line expression and no statements, and it contains no comments For a single-line block, put spaces after the opening brace and before the\\nclosing brace. Examples: fn main() { // Single line let _ = { a_call() }; let _ = unsafe { a_call() }; // Not allowed on one line // Statement position. { a_call() } // Contains a statement let _ = { a_call(); }; unsafe { a_call(); } // Contains a comment let _ = { // A comment }; let _ = { // A comment a_call() }; // Multiple lines let _ = { a_call(); another_call() }; let _ = { a_call( an_argument, another_arg, ) };\\n}","breadcrumbs":"Expressions » Blocks","id":"50","title":"Blocks"},"51":{"body":"Don’t put any extra spaces before the first | (unless the closure is prefixed\\nby a keyword such as move); put a space between the second | and the\\nexpression of the closure. Between the |s, use function definition syntax,\\nbut elide types where possible. Use closures without the enclosing {}, if possible. Add the {} when you have\\na return type, when there are statements, when there are comments inside the\\nclosure, or when the body expression is a control-flow expression that spans\\nmultiple lines. If using braces, follow the rules above for blocks. Examples: #![allow(unused)] fn main() {\\n|arg1, arg2| expr move |arg1: i32, arg2: i32| -> i32 { expr1; expr2\\n} || Foo { field1, field2: 0,\\n} || { if true { blah } else { boo }\\n} |x| unsafe { expr\\n} }","breadcrumbs":"Expressions » Closures","id":"51","title":"Closures"},"52":{"body":"If a struct literal is small, format it on a single line, and do not use a\\ntrailing comma. If not, split it across multiple lines, with each field on its\\nown block-indented line, and use a trailing comma. For each field: value entry, put a space after the colon only. Put a space before the opening brace. In the single-line form, put spaces after\\nthe opening brace and before the closing brace. #![allow(unused)] fn main() {\\nFoo { field1, field2: 0 }\\nlet f = Foo { field1, field2: an_expr,\\n}; } Functional record update syntax is treated like a field, but it must never have\\na trailing comma. Do not put a space after ... #![allow(unused)] fn main() {\\nlet f = Foo { field1, ..an_expr\\n}; }","breadcrumbs":"Expressions » Struct literals","id":"52","title":"Struct literals"},"53":{"body":"Never break between the opening and closing parentheses of the () unit literal.","breadcrumbs":"Expressions » Unit literals","id":"53","title":"Unit literals"},"54":{"body":"Use a single-line form where possible. Do not put spaces between the opening\\nparenthesis and the first element, or between the last element and the closing\\nparenthesis. Separate elements with a comma followed by a space. Where a single-line form is not possible, write the tuple across\\nmultiple lines, with each element of the tuple on its own block-indented line,\\nand use a trailing comma. #![allow(unused)] fn main() {\\n(a, b, c) let x = ( a_long_expr, another_very_long_expr,\\n); }","breadcrumbs":"Expressions » Tuple literals","id":"54","title":"Tuple literals"},"55":{"body":"Do not put space between the identifier and the opening parenthesis. Otherwise,\\nfollow the rules for tuple literals: #![allow(unused)] fn main() {\\nFoo(a, b, c) let x = Foo( a_long_expr, another_very_long_expr,\\n); }","breadcrumbs":"Expressions » Tuple struct literals","id":"55","title":"Tuple struct literals"},"56":{"body":"Follow the formatting rules for the various struct literals. Prefer using the\\nname of the enum as a qualifying name, unless the enum is in the prelude: #![allow(unused)] fn main() {\\nFoo::Bar(a, b)\\nFoo::Baz { field1, field2: 1001,\\n}\\nOk(an_expr) }","breadcrumbs":"Expressions » Enum literals","id":"56","title":"Enum literals"},"57":{"body":"Write small array literals on a single line. Do not put spaces between the opening\\nsquare bracket and the first element, or between the last element and the closing\\nsquare bracket. Separate elements with a comma followed by a space. If using the repeating initializer, put a space after the semicolon\\nonly. Apply the same rules if using vec! or similar array-like macros; always use\\nsquare brackets with such macros. Examples: fn main() { let x = [1, 2, 3]; let y = vec![a, b, c, d]; let a = [42; 10];\\n} For arrays that have to be broken across lines, if using the repeating\\ninitializer, break after the ;, not before. Otherwise, follow the rules below\\nfor function calls. In any case, block-indent the contents of the initializer,\\nand put line breaks after the opening square bracket and before the closing\\nsquare bracket: fn main() { [ a_long_expression(); 1234567890 ] let x = [ an_expression, another_expression, a_third_expression, ];\\n}","breadcrumbs":"Expressions » Array literals","id":"57","title":"Array literals"},"58":{"body":"Don’t put spaces around the square brackets. Avoid breaking lines if possible.\\nNever break a line between the target expression and the opening square\\nbracket. If the indexing expression must be broken onto a subsequent line, or\\nspans multiple lines itself, then block-indent the indexing expression, and put\\nnewlines after the opening square bracket and before the closing square\\nbracket: Examples: fn main() { foo[42]; &foo[..10]; bar[0..100]; foo[4 + 5 / bar]; a_long_target[ a_long_indexing_expression ];\\n}","breadcrumbs":"Expressions » Array accesses, indexing, and slicing","id":"58","title":"Array accesses, indexing, and slicing"},"59":{"body":"Do not include a space between a unary op and its operand (i.e., !x, not ! x). However, there must be a space after &mut. Avoid line-breaking\\nbetween a unary operator and its operand.","breadcrumbs":"Expressions » Unary operations","id":"59","title":"Unary operations"},"6":{"body":"In comma-separated lists of any kind, use a trailing comma when followed by a\\nnewline: #![allow(unused)] fn main() {\\nfunction_call( argument, another_argument,\\n); let array = [ element, another_element, yet_another_element,\\n]; } This makes moving code (e.g., by copy and paste) easier, and makes diffs\\nsmaller, as appending or removing items does not require modifying another line\\nto add or remove a comma.","breadcrumbs":"Introduction » Trailing commas","id":"6","title":"Trailing commas"},"60":{"body":"Do include spaces around binary ops (i.e., x + 1, not x+1) (including =\\nand other assignment operators such as += or *=). For comparison operators, because for T op U, &T op &U is also implemented:\\nif you have t: &T, and u: U, prefer *t op u to t op &u. In general,\\nwithin expressions, prefer dereferencing to taking references, unless necessary\\n(e.g. to avoid an unnecessarily expensive operation). Use parentheses liberally; do not necessarily elide them due to precedence.\\nTools should not automatically insert or remove parentheses. Do not use spaces\\nto indicate precedence. If line-breaking, block-indent each subsequent line. For assignment operators,\\nbreak after the operator; for all other operators, put the operator on the\\nsubsequent line. Put each sub-expression on its own line: #![allow(unused)] fn main() {\\nfoo_bar + bar + baz + qux + whatever } Prefer line-breaking at an assignment operator (either = or +=, etc.) rather\\nthan at other binary operators.","breadcrumbs":"Expressions » Binary operations","id":"60","title":"Binary operations"},"61":{"body":"Format as casts like a binary operator. In particular, always include spaces\\naround as, and if line-breaking, break before the as (never after) and\\nblock-indent the subsequent line. Format the type on the right-hand side using\\nthe rules for types. However, unlike with other binary operators, if chaining a series of as casts\\nthat require line-breaking, and line-breaking before the first as suffices to\\nmake the remainder fit on the next line, don’t break before any subsequent as; instead, leave the series of types all on the same line: #![allow(unused)] fn main() {\\nlet cstr = very_long_expression() as *const str as *const [u8] as *const std::os::raw::c_char; } If the subsequent line still requires line-breaking, break and block-indent\\nbefore each as as with other binary operators.","breadcrumbs":"Expressions » Casts ( as)","id":"61","title":"Casts ( as)"},"62":{"body":"Do not include extraneous parentheses for if and while expressions. #![allow(unused)] fn main() {\\nif true {\\n} } is better than #![allow(unused)] fn main() {\\nif (true) {\\n} } Do include extraneous parentheses if it makes an arithmetic or logic expression\\neasier to understand ( (x * 15) + (y * 20) is fine)","breadcrumbs":"Expressions » Control flow","id":"62","title":"Control flow"},"63":{"body":"Do not put a space between the function name, and the opening parenthesis. Do not put a space between an argument, and the comma which follows. Do put a space between an argument, and the comma which precedes it. Prefer not to break a line in the callee expression. For a function call with no arguments (a nullary function call like func()),\\nnever break within the parentheses, and never put a space between the\\nparentheses. Always write a nullary function call as a single-line call, never\\na multi-line call.","breadcrumbs":"Expressions » Function calls","id":"63","title":"Function calls"},"64":{"body":"Do not put a space between the function name and open paren, between the open\\nparen and the first argument, or between the last argument and the close paren. Do not put a comma after the last argument. #![allow(unused)] fn main() {\\nfoo(x, y, z) }","breadcrumbs":"Expressions » Single-line calls","id":"64","title":"Single-line calls"},"65":{"body":"If the function call is not small, it would otherwise over-run the max width,\\nor any argument or the callee is multi-line, then format the call across\\nmultiple lines. In this case, put each argument on its own block-indented line,\\nbreak after the opening parenthesis and before the closing parenthesis,\\nand use a trailing comma: #![allow(unused)] fn main() {\\na_function_call( arg1, a_nested_call(a, b),\\n) }","breadcrumbs":"Expressions » Multi-line calls","id":"65","title":"Multi-line calls"},"66":{"body":"Follow the function rules for calling. Do not put any spaces around the .. #![allow(unused)] fn main() {\\nx.foo().bar().baz(x, y, z); }","breadcrumbs":"Expressions » Method calls","id":"66","title":"Method calls"},"67":{"body":"If a macro can be parsed like other constructs, format it like those\\nconstructs. For example, a macro use foo!(a, b, c) can be parsed like a\\nfunction call (ignoring the !), so format it using the rules for function\\ncalls. The style guide defines specific formatting for particular macros in the\\nlanguage or standard library. The style guide does not define formatting for\\nany third-party macros, even if similar to those in the language or standard\\nlibrary.","breadcrumbs":"Expressions » Macro uses","id":"67","title":"Macro uses"},"68":{"body":"For macros which take a format string, if all other arguments are small,\\nformat the arguments before the format string on a single line if they fit, and\\nformat the arguments after the format string on a single line if they fit, with\\nthe format string on its own line. If the arguments are not small or do not\\nfit, put each on its own line as with a function. For example: #![allow(unused)] fn main() {\\nprintln!( \\"Hello {} and {}\\", name1, name2,\\n); assert_eq!( x, y, \\"x and y were not equal, see {}\\", reason,\\n); }","breadcrumbs":"Expressions » Format string macros","id":"68","title":"Format string macros"},"69":{"body":"A chain is a sequence of field accesses, method calls, and/or uses of the try\\noperator ?. E.g., a.b.c().d or foo?.bar().baz?. Format the chain on one line if it is “small” and otherwise possible to do so.\\nIf formatting on multiple lines, put each field access or method call in the\\nchain on its own line, with the line-break before the . and after any ?.\\nBlock-indent each subsequent line: #![allow(unused)] fn main() {\\nlet foo = bar .baz? .qux(); } If the length of the last line of the first element plus its indentation is\\nless than or equal to the indentation of the second line, then combine the\\nfirst and second lines if they fit. Apply this rule recursively. #![allow(unused)] fn main() {\\nx.baz? .qux() x.y.z .qux() let foo = x .baz? .qux(); foo( expr1, expr2,\\n).baz? .qux(); }","breadcrumbs":"Expressions » Chains of fields and method calls","id":"69","title":"Chains of fields and method calls"},"7":{"body":"Separate items and statements by either zero or one blank lines (i.e., one or\\ntwo newlines). E.g, #![allow(unused)] fn main() {\\nfn foo() { let x = ...; let y = ...; let z = ...;\\n} fn bar() {}\\nfn baz() {} }","breadcrumbs":"Introduction » Blank lines","id":"7","title":"Blank lines"},"70":{"body":"If any element in a chain is formatted across multiple lines, put that element\\nand any later elements on their own lines. #![allow(unused)] fn main() {\\na.b.c()? .foo( an_expr, another_expr, ) .bar .baz } Note there is block indent due to the chain and the function call in the above\\nexample. Prefer formatting the whole chain in multi-line style and each element on one\\nline, rather than putting some elements on multiple lines and some on a single\\nline, e.g., #![allow(unused)] fn main() {\\n// Better\\nself.pre_comment .as_ref() .map_or(false, |comment| comment.starts_with(\\"//\\")) // Worse\\nself.pre_comment.as_ref().map_or( false, |comment| comment.starts_with(\\"//\\"),\\n) }","breadcrumbs":"Expressions » Multi-line elements","id":"70","title":"Multi-line elements"},"71":{"body":"This section covers for and loop expressions, as well as if and while\\nexpressions with their sub-expression variants. This includes those with a\\nsingle let sub-expression (i.e. if let and while let)\\nas well as “let-chains”: those with one or more let sub-expressions and\\none or more bool-type conditions (i.e. if a && let Some(b) = c). Put the keyword, any initial clauses, and the opening brace of the block all on\\na single line, if they fit. Apply the usual rules for block\\nformatting to the block. If there is an else component, then put the closing brace, else, any\\nfollowing clause, and the opening brace all on the same line, with a single\\nspace before and after the else keyword: #![allow(unused)] fn main() {\\nif ... { ...\\n} else { ...\\n} if let ... { ...\\n} else if ... { ...\\n} else { ...\\n} } If the control line needs to be broken, then prefer breaking after the = for any let sub-expression in an if or while expression that does not fit,\\nand before in in a for expression; the following line should be block indented.\\nIf the control line is broken for any reason, then the opening brace should be on its\\nown line and not indented. Examples: #![allow(unused)] fn main() {\\nwhile let Some(foo) = a_long_expression\\n{ ...\\n} for foo in a_long_expression\\n{ ...\\n} if a_long_expression && another_long_expression || a_third_long_expression\\n{ ...\\n} if let Some(a) = b && another_long_expression && a_third_long_expression\\n{ // ...\\n} if let Some(relatively_long_thing) = a_long_expression && another_long_expression && a_third_long_expression\\n{ // ...\\n} if some_expr && another_long_expression && let Some(relatively_long_thing) = a_long_long_long_long_long_long_really_reallllllllllyyyyyyy_long_expression && a_third_long_expression\\n{ // ...\\n} } A let-chain control line is allowed to be formatted on a single line provided\\nit only consists of two clauses, with the first, left-hand side operand being a literal or an ident (which can optionally be preceded by any number of unary prefix operators),\\nand the second, right-hand side operand being a single-line let clause. Otherwise,\\nthe control line must be broken and formatted according to the above rules. For example: #![allow(unused)] fn main() {\\nif a && let Some(b) = foo() { // ...\\n} if true && let Some(b) = foo() { // ...\\n} let operator = if !from_hir_call && let Some(p) = parent { // ...\\n}; if let Some(b) = foo() && a\\n{ // ..\\n} if foo() && let Some(b) = bar\\n{ // ...\\n} if gen_pos != GenericArgPosition::Type && let Some(b) = gen_args.bindings.first()\\n{ // ..\\n} } Where the initial clause spans multiple lines and ends with one or more closing\\nparentheses, square brackets, or braces, and there is nothing else on that\\nline, and that line is not indented beyond the indent on the first line of the\\ncontrol flow expression, then put the opening brace of the block on the same\\nline with a preceding space. For example: #![allow(unused)] fn main() {\\nif !self.config.file_lines().intersects( &self.codemap.lookup_line_range( stmt.span, ),\\n) { // Opening brace on same line as initial clause. ...\\n} }","breadcrumbs":"Expressions » Control flow expressions","id":"71","title":"Control flow expressions"},"72":{"body":"Put an if else or if let else on a single line if it occurs in expression\\ncontext (i.e., is not a standalone statement), it contains a single else\\nclause, and is small: #![allow(unused)] fn main() {\\nlet y = if x { 0 } else { 1 }; // Examples that must be multi-line.\\nlet y = if something_very_long { not_small\\n} else { also_not_small\\n}; if x { 0\\n} else { 1\\n} }","breadcrumbs":"Expressions » Single line if else","id":"72","title":"Single line if else"},"73":{"body":"Prefer not to line-break inside the discriminant expression. Always break after\\nthe opening brace and before the closing brace. Block-indent the match arms\\nonce: #![allow(unused)] fn main() {\\nmatch foo { // arms\\n} let x = match foo.bar.baz() { // arms\\n}; } Use a trailing comma for a match arm if and only if not using a block. Never start a match arm pattern with |: #![allow(unused)] fn main() {\\nmatch foo { // Don\'t do this. | foo => bar, // Or this. | a_very_long_pattern | another_pattern | yet_another_pattern | a_fourth_pattern => { ... }\\n} } Prefer: #![allow(unused)] fn main() {\\nmatch foo { foo => bar, a_very_long_pattern | another_pattern | yet_another_pattern | a_fourth_pattern => { ... }\\n} } Avoid splitting the left-hand side (before the =>) of a match arm where\\npossible. If the right-hand side of the match arm is kept on the same line,\\nnever use a block (unless the block is empty). If the right-hand side consists of multiple statements, or has line comments,\\nor the start of the line does not fit on the same line as the left-hand side,\\nuse a block. Do not flatten a right-hand side block containing a single macro call\\nbecause its expanded form could contain a trailing semicolon. Block-indent the body of a block arm. Examples: #![allow(unused)] fn main() {\\nmatch foo { foo => bar, a_very_long_pattern | another_pattern if an_expression() => { no_room_for_this_expression() } foo => { // A comment. an_expression() } foo => { let a = statement(); an_expression() } bar => {} // Trailing comma on last item. foo => bar, baz => qux!(), lorem => { ipsum!() }\\n} } If the body is a single expression with no line comments and not a control flow\\nexpression, start it on the same line as the left-hand side. If not, then it\\nmust be in a block. Example: #![allow(unused)] fn main() {\\nmatch foo { // A combinable expression. foo => a_function_call(another_call( argument1, argument2, )), // A non-combinable expression bar => { a_function_call( another_call( argument1, argument2, ), another_argument, ) }\\n} }","breadcrumbs":"Expressions » Match","id":"73","title":"Match"},"74":{"body":"If using a block form on the right-hand side of a match arm makes it possible\\nto avoid breaking on the left-hand side, do that: #![allow(unused)] fn main() { // Assuming the following line does not fit in the max width a_very_long_pattern | another_pattern => ALongStructName { ... }, // Prefer this a_very_long_pattern | another_pattern => { ALongStructName { ... } } // To splitting the pattern. } Never break after => without using the block form of the body. If the left-hand side must be split and there is an if clause, break before\\nthe if and block indent. In this case, always use a block body and start the\\nbody on a new line: #![allow(unused)] fn main() { a_very_long_pattern | another_pattern if expr => { ... } } If required to break the pattern, put each clause of the pattern on its own\\nline with no additional indent, breaking before the |. If there is an if\\nclause, use the above form: #![allow(unused)] fn main() { a_very_long_pattern | another_pattern | yet_another_pattern | a_forth_pattern => { ... } a_very_long_pattern | another_pattern | yet_another_pattern | a_forth_pattern if expr => { ... } } If the pattern is multi-line, and the last line is less wide than the indent, do\\nnot put the if clause on a new line. E.g., #![allow(unused)] fn main() { Token::Dimension { value, ref unit, .. } if num_context.is_ok(context.parsing_mode, value) => { ... } } If every clause in a pattern is small, but the whole pattern does not fit on\\none line, then format the pattern across multiple lines with as many clauses\\nper line as possible. Again, break before a |: #![allow(unused)] fn main() { foo | bar | baz | qux => { ... } } We define a pattern clause to be small if it fits on a single line and\\nmatches “small” in the following grammar: small: - small_no_tuple - unary tuple constructor: `(` small_no_tuple `,` `)` - `&` small small_no_tuple: - single token - `&` small_no_tuple E.g., &&Some(foo) matches, Foo(4, Bar) does not.","breadcrumbs":"Expressions » Line-breaking","id":"74","title":"Line-breaking"},"75":{"body":"Where a function call has a single argument, and that argument is formatted\\nacross multiple-lines, format the outer call as if it were a single-line call,\\nif the result fits. Apply the same combining behaviour to any similar\\nexpressions which have multi-line, block-indented lists of sub-expressions\\ndelimited by parentheses (e.g., macros or tuple struct literals). E.g., #![allow(unused)] fn main() {\\nfoo(bar( an_expr, another_expr,\\n)) let x = foo(Bar { field: whatever,\\n}); foo(|param| { action(); foo(param)\\n}) let x = combinable([ an_expr, another_expr,\\n]); let arr = [combinable( an_expr, another_expr,\\n)]; } Apply this behavior recursively. For a function with multiple arguments, if the last argument is a multi-line\\nclosure with an explicit block, there are no other closure arguments, and all\\nthe arguments and the first line of the closure fit on the first line, use the\\nsame combining behavior: #![allow(unused)] fn main() {\\nfoo(first_arg, x, |param| { action(); foo(param)\\n}) }","breadcrumbs":"Expressions » Combinable expressions","id":"75","title":"Combinable expressions"},"76":{"body":"Do not put spaces in ranges, e.g., 0..10, x..=y, ..x.len(), foo... When writing a range with both upper and lower bounds, if the line must be\\nbroken within the range, break before the range operator and block indent the\\nsecond line: #![allow(unused)] fn main() {\\na_long_expression ..another_long_expression } For the sake of indicating precedence, if either bound is a compound\\nexpression, use parentheses around it, e.g., ..(x + 1), (x.f)..(x.f.len()),\\nor 0..(x - 10).","breadcrumbs":"Expressions » Ranges","id":"76","title":"Ranges"},"77":{"body":"Hexadecimal literals may use upper- or lower-case letters, but they must not be\\nmixed within the same literal. Projects should use the same case for all\\nliterals, but we do not make a recommendation for either lower- or upper-case.","breadcrumbs":"Expressions » Hexadecimal literals","id":"77","title":"Hexadecimal literals"},"78":{"body":"Format patterns like their corresponding expressions. See the section on match for additional formatting for patterns in match arms.","breadcrumbs":"Expressions » Patterns","id":"78","title":"Patterns"},"79":{"body":"","breadcrumbs":"Types and Bounds » Types and Bounds","id":"79","title":"Types and Bounds"},"8":{"body":"Do not include trailing whitespace on the end of any line. This includes blank\\nlines, comment lines, code lines, and string literals. Note that avoiding trailing whitespace in string literals requires care to\\npreserve the value of the literal.","breadcrumbs":"Introduction » Trailing whitespace","id":"8","title":"Trailing whitespace"},"80":{"body":"[T] no spaces [T; expr], e.g., [u32; 42], [Vec<Foo>; 10 * 2 + foo()] (space after colon, no spaces around square brackets) *const T, *mut T (no space after *, space before type) &\'a T, &T, &\'a mut T, &mut T (no space after &, single spaces separating other words) unsafe extern \\"C\\" fn<\'a, \'b, \'c>(T, U, V) -> W or fn() (single spaces around keywords and sigils, and after commas, no trailing commas, no spaces around brackets) ! gets treated like any other type name, Name (A, B, C, D) (spaces after commas, no spaces around parens, no trailing comma unless it is a one-tuple) <Baz<T> as SomeTrait>::Foo::Bar or Foo::Bar or ::Foo::Bar (no spaces around :: or angle brackets, single spaces around as) Foo::Bar<T, U, V> (spaces after commas, no trailing comma, no spaces around angle brackets) T + T + T (single spaces between types, and +). impl T + T + T (single spaces between keyword, types, and +). Do not put space around parentheses used in types, e.g., (Foo)","breadcrumbs":"Types and Bounds » Single line formatting","id":"80","title":"Single line formatting"},"81":{"body":"Avoid breaking lines in types where possible. Prefer breaking at outermost scope, e.g., prefer #![allow(unused)] fn main() {\\nFoo< Bar, Baz<Type1, Type2>,\\n> } to #![allow(unused)] fn main() {\\nFoo<Bar, Baz< Type1, Type2,\\n>> } If a type requires line-breaks in order to fit, this section outlines where to\\nbreak such types if necessary. Break [T; expr] after the ; if necessary. Break function types following the rules for function declarations. Break generic types following the rules for generics. Break types with + by breaking before the + and block-indenting the\\nsubsequent lines. When breaking such a type, break before every +: #![allow(unused)] fn main() {\\nimpl Clone + Copy + Debug Box< Clone + Copy + Debug\\n> }","breadcrumbs":"Types and Bounds » Line breaks","id":"81","title":"Line breaks"},"82":{"body":"A use<\'a, T> precise capturing bound is formatted as if it were a single path segment with non-turbofished angle-bracketed args, like a trait bound whose identifier is use. #![allow(unused)] fn main() {\\nfn foo() -> impl Sized + use<\'a> {} // is formatted analogously to: fn foo() -> impl Sized + Use<\'a> {} }","breadcrumbs":"Types and Bounds » Precise capturing bounds","id":"82","title":"Precise capturing bounds"},"83":{"body":"","breadcrumbs":"Other style advice » Other style advice","id":"83","title":"Other style advice"},"84":{"body":"Prefer to use Rust’s expression oriented nature where possible; #![allow(unused)] fn main() {\\n// use\\nlet x = if y { 1 } else { 0 };\\n// not\\nlet x;\\nif y { x = 1;\\n} else { x = 0;\\n} }","breadcrumbs":"Other style advice » Expressions","id":"84","title":"Expressions"},"85":{"body":"Types shall be UpperCamelCase, Enum variants shall be UpperCamelCase, Struct fields shall be snake_case, Function and method names shall be snake_case, Local variables shall be snake_case, Macro names shall be snake_case, Constants ( consts and immutable statics) shall be SCREAMING_SNAKE_CASE. When a name is forbidden because it is a reserved word (such as crate),\\neither use a raw identifier ( r#crate) or use a trailing underscore\\n( crate_). Don’t misspell the word ( krate).","breadcrumbs":"Other style advice » Names","id":"85","title":"Names"},"86":{"body":"Avoid #[path] annotations where possible.","breadcrumbs":"Other style advice » Modules","id":"86","title":"Modules"},"87":{"body":"","breadcrumbs":"Cargo.toml conventions » Cargo.toml conventions","id":"87","title":"Cargo.toml conventions"},"88":{"body":"Use the same line width and indentation as Rust code. Put a blank line between the last key-value pair in a section and the header of\\nthe next section. Do not place a blank line between section headers and the\\nkey-value pairs in that section, or between key-value pairs in a section. Version-sort key names within each section, with the exception of the [package] section. Put the [package] section at the top of the file; put\\nthe name and version keys in that order at the top of that section,\\nfollowed by the remaining keys other than description in order, followed by\\nthe description at the end of that section. Don’t use quotes around any standard key names; use bare keys. Only use quoted\\nkeys for non-standard keys whose names require them, and avoid introducing such\\nkey names when possible. See the TOML\\nspecification for details. Put a single space both before and after the = between a key and value. Do\\nnot indent any key names; start all key names at the start of a line. Use multi-line strings (rather than newline escape sequences) for any string\\nvalues that include multiple lines, such as the crate description. For array values, such as a list of features, put the entire list on the same\\nline as the key, if it fits. Otherwise, use block indentation: put a newline\\nafter the opening square bracket, indent each item by one indentation level,\\nput a comma after each item (including the last), and put the closing square\\nbracket at the start of a line by itself after the last item. #![allow(unused)] fn main() {\\nsome_feature = [ \\"another_feature\\", \\"yet_another_feature\\", \\"some_dependency?/some_feature\\",\\n] } For table values, such as a crate dependency with a path, write the entire\\ntable using curly braces and commas on the same line as the key if it fits. If\\nthe entire table does not fit on the same line as the key, separate it out into\\na separate section with key-value pairs: [dependencies]\\ncrate1 = { path = \\"crate1\\", version = \\"1.2.3\\" } [dependencies.extremely_long_crate_name_goes_here]\\npath = \\"extremely_long_path_name_goes_right_here\\"\\nversion = \\"4.5.6\\"","breadcrumbs":"Cargo.toml conventions » Formatting conventions","id":"88","title":"Formatting conventions"},"89":{"body":"The authors list, if present, should consist of strings that each contain an\\nauthor name followed by an email address in angle brackets: Full Name <email@address>. It should not contain bare email addresses, or names without\\nemail addresses. (The authors list may also include a mailing list address\\nwithout an associated name.) The license field must contain a valid SPDX\\nexpression,\\nusing valid SPDX license names. (As an exception,\\nby widespread convention, the license field may use / in place of OR; for\\nexample, MIT/Apache-2.0.) The homepage field, if present, must consist of a single URL, including the\\nscheme (e.g. https://example.org/, not just example.org.) Within the description field, wrap text at 80 columns. Don’t start the\\ndescription field with the name of the crate (e.g. “cratename is a …”); just\\ndescribe the crate itself. If providing a multi-sentence description, the first\\nsentence should go on a line by itself and summarize the crate, like the\\nsubject of an email or commit message; subsequent sentences can then describe\\nthe crate in more detail.","breadcrumbs":"Cargo.toml conventions » Metadata conventions","id":"89","title":"Metadata conventions"},"9":{"body":"In various cases, the default Rust style specifies to sort things. If not\\notherwise specified, such sorting should be “version sorting”, which ensures\\nthat (for instance) x8 comes before x16 even though the character 1 comes\\nbefore the character 8. For the purposes of the Rust style, to compare two strings for version-sorting: Process both strings from beginning to end as two sequences of maximal-length\\nchunks, where each chunk consists either of a sequence of characters other\\nthan ASCII digits, or a sequence of ASCII digits (a numeric chunk), and\\ncompare corresponding chunks from the strings. To compare two numeric chunks, compare them by numeric value, ignoring\\nleading zeroes. If the two chunks have equal numeric value, but different\\nnumbers of leading digits, and this is the first time this has happened for\\nthese strings, treat the chunks as equal (moving on to the next chunk) but\\nremember which string had more leading zeroes. To compare two chunks if both are not numeric, compare them by Unicode\\ncharacter lexicographically, with two exceptions: _ (underscore) sorts immediately after (space) but before any other\\ncharacter. (This treats underscore as a word separator, as commonly used in\\nidentifiers.) Unless otherwise specified, version-sorting should sort non-lowercase\\ncharacters (characters that can start an UpperCamelCase identifier)\\nbefore lowercase characters. If the comparison reaches the end of the string and considers each pair of\\nchunks equal: If one of the numeric comparisons noted the earliest point at which one\\nstring had more leading zeroes than the other, sort the string with more\\nleading zeroes first. Otherwise, the strings are equal. Note that there exist various algorithms called “version sorting”, which\\ngenerally try to solve the same problem, but which differ in various ways (such\\nas in their handling of numbers with leading zeroes). This algorithm\\ndoes not purport to precisely match the behavior of any particular other\\nalgorithm, only to produce a simple and satisfying result for Rust formatting.\\nIn particular, this algorithm aims to produce a satisfying result for a set of\\nsymbols that have the same number of leading zeroes, and an acceptable and\\neasily understandable result for a set of symbols that has varying numbers of\\nleading zeroes. As an example, version-sorting will sort the following strings in the order\\ngiven: _ZYXW _abcd A2 ABCD Z_YXW ZY_XW ZY_XW ZYXW ZYXW_ a1 abcd u_zzz u8 u16 u32 u64 u128 u256 ua usize uz v000 v00 v0 v0s v00t v0u v001 v01 v1 v009 v09 v9 v010 v10 w005s09t w5s009t x64 x86 x86_32 x86_64 x86_128 x87 zyxw","breadcrumbs":"Introduction » Sorting","id":"9","title":"Sorting"},"90":{"body":"When deciding on style guidelines, the style team follows these guiding\\nprinciples (in rough priority order): readability scan-ability avoiding misleading formatting accessibility - readable and editable by users using the widest\\nvariety of hardware, including non-visual accessibility interfaces readability of code in contexts without syntax highlighting or IDE\\nassistance, such as rustc error messages, diffs, grep, and other\\nplain-text contexts aesthetics sense of ‘beauty’ consistent with other languages/tools specifics compatibility with version control practices - preserving diffs,\\nmerge-friendliness, etc. preventing rightward drift minimising vertical space application ease of manual application ease of implementation (in rustfmt, and in other tools/editors/code generators) internal consistency simplicity of formatting rules","breadcrumbs":"Guiding principles and rationale » Guiding principles and rationale","id":"90","title":"Guiding principles and rationale"},"91":{"body":"The default Rust style evolves over time, as Rust does. However, to avoid\\nbreaking established code style, and CI jobs checking code style, changes to\\nthe default Rust style only appear in style editions. Code written in a given Rust edition\\nuses the corresponding Rust style edition by default. To make it easier to\\nmigrate code style separately from the semantic changes between Rust editions,\\nformatting tools such as rustfmt allow updating the style edition separately\\nfrom the Rust edition. The current version of the style guide describes the latest Rust style edition.\\nEach distinct past style will have a corresponding archived version of the\\nstyle guide. Note that archived versions of the style guide do not document formatting for\\nnewer Rust constructs that did not exist at the time that version of the style\\nguide was archived. However, each style edition will still format all\\nconstructs valid in that Rust edition, with the style of newer constructs\\ncoming from the first subsequent style edition providing formatting rules for\\nthat construct (without any of the systematic/global changes from that style\\nedition). Not all Rust editions have corresponding changes to the Rust style. For\\ninstance, Rust 2015, Rust 2018, and Rust 2021 all use the same style edition.","breadcrumbs":"Rust style editions » Rust style editions","id":"91","title":"Rust style editions"},"92":{"body":"Never break within a nullary function call func() or a unit literal ().","breadcrumbs":"Rust style editions » Rust next style edition","id":"92","title":"Rust next style edition"},"93":{"body":"This style guide describes the Rust 2024 style edition. The Rust 2024 style\\nedition is currently nightly-only and may change before the release of Rust\\n2024. For a full history of changes in the Rust 2024 style edition, see the git\\nhistory of the style guide. Notable changes in the Rust 2024 style edition\\ninclude: Miscellaneous rustfmt bugfixes. Use version-sort (sort x8, x16, x32, x64, x128 in that order). Change “ASCIIbetical” sort to Unicode-aware “non-lowercase before lowercase”.","breadcrumbs":"Rust style editions » Rust 2024 style edition","id":"93","title":"Rust 2024 style edition"},"94":{"body":"The archived version of the style guide at https://github.com/rust-lang/rust/tree/37343f4a4d4ed7ad0891cb79e8eb25acf43fb821/src/doc/style-guide/src\\ndescribes the style edition corresponding to Rust 2015, Rust 2018, and Rust\\n2021.","breadcrumbs":"Rust style editions » Rust 2015/2018/2021 style edition","id":"94","title":"Rust 2015/2018/2021 style edition"},"95":{"body":"This chapter documents style and formatting for nightly-only syntax. The rest of the style guide documents style for stable Rust syntax; nightly syntax only appears in this chapter. Each section here includes the name of the feature gate, so that searches (e.g. git grep) for a nightly feature in the Rust repository also turn up the style guide section. Style and formatting for nightly-only syntax should be removed from this chapter and integrated into the appropriate sections of the style guide at the time of stabilization. There is no guarantee of the stability of this chapter in contrast to the rest of the style guide. Refer to the style team policy for nightly formatting procedure regarding breaking changes to this chapter.","breadcrumbs":"Nightly-only syntax » Nightly","id":"95","title":"Nightly"},"96":{"body":"Location: Placed before comments and attributes in the root. Tracking issue: #136889 Feature gate: frontmatter There should be no blank lines between the frontmatter and either the start of the file or a shebang.\\nThere can be zero or one line between the frontmatter and any following content. The frontmatter fences should use the minimum number of dashes necessary for the contained content (one more than the longest series of initial dashes in the\\ncontent, with a minimum of 3 to be recognized as frontmatter delimiters).\\nIf an infostring is present after the opening fence, there should be one space separating them.\\nThe frontmatter fence lines should not have trailing whitespace. #!/usr/bin/env cargo\\n--- cargo\\n[dependencies]\\nregex = \\"1\\"\\n--- fn main() {}","breadcrumbs":"Nightly-only syntax » Frontmatter","id":"96","title":"Frontmatter"}},"length":97,"save":true},"fields":["title","body","breadcrumbs"],"index":{"body":{"root":{"0":{".":{".":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"76":{"tf":1.0}}}},"1":{"0":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":4,"docs":{"51":{"tf":1.0},"52":{"tf":1.0},"72":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}}},"1":{".":{"2":{".":{"3":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"0":{"1":{"df":1,"docs":{"56":{"tf":1.0}}},"df":2,"docs":{"14":{"tf":1.0},"5":{"tf":1.0}}},"df":3,"docs":{"57":{"tf":1.0},"76":{"tf":1.0},"80":{"tf":1.0}}},"1":{"df":1,"docs":{"23":{"tf":1.0}}},"2":{"3":{"4":{"5":{"6":{"7":{"8":{"9":{"0":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"46":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"6":{"8":{"8":{"9":{"df":1,"docs":{"96":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"df":1,"docs":{"62":{"tf":1.0}}},"df":7,"docs":{"57":{"tf":1.0},"60":{"tf":1.0},"72":{"tf":1.4142135623730951},"76":{"tf":1.0},"84":{"tf":1.4142135623730951},"9":{"tf":1.0},"96":{"tf":1.0}}},"2":{".":{"0":{"df":1,"docs":{"89":{"tf":1.0}}},"df":0,"docs":{}},"0":{"1":{"5":{"/":{"2":{"0":{"1":{"8":{"/":{"2":{"0":{"2":{"1":{"df":1,"docs":{"94":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"91":{"tf":1.0},"94":{"tf":1.0}}},"8":{"df":2,"docs":{"91":{"tf":1.0},"94":{"tf":1.0}}},"df":0,"docs":{}},"2":{"1":{"df":2,"docs":{"91":{"tf":1.0},"94":{"tf":1.0}}},"4":{"df":1,"docs":{"93":{"tf":2.449489742783178}}},"df":0,"docs":{}},"df":1,"docs":{"62":{"tf":1.0}}},"2":{"df":1,"docs":{"23":{"tf":1.4142135623730951}}},"df":2,"docs":{"57":{"tf":1.0},"80":{"tf":1.0}}},"3":{"3":{"df":1,"docs":{"23":{"tf":1.0}}},"df":2,"docs":{"57":{"tf":1.0},"96":{"tf":1.0}}},"4":{".":{"5":{".":{"6":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"df":3,"docs":{"15":{"tf":1.0},"57":{"tf":1.0},"80":{"tf":1.0}}},"df":1,"docs":{"5":{"tf":1.4142135623730951}}},"5":{"df":1,"docs":{"58":{"tf":1.0}}},"8":{"0":{"df":2,"docs":{"14":{"tf":1.7320508075688772},"89":{"tf":1.0}}},"df":1,"docs":{"9":{"tf":1.0}}},"_":{"a":{"b":{"c":{"d":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"50":{"tf":2.6457513110645907},"9":{"tf":1.0}},"z":{"df":0,"docs":{},"y":{"df":0,"docs":{},"x":{"df":0,"docs":{},"w":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"a":{".":{"b":{".":{"c":{"(":{")":{".":{"d":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"df":1,"docs":{"9":{"tf":1.0}}},"2":{"df":1,"docs":{"9":{"tf":1.0}}},":":{":":{"b":{":":{":":{"c":{"df":1,"docs":{"37":{"tf":1.0}}},"d":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{},"{":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":4,"docs":{"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0}}},"c":{":":{":":{"d":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"41":{"tf":1.0}}}}}},"{":{"b":{"df":2,"docs":{"41":{"tf":1.0},"43":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"50":{"tf":3.1622776601683795}},"l":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"_":{"a":{"_":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"50":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"74":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"73":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"5":{"tf":1.4142135623730951},"65":{"tf":1.0},"73":{"tf":1.0}},"l":{"(":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":2,"docs":{"54":{"tf":1.0},"55":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"57":{"tf":1.0},"71":{"tf":2.0},"76":{"tf":1.0}}}}}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"58":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"y":{"df":0,"docs":{},"y":{"df":0,"docs":{},"y":{"df":0,"docs":{},"y":{"df":0,"docs":{},"y":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"71":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}}}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"47":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"a":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"57":{"tf":1.0}}}}}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"71":{"tf":2.0}}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"73":{"tf":1.7320508075688772},"74":{"tf":2.23606797749979}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"b":{"c":{"d":{"df":2,"docs":{"45":{"tf":2.449489742783178},"9":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"46":{"tf":1.0}}}}},"df":1,"docs":{"46":{"tf":1.4142135623730951}}},"df":0,"docs":{},"i":{"df":2,"docs":{"21":{"tf":1.0},"36":{"tf":1.0}},"l":{"df":1,"docs":{"90":{"tf":1.0}}}},"o":{"df":0,"docs":{},"v":{"df":5,"docs":{"5":{"tf":1.0},"51":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.0}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"58":{"tf":1.0},"69":{"tf":1.4142135623730951},"90":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"71":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"24":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}}}}}},"d":{"d":{"df":2,"docs":{"51":{"tf":1.0},"6":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"74":{"tf":1.0},"78":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"34":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"89":{"tf":2.0}}}}}}},"df":2,"docs":{"1":{"tf":1.0},"2":{"tf":1.0}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"90":{"tf":1.0}}}}}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"25":{"tf":1.0},"74":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"9":{"tf":1.0}}}},"l":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":1,"docs":{"9":{"tf":2.0}}}}}}}}},"i":{"a":{"df":0,"docs":{},"s":{"df":3,"docs":{"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":53,"docs":{"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.0},"21":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.7320508075688772},"26":{"tf":1.4142135623730951},"27":{"tf":1.7320508075688772},"28":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.7320508075688772},"33":{"tf":1.4142135623730951},"34":{"tf":1.7320508075688772},"35":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"42":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":2.23606797749979},"46":{"tf":2.0},"47":{"tf":1.0},"48":{"tf":1.4142135623730951},"5":{"tf":1.0},"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.4142135623730951},"7":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":2.0},"72":{"tf":1.0},"73":{"tf":2.23606797749979},"74":{"tf":2.23606797749979},"75":{"tf":1.4142135623730951},"76":{"tf":1.0},"81":{"tf":1.7320508075688772},"82":{"tf":1.0},"84":{"tf":1.0},"88":{"tf":1.0}}}}}}},"df":4,"docs":{"20":{"tf":1.0},"50":{"tf":1.0},"71":{"tf":1.0},"91":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"45":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"74":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"45":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"h":{"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"y":{"df":8,"docs":{"36":{"tf":1.0},"40":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"57":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"50":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"50":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":3,"docs":{"52":{"tf":1.4142135623730951},"70":{"tf":1.0},"75":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":5,"docs":{"16":{"tf":1.0},"45":{"tf":1.4142135623730951},"48":{"tf":1.0},"57":{"tf":1.0},"73":{"tf":1.7320508075688772}}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"50":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"82":{"tf":1.0}}}}}},"d":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"46":{"tf":1.0},"69":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":2.0}}}},"df":0,"docs":{}}}}}}}}}}}}}}},"g":{"df":0,"docs":{},"l":{"df":3,"docs":{"80":{"tf":1.4142135623730951},"82":{"tf":1.0},"89":{"tf":1.0}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"20":{"tf":1.0},"86":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"20":{"tf":1.0},"50":{"tf":1.0},"6":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"50":{"tf":1.0}},"u":{"df":2,"docs":{"6":{"tf":1.0},"73":{"tf":1.0}}}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"50":{"tf":1.0},"73":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"6":{"tf":1.0}}},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":2,"docs":{"70":{"tf":1.0},"75":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"16":{"tf":1.0},"57":{"tf":1.0}}}}}}}}},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"88":{"tf":1.0}}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"71":{"tf":2.0},"76":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"73":{"tf":1.7320508075688772},"74":{"tf":2.23606797749979}}}}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":2,"docs":{"54":{"tf":1.0},"55":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"33":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":5,"docs":{"14":{"tf":1.0},"20":{"tf":1.4142135623730951},"25":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"90":{"tf":1.4142135623730951}}},"df":8,"docs":{"20":{"tf":1.0},"33":{"tf":1.0},"40":{"tf":1.0},"46":{"tf":1.0},"57":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"95":{"tf":1.0}}}}}}}}},"r":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"91":{"tf":1.7320508075688772},"94":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"1":{"df":4,"docs":{"21":{"tf":1.0},"46":{"tf":1.0},"51":{"tf":1.4142135623730951},"65":{"tf":1.0}}},"2":{"df":3,"docs":{"21":{"tf":1.4142135623730951},"46":{"tf":1.0},"51":{"tf":1.4142135623730951}}},"3":{"df":1,"docs":{"46":{"tf":1.0}}},"4":{"df":1,"docs":{"46":{"tf":1.0}}},"df":2,"docs":{"33":{"tf":1.7320508075688772},"82":{"tf":1.0}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"1":{"df":1,"docs":{"73":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"73":{"tf":1.4142135623730951}}},"df":9,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"21":{"tf":1.4142135623730951},"6":{"tf":1.0},"63":{"tf":1.7320508075688772},"64":{"tf":1.7320508075688772},"65":{"tf":1.4142135623730951},"68":{"tf":2.0},"75":{"tf":2.449489742783178}}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}}}}}},"m":{"df":3,"docs":{"73":{"tf":2.8284271247461903},"74":{"tf":1.0},"78":{"tf":1.0}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":15,"docs":{"24":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"32":{"tf":1.0},"37":{"tf":1.0},"47":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":1.0},"76":{"tf":1.0},"80":{"tf":2.8284271247461903},"88":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"y":{"df":4,"docs":{"57":{"tf":2.0},"58":{"tf":1.0},"6":{"tf":1.0},"88":{"tf":1.0}}}},"df":1,"docs":{"75":{"tf":1.0}}}},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}}},"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":1,"docs":{"68":{"tf":1.0}}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":2,"docs":{"33":{"tf":1.0},"60":{"tf":1.7320508075688772}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"90":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":3,"docs":{"32":{"tf":1.0},"35":{"tf":1.7320508075688772},"89":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"74":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"14":{"tf":1.0},"15":{"tf":3.0},"39":{"tf":1.0},"50":{"tf":1.0},"96":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"15":{"tf":1.0},"89":{"tf":1.7320508075688772}}}}},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.0},"20":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":16,"docs":{"21":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":1.4142135623730951},"36":{"tf":1.0},"50":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.0},"81":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}},"b":{":":{":":{"a":{"df":1,"docs":{"40":{"tf":1.0}}},"c":{"df":1,"docs":{"40":{"tf":1.0}}},"d":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"x":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{}},"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{},"{":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"40":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"r":{"(":{"1":{"1":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"1":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}}}}}},"<":{"df":0,"docs":{},"t":{"df":2,"docs":{"33":{"tf":1.0},"34":{"tf":1.0}}}},"[":{"0":{".":{".":{"1":{"0":{"0":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":17,"docs":{"15":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"35":{"tf":1.0},"37":{"tf":1.0},"46":{"tf":1.4142135623730951},"48":{"tf":1.0},"5":{"tf":1.4142135623730951},"58":{"tf":1.0},"60":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":2.449489742783178},"74":{"tf":1.4142135623730951},"81":{"tf":1.0}},"e":{"df":2,"docs":{"88":{"tf":1.0},"89":{"tf":1.0}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"3":{"tf":1.0},"50":{"tf":1.0}}}},"z":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"80":{"tf":1.0}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"1":{"df":1,"docs":{"81":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":11,"docs":{"15":{"tf":1.4142135623730951},"37":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"60":{"tf":1.0},"69":{"tf":1.7320508075688772},"7":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"81":{"tf":1.0}}}},"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":10,"docs":{"25":{"tf":2.0},"39":{"tf":1.4142135623730951},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":1.0},"80":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"90":{"tf":1.0}}}}}},"df":2,"docs":{"16":{"tf":1.0},"71":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":34,"docs":{"14":{"tf":2.23606797749979},"15":{"tf":1.0},"20":{"tf":1.7320508075688772},"21":{"tf":1.0},"27":{"tf":1.7320508075688772},"28":{"tf":1.4142135623730951},"30":{"tf":1.0},"32":{"tf":1.7320508075688772},"33":{"tf":1.4142135623730951},"34":{"tf":2.6457513110645907},"35":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"50":{"tf":2.0},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"61":{"tf":2.0},"65":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"74":{"tf":1.7320508075688772},"76":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.4142135623730951},"88":{"tf":1.0},"9":{"tf":2.0},"93":{"tf":1.4142135623730951},"96":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"75":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"75":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"38":{"tf":1.0},"57":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"62":{"tf":1.0},"70":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":18,"docs":{"25":{"tf":1.0},"27":{"tf":1.0},"46":{"tf":1.7320508075688772},"48":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"53":{"tf":1.0},"54":{"tf":1.4142135623730951},"55":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"59":{"tf":1.4142135623730951},"63":{"tf":2.0},"64":{"tf":1.7320508075688772},"80":{"tf":1.4142135623730951},"88":{"tf":2.0},"91":{"tf":1.0},"96":{"tf":1.4142135623730951}}}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"60":{"tf":1.7320508075688772},"61":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"h":{"df":1,"docs":{"51":{"tf":1.0}}},"m":{"b":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"45":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"k":{"df":5,"docs":{"39":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.0},"88":{"tf":1.4142135623730951},"96":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"45":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"o":{"c":{"df":0,"docs":{},"k":{"_":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"50":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":32,"docs":{"14":{"tf":2.449489742783178},"21":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":2.0},"34":{"tf":1.0},"38":{"tf":1.0},"45":{"tf":2.23606797749979},"46":{"tf":2.6457513110645907},"48":{"tf":1.4142135623730951},"5":{"tf":1.7320508075688772},"50":{"tf":3.7416573867739413},"51":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"65":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":2.23606797749979},"73":{"tf":3.0},"74":{"tf":2.0},"75":{"tf":1.4142135623730951},"76":{"tf":1.0},"81":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"d":{"df":0,"docs":{},"i":{"df":4,"docs":{"33":{"tf":1.7320508075688772},"51":{"tf":1.0},"73":{"tf":1.4142135623730951},"74":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"o":{"df":1,"docs":{"51":{"tf":1.0}},"l":{"df":1,"docs":{"71":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":7,"docs":{"1":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":1.0},"45":{"tf":1.0},"76":{"tf":1.0},"88":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":7,"docs":{"27":{"tf":2.449489742783178},"32":{"tf":1.0},"33":{"tf":2.6457513110645907},"35":{"tf":1.0},"76":{"tf":1.4142135623730951},"79":{"tf":1.0},"82":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"x":{"<":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}}}}}}},"df":1,"docs":{"81":{"tf":1.0}}}},"r":{"a":{"c":{"df":0,"docs":{},"e":{"df":16,"docs":{"24":{"tf":1.0},"25":{"tf":1.7320508075688772},"27":{"tf":1.7320508075688772},"28":{"tf":1.7320508075688772},"30":{"tf":1.0},"32":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":1.7320508075688772},"50":{"tf":2.23606797749979},"51":{"tf":1.0},"52":{"tf":1.7320508075688772},"71":{"tf":2.6457513110645907},"73":{"tf":1.4142135623730951},"88":{"tf":1.0}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":10,"docs":{"33":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"57":{"tf":2.23606797749979},"58":{"tf":2.0},"71":{"tf":1.0},"80":{"tf":2.0},"82":{"tf":1.0},"88":{"tf":1.4142135623730951},"89":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}},"df":28,"docs":{"2":{"tf":1.0},"21":{"tf":1.0},"27":{"tf":2.449489742783178},"28":{"tf":2.0},"32":{"tf":2.0},"33":{"tf":1.0},"34":{"tf":2.23606797749979},"38":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":2.449489742783178},"48":{"tf":1.0},"53":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":1.7320508075688772},"61":{"tf":2.6457513110645907},"63":{"tf":1.4142135623730951},"65":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.4142135623730951},"74":{"tf":2.6457513110645907},"76":{"tf":1.0},"81":{"tf":3.4641016151377544},"91":{"tf":1.0},"92":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"57":{"tf":1.0},"58":{"tf":1.0},"71":{"tf":1.7320508075688772},"76":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"3":{"tf":2.449489742783178}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"22":{"tf":1.0}}},"df":0,"docs":{}}}}},"c":{":":{":":{"d":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},">":{"(":{"df":0,"docs":{},"t":{"df":1,"docs":{"80":{"tf":1.0}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":13,"docs":{"22":{"tf":1.0},"57":{"tf":1.0},"63":{"tf":2.449489742783178},"64":{"tf":1.0},"65":{"tf":1.7320508075688772},"66":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"69":{"tf":1.7320508075688772},"70":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.7320508075688772},"9":{"tf":1.0},"92":{"tf":1.0}},"e":{"df":2,"docs":{"63":{"tf":1.0},"65":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"82":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"8":{"tf":1.0}}},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"18":{"tf":1.0},"87":{"tf":1.0}}}}}}},"df":1,"docs":{"96":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"e":{"df":8,"docs":{"15":{"tf":1.0},"24":{"tf":1.0},"46":{"tf":1.0},"57":{"tf":1.0},"65":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.7320508075688772},"9":{"tf":1.0}}},"t":{"df":1,"docs":{"61":{"tf":1.7320508075688772}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"3":{"tf":1.0}}}}},"df":8,"docs":{"36":{"tf":1.7320508075688772},"39":{"tf":1.4142135623730951},"54":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":1.0},"80":{"tf":1.4142135623730951}},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"61":{"tf":1.0},"69":{"tf":2.0},"70":{"tf":1.7320508075688772},"71":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"g":{"df":4,"docs":{"20":{"tf":1.0},"91":{"tf":2.0},"93":{"tf":2.0},"95":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"95":{"tf":2.23606797749979}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"14":{"tf":1.0},"16":{"tf":1.0},"5":{"tf":1.0},"9":{"tf":2.8284271247461903}}}},"df":0,"docs":{}},"df":1,"docs":{"14":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"91":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":1,"docs":{"46":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"9":{"tf":3.1622776601683795}}}}}},"i":{"df":1,"docs":{"91":{"tf":1.0}},"r":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":7,"docs":{"27":{"tf":1.0},"32":{"tf":2.449489742783178},"33":{"tf":2.8284271247461903},"34":{"tf":3.3166247903554},"71":{"tf":2.449489742783178},"72":{"tf":1.0},"74":{"tf":2.6457513110645907}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"81":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":20,"docs":{"14":{"tf":1.4142135623730951},"21":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"38":{"tf":1.0},"46":{"tf":1.4142135623730951},"50":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"71":{"tf":1.4142135623730951},"73":{"tf":1.0},"88":{"tf":1.0}}},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"51":{"tf":2.23606797749979},"75":{"tf":1.7320508075688772}}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":11,"docs":{"1":{"tf":1.4142135623730951},"14":{"tf":1.0},"16":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.0},"88":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":2.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"27":{"tf":1.0},"35":{"tf":1.0},"52":{"tf":1.0},"80":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":1,"docs":{"89":{"tf":1.0}}}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"15":{"tf":1.0},"45":{"tf":1.0},"69":{"tf":1.0},"73":{"tf":1.4142135623730951},"75":{"tf":2.23606797749979}}}}},"df":0,"docs":{},"e":{"df":4,"docs":{"20":{"tf":1.4142135623730951},"40":{"tf":2.0},"9":{"tf":1.4142135623730951},"91":{"tf":1.0}}},"m":{"a":{"df":17,"docs":{"21":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.7320508075688772},"32":{"tf":1.7320508075688772},"33":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"52":{"tf":1.7320508075688772},"54":{"tf":1.4142135623730951},"57":{"tf":1.0},"6":{"tf":2.0},"63":{"tf":1.4142135623730951},"64":{"tf":1.0},"65":{"tf":1.0},"73":{"tf":1.4142135623730951},"80":{"tf":2.449489742783178},"88":{"tf":1.4142135623730951}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":12,"docs":{"14":{"tf":5.291502622129181},"21":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":3.0},"51":{"tf":1.0},"70":{"tf":1.4142135623730951},"73":{"tf":1.7320508075688772},"8":{"tf":1.0},"96":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"89":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":2.449489742783178}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"60":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}}},"t":{"df":1,"docs":{"90":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}},"x":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"16":{"tf":1.0},"33":{"tf":1.4142135623730951},"46":{"tf":2.23606797749979},"71":{"tf":1.0}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"27":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":7,"docs":{"1":{"tf":1.0},"20":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0},"89":{"tf":1.4142135623730951},"9":{"tf":1.0},"90":{"tf":1.4142135623730951}}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"85":{"tf":1.0}}}}},"df":3,"docs":{"61":{"tf":1.7320508075688772},"80":{"tf":1.0},"85":{"tf":1.0}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"16":{"tf":1.0},"67":{"tf":1.4142135623730951},"91":{"tf":2.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"74":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":7,"docs":{"33":{"tf":1.0},"46":{"tf":2.0},"50":{"tf":2.0},"72":{"tf":1.0},"73":{"tf":1.4142135623730951},"89":{"tf":1.7320508075688772},"96":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"50":{"tf":1.0},"57":{"tf":1.0},"96":{"tf":1.7320508075688772}}}},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"72":{"tf":1.0},"90":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"33":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":5,"docs":{"51":{"tf":1.0},"62":{"tf":1.0},"71":{"tf":2.449489742783178},"73":{"tf":1.0},"90":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":7,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"20":{"tf":1.0},"4":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.4142135623730951}}}}}}},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"6":{"tf":1.0},"81":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":1,"docs":{"3":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"78":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.7320508075688772},"94":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"45":{"tf":1.4142135623730951},"71":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"1":{"df":1,"docs":{"88":{"tf":1.4142135623730951}}},"_":{"df":1,"docs":{"85":{"tf":1.0}}},"df":6,"docs":{"14":{"tf":1.0},"20":{"tf":1.0},"29":{"tf":1.4142135623730951},"85":{"tf":1.0},"88":{"tf":1.4142135623730951},"89":{"tf":2.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"89":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"88":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"91":{"tf":1.0},"93":{"tf":1.0}}}}}}}}},"d":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"96":{"tf":1.4142135623730951}}}}},"df":3,"docs":{"39":{"tf":1.4142135623730951},"57":{"tf":1.0},"80":{"tf":1.0}},"e":{"b":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{">":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}},"df":3,"docs":{"27":{"tf":1.0},"32":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951}}}}},"c":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"16":{"tf":1.0},"19":{"tf":1.0},"90":{"tf":1.0}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"r":{"df":6,"docs":{"20":{"tf":1.7320508075688772},"24":{"tf":1.0},"25":{"tf":1.0},"32":{"tf":1.0},"45":{"tf":1.4142135623730951},"81":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":7,"docs":{"1":{"tf":1.0},"2":{"tf":2.449489742783178},"3":{"tf":1.0},"38":{"tf":1.0},"43":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.7320508075688772}}}}}},"df":1,"docs":{"46":{"tf":1.0}},"g":{"df":1,"docs":{"45":{"tf":1.0}}},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"2":{"tf":1.0},"67":{"tf":1.4142135623730951},"74":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"16":{"tf":1.0},"21":{"tf":1.4142135623730951},"31":{"tf":1.0},"51":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"47":{"tf":1.4142135623730951},"75":{"tf":1.0},"96":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"16":{"tf":1.0},"88":{"tf":1.4142135623730951},"96":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"88":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"15":{"tf":1.7320508075688772}},"e":{"(":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"15":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":5,"docs":{"46":{"tf":1.0},"89":{"tf":1.4142135623730951},"91":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"88":{"tf":1.7320508075688772},"89":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"88":{"tf":1.0},"89":{"tf":1.0}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"1":{"tf":1.0},"2":{"tf":1.4142135623730951}}}}}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":3,"docs":{"5":{"tf":1.0},"6":{"tf":1.0},"90":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"16":{"tf":1.4142135623730951},"3":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.7320508075688772}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"73":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"32":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"34":{"tf":1.0},"91":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"o":{"c":{"df":1,"docs":{"14":{"tf":2.0}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"14":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"n":{"\'":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":11,"docs":{"1":{"tf":1.0},"20":{"tf":1.0},"26":{"tf":1.4142135623730951},"37":{"tf":1.0},"45":{"tf":1.0},"51":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"25":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":2,"docs":{"5":{"tf":1.0},"90":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"e":{"df":2,"docs":{"60":{"tf":1.0},"70":{"tf":1.0}}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":23,"docs":{"15":{"tf":1.0},"25":{"tf":1.4142135623730951},"26":{"tf":1.0},"27":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.4142135623730951},"5":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"74":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"81":{"tf":1.0},"89":{"tf":1.4142135623730951},"95":{"tf":1.0}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":24,"docs":{"15":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"24":{"tf":1.7320508075688772},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"33":{"tf":1.7320508075688772},"42":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.4142135623730951},"54":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.4142135623730951},"70":{"tf":1.0},"74":{"tf":1.0},"88":{"tf":1.7320508075688772},"89":{"tf":1.0},"9":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951},"95":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}},"s":{"df":1,"docs":{"90":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"6":{"tf":1.0},"62":{"tf":1.0},"91":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"90":{"tf":1.0},"91":{"tf":3.7416573867739413},"92":{"tf":1.0},"93":{"tf":2.23606797749979},"94":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"54":{"tf":2.0},"57":{"tf":1.7320508075688772},"6":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":2.449489742783178}}}}}}},"i":{"d":{"df":2,"docs":{"51":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"@":{"a":{"d":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"89":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"89":{"tf":2.0}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":4,"docs":{"25":{"tf":1.4142135623730951},"26":{"tf":1.0},"50":{"tf":1.0},"73":{"tf":1.0}}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"d":{"df":8,"docs":{"14":{"tf":1.0},"25":{"tf":1.0},"46":{"tf":1.7320508075688772},"48":{"tf":1.0},"71":{"tf":1.0},"8":{"tf":1.0},"88":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"1":{"tf":1.0},"9":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":3,"docs":{"14":{"tf":1.0},"46":{"tf":1.7320508075688772},"88":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"1":{"tf":1.0},"52":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":3,"docs":{"24":{"tf":2.0},"56":{"tf":1.7320508075688772},"85":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"15":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"9":{"tf":2.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"24":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"24":{"tf":1.4142135623730951},"90":{"tf":1.0}}}}}},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"88":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"1":{"tf":1.0},"91":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"c":{"df":2,"docs":{"60":{"tf":1.0},"90":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":6,"docs":{"1":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"67":{"tf":1.0},"9":{"tf":1.0}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"2":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"91":{"tf":1.0}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":23,"docs":{"14":{"tf":1.0},"16":{"tf":1.4142135623730951},"21":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"5":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.7320508075688772},"72":{"tf":1.0},"73":{"tf":1.4142135623730951},"89":{"tf":1.0},"9":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"89":{"tf":1.0}}}}}},"<":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"32":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":5,"docs":{"20":{"tf":1.0},"40":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"25":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"60":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"41":{"tf":1.0},"75":{"tf":1.0}}}}},"df":0,"docs":{}}},"r":{"1":{"df":2,"docs":{"51":{"tf":1.0},"69":{"tf":1.0}}},"2":{"df":2,"docs":{"51":{"tf":1.0},"69":{"tf":1.0}}},"_":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"48":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":6,"docs":{"45":{"tf":2.0},"48":{"tf":1.0},"51":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":20,"docs":{"12":{"tf":1.0},"16":{"tf":1.0},"45":{"tf":2.449489742783178},"46":{"tf":2.449489742783178},"48":{"tf":2.0},"49":{"tf":1.0},"50":{"tf":1.7320508075688772},"51":{"tf":1.7320508075688772},"58":{"tf":1.7320508075688772},"60":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"71":{"tf":3.1622776601683795},"72":{"tf":1.0},"73":{"tf":2.23606797749979},"75":{"tf":1.7320508075688772},"76":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.4142135623730951},"89":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":5,"docs":{"20":{"tf":1.0},"21":{"tf":1.0},"29":{"tf":1.4142135623730951},"36":{"tf":2.6457513110645907},"80":{"tf":1.0}}}}},"r":{"a":{"df":1,"docs":{"51":{"tf":1.0}},"n":{"df":1,"docs":{"62":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"88":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}}},"f":{"1":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}},"3":{"2":{"df":1,"docs":{"15":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"24":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"46":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"70":{"tf":1.0}}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}}}}}},"df":2,"docs":{"45":{"tf":2.6457513110645907},"52":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"88":{"tf":1.0},"95":{"tf":1.4142135623730951},"96":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"96":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"w":{"df":2,"docs":{"26":{"tf":1.0},"42":{"tf":1.0}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"1":{"df":3,"docs":{"51":{"tf":1.0},"52":{"tf":1.7320508075688772},"56":{"tf":1.0}}},"2":{"df":3,"docs":{"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"56":{"tf":1.0}}},"df":8,"docs":{"24":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"26":{"tf":2.0},"52":{"tf":1.7320508075688772},"69":{"tf":1.7320508075688772},"75":{"tf":1.0},"85":{"tf":1.0},"89":{"tf":2.23606797749979}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":3,"docs":{"20":{"tf":1.0},"88":{"tf":1.0},"96":{"tf":1.0}}}},"n":{"d":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":1,"docs":{"62":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"u":{"3":{"2":{"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":15,"docs":{"20":{"tf":1.0},"27":{"tf":1.0},"40":{"tf":1.0},"45":{"tf":2.0},"51":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0},"64":{"tf":1.0},"69":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"89":{"tf":1.0},"9":{"tf":1.4142135623730951},"91":{"tf":1.0}}}}},"t":{"df":18,"docs":{"21":{"tf":1.0},"25":{"tf":1.4142135623730951},"26":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":2.0},"46":{"tf":1.0},"61":{"tf":1.0},"68":{"tf":1.7320508075688772},"69":{"tf":1.0},"71":{"tf":1.4142135623730951},"73":{"tf":1.0},"74":{"tf":1.7320508075688772},"75":{"tf":1.4142135623730951},"81":{"tf":1.0},"88":{"tf":1.7320508075688772}}},"x":{"df":1,"docs":{"3":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"73":{"tf":1.0}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":4,"docs":{"51":{"tf":1.0},"62":{"tf":1.0},"71":{"tf":1.4142135623730951},"73":{"tf":1.0}}}}},"n":{"<":{"\'":{"a":{"df":1,"docs":{"80":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":58,"docs":{"14":{"tf":2.0},"15":{"tf":1.0},"16":{"tf":1.0},"21":{"tf":2.23606797749979},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.7320508075688772},"26":{"tf":1.4142135623730951},"27":{"tf":1.7320508075688772},"28":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":2.23606797749979},"33":{"tf":2.449489742783178},"34":{"tf":1.7320508075688772},"35":{"tf":1.0},"36":{"tf":1.7320508075688772},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"42":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":2.23606797749979},"46":{"tf":2.23606797749979},"47":{"tf":1.0},"48":{"tf":2.0},"5":{"tf":1.0},"50":{"tf":2.6457513110645907},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.4142135623730951},"7":{"tf":2.0},"70":{"tf":1.4142135623730951},"71":{"tf":2.0},"72":{"tf":1.0},"73":{"tf":2.23606797749979},"74":{"tf":2.23606797749979},"75":{"tf":1.4142135623730951},"76":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.7320508075688772},"82":{"tf":1.7320508075688772},"84":{"tf":1.0},"88":{"tf":1.0},"96":{"tf":1.0}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":24,"docs":{"14":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"25":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"41":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"51":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.4142135623730951},"6":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.0},"71":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951},"89":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0},"96":{"tf":1.0}}}}}},"o":{"!":{"(":{"a":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"(":{"4":{"df":1,"docs":{"74":{"tf":1.0}}},"a":{"df":1,"docs":{"55":{"tf":1.0}},"r":{"df":0,"docs":{},"g":{"1":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}}}},"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"75":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"15":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}},"x":{"df":1,"docs":{"64":{"tf":1.0}}},"|":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"75":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},".":{"b":{"a":{"df":0,"docs":{},"r":{".":{"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},":":{":":{"b":{"a":{"df":0,"docs":{},"r":{"(":{"a":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},":":{":":{"df":0,"docs":{},"{":{"a":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"80":{"tf":1.0}}}},"df":1,"docs":{"80":{"tf":1.4142135623730951}}},"z":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"{":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}}}}},"df":0,"docs":{}},"<":{"b":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"45":{"tf":1.7320508075688772},"81":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":3,"docs":{"32":{"tf":1.0},"33":{"tf":2.0},"34":{"tf":2.0}}}},"?":{".":{"b":{"a":{"df":0,"docs":{},"r":{"(":{")":{".":{"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"[":{".":{".":{"1":{"0":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"2":{"df":1,"docs":{"58":{"tf":1.0}}},"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"_":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":35,"docs":{"14":{"tf":1.7320508075688772},"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"20":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":2.8284271247461903},"26":{"tf":1.7320508075688772},"27":{"tf":1.4142135623730951},"28":{"tf":1.7320508075688772},"29":{"tf":1.0},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.4142135623730951},"38":{"tf":1.0},"45":{"tf":3.3166247903554},"46":{"tf":1.0},"48":{"tf":1.7320508075688772},"5":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.7320508075688772},"55":{"tf":1.0},"69":{"tf":1.7320508075688772},"7":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":2.23606797749979},"73":{"tf":3.4641016151377544},"74":{"tf":1.0},"76":{"tf":1.0},"80":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":1.4142135623730951}}},"r":{"b":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"85":{"tf":1.0}}}}},"df":1,"docs":{"2":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":38,"docs":{"1":{"tf":2.6457513110645907},"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.7320508075688772},"17":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"24":{"tf":2.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.7320508075688772},"35":{"tf":1.0},"37":{"tf":1.0},"4":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":2.23606797749979},"52":{"tf":1.0},"56":{"tf":1.0},"61":{"tf":1.4142135623730951},"65":{"tf":1.0},"67":{"tf":2.0},"68":{"tf":2.6457513110645907},"69":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772},"74":{"tf":1.0},"75":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"80":{"tf":1.0},"82":{"tf":1.4142135623730951},"88":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.4142135623730951},"91":{"tf":2.0},"95":{"tf":1.7320508075688772}},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":5,"docs":{"42":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.4142135623730951},"73":{"tf":1.0},"74":{"tf":1.7320508075688772}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"16":{"tf":1.0}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"90":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"71":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"96":{"tf":2.6457513110645907}}}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"31":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0}}}},"n":{"c":{"df":2,"docs":{"63":{"tf":1.0},"92":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}},"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":19,"docs":{"15":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":2.23606797749979},"22":{"tf":1.4142135623730951},"39":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"57":{"tf":1.0},"63":{"tf":2.23606797749979},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.4142135623730951},"68":{"tf":1.0},"70":{"tf":1.0},"75":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"85":{"tf":1.0},"92":{"tf":1.0}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"45":{"tf":1.0},"46":{"tf":1.0}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}}}}}}}}}},"g":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"95":{"tf":1.0},"96":{"tf":1.0}}}}},"df":1,"docs":{"45":{"tf":2.6457513110645907}},"e":{"df":0,"docs":{},"n":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{".":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":1,"docs":{"71":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":8,"docs":{"15":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"32":{"tf":2.8284271247461903},"60":{"tf":1.0},"81":{"tf":1.4142135623730951},"9":{"tf":1.0},"90":{"tf":1.0}},"i":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"df":1,"docs":{"80":{"tf":1.0}}}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"93":{"tf":1.0},"95":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"9":{"tf":1.0},"91":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"o":{"b":{"df":2,"docs":{"40":{"tf":1.0},"41":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":1,"docs":{"89":{"tf":1.0}},"e":{"df":1,"docs":{"14":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"74":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":2,"docs":{"90":{"tf":1.0},"95":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":3,"docs":{"39":{"tf":2.23606797749979},"40":{"tf":1.0},"42":{"tf":1.0}}}}}},"u":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"95":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"d":{"df":11,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":1.7320508075688772},"3":{"tf":2.0},"67":{"tf":1.4142135623730951},"90":{"tf":1.4142135623730951},"91":{"tf":2.0},"93":{"tf":1.4142135623730951},"94":{"tf":1.0},"95":{"tf":2.0}},"e":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"94":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"14":{"tf":1.0},"19":{"tf":1.0},"25":{"tf":1.0},"90":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"34":{"tf":1.0},"61":{"tf":1.0},"71":{"tf":1.4142135623730951},"73":{"tf":2.449489742783178},"74":{"tf":1.7320508075688772}},"l":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"r":{"d":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"90":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"88":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"68":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"95":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}}}}}},"x":{"a":{"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"77":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"90":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"93":{"tf":1.4142135623730951}}}}}}}},"o":{"c":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"89":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"89":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"94":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{".":{"df":6,"docs":{"46":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":1.0}}},"3":{"2":{"df":2,"docs":{"21":{"tf":2.449489742783178},"51":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"d":{"df":1,"docs":{"90":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"71":{"tf":1.0}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":6,"docs":{"14":{"tf":1.0},"24":{"tf":1.0},"55":{"tf":1.0},"82":{"tf":1.0},"85":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}}}},"x":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"67":{"tf":1.0},"9":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":3,"docs":{"28":{"tf":1.0},"33":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"85":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.0}}}},"l":{"<":{"df":0,"docs":{},"t":{"df":2,"docs":{"32":{"tf":1.0},"33":{"tf":1.0}}}},"df":4,"docs":{"28":{"tf":2.6457513110645907},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"3":{"tf":1.4142135623730951},"60":{"tf":1.0},"90":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":9,"docs":{"1":{"tf":1.0},"20":{"tf":1.0},"37":{"tf":1.4142135623730951},"38":{"tf":3.1622776601683795},"39":{"tf":2.6457513110645907},"40":{"tf":1.7320508075688772},"41":{"tf":1.4142135623730951},"42":{"tf":2.449489742783178},"43":{"tf":1.4142135623730951}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":14,"docs":{"14":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"71":{"tf":1.0},"8":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"90":{"tf":1.0},"93":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":31,"docs":{"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"21":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.7320508075688772},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.7320508075688772},"34":{"tf":2.0},"38":{"tf":1.0},"45":{"tf":2.23606797749979},"46":{"tf":2.0},"5":{"tf":2.8284271247461903},"50":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"65":{"tf":1.0},"69":{"tf":1.7320508075688772},"70":{"tf":1.0},"71":{"tf":2.0},"73":{"tf":1.4142135623730951},"74":{"tf":1.7320508075688772},"75":{"tf":1.0},"76":{"tf":1.0},"81":{"tf":1.0},"88":{"tf":2.23606797749979}}}},"x":{"<":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"<":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":2,"docs":{"27":{"tf":1.0},"33":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"o":{"<":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"df":1,"docs":{"58":{"tf":1.7320508075688772}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"27":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"<":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"i":{"c":{"df":3,"docs":{"24":{"tf":1.0},"60":{"tf":1.0},"76":{"tf":1.0}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":2,"docs":{"16":{"tf":1.0},"27":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"1":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"96":{"tf":1.0}}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":5,"docs":{"46":{"tf":2.449489742783178},"50":{"tf":1.0},"57":{"tf":1.7320508075688772},"71":{"tf":1.7320508075688772},"96":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"14":{"tf":1.4142135623730951},"33":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"14":{"tf":1.0},"15":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"2":{"tf":1.0},"60":{"tf":1.0}}}}},"i":{"d":{"df":3,"docs":{"15":{"tf":1.0},"51":{"tf":1.0},"73":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"9":{"tf":1.0},"91":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":2,"docs":{"32":{"tf":1.0},"61":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":1,"docs":{"95":{"tf":1.0}}}},"r":{"df":0,"docs":{},"f":{"a":{"c":{"df":1,"docs":{"90":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"45":{"tf":1.0}}}}},"n":{"df":1,"docs":{"90":{"tf":1.0}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"3":{"tf":1.0}}}}}}}}},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"73":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":2,"docs":{"16":{"tf":1.0},"96":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":15,"docs":{"10":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"16":{"tf":1.7320508075688772},"20":{"tf":2.6457513110645907},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.4142135623730951},"39":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"73":{"tf":1.0},"88":{"tf":1.7320508075688772}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":5,"docs":{"21":{"tf":1.0},"3":{"tf":1.0},"58":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.4142135623730951}}}}}}}},"j":{"df":0,"docs":{},"o":{"b":{"df":1,"docs":{"91":{"tf":1.0}}},"df":0,"docs":{}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":2,"docs":{"25":{"tf":1.0},"34":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.0}}}},"y":{"df":1,"docs":{"88":{"tf":4.242640687119285}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":12,"docs":{"14":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"46":{"tf":2.23606797749979},"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"71":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"33":{"tf":1.0},"6":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"85":{"tf":1.0}}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"/":{"3":{"7":{"3":{"4":{"3":{"df":0,"docs":{},"f":{"4":{"a":{"4":{"d":{"4":{"df":0,"docs":{},"e":{"d":{"7":{"a":{"d":{"0":{"8":{"9":{"1":{"c":{"b":{"7":{"9":{"df":0,"docs":{},"e":{"8":{"df":0,"docs":{},"e":{"b":{"2":{"5":{"a":{"c":{"df":0,"docs":{},"f":{"4":{"3":{"df":0,"docs":{},"f":{"b":{"8":{"2":{"1":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":1,"docs":{"94":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"2":{"tf":1.0},"67":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"90":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":2,"docs":{"32":{"tf":1.0},"38":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":11,"docs":{"21":{"tf":1.0},"34":{"tf":1.0},"40":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.0},"64":{"tf":1.4142135623730951},"69":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"88":{"tf":1.7320508075688772}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"70":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"91":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"9":{"tf":2.8284271247461903}}},"df":0,"docs":{},"v":{"df":3,"docs":{"16":{"tf":1.0},"34":{"tf":1.0},"61":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":3,"docs":{"71":{"tf":1.0},"73":{"tf":1.7320508075688772},"74":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"14":{"tf":1.0},"69":{"tf":1.0},"9":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"1":{"tf":1.0},"5":{"tf":1.0},"69":{"tf":1.0},"74":{"tf":1.0}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"14":{"tf":1.0},"32":{"tf":1.0},"77":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":8,"docs":{"10":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"33":{"tf":1.0},"46":{"tf":1.4142135623730951},"5":{"tf":1.0},"88":{"tf":1.0}}}}},"x":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"i":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"89":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.4142135623730951}}}}},"n":{"df":0,"docs":{},"e":{"df":50,"docs":{"14":{"tf":2.8284271247461903},"15":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"2":{"tf":1.0},"21":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":2.449489742783178},"25":{"tf":2.23606797749979},"26":{"tf":2.23606797749979},"27":{"tf":2.0},"28":{"tf":2.0},"32":{"tf":2.449489742783178},"33":{"tf":2.449489742783178},"34":{"tf":1.7320508075688772},"37":{"tf":1.0},"38":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"42":{"tf":2.0},"45":{"tf":3.872983346207417},"46":{"tf":4.358898943540674},"5":{"tf":1.4142135623730951},"50":{"tf":3.1622776601683795},"51":{"tf":1.0},"52":{"tf":2.0},"54":{"tf":2.0},"57":{"tf":1.7320508075688772},"58":{"tf":2.0},"59":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":2.23606797749979},"61":{"tf":2.8284271247461903},"63":{"tf":1.7320508075688772},"64":{"tf":1.0},"65":{"tf":2.0},"68":{"tf":2.0},"69":{"tf":2.8284271247461903},"7":{"tf":1.4142135623730951},"70":{"tf":2.6457513110645907},"71":{"tf":4.0},"72":{"tf":1.7320508075688772},"73":{"tf":2.6457513110645907},"74":{"tf":3.3166247903554},"75":{"tf":2.449489742783178},"76":{"tf":1.4142135623730951},"8":{"tf":2.0},"80":{"tf":1.0},"81":{"tf":2.0},"88":{"tf":3.1622776601683795},"89":{"tf":1.0},"96":{"tf":1.7320508075688772}}}},"s":{"df":0,"docs":{},"t":{"df":11,"docs":{"15":{"tf":1.0},"22":{"tf":1.4142135623730951},"24":{"tf":1.0},"38":{"tf":2.0},"40":{"tf":1.4142135623730951},"41":{"tf":1.0},"42":{"tf":1.0},"6":{"tf":1.0},"75":{"tf":1.0},"88":{"tf":1.4142135623730951},"89":{"tf":1.7320508075688772}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":13,"docs":{"16":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"54":{"tf":1.0},"55":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"71":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":2.0},"8":{"tf":1.7320508075688772},"92":{"tf":1.0}}}}}},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"85":{"tf":1.0}}},"t":{"df":1,"docs":{"96":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"25":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":1,"docs":{"38":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"96":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"25":{"tf":1.4142135623730951}}}}}}},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"48":{"tf":1.0},"71":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"73":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"9":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":3,"docs":{"1":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.4142135623730951}}}}}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"20":{"tf":1.0},"39":{"tf":1.0}}}}},"df":8,"docs":{"31":{"tf":1.0},"47":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"67":{"tf":2.23606797749979},"68":{"tf":1.4142135623730951},"73":{"tf":1.0},"75":{"tf":1.0},"85":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"89":{"tf":1.0}}},"n":{"df":56,"docs":{"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.0},"21":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.7320508075688772},"26":{"tf":1.4142135623730951},"27":{"tf":1.7320508075688772},"28":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.7320508075688772},"33":{"tf":1.4142135623730951},"34":{"tf":1.7320508075688772},"35":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"42":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":2.23606797749979},"46":{"tf":2.23606797749979},"47":{"tf":1.0},"48":{"tf":1.4142135623730951},"5":{"tf":1.0},"50":{"tf":1.7320508075688772},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.4142135623730951},"7":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":2.0},"72":{"tf":1.0},"73":{"tf":2.23606797749979},"74":{"tf":2.23606797749979},"75":{"tf":1.4142135623730951},"76":{"tf":1.0},"81":{"tf":1.7320508075688772},"82":{"tf":1.0},"84":{"tf":1.0},"88":{"tf":1.0},"96":{"tf":1.0}}}},"k":{"df":0,"docs":{},"e":{"df":9,"docs":{"41":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.4142135623730951},"61":{"tf":1.0},"62":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0},"91":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"df":2,"docs":{"16":{"tf":1.0},"74":{"tf":1.0}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"90":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"70":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"14":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":6,"docs":{"1":{"tf":1.0},"46":{"tf":1.0},"73":{"tf":3.4641016151377544},"74":{"tf":1.7320508075688772},"78":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"df":0,"docs":{}},"x":{"df":3,"docs":{"38":{"tf":1.0},"65":{"tf":1.0},"74":{"tf":1.0}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"9":{"tf":1.0}},"u":{"df":0,"docs":{},"m":{"df":2,"docs":{"14":{"tf":1.0},"5":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"16":{"tf":1.0}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"1":{"tf":1.0},"14":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"g":{"df":4,"docs":{"39":{"tf":1.0},"41":{"tf":1.4142135623730951},"43":{"tf":2.6457513110645907},"90":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"89":{"tf":1.0},"90":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"89":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":3,"docs":{"66":{"tf":1.0},"69":{"tf":1.7320508075688772},"85":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"91":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"90":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"96":{"tf":1.4142135623730951}}}}}}},"s":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"90":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"85":{"tf":1.0}}}}}}},"t":{"/":{"a":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"89":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"x":{"df":1,"docs":{"77":{"tf":1.0}}}},"o":{"d":{"df":2,"docs":{"20":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":5,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"20":{"tf":2.23606797749979},"30":{"tf":1.0},"86":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":10,"docs":{"1":{"tf":1.0},"16":{"tf":1.4142135623730951},"26":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"46":{"tf":1.0},"71":{"tf":1.7320508075688772},"89":{"tf":1.0},"9":{"tf":1.7320508075688772},"96":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"1":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":4,"docs":{"20":{"tf":1.0},"51":{"tf":1.4142135623730951},"6":{"tf":1.0},"9":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":16,"docs":{"14":{"tf":1.0},"16":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"34":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"46":{"tf":1.7320508075688772},"63":{"tf":1.0},"65":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"72":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.4142135623730951},"88":{"tf":1.0},"89":{"tf":1.0}},"p":{"df":0,"docs":{},"l":{"df":20,"docs":{"15":{"tf":1.0},"24":{"tf":1.4142135623730951},"32":{"tf":1.0},"38":{"tf":1.4142135623730951},"45":{"tf":1.7320508075688772},"46":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0},"65":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.4142135623730951},"88":{"tf":1.0}}}}}}},"t":{"df":2,"docs":{"59":{"tf":1.0},"80":{"tf":1.7320508075688772}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"1":{"df":1,"docs":{"68":{"tf":1.0}}},"2":{"df":1,"docs":{"68":{"tf":1.0}}},"df":18,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"32":{"tf":1.0},"38":{"tf":1.4142135623730951},"40":{"tf":1.0},"47":{"tf":1.0},"56":{"tf":1.4142135623730951},"63":{"tf":1.0},"64":{"tf":1.0},"80":{"tf":1.4142135623730951},"85":{"tf":2.0},"88":{"tf":2.6457513110645907},"89":{"tf":2.449489742783178},"95":{"tf":1.0}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"84":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":5,"docs":{"34":{"tf":1.0},"38":{"tf":1.0},"60":{"tf":1.0},"81":{"tf":1.4142135623730951},"96":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":2,"docs":{"1":{"tf":1.4142135623730951},"71":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"38":{"tf":1.0},"42":{"tf":2.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"46":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.7320508075688772},"73":{"tf":1.4142135623730951},"74":{"tf":1.0},"92":{"tf":1.0}}}}},"w":{"df":6,"docs":{"1":{"tf":1.4142135623730951},"3":{"tf":1.0},"33":{"tf":1.4142135623730951},"39":{"tf":1.0},"45":{"tf":1.0},"74":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"91":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"14":{"tf":1.4142135623730951},"50":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"88":{"tf":1.4142135623730951}}}}}},"x":{"df":0,"docs":{},"t":{"df":5,"docs":{"46":{"tf":1.0},"61":{"tf":1.0},"88":{"tf":1.0},"9":{"tf":1.0},"92":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"93":{"tf":1.0},"95":{"tf":2.449489742783178}}}}}}}},"o":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"73":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"n":{"df":10,"docs":{"17":{"tf":1.0},"2":{"tf":1.0},"28":{"tf":1.0},"42":{"tf":1.0},"73":{"tf":1.0},"82":{"tf":1.0},"88":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"46":{"tf":1.0}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"16":{"tf":1.0},"34":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"41":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{}}}},"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":9,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"21":{"tf":1.0},"33":{"tf":1.4142135623730951},"38":{"tf":1.0},"70":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.4142135623730951},"91":{"tf":1.0}}},"h":{"df":3,"docs":{"41":{"tf":1.0},"46":{"tf":1.0},"71":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"63":{"tf":1.4142135623730951},"92":{"tf":1.0}}}}},"df":0,"docs":{}}},"m":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"74":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"71":{"tf":1.0},"9":{"tf":2.0},"96":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":2.449489742783178}}}}}}},"o":{"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"72":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"k":{"(":{"a":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"c":{"df":2,"docs":{"25":{"tf":1.0},"73":{"tf":1.0}}},"df":21,"docs":{"1":{"tf":1.0},"21":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"32":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"42":{"tf":1.0},"46":{"tf":1.4142135623730951},"50":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.4142135623730951},"70":{"tf":1.0},"71":{"tf":1.7320508075688772},"74":{"tf":1.0},"80":{"tf":1.0},"88":{"tf":1.0},"9":{"tf":1.4142135623730951},"96":{"tf":1.7320508075688772}},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"58":{"tf":1.0}}}}},"p":{"df":2,"docs":{"59":{"tf":1.0},"60":{"tf":2.23606797749979}},"e":{"df":0,"docs":{},"n":{"df":24,"docs":{"14":{"tf":1.7320508075688772},"21":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"30":{"tf":1.0},"32":{"tf":1.7320508075688772},"38":{"tf":1.0},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"50":{"tf":1.7320508075688772},"52":{"tf":1.4142135623730951},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"63":{"tf":1.0},"64":{"tf":1.4142135623730951},"65":{"tf":1.0},"71":{"tf":2.23606797749979},"73":{"tf":1.0},"88":{"tf":1.0},"96":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"59":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":6,"docs":{"59":{"tf":1.4142135623730951},"60":{"tf":3.1622776601683795},"61":{"tf":1.7320508075688772},"69":{"tf":1.0},"71":{"tf":1.4142135623730951},"76":{"tf":1.0}}}},"t":{"df":1,"docs":{"46":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"2":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0},"71":{"tf":1.0}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":10,"docs":{"15":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"39":{"tf":1.7320508075688772},"40":{"tf":1.0},"81":{"tf":1.0},"88":{"tf":1.4142135623730951},"9":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":13,"docs":{"27":{"tf":1.0},"28":{"tf":1.0},"33":{"tf":1.0},"41":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"55":{"tf":1.0},"57":{"tf":1.0},"65":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"88":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}}}}}},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"24":{"tf":1.0},"88":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"75":{"tf":1.0}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"81":{"tf":1.0}}}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"81":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"=":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"27":{"tf":2.0}}}}}}},"df":2,"docs":{"33":{"tf":2.23606797749979},"39":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"5":{"tf":1.0},"65":{"tf":1.0},"91":{"tf":1.0}},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"88":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"88":{"tf":2.0},"9":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"75":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"22":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"64":{"tf":1.7320508075688772},"80":{"tf":1.0}},"t":{"df":1,"docs":{"71":{"tf":1.0}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":11,"docs":{"26":{"tf":1.4142135623730951},"46":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.0},"60":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"71":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"80":{"tf":1.0}},"i":{"df":6,"docs":{"21":{"tf":1.4142135623730951},"32":{"tf":1.0},"54":{"tf":1.4142135623730951},"55":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":1.4142135623730951}}}}}}}}},"s":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}},"t":{"df":1,"docs":{"32":{"tf":1.0}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":6,"docs":{"16":{"tf":1.0},"2":{"tf":1.0},"26":{"tf":1.0},"61":{"tf":1.0},"67":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":1,"docs":{"67":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"6":{"tf":1.0},"91":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"82":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.7320508075688772}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":6,"docs":{"1":{"tf":1.0},"45":{"tf":2.6457513110645907},"46":{"tf":1.7320508075688772},"73":{"tf":1.0},"74":{"tf":2.8284271247461903},"78":{"tf":1.7320508075688772}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"21":{"tf":1.0}}}}},"r":{"df":1,"docs":{"74":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":6,"docs":{"16":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"90":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"u":{"df":1,"docs":{"69":{"tf":1.0}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"95":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"46":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"47":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"50":{"tf":2.0}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":17,"docs":{"15":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"37":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"58":{"tf":1.0},"69":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.4142135623730951},"81":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"90":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"d":{"df":6,"docs":{"34":{"tf":1.7320508075688772},"46":{"tf":2.0},"60":{"tf":1.4142135623730951},"63":{"tf":1.0},"71":{"tf":1.4142135623730951},"76":{"tf":1.0}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"82":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":18,"docs":{"14":{"tf":2.0},"15":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"32":{"tf":1.7320508075688772},"33":{"tf":1.0},"38":{"tf":1.4142135623730951},"5":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.7320508075688772},"63":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.4142135623730951},"74":{"tf":1.0},"81":{"tf":1.4142135623730951},"84":{"tf":1.0}}}},"i":{"df":0,"docs":{},"x":{"df":2,"docs":{"51":{"tf":1.0},"71":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"34":{"tf":1.0},"40":{"tf":1.4142135623730951},"45":{"tf":1.0},"89":{"tf":1.4142135623730951},"96":{"tf":1.0}}}},"r":{"df":0,"docs":{},"v":{"df":3,"docs":{"15":{"tf":1.0},"8":{"tf":1.0},"90":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"39":{"tf":1.0},"90":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"19":{"tf":1.0},"90":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"n":{"df":1,"docs":{"68":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"90":{"tf":1.0}}}}}}}},"o":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"95":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"9":{"tf":1.4142135623730951}},"t":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":1,"docs":{"1":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"77":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"48":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"21":{"tf":1.0},"26":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":4,"docs":{"45":{"tf":1.0},"71":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"b":{"df":6,"docs":{"14":{"tf":1.0},"21":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"25":{"tf":1.0}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}},"s":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"t":{"df":37,"docs":{"14":{"tf":2.449489742783178},"15":{"tf":1.4142135623730951},"20":{"tf":1.0},"21":{"tf":1.0},"24":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"27":{"tf":2.0},"28":{"tf":1.0},"32":{"tf":2.449489742783178},"33":{"tf":1.7320508075688772},"35":{"tf":1.0},"37":{"tf":1.0},"45":{"tf":2.0},"46":{"tf":1.7320508075688772},"47":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"52":{"tf":2.0},"54":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.7320508075688772},"58":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"63":{"tf":2.0},"64":{"tf":1.4142135623730951},"65":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772},"72":{"tf":1.0},"74":{"tf":1.4142135623730951},"76":{"tf":1.0},"80":{"tf":1.0},"88":{"tf":2.8284271247461903}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":3,"docs":{"46":{"tf":1.0},"50":{"tf":1.0},"56":{"tf":1.0}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"88":{"tf":1.4142135623730951}}}},"x":{"(":{"\\"":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"46":{"tf":1.0}}}}}}}}}}}}}}}}}}}},"df":0,"docs":{}},"df":4,"docs":{"60":{"tf":1.0},"69":{"tf":2.23606797749979},"73":{"tf":1.0},"74":{"tf":1.0}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"45":{"tf":2.23606797749979}}}}}},"r":{"#":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"85":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"76":{"tf":2.23606797749979}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"90":{"tf":1.0}}}},"df":0,"docs":{}}}}},"w":{"df":1,"docs":{"85":{"tf":1.0}}}},"df":1,"docs":{"40":{"tf":1.0}},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"9":{"tf":1.0}}}},"d":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"90":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"68":{"tf":1.0},"71":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"96":{"tf":1.0}}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"14":{"tf":1.0},"2":{"tf":1.0},"77":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"d":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":4,"docs":{"40":{"tf":1.0},"41":{"tf":1.0},"69":{"tf":1.0},"75":{"tf":1.0}}}}}},"df":1,"docs":{"39":{"tf":1.4142135623730951}},"f":{"df":1,"docs":{"74":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"2":{"tf":1.4142135623730951},"60":{"tf":1.0},"95":{"tf":1.0}}}}},"g":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"95":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"96":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"61":{"tf":1.0}}},"df":2,"docs":{"45":{"tf":1.0},"88":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"v":{"df":3,"docs":{"6":{"tf":1.4142135623730951},"60":{"tf":1.0},"95":{"tf":1.0}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"95":{"tf":1.0}}}}}}}}},"r":{"(":{"c":{"df":1,"docs":{"15":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":14,"docs":{"1":{"tf":1.0},"24":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"38":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"6":{"tf":1.0},"61":{"tf":1.4142135623730951},"74":{"tf":1.0},"8":{"tf":1.0},"81":{"tf":1.0},"88":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"85":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"3":{"tf":1.0}}}}},"t":{"df":2,"docs":{"45":{"tf":1.0},"95":{"tf":1.4142135623730951}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"75":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"46":{"tf":2.8284271247461903},"48":{"tf":1.0},"51":{"tf":1.0}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"33":{"tf":1.4142135623730951}}}}}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":6,"docs":{"25":{"tf":1.4142135623730951},"34":{"tf":1.0},"61":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.7320508075688772},"74":{"tf":1.0}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"5":{"tf":1.0},"90":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"96":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"90":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":18,"docs":{"1":{"tf":1.4142135623730951},"33":{"tf":1.0},"38":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.4142135623730951},"61":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"90":{"tf":1.0},"91":{"tf":1.0}}}},"n":{"df":1,"docs":{"65":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"c":{"df":1,"docs":{"90":{"tf":1.0}}},"df":13,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"2":{"tf":2.0},"20":{"tf":1.0},"21":{"tf":1.0},"3":{"tf":1.4142135623730951},"88":{"tf":1.0},"9":{"tf":1.7320508075688772},"91":{"tf":4.0},"92":{"tf":1.0},"93":{"tf":2.449489742783178},"94":{"tf":2.0},"95":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":6,"docs":{"1":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":2.0},"90":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0}}}}},"’":{"df":1,"docs":{"84":{"tf":1.0}}}}}}},"s":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"76":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":16,"docs":{"20":{"tf":1.0},"25":{"tf":1.7320508075688772},"33":{"tf":1.4142135623730951},"39":{"tf":1.0},"45":{"tf":1.4142135623730951},"46":{"tf":2.449489742783178},"50":{"tf":1.4142135623730951},"57":{"tf":1.0},"61":{"tf":1.0},"71":{"tf":1.7320508075688772},"73":{"tf":1.7320508075688772},"75":{"tf":1.4142135623730951},"77":{"tf":1.4142135623730951},"88":{"tf":2.0},"9":{"tf":1.4142135623730951},"91":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"1":{"tf":1.0}}}}},"c":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"90":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"89":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"81":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"85":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":2,"docs":{"40":{"tf":1.0},"51":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"21":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"24":{"tf":1.0},"51":{"tf":1.0},"69":{"tf":1.4142135623730951},"71":{"tf":1.0},"76":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"71":{"tf":1.0},"78":{"tf":1.0},"81":{"tf":1.0},"88":{"tf":3.3166247903554},"95":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{},"e":{"df":5,"docs":{"16":{"tf":1.0},"68":{"tf":1.0},"78":{"tf":1.0},"88":{"tf":1.0},"93":{"tf":1.0}}},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"82":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"f":{".":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"71":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"(":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"70":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"(":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"70":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},":":{":":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":2.23606797749979}}}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"20":{"tf":1.0},"40":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"20":{"tf":1.0},"91":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":9,"docs":{"26":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"33":{"tf":1.0},"45":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.7320508075688772},"57":{"tf":1.0},"73":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"90":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"14":{"tf":1.0},"89":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":12,"docs":{"26":{"tf":1.0},"39":{"tf":1.0},"45":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"80":{"tf":1.0},"88":{"tf":1.4142135623730951},"9":{"tf":1.0},"91":{"tf":1.4142135623730951},"96":{"tf":1.0}}}},"df":0,"docs":{}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":3,"docs":{"69":{"tf":1.0},"88":{"tf":1.0},"9":{"tf":1.7320508075688772}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"61":{"tf":1.4142135623730951},"96":{"tf":1.0}}}},"t":{"df":4,"docs":{"1":{"tf":1.0},"20":{"tf":1.0},"39":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"h":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"85":{"tf":2.6457513110645907}}}}},"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"96":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"33":{"tf":1.0},"46":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":6,"docs":{"34":{"tf":1.0},"45":{"tf":1.0},"61":{"tf":1.0},"71":{"tf":1.4142135623730951},"73":{"tf":2.449489742783178},"74":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"14":{"tf":2.6457513110645907},"80":{"tf":1.0}}}},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"21":{"tf":1.4142135623730951},"28":{"tf":1.0}}}}}},"df":1,"docs":{"15":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":4,"docs":{"1":{"tf":1.0},"57":{"tf":1.0},"67":{"tf":1.0},"75":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"16":{"tf":1.0},"9":{"tf":1.0}},"i":{"c":{"df":1,"docs":{"90":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"25":{"tf":1.0},"26":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":28,"docs":{"14":{"tf":2.0},"15":{"tf":1.7320508075688772},"16":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":1.4142135623730951},"38":{"tf":1.0},"45":{"tf":1.4142135623730951},"46":{"tf":2.449489742783178},"50":{"tf":2.449489742783178},"52":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"57":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"68":{"tf":1.4142135623730951},"70":{"tf":1.0},"71":{"tf":2.23606797749979},"72":{"tf":1.7320508075688772},"73":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"80":{"tf":2.449489742783178},"82":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}},"df":0,"docs":{}}},"z":{"df":0,"docs":{},"e":{"df":3,"docs":{"16":{"tf":1.0},"33":{"tf":1.0},"82":{"tf":1.4142135623730951}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"14":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"58":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"74":{"tf":2.0}}}}}}},"df":0,"docs":{}}}},"df":9,"docs":{"16":{"tf":2.0},"24":{"tf":1.0},"52":{"tf":1.0},"57":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":2.23606797749979}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"14":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0}}}}}}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"85":{"tf":2.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"9":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"(":{"1":{"df":1,"docs":{"46":{"tf":1.7320508075688772}}},"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"71":{"tf":1.0}}},"b":{"df":1,"docs":{"71":{"tf":2.449489742783178}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":2,"docs":{"71":{"tf":1.0},"74":{"tf":1.0}}}}},"p":{"df":1,"docs":{"71":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"x":{"df":1,"docs":{"46":{"tf":1.7320508075688772}}}},"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"y":{"?":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"88":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"88":{"tf":1.0}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"2":{"df":1,"docs":{"34":{"tf":1.0}}},"df":1,"docs":{"34":{"tf":2.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"72":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{">":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{":":{":":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"80":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"r":{"df":0,"docs":{},"t":{"df":6,"docs":{"20":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"88":{"tf":1.0},"9":{"tf":3.4641016151377544},"93":{"tf":1.7320508075688772}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":39,"docs":{"14":{"tf":1.7320508075688772},"15":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"32":{"tf":2.0},"33":{"tf":1.0},"35":{"tf":1.0},"37":{"tf":1.0},"45":{"tf":1.7320508075688772},"46":{"tf":1.4142135623730951},"47":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"52":{"tf":2.0},"54":{"tf":1.4142135623730951},"55":{"tf":1.0},"57":{"tf":1.7320508075688772},"58":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"63":{"tf":2.0},"64":{"tf":1.0},"66":{"tf":1.0},"71":{"tf":1.4142135623730951},"76":{"tf":1.0},"80":{"tf":4.242640687119285},"88":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":3,"docs":{"51":{"tf":1.0},"58":{"tf":1.0},"71":{"tf":1.0}}}},"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"89":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"24":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":3,"docs":{"67":{"tf":1.0},"88":{"tf":1.0},"90":{"tf":1.0}},"i":{"df":3,"docs":{"16":{"tf":1.0},"36":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":6,"docs":{"15":{"tf":1.0},"38":{"tf":1.0},"45":{"tf":1.4142135623730951},"52":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.4142135623730951}}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"r":{"df":7,"docs":{"46":{"tf":1.0},"47":{"tf":1.0},"57":{"tf":2.23606797749979},"58":{"tf":2.0},"71":{"tf":1.0},"80":{"tf":1.0},"88":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}}},"l":{"df":1,"docs":{"95":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"72":{"tf":1.0}}}}},"r":{"d":{"df":2,"docs":{"67":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":9,"docs":{"14":{"tf":1.0},"33":{"tf":1.0},"39":{"tf":1.0},"73":{"tf":1.7320508075688772},"74":{"tf":1.0},"88":{"tf":1.7320508075688772},"89":{"tf":1.0},"9":{"tf":1.0},"96":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":13,"docs":{"11":{"tf":1.0},"20":{"tf":1.4142135623730951},"37":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":3.4641016151377544},"47":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"50":{"tf":2.23606797749979},"51":{"tf":1.0},"7":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.4142135623730951}}}}}}},"i":{"c":{"df":1,"docs":{"85":{"tf":1.0}}},"df":0,"docs":{}}},"y":{"df":1,"docs":{"45":{"tf":1.0}}}},"d":{":":{":":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{":":{":":{"c":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"46":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"45":{"tf":1.0},"61":{"tf":1.0},"91":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"71":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"r":{"df":1,"docs":{"61":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":8,"docs":{"26":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"68":{"tf":2.23606797749979},"8":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951},"89":{"tf":1.0},"9":{"tf":3.1622776601683795}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":13,"docs":{"14":{"tf":1.0},"15":{"tf":1.7320508075688772},"16":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":2.8284271247461903},"25":{"tf":3.7416573867739413},"26":{"tf":3.4641016151377544},"52":{"tf":1.4142135623730951},"55":{"tf":1.0},"56":{"tf":1.0},"75":{"tf":1.0},"85":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":15,"docs":{"0":{"tf":1.0},"1":{"tf":1.7320508075688772},"2":{"tf":3.0},"3":{"tf":2.449489742783178},"50":{"tf":1.0},"67":{"tf":1.4142135623730951},"70":{"tf":1.0},"83":{"tf":1.0},"9":{"tf":1.4142135623730951},"90":{"tf":1.4142135623730951},"91":{"tf":4.58257569495584},"92":{"tf":1.0},"93":{"tf":2.6457513110645907},"94":{"tf":1.7320508075688772},"95":{"tf":2.8284271247461903}}}}}},"u":{"b":{"df":4,"docs":{"16":{"tf":1.0},"60":{"tf":1.0},"71":{"tf":2.0},"75":{"tf":1.0}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"45":{"tf":1.0},"89":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":8,"docs":{"45":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.7320508075688772},"69":{"tf":1.0},"81":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"h":{"df":16,"docs":{"1":{"tf":1.4142135623730951},"2":{"tf":1.7320508075688772},"20":{"tf":1.0},"24":{"tf":1.0},"3":{"tf":1.0},"36":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.0},"81":{"tf":1.4142135623730951},"85":{"tf":1.0},"88":{"tf":2.0},"9":{"tf":1.4142135623730951},"90":{"tf":1.0},"91":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"89":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"20":{"tf":1.0},"40":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"f":{"a":{"c":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":4,"docs":{"51":{"tf":1.0},"52":{"tf":1.0},"90":{"tf":1.0},"95":{"tf":2.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"b":{"df":1,"docs":{"91":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"t":{"a":{"b":{"df":1,"docs":{"5":{"tf":1.0}},"l":{"df":1,"docs":{"88":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":3,"docs":{"1":{"tf":1.0},"60":{"tf":1.0},"68":{"tf":1.0}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}},"df":8,"docs":{"14":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":2.6457513110645907},"34":{"tf":2.0},"60":{"tf":2.449489742783178},"80":{"tf":3.7416573867739413},"81":{"tf":1.0},"82":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"m":{"df":3,"docs":{"3":{"tf":1.4142135623730951},"90":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"33":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"89":{"tf":1.0},"90":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"50":{"tf":2.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":3,"docs":{"1":{"tf":1.0},"20":{"tf":1.0},"9":{"tf":1.0}}}},"r":{"d":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"67":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"u":{"df":1,"docs":{"1":{"tf":1.0}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":4,"docs":{"1":{"tf":1.4142135623730951},"9":{"tf":1.0},"91":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{":":{":":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"74":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"74":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"88":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":10,"docs":{"1":{"tf":1.7320508075688772},"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"2":{"tf":1.7320508075688772},"3":{"tf":1.7320508075688772},"38":{"tf":1.0},"41":{"tf":1.4142135623730951},"43":{"tf":1.0},"60":{"tf":1.0},"91":{"tf":1.0}},"s":{"/":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"90":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"’":{"df":1,"docs":{"1":{"tf":1.0}}}}},"p":{"df":2,"docs":{"20":{"tf":1.0},"88":{"tf":1.4142135623730951}}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"96":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":17,"docs":{"21":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"34":{"tf":1.7320508075688772},"38":{"tf":1.4142135623730951},"52":{"tf":1.7320508075688772},"54":{"tf":1.0},"6":{"tf":1.4142135623730951},"65":{"tf":1.0},"73":{"tf":1.7320508075688772},"8":{"tf":1.7320508075688772},"80":{"tf":1.7320508075688772},"85":{"tf":1.0},"96":{"tf":1.0}}},"t":{"df":2,"docs":{"27":{"tf":2.8284271247461903},"82":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":4,"docs":{"14":{"tf":1.0},"52":{"tf":1.0},"80":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"i":{"df":3,"docs":{"45":{"tf":1.0},"69":{"tf":1.0},"9":{"tf":1.0}}},"u":{"df":0,"docs":{},"e":{"df":4,"docs":{"46":{"tf":1.4142135623730951},"51":{"tf":1.0},"62":{"tf":1.4142135623730951},"71":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":8,"docs":{"22":{"tf":2.0},"24":{"tf":1.0},"26":{"tf":2.23606797749979},"54":{"tf":1.7320508075688772},"55":{"tf":1.4142135623730951},"74":{"tf":1.0},"75":{"tf":1.0},"80":{"tf":1.0}}}},"r":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"82":{"tf":1.0}}}}}}}},"df":0,"docs":{},"n":{"df":1,"docs":{"95":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"o":{"df":4,"docs":{"45":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"9":{"tf":2.449489742783178}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"1":{"df":1,"docs":{"81":{"tf":1.0}}},"2":{"df":2,"docs":{"23":{"tf":1.0},"81":{"tf":1.4142135623730951}}},"df":20,"docs":{"13":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.7320508075688772},"34":{"tf":3.3166247903554},"35":{"tf":2.23606797749979},"45":{"tf":2.8284271247461903},"46":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.4142135623730951},"61":{"tf":1.7320508075688772},"71":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":2.23606797749979},"81":{"tf":2.6457513110645907},"85":{"tf":1.0}}},"i":{"c":{"df":2,"docs":{"1":{"tf":1.0},"3":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"1":{"2":{"8":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"6":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"2":{"5":{"6":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"2":{"df":4,"docs":{"24":{"tf":1.4142135623730951},"32":{"tf":1.0},"80":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}},"6":{"4":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"8":{"df":3,"docs":{"26":{"tf":1.4142135623730951},"61":{"tf":1.0},"9":{"tf":1.0}}},":":{":":{"a":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"34":{"tf":1.7320508075688772}},"e":{"2":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},">":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"z":{"df":0,"docs":{},"z":{"df":0,"docs":{},"z":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"a":{"df":1,"docs":{"9":{"tf":1.0}}},"df":6,"docs":{"32":{"tf":2.0},"33":{"tf":2.23606797749979},"34":{"tf":3.4641016151377544},"42":{"tf":1.0},"60":{"tf":2.449489742783178},"80":{"tf":1.4142135623730951}},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"59":{"tf":1.7320508075688772},"71":{"tf":1.0},"74":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"85":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"62":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":2,"docs":{"41":{"tf":1.0},"43":{"tf":1.7320508075688772}},"i":{"c":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"9":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"25":{"tf":1.7320508075688772}}}},"t":{"df":5,"docs":{"25":{"tf":1.0},"26":{"tf":1.0},"53":{"tf":1.4142135623730951},"74":{"tf":1.0},"92":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":9,"docs":{"33":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.0},"73":{"tf":1.0},"80":{"tf":1.0},"9":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"k":{"df":1,"docs":{"61":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"s":{"a":{"df":0,"docs":{},"f":{"df":5,"docs":{"21":{"tf":1.0},"36":{"tf":1.4142135623730951},"50":{"tf":2.23606797749979},"51":{"tf":1.0},"80":{"tf":1.0}},"e":{"_":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"_":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":1,"docs":{"50":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"25":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"52":{"tf":1.0},"91":{"tf":1.0}}}},"df":0,"docs":{}},"df":2,"docs":{"14":{"tf":1.0},"95":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"c":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"85":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":2,"docs":{"76":{"tf":1.0},"77":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"89":{"tf":1.0}}}},"s":{"df":55,"docs":{"1":{"tf":2.449489742783178},"14":{"tf":2.0},"16":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.4142135623730951},"20":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.7320508075688772},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.7320508075688772},"33":{"tf":1.7320508075688772},"37":{"tf":2.0},"38":{"tf":1.4142135623730951},"39":{"tf":2.8284271247461903},"40":{"tf":1.0},"41":{"tf":2.23606797749979},"42":{"tf":1.4142135623730951},"43":{"tf":1.7320508075688772},"45":{"tf":1.0},"47":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"5":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.7320508075688772},"52":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"56":{"tf":1.0},"57":{"tf":2.0},"6":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.7320508075688772},"69":{"tf":1.0},"73":{"tf":2.0},"74":{"tf":2.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.4142135623730951},"80":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.4142135623730951},"85":{"tf":1.4142135623730951},"88":{"tf":2.6457513110645907},"89":{"tf":1.4142135623730951},"9":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.4142135623730951},"93":{"tf":1.0},"96":{"tf":1.0}},"e":{"<":{"\'":{"a":{"df":1,"docs":{"82":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":1,"docs":{"90":{"tf":1.0}}}},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"9":{"tf":1.0}}}},"r":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":1,"docs":{"96":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"14":{"tf":1.0},"71":{"tf":1.0}}}},"df":0,"docs":{}}},"z":{"df":1,"docs":{"9":{"tf":1.0}}}},"v":{"0":{"0":{"0":{"df":1,"docs":{"9":{"tf":1.0}}},"1":{"df":1,"docs":{"9":{"tf":1.0}}},"9":{"df":1,"docs":{"9":{"tf":1.0}}},"df":1,"docs":{"9":{"tf":1.0}},"t":{"df":1,"docs":{"9":{"tf":1.0}}}},"1":{"0":{"df":1,"docs":{"9":{"tf":1.0}}},"df":1,"docs":{"9":{"tf":1.0}}},"9":{"df":1,"docs":{"9":{"tf":1.0}}},"df":1,"docs":{"9":{"tf":1.4142135623730951}},"u":{"df":1,"docs":{"9":{"tf":1.0}}}},"1":{"0":{"df":1,"docs":{"9":{"tf":1.0}}},"df":1,"docs":{"9":{"tf":1.0}}},"9":{"df":1,"docs":{"9":{"tf":1.0}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"89":{"tf":1.4142135623730951},"91":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":6,"docs":{"48":{"tf":1.0},"52":{"tf":1.0},"74":{"tf":1.4142135623730951},"8":{"tf":1.0},"88":{"tf":2.8284271247461903},"9":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"85":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"24":{"tf":2.6457513110645907},"71":{"tf":1.0},"85":{"tf":1.0}}}}},"df":1,"docs":{"9":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"90":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":2,"docs":{"56":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}}}},"df":1,"docs":{"80":{"tf":1.4142135623730951}},"e":{"c":{"!":{"[":{"a":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"80":{"tf":1.0}}}}},"t":{"df":1,"docs":{"32":{"tf":1.4142135623730951}}},"u":{"df":1,"docs":{"32":{"tf":1.4142135623730951}}}},"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":9,"docs":{"20":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"88":{"tf":2.0},"9":{"tf":2.23606797749979},"90":{"tf":1.0},"91":{"tf":2.0},"93":{"tf":1.0},"94":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"90":{"tf":1.0}}},"df":0,"docs":{}}},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}}}}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"34":{"tf":1.0},"5":{"tf":1.4142135623730951},"90":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":1,"docs":{"16":{"tf":1.0}}}},"w":{"0":{"0":{"5":{"df":0,"docs":{},"s":{"0":{"9":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"df":0,"docs":{},"s":{"0":{"0":{"9":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"a":{"df":0,"docs":{},"y":{"df":2,"docs":{"3":{"tf":1.0},"9":{"tf":1.0}}}},"df":2,"docs":{"42":{"tf":1.0},"80":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"3":{"tf":1.0},"71":{"tf":1.4142135623730951}}}}},"h":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":2,"docs":{"60":{"tf":1.0},"75":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"2":{"tf":1.0},"20":{"tf":1.0}}}}}}},"i":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":3,"docs":{"14":{"tf":1.0},"8":{"tf":1.7320508075688772},"96":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":3,"docs":{"26":{"tf":1.0},"70":{"tf":1.0},"74":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"82":{"tf":1.0},"88":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"14":{"tf":1.0},"74":{"tf":1.0}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":2,"docs":{"3":{"tf":1.4142135623730951},"89":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":1,"docs":{"90":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":6,"docs":{"14":{"tf":1.0},"38":{"tf":1.0},"5":{"tf":1.4142135623730951},"65":{"tf":1.0},"74":{"tf":1.0},"88":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":13,"docs":{"20":{"tf":1.7320508075688772},"21":{"tf":1.0},"25":{"tf":1.4142135623730951},"26":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"92":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":8,"docs":{"14":{"tf":1.0},"24":{"tf":1.0},"41":{"tf":1.0},"51":{"tf":1.0},"74":{"tf":1.0},"89":{"tf":1.4142135623730951},"90":{"tf":1.0},"91":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"w":{"c":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":4,"docs":{"32":{"tf":1.0},"80":{"tf":1.0},"85":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"70":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"89":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":10,"docs":{"14":{"tf":1.0},"22":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.4142135623730951},"50":{"tf":1.7320508075688772},"54":{"tf":1.0},"57":{"tf":1.0},"63":{"tf":1.0},"76":{"tf":1.0},"88":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"24":{"tf":1.0},"50":{"tf":1.0},"91":{"tf":1.0}}}}}}}}},"x":{"+":{"1":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}},".":{".":{"=":{"df":0,"docs":{},"i":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}},"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{")":{".":{".":{"(":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"(":{")":{".":{"b":{"a":{"df":0,"docs":{},"r":{"(":{")":{".":{"b":{"a":{"df":0,"docs":{},"z":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"76":{"tf":1.0}}}}},"y":{".":{"df":0,"docs":{},"z":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}}},"1":{"2":{"8":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}},"6":{"df":2,"docs":{"9":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}},"3":{"2":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}},"6":{"4":{"df":2,"docs":{"9":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}},"8":{"6":{"_":{"1":{"2":{"8":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"2":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"6":{"4":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"9":{"tf":1.0}}},"7":{"df":1,"docs":{"9":{"tf":1.0}}},"df":2,"docs":{"9":{"tf":1.0},"93":{"tf":1.0}}},"df":20,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"23":{"tf":1.0},"32":{"tf":1.0},"42":{"tf":1.0},"51":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"60":{"tf":1.0},"62":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.0},"7":{"tf":1.0},"72":{"tf":1.4142135623730951},"73":{"tf":1.0},"75":{"tf":1.7320508075688772},"76":{"tf":1.0},"84":{"tf":2.0}}},"y":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":13,"docs":{"15":{"tf":1.0},"23":{"tf":1.0},"32":{"tf":1.4142135623730951},"40":{"tf":1.0},"42":{"tf":1.0},"57":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.4142135623730951},"7":{"tf":1.0},"72":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"6":{"tf":1.0}}}},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"88":{"tf":1.0}}}}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"73":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"z":{"_":{"df":0,"docs":{},"y":{"df":0,"docs":{},"x":{"df":0,"docs":{},"w":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"df":5,"docs":{"40":{"tf":1.0},"42":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":3,"docs":{"7":{"tf":1.0},"9":{"tf":2.6457513110645907},"96":{"tf":1.0}}}}},"y":{"_":{"df":0,"docs":{},"x":{"df":0,"docs":{},"w":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"x":{"df":0,"docs":{},"w":{"_":{"df":1,"docs":{"9":{"tf":1.0}}},"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}}}}},"breadcrumbs":{"root":{"0":{".":{".":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"76":{"tf":1.0}}}},"1":{"0":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":4,"docs":{"51":{"tf":1.0},"52":{"tf":1.0},"72":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}}},"1":{".":{"2":{".":{"3":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"0":{"1":{"df":1,"docs":{"56":{"tf":1.0}}},"df":2,"docs":{"14":{"tf":1.0},"5":{"tf":1.0}}},"df":3,"docs":{"57":{"tf":1.0},"76":{"tf":1.0},"80":{"tf":1.0}}},"1":{"df":1,"docs":{"23":{"tf":1.0}}},"2":{"3":{"4":{"5":{"6":{"7":{"8":{"9":{"0":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"46":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"6":{"8":{"8":{"9":{"df":1,"docs":{"96":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"df":1,"docs":{"62":{"tf":1.0}}},"df":7,"docs":{"57":{"tf":1.0},"60":{"tf":1.0},"72":{"tf":1.4142135623730951},"76":{"tf":1.0},"84":{"tf":1.4142135623730951},"9":{"tf":1.0},"96":{"tf":1.0}}},"2":{".":{"0":{"df":1,"docs":{"89":{"tf":1.0}}},"df":0,"docs":{}},"0":{"1":{"5":{"/":{"2":{"0":{"1":{"8":{"/":{"2":{"0":{"2":{"1":{"df":1,"docs":{"94":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"91":{"tf":1.0},"94":{"tf":1.0}}},"8":{"df":2,"docs":{"91":{"tf":1.0},"94":{"tf":1.0}}},"df":0,"docs":{}},"2":{"1":{"df":2,"docs":{"91":{"tf":1.0},"94":{"tf":1.0}}},"4":{"df":1,"docs":{"93":{"tf":2.6457513110645907}}},"df":0,"docs":{}},"df":1,"docs":{"62":{"tf":1.0}}},"2":{"df":1,"docs":{"23":{"tf":1.4142135623730951}}},"df":2,"docs":{"57":{"tf":1.0},"80":{"tf":1.0}}},"3":{"3":{"df":1,"docs":{"23":{"tf":1.0}}},"df":2,"docs":{"57":{"tf":1.0},"96":{"tf":1.0}}},"4":{".":{"5":{".":{"6":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"df":3,"docs":{"15":{"tf":1.0},"57":{"tf":1.0},"80":{"tf":1.0}}},"df":1,"docs":{"5":{"tf":1.4142135623730951}}},"5":{"df":1,"docs":{"58":{"tf":1.0}}},"8":{"0":{"df":2,"docs":{"14":{"tf":1.7320508075688772},"89":{"tf":1.0}}},"df":1,"docs":{"9":{"tf":1.0}}},"_":{"a":{"b":{"c":{"d":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"50":{"tf":2.6457513110645907},"9":{"tf":1.0}},"z":{"df":0,"docs":{},"y":{"df":0,"docs":{},"x":{"df":0,"docs":{},"w":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"a":{".":{"b":{".":{"c":{"(":{")":{".":{"d":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"df":1,"docs":{"9":{"tf":1.0}}},"2":{"df":1,"docs":{"9":{"tf":1.0}}},":":{":":{"b":{":":{":":{"c":{"df":1,"docs":{"37":{"tf":1.0}}},"d":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{},"{":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":4,"docs":{"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0}}},"c":{":":{":":{"d":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"41":{"tf":1.0}}}}}},"{":{"b":{"df":2,"docs":{"41":{"tf":1.0},"43":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"50":{"tf":3.1622776601683795}},"l":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"_":{"a":{"_":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"50":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"74":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"73":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"5":{"tf":1.4142135623730951},"65":{"tf":1.0},"73":{"tf":1.0}},"l":{"(":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":2,"docs":{"54":{"tf":1.0},"55":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"57":{"tf":1.0},"71":{"tf":2.0},"76":{"tf":1.0}}}}}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"58":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"y":{"df":0,"docs":{},"y":{"df":0,"docs":{},"y":{"df":0,"docs":{},"y":{"df":0,"docs":{},"y":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"71":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}}}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"47":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"a":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"57":{"tf":1.0}}}}}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"71":{"tf":2.0}}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"73":{"tf":1.7320508075688772},"74":{"tf":2.23606797749979}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"b":{"c":{"d":{"df":2,"docs":{"45":{"tf":2.449489742783178},"9":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"46":{"tf":1.0}}}}},"df":1,"docs":{"46":{"tf":1.4142135623730951}}},"df":0,"docs":{},"i":{"df":2,"docs":{"21":{"tf":1.0},"36":{"tf":1.0}},"l":{"df":1,"docs":{"90":{"tf":1.0}}}},"o":{"df":0,"docs":{},"v":{"df":5,"docs":{"5":{"tf":1.0},"51":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.0}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"58":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"90":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"71":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"24":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}}}}}},"d":{"d":{"df":2,"docs":{"51":{"tf":1.0},"6":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"74":{"tf":1.0},"78":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"34":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"89":{"tf":2.0}}}}}}},"df":2,"docs":{"1":{"tf":1.0},"2":{"tf":1.0}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"i":{"c":{"df":4,"docs":{"83":{"tf":1.7320508075688772},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"90":{"tf":1.0}}}}}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"25":{"tf":1.0},"74":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"9":{"tf":1.0}}}},"l":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":1,"docs":{"9":{"tf":2.0}}}}}}}}},"i":{"a":{"df":0,"docs":{},"s":{"df":3,"docs":{"33":{"tf":1.0},"34":{"tf":1.7320508075688772},"35":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":53,"docs":{"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.0},"21":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.7320508075688772},"26":{"tf":1.4142135623730951},"27":{"tf":1.7320508075688772},"28":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.7320508075688772},"33":{"tf":1.4142135623730951},"34":{"tf":1.7320508075688772},"35":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"42":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":2.23606797749979},"46":{"tf":2.0},"47":{"tf":1.0},"48":{"tf":1.4142135623730951},"5":{"tf":1.0},"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.4142135623730951},"7":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":2.0},"72":{"tf":1.0},"73":{"tf":2.23606797749979},"74":{"tf":2.23606797749979},"75":{"tf":1.4142135623730951},"76":{"tf":1.0},"81":{"tf":1.7320508075688772},"82":{"tf":1.0},"84":{"tf":1.0},"88":{"tf":1.0}}}}}}},"df":4,"docs":{"20":{"tf":1.0},"50":{"tf":1.0},"71":{"tf":1.0},"91":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"45":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"74":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"45":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"h":{"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"y":{"df":8,"docs":{"36":{"tf":1.0},"40":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"57":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"50":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"50":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":3,"docs":{"52":{"tf":1.4142135623730951},"70":{"tf":1.0},"75":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":5,"docs":{"16":{"tf":1.0},"45":{"tf":1.4142135623730951},"48":{"tf":1.0},"57":{"tf":1.0},"73":{"tf":1.7320508075688772}}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"50":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"82":{"tf":1.0}}}}}},"d":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"46":{"tf":1.0},"69":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":2.0}}}},"df":0,"docs":{}}}}}}}}}}}}}}},"g":{"df":0,"docs":{},"l":{"df":3,"docs":{"80":{"tf":1.4142135623730951},"82":{"tf":1.0},"89":{"tf":1.0}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"20":{"tf":1.0},"86":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"20":{"tf":1.0},"50":{"tf":1.0},"6":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"50":{"tf":1.0}},"u":{"df":2,"docs":{"6":{"tf":1.0},"73":{"tf":1.0}}}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"50":{"tf":1.0},"73":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"6":{"tf":1.0}}},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":2,"docs":{"70":{"tf":1.0},"75":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"16":{"tf":1.0},"57":{"tf":1.0}}}}}}}}},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"88":{"tf":1.0}}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"71":{"tf":2.0},"76":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"73":{"tf":1.7320508075688772},"74":{"tf":2.23606797749979}}}}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":2,"docs":{"54":{"tf":1.0},"55":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"33":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":5,"docs":{"14":{"tf":1.0},"20":{"tf":1.4142135623730951},"25":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"90":{"tf":1.4142135623730951}}},"df":8,"docs":{"20":{"tf":1.0},"33":{"tf":1.0},"40":{"tf":1.0},"46":{"tf":1.0},"57":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"95":{"tf":1.0}}}}}}}}},"r":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"91":{"tf":1.7320508075688772},"94":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"1":{"df":4,"docs":{"21":{"tf":1.0},"46":{"tf":1.0},"51":{"tf":1.4142135623730951},"65":{"tf":1.0}}},"2":{"df":3,"docs":{"21":{"tf":1.4142135623730951},"46":{"tf":1.0},"51":{"tf":1.4142135623730951}}},"3":{"df":1,"docs":{"46":{"tf":1.0}}},"4":{"df":1,"docs":{"46":{"tf":1.0}}},"df":2,"docs":{"33":{"tf":1.7320508075688772},"82":{"tf":1.0}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"1":{"df":1,"docs":{"73":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"73":{"tf":1.4142135623730951}}},"df":9,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"21":{"tf":1.4142135623730951},"6":{"tf":1.0},"63":{"tf":1.7320508075688772},"64":{"tf":1.7320508075688772},"65":{"tf":1.4142135623730951},"68":{"tf":2.0},"75":{"tf":2.449489742783178}}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}}}}}},"m":{"df":3,"docs":{"73":{"tf":2.8284271247461903},"74":{"tf":1.0},"78":{"tf":1.0}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":15,"docs":{"24":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"32":{"tf":1.0},"37":{"tf":1.0},"47":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":1.0},"76":{"tf":1.0},"80":{"tf":2.8284271247461903},"88":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"y":{"df":4,"docs":{"57":{"tf":2.23606797749979},"58":{"tf":1.4142135623730951},"6":{"tf":1.0},"88":{"tf":1.0}}}},"df":1,"docs":{"75":{"tf":1.0}}}},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}}},"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":1,"docs":{"68":{"tf":1.0}}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":2,"docs":{"33":{"tf":1.0},"60":{"tf":1.7320508075688772}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"90":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":3,"docs":{"32":{"tf":1.0},"35":{"tf":2.0},"89":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"74":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"14":{"tf":1.0},"15":{"tf":3.1622776601683795},"39":{"tf":1.0},"50":{"tf":1.0},"96":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"15":{"tf":1.0},"89":{"tf":1.7320508075688772}}}}},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.0},"20":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":16,"docs":{"21":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":1.4142135623730951},"36":{"tf":1.0},"50":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.0},"81":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}},"b":{":":{":":{"a":{"df":1,"docs":{"40":{"tf":1.0}}},"c":{"df":1,"docs":{"40":{"tf":1.0}}},"d":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"x":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{}},"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{},"{":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"40":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"r":{"(":{"1":{"1":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"1":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}}}}}},"<":{"df":0,"docs":{},"t":{"df":2,"docs":{"33":{"tf":1.0},"34":{"tf":1.0}}}},"[":{"0":{".":{".":{"1":{"0":{"0":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":17,"docs":{"15":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"35":{"tf":1.0},"37":{"tf":1.0},"46":{"tf":1.4142135623730951},"48":{"tf":1.0},"5":{"tf":1.4142135623730951},"58":{"tf":1.0},"60":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":2.449489742783178},"74":{"tf":1.4142135623730951},"81":{"tf":1.0}},"e":{"df":2,"docs":{"88":{"tf":1.0},"89":{"tf":1.0}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"3":{"tf":1.0},"50":{"tf":1.0}}}},"z":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"80":{"tf":1.0}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"1":{"df":1,"docs":{"81":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":11,"docs":{"15":{"tf":1.4142135623730951},"37":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"60":{"tf":1.0},"69":{"tf":1.7320508075688772},"7":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"81":{"tf":1.0}}}},"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"b":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":10,"docs":{"25":{"tf":2.0},"39":{"tf":1.4142135623730951},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":1.0},"80":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"90":{"tf":1.0}}}}}},"df":2,"docs":{"16":{"tf":1.0},"71":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":34,"docs":{"14":{"tf":2.23606797749979},"15":{"tf":1.0},"20":{"tf":1.7320508075688772},"21":{"tf":1.0},"27":{"tf":1.7320508075688772},"28":{"tf":1.4142135623730951},"30":{"tf":1.0},"32":{"tf":1.7320508075688772},"33":{"tf":1.4142135623730951},"34":{"tf":2.6457513110645907},"35":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"50":{"tf":2.0},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"61":{"tf":2.0},"65":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"74":{"tf":1.7320508075688772},"76":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.4142135623730951},"88":{"tf":1.0},"9":{"tf":2.0},"93":{"tf":1.4142135623730951},"96":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"75":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"75":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"38":{"tf":1.0},"57":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"62":{"tf":1.0},"70":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":18,"docs":{"25":{"tf":1.0},"27":{"tf":1.0},"46":{"tf":1.7320508075688772},"48":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"53":{"tf":1.0},"54":{"tf":1.4142135623730951},"55":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"59":{"tf":1.4142135623730951},"63":{"tf":2.0},"64":{"tf":1.7320508075688772},"80":{"tf":1.4142135623730951},"88":{"tf":2.0},"91":{"tf":1.0},"96":{"tf":1.4142135623730951}}}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"60":{"tf":2.0},"61":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"h":{"df":1,"docs":{"51":{"tf":1.0}}},"m":{"b":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"45":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"k":{"df":5,"docs":{"39":{"tf":1.0},"7":{"tf":1.7320508075688772},"8":{"tf":1.0},"88":{"tf":1.4142135623730951},"96":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"45":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"o":{"c":{"df":0,"docs":{},"k":{"_":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"50":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":32,"docs":{"14":{"tf":2.449489742783178},"21":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":2.0},"34":{"tf":1.0},"38":{"tf":1.0},"45":{"tf":2.23606797749979},"46":{"tf":2.8284271247461903},"48":{"tf":1.4142135623730951},"5":{"tf":1.7320508075688772},"50":{"tf":3.872983346207417},"51":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"65":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":2.23606797749979},"73":{"tf":3.0},"74":{"tf":2.0},"75":{"tf":1.4142135623730951},"76":{"tf":1.0},"81":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"d":{"df":0,"docs":{},"i":{"df":4,"docs":{"33":{"tf":1.7320508075688772},"51":{"tf":1.0},"73":{"tf":1.4142135623730951},"74":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"o":{"df":1,"docs":{"51":{"tf":1.0}},"l":{"df":1,"docs":{"71":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":7,"docs":{"1":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":1.0},"45":{"tf":1.0},"76":{"tf":1.0},"88":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":9,"docs":{"27":{"tf":2.449489742783178},"32":{"tf":1.0},"33":{"tf":2.6457513110645907},"35":{"tf":1.0},"76":{"tf":1.4142135623730951},"79":{"tf":1.7320508075688772},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":2.23606797749979}}},"df":0,"docs":{}}},"x":{"<":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}}}}}}},"df":1,"docs":{"81":{"tf":1.0}}}},"r":{"a":{"c":{"df":0,"docs":{},"e":{"df":16,"docs":{"24":{"tf":1.0},"25":{"tf":1.7320508075688772},"27":{"tf":1.7320508075688772},"28":{"tf":1.7320508075688772},"30":{"tf":1.0},"32":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":1.7320508075688772},"50":{"tf":2.23606797749979},"51":{"tf":1.0},"52":{"tf":1.7320508075688772},"71":{"tf":2.6457513110645907},"73":{"tf":1.4142135623730951},"88":{"tf":1.0}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":10,"docs":{"33":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"57":{"tf":2.23606797749979},"58":{"tf":2.0},"71":{"tf":1.0},"80":{"tf":2.0},"82":{"tf":1.0},"88":{"tf":1.4142135623730951},"89":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}},"df":28,"docs":{"2":{"tf":1.0},"21":{"tf":1.0},"27":{"tf":2.449489742783178},"28":{"tf":2.0},"32":{"tf":2.0},"33":{"tf":1.0},"34":{"tf":2.23606797749979},"38":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":2.449489742783178},"48":{"tf":1.0},"53":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":1.7320508075688772},"61":{"tf":2.6457513110645907},"63":{"tf":1.4142135623730951},"65":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.4142135623730951},"74":{"tf":2.8284271247461903},"76":{"tf":1.0},"81":{"tf":3.605551275463989},"91":{"tf":1.0},"92":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"57":{"tf":1.0},"58":{"tf":1.0},"71":{"tf":1.7320508075688772},"76":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"3":{"tf":2.6457513110645907}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"22":{"tf":1.0}}},"df":0,"docs":{}}}}},"c":{":":{":":{"d":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},">":{"(":{"df":0,"docs":{},"t":{"df":1,"docs":{"80":{"tf":1.0}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":13,"docs":{"22":{"tf":1.0},"57":{"tf":1.0},"63":{"tf":2.6457513110645907},"64":{"tf":1.4142135623730951},"65":{"tf":2.0},"66":{"tf":1.7320508075688772},"67":{"tf":1.4142135623730951},"69":{"tf":2.0},"70":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.7320508075688772},"9":{"tf":1.0},"92":{"tf":1.0}},"e":{"df":2,"docs":{"63":{"tf":1.0},"65":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"82":{"tf":1.7320508075688772}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"8":{"tf":1.0}}},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":4,"docs":{"18":{"tf":1.4142135623730951},"87":{"tf":1.7320508075688772},"88":{"tf":1.0},"89":{"tf":1.0}}}}}}},"df":1,"docs":{"96":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"e":{"df":8,"docs":{"15":{"tf":1.0},"24":{"tf":1.0},"46":{"tf":1.0},"57":{"tf":1.0},"65":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.7320508075688772},"9":{"tf":1.0}}},"t":{"df":1,"docs":{"61":{"tf":2.0}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"3":{"tf":1.0}}}}},"df":8,"docs":{"36":{"tf":1.7320508075688772},"39":{"tf":1.4142135623730951},"54":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":1.0},"80":{"tf":1.4142135623730951}},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"61":{"tf":1.0},"69":{"tf":2.23606797749979},"70":{"tf":1.7320508075688772},"71":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"g":{"df":4,"docs":{"20":{"tf":1.0},"91":{"tf":2.0},"93":{"tf":2.0},"95":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"95":{"tf":2.23606797749979}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"14":{"tf":1.0},"16":{"tf":1.0},"5":{"tf":1.0},"9":{"tf":2.8284271247461903}}}},"df":0,"docs":{}},"df":1,"docs":{"14":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"91":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":1,"docs":{"46":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"9":{"tf":3.1622776601683795}}}}}},"i":{"df":1,"docs":{"91":{"tf":1.0}},"r":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":7,"docs":{"27":{"tf":1.0},"32":{"tf":2.449489742783178},"33":{"tf":3.0},"34":{"tf":3.3166247903554},"71":{"tf":2.449489742783178},"72":{"tf":1.0},"74":{"tf":2.6457513110645907}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"81":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":20,"docs":{"14":{"tf":1.4142135623730951},"21":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"38":{"tf":1.0},"46":{"tf":1.4142135623730951},"50":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"71":{"tf":1.4142135623730951},"73":{"tf":1.0},"88":{"tf":1.0}}},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"51":{"tf":2.449489742783178},"75":{"tf":1.7320508075688772}}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":11,"docs":{"1":{"tf":1.4142135623730951},"14":{"tf":1.0},"16":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.0},"88":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":2.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"27":{"tf":1.0},"35":{"tf":1.0},"52":{"tf":1.0},"80":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":1,"docs":{"89":{"tf":1.0}}}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"15":{"tf":1.0},"45":{"tf":1.0},"69":{"tf":1.0},"73":{"tf":1.4142135623730951},"75":{"tf":2.449489742783178}}}}},"df":0,"docs":{},"e":{"df":4,"docs":{"20":{"tf":1.4142135623730951},"40":{"tf":2.0},"9":{"tf":1.4142135623730951},"91":{"tf":1.0}}},"m":{"a":{"df":17,"docs":{"21":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.7320508075688772},"32":{"tf":1.7320508075688772},"33":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"52":{"tf":1.7320508075688772},"54":{"tf":1.4142135623730951},"57":{"tf":1.0},"6":{"tf":2.23606797749979},"63":{"tf":1.4142135623730951},"64":{"tf":1.0},"65":{"tf":1.0},"73":{"tf":1.4142135623730951},"80":{"tf":2.449489742783178},"88":{"tf":1.4142135623730951}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":12,"docs":{"14":{"tf":5.385164807134504},"21":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":3.0},"51":{"tf":1.0},"70":{"tf":1.4142135623730951},"73":{"tf":1.7320508075688772},"8":{"tf":1.0},"96":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"89":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":2.449489742783178}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"60":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}}},"t":{"df":1,"docs":{"90":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}},"x":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"16":{"tf":1.0},"33":{"tf":1.4142135623730951},"46":{"tf":2.23606797749979},"71":{"tf":1.0}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"27":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":7,"docs":{"1":{"tf":1.0},"20":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0},"89":{"tf":1.4142135623730951},"9":{"tf":1.0},"90":{"tf":1.4142135623730951}}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"85":{"tf":1.0}}}}},"df":3,"docs":{"61":{"tf":1.7320508075688772},"80":{"tf":1.0},"85":{"tf":1.0}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"16":{"tf":1.0},"67":{"tf":1.4142135623730951},"91":{"tf":2.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"74":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":7,"docs":{"33":{"tf":1.0},"46":{"tf":2.0},"50":{"tf":2.0},"72":{"tf":1.0},"73":{"tf":1.4142135623730951},"89":{"tf":1.7320508075688772},"96":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"50":{"tf":1.0},"57":{"tf":1.0},"96":{"tf":1.7320508075688772}}}},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"72":{"tf":1.0},"90":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"33":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":5,"docs":{"51":{"tf":1.0},"62":{"tf":1.4142135623730951},"71":{"tf":2.6457513110645907},"73":{"tf":1.0},"90":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":7,"docs":{"17":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"20":{"tf":1.0},"4":{"tf":1.4142135623730951},"87":{"tf":1.7320508075688772},"88":{"tf":1.7320508075688772},"89":{"tf":2.0}}}}}}},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"6":{"tf":1.0},"81":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":1,"docs":{"3":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"78":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.7320508075688772},"94":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"45":{"tf":1.4142135623730951},"71":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"1":{"df":1,"docs":{"88":{"tf":1.4142135623730951}}},"_":{"df":1,"docs":{"85":{"tf":1.0}}},"df":6,"docs":{"14":{"tf":1.0},"20":{"tf":1.0},"29":{"tf":1.7320508075688772},"85":{"tf":1.0},"88":{"tf":1.4142135623730951},"89":{"tf":2.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"89":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"88":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"91":{"tf":1.0},"93":{"tf":1.0}}}}}}}}},"d":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"96":{"tf":1.4142135623730951}}}}},"df":3,"docs":{"39":{"tf":1.4142135623730951},"57":{"tf":1.0},"80":{"tf":1.0}},"e":{"b":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{">":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}},"df":3,"docs":{"27":{"tf":1.0},"32":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951}}}}},"c":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"16":{"tf":1.0},"19":{"tf":1.4142135623730951},"90":{"tf":1.0}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"r":{"df":6,"docs":{"20":{"tf":1.7320508075688772},"24":{"tf":1.0},"25":{"tf":1.0},"32":{"tf":1.0},"45":{"tf":1.4142135623730951},"81":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":7,"docs":{"1":{"tf":1.0},"2":{"tf":2.6457513110645907},"3":{"tf":1.0},"38":{"tf":1.0},"43":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.7320508075688772}}}}}},"df":1,"docs":{"46":{"tf":1.0}},"g":{"df":1,"docs":{"45":{"tf":1.0}}},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"2":{"tf":1.0},"67":{"tf":1.4142135623730951},"74":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"16":{"tf":1.0},"21":{"tf":1.7320508075688772},"31":{"tf":1.0},"51":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"47":{"tf":1.4142135623730951},"75":{"tf":1.0},"96":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"16":{"tf":1.0},"88":{"tf":1.4142135623730951},"96":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"88":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"15":{"tf":1.7320508075688772}},"e":{"(":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"15":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":5,"docs":{"46":{"tf":1.0},"89":{"tf":1.4142135623730951},"91":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"88":{"tf":1.7320508075688772},"89":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"88":{"tf":1.0},"89":{"tf":1.0}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"1":{"tf":1.0},"2":{"tf":1.4142135623730951}}}}}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":3,"docs":{"5":{"tf":1.0},"6":{"tf":1.0},"90":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"16":{"tf":1.4142135623730951},"3":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.7320508075688772}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"73":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"32":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"34":{"tf":1.0},"91":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"o":{"c":{"df":1,"docs":{"14":{"tf":2.0}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"14":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"n":{"\'":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":11,"docs":{"1":{"tf":1.0},"20":{"tf":1.0},"26":{"tf":1.4142135623730951},"37":{"tf":1.0},"45":{"tf":1.0},"51":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"25":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":2,"docs":{"5":{"tf":1.0},"90":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"e":{"df":2,"docs":{"60":{"tf":1.0},"70":{"tf":1.0}}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":23,"docs":{"15":{"tf":1.0},"25":{"tf":1.4142135623730951},"26":{"tf":1.0},"27":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.4142135623730951},"5":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"74":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"81":{"tf":1.0},"89":{"tf":1.4142135623730951},"95":{"tf":1.0}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":24,"docs":{"15":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"24":{"tf":1.7320508075688772},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"33":{"tf":1.7320508075688772},"42":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.4142135623730951},"54":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.4142135623730951},"70":{"tf":1.0},"74":{"tf":1.0},"88":{"tf":1.7320508075688772},"89":{"tf":1.0},"9":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951},"95":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}},"s":{"df":1,"docs":{"90":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"6":{"tf":1.0},"62":{"tf":1.0},"91":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"90":{"tf":1.0},"91":{"tf":4.0},"92":{"tf":1.7320508075688772},"93":{"tf":2.6457513110645907},"94":{"tf":2.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"54":{"tf":2.0},"57":{"tf":1.7320508075688772},"6":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":2.6457513110645907}}}}}}},"i":{"d":{"df":2,"docs":{"51":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"@":{"a":{"d":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"89":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"89":{"tf":2.0}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":4,"docs":{"25":{"tf":1.4142135623730951},"26":{"tf":1.0},"50":{"tf":1.0},"73":{"tf":1.0}}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"d":{"df":8,"docs":{"14":{"tf":1.0},"25":{"tf":1.0},"46":{"tf":1.7320508075688772},"48":{"tf":1.0},"71":{"tf":1.0},"8":{"tf":1.0},"88":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"1":{"tf":1.0},"9":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":3,"docs":{"14":{"tf":1.0},"46":{"tf":1.7320508075688772},"88":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"1":{"tf":1.0},"52":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":3,"docs":{"24":{"tf":2.23606797749979},"56":{"tf":2.0},"85":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"15":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"9":{"tf":2.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"24":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"24":{"tf":1.4142135623730951},"90":{"tf":1.0}}}}}},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"88":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"1":{"tf":1.0},"91":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"c":{"df":2,"docs":{"60":{"tf":1.0},"90":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":6,"docs":{"1":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"67":{"tf":1.0},"9":{"tf":1.0}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"2":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"91":{"tf":1.0}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":23,"docs":{"14":{"tf":1.0},"16":{"tf":1.4142135623730951},"21":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"5":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.7320508075688772},"72":{"tf":1.0},"73":{"tf":1.4142135623730951},"89":{"tf":1.0},"9":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"89":{"tf":1.0}}}}}},"<":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"32":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":5,"docs":{"20":{"tf":1.0},"40":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"25":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"60":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"41":{"tf":1.0},"75":{"tf":1.0}}}}},"df":0,"docs":{}}},"r":{"1":{"df":2,"docs":{"51":{"tf":1.0},"69":{"tf":1.0}}},"2":{"df":2,"docs":{"51":{"tf":1.0},"69":{"tf":1.0}}},"_":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"48":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":6,"docs":{"45":{"tf":2.0},"48":{"tf":1.0},"51":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":37,"docs":{"12":{"tf":1.4142135623730951},"16":{"tf":1.0},"45":{"tf":2.449489742783178},"46":{"tf":2.449489742783178},"48":{"tf":2.23606797749979},"49":{"tf":1.7320508075688772},"50":{"tf":2.0},"51":{"tf":2.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":2.0},"59":{"tf":1.0},"60":{"tf":1.7320508075688772},"61":{"tf":1.0},"62":{"tf":1.7320508075688772},"63":{"tf":1.4142135623730951},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":3.4641016151377544},"72":{"tf":1.4142135623730951},"73":{"tf":2.449489742783178},"74":{"tf":1.0},"75":{"tf":2.23606797749979},"76":{"tf":1.4142135623730951},"77":{"tf":1.0},"78":{"tf":1.4142135623730951},"84":{"tf":1.7320508075688772},"89":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":5,"docs":{"20":{"tf":1.0},"21":{"tf":1.0},"29":{"tf":1.7320508075688772},"36":{"tf":2.8284271247461903},"80":{"tf":1.0}}}}},"r":{"a":{"df":1,"docs":{"51":{"tf":1.0}},"n":{"df":1,"docs":{"62":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"88":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}}},"f":{"1":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}},"3":{"2":{"df":1,"docs":{"15":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"24":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"46":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"70":{"tf":1.0}}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}}}}}},"df":2,"docs":{"45":{"tf":2.6457513110645907},"52":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"88":{"tf":1.0},"95":{"tf":1.4142135623730951},"96":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"96":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"w":{"df":2,"docs":{"26":{"tf":1.0},"42":{"tf":1.0}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"1":{"df":3,"docs":{"51":{"tf":1.0},"52":{"tf":1.7320508075688772},"56":{"tf":1.0}}},"2":{"df":3,"docs":{"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"56":{"tf":1.0}}},"df":8,"docs":{"24":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"26":{"tf":2.0},"52":{"tf":1.7320508075688772},"69":{"tf":2.0},"75":{"tf":1.0},"85":{"tf":1.0},"89":{"tf":2.23606797749979}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":3,"docs":{"20":{"tf":1.0},"88":{"tf":1.0},"96":{"tf":1.0}}}},"n":{"d":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":1,"docs":{"62":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"u":{"3":{"2":{"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":15,"docs":{"20":{"tf":1.0},"27":{"tf":1.0},"40":{"tf":1.0},"45":{"tf":2.0},"51":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0},"64":{"tf":1.0},"69":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"89":{"tf":1.0},"9":{"tf":1.4142135623730951},"91":{"tf":1.0}}}}},"t":{"df":18,"docs":{"21":{"tf":1.0},"25":{"tf":1.4142135623730951},"26":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":2.0},"46":{"tf":1.0},"61":{"tf":1.0},"68":{"tf":1.7320508075688772},"69":{"tf":1.0},"71":{"tf":1.4142135623730951},"73":{"tf":1.0},"74":{"tf":1.7320508075688772},"75":{"tf":1.4142135623730951},"81":{"tf":1.0},"88":{"tf":1.7320508075688772}}},"x":{"df":1,"docs":{"3":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"73":{"tf":1.0}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":4,"docs":{"51":{"tf":1.0},"62":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772},"73":{"tf":1.0}}}}},"n":{"<":{"\'":{"a":{"df":1,"docs":{"80":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":58,"docs":{"14":{"tf":2.0},"15":{"tf":1.0},"16":{"tf":1.0},"21":{"tf":2.23606797749979},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.7320508075688772},"26":{"tf":1.4142135623730951},"27":{"tf":1.7320508075688772},"28":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":2.23606797749979},"33":{"tf":2.449489742783178},"34":{"tf":1.7320508075688772},"35":{"tf":1.0},"36":{"tf":1.7320508075688772},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"42":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":2.23606797749979},"46":{"tf":2.23606797749979},"47":{"tf":1.0},"48":{"tf":2.0},"5":{"tf":1.0},"50":{"tf":2.6457513110645907},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.4142135623730951},"7":{"tf":2.0},"70":{"tf":1.4142135623730951},"71":{"tf":2.0},"72":{"tf":1.0},"73":{"tf":2.23606797749979},"74":{"tf":2.23606797749979},"75":{"tf":1.4142135623730951},"76":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.7320508075688772},"82":{"tf":1.7320508075688772},"84":{"tf":1.0},"88":{"tf":1.0},"96":{"tf":1.0}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":24,"docs":{"14":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"25":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"41":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"51":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.4142135623730951},"6":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.0},"71":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951},"89":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0},"96":{"tf":1.0}}}}}},"o":{"!":{"(":{"a":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"(":{"4":{"df":1,"docs":{"74":{"tf":1.0}}},"a":{"df":1,"docs":{"55":{"tf":1.0}},"r":{"df":0,"docs":{},"g":{"1":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}}}},"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"75":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"15":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}},"x":{"df":1,"docs":{"64":{"tf":1.0}}},"|":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"75":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},".":{"b":{"a":{"df":0,"docs":{},"r":{".":{"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},":":{":":{"b":{"a":{"df":0,"docs":{},"r":{"(":{"a":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},":":{":":{"df":0,"docs":{},"{":{"a":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"80":{"tf":1.0}}}},"df":1,"docs":{"80":{"tf":1.4142135623730951}}},"z":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"{":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}}}}},"df":0,"docs":{}},"<":{"b":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"45":{"tf":1.7320508075688772},"81":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":3,"docs":{"32":{"tf":1.0},"33":{"tf":2.0},"34":{"tf":2.0}}}},"?":{".":{"b":{"a":{"df":0,"docs":{},"r":{"(":{")":{".":{"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"[":{".":{".":{"1":{"0":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"2":{"df":1,"docs":{"58":{"tf":1.0}}},"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"_":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":35,"docs":{"14":{"tf":1.7320508075688772},"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"20":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":2.8284271247461903},"26":{"tf":1.7320508075688772},"27":{"tf":1.4142135623730951},"28":{"tf":1.7320508075688772},"29":{"tf":1.0},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.4142135623730951},"38":{"tf":1.0},"45":{"tf":3.3166247903554},"46":{"tf":1.0},"48":{"tf":1.7320508075688772},"5":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.7320508075688772},"55":{"tf":1.0},"69":{"tf":1.7320508075688772},"7":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":2.23606797749979},"73":{"tf":3.4641016151377544},"74":{"tf":1.0},"76":{"tf":1.0},"80":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":1.4142135623730951}}},"r":{"b":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"85":{"tf":1.0}}}}},"df":1,"docs":{"2":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":38,"docs":{"1":{"tf":2.8284271247461903},"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.7320508075688772},"17":{"tf":1.4142135623730951},"20":{"tf":1.0},"21":{"tf":1.0},"24":{"tf":2.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.7320508075688772},"35":{"tf":1.0},"37":{"tf":1.0},"4":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":2.23606797749979},"52":{"tf":1.0},"56":{"tf":1.0},"61":{"tf":1.4142135623730951},"65":{"tf":1.0},"67":{"tf":2.0},"68":{"tf":2.8284271247461903},"69":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772},"74":{"tf":1.0},"75":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951},"9":{"tf":1.0},"90":{"tf":1.4142135623730951},"91":{"tf":2.0},"95":{"tf":1.7320508075688772}},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":5,"docs":{"42":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.4142135623730951},"73":{"tf":1.0},"74":{"tf":1.7320508075688772}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"16":{"tf":1.0}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"90":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"71":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"96":{"tf":2.8284271247461903}}}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"31":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0}}}},"n":{"c":{"df":2,"docs":{"63":{"tf":1.0},"92":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}},"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":19,"docs":{"15":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":2.449489742783178},"22":{"tf":1.4142135623730951},"39":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"57":{"tf":1.0},"63":{"tf":2.449489742783178},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.4142135623730951},"68":{"tf":1.0},"70":{"tf":1.0},"75":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"85":{"tf":1.0},"92":{"tf":1.0}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"45":{"tf":1.0},"46":{"tf":1.0}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}}}}}}}}}},"g":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"95":{"tf":1.0},"96":{"tf":1.0}}}}},"df":1,"docs":{"45":{"tf":2.6457513110645907}},"e":{"df":0,"docs":{},"n":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{".":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":1,"docs":{"71":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":8,"docs":{"15":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"32":{"tf":3.0},"60":{"tf":1.0},"81":{"tf":1.4142135623730951},"9":{"tf":1.0},"90":{"tf":1.0}},"i":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"df":1,"docs":{"80":{"tf":1.0}}}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"93":{"tf":1.0},"95":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"9":{"tf":1.0},"91":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"o":{"b":{"df":2,"docs":{"40":{"tf":1.0},"41":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":1,"docs":{"89":{"tf":1.0}},"e":{"df":1,"docs":{"14":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"74":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":2,"docs":{"90":{"tf":1.0},"95":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":3,"docs":{"39":{"tf":2.23606797749979},"40":{"tf":1.0},"42":{"tf":1.0}}}}}},"u":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"95":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"d":{"df":11,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":1.7320508075688772},"3":{"tf":2.0},"67":{"tf":1.4142135623730951},"90":{"tf":2.0},"91":{"tf":2.0},"93":{"tf":1.4142135623730951},"94":{"tf":1.0},"95":{"tf":2.0}},"e":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"94":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"14":{"tf":1.0},"19":{"tf":1.4142135623730951},"25":{"tf":1.0},"90":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"34":{"tf":1.0},"61":{"tf":1.0},"71":{"tf":1.4142135623730951},"73":{"tf":2.449489742783178},"74":{"tf":1.7320508075688772}},"l":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"r":{"d":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"90":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"88":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"68":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"95":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}}}}}},"x":{"a":{"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"77":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"90":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"93":{"tf":1.4142135623730951}}}}}}}},"o":{"c":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"89":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"89":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"94":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{".":{"df":6,"docs":{"46":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":1.0}}},"3":{"2":{"df":2,"docs":{"21":{"tf":2.449489742783178},"51":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"d":{"df":1,"docs":{"90":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"71":{"tf":1.0}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":6,"docs":{"14":{"tf":1.0},"24":{"tf":1.0},"55":{"tf":1.0},"82":{"tf":1.0},"85":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}}}},"x":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"67":{"tf":1.0},"9":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":3,"docs":{"28":{"tf":1.0},"33":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"85":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.0}}}},"l":{"<":{"df":0,"docs":{},"t":{"df":2,"docs":{"32":{"tf":1.0},"33":{"tf":1.0}}}},"df":4,"docs":{"28":{"tf":2.8284271247461903},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"3":{"tf":1.4142135623730951},"60":{"tf":1.0},"90":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":9,"docs":{"1":{"tf":1.0},"20":{"tf":1.0},"37":{"tf":1.7320508075688772},"38":{"tf":3.3166247903554},"39":{"tf":2.8284271247461903},"40":{"tf":2.0},"41":{"tf":1.4142135623730951},"42":{"tf":2.6457513110645907},"43":{"tf":1.7320508075688772}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":14,"docs":{"14":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"71":{"tf":1.0},"8":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"90":{"tf":1.0},"93":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":31,"docs":{"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"21":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.7320508075688772},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.7320508075688772},"34":{"tf":2.0},"38":{"tf":1.0},"45":{"tf":2.23606797749979},"46":{"tf":2.0},"5":{"tf":3.0},"50":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"65":{"tf":1.0},"69":{"tf":1.7320508075688772},"70":{"tf":1.0},"71":{"tf":2.0},"73":{"tf":1.4142135623730951},"74":{"tf":1.7320508075688772},"75":{"tf":1.0},"76":{"tf":1.0},"81":{"tf":1.0},"88":{"tf":2.23606797749979}}}},"x":{"<":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"<":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":2,"docs":{"27":{"tf":1.0},"33":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"o":{"<":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"df":1,"docs":{"58":{"tf":2.0}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"27":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"<":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"i":{"c":{"df":3,"docs":{"24":{"tf":1.0},"60":{"tf":1.0},"76":{"tf":1.0}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":2,"docs":{"16":{"tf":1.0},"27":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"1":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"96":{"tf":1.0}}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":5,"docs":{"46":{"tf":2.449489742783178},"50":{"tf":1.0},"57":{"tf":1.7320508075688772},"71":{"tf":1.7320508075688772},"96":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"14":{"tf":1.4142135623730951},"33":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"14":{"tf":1.0},"15":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"2":{"tf":1.0},"60":{"tf":1.0}}}}},"i":{"d":{"df":3,"docs":{"15":{"tf":1.0},"51":{"tf":1.0},"73":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"9":{"tf":1.0},"91":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":2,"docs":{"32":{"tf":1.0},"61":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":1,"docs":{"95":{"tf":1.0}}}},"r":{"df":0,"docs":{},"f":{"a":{"c":{"df":1,"docs":{"90":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"45":{"tf":1.0}}}}},"n":{"df":1,"docs":{"90":{"tf":1.0}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"88":{"tf":1.0}},"t":{"df":20,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"3":{"tf":1.0}}}}}}}}},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"73":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":2,"docs":{"16":{"tf":1.0},"96":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":32,"docs":{"10":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"16":{"tf":2.0},"20":{"tf":3.0},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.7320508075688772},"28":{"tf":1.7320508075688772},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":2.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"73":{"tf":1.0},"88":{"tf":1.7320508075688772}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":5,"docs":{"21":{"tf":1.0},"3":{"tf":1.0},"58":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.4142135623730951}}}}}}}},"j":{"df":0,"docs":{},"o":{"b":{"df":1,"docs":{"91":{"tf":1.0}}},"df":0,"docs":{}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":2,"docs":{"25":{"tf":1.0},"34":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.0}}}},"y":{"df":1,"docs":{"88":{"tf":4.242640687119285}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":12,"docs":{"14":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"46":{"tf":2.23606797749979},"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"71":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"33":{"tf":1.0},"6":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"85":{"tf":1.0}}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"/":{"3":{"7":{"3":{"4":{"3":{"df":0,"docs":{},"f":{"4":{"a":{"4":{"d":{"4":{"df":0,"docs":{},"e":{"d":{"7":{"a":{"d":{"0":{"8":{"9":{"1":{"c":{"b":{"7":{"9":{"df":0,"docs":{},"e":{"8":{"df":0,"docs":{},"e":{"b":{"2":{"5":{"a":{"c":{"df":0,"docs":{},"f":{"4":{"3":{"df":0,"docs":{},"f":{"b":{"8":{"2":{"1":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":1,"docs":{"94":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"2":{"tf":1.0},"67":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"90":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":2,"docs":{"32":{"tf":1.0},"38":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":11,"docs":{"21":{"tf":1.0},"34":{"tf":1.0},"40":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.0},"64":{"tf":1.4142135623730951},"69":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"88":{"tf":1.7320508075688772}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"70":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"91":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"9":{"tf":2.8284271247461903}}},"df":0,"docs":{},"v":{"df":3,"docs":{"16":{"tf":1.0},"34":{"tf":1.0},"61":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":3,"docs":{"71":{"tf":1.0},"73":{"tf":1.7320508075688772},"74":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"14":{"tf":1.0},"69":{"tf":1.0},"9":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"1":{"tf":1.0},"5":{"tf":1.0},"69":{"tf":1.0},"74":{"tf":1.0}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"14":{"tf":1.0},"32":{"tf":1.0},"77":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":8,"docs":{"10":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"33":{"tf":1.0},"46":{"tf":1.4142135623730951},"5":{"tf":1.0},"88":{"tf":1.0}}}}},"x":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"i":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"89":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.4142135623730951}}}}},"n":{"df":0,"docs":{},"e":{"df":50,"docs":{"14":{"tf":2.8284271247461903},"15":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"2":{"tf":1.0},"21":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"24":{"tf":2.449489742783178},"25":{"tf":2.23606797749979},"26":{"tf":2.23606797749979},"27":{"tf":2.0},"28":{"tf":2.0},"32":{"tf":2.449489742783178},"33":{"tf":2.449489742783178},"34":{"tf":1.7320508075688772},"37":{"tf":1.0},"38":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"42":{"tf":2.0},"45":{"tf":3.872983346207417},"46":{"tf":4.358898943540674},"5":{"tf":1.7320508075688772},"50":{"tf":3.1622776601683795},"51":{"tf":1.0},"52":{"tf":2.0},"54":{"tf":2.0},"57":{"tf":1.7320508075688772},"58":{"tf":2.0},"59":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":2.23606797749979},"61":{"tf":2.8284271247461903},"63":{"tf":1.7320508075688772},"64":{"tf":1.4142135623730951},"65":{"tf":2.23606797749979},"68":{"tf":2.0},"69":{"tf":2.8284271247461903},"7":{"tf":1.7320508075688772},"70":{"tf":2.8284271247461903},"71":{"tf":4.0},"72":{"tf":2.0},"73":{"tf":2.6457513110645907},"74":{"tf":3.4641016151377544},"75":{"tf":2.449489742783178},"76":{"tf":1.4142135623730951},"8":{"tf":2.0},"80":{"tf":1.4142135623730951},"81":{"tf":2.23606797749979},"88":{"tf":3.1622776601683795},"89":{"tf":1.0},"96":{"tf":1.7320508075688772}}}},"s":{"df":0,"docs":{},"t":{"df":11,"docs":{"15":{"tf":1.0},"22":{"tf":1.4142135623730951},"24":{"tf":1.0},"38":{"tf":2.23606797749979},"40":{"tf":1.7320508075688772},"41":{"tf":1.0},"42":{"tf":1.0},"6":{"tf":1.0},"75":{"tf":1.0},"88":{"tf":1.4142135623730951},"89":{"tf":1.7320508075688772}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":13,"docs":{"16":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.7320508075688772},"53":{"tf":1.7320508075688772},"54":{"tf":1.4142135623730951},"55":{"tf":1.7320508075688772},"56":{"tf":1.7320508075688772},"57":{"tf":1.7320508075688772},"71":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":2.23606797749979},"8":{"tf":1.7320508075688772},"92":{"tf":1.0}}}}}},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"85":{"tf":1.0}}},"t":{"df":1,"docs":{"96":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"25":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":1,"docs":{"38":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"96":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"25":{"tf":1.4142135623730951}}}}}}},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"48":{"tf":1.0},"71":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"73":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"9":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":3,"docs":{"1":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.4142135623730951}}}}}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"31":{"tf":1.7320508075688772}}}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"20":{"tf":1.0},"39":{"tf":1.0}}}}},"df":8,"docs":{"31":{"tf":1.0},"47":{"tf":1.7320508075688772},"57":{"tf":1.4142135623730951},"67":{"tf":2.449489742783178},"68":{"tf":1.7320508075688772},"73":{"tf":1.0},"75":{"tf":1.0},"85":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"89":{"tf":1.0}}},"n":{"df":56,"docs":{"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.0},"21":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.7320508075688772},"26":{"tf":1.4142135623730951},"27":{"tf":1.7320508075688772},"28":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.7320508075688772},"33":{"tf":1.4142135623730951},"34":{"tf":1.7320508075688772},"35":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"42":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":2.23606797749979},"46":{"tf":2.23606797749979},"47":{"tf":1.0},"48":{"tf":1.4142135623730951},"5":{"tf":1.0},"50":{"tf":1.7320508075688772},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.4142135623730951},"7":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":2.0},"72":{"tf":1.0},"73":{"tf":2.23606797749979},"74":{"tf":2.23606797749979},"75":{"tf":1.4142135623730951},"76":{"tf":1.0},"81":{"tf":1.7320508075688772},"82":{"tf":1.0},"84":{"tf":1.0},"88":{"tf":1.0},"96":{"tf":1.0}}}},"k":{"df":0,"docs":{},"e":{"df":9,"docs":{"41":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.4142135623730951},"61":{"tf":1.0},"62":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0},"91":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"df":2,"docs":{"16":{"tf":1.0},"74":{"tf":1.0}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"90":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"70":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"14":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":6,"docs":{"1":{"tf":1.0},"46":{"tf":1.0},"73":{"tf":3.605551275463989},"74":{"tf":1.7320508075688772},"78":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"df":0,"docs":{}},"x":{"df":3,"docs":{"38":{"tf":1.0},"65":{"tf":1.0},"74":{"tf":1.0}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"9":{"tf":1.0}},"u":{"df":0,"docs":{},"m":{"df":2,"docs":{"14":{"tf":1.0},"5":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"16":{"tf":1.0}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"1":{"tf":1.0},"14":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"g":{"df":4,"docs":{"39":{"tf":1.0},"41":{"tf":1.4142135623730951},"43":{"tf":2.8284271247461903},"90":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"89":{"tf":1.0},"90":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"89":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":3,"docs":{"66":{"tf":1.4142135623730951},"69":{"tf":2.0},"85":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"91":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"90":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"96":{"tf":1.4142135623730951}}}}}}},"s":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"90":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"85":{"tf":1.0}}}}}}},"t":{"/":{"a":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"89":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"x":{"df":1,"docs":{"77":{"tf":1.0}}}},"o":{"d":{"df":2,"docs":{"20":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":5,"docs":{"10":{"tf":1.4142135623730951},"14":{"tf":1.0},"20":{"tf":2.23606797749979},"30":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":10,"docs":{"1":{"tf":1.0},"16":{"tf":1.4142135623730951},"26":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"46":{"tf":1.0},"71":{"tf":1.7320508075688772},"89":{"tf":1.0},"9":{"tf":1.7320508075688772},"96":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}},"v":{"df":0,"docs":{},"e":{"df":4,"docs":{"20":{"tf":1.0},"51":{"tf":1.4142135623730951},"6":{"tf":1.0},"9":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":16,"docs":{"14":{"tf":1.0},"16":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"34":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"46":{"tf":1.7320508075688772},"63":{"tf":1.0},"65":{"tf":1.7320508075688772},"70":{"tf":1.7320508075688772},"72":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.4142135623730951},"88":{"tf":1.0},"89":{"tf":1.0}},"p":{"df":0,"docs":{},"l":{"df":20,"docs":{"15":{"tf":1.0},"24":{"tf":1.4142135623730951},"32":{"tf":1.0},"38":{"tf":1.4142135623730951},"45":{"tf":1.7320508075688772},"46":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0},"65":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.4142135623730951},"88":{"tf":1.0}}}}}}},"t":{"df":2,"docs":{"59":{"tf":1.0},"80":{"tf":1.7320508075688772}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"1":{"df":1,"docs":{"68":{"tf":1.0}}},"2":{"df":1,"docs":{"68":{"tf":1.0}}},"df":18,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"32":{"tf":1.0},"38":{"tf":1.4142135623730951},"40":{"tf":1.0},"47":{"tf":1.0},"56":{"tf":1.4142135623730951},"63":{"tf":1.0},"64":{"tf":1.0},"80":{"tf":1.4142135623730951},"85":{"tf":2.23606797749979},"88":{"tf":2.6457513110645907},"89":{"tf":2.449489742783178},"95":{"tf":1.0}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"84":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":5,"docs":{"34":{"tf":1.0},"38":{"tf":1.0},"60":{"tf":1.0},"81":{"tf":1.4142135623730951},"96":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":2,"docs":{"1":{"tf":1.4142135623730951},"71":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"38":{"tf":1.0},"42":{"tf":2.23606797749979}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"46":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.7320508075688772},"73":{"tf":1.4142135623730951},"74":{"tf":1.0},"92":{"tf":1.0}}}}},"w":{"df":6,"docs":{"1":{"tf":1.4142135623730951},"3":{"tf":1.0},"33":{"tf":1.4142135623730951},"39":{"tf":1.0},"45":{"tf":1.0},"74":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"91":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"14":{"tf":1.4142135623730951},"50":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"88":{"tf":1.4142135623730951}}}}}},"x":{"df":0,"docs":{},"t":{"df":5,"docs":{"46":{"tf":1.0},"61":{"tf":1.0},"88":{"tf":1.0},"9":{"tf":1.0},"92":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"93":{"tf":1.0},"95":{"tf":2.8284271247461903},"96":{"tf":1.0}}}}}}}},"o":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"73":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"n":{"df":10,"docs":{"17":{"tf":1.4142135623730951},"2":{"tf":1.0},"28":{"tf":1.0},"42":{"tf":1.0},"73":{"tf":1.0},"82":{"tf":1.0},"88":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"46":{"tf":1.0}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"16":{"tf":1.0},"34":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"41":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{}}}},"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":9,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"21":{"tf":1.0},"33":{"tf":1.4142135623730951},"38":{"tf":1.0},"70":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.4142135623730951},"91":{"tf":1.0}}},"h":{"df":3,"docs":{"41":{"tf":1.0},"46":{"tf":1.0},"71":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"63":{"tf":1.4142135623730951},"92":{"tf":1.0}}}}},"df":0,"docs":{}}},"m":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"74":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"71":{"tf":1.0},"9":{"tf":2.0},"96":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":2.449489742783178}}}}}}},"o":{"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"72":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"k":{"(":{"a":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"c":{"df":2,"docs":{"25":{"tf":1.0},"73":{"tf":1.0}}},"df":21,"docs":{"1":{"tf":1.0},"21":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"32":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"42":{"tf":1.0},"46":{"tf":1.4142135623730951},"50":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.4142135623730951},"70":{"tf":1.0},"71":{"tf":1.7320508075688772},"74":{"tf":1.0},"80":{"tf":1.0},"88":{"tf":1.0},"9":{"tf":1.4142135623730951},"96":{"tf":1.7320508075688772}},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"58":{"tf":1.0}}}}},"p":{"df":2,"docs":{"59":{"tf":1.0},"60":{"tf":2.23606797749979}},"e":{"df":0,"docs":{},"n":{"df":24,"docs":{"14":{"tf":1.7320508075688772},"21":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"30":{"tf":1.0},"32":{"tf":1.7320508075688772},"38":{"tf":1.0},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"50":{"tf":1.7320508075688772},"52":{"tf":1.4142135623730951},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"63":{"tf":1.0},"64":{"tf":1.4142135623730951},"65":{"tf":1.0},"71":{"tf":2.23606797749979},"73":{"tf":1.0},"88":{"tf":1.0},"96":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"59":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":6,"docs":{"59":{"tf":1.7320508075688772},"60":{"tf":3.3166247903554},"61":{"tf":1.7320508075688772},"69":{"tf":1.0},"71":{"tf":1.4142135623730951},"76":{"tf":1.0}}}},"t":{"df":1,"docs":{"46":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"2":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0},"71":{"tf":1.0}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":10,"docs":{"15":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"39":{"tf":2.0},"40":{"tf":1.4142135623730951},"81":{"tf":1.0},"88":{"tf":1.4142135623730951},"9":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":13,"docs":{"27":{"tf":1.0},"28":{"tf":1.0},"33":{"tf":1.0},"41":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"55":{"tf":1.0},"57":{"tf":1.0},"65":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"88":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}}}}}},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"24":{"tf":1.0},"88":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"75":{"tf":1.0}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"81":{"tf":1.0}}}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"81":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"=":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"27":{"tf":2.0}}}}}}},"df":2,"docs":{"33":{"tf":2.23606797749979},"39":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"5":{"tf":1.0},"65":{"tf":1.0},"91":{"tf":1.0}},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"88":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"88":{"tf":2.0},"9":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"75":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"22":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"64":{"tf":1.7320508075688772},"80":{"tf":1.0}},"t":{"df":1,"docs":{"71":{"tf":1.0}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":11,"docs":{"26":{"tf":1.4142135623730951},"46":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.0},"60":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"71":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"80":{"tf":1.0}},"i":{"df":6,"docs":{"21":{"tf":1.4142135623730951},"32":{"tf":1.0},"54":{"tf":1.4142135623730951},"55":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":1.4142135623730951}}}}}}}}},"s":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}},"t":{"df":1,"docs":{"32":{"tf":1.0}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":6,"docs":{"16":{"tf":1.0},"2":{"tf":1.0},"26":{"tf":1.0},"61":{"tf":1.0},"67":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":1,"docs":{"67":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"6":{"tf":1.0},"91":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"82":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.7320508075688772}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":6,"docs":{"1":{"tf":1.0},"45":{"tf":2.6457513110645907},"46":{"tf":1.7320508075688772},"73":{"tf":1.0},"74":{"tf":2.8284271247461903},"78":{"tf":2.0}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"21":{"tf":1.0}}}}},"r":{"df":1,"docs":{"74":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":6,"docs":{"16":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"90":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"u":{"df":1,"docs":{"69":{"tf":1.0}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"95":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"46":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"47":{"tf":1.7320508075688772},"48":{"tf":1.7320508075688772},"50":{"tf":2.0}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":17,"docs":{"15":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"37":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"58":{"tf":1.0},"69":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.4142135623730951},"81":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"90":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"d":{"df":6,"docs":{"34":{"tf":1.7320508075688772},"46":{"tf":2.0},"60":{"tf":1.4142135623730951},"63":{"tf":1.0},"71":{"tf":1.4142135623730951},"76":{"tf":1.0}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"82":{"tf":1.7320508075688772},"9":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":18,"docs":{"14":{"tf":2.0},"15":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"32":{"tf":1.7320508075688772},"33":{"tf":1.0},"38":{"tf":1.4142135623730951},"5":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.7320508075688772},"63":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.4142135623730951},"74":{"tf":1.0},"81":{"tf":1.4142135623730951},"84":{"tf":1.0}}}},"i":{"df":0,"docs":{},"x":{"df":2,"docs":{"51":{"tf":1.0},"71":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"34":{"tf":1.0},"40":{"tf":1.4142135623730951},"45":{"tf":1.0},"89":{"tf":1.4142135623730951},"96":{"tf":1.0}}}},"r":{"df":0,"docs":{},"v":{"df":3,"docs":{"15":{"tf":1.0},"8":{"tf":1.0},"90":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"39":{"tf":1.0},"90":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"19":{"tf":1.4142135623730951},"90":{"tf":2.0}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"n":{"df":1,"docs":{"68":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"90":{"tf":1.0}}}}}}}},"o":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"95":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"9":{"tf":1.4142135623730951}},"t":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":1,"docs":{"1":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"77":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"48":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"21":{"tf":1.0},"26":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":4,"docs":{"45":{"tf":1.0},"71":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"b":{"df":6,"docs":{"14":{"tf":1.0},"21":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"25":{"tf":1.0}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}},"s":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"t":{"df":37,"docs":{"14":{"tf":2.449489742783178},"15":{"tf":1.4142135623730951},"20":{"tf":1.0},"21":{"tf":1.0},"24":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"27":{"tf":2.0},"28":{"tf":1.0},"32":{"tf":2.449489742783178},"33":{"tf":1.7320508075688772},"35":{"tf":1.0},"37":{"tf":1.0},"45":{"tf":2.0},"46":{"tf":1.7320508075688772},"47":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"52":{"tf":2.0},"54":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.7320508075688772},"58":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"63":{"tf":2.0},"64":{"tf":1.4142135623730951},"65":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772},"72":{"tf":1.0},"74":{"tf":1.4142135623730951},"76":{"tf":1.0},"80":{"tf":1.0},"88":{"tf":2.8284271247461903}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":3,"docs":{"46":{"tf":1.0},"50":{"tf":1.0},"56":{"tf":1.0}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"88":{"tf":1.4142135623730951}}}},"x":{"(":{"\\"":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"46":{"tf":1.0}}}}}}}}}}}}}}}}}}}},"df":0,"docs":{}},"df":4,"docs":{"60":{"tf":1.0},"69":{"tf":2.23606797749979},"73":{"tf":1.0},"74":{"tf":1.0}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"45":{"tf":2.23606797749979}}}}}},"r":{"#":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"85":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"76":{"tf":2.449489742783178}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"90":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}},"w":{"df":1,"docs":{"85":{"tf":1.0}}}},"df":1,"docs":{"40":{"tf":1.0}},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"9":{"tf":1.0}}}},"d":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"90":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"68":{"tf":1.0},"71":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"96":{"tf":1.0}}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"14":{"tf":1.0},"2":{"tf":1.0},"77":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"d":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":4,"docs":{"40":{"tf":1.0},"41":{"tf":1.0},"69":{"tf":1.0},"75":{"tf":1.0}}}}}},"df":1,"docs":{"39":{"tf":1.4142135623730951}},"f":{"df":1,"docs":{"74":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"2":{"tf":1.4142135623730951},"60":{"tf":1.0},"95":{"tf":1.0}}}}},"g":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"95":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"96":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"61":{"tf":1.0}}},"df":2,"docs":{"45":{"tf":1.0},"88":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"v":{"df":3,"docs":{"6":{"tf":1.4142135623730951},"60":{"tf":1.0},"95":{"tf":1.0}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"95":{"tf":1.0}}}}}}}}},"r":{"(":{"c":{"df":1,"docs":{"15":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":14,"docs":{"1":{"tf":1.0},"24":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"38":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"6":{"tf":1.0},"61":{"tf":1.4142135623730951},"74":{"tf":1.0},"8":{"tf":1.0},"81":{"tf":1.0},"88":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"85":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"3":{"tf":1.0}}}}},"t":{"df":2,"docs":{"45":{"tf":1.0},"95":{"tf":1.4142135623730951}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"75":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"46":{"tf":2.8284271247461903},"48":{"tf":1.0},"51":{"tf":1.0}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"33":{"tf":1.4142135623730951}}}}}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":6,"docs":{"25":{"tf":1.4142135623730951},"34":{"tf":1.0},"61":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.7320508075688772},"74":{"tf":1.0}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"5":{"tf":1.0},"90":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"96":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"90":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":18,"docs":{"1":{"tf":1.4142135623730951},"33":{"tf":1.0},"38":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.4142135623730951},"61":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"90":{"tf":1.0},"91":{"tf":1.0}}}},"n":{"df":1,"docs":{"65":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"c":{"df":1,"docs":{"90":{"tf":1.0}}},"df":13,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.0},"2":{"tf":2.23606797749979},"20":{"tf":1.0},"21":{"tf":1.0},"3":{"tf":1.4142135623730951},"88":{"tf":1.0},"9":{"tf":1.7320508075688772},"91":{"tf":4.242640687119285},"92":{"tf":1.7320508075688772},"93":{"tf":2.8284271247461903},"94":{"tf":2.449489742783178},"95":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":6,"docs":{"1":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":2.0},"90":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0}}}}},"’":{"df":1,"docs":{"84":{"tf":1.0}}}}}}},"s":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"76":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":16,"docs":{"20":{"tf":1.0},"25":{"tf":1.7320508075688772},"33":{"tf":1.4142135623730951},"39":{"tf":1.0},"45":{"tf":1.4142135623730951},"46":{"tf":2.449489742783178},"50":{"tf":1.4142135623730951},"57":{"tf":1.0},"61":{"tf":1.0},"71":{"tf":1.7320508075688772},"73":{"tf":1.7320508075688772},"75":{"tf":1.4142135623730951},"77":{"tf":1.4142135623730951},"88":{"tf":2.0},"9":{"tf":1.4142135623730951},"91":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"1":{"tf":1.0}}}}},"c":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"90":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"89":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"81":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"85":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":2,"docs":{"40":{"tf":1.0},"51":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"21":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"24":{"tf":1.0},"51":{"tf":1.0},"69":{"tf":1.4142135623730951},"71":{"tf":1.0},"76":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"71":{"tf":1.0},"78":{"tf":1.0},"81":{"tf":1.0},"88":{"tf":3.3166247903554},"95":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{},"e":{"df":5,"docs":{"16":{"tf":1.0},"68":{"tf":1.0},"78":{"tf":1.0},"88":{"tf":1.0},"93":{"tf":1.0}}},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"82":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"f":{".":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"71":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"(":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"70":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"(":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"70":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},":":{":":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":2.23606797749979}}}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"20":{"tf":1.0},"40":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"20":{"tf":1.0},"91":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":9,"docs":{"26":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"33":{"tf":1.0},"45":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.7320508075688772},"57":{"tf":1.0},"73":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"90":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"14":{"tf":1.0},"89":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":12,"docs":{"26":{"tf":1.0},"39":{"tf":1.0},"45":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"80":{"tf":1.0},"88":{"tf":1.4142135623730951},"9":{"tf":1.0},"91":{"tf":1.4142135623730951},"96":{"tf":1.0}}}},"df":0,"docs":{}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":3,"docs":{"69":{"tf":1.0},"88":{"tf":1.0},"9":{"tf":1.7320508075688772}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"61":{"tf":1.4142135623730951},"96":{"tf":1.0}}}},"t":{"df":4,"docs":{"1":{"tf":1.0},"20":{"tf":1.0},"39":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"h":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"85":{"tf":2.6457513110645907}}}}},"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"96":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"33":{"tf":1.0},"46":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":6,"docs":{"34":{"tf":1.0},"45":{"tf":1.0},"61":{"tf":1.0},"71":{"tf":1.4142135623730951},"73":{"tf":2.449489742783178},"74":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"14":{"tf":2.6457513110645907},"80":{"tf":1.0}}}},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"21":{"tf":1.4142135623730951},"28":{"tf":1.0}}}}}},"df":1,"docs":{"15":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":4,"docs":{"1":{"tf":1.0},"57":{"tf":1.0},"67":{"tf":1.0},"75":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"16":{"tf":1.0},"9":{"tf":1.0}},"i":{"c":{"df":1,"docs":{"90":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"25":{"tf":1.0},"26":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":28,"docs":{"14":{"tf":2.0},"15":{"tf":1.7320508075688772},"16":{"tf":1.0},"23":{"tf":1.4142135623730951},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":1.4142135623730951},"38":{"tf":1.0},"45":{"tf":1.4142135623730951},"46":{"tf":2.449489742783178},"50":{"tf":2.449489742783178},"52":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"57":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"70":{"tf":1.0},"71":{"tf":2.23606797749979},"72":{"tf":2.0},"73":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"80":{"tf":2.6457513110645907},"82":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}},"df":0,"docs":{}}},"z":{"df":0,"docs":{},"e":{"df":3,"docs":{"16":{"tf":1.0},"33":{"tf":1.0},"82":{"tf":1.4142135623730951}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"14":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"58":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"74":{"tf":2.0}}}}}}},"df":0,"docs":{}}}},"df":9,"docs":{"16":{"tf":2.23606797749979},"24":{"tf":1.0},"52":{"tf":1.0},"57":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":2.23606797749979}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"14":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0}}}}}}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"85":{"tf":2.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"9":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"(":{"1":{"df":1,"docs":{"46":{"tf":1.7320508075688772}}},"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"71":{"tf":1.0}}},"b":{"df":1,"docs":{"71":{"tf":2.449489742783178}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":2,"docs":{"71":{"tf":1.0},"74":{"tf":1.0}}}}},"p":{"df":1,"docs":{"71":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"x":{"df":1,"docs":{"46":{"tf":1.7320508075688772}}}},"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"y":{"?":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"88":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"88":{"tf":1.0}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"2":{"df":1,"docs":{"34":{"tf":1.0}}},"df":1,"docs":{"34":{"tf":2.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"72":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{">":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{":":{":":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"80":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"r":{"df":0,"docs":{},"t":{"df":6,"docs":{"20":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"88":{"tf":1.0},"9":{"tf":3.605551275463989},"93":{"tf":1.7320508075688772}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":39,"docs":{"14":{"tf":1.7320508075688772},"15":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"32":{"tf":2.0},"33":{"tf":1.0},"35":{"tf":1.0},"37":{"tf":1.0},"45":{"tf":1.7320508075688772},"46":{"tf":1.4142135623730951},"47":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"52":{"tf":2.0},"54":{"tf":1.4142135623730951},"55":{"tf":1.0},"57":{"tf":1.7320508075688772},"58":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"63":{"tf":2.0},"64":{"tf":1.0},"66":{"tf":1.0},"71":{"tf":1.4142135623730951},"76":{"tf":1.0},"80":{"tf":4.242640687119285},"88":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":3,"docs":{"51":{"tf":1.0},"58":{"tf":1.0},"71":{"tf":1.0}}}},"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"89":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"24":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":3,"docs":{"67":{"tf":1.0},"88":{"tf":1.0},"90":{"tf":1.0}},"i":{"df":3,"docs":{"16":{"tf":1.0},"36":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":6,"docs":{"15":{"tf":1.0},"38":{"tf":1.0},"45":{"tf":1.4142135623730951},"52":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.4142135623730951}}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"r":{"df":7,"docs":{"46":{"tf":1.0},"47":{"tf":1.0},"57":{"tf":2.23606797749979},"58":{"tf":2.0},"71":{"tf":1.0},"80":{"tf":1.0},"88":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}}},"l":{"df":1,"docs":{"95":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"72":{"tf":1.0}}}}},"r":{"d":{"df":2,"docs":{"67":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":9,"docs":{"14":{"tf":1.0},"33":{"tf":1.0},"39":{"tf":1.0},"73":{"tf":1.7320508075688772},"74":{"tf":1.0},"88":{"tf":1.7320508075688772},"89":{"tf":1.0},"9":{"tf":1.0},"96":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":13,"docs":{"11":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"44":{"tf":1.7320508075688772},"45":{"tf":1.7320508075688772},"46":{"tf":3.7416573867739413},"47":{"tf":2.0},"48":{"tf":2.0},"50":{"tf":2.23606797749979},"51":{"tf":1.0},"7":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.4142135623730951}}}}}}},"i":{"c":{"df":1,"docs":{"85":{"tf":1.0}}},"df":0,"docs":{}}},"y":{"df":1,"docs":{"45":{"tf":1.0}}}},"d":{":":{":":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{":":{":":{"c":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"46":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"45":{"tf":1.0},"61":{"tf":1.0},"91":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"71":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"r":{"df":1,"docs":{"61":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":8,"docs":{"26":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"68":{"tf":2.449489742783178},"8":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951},"89":{"tf":1.0},"9":{"tf":3.1622776601683795}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":13,"docs":{"14":{"tf":1.0},"15":{"tf":1.7320508075688772},"16":{"tf":1.0},"22":{"tf":1.7320508075688772},"23":{"tf":1.0},"24":{"tf":2.8284271247461903},"25":{"tf":3.872983346207417},"26":{"tf":3.605551275463989},"52":{"tf":1.7320508075688772},"55":{"tf":1.4142135623730951},"56":{"tf":1.0},"75":{"tf":1.0},"85":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":18,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.7320508075688772},"2":{"tf":3.1622776601683795},"3":{"tf":2.449489742783178},"50":{"tf":1.0},"67":{"tf":1.4142135623730951},"70":{"tf":1.0},"83":{"tf":1.7320508075688772},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.4142135623730951},"90":{"tf":1.4142135623730951},"91":{"tf":4.795831523312719},"92":{"tf":1.7320508075688772},"93":{"tf":3.0},"94":{"tf":2.23606797749979},"95":{"tf":2.8284271247461903}}}}}},"u":{"b":{"df":4,"docs":{"16":{"tf":1.0},"60":{"tf":1.0},"71":{"tf":2.0},"75":{"tf":1.0}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"45":{"tf":1.0},"89":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":8,"docs":{"45":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.7320508075688772},"69":{"tf":1.0},"81":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"h":{"df":16,"docs":{"1":{"tf":1.4142135623730951},"2":{"tf":1.7320508075688772},"20":{"tf":1.0},"24":{"tf":1.0},"3":{"tf":1.0},"36":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.0},"81":{"tf":1.4142135623730951},"85":{"tf":1.0},"88":{"tf":2.0},"9":{"tf":1.4142135623730951},"90":{"tf":1.0},"91":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"89":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"20":{"tf":1.0},"40":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"f":{"a":{"c":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"y":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":5,"docs":{"51":{"tf":1.0},"52":{"tf":1.0},"90":{"tf":1.0},"95":{"tf":2.23606797749979},"96":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"b":{"df":1,"docs":{"91":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"t":{"a":{"b":{"df":1,"docs":{"5":{"tf":1.0}},"l":{"df":1,"docs":{"88":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":3,"docs":{"1":{"tf":1.0},"60":{"tf":1.0},"68":{"tf":1.0}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}},"df":8,"docs":{"14":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":2.6457513110645907},"34":{"tf":2.0},"60":{"tf":2.449489742783178},"80":{"tf":3.7416573867739413},"81":{"tf":1.0},"82":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"m":{"df":3,"docs":{"3":{"tf":1.4142135623730951},"90":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"33":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"89":{"tf":1.0},"90":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"50":{"tf":2.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":3,"docs":{"1":{"tf":1.0},"20":{"tf":1.0},"9":{"tf":1.0}}}},"r":{"d":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"67":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"u":{"df":1,"docs":{"1":{"tf":1.0}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":4,"docs":{"1":{"tf":1.4142135623730951},"9":{"tf":1.0},"91":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{":":{":":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"74":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"74":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"88":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":10,"docs":{"1":{"tf":2.0},"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"2":{"tf":1.7320508075688772},"3":{"tf":1.7320508075688772},"38":{"tf":1.0},"41":{"tf":1.4142135623730951},"43":{"tf":1.0},"60":{"tf":1.0},"91":{"tf":1.0}},"s":{"/":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"90":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"’":{"df":1,"docs":{"1":{"tf":1.0}}}}},"p":{"df":2,"docs":{"20":{"tf":1.0},"88":{"tf":1.4142135623730951}}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"96":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":17,"docs":{"21":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"34":{"tf":1.7320508075688772},"38":{"tf":1.4142135623730951},"52":{"tf":1.7320508075688772},"54":{"tf":1.0},"6":{"tf":1.7320508075688772},"65":{"tf":1.0},"73":{"tf":1.7320508075688772},"8":{"tf":2.0},"80":{"tf":1.7320508075688772},"85":{"tf":1.0},"96":{"tf":1.0}}},"t":{"df":2,"docs":{"27":{"tf":3.0},"82":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":4,"docs":{"14":{"tf":1.0},"52":{"tf":1.0},"80":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"i":{"df":3,"docs":{"45":{"tf":1.0},"69":{"tf":1.0},"9":{"tf":1.0}}},"u":{"df":0,"docs":{},"e":{"df":4,"docs":{"46":{"tf":1.4142135623730951},"51":{"tf":1.0},"62":{"tf":1.4142135623730951},"71":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":8,"docs":{"22":{"tf":2.449489742783178},"24":{"tf":1.0},"26":{"tf":2.449489742783178},"54":{"tf":2.0},"55":{"tf":1.7320508075688772},"74":{"tf":1.0},"75":{"tf":1.0},"80":{"tf":1.0}}}},"r":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"82":{"tf":1.0}}}}}}}},"df":0,"docs":{},"n":{"df":1,"docs":{"95":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"o":{"df":4,"docs":{"45":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"9":{"tf":2.449489742783178}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"1":{"df":1,"docs":{"81":{"tf":1.0}}},"2":{"df":2,"docs":{"23":{"tf":1.0},"81":{"tf":1.4142135623730951}}},"df":21,"docs":{"13":{"tf":1.4142135623730951},"20":{"tf":1.0},"22":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.7320508075688772},"34":{"tf":3.4641016151377544},"35":{"tf":2.449489742783178},"45":{"tf":2.8284271247461903},"46":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.4142135623730951},"61":{"tf":1.7320508075688772},"71":{"tf":1.0},"79":{"tf":1.7320508075688772},"80":{"tf":2.449489742783178},"81":{"tf":2.8284271247461903},"82":{"tf":1.0},"85":{"tf":1.0}}},"i":{"c":{"df":2,"docs":{"1":{"tf":1.0},"3":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"1":{"2":{"8":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"6":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"2":{"5":{"6":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"2":{"df":4,"docs":{"24":{"tf":1.4142135623730951},"32":{"tf":1.0},"80":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}},"6":{"4":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"8":{"df":3,"docs":{"26":{"tf":1.4142135623730951},"61":{"tf":1.0},"9":{"tf":1.0}}},":":{":":{"a":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"34":{"tf":1.7320508075688772}},"e":{"2":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},">":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"z":{"df":0,"docs":{},"z":{"df":0,"docs":{},"z":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"a":{"df":1,"docs":{"9":{"tf":1.0}}},"df":6,"docs":{"32":{"tf":2.0},"33":{"tf":2.23606797749979},"34":{"tf":3.4641016151377544},"42":{"tf":1.0},"60":{"tf":2.449489742783178},"80":{"tf":1.4142135623730951}},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"59":{"tf":2.0},"71":{"tf":1.0},"74":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"85":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"62":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":2,"docs":{"41":{"tf":1.0},"43":{"tf":1.7320508075688772}},"i":{"c":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"9":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"25":{"tf":2.0}}}},"t":{"df":5,"docs":{"25":{"tf":1.0},"26":{"tf":1.0},"53":{"tf":1.7320508075688772},"74":{"tf":1.0},"92":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":9,"docs":{"33":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.0},"73":{"tf":1.0},"80":{"tf":1.0},"9":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"k":{"df":1,"docs":{"61":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"s":{"a":{"df":0,"docs":{},"f":{"df":5,"docs":{"21":{"tf":1.0},"36":{"tf":1.4142135623730951},"50":{"tf":2.23606797749979},"51":{"tf":1.0},"80":{"tf":1.0}},"e":{"_":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"_":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":1,"docs":{"50":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"25":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"52":{"tf":1.0},"91":{"tf":1.0}}}},"df":0,"docs":{}},"df":2,"docs":{"14":{"tf":1.0},"95":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"c":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"85":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":2,"docs":{"76":{"tf":1.0},"77":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"89":{"tf":1.0}}}},"s":{"df":55,"docs":{"1":{"tf":2.6457513110645907},"14":{"tf":2.0},"16":{"tf":1.0},"19":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"20":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.7320508075688772},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.7320508075688772},"33":{"tf":1.7320508075688772},"37":{"tf":2.23606797749979},"38":{"tf":1.4142135623730951},"39":{"tf":2.8284271247461903},"40":{"tf":1.0},"41":{"tf":2.23606797749979},"42":{"tf":1.4142135623730951},"43":{"tf":1.7320508075688772},"45":{"tf":1.0},"47":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"5":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.7320508075688772},"52":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"56":{"tf":1.0},"57":{"tf":2.0},"6":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":2.0},"69":{"tf":1.0},"73":{"tf":2.0},"74":{"tf":2.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.4142135623730951},"80":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.4142135623730951},"85":{"tf":1.4142135623730951},"88":{"tf":2.6457513110645907},"89":{"tf":1.4142135623730951},"9":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.4142135623730951},"93":{"tf":1.0},"96":{"tf":1.0}},"e":{"<":{"\'":{"a":{"df":1,"docs":{"82":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":1,"docs":{"90":{"tf":1.0}}}},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"9":{"tf":1.0}}}},"r":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":1,"docs":{"96":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"14":{"tf":1.0},"71":{"tf":1.0}}}},"df":0,"docs":{}}},"z":{"df":1,"docs":{"9":{"tf":1.0}}}},"v":{"0":{"0":{"0":{"df":1,"docs":{"9":{"tf":1.0}}},"1":{"df":1,"docs":{"9":{"tf":1.0}}},"9":{"df":1,"docs":{"9":{"tf":1.0}}},"df":1,"docs":{"9":{"tf":1.0}},"t":{"df":1,"docs":{"9":{"tf":1.0}}}},"1":{"0":{"df":1,"docs":{"9":{"tf":1.0}}},"df":1,"docs":{"9":{"tf":1.0}}},"9":{"df":1,"docs":{"9":{"tf":1.0}}},"df":1,"docs":{"9":{"tf":1.4142135623730951}},"u":{"df":1,"docs":{"9":{"tf":1.0}}}},"1":{"0":{"df":1,"docs":{"9":{"tf":1.0}}},"df":1,"docs":{"9":{"tf":1.0}}},"9":{"df":1,"docs":{"9":{"tf":1.0}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"89":{"tf":1.4142135623730951},"91":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":6,"docs":{"48":{"tf":1.0},"52":{"tf":1.0},"74":{"tf":1.4142135623730951},"8":{"tf":1.0},"88":{"tf":2.8284271247461903},"9":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"85":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"24":{"tf":2.6457513110645907},"71":{"tf":1.0},"85":{"tf":1.0}}}}},"df":1,"docs":{"9":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"90":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":2,"docs":{"56":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}}}},"df":1,"docs":{"80":{"tf":1.4142135623730951}},"e":{"c":{"!":{"[":{"a":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"80":{"tf":1.0}}}}},"t":{"df":1,"docs":{"32":{"tf":1.4142135623730951}}},"u":{"df":1,"docs":{"32":{"tf":1.4142135623730951}}}},"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":9,"docs":{"20":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"88":{"tf":2.0},"9":{"tf":2.23606797749979},"90":{"tf":1.0},"91":{"tf":2.0},"93":{"tf":1.0},"94":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"90":{"tf":1.0}}},"df":0,"docs":{}}},"y":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}}}}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"34":{"tf":1.0},"5":{"tf":1.4142135623730951},"90":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":1,"docs":{"16":{"tf":1.0}}}},"w":{"0":{"0":{"5":{"df":0,"docs":{},"s":{"0":{"9":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"df":0,"docs":{},"s":{"0":{"0":{"9":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"a":{"df":0,"docs":{},"y":{"df":2,"docs":{"3":{"tf":1.0},"9":{"tf":1.0}}}},"df":2,"docs":{"42":{"tf":1.0},"80":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"3":{"tf":1.0},"71":{"tf":1.4142135623730951}}}}},"h":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":2,"docs":{"60":{"tf":1.0},"75":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"2":{"tf":1.0},"20":{"tf":1.0}}}}}}},"i":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":3,"docs":{"14":{"tf":1.0},"8":{"tf":2.0},"96":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":3,"docs":{"26":{"tf":1.0},"70":{"tf":1.0},"74":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"82":{"tf":1.0},"88":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"14":{"tf":1.0},"74":{"tf":1.0}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":2,"docs":{"3":{"tf":1.4142135623730951},"89":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":1,"docs":{"90":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":6,"docs":{"14":{"tf":1.0},"38":{"tf":1.0},"5":{"tf":1.7320508075688772},"65":{"tf":1.0},"74":{"tf":1.0},"88":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":13,"docs":{"20":{"tf":1.7320508075688772},"21":{"tf":1.0},"25":{"tf":1.4142135623730951},"26":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"92":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":8,"docs":{"14":{"tf":1.0},"24":{"tf":1.0},"41":{"tf":1.0},"51":{"tf":1.0},"74":{"tf":1.0},"89":{"tf":1.4142135623730951},"90":{"tf":1.0},"91":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"w":{"c":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":4,"docs":{"32":{"tf":1.0},"80":{"tf":1.0},"85":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"70":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"89":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":10,"docs":{"14":{"tf":1.0},"22":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.4142135623730951},"50":{"tf":1.7320508075688772},"54":{"tf":1.0},"57":{"tf":1.0},"63":{"tf":1.0},"76":{"tf":1.0},"88":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"24":{"tf":1.0},"50":{"tf":1.0},"91":{"tf":1.0}}}}}}}}},"x":{"+":{"1":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}},".":{".":{"=":{"df":0,"docs":{},"i":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}},"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{")":{".":{".":{"(":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"(":{")":{".":{"b":{"a":{"df":0,"docs":{},"r":{"(":{")":{".":{"b":{"a":{"df":0,"docs":{},"z":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"76":{"tf":1.0}}}}},"y":{".":{"df":0,"docs":{},"z":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}}},"1":{"2":{"8":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}},"6":{"df":2,"docs":{"9":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}},"3":{"2":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}},"6":{"4":{"df":2,"docs":{"9":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}},"8":{"6":{"_":{"1":{"2":{"8":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"2":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"6":{"4":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"9":{"tf":1.0}}},"7":{"df":1,"docs":{"9":{"tf":1.0}}},"df":2,"docs":{"9":{"tf":1.0},"93":{"tf":1.0}}},"df":20,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"23":{"tf":1.0},"32":{"tf":1.0},"42":{"tf":1.0},"51":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"60":{"tf":1.0},"62":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.0},"7":{"tf":1.0},"72":{"tf":1.4142135623730951},"73":{"tf":1.0},"75":{"tf":1.7320508075688772},"76":{"tf":1.0},"84":{"tf":2.0}}},"y":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":13,"docs":{"15":{"tf":1.0},"23":{"tf":1.0},"32":{"tf":1.4142135623730951},"40":{"tf":1.0},"42":{"tf":1.0},"57":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.4142135623730951},"7":{"tf":1.0},"72":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"6":{"tf":1.0}}}},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"88":{"tf":1.0}}}}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"73":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"z":{"_":{"df":0,"docs":{},"y":{"df":0,"docs":{},"x":{"df":0,"docs":{},"w":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"df":5,"docs":{"40":{"tf":1.0},"42":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":3,"docs":{"7":{"tf":1.0},"9":{"tf":2.6457513110645907},"96":{"tf":1.0}}}}},"y":{"_":{"df":0,"docs":{},"x":{"df":0,"docs":{},"w":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"x":{"df":0,"docs":{},"w":{"_":{"df":1,"docs":{"9":{"tf":1.0}}},"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}}}}},"title":{"root":{"2":{"0":{"1":{"5":{"/":{"2":{"0":{"1":{"8":{"/":{"2":{"0":{"2":{"1":{"df":1,"docs":{"94":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"4":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"58":{"tf":1.0}}}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"df":2,"docs":{"57":{"tf":1.0},"58":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"46":{"tf":1.0},"50":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"79":{"tf":1.0},"82":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":2,"docs":{"74":{"tf":1.0},"81":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"3":{"tf":1.0}}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":5,"docs":{"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"82":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"18":{"tf":1.0},"87":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"69":{"tf":1.0}}}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"51":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"75":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"a":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"62":{"tf":1.0},"71":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"4":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0}}}}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"91":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":2,"docs":{"24":{"tf":1.0},"56":{"tf":1.0}}}}},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":6,"docs":{"12":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":1.0},"84":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"29":{"tf":1.0},"36":{"tf":1.0}}}}}}}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"62":{"tf":1.0},"71":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":6,"docs":{"1":{"tf":1.0},"17":{"tf":1.0},"4":{"tf":1.0},"68":{"tf":1.0},"80":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"96":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"21":{"tf":1.0},"63":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"0":{"tf":1.0},"90":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"19":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"77":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.0}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":6,"docs":{"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0}}}}}}},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}},"x":{"df":1,"docs":{"58":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":4,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"20":{"tf":1.0},"36":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"38":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":10,"docs":{"23":{"tf":1.0},"5":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"38":{"tf":1.0},"40":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"77":{"tf":1.0}}}}}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"df":3,"docs":{"47":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"43":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"89":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"66":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{}}}}},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":3,"docs":{"10":{"tf":1.0},"30":{"tf":1.0},"86":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"65":{"tf":1.0},"70":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"85":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"92":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"95":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"41":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"59":{"tf":1.0},"60":{"tf":1.0}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"39":{"tf":1.0},"40":{"tf":1.0}}}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"78":{"tf":1.0}}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"47":{"tf":1.0},"48":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"82":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"19":{"tf":1.0},"90":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"76":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"90":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":6,"docs":{"0":{"tf":1.0},"2":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":4,"docs":{"23":{"tf":1.0},"64":{"tf":1.0},"72":{"tf":1.0},"80":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"58":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"16":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":7,"docs":{"11":{"tf":1.0},"37":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"68":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"22":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":7,"docs":{"0":{"tf":1.0},"2":{"tf":1.0},"83":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"6":{"tf":1.0},"8":{"tf":1.0}}},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":4,"docs":{"22":{"tf":1.4142135623730951},"26":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":4,"docs":{"13":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"79":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"59":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"25":{"tf":1.0}}}},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}},"s":{"df":4,"docs":{"1":{"tf":1.0},"19":{"tf":1.0},"37":{"tf":1.0},"67":{"tf":1.0}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"i":{"d":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"5":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"lang":"English","pipeline":["trimmer","stopWordFilter","stemmer"],"ref":"id","version":"0.9.5"},"results_options":{"limit_results":30,"teaser_word_count":30},"search_options":{"bool":"OR","expand":true,"fields":{"body":{"boost":1},"breadcrumbs":{"boost":1},"title":{"boost":2}}}}'));