window.search = Object.assign(window.search, JSON.parse('{"doc_urls":["intro.html#the-rustonomicon","intro.html#the-dark-arts-of-unsafe-rust","meet-safe-and-unsafe.html#meet-safe-and-unsafe","safe-unsafe-meaning.html#how-safe-and-unsafe-interact","what-unsafe-does.html#what-unsafe-rust-can-do","working-with-unsafe.html#working-with-unsafe","data.html#data-representation-in-rust","repr-rust.html#reprrust","exotic-sizes.html#exotically-sized-types","exotic-sizes.html#dynamically-sized-types-dsts","exotic-sizes.html#zero-sized-types-zsts","exotic-sizes.html#empty-types","exotic-sizes.html#extern-types","other-reprs.html#alternative-representations","other-reprs.html#reprc","other-reprs.html#reprtransparent","other-reprs.html#repru-repri","other-reprs.html#reprpacked-reprpackedn","other-reprs.html#repralignn","ownership.html#ownership-and-lifetimes","references.html#references","aliasing.html#aliasing","aliasing.html#why-aliasing-matters","lifetimes.html#lifetimes","lifetimes.html#example-references-that-outlive-referents","lifetimes.html#example-aliasing-a-mutable-reference","lifetimes.html#the-area-covered-by-a-lifetime","lifetime-mismatch.html#limits-of-lifetimes","lifetime-mismatch.html#improperly-reduced-borrows","lifetime-elision.html#lifetime-elision","unbounded-lifetimes.html#unbounded-lifetimes","hrtb.html#higher-rank-trait-bounds-hrtbs","subtyping.html#subtyping-and-variance","subtyping.html#subtyping","subtyping.html#variance","dropck.html#drop-check","dropck.html#an-escape-hatch","dropck.html#a-related-side-note-about-drop-order","dropck.html#is-that-all-about-drop-checker","phantom-data.html#phantomdata","phantom-data.html#generic-parameters-and-drop-checking","phantom-data.html#an-exception-the-special-case-of-the-standard-library-and-its-unstable-may_dangle","phantom-data.html#table-of-phantomdata-patterns","borrow-splitting.html#splitting-borrows","conversions.html#type-conversions","coercions.html#coercions","dot-operator.html#the-dot-operator","casts.html#casts","casts.html#safety-of-casting","casts.html#some-notes-about-casting","casts.html#lengths-when-casting-raw-slices","casts.html#transitivity","transmutes.html#transmutes","uninitialized.html#working-with-uninitialized-memory","checked-uninit.html#checked-uninitialized-memory","drop-flags.html#drop-flags","unchecked-uninit.html#unchecked-uninitialized-memory","obrm.html#the-perils-of-ownership-based-resource-management-obrm","constructors.html#constructors","destructors.html#destructors","leaking.html#leaking","leaking.html#drain","leaking.html#rc","leaking.html#threadscopedjoinguard","unwinding.html#unwinding","exception-safety.html#exception-safety","exception-safety.html#vecpush_all","exception-safety.html#binaryheapsift_up","poisoning.html#poisoning","concurrency.html#concurrency-and-parallelism","races.html#data-races-and-race-conditions","send-and-sync.html#send-and-sync","send-and-sync.html#example","atomics.html#atomics","atomics.html#compiler-reordering","atomics.html#hardware-reordering","atomics.html#data-accesses","atomics.html#sequentially-consistent","atomics.html#acquire-release","atomics.html#relaxed","vec/vec.html#example-implementing-vec","vec/vec-layout.html#layout","vec/vec-alloc.html#allocating-memory","vec/vec-push-pop.html#push-and-pop","vec/vec-dealloc.html#deallocating","vec/vec-deref.html#deref","vec/vec-insert-remove.html#insert-and-remove","vec/vec-into-iter.html#intoiter","vec/vec-raw.html#rawvec","vec/vec-drain.html#drain","vec/vec-zsts.html#handling-zero-sized-types","vec/vec-zsts.html#allocating-zero-sized-types","vec/vec-zsts.html#iterating-zero-sized-types","vec/vec-final.html#the-final-code","arc-mutex/arc-and-mutex.html#implementing-arc-and-mutex","arc-mutex/arc.html#implementing-arc","arc-mutex/arc-layout.html#layout","arc-mutex/arc-base.html#base-code","arc-mutex/arc-base.html#constructing-the-arc","arc-mutex/arc-base.html#send-and-sync","arc-mutex/arc-base.html#getting-the-arcinner","arc-mutex/arc-base.html#deref","arc-mutex/arc-base.html#code","arc-mutex/arc-clone.html#cloning","arc-mutex/arc-drop.html#dropping","arc-mutex/arc-final.html#final-code","ffi.html#foreign-function-interface","ffi.html#introduction","ffi.html#a-note-about-libc","ffi.html#prepare-the-build-script","ffi.html#calling-foreign-functions","ffi.html#creating-a-safe-interface","ffi.html#destructors","ffi.html#calling-rust-code-from-c","ffi.html#rust-side","ffi.html#c-side","ffi.html#callbacks-from-c-code-to-rust-functions","ffi.html#targeting-callbacks-to-rust-objects","ffi.html#asynchronous-callbacks","ffi.html#linking","ffi.html#unsafe-blocks","ffi.html#accessing-foreign-globals","ffi.html#foreign-calling-conventions","ffi.html#interoperability-with-foreign-code","ffi.html#variadic-functions","ffi.html#the-nullable-pointer-optimization","ffi.html#ffi-and-unwinding","ffi.html#rust-panic-with-c-unwind","ffi.html#c-throw-with-c-unwind","ffi.html#panic-can-be-stopped-at-an-abi-boundary","ffi.html#catching-panic-preemptively","ffi.html#representing-opaque-structs","beneath-std.html#beneath-std","beneath-std.html#using-libc","beneath-std.html#writing-an-executable-without-std","panic-handler.html#panic_handler"],"index":{"documentStore":{"docInfo":{"0":{"body":24,"breadcrumbs":2,"title":1},"1":{"body":240,"breadcrumbs":5,"title":4},"10":{"body":177,"breadcrumbs":9,"title":4},"100":{"body":32,"breadcrumbs":8,"title":2},"101":{"body":47,"breadcrumbs":7,"title":1},"102":{"body":63,"breadcrumbs":7,"title":1},"103":{"body":266,"breadcrumbs":6,"title":1},"104":{"body":267,"breadcrumbs":6,"title":1},"105":{"body":159,"breadcrumbs":8,"title":2},"106":{"body":0,"breadcrumbs":4,"title":3},"107":{"body":24,"breadcrumbs":2,"title":1},"108":{"body":25,"breadcrumbs":3,"title":2},"109":{"body":67,"breadcrumbs":4,"title":3},"11":{"body":206,"breadcrumbs":7,"title":2},"110":{"body":175,"breadcrumbs":4,"title":3},"111":{"body":377,"breadcrumbs":4,"title":3},"112":{"body":25,"breadcrumbs":2,"title":1},"113":{"body":12,"breadcrumbs":5,"title":4},"114":{"body":74,"breadcrumbs":3,"title":2},"115":{"body":59,"breadcrumbs":3,"title":2},"116":{"body":103,"breadcrumbs":6,"title":5},"117":{"body":130,"breadcrumbs":5,"title":4},"118":{"body":104,"breadcrumbs":3,"title":2},"119":{"body":192,"breadcrumbs":2,"title":1},"12":{"body":30,"breadcrumbs":7,"title":2},"120":{"body":47,"breadcrumbs":3,"title":2},"121":{"body":88,"breadcrumbs":4,"title":3},"122":{"body":121,"breadcrumbs":4,"title":3},"123":{"body":114,"breadcrumbs":4,"title":3},"124":{"body":41,"breadcrumbs":3,"title":2},"125":{"body":229,"breadcrumbs":4,"title":3},"126":{"body":109,"breadcrumbs":3,"title":2},"127":{"body":40,"breadcrumbs":5,"title":4},"128":{"body":62,"breadcrumbs":5,"title":4},"129":{"body":23,"breadcrumbs":5,"title":4},"13":{"body":8,"breadcrumbs":5,"title":2},"130":{"body":45,"breadcrumbs":4,"title":3},"131":{"body":223,"breadcrumbs":4,"title":3},"132":{"body":16,"breadcrumbs":4,"title":2},"133":{"body":66,"breadcrumbs":4,"title":2},"134":{"body":158,"breadcrumbs":6,"title":4},"135":{"body":167,"breadcrumbs":4,"title":1},"14":{"body":248,"breadcrumbs":4,"title":1},"15":{"body":110,"breadcrumbs":4,"title":1},"16":{"body":162,"breadcrumbs":5,"title":2},"17":{"body":97,"breadcrumbs":5,"title":2},"18":{"body":33,"breadcrumbs":4,"title":1},"19":{"body":238,"breadcrumbs":3,"title":2},"2":{"body":302,"breadcrumbs":6,"title":3},"20":{"body":65,"breadcrumbs":3,"title":1},"21":{"body":55,"breadcrumbs":3,"title":1},"22":{"body":396,"breadcrumbs":4,"title":2},"23":{"body":282,"breadcrumbs":3,"title":1},"24":{"body":195,"breadcrumbs":6,"title":4},"25":{"body":164,"breadcrumbs":6,"title":4},"26":{"body":244,"breadcrumbs":5,"title":3},"27":{"body":153,"breadcrumbs":5,"title":2},"28":{"body":136,"breadcrumbs":6,"title":3},"29":{"body":234,"breadcrumbs":5,"title":2},"3":{"body":745,"breadcrumbs":9,"title":3},"30":{"body":162,"breadcrumbs":5,"title":2},"31":{"body":230,"breadcrumbs":10,"title":5},"32":{"body":97,"breadcrumbs":5,"title":2},"33":{"body":165,"breadcrumbs":4,"title":1},"34":{"body":907,"breadcrumbs":4,"title":1},"35":{"body":520,"breadcrumbs":5,"title":2},"36":{"body":334,"breadcrumbs":5,"title":2},"37":{"body":15,"breadcrumbs":8,"title":5},"38":{"body":22,"breadcrumbs":5,"title":2},"39":{"body":133,"breadcrumbs":3,"title":1},"4":{"body":384,"breadcrumbs":6,"title":2},"40":{"body":240,"breadcrumbs":6,"title":4},"41":{"body":363,"breadcrumbs":9,"title":7},"42":{"body":90,"breadcrumbs":5,"title":3},"43":{"body":669,"breadcrumbs":5,"title":2},"44":{"body":104,"breadcrumbs":4,"title":2},"45":{"body":118,"breadcrumbs":4,"title":1},"46":{"body":419,"breadcrumbs":6,"title":2},"47":{"body":36,"breadcrumbs":4,"title":1},"48":{"body":68,"breadcrumbs":5,"title":2},"49":{"body":0,"breadcrumbs":5,"title":2},"5":{"body":361,"breadcrumbs":7,"title":2},"50":{"body":16,"breadcrumbs":7,"title":4},"51":{"body":11,"breadcrumbs":4,"title":1},"52":{"body":250,"breadcrumbs":4,"title":1},"53":{"body":42,"breadcrumbs":5,"title":3},"54":{"body":242,"breadcrumbs":6,"title":3},"55":{"body":302,"breadcrumbs":6,"title":2},"56":{"body":590,"breadcrumbs":6,"title":3},"57":{"body":73,"breadcrumbs":10,"title":6},"58":{"body":216,"breadcrumbs":6,"title":1},"59":{"body":422,"breadcrumbs":6,"title":1},"6":{"body":61,"breadcrumbs":5,"title":3},"60":{"body":239,"breadcrumbs":6,"title":1},"61":{"body":200,"breadcrumbs":6,"title":1},"62":{"body":157,"breadcrumbs":6,"title":1},"63":{"body":248,"breadcrumbs":6,"title":1},"64":{"body":260,"breadcrumbs":2,"title":1},"65":{"body":169,"breadcrumbs":5,"title":2},"66":{"body":105,"breadcrumbs":4,"title":1},"67":{"body":366,"breadcrumbs":4,"title":1},"68":{"body":183,"breadcrumbs":3,"title":1},"69":{"body":70,"breadcrumbs":3,"title":2},"7":{"body":485,"breadcrumbs":4,"title":1},"70":{"body":317,"breadcrumbs":6,"title":4},"71":{"body":321,"breadcrumbs":5,"title":2},"72":{"body":537,"breadcrumbs":4,"title":1},"73":{"body":117,"breadcrumbs":3,"title":1},"74":{"body":79,"breadcrumbs":4,"title":2},"75":{"body":229,"breadcrumbs":4,"title":2},"76":{"body":179,"breadcrumbs":4,"title":2},"77":{"body":120,"breadcrumbs":4,"title":2},"78":{"body":164,"breadcrumbs":4,"title":2},"79":{"body":74,"breadcrumbs":3,"title":1},"8":{"body":11,"breadcrumbs":8,"title":3},"80":{"body":63,"breadcrumbs":5,"title":3},"81":{"body":159,"breadcrumbs":4,"title":1},"82":{"body":805,"breadcrumbs":5,"title":2},"83":{"body":170,"breadcrumbs":6,"title":2},"84":{"body":75,"breadcrumbs":4,"title":1},"85":{"body":99,"breadcrumbs":4,"title":1},"86":{"body":132,"breadcrumbs":6,"title":2},"87":{"body":335,"breadcrumbs":4,"title":1},"88":{"body":304,"breadcrumbs":4,"title":1},"89":{"body":331,"breadcrumbs":4,"title":1},"9":{"body":205,"breadcrumbs":9,"title":4},"90":{"body":65,"breadcrumbs":10,"title":4},"91":{"body":220,"breadcrumbs":10,"title":4},"92":{"body":325,"breadcrumbs":10,"title":4},"93":{"body":650,"breadcrumbs":6,"title":2},"94":{"body":26,"breadcrumbs":6,"title":3},"95":{"body":51,"breadcrumbs":6,"title":2},"96":{"body":238,"breadcrumbs":6,"title":1},"97":{"body":10,"breadcrumbs":8,"title":2},"98":{"body":46,"breadcrumbs":8,"title":2},"99":{"body":96,"breadcrumbs":8,"title":2}},"docs":{"0":{"body":"Warning:\\nThis book is incomplete.\\nDocumenting everything and rewriting outdated parts take a while.\\nSee the issue tracker to check what’s missing/outdated, and if there are any mistakes or ideas that haven’t been reported, feel free to open a new issue there.","breadcrumbs":"Introduction » The Rustonomicon","id":"0","title":"The Rustonomicon"},"1":{"body":"THE KNOWLEDGE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF UNLEASHING INDESCRIBABLE HORRORS THAT SHATTER YOUR PSYCHE AND SET YOUR MIND ADRIFT IN THE UNKNOWABLY INFINITE COSMOS. The Rustonomicon digs into all the awful details that you need to understand when writing Unsafe Rust programs. Should you wish a long and happy career of writing Rust programs, you should turn back now and forget you ever saw this book.\\nIt is not necessary.\\nHowever if you intend to write unsafe code — or just want to dig into the guts of the language — this book contains lots of useful information. Unlike The Rust Programming Language, we will be assuming considerable prior knowledge.\\nIn particular, you should be comfortable with basic systems programming and Rust.\\nIf you don’t feel comfortable with these topics, you should consider reading The Book first.\\nThat said, we won’t assume you have read it, and we will take care to occasionally give a refresher on the basics where appropriate.\\nYou can skip straight to this book if you want; just know that we won’t be explaining everything from the ground up. This book exists primarily as a high-level companion to The Reference.\\nWhere The Reference exists to detail the syntax and semantics of every part of the language, The Rustonomicon exists to describe how to use those pieces together, and the issues that you will have in doing so. The Reference will tell you the syntax and semantics of references, destructors, and unwinding, but it won’t tell you how combining them can lead to exception-safety issues, or how to deal with those issues. It should be noted that we haven’t synced The Rustnomicon and The Reference well, so they may have duplicate content.\\nIn general, if the two documents disagree, The Reference should be assumed to be correct (it isn’t yet considered normative, it’s just better maintained). Topics that are within the scope of this book include: the meaning of (un)safety, unsafe primitives provided by the language and standard library, techniques for creating safe abstractions with those unsafe primitives, subtyping and variance, exception-safety (panic/unwind-safety), working with uninitialized memory, type punning, concurrency, interoperating with other languages (FFI), optimization tricks, how constructs lower to compiler/OS/hardware primitives, how to not make the memory model people angry, how you’re going to make the memory model people angry, and more. The Rustonomicon is not a place to exhaustively describe the semantics and guarantees of every single API in the standard library, nor is it a place to exhaustively describe every feature of Rust. Unless otherwise noted, Rust code in this book uses the Rust 2024 edition.","breadcrumbs":"Introduction » The Dark Arts of Unsafe Rust","id":"1","title":"The Dark Arts of Unsafe Rust"},"10":{"body":"Rust also allows types to be specified that occupy no space: #![allow(unused)] fn main() {\\nstruct Nothing; // No fields = no size // All fields have no size = no size\\nstruct LotsOfNothing { foo: Nothing, qux: (), // empty tuple has no size baz: [u8; 0], // empty array has no size\\n} } On their own, Zero Sized Types (ZSTs) are, for obvious reasons, pretty useless.\\nHowever as with many curious layout choices in Rust, their potential is realized\\nin a generic context: Rust largely understands that any operation that produces\\nor stores a ZST can be reduced to a no-op. First off, storing it doesn’t even\\nmake sense – it doesn’t occupy any space. Also there’s only one value of that\\ntype, so anything that loads it can just produce it from the aether – which is\\nalso a no-op since it doesn’t occupy any space. One of the most extreme examples of this is Sets and Maps. Given a Map<Key, Value>, it is common to implement a Set<Key> as just a thin wrapper\\naround Map<Key, UselessJunk>. In many languages, this would necessitate\\nallocating space for UselessJunk and doing work to store and load UselessJunk\\nonly to discard it. Proving this unnecessary would be a difficult analysis for\\nthe compiler. However in Rust, we can just say that Set<Key> = Map<Key, ()>. Now Rust\\nstatically knows that every load and store is useless, and no allocation has any\\nsize. The result is that the monomorphized code is basically a custom\\nimplementation of a HashSet with none of the overhead that HashMap would have to\\nsupport values. Safe code need not worry about ZSTs, but unsafe code must be careful about the\\nconsequence of types with no size. In particular, pointer offsets are no-ops,\\nand allocators typically require a non-zero size. Note that references to ZSTs (including empty slices), just like all other\\nreferences, must be non-null and suitably aligned. However, loading or storing\\nthrough a null pointer to a ZST is not undefined behavior, unlike\\npointers to other types.","breadcrumbs":"Data Layout » Exotically Sized Types » Zero Sized Types (ZSTs)","id":"10","title":"Zero Sized Types (ZSTs)"},"100":{"body":"To dereference the NonNull<T> pointer into a &T, we can call NonNull::as_ref. This is unsafe, unlike the typical as_ref function, so we\\nmust call it like this: unsafe { self.ptr.as_ref() } We’ll be using this snippet a few times in this code (usually with an associated let binding). This unsafety is okay because while this Arc is alive, we’re guaranteed that\\nthe inner pointer is valid.","breadcrumbs":"Implementing Arc and Mutex » Arc » Base Code » Getting the ArcInner","id":"100","title":"Getting the ArcInner"},"101":{"body":"Alright. Now we can make Arcs (and soon will be able to clone and destroy them correctly), but how do we get\\nto the data inside? What we need now is an implementation of Deref. We’ll need to import the trait: use std::ops::Deref; And here’s the implementation: impl<T> Deref for Arc<T> { type Target = T; fn deref(&self) -> &T { let inner = unsafe { self.ptr.as_ref() }; &inner.data }\\n} Pretty simple, eh? This simply dereferences the NonNull pointer to the ArcInner<T>, then gets a reference to the data inside.","breadcrumbs":"Implementing Arc and Mutex » Arc » Base Code » Deref","id":"101","title":"Deref"},"102":{"body":"Here’s all the code from this section: use std::ops::Deref; impl<T> Arc<T> { pub fn new(data: T) -> Arc<T> { // We start the reference count at 1, as that first reference is the // current pointer. let boxed = Box::new(ArcInner { rc: AtomicUsize::new(1), data, }); Arc { // It is okay to call `.unwrap()` here as we get a pointer from // `Box::into_raw` which is guaranteed to not be null. ptr: NonNull::new(Box::into_raw(boxed)).unwrap(), phantom: PhantomData, } }\\n} unsafe impl<T: Sync + Send> Send for Arc<T> {}\\nunsafe impl<T: Sync + Send> Sync for Arc<T> {} impl<T> Deref for Arc<T> { type Target = T; fn deref(&self) -> &T { let inner = unsafe { self.ptr.as_ref() }; &inner.data }\\n}","breadcrumbs":"Implementing Arc and Mutex » Arc » Base Code » Code","id":"102","title":"Code"},"103":{"body":"Now that we’ve got some basic code set up, we’ll need a way to clone the Arc. Basically, we need to: Increment the atomic reference count Construct a new instance of the Arc from the inner pointer First, we need to get access to the ArcInner: let inner = unsafe { self.ptr.as_ref() }; We can update the atomic reference count as follows: let old_rc = inner.rc.fetch_add(1, Ordering::???); But what ordering should we use here? We don’t really have any code that will\\nneed atomic synchronization when cloning, as we do not modify the internal value\\nwhile cloning. Thus, we can use a Relaxed ordering here, which implies no\\nhappens-before relationship but is atomic. When Dropping the Arc, however,\\nwe’ll need to atomically synchronize when decrementing the reference count. This\\nis described more in the section on the Drop implementation for Arc. For more information on atomic relationships and Relaxed\\nordering, see the section on atomics. Thus, the code becomes this: let old_rc = inner.rc.fetch_add(1, Ordering::Relaxed); We’ll need to add another import to use Ordering: #![allow(unused)] fn main() {\\nuse std::sync::atomic::Ordering; } However, we have one problem with this implementation right now. What if someone\\ndecides to mem::forget a bunch of Arcs? The code we have written so far (and\\nwill write) assumes that the reference count accurately portrays how many Arcs\\nare in memory, but with mem::forget this is false. Thus, when more and more\\nArcs are cloned from this one without them being Dropped and the reference\\ncount being decremented, we can overflow! This will cause use-after-free which\\nis INCREDIBLY BAD! To handle this, we need to check that the reference count does not go over some\\narbitrary value (below usize::MAX, as we’re storing the reference count as an AtomicUsize), and do something. The standard library’s implementation decides to just abort the program (as it\\nis an incredibly unlikely case in normal code and if it happens, the program is\\nprobably incredibly degenerate) if the reference count reaches isize::MAX\\n(about half of usize::MAX) on any thread, on the assumption that there are\\nprobably not about 2 billion threads (or about 9 quintillion on some 64-bit\\nmachines) incrementing the reference count at once. This is what we’ll do. It’s pretty simple to implement this behavior: if old_rc >= isize::MAX as usize { std::process::abort();\\n} Then, we need to return a new instance of the Arc: Self { ptr: self.ptr, phantom: PhantomData\\n} Now, let’s wrap this all up inside the Clone implementation: use std::sync::atomic::Ordering; impl<T> Clone for Arc<T> { fn clone(&self) -> Arc<T> { let inner = unsafe { self.ptr.as_ref() }; // Using a relaxed ordering is alright here as we don\'t need any atomic // synchronization here as we\'re not modifying or accessing the inner // data. let old_rc = inner.rc.fetch_add(1, Ordering::Relaxed); if old_rc >= isize::MAX as usize { std::process::abort(); } Self { ptr: self.ptr, phantom: PhantomData, } }\\n}","breadcrumbs":"Implementing Arc and Mutex » Arc » Cloning » Cloning","id":"103","title":"Cloning"},"104":{"body":"We now need a way to decrease the reference count and drop the data once it is\\nlow enough, otherwise the data will live forever on the heap. To do this, we can implement Drop. Basically, we need to: Decrement the reference count If there is only one reference remaining to the data, then: Atomically fence the data to prevent reordering of the use and deletion of\\nthe data Drop the inner data First, we’ll need to get access to the ArcInner: let inner = unsafe { self.ptr.as_ref() }; Now, we need to decrement the reference count. To streamline our code, we can\\nalso return if the returned value from fetch_sub (the value of the reference\\ncount before decrementing it) is not equal to 1 (which happens when we are not\\nthe last reference to the data). if inner.rc.fetch_sub(1, Ordering::Release) != 1 { return;\\n} We then need to create an atomic fence to prevent reordering of the use of the\\ndata and deletion of the data. As described in the standard library’s\\nimplementation of Arc: This fence is needed to prevent reordering of use of the data and deletion of\\nthe data. Because it is marked Release, the decreasing of the reference\\ncount synchronizes with this Acquire fence. This means that use of the data\\nhappens before decreasing the reference count, which happens before this\\nfence, which happens before the deletion of the data. As explained in the Boost documentation, It is important to enforce any possible access to the object in one\\nthread (through an existing reference) to happen before deleting\\nthe object in a different thread. This is achieved by a “release”\\noperation after dropping a reference (any access to the object\\nthrough this reference must obviously happened before), and an\\n“acquire” operation before deleting the object. In particular, while the contents of an Arc are usually immutable, it’s\\npossible to have interior writes to something like a Mutex<T>. Since a Mutex\\nis not acquired when it is deleted, we can’t rely on its synchronization logic\\nto make writes in thread A visible to a destructor running in thread B. Also note that the Acquire fence here could probably be replaced with an\\nAcquire load, which could improve performance in highly-contended situations.\\nSee 2. To do this, we do the following: #![allow(unused)] fn main() { use std::sync::atomic::Ordering;\\nuse std::sync::atomic;\\natomic::fence(Ordering::Acquire); } Finally, we can drop the data itself. We use Box::from_raw to drop the boxed ArcInner<T> and its data. This takes a *mut T and not a NonNull<T>, so we\\nmust convert using NonNull::as_ptr. unsafe { Box::from_raw(self.ptr.as_ptr()); } This is safe as we know we have the last pointer to the ArcInner and that its\\npointer is valid. Now, let’s wrap this all up inside the Drop implementation: impl<T> Drop for Arc<T> { fn drop(&mut self) { let inner = unsafe { self.ptr.as_ref() }; if inner.rc.fetch_sub(1, Ordering::Release) != 1 { return; } // This fence is needed to prevent reordering of the use and deletion // of the data. atomic::fence(Ordering::Acquire); // This is safe as we know we have the last pointer to the `ArcInner` // and that its pointer is valid. unsafe { Box::from_raw(self.ptr.as_ptr()); } }\\n}","breadcrumbs":"Implementing Arc and Mutex » Arc » Dropping » Dropping","id":"104","title":"Dropping"},"105":{"body":"Here’s the final code, with some added comments and re-ordered imports: #![allow(unused)] fn main() {\\nuse std::marker::PhantomData;\\nuse std::ops::Deref;\\nuse std::ptr::NonNull;\\nuse std::sync::atomic::{self, AtomicUsize, Ordering}; pub struct Arc<T> { ptr: NonNull<ArcInner<T>>, phantom: PhantomData<ArcInner<T>>,\\n} pub struct ArcInner<T> { rc: AtomicUsize, data: T,\\n} impl<T> Arc<T> { pub fn new(data: T) -> Arc<T> { // We start the reference count at 1, as that first reference is the // current pointer. let boxed = Box::new(ArcInner { rc: AtomicUsize::new(1), data, }); Arc { // It is okay to call `.unwrap()` here as we get a pointer from // `Box::into_raw` which is guaranteed to not be null. ptr: NonNull::new(Box::into_raw(boxed)).unwrap(), phantom: PhantomData, } }\\n} unsafe impl<T: Sync + Send> Send for Arc<T> {}\\nunsafe impl<T: Sync + Send> Sync for Arc<T> {} impl<T> Deref for Arc<T> { type Target = T; fn deref(&self) -> &T { let inner = unsafe { self.ptr.as_ref() }; &inner.data }\\n} impl<T> Clone for Arc<T> { fn clone(&self) -> Arc<T> { let inner = unsafe { self.ptr.as_ref() }; // Using a relaxed ordering is alright here as we don\'t need any atomic // synchronization here as we\'re not modifying or accessing the inner // data. let old_rc = inner.rc.fetch_add(1, Ordering::Relaxed); if old_rc >= isize::MAX as usize { std::process::abort(); } Self { ptr: self.ptr, phantom: PhantomData, } }\\n} impl<T> Drop for Arc<T> { fn drop(&mut self) { let inner = unsafe { self.ptr.as_ref() }; if inner.rc.fetch_sub(1, Ordering::Release) != 1 { return; } // This fence is needed to prevent reordering of the use and deletion // of the data. atomic::fence(Ordering::Acquire); // This is safe as we know we have the last pointer to the `ArcInner` // and that its pointer is valid. unsafe { Box::from_raw(self.ptr.as_ptr()); } }\\n} }","breadcrumbs":"Implementing Arc and Mutex » Arc » Final Code » Final Code","id":"105","title":"Final Code"},"106":{"body":"","breadcrumbs":"FFI » Foreign Function Interface","id":"106","title":"Foreign Function Interface"},"107":{"body":"This guide will use the snappy\\ncompression/decompression library as an introduction to writing bindings for\\nforeign code. Rust is currently unable to call directly into a C++ library, but\\nsnappy includes a C interface (documented in snappy-c.h).","breadcrumbs":"FFI » Introduction","id":"107","title":"Introduction"},"108":{"body":"Many of these examples use the libc crate, which provides various\\ntype definitions for C types, among other things. If you’re trying out these\\nexamples yourself, you’ll need to add libc to your Cargo.toml: [dependencies]\\nlibc = \\"0.2.0\\"","breadcrumbs":"FFI » A note about libc","id":"108","title":"A note about libc"},"109":{"body":"Because snappy is a static library by default, so there is no stdc++ linked in the output artifact.\\nIn order to use this foreign library in Rust, we have to manually specify that we want to link stdc++ std to our project.\\nThe easiest way to do this is by setting up a build script. First edit Cargo.toml, inside package add build = \\"build.rs\\": [package]\\n...\\nbuild = \\"build.rs\\" Then create a new file at the root of your workspace, named build.rs: // build.rs\\nfn main() { println!(\\"cargo:rustc-link-lib=dylib=stdc++\\"); // This line may be unnecessary for some environments. println!(\\"cargo:rustc-link-search=<YOUR SNAPPY LIBRARY PATH>\\");\\n} For more information, please read The Cargo Book - build script.","breadcrumbs":"FFI » Prepare the build script","id":"109","title":"Prepare the build script"},"11":{"body":"Rust also enables types to be declared that cannot even be instantiated. These\\ntypes can only be talked about at the type level, and never at the value level.\\nEmpty types can be declared by specifying an enum with no variants: #![allow(unused)] fn main() {\\nenum Void {} // No variants = EMPTY } Empty types are even more marginal than ZSTs. The primary motivating example for\\nan empty type is type-level unreachability. For instance, suppose an API needs to\\nreturn a Result in general, but a specific case actually is infallible. It’s\\nactually possible to communicate this at the type level by returning a Result<T, Void>. Consumers of the API can confidently unwrap such a Result\\nknowing that it’s statically impossible for this value to be an Err, as\\nthis would require providing a value of type Void. In principle, Rust can do some interesting analyses and optimizations based\\non this fact. For instance, Result<T, Void> is represented as just T,\\nbecause the Err case doesn’t actually exist (strictly speaking, this is only\\nan optimization that is not guaranteed, so for example transmuting one into the\\nother is still Undefined Behavior). The following also compiles: #![allow(unused)] fn main() {\\nenum Void {} let res: Result<u32, Void> = Ok(0); // Err doesn\'t exist anymore, so Ok is actually irrefutable.\\nlet Ok(num) = res; } One final subtle detail about empty types is that raw pointers to them are\\nactually valid to construct, but dereferencing them is Undefined Behavior\\nbecause that wouldn’t make sense. We recommend against modelling C’s void* type with *const Void.\\nA lot of people started doing that but quickly ran into trouble because\\nRust doesn’t really have any safety guards against trying to instantiate\\nempty types with unsafe code, and if you do it, it’s Undefined Behavior.\\nThis was especially problematic because developers had a habit of converting\\nraw pointers to references and &Void is also Undefined Behavior to\\nconstruct. *const () (or equivalent) works reasonably well for void*, and can be made\\ninto a reference without any safety problems. It still doesn’t prevent you from\\ntrying to read or write values, but at least it compiles to a no-op instead\\nof Undefined Behavior.","breadcrumbs":"Data Layout » Exotically Sized Types » Empty Types","id":"11","title":"Empty Types"},"110":{"body":"The following is a minimal example of calling a foreign function which will\\ncompile if snappy is installed: use libc::size_t; #[link(name = \\"snappy\\")]\\nunsafe extern \\"C\\" { fn snappy_max_compressed_length(source_length: size_t) -> size_t;\\n} fn main() { let x = unsafe { snappy_max_compressed_length(100) }; println!(\\"max compressed length of a 100 byte buffer: {}\\", x);\\n} The extern block is a list of function signatures in a foreign library, in\\nthis case with the platform’s C ABI. The #[link(...)] attribute is used to\\ninstruct the linker to link against the snappy library so the symbols can be\\nresolved. Foreign functions are assumed to be unsafe so calls to them need to be wrapped\\nwith unsafe {} as a promise to the compiler that everything contained within\\ntruly is safe. C libraries often expose interfaces that aren’t thread-safe, and\\nalmost any function that takes a pointer argument isn’t valid for all possible\\ninputs since the pointer could be dangling, and raw pointers fall outside of\\nRust’s safe memory model. When declaring the argument types to a foreign function, the Rust compiler\\ncannot check if the declaration is correct, so specifying it correctly is part\\nof keeping the binding correct at runtime. The extern block can be extended to cover the entire snappy API: use libc::{c_int, size_t}; #[link(name = \\"snappy\\")]\\nunsafe extern \\"C\\" { fn snappy_compress(input: *const u8, input_length: size_t, compressed: *mut u8, compressed_length: *mut size_t) -> c_int; fn snappy_uncompress(compressed: *const u8, compressed_length: size_t, uncompressed: *mut u8, uncompressed_length: *mut size_t) -> c_int; fn snappy_max_compressed_length(source_length: size_t) -> size_t; fn snappy_uncompressed_length(compressed: *const u8, compressed_length: size_t, result: *mut size_t) -> c_int; fn snappy_validate_compressed_buffer(compressed: *const u8, compressed_length: size_t) -> c_int;\\n} fn main() {}","breadcrumbs":"FFI » Calling foreign functions","id":"110","title":"Calling foreign functions"},"111":{"body":"The raw C API needs to be wrapped to provide memory safety and make use of higher-level concepts\\nlike vectors. A library can choose to expose only the safe, high-level interface and hide the unsafe\\ninternal details. Wrapping the functions which expect buffers involves using the slice::raw module to manipulate Rust’s\\nvectors as pointers to memory. Rust’s vectors are guaranteed to be a contiguous block of memory. The\\nlength is the number of elements currently contained, and the capacity is the total size in elements of\\nthe allocated memory. The length is less than or equal to the capacity. use libc::{c_int, size_t}; unsafe fn snappy_validate_compressed_buffer(_: *const u8, _: size_t) -> c_int { 0 } fn main() {}\\npub fn validate_compressed_buffer(src: &[u8]) -> bool { unsafe { snappy_validate_compressed_buffer(src.as_ptr(), src.len() as size_t) == 0 }\\n} The validate_compressed_buffer wrapper above makes use of an unsafe block, but it makes the\\nguarantee that calling it is safe for all inputs by leaving off unsafe from the function\\nsignature. The snappy_compress and snappy_uncompress functions are more complex, since a buffer has to be\\nallocated to hold the output too. The snappy_max_compressed_length function can be used to allocate a vector with the maximum\\nrequired capacity to hold the compressed output. The vector can then be passed to the snappy_compress function as an output parameter. An output parameter is also passed to retrieve\\nthe true length after compression for setting the length. use libc::{size_t, c_int}; unsafe fn snappy_compress(a: *const u8, b: size_t, c: *mut u8, d: *mut size_t) -> c_int { 0 } unsafe fn snappy_max_compressed_length(a: size_t) -> size_t { a } fn main() {}\\npub fn compress(src: &[u8]) -> Vec<u8> { unsafe { let srclen = src.len() as size_t; let psrc = src.as_ptr(); let mut dstlen = snappy_max_compressed_length(srclen); let mut dst = Vec::with_capacity(dstlen as usize); let pdst = dst.as_mut_ptr(); snappy_compress(psrc, srclen, pdst, &mut dstlen); dst.set_len(dstlen as usize); dst }\\n} Decompression is similar, because snappy stores the uncompressed size as part of the compression\\nformat and snappy_uncompressed_length will retrieve the exact buffer size required. use libc::{size_t, c_int}; unsafe fn snappy_uncompress(compressed: *const u8, compressed_length: size_t, uncompressed: *mut u8, uncompressed_length: *mut size_t) -> c_int { 0 } unsafe fn snappy_uncompressed_length(compressed: *const u8, compressed_length: size_t, result: *mut size_t) -> c_int { 0 } fn main() {}\\npub fn uncompress(src: &[u8]) -> Option<Vec<u8>> { unsafe { let srclen = src.len() as size_t; let psrc = src.as_ptr(); let mut dstlen: size_t = 0; snappy_uncompressed_length(psrc, srclen, &mut dstlen); let mut dst = Vec::with_capacity(dstlen as usize); let pdst = dst.as_mut_ptr(); if snappy_uncompress(psrc, srclen, pdst, &mut dstlen) == 0 { dst.set_len(dstlen as usize); Some(dst) } else { None // SNAPPY_INVALID_INPUT } }\\n} Then, we can add some tests to show how to use them. use libc::{c_int, size_t}; unsafe fn snappy_compress(input: *const u8, input_length: size_t, compressed: *mut u8, compressed_length: *mut size_t) -> c_int { 0 } unsafe fn snappy_uncompress(compressed: *const u8, compressed_length: size_t, uncompressed: *mut u8, uncompressed_length: *mut size_t) -> c_int { 0 } unsafe fn snappy_max_compressed_length(source_length: size_t) -> size_t { 0 } unsafe fn snappy_uncompressed_length(compressed: *const u8, compressed_length: size_t, result: *mut size_t) -> c_int { 0 } unsafe fn snappy_validate_compressed_buffer(compressed: *const u8, compressed_length: size_t) -> c_int { 0 } fn main() { } #[cfg(test)]\\nmod tests { use super::*; #[test] fn valid() { let d = vec![0xde, 0xad, 0xd0, 0x0d]; let c: &[u8] = &compress(&d); assert!(validate_compressed_buffer(c)); assert!(uncompress(c) == Some(d)); } #[test] fn invalid() { let d = vec![0, 0, 0, 0]; assert!(!validate_compressed_buffer(&d)); assert!(uncompress(&d).is_none()); } #[test] fn empty() { let d = vec![]; assert!(!validate_compressed_buffer(&d)); assert!(uncompress(&d).is_none()); let c = compress(&d); assert!(validate_compressed_buffer(&c)); assert!(uncompress(&c) == Some(d)); }\\n}","breadcrumbs":"FFI » Creating a safe interface","id":"111","title":"Creating a safe interface"},"112":{"body":"Foreign libraries often hand off ownership of resources to the calling code.\\nWhen this occurs, we must use Rust’s destructors to provide safety and guarantee\\nthe release of these resources (especially in the case of a panic). For more information about destructors, see the Drop trait.","breadcrumbs":"FFI » Destructors","id":"112","title":"Destructors"},"113":{"body":"You may wish to compile Rust code in a way that can be called from C.\\nThis is fairly easy, but requires a few things.","breadcrumbs":"FFI » Calling Rust code from C","id":"113","title":"Calling Rust code from C"},"114":{"body":"First, we assume you have a lib crate named as rust_from_c. lib.rs should have Rust code as following: #[unsafe(no_mangle)]\\npub extern \\"C\\" fn hello_from_rust() { println!(\\"Hello from Rust!\\");\\n} fn main() {} The extern \\"C\\" makes this function adhere to the C calling convention, as discussed below in “ Foreign Calling Conventions”.\\nThe no_mangle attribute turns off Rust’s name mangling, so that it has a well defined symbol to link to. Then, to compile Rust code as a shared library that can be called from C, add the following to your Cargo.toml: [lib]\\ncrate-type = [\\"cdylib\\"] (NOTE: We could also use the staticlib crate type but it also requires tweaking some linking flags.) Run cargo build and you’re ready to go on the Rust side.","breadcrumbs":"FFI » Rust side","id":"114","title":"Rust side"},"115":{"body":"We’ll create a C file to call the hello_from_rust function and compile it by gcc. C file should look like: extern void hello_from_rust(); int main(void) { hello_from_rust(); return 0;\\n} We name the file as call_rust.c and place it on the crate root.\\nRun the following to compile: gcc call_rust.c -o call_rust -lrust_from_c -L./target/debug -l and -L tell gcc to find our Rust library. Finally, we can call Rust code from C with LD_LIBRARY_PATH specified: $ LD_LIBRARY_PATH=./target/debug ./call_rust\\nHello from Rust! That’s it!\\nFor a more realistic example, check the cbindgen.","breadcrumbs":"FFI » C side","id":"115","title":"C side"},"116":{"body":"Some external libraries require the usage of callbacks to report back their\\ncurrent state or intermediate data to the caller.\\nIt is possible to pass functions defined in Rust to an external library.\\nThe requirement for this is that the callback function is marked as extern\\nwith the correct calling convention to make it callable from C code. The callback function can then be sent through a registration call\\nto the C library and afterwards be invoked from there. A basic example is: Rust code: extern fn callback(a: i32) { println!(\\"I\'m called from C with value {0}\\", a);\\n} #[link(name = \\"extlib\\")]\\nunsafe extern { fn register_callback(cb: extern fn(i32)) -> i32; fn trigger_callback();\\n} fn main() { unsafe { register_callback(callback); trigger_callback(); // Triggers the callback. }\\n} C code: typedef void (*rust_callback)(int32_t);\\nrust_callback cb; int32_t register_callback(rust_callback callback) { cb = callback; return 1;\\n} void trigger_callback() { cb(7); // Will call callback(7) in Rust.\\n} In this example Rust’s main() will call trigger_callback() in C,\\nwhich would, in turn, call back to callback() in Rust.","breadcrumbs":"FFI » Callbacks from C code to Rust functions","id":"116","title":"Callbacks from C code to Rust functions"},"117":{"body":"The former example showed how a global function can be called from C code.\\nHowever it is often desired that the callback is targeted to a special\\nRust object. This could be the object that represents the wrapper for the\\nrespective C object. This can be achieved by passing a raw pointer to the object down to the\\nC library. The C library can then include the pointer to the Rust object in\\nthe notification. This will allow the callback to unsafely access the\\nreferenced Rust object. Rust code: struct RustObject { a: i32, // Other members...\\n} unsafe extern \\"C\\" fn callback(target: *mut RustObject, a: i32) { println!(\\"I\'m called from C with value {0}\\", a); unsafe { // Update the value in RustObject with the value received from the callback: (*target).a = a; }\\n} #[link(name = \\"extlib\\")]\\nunsafe extern { fn register_callback(target: *mut RustObject, cb: unsafe extern fn(*mut RustObject, i32)) -> i32; fn trigger_callback();\\n} fn main() { // Create the object that will be referenced in the callback: let mut rust_object = Box::new(RustObject { a: 5 }); unsafe { register_callback(&mut *rust_object, callback); trigger_callback(); }\\n} C code: typedef void (*rust_callback)(void*, int32_t);\\nvoid* cb_target;\\nrust_callback cb; int32_t register_callback(void* callback_target, rust_callback callback) { cb_target = callback_target; cb = callback; return 1;\\n} void trigger_callback() { cb(cb_target, 7); // Will call callback(&rustObject, 7) in Rust.\\n}","breadcrumbs":"FFI » Targeting callbacks to Rust objects","id":"117","title":"Targeting callbacks to Rust objects"},"118":{"body":"In the previously given examples the callbacks are invoked as a direct reaction\\nto a function call to the external C library.\\nThe control over the current thread is switched from Rust to C to Rust for the\\nexecution of the callback, but in the end the callback is executed on the\\nsame thread that called the function which triggered the callback. Things get more complicated when the external library spawns its own threads\\nand invokes callbacks from there.\\nIn these cases access to Rust data structures inside the callbacks is\\nespecially unsafe and proper synchronization mechanisms must be used.\\nBesides classical synchronization mechanisms like mutexes, one possibility in\\nRust is to use channels (in std::sync::mpsc) to forward data from the C\\nthread that invoked the callback into a Rust thread. If an asynchronous callback targets a special object in the Rust address space\\nit is also absolutely necessary that no more callbacks are performed by the\\nC library after the respective Rust object gets destroyed.\\nThis can be achieved by unregistering the callback in the object’s\\ndestructor and designing the library in a way that guarantees that no\\ncallback will be performed after deregistration.","breadcrumbs":"FFI » Asynchronous callbacks","id":"118","title":"Asynchronous callbacks"},"119":{"body":"The link attribute on extern blocks provides the basic building block for\\ninstructing rustc how it will link to native libraries. There are two accepted\\nforms of the link attribute today: #[link(name = \\"foo\\")] #[link(name = \\"foo\\", kind = \\"bar\\")] In both of these cases, foo is the name of the native library that we’re\\nlinking to, and in the second case bar is the type of native library that the\\ncompiler is linking to. There are currently three known types of native\\nlibraries: Dynamic - #[link(name = \\"readline\\")] Static - #[link(name = \\"my_build_dependency\\", kind = \\"static\\")] Frameworks - #[link(name = \\"CoreFoundation\\", kind = \\"framework\\")] Note that frameworks are only available on macOS targets. The different kind values are meant to differentiate how the native library\\nparticipates in linkage. From a linkage perspective, the Rust compiler creates\\ntwo flavors of artifacts: partial (rlib/staticlib) and final (dylib/binary).\\nNative dynamic library and framework dependencies are propagated to the final\\nartifact boundary, while static library dependencies are not propagated at\\nall, because the static libraries are integrated directly into the subsequent\\nartifact. A few examples of how this model can be used are: A native build dependency. Sometimes some C/C++ glue is needed when writing\\nsome Rust code, but distribution of the C/C++ code in a library format is\\na burden. In this case, the code will be archived into libfoo.a and then the\\nRust crate would declare a dependency via #[link(name = \\"foo\\", kind = \\"static\\")]. Regardless of the flavor of output for the crate, the native static library\\nwill be included in the output, meaning that distribution of the native static\\nlibrary is not necessary. A normal dynamic dependency. Common system libraries (like readline) are\\navailable on a large number of systems, and often a static copy of these\\nlibraries cannot be found. When this dependency is included in a Rust crate,\\npartial targets (like rlibs) will not link to the library, but when the rlib\\nis included in a final target (like a binary), the native library will be\\nlinked in. On macOS, frameworks behave with the same semantics as a dynamic library.","breadcrumbs":"FFI » Linking","id":"119","title":"Linking"},"12":{"body":"There is an accepted RFC to add proper types with an unknown size,\\ncalled extern types, which would let Rust developers model things like C’s void*\\nand other “declared but never defined” types more accurately. However as of\\nRust 2018, the feature is stuck in limbo over how size_of_val::<MyExternType>()\\nshould behave.","breadcrumbs":"Data Layout » Exotically Sized Types » Extern Types","id":"12","title":"Extern Types"},"120":{"body":"Some operations, like dereferencing raw pointers or calling functions that have been marked\\nunsafe are only allowed inside unsafe blocks. Unsafe blocks isolate unsafety and are a promise to\\nthe compiler that the unsafety does not leak out of the block. Unsafe functions, on the other hand, advertise it to the world. An unsafe function is written like\\nthis: #![allow(unused)] fn main() {\\nunsafe fn kaboom(ptr: *const i32) -> i32 { *ptr } } This function can only be called from an unsafe block or another unsafe function.","breadcrumbs":"FFI » Unsafe blocks","id":"120","title":"Unsafe blocks"},"121":{"body":"Foreign APIs often export a global variable which could do something like track\\nglobal state. In order to access these variables, you declare them in extern\\nblocks with the static keyword: #[link(name = \\"readline\\")]\\nunsafe extern { static rl_readline_version: libc::c_int;\\n} fn main() { println!(\\"You have readline version {} installed.\\", unsafe { rl_readline_version as i32 });\\n} Alternatively, you may need to alter global state provided by a foreign\\ninterface. To do this, statics can be declared with mut so we can mutate\\nthem. use std::ffi::CString;\\nuse std::ptr; #[link(name = \\"readline\\")]\\nunsafe extern { static mut rl_prompt: *const libc::c_char;\\n} fn main() { let prompt = CString::new(\\"[my-awesome-shell] $\\").unwrap(); unsafe { rl_prompt = prompt.as_ptr(); println!(\\"{:?}\\", rl_prompt); rl_prompt = ptr::null(); }\\n} Note that all interaction with a static mut is unsafe, both reading and\\nwriting. Dealing with global mutable state requires a great deal of care.","breadcrumbs":"FFI » Accessing foreign globals","id":"121","title":"Accessing foreign globals"},"122":{"body":"Most foreign code exposes a C ABI, and Rust uses the platform’s C calling convention by default when\\ncalling foreign functions. Some foreign functions, most notably the Windows API, use other calling\\nconventions. Rust provides a way to tell the compiler which convention to use: #[cfg(all(target_os = \\"win32\\", target_arch = \\"x86\\"))]\\n#[link(name = \\"kernel32\\")]\\n#[allow(non_snake_case)]\\nunsafe extern \\"stdcall\\" { fn SetEnvironmentVariableA(n: *const u8, v: *const u8) -> libc::c_int;\\n} fn main() { } This applies to the entire extern block. The list of supported ABI constraints\\nare: stdcall aapcs cdecl fastcall thiscall vectorcall\\nThis is currently hidden behind the abi_vectorcall gate and is subject to change. Rust system C win64 sysv64 Most of the ABIs in this list are self-explanatory, but the system ABI may\\nseem a little odd. This constraint selects whatever the appropriate ABI is for\\ninteroperating with the target’s libraries. For example, on win32 with a x86\\narchitecture, this means that the abi used would be stdcall. On x86_64,\\nhowever, windows uses the C calling convention, so C would be used. This\\nmeans that in our previous example, we could have used extern \\"system\\" { ... }\\nto define a block for all windows systems, not only x86 ones.","breadcrumbs":"FFI » Foreign calling conventions","id":"122","title":"Foreign calling conventions"},"123":{"body":"Rust guarantees that the layout of a struct is compatible with the platform’s\\nrepresentation in C only if the #[repr(C)] attribute is applied to it. #[repr(C, packed)] can be used to lay out struct members without padding. #[repr(C)] can also be applied to an enum. Rust’s owned boxes ( Box<T>) use non-nullable pointers as handles which point\\nto the contained object. However, they should not be manually created because\\nthey are managed by internal allocators. References can safely be assumed to be\\nnon-nullable pointers directly to the type. However, breaking the borrow\\nchecking or mutability rules is not guaranteed to be safe, so prefer using raw\\npointers ( *) if that’s needed because the compiler can’t make as many\\nassumptions about them. Vectors and strings share the same basic memory layout, and utilities are\\navailable in the vec and str modules for working with C APIs. However,\\nstrings are not terminated with \\\\0. If you need a NUL-terminated string for\\ninteroperability with C, you should use the CString type in the std::ffi\\nmodule. The libc crate on crates.io includes type aliases and function\\ndefinitions for the C standard library in the libc module, and Rust links\\nagainst libc and libm by default.","breadcrumbs":"FFI » Interoperability with foreign code","id":"123","title":"Interoperability with foreign code"},"124":{"body":"In C, functions can be ‘variadic’, meaning they accept a variable number of arguments. This can\\nbe achieved in Rust by specifying ... within the argument list of a foreign function declaration: unsafe extern { fn foo(x: i32, ...);\\n} fn main() { unsafe { foo(10, 20, 30, 40, 50); }\\n} Normal Rust functions can not be variadic: #![allow(unused)] fn main() {\\n// This will not compile fn foo(x: i32, ...) {} }","breadcrumbs":"FFI » Variadic functions","id":"124","title":"Variadic functions"},"125":{"body":"Certain Rust types are defined to never be null. This includes references ( &T, &mut T), boxes ( Box<T>), and function pointers ( extern \\"abi\\" fn()). When\\ninterfacing with C, pointers that might be null are often used, which would seem to\\nrequire some messy transmutes and/or unsafe code to handle conversions to/from Rust types.\\nHowever, trying to construct/work with these invalid values is undefined behavior,\\nso you should use the following workaround instead. As a special case, an enum is eligible for the “nullable pointer optimization” if it contains\\nexactly two variants, one of which contains no data and the other contains a field of one of the\\nnon-nullable types listed above. This means no extra space is required for a discriminant; rather,\\nthe empty variant is represented by putting a null value into the non-nullable field. This is\\ncalled an “optimization”, but unlike other optimizations it is guaranteed to apply to eligible\\ntypes. The most common type that takes advantage of the nullable pointer optimization is Option<T>,\\nwhere None corresponds to null. So Option<extern \\"C\\" fn(c_int) -> c_int> is a correct way\\nto represent a nullable function pointer using the C ABI (corresponding to the C type int (*)(int)). Here is a contrived example. Let’s say some C library has a facility for registering a\\ncallback, which gets called in certain situations. The callback is passed a function pointer\\nand an integer and it is supposed to run the function with the integer as a parameter. So\\nwe have function pointers flying across the FFI boundary in both directions. use libc::c_int; #[cfg(hidden)]\\nunsafe extern \\"C\\" { /// Registers the callback. fn register(cb: Option<extern \\"C\\" fn(Option<extern \\"C\\" fn(c_int) -> c_int>, c_int) -> c_int>);\\n} unsafe fn register(_: Option<extern \\"C\\" fn(Option<extern \\"C\\" fn(c_int) -> c_int>, c_int) -> c_int>) {} /// This fairly useless function receives a function pointer and an integer\\n/// from C, and returns the result of calling the function with the integer.\\n/// In case no function is provided, it squares the integer by default.\\nextern \\"C\\" fn apply(process: Option<extern \\"C\\" fn(c_int) -> c_int>, int: c_int) -> c_int { match process { Some(f) => f(int), None => int * int }\\n} fn main() { unsafe { register(Some(apply)); }\\n} And the code on the C side looks like this: void register(int (*f)(int (*)(int), int)) { ...\\n} No transmute required!","breadcrumbs":"FFI » The “nullable pointer optimization”","id":"125","title":"The “nullable pointer optimization”"},"126":{"body":"It’s important to be mindful of unwinding when working with FFI. Most\\nABI strings come in two variants, one with an -unwind suffix and one without.\\nThe Rust ABI always permits unwinding, so there is no Rust-unwind ABI. If you expect Rust panics or foreign (e.g. C++) exceptions to cross an FFI\\nboundary, that boundary must use the appropriate -unwind ABI string.\\nConversely, if you do not expect unwinding to cross an ABI boundary, use one of\\nthe non- unwind ABI strings. Note: Compiling with panic=abort will still cause panic! to immediately\\nabort the process, regardless of which ABI is specified by the function that panics. If an unwinding operation does encounter an ABI boundary that is\\nnot permitted to unwind, the behavior depends on the source of the unwinding\\n(Rust panic or a foreign exception): panic will cause the process to safely abort. A foreign exception entering Rust will cause undefined behavior. Note that the interaction of catch_unwind with foreign exceptions is\\nundefined, as is the interaction of panic with foreign exception-catching\\nmechanisms (notably C++’s try/ catch).","breadcrumbs":"FFI » FFI and unwinding","id":"126","title":"FFI and unwinding"},"127":{"body":"#[unsafe(no_mangle)]\\nunsafe extern \\"C-unwind\\" fn example() { panic!(\\"Uh oh\\");\\n} This function (when compiled with panic=unwind) is permitted to unwind C++\\nstack frames. [Rust function with `catch_unwind`, which stops the unwinding] | ... |\\n[C++ frames] | ^ | (calls) | (unwinding v | goes this\\n[Rust function `example`] | way) | | +--- rust function panics --+ If the C++ frames have objects, their destructors will be called.","breadcrumbs":"FFI » Rust panic with \\"C-unwind\\"","id":"127","title":"Rust panic with \\"C-unwind\\""},"128":{"body":"#[link(...)]\\nunsafe extern \\"C-unwind\\" { // A C++ function that may throw an exception fn may_throw();\\n} #[unsafe(no_mangle)]\\nunsafe extern \\"C-unwind\\" fn rust_passthrough() { let b = Box::new(5); unsafe { may_throw(); } println!(\\"{:?}\\", &b);\\n} A C++ function with a try block may invoke rust_passthrough and catch an\\nexception thrown by may_throw. [C++ function with `try` block that invokes `rust_passthrough`] | ... |\\n[Rust function `rust_passthrough`] | ^ | (calls) | (unwinding v | goes this\\n[C++ function `may_throw`] | way) | | +--- C++ function throws ----+ If may_throw does throw an exception, b will be dropped. Otherwise, 5\\nwill be printed.","breadcrumbs":"FFI » C++ throw with \\"C-unwind\\"","id":"128","title":"C++ throw with \\"C-unwind\\""},"129":{"body":"#![allow(unused)] fn main() {\\n#[unsafe(no_mangle)]\\nextern \\"C\\" fn assert_nonzero(input: u32) { assert!(input != 0)\\n} } If assert_nonzero is called with the argument 0, the runtime is guaranteed\\nto (safely) abort the process, whether or not compiled with panic=abort.","breadcrumbs":"FFI » panic can be stopped at an ABI boundary","id":"129","title":"panic can be stopped at an ABI boundary"},"13":{"body":"Rust allows you to specify alternative data layout strategies from the default.","breadcrumbs":"Data Layout » Other reprs » Alternative representations","id":"13","title":"Alternative representations"},"130":{"body":"If you are writing Rust code that may panic, and you don’t wish to abort the\\nprocess if it panics, you must use catch_unwind: use std::panic::catch_unwind; #[unsafe(no_mangle)]\\npub extern \\"C\\" fn oh_no() -> i32 { let result = catch_unwind(|| { panic!(\\"Oops!\\"); }); match result { Ok(_) => 0, Err(_) => 1, }\\n} fn main() {} Please note that catch_unwind will only catch unwinding panics, not\\nthose that abort the process. See the documentation of catch_unwind\\nfor more information.","breadcrumbs":"FFI » Catching panic preemptively","id":"130","title":"Catching panic preemptively"},"131":{"body":"Sometimes, a C library wants to provide a pointer to something, but not let you know the internal details of the thing it wants.\\nA stable and simple way is to use a void * argument: void foo(void *arg);\\nvoid bar(void *arg); We can represent this in Rust with the c_void type: unsafe extern \\"C\\" { pub fn foo(arg: *mut libc::c_void); pub fn bar(arg: *mut libc::c_void);\\n} fn main() {} This is a perfectly valid way of handling the situation. However, we can do a bit\\nbetter. To solve this, some C libraries will instead create a struct, where\\nthe details and memory layout of the struct are private. This gives some amount\\nof type safety. These structures are called ‘opaque’. Here’s an example, in C: struct Foo; /* Foo is a structure, but its contents are not part of the public interface */\\nstruct Bar;\\nvoid foo(struct Foo *arg);\\nvoid bar(struct Bar *arg); To do this in Rust, let’s create our own opaque types: #[repr(C)]\\npub struct Foo { _data: (), _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,\\n}\\n#[repr(C)]\\npub struct Bar { _data: (), _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,\\n} unsafe extern \\"C\\" { pub fn foo(arg: *mut Foo); pub fn bar(arg: *mut Bar);\\n} fn main() {} By including at least one private field and no constructor,\\nwe create an opaque type that we can’t instantiate outside of this module.\\n(A struct with no field could be instantiated by anyone.)\\nWe also want to use this type in FFI, so we have to add #[repr(C)].\\nThe marker ensures the compiler does not mark the struct as Send, Sync, and Unpin. ( *mut u8 is not Send or Sync, PhantomPinned is not Unpin) But because our Foo and Bar types are\\ndifferent, we’ll get type safety between the two of them, so we cannot\\naccidentally pass a pointer to Foo to bar(). Notice that it is a really bad idea to use an empty enum as FFI type.\\nThe compiler relies on empty enums being uninhabited, so handling values of type &Empty is a huge footgun and can lead to buggy program behavior (by triggering\\nundefined behavior). NOTE: The simplest way would use “extern types”.\\nBut it’s currently (as of June 2021) unstable and has some unresolved questions, see the RFC page and the tracking issue for more details.","breadcrumbs":"FFI » Representing opaque structs","id":"131","title":"Representing opaque structs"},"132":{"body":"This section documents features that are normally provided by the std crate and\\nthat #![no_std] developers have to deal with (i.e. provide) to build #![no_std] binary crates.","breadcrumbs":"Beneath std » Beneath std","id":"132","title":"Beneath std"},"133":{"body":"In order to build a #[no_std] executable we will need libc as a dependency.\\nWe can specify this using our Cargo.toml file: [dependencies]\\nlibc = { version = \\"0.2.146\\", default-features = false } Note that the default features have been disabled. This is a critical step - the default features of libc include the std crate and so must be\\ndisabled. Alternatively, we can use the unstable rustc_private private feature together\\nwith an extern crate libc; declaration as shown in the examples below. Note that\\nwindows-msvc targets do not require a libc, and correspondingly there is no libc\\ncrate in their sysroot. We do not need the extern crate libc; below, and having it\\non a windows-msvc target would be a compile error.","breadcrumbs":"Beneath std » Using libc","id":"133","title":"Using libc"},"134":{"body":"We will probably need a nightly version of the compiler to produce\\na #![no_std] executable because on many platforms, we have to provide the eh_personality lang item, which is unstable. You will need to define a symbol for the entry point that is suitable for your target. For example, main, _start, WinMain, or whatever starting point is relevant for your target.\\nAdditionally, you need to use the #![no_main] attribute to prevent the compiler from attempting to generate an entry point itself. Additionally, it’s required to define a panic handler function. #![feature(lang_items, core_intrinsics, rustc_private)]\\n#![allow(internal_features)]\\n#![no_std]\\n#![no_main] // Necessary for `panic = \\"unwind\\"` builds on cfg(unix) platforms.\\n#![feature(panic_unwind)]\\nextern crate unwind; // Pull in the system libc library for what crt0.o likely requires.\\n#[cfg(not(windows))]\\nextern crate libc; use core::ffi::{c_char, c_int};\\nuse core::panic::PanicInfo; // Entry point for this program.\\n#[unsafe(no_mangle)] // ensure that this symbol is included in the output as `main`\\nextern \\"C\\" fn main(_argc: c_int, _argv: *const *const c_char) -> c_int { 0\\n} // These functions are used by the compiler, but not for an empty program like this.\\n// They are normally provided by `std`.\\n#[lang = \\"eh_personality\\"]\\nfn rust_eh_personality() {}\\n#[panic_handler]\\nfn panic_handler(_info: &PanicInfo) -> ! { core::intrinsics::abort() } If you are working with a target that doesn’t have binary releases of the\\nstandard library available via rustup (this probably means you are building the core crate yourself) and need compiler-rt intrinsics (i.e. you are probably\\ngetting linker errors when building an executable: undefined reference to `__aeabi_memcpy\'), you need to manually link to the compiler_builtins crate to get those intrinsics and solve the linker errors.","breadcrumbs":"Beneath std » Writing an executable without std","id":"134","title":"Writing an executable without std"},"135":{"body":"#[panic_handler] is used to define the behavior of panic! in #![no_std] applications.\\nThe #[panic_handler] attribute must be applied to a function with signature fn(&PanicInfo) -> ! and such function must appear once in the dependency graph of a binary / dylib / cdylib\\ncrate. The API of PanicInfo can be found in the API docs. Given that #![no_std] applications have no standard output and that some #![no_std]\\napplications, e.g. embedded applications, need different panicking behaviors for development and for\\nrelease it can be helpful to have panic crates, crate that only contain a #[panic_handler].\\nThis way applications can easily swap the panicking behavior by simply linking to a different panic\\ncrate. Below is shown an example where an application has a different panicking behavior depending on\\nwhether is compiled using the dev profile ( cargo build) or using the release profile ( cargo build --release). panic-semihosting crate – log panic messages to the host stderr using semihosting: #![no_std] use core::fmt::{Write, self};\\nuse core::panic::PanicInfo; struct HStderr { // .. _0: (),\\n} impl HStderr { fn new() -> HStderr { HStderr { _0: () } } } impl fmt::Write for HStderr { fn write_str(&mut self, _: &str) -> fmt::Result { Ok(()) } } #[panic_handler]\\nfn panic(info: &PanicInfo) -> ! { let mut host_stderr = HStderr::new(); // logs \\"panicked at \'$reason\', src/main.rs:27:4\\" to the host stderr writeln!(host_stderr, \\"{}\\", info).ok(); loop {}\\n} panic-halt crate – halt the thread on panic; messages are discarded: #![no_std] use core::panic::PanicInfo; #[panic_handler]\\nfn panic(_info: &PanicInfo) -> ! { loop {}\\n} app crate: #![no_std] // dev profile\\n#[cfg(debug_assertions)]\\nextern crate panic_semihosting; // release profile\\n#[cfg(not(debug_assertions))]\\nextern crate panic_halt; fn main() { // ..\\n}","breadcrumbs":"Beneath std » #[panic_handler] » #[panic_handler]","id":"135","title":"#[panic_handler]"},"14":{"body":"This is the most important repr. It has fairly simple intent: do what C does.\\nThe order, size, and alignment of fields is exactly what you would expect from C\\nor C++. The type is also passed across extern \\"C\\" function call boundaries the\\nsame way C would pass the corresponding type. Any type you expect to pass through an FFI boundary should have repr(C), as C is the lingua-franca of the programming world. This is also\\nnecessary to soundly do more elaborate tricks with data layout such as\\nreinterpreting values as a different type. We strongly recommend using rust-bindgen and/or cbindgen to manage your FFI\\nboundaries for you. The Rust team works closely with those projects to ensure\\nthat they work robustly and are compatible with current and future guarantees\\nabout type layouts and reprs. The interaction of repr(C) with Rust’s more exotic data layout features must be\\nkept in mind. Due to its dual purpose as “for FFI” and “for layout control”, repr(C) can be applied to types that will be nonsensical or problematic if\\npassed through the FFI boundary. ZSTs are still zero-sized, even though this is not a standard behavior in\\nC, and is explicitly contrary to the behavior of an empty type in C++, which\\nsays they should still consume a byte of space. DST pointers (wide pointers) and tuples are not a concept\\nin C, and as such are never FFI-safe. Enums with fields also aren’t a concept in C or C++, but a valid bridging\\nof the types is defined. If T is an FFI-safe non-nullable pointer\\ntype, Option<T> is guaranteed to have the same layout and ABI as T and is\\ntherefore also FFI-safe. As of this writing, this covers &, &mut,\\nand function pointers, all of which can never be null. Tuple structs are like structs with regards to repr(C), as the only\\ndifference from a struct is that the fields aren’t named. repr(C) is equivalent to one of repr(u*) (see the next section) for\\nfieldless enums. The chosen size and sign is the default enum size and sign for the target platform’s C\\napplication binary interface (ABI). Note that enum representation in C is implementation\\ndefined, so this is really a “best guess”. In particular, this may be incorrect\\nwhen the C code of interest is compiled with certain flags. Fieldless enums with repr(C) or repr(u*) still may not be set to an\\ninteger value without a corresponding variant, even though this is\\npermitted behavior in C or C++. It is undefined behavior to (unsafely)\\nconstruct an instance of an enum that does not match one of its\\nvariants. (This allows exhaustive matches to continue to be written and\\ncompiled as normal.)","breadcrumbs":"Data Layout » Other reprs » repr(C)","id":"14","title":"repr(C)"},"15":{"body":"#[repr(transparent)] can only be used on a struct or single-variant enum that has a single non-zero-sized field (there may be additional zero-sized fields).\\nThe effect is that the layout and ABI of the whole struct/enum is guaranteed to be the same as that one field. NOTE: There’s a transparent_unions nightly feature to apply repr(transparent) to unions,\\nbut it hasn’t been stabilized due to design concerns. See the tracking issue for more details. The goal is to make it possible to transmute between the single field and the\\nstruct/enum. An example of that is UnsafeCell, which can be transmuted into\\nthe type it wraps ( UnsafeCell also uses the unstable no_niche,\\nso its ABI is not actually guaranteed to be the same when nested in other types). Also, passing the struct/enum through FFI where the inner field type is expected on\\nthe other side is guaranteed to work. In particular, this is necessary for struct Foo(f32) or enum Foo { Bar(f32) } to always have the same ABI as f32. This repr is only considered part of the public ABI of a type if either the single\\nfield is pub, or if its layout is documented in prose. Otherwise, the layout should\\nnot be relied upon by other crates. More details are in the RFC 1758 and the RFC 2645.","breadcrumbs":"Data Layout » Other reprs » repr(transparent)","id":"15","title":"repr(transparent)"},"16":{"body":"These specify the size and sign to make a fieldless enum. If the discriminant overflows\\nthe integer it has to fit in, it will produce a compile-time error. You can\\nmanually ask Rust to allow this by setting the overflowing element to explicitly\\nbe 0. However Rust will not allow you to create an enum where two variants have\\nthe same discriminant. The term “fieldless enum” only means that the enum doesn’t have data in any\\nof its variants. A fieldless enum without a repr is\\nstill a Rust native type, and does not have a stable layout or representation.\\nAdding a repr(u*)/ repr(i*) causes it to be treated exactly like the specified\\ninteger type for layout purposes (except that the compiler will still exploit its\\nknowledge of “invalid” values at this type to optimize enum layout, such as when\\nthis enum is wrapped in Option). Note that the function call ABI for these\\ntypes is still in general unspecified, except that across extern \\"C\\" calls they\\nare ABI-compatible with C enums of the same sign and size. If the enum has fields, the effect is similar to the effect of repr(C)\\nin that there is a defined layout of the type. This makes it possible to\\npass the enum to C code, or access the type’s raw representation and directly\\nmanipulate its tag and fields. See the RFC for details. These reprs have no effect on a struct. Adding an explicit repr(u*), repr(i*), or repr(C) to an enum with fields suppresses the null-pointer optimization, like: #![allow(unused)] fn main() { use std::mem::size_of;\\nenum MyOption<T> { Some(T), None,\\n} #[repr(u8)]\\nenum MyReprOption<T> { Some(T), None,\\n} assert_eq!(8, size_of::<MyOption<&u16>>());\\nassert_eq!(16, size_of::<MyReprOption<&u16>>()); } This optimization still applies to fieldless enums with an explicit repr(u*), repr(i*), or repr(C).","breadcrumbs":"Data Layout » Other reprs » repr(u*), repr(i*)","id":"16","title":"repr(u*), repr(i*)"},"17":{"body":"repr(packed(n)) (where n is a power of two) forces the type to have an\\nalignment of at most n. Most commonly used without an explicit n, repr(packed) is equivalent to repr(packed(1)) which forces Rust to strip\\nany padding, and only align the type to a byte. This may improve the memory\\nfootprint, but will likely have other negative side-effects. In particular, most architectures strongly prefer values to be naturally\\naligned. This may mean that unaligned loads are penalized (x86), or even fault\\n(some ARM chips). For simple cases like directly loading or storing a packed\\nfield, the compiler might be able to paper over alignment issues with shifts\\nand masks. However if you take a reference to a packed field, it’s unlikely\\nthat the compiler will be able to emit code to avoid an unaligned load. As this can cause undefined behavior, the lint has been implemented\\nand it will become a hard error. repr(packed)/repr(packed(n)) is not to be used lightly. Unless you have\\nextreme requirements, this should not be used. This repr is a modifier on repr(C) and repr(Rust). For FFI compatibility\\nyou most likely always want to be explicit: repr(C, packed).","breadcrumbs":"Data Layout » Other reprs » repr(packed), repr(packed(n))","id":"17","title":"repr(packed), repr(packed(n))"},"18":{"body":"repr(align(n)) (where n is a power of two) forces the type to have an\\nalignment of at least n. This enables several tricks, like making sure neighboring elements of an array\\nnever share the same cache line with each other (which may speed up certain\\nkinds of concurrent code). This is a modifier on repr(C) and repr(Rust). It is incompatible with repr(packed).","breadcrumbs":"Data Layout » Other reprs » repr(align(n))","id":"18","title":"repr(align(n))"},"19":{"body":"Ownership is the breakout feature of Rust. It allows Rust to be completely\\nmemory-safe and efficient, while avoiding garbage collection. Before getting\\ninto the ownership system in detail, we will consider the motivation of this\\ndesign. We will assume that you accept that garbage collection (GC) is not always an\\noptimal solution, and that it is desirable to manually manage memory in some\\ncontexts. If you do not accept this, might I interest you in a different\\nlanguage? Regardless of your feelings on GC, it is pretty clearly a massive boon to\\nmaking code safe. You never have to worry about things going away too soon\\n(although whether you still wanted to be pointing at that thing is a different\\nissue…). This is a pervasive problem that C and C++ programs need to deal\\nwith. Consider this simple mistake that all of us who have used a non-GC’d\\nlanguage have made at one point: #![allow(unused)] fn main() {\\nfn as_str(data: &u32) -> &str { // compute the string let s = format!(\\"{}\\", data); // OH NO! We returned a reference to something that // exists only in this function! // Dangling pointer! Use after free! Alas! // (this does not compile in Rust) &s\\n} } This is exactly what Rust’s ownership system was built to solve.\\nRust knows the scope in which the &s lives, and as such can prevent it from\\nescaping. However this is a simple case that even a C compiler could plausibly\\ncatch. Things get more complicated as code gets bigger and pointers get fed through\\nvarious functions. Eventually, a C compiler will fall down and won’t be able to\\nperform sufficient escape analysis to prove your code unsound. It will consequently\\nbe forced to accept your program on the assumption that it is correct. This will never happen to Rust. It’s up to the programmer to prove to the\\ncompiler that everything is sound. Of course, Rust’s story around ownership is much more complicated than just\\nverifying that references don’t escape the scope of their referent. That’s\\nbecause ensuring pointers are always valid is much more complicated than this.\\nFor instance in this code, #![allow(unused)] fn main() {\\nlet mut data = vec![1, 2, 3];\\n// get an internal reference\\nlet x = &data[0]; // OH NO! `push` causes the backing storage of `data` to be reallocated.\\n// Dangling pointer! Use after free! Alas!\\n// (this does not compile in Rust)\\ndata.push(4); println!(\\"{}\\", x); } naive scope analysis would be insufficient to prevent this bug, because data\\ndoes in fact live as long as we needed. However it was changed while we had\\na reference into it. This is why Rust requires any references to freeze the\\nreferent and its owners.","breadcrumbs":"Ownership » Ownership and Lifetimes","id":"19","title":"Ownership and Lifetimes"},"2":{"body":"It would be great to not have to worry about low-level implementation details.\\nWho could possibly care how much space the empty tuple occupies? Sadly, it\\nsometimes matters and we need to worry about it. The most common reason\\ndevelopers start to care about implementation details is performance, but more\\nimportantly, these details can become a matter of correctness when interfacing\\ndirectly with hardware, operating systems, or other languages. When implementation details start to matter in a safe programming language,\\nprogrammers usually have three options: fiddle with the code to encourage the compiler/runtime to perform an optimization adopt a more unidiomatic or cumbersome design to get the desired implementation rewrite the implementation in a language that lets you deal with those details For that last option, the language programmers tend to use is C. This is often\\nnecessary to interface with systems that only declare a C interface. Unfortunately, C is incredibly unsafe to use (sometimes for good reason),\\nand this unsafety is magnified when trying to interoperate with another\\nlanguage. Care must be taken to ensure C and the other language agree on\\nwhat’s happening, and that they don’t step on each other’s toes. So what does this have to do with Rust? Well, unlike C, Rust is a safe programming language. But, like C, Rust is an unsafe programming language. More accurately, Rust contains both a safe and unsafe programming language. Rust can be thought of as a combination of two programming languages: Safe\\nRust and Unsafe Rust. Conveniently, these names mean exactly what they say:\\nSafe Rust is Safe. Unsafe Rust is, well, not. In fact, Unsafe Rust lets us\\ndo some really unsafe things. Things the Rust authors will implore you not to\\ndo, but we’ll do anyway. Safe Rust is the true Rust programming language. If all you do is write Safe\\nRust, you will never have to worry about type-safety or memory-safety. You will\\nnever endure a dangling pointer, a use-after-free, or any other kind of\\nUndefined Behavior (a.k.a. UB). The standard library also gives you enough utilities out of the box that you’ll\\nbe able to write high-performance applications and libraries in pure idiomatic\\nSafe Rust. But maybe you want to talk to another language. Maybe you’re writing a\\nlow-level abstraction not exposed by the standard library. Maybe you’re writing the standard library (which is written entirely in Rust). Maybe you\\nneed to do something the type-system doesn’t understand and just frob some dang\\nbits. Maybe you need Unsafe Rust. Unsafe Rust is exactly like Safe Rust with all the same rules and semantics.\\nIt just lets you do some extra things that are Definitely Not Safe\\n(which we will define in the next section). The value of this separation is that we gain the benefits of using an unsafe\\nlanguage like C — low level control over implementation details — without most\\nof the problems that come with trying to integrate it with a completely\\ndifferent safe language. There are still some problems — most notably, we must become aware of properties\\nthat the type system assumes and audit them in any code that interacts with\\nUnsafe Rust. That’s the purpose of this book: to teach you about these assumptions\\nand how to manage them.","breadcrumbs":"Meet Safe and Unsafe » Meet Safe and Unsafe","id":"2","title":"Meet Safe and Unsafe"},"20":{"body":"There are two kinds of references: Shared reference: & Mutable reference: &mut Which obey the following rules: A reference cannot outlive its referent A mutable reference cannot be aliased That’s it. That’s the whole model references follow. Of course, we should probably define what aliased means. error[E0425]: cannot find value `aliased` in this scope --> <rust.rs>:2:20 |\\n2 | println!(\\"{}\\", aliased); | ^^^^^^^ not found in this scope error: aborting due to previous error Unfortunately, Rust hasn’t actually defined its aliasing model. 🙀 While we wait for the Rust devs to specify the semantics of their language,\\nlet’s use the next section to discuss what aliasing is in general, and why it\\nmatters.","breadcrumbs":"Ownership » References » References","id":"20","title":"References"},"21":{"body":"First off, let’s get some important caveats out of the way: We will be using the broadest possible definition of aliasing for the sake\\nof discussion. Rust’s definition will probably be more restricted to factor\\nin mutations and liveness. We will be assuming a single-threaded, interrupt-free, execution. We will also\\nbe ignoring things like memory-mapped hardware. Rust assumes these things\\ndon’t happen unless you tell it otherwise. For more details, see the Concurrency Chapter. With that said, here’s our working definition: variables and pointers alias\\nif they refer to overlapping regions of memory.","breadcrumbs":"Ownership » Aliasing » Aliasing","id":"21","title":"Aliasing"},"22":{"body":"So why should we care about aliasing? Consider this simple function: #![allow(unused)] fn main() {\\nfn compute(input: &u32, output: &mut u32) { if *input > 10 { *output = 1; } if *input > 5 { *output *= 2; } // remember that `output` will be `2` if `input > 10`\\n} } We would like to be able to optimize it to the following function: #![allow(unused)] fn main() {\\nfn compute(input: &u32, output: &mut u32) { let cached_input = *input; // keep `*input` in a register if cached_input > 10 { // If the input is greater than 10, the previous code would set the output to 1 and then double it, // resulting in an output of 2 (because `>10` implies `>5`). // Here, we avoid the double assignment and just set it directly to 2. *output = 2; } else if cached_input > 5 { *output *= 2; }\\n} } In Rust, this optimization should be sound. For almost any other language, it\\nwouldn’t be (barring global analysis). This is because the optimization relies\\non knowing that aliasing doesn’t occur, which most languages are fairly liberal\\nwith. Specifically, we need to worry about function arguments that make input\\nand output overlap, such as compute(&x, &mut x). With that input, we could get this execution: // input == output == 0xabad1dea // *input == *output == 20\\nif *input > 10 { // true (*input == 20) *output = 1; // also overwrites *input, because they are the same\\n}\\nif *input > 5 { // false (*input == 1) *output *= 2;\\n} // *input == *output == 1 Our optimized function would produce *output == 2 for this input, so the\\ncorrectness of our optimization relies on this input being impossible. In Rust we know this input should be impossible because &mut isn’t allowed to be\\naliased. So we can safely reject its possibility and perform this optimization.\\nIn most other languages, this input would be entirely possible, and must be considered. This is why alias analysis is important: it lets the compiler perform useful\\noptimizations! Some examples: keeping values in registers by proving no pointers access the value’s memory eliminating reads by proving some memory hasn’t been written to since last we read it eliminating writes by proving some memory is never read before the next write to it moving or reordering reads and writes by proving they don’t depend on each other These optimizations also tend to prove the soundness of bigger optimizations\\nsuch as loop vectorization, constant propagation, and dead code elimination. In the previous example, we used the fact that &mut u32 can’t be aliased to prove\\nthat writes to *output can’t possibly affect *input. This lets us cache *input\\nin a register, eliminating a read. By caching this read, we knew that the write in the > 10 branch couldn’t\\naffect whether we take the > 5 branch, allowing us to also eliminate a\\nread-modify-write (doubling *output) when *input > 10. The key thing to remember about alias analysis is that writes are the primary\\nhazard for optimizations. That is, the only thing that prevents us\\nfrom moving a read to any other part of the program is the possibility of us\\nre-ordering it with a write to the same location. For instance, we have no concern for aliasing in the following modified version\\nof our function, because we’ve moved the only write to *output to the very\\nend of our function. This allows us to freely reorder the reads of *input that\\noccur before it: #![allow(unused)] fn main() {\\nfn compute(input: &u32, output: &mut u32) { let mut temp = *output; if *input > 10 { temp = 1; } if *input > 5 { temp *= 2; } *output = temp;\\n} } We’re still relying on alias analysis to assume that input doesn’t alias temp, but the proof is much simpler: the value of a local variable can’t be\\naliased by things that existed before it was declared. This is an assumption\\nevery language freely makes, and so this version of the function could be\\noptimized the way we want in any language. This is why the definition of “alias” that Rust will use likely involves some\\nnotion of liveness and mutation: we don’t actually care if aliasing occurs if\\nthere aren’t any actual writes to memory happening. Of course, a full aliasing model for Rust must also take into consideration things like\\nfunction calls (which may mutate things we don’t see), raw pointers (which have\\nno aliasing requirements on their own), and UnsafeCell (which lets the referent\\nof an & be mutated).","breadcrumbs":"Ownership » Aliasing » Why Aliasing Matters","id":"22","title":"Why Aliasing Matters"},"23":{"body":"Rust enforces these rules through lifetimes. Lifetimes are named\\nregions of code that a reference must be valid for. Those regions\\nmay be fairly complex, as they correspond to paths of execution\\nin the program. There may even be holes in these paths of execution,\\nas it’s possible to invalidate a reference as long as it’s reinitialized\\nbefore it’s used again. Types which contain references (or pretend to)\\nmay also be tagged with lifetimes so that Rust can prevent them from\\nbeing invalidated as well. In most of our examples, the lifetimes will coincide with scopes. This is\\nbecause our examples are simple. The more complex cases where they don’t\\ncoincide are described below. Within a function body, Rust generally doesn’t let you explicitly name the\\nlifetimes involved. This is because it’s generally not really necessary\\nto talk about lifetimes in a local context; Rust has all the information and\\ncan work out everything as optimally as possible. Many anonymous scopes and\\ntemporaries that you would otherwise have to write are often introduced to\\nmake your code Just Work. However once you cross the function boundary, you need to start talking about\\nlifetimes. Lifetimes are denoted with an apostrophe: \'a, \'static. To dip\\nour toes with lifetimes, we’re going to pretend that we’re actually allowed\\nto label scopes with lifetimes, and desugar the examples from the start of\\nthis chapter. Originally, our examples made use of aggressive sugar – high fructose corn\\nsyrup even – around scopes and lifetimes, because writing everything out\\nexplicitly is extremely noisy. All Rust code relies on aggressive inference\\nand elision of “obvious” things. One particularly interesting piece of sugar is that each let statement\\nimplicitly introduces a scope. For the most part, this doesn’t really matter.\\nHowever it does matter for variables that refer to each other. As a simple\\nexample, let’s completely desugar this simple piece of Rust code: #![allow(unused)] fn main() {\\nlet x = 0;\\nlet y = &x;\\nlet z = &y; } The borrow checker always tries to minimize the extent of a lifetime, so it will\\nlikely desugar to the following: // NOTE: `\'a: {` and `&\'b x` is not valid syntax!\\n\'a: { let x: i32 = 0; \'b: { // lifetime used is \'b because that\'s good enough. let y: &\'b i32 = &\'b x; \'c: { // ditto on \'c let z: &\'c &\'b i32 = &\'c y; // \\"a reference to a reference to an i32\\" (with lifetimes annotated) } }\\n} Wow. That’s… awful. Let’s all take a moment to thank Rust for making this easier. Actually passing references to outer scopes will cause Rust to infer\\na larger lifetime: #![allow(unused)] fn main() {\\nlet x = 0;\\nlet z;\\nlet y = &x;\\nz = y; } \'a: { let x: i32 = 0; \'b: { let z: &\'b i32; \'c: { // Must use \'b here because the reference to x is // being passed to the scope \'b. let y: &\'b i32 = &\'b x; z = y; } }\\n}","breadcrumbs":"Ownership » Lifetimes » Lifetimes","id":"23","title":"Lifetimes"},"24":{"body":"Alright, let’s look at some of those examples from before: #![allow(unused)] fn main() {\\nfn as_str(data: &u32) -> &str { let s = format!(\\"{}\\", data); &s\\n} } desugars to: fn as_str<\'a>(data: &\'a u32) -> &\'a str { \'b: { let s = format!(\\"{}\\", data); return &\'a s; }\\n} This signature of as_str takes a reference to a u32 with some lifetime, and\\npromises that it can produce a reference to a str that can live just as long.\\nAlready we can see why this signature might be trouble. That basically implies\\nthat we’re going to find a str somewhere in the scope the reference\\nto the u32 originated in, or somewhere even earlier. That’s a bit of a tall\\norder. We then proceed to compute the string s, and return a reference to it. Since\\nthe contract of our function says the reference must outlive \'a, that’s the\\nlifetime we infer for the reference. Unfortunately, s was defined in the\\nscope \'b, so the only way this is sound is if \'b contains \'a – which is\\nclearly false since \'a must contain the function call itself. We have therefore\\ncreated a reference whose lifetime outlives its referent, which is literally\\nthe first thing we said that references can’t do. The compiler rightfully blows\\nup in our face. To make this more clear, we can expand the example: fn as_str<\'a>(data: &\'a u32) -> &\'a str { \'b: { let s = format!(\\"{}\\", data); return &\'a s }\\n} fn main() { \'c: { let x: u32 = 0; \'d: { // An anonymous scope is introduced because the borrow does not // need to last for the whole scope x is valid for. The return // of as_str must find a str somewhere before this function // call. Obviously not happening. println!(\\"{}\\", as_str::<\'d>(&\'d x)); } }\\n} Shoot! Of course, the right way to write this function is as follows: #![allow(unused)] fn main() {\\nfn to_string(data: &u32) -> String { format!(\\"{}\\", data)\\n} } We must produce an owned value inside the function to return it! The only way\\nwe could have returned an &\'a str would have been if it was in a field of the &\'a u32, which is obviously not the case. (Actually we could have also just returned a string literal, which as a global\\ncan be considered to reside at the bottom of the stack; though this limits\\nour implementation just a bit.)","breadcrumbs":"Ownership » Lifetimes » Example: references that outlive referents","id":"24","title":"Example: references that outlive referents"},"25":{"body":"How about the other example: #![allow(unused)] fn main() {\\nlet mut data = vec![1, 2, 3];\\nlet x = &data[0];\\ndata.push(4);\\nprintln!(\\"{}\\", x); } \'a: { let mut data: Vec<i32> = vec![1, 2, 3]; \'b: { // \'b is as big as we need this borrow to be // (just need to get to `println!`) let x: &\'b i32 = Index::index::<\'b>(&\'b data, 0); \'c: { // Temporary scope because we don\'t need the // &mut to last any longer. Vec::push(&\'c mut data, 4); } println!(\\"{}\\", x); }\\n} The problem here is a bit more subtle and interesting. We want Rust to\\nreject this program for the following reason: We have a live shared reference x\\nto a descendant of data when we try to take a mutable reference to data\\nto push. This would create an aliased mutable reference, which would\\nviolate the second rule of references. However this is not at all how Rust reasons that this program is bad. Rust\\ndoesn’t understand that x is a reference to a subpath of data. It doesn’t\\nunderstand Vec at all. What it does see is that x has to live for \'b in\\norder to be printed. The signature of Index::index subsequently demands that\\nthe reference we take to data has to survive for \'b. When we try to call push, it then sees us try to make an &\'c mut data. Rust knows that \'c is\\ncontained within \'b, and rejects our program because the &\'b data must still\\nbe alive! Here we see that the lifetime system is much more coarse than the reference\\nsemantics we’re actually interested in preserving. For the most part, that’s\\ntotally ok, because it keeps us from spending all day explaining our program\\nto the compiler. However it does mean that several programs that are totally\\ncorrect with respect to Rust’s true semantics are rejected because lifetimes\\nare too dumb.","breadcrumbs":"Ownership » Lifetimes » Example: aliasing a mutable reference","id":"25","title":"Example: aliasing a mutable reference"},"26":{"body":"A reference (sometimes called a borrow) is alive from the place it is\\ncreated to its last use. The borrowed value needs to outlive only borrows that\\nare alive. This looks simple, but there are a few subtleties. The following snippet compiles, because after printing x, it is no longer\\nneeded, so it doesn’t matter if it is dangling or aliased (even though the\\nvariable x technically exists to the very end of the scope). #![allow(unused)] fn main() {\\nlet mut data = vec![1, 2, 3];\\nlet x = &data[0];\\nprintln!(\\"{}\\", x);\\n// This is OK, x is no longer needed\\ndata.push(4); } However, if the value has a destructor, the destructor is run at the end of the\\nscope. And running the destructor is considered a use ‒ obviously the last one.\\nSo, this will not compile. #![allow(unused)] fn main() {\\n#[derive(Debug)]\\nstruct X<\'a>(&\'a i32); impl Drop for X<\'_> { fn drop(&mut self) {}\\n} let mut data = vec![1, 2, 3];\\nlet x = X(&data[0]);\\nprintln!(\\"{:?}\\", x);\\ndata.push(4);\\n// Here, the destructor is run and therefore this\'ll fail to compile. } One way to convince the compiler that x is no longer valid is by using drop(x) before data.push(4). Furthermore, there might be multiple possible last uses of the borrow, for\\nexample in each branch of a condition. #![allow(unused)] fn main() { fn some_condition() -> bool { true }\\nlet mut data = vec![1, 2, 3];\\nlet x = &data[0]; if some_condition() { println!(\\"{}\\", x); // This is the last use of `x` in this branch data.push(4); // So we can push here\\n} else { // There\'s no use of `x` in here, so effectively the last use is the // creation of x at the top of the example. data.push(5);\\n} } And a lifetime can have a pause in it. Or you might look at it as two distinct\\nborrows just being tied to the same local variable. This often happens around\\nloops (writing a new value of a variable at the end of the loop and using it for\\nthe last time at the top of the next iteration). #![allow(unused)] fn main() {\\nlet mut data = vec![1, 2, 3];\\n// This mut allows us to change where the reference points to\\nlet mut x = &data[0]; println!(\\"{}\\", x); // Last use of this borrow\\ndata.push(4);\\nx = &data[3]; // We start a new borrow here\\nprintln!(\\"{}\\", x); } Historically, Rust kept the borrow alive until the end of scope, so these\\nexamples might fail to compile with older compilers. Also, there are still some\\ncorner cases where Rust fails to properly shorten the live part of the borrow\\nand fails to compile even when it looks like it should. These’ll be solved over\\ntime.","breadcrumbs":"Ownership » Lifetimes » The area covered by a lifetime","id":"26","title":"The area covered by a lifetime"},"27":{"body":"Given the following code: #[derive(Debug)]\\nstruct Foo; impl Foo { fn mutate_and_share(&mut self) -> &Self { &*self } fn share(&self) {}\\n} fn main() { let mut foo = Foo; let loan = foo.mutate_and_share(); foo.share(); println!(\\"{:?}\\", loan);\\n} One might expect it to compile. We call mutate_and_share, which mutably\\nborrows foo temporarily, but then returns only a shared reference. Therefore\\nwe would expect foo.share() to succeed as foo shouldn’t be mutably borrowed. However when we try to compile it: error[E0502]: cannot borrow `foo` as immutable because it is also borrowed as mutable --> src/main.rs:12:5 |\\n11 | let loan = foo.mutate_and_share(); | --- mutable borrow occurs here\\n12 | foo.share(); | ^^^ immutable borrow occurs here\\n13 | println!(\\"{:?}\\", loan); What happened? Well, we got the exact same reasoning as we did for Example 2 in the previous section. We desugar the program and we get\\nthe following: struct Foo; impl Foo { fn mutate_and_share<\'a>(&\'a mut self) -> &\'a Self { &\'a *self } fn share<\'a>(&\'a self) {}\\n} fn main() { \'b: { let mut foo: Foo = Foo; \'c: { let loan: &\'c Foo = Foo::mutate_and_share::<\'c>(&\'c mut foo); \'d: { Foo::share::<\'d>(&\'d foo); } println!(\\"{:?}\\", loan); } }\\n} The lifetime system is forced to extend the &mut foo to have lifetime \'c,\\ndue to the lifetime of loan and mutate_and_share’s signature. Then when we\\ntry to call share, it sees we’re trying to alias that &\'c mut foo and\\nblows up in our face! This program is clearly correct according to the reference semantics we actually\\ncare about, but the lifetime system is too coarse-grained to handle that.","breadcrumbs":"Ownership » Limits of Lifetimes » Limits of Lifetimes","id":"27","title":"Limits of Lifetimes"},"28":{"body":"The following code fails to compile, because Rust sees that a variable, map,\\nis borrowed twice, and can not infer that the first borrow ceases to be needed\\nbefore the second one occurs. This is caused by Rust conservatively falling back\\nto using a whole scope for the first borrow. This will eventually get fixed. #![allow(unused)] fn main() { use std::collections::HashMap; use std::hash::Hash;\\nfn get_default<\'m, K, V>(map: &\'m mut HashMap<K, V>, key: K) -> &\'m mut V\\nwhere K: Clone + Eq + Hash, V: Default,\\n{ match map.get_mut(&key) { Some(value) => value, None => { map.insert(key.clone(), V::default()); map.get_mut(&key).unwrap() } }\\n} } Because of the lifetime restrictions imposed, &mut map’s lifetime\\noverlaps other mutable borrows, resulting in a compile error: error[E0499]: cannot borrow `*map` as mutable more than once at a time --> src/main.rs:12:13 |\\n4 | fn get_default<\'m, K, V>(map: &\'m mut HashMap<K, V>, key: K) -> &\'m mut V | -- lifetime `\'m` defined here\\n...\\n9 | match map.get_mut(&key) { | - --- first mutable borrow occurs here | _____| | |\\n10 | | Some(value) => value,\\n11 | | None => {\\n12 | | map.insert(key.clone(), V::default()); | | ^^^ second mutable borrow occurs here\\n13 | | map.get_mut(&key).unwrap()\\n14 | | }\\n15 | | } | |_____- returning this value requires that `*map` is borrowed for `\'m`","breadcrumbs":"Ownership » Limits of Lifetimes » Improperly reduced borrows","id":"28","title":"Improperly reduced borrows"},"29":{"body":"In order to make common patterns more ergonomic, Rust allows lifetimes to be elided in function signatures. A lifetime position is anywhere you can write a lifetime in a type: &\'a T\\n&\'a mut T\\nT<\'a> Lifetime positions can appear as either “input” or “output”: For fn definitions, fn types, and the traits Fn, FnMut, and FnOnce,\\ninput refers to the types of the formal arguments, while output refers to\\nresult types. So fn foo(s: &str) -> (&str, &str) has elided one lifetime in\\ninput position and two lifetimes in output position. Note that the input\\npositions of a fn method definition do not include the lifetimes that occur\\nin the method’s impl header (nor lifetimes that occur in the trait header,\\nfor a default method). For impl headers, all types are input. So impl Trait<&T> for Struct<&T>\\nhas elided two lifetimes in input position, while impl Struct<&T> has elided\\none. Elision rules are as follows: Each elided lifetime in input position becomes a distinct lifetime\\nparameter. If there is exactly one input lifetime position (elided or not), that lifetime\\nis assigned to all elided output lifetimes. If there are multiple input lifetime positions, but one of them is &self or &mut self, the lifetime of self is assigned to all elided output lifetimes. Otherwise, it is an error to elide an output lifetime. Examples: fn print(s: &str); // elided\\nfn print<\'a>(s: &\'a str); // expanded fn debug(lvl: usize, s: &str); // elided\\nfn debug<\'a>(lvl: usize, s: &\'a str); // expanded fn substr(s: &str, until: usize) -> &str; // elided\\nfn substr<\'a>(s: &\'a str, until: usize) -> &\'a str; // expanded fn get_str() -> &str; // ILLEGAL fn frob(s: &str, t: &str) -> &str; // ILLEGAL fn get_mut(&mut self) -> &mut T; // elided\\nfn get_mut<\'a>(&\'a mut self) -> &\'a mut T; // expanded fn args<T: ToCStr>(&mut self, args: &[T]) -> &mut Command // elided\\nfn args<\'a, \'b, T: ToCStr>(&\'a mut self, args: &\'b [T]) -> &\'a mut Command // expanded fn new(buf: &mut [u8]) -> BufWriter; // elided\\nfn new(buf: &mut [u8]) -> BufWriter<\'_>; // elided (with `rust_2018_idioms`)\\nfn new<\'a>(buf: &\'a mut [u8]) -> BufWriter<\'a> // expanded","breadcrumbs":"Ownership » Lifetime Elision » Lifetime Elision","id":"29","title":"Lifetime Elision"},"3":{"body":"What’s the relationship between Safe Rust and Unsafe Rust? How do they\\ninteract? The separation between Safe Rust and Unsafe Rust is controlled with the unsafe keyword, which acts as an interface from one to the other. This is\\nwhy we can say Safe Rust is a safe language: all the unsafe parts are kept\\nexclusively behind the unsafe boundary. If you wish, you can even toss #![forbid(unsafe_code)] into your code base to statically guarantee that\\nyou’re only writing Safe Rust. The unsafe keyword has two uses: to declare the existence of contracts the\\ncompiler can’t check, and to declare that a programmer has checked that these\\ncontracts have been upheld. You can use unsafe to indicate the existence of unchecked contracts on functions and trait declarations. On functions, unsafe means that\\nusers of the function must check that function’s documentation to ensure\\nthey are using it in a way that maintains the contracts the function\\nrequires. On trait declarations, unsafe means that implementors of the\\ntrait must check the trait documentation to ensure their implementation\\nmaintains the contracts the trait requires. You can use unsafe on a block to declare that all unsafe actions performed\\nwithin are verified to uphold the contracts of those operations. For instance,\\nthe index passed to slice::get_unchecked is in-bounds. You can use unsafe on a trait implementation to declare that the implementation\\nupholds the trait’s contract. For instance, that a type implementing Send is\\nreally safe to move to another thread. The standard library has a number of unsafe functions, including: slice::get_unchecked, which performs unchecked indexing,\\nallowing memory safety to be freely violated. mem::transmute reinterprets some value as having a given type,\\nbypassing type safety in arbitrary ways (see conversions for details). Every raw pointer to a sized type has an offset method that\\ninvokes Undefined Behavior if the passed offset is not “in bounds”. All FFI (Foreign Function Interface) functions are unsafe to call because the\\nother language can do arbitrary operations that the Rust compiler can’t check. As of Rust 1.29.2, the standard library defines the following unsafe traits\\n(there are others, but they are not stabilized yet and some of them may never\\nbe): Send is a marker trait (a trait with no API) that promises implementors\\nare safe to send (move) to another thread. Sync is a marker trait that promises threads can safely share implementors\\nthrough a shared reference. GlobalAlloc allows customizing the memory allocator of the whole program. Much of the Rust standard library also uses Unsafe Rust internally. These\\nimplementations have generally been rigorously manually checked, so the Safe Rust\\ninterfaces built on top of these implementations can be assumed to be safe. The need for all of this separation boils down to a single fundamental property\\nof Safe Rust, the soundness property: No matter what, Safe Rust can’t cause Undefined Behavior. The design of the safe/unsafe split means that there is an asymmetric trust\\nrelationship between Safe and Unsafe Rust. Safe Rust inherently has to\\ntrust that any Unsafe Rust it touches has been written correctly.\\nOn the other hand, Unsafe Rust cannot trust Safe Rust without care. As an example, Rust has the PartialOrd and Ord traits to differentiate\\nbetween types which can “just” be compared, and those that provide a “total”\\nordering (which basically means that comparison behaves reasonably). BTreeMap doesn’t really make sense for partially-ordered types, and so it\\nrequires that its keys implement Ord. However, BTreeMap has Unsafe Rust code\\ninside of its implementation. Because it would be unacceptable for a sloppy Ord\\nimplementation (which is Safe to write) to cause Undefined Behavior, the Unsafe\\ncode in BTreeMap must be written to be robust against Ord implementations which\\naren’t actually total — even though that’s the whole point of requiring Ord. The Unsafe Rust code just can’t trust the Safe Rust code to be written correctly.\\nThat said, BTreeMap will still behave completely erratically if you feed in\\nvalues that don’t have a total ordering. It just won’t ever cause Undefined\\nBehavior. One may wonder, if BTreeMap cannot trust Ord because it’s Safe, why can it\\ntrust any Safe code? For instance BTreeMap relies on integers and slices to\\nbe implemented correctly. Those are safe too, right? The difference is one of scope. When BTreeMap relies on integers and slices,\\nit’s relying on one very specific implementation. This is a measured risk that\\ncan be weighed against the benefit. In this case there’s basically zero risk;\\nif integers and slices are broken, everyone is broken. Also, they’re maintained\\nby the same people who maintain BTreeMap, so it’s easy to keep tabs on them. On the other hand, BTreeMap’s key type is generic. Trusting its Ord implementation\\nmeans trusting every Ord implementation in the past, present, and future.\\nHere the risk is high: someone somewhere is going to make a mistake and mess up\\ntheir Ord implementation, or even just straight up lie about providing a total\\nordering because “it seems to work”. When that happens, BTreeMap needs to be\\nprepared. The same logic applies to trusting a closure that’s passed to you to behave\\ncorrectly. This problem of unbounded generic trust is the problem that unsafe traits\\nexist to resolve. The BTreeMap type could theoretically require that keys\\nimplement a new trait called UnsafeOrd, rather than Ord, that might look\\nlike this: #![allow(unused)] fn main() {\\nuse std::cmp::Ordering; unsafe trait UnsafeOrd { fn cmp(&self, other: &Self) -> Ordering;\\n} } Then, a type would use unsafe to implement UnsafeOrd, indicating that\\nthey’ve ensured their implementation maintains whatever contracts the\\ntrait expects. In this situation, the Unsafe Rust in the internals of BTreeMap would be justified in trusting that the key type’s UnsafeOrd\\nimplementation is correct. If it isn’t, it’s the fault of the unsafe trait\\nimplementation, which is consistent with Rust’s safety guarantees. The decision of whether to mark a trait unsafe is an API design choice. A\\nsafe trait is easier to implement, but any unsafe code that relies on it must\\ndefend against incorrect behavior. Marking a trait unsafe shifts this\\nresponsibility to the implementor. Rust has traditionally avoided marking\\ntraits unsafe because it makes Unsafe Rust pervasive, which isn’t desirable. Send and Sync are marked unsafe because thread safety is a fundamental\\nproperty that unsafe code can’t possibly hope to defend against in the way it\\ncould defend against a buggy Ord implementation. Similarly, GlobalAlloc\\nis keeping accounts of all the memory in the program and other things like Box or Vec that build on top of it. If it does something weird (giving the same\\nchunk of memory to another request when it is still in use), there’s no chance\\nto detect that and do anything about it. The decision of whether to mark your own traits unsafe depends on the same\\nsort of consideration. If unsafe code can’t reasonably expect to defend\\nagainst a broken implementation of the trait, then marking the trait unsafe is\\na reasonable choice. As an aside, while Send and Sync are unsafe traits, they are also\\nautomatically implemented for types when such derivations are provably safe\\nto do. Send is automatically derived for all types composed only of values\\nwhose types also implement Send. Sync is automatically derived for all\\ntypes composed only of values whose types also implement Sync. This minimizes\\nthe pervasive unsafety of making these two traits unsafe. And not many people\\nare going to implement memory allocators (or use them directly, for that\\nmatter). This is the balance between Safe and Unsafe Rust. The separation is designed to\\nmake using Safe Rust as ergonomic as possible, but requires extra effort and\\ncare when writing Unsafe Rust. The rest of this book is largely a discussion\\nof the sort of care that must be taken, and what contracts Unsafe Rust must uphold.","breadcrumbs":"Meet Safe and Unsafe » How Safe and Unsafe Interact » How Safe and Unsafe Interact","id":"3","title":"How Safe and Unsafe Interact"},"30":{"body":"Unsafe code can often end up producing references or lifetimes out of thin air.\\nSuch lifetimes come into the world as unbounded. The most common source of\\nthis is taking a reference to a dereferenced raw pointer, which produces a\\nreference with an unbounded lifetime. Such a lifetime becomes as big as context\\ndemands. This is in fact more powerful than simply becoming \'static, because\\nfor instance &\'static &\'a T will fail to typecheck, but the unbound lifetime\\nwill perfectly mold into &\'a &\'a T as needed. However for most intents and\\npurposes, such an unbounded lifetime can be regarded as \'static. Almost no reference is \'static, so this is probably wrong. transmute and transmute_copy are the two other primary offenders. One should endeavor to\\nbound an unbounded lifetime as quickly as possible, especially across function\\nboundaries. Given a function, any output lifetimes that don’t derive from inputs are\\nunbounded. For instance: fn get_str<\'a>(s: *const String) -> &\'a str { unsafe { &*s }\\n} fn main() { let soon_dropped = String::from(\\"hello\\"); let dangling = get_str(&soon_dropped); drop(soon_dropped); println!(\\"Invalid str: {}\\", dangling); // Invalid str: gӚ_`\\n} The easiest way to avoid unbounded lifetimes is to use lifetime elision at the\\nfunction boundary. If an output lifetime is elided, then it must be bounded by\\nan input lifetime. Of course it might be bounded by the wrong lifetime, but\\nthis will usually just cause a compiler error, rather than allow memory safety\\nto be trivially violated. Within a function, bounding lifetimes is more error-prone. The safest and easiest\\nway to bound a lifetime is to return it from a function with a bound lifetime.\\nHowever if this is unacceptable, the reference can be placed in a location with\\na specific lifetime. Unfortunately it’s impossible to name all lifetimes involved\\nin a function.","breadcrumbs":"Ownership » Unbounded Lifetimes » Unbounded Lifetimes","id":"30","title":"Unbounded Lifetimes"},"31":{"body":"Rust’s Fn traits are a little bit magic. For instance, we can write the\\nfollowing code: struct Closure<F> { data: (u8, u16), func: F,\\n} impl<F> Closure<F> where F: Fn(&(u8, u16)) -> &u8,\\n{ fn call(&self) -> &u8 { (self.func)(&self.data) }\\n} fn do_it(data: &(u8, u16)) -> &u8 { &data.0 } fn main() { let clo = Closure { data: (0, 1), func: do_it }; println!(\\"{}\\", clo.call());\\n} If we try to naively desugar this code in the same way that we did in the lifetimes section, we run into some trouble: // NOTE: `&\'b data.0` and `\'x: {` is not valid syntax!\\nstruct Closure<F> { data: (u8, u16), func: F,\\n} impl<F> Closure<F> // where F: Fn(&\'??? (u8, u16)) -> &\'??? u8,\\n{ fn call<\'a>(&\'a self) -> &\'a u8 { (self.func)(&self.data) }\\n} fn do_it<\'b>(data: &\'b (u8, u16)) -> &\'b u8 { &\'b data.0 } fn main() { \'x: { let clo = Closure { data: (0, 1), func: do_it }; println!(\\"{}\\", clo.call()); }\\n} How on earth are we supposed to express the lifetimes on F’s trait bound? We\\nneed to provide some lifetime there, but the lifetime we care about can’t be\\nnamed until we enter the body of call! Also, that isn’t some fixed lifetime; call works with any lifetime &self happens to have at that point. This job requires The Magic of Higher-Rank Trait Bounds (HRTBs). The way we\\ndesugar this is as follows: where for<\'a> F: Fn(&\'a (u8, u16)) -> &\'a u8, Alternatively: where F: for<\'a> Fn(&\'a (u8, u16)) -> &\'a u8, (Where Fn(a, b, c) -> d is itself just sugar for the unstable real Fn\\ntrait) for<\'a> can be read as “for all choices of \'a”, and basically produces an infinite list of trait bounds that F must satisfy. Intense. There aren’t many\\nplaces outside of the Fn traits where we encounter HRTBs, and even for\\nthose we have a nice magic sugar for the common cases. In summary, we can rewrite the original code more explicitly as: struct Closure<F> { data: (u8, u16), func: F,\\n} impl<F> Closure<F> where for<\'a> F: Fn(&\'a (u8, u16)) -> &\'a u8,\\n{ fn call(&self) -> &u8 { (self.func)(&self.data) }\\n} fn do_it(data: &(u8, u16)) -> &u8 { &data.0 } fn main() { let clo = Closure { data: (0, 1), func: do_it }; println!(\\"{}\\", clo.call());\\n}","breadcrumbs":"Ownership » Higher-Rank Trait Bounds » Higher-Rank Trait Bounds (HRTBs)","id":"31","title":"Higher-Rank Trait Bounds (HRTBs)"},"32":{"body":"Rust uses lifetimes to track the relationships between borrows and ownership.\\nHowever, a naive implementation of lifetimes would be either too restrictive,\\nor permit undefined behavior. In order to allow flexible usage of lifetimes\\nwhile also preventing their misuse, Rust uses subtyping and variance. Let’s start with an example. // Note: debug expects two parameters with the *same* lifetime\\nfn debug<\'a>(a: &\'a str, b: &\'a str) { println!(\\"a = {a:?} b = {b:?}\\");\\n} fn main() { let hello: &\'static str = \\"hello\\"; { let world = String::from(\\"world\\"); let world = &world; // \'world has a shorter lifetime than \'static debug(hello, world); }\\n} In a conservative implementation of lifetimes, since hello and world have different lifetimes,\\nwe might see the following error: error[E0308]: mismatched types --> src/main.rs:10:16 |\\n10 | debug(hello, world); | ^ | | | expected `&\'static str`, found struct `&\'world str` This would be rather unfortunate. In this case,\\nwhat we want is to accept any type that lives at least as long as \'world.\\nLet’s try using subtyping with our lifetimes.","breadcrumbs":"Ownership » Subtyping and Variance » Subtyping and Variance","id":"32","title":"Subtyping and Variance"},"33":{"body":"Subtyping is the idea that one type can be used in place of another. Let’s define that Sub is a subtype of Super (we’ll be using the notation Sub <: Super throughout this chapter). What this is suggesting to us is that the set of requirements that Super defines\\nare completely satisfied by Sub. Sub may then have more requirements. Now, in order to use subtyping with lifetimes, we need to define the requirement of a lifetime: \'a defines a region of code. Now that we have a defined set of requirements for lifetimes, we can define how they relate to each other: \'long <: \'short if and only if \'long defines a region of code that completely contains \'short. \'long may define a region larger than \'short, but that still fits our definition. As we will see throughout the rest of this chapter,\\nsubtyping is a lot more complicated and subtle than this,\\nbut this simple rule is a very good 99% intuition.\\nAnd unless you write unsafe code, the compiler will automatically handle all the corner cases for you. But this is the Rustonomicon. We’re writing unsafe code,\\nso we need to understand how this stuff really works, and how we can mess it up. Going back to our example above, we can say that \'static <: \'world.\\nFor now, let’s also accept the idea that subtypes of lifetimes can be passed through references\\n(more on this in Variance), e.g. &\'static str is a subtype of &\'world str, then we can “downgrade” &\'static str into a &\'world str.\\nWith that, the example above will compile: fn debug<\'a>(a: &\'a str, b: &\'a str) { println!(\\"a = {a:?} b = {b:?}\\");\\n} fn main() { let hello: &\'static str = \\"hello\\"; { let world = String::from(\\"world\\"); let world = &world; // \'world has a shorter lifetime than \'static debug(hello, world); // hello silently downgrades from `&\'static str` into `&\'world str` }\\n}","breadcrumbs":"Ownership » Subtyping and Variance » Subtyping","id":"33","title":"Subtyping"},"34":{"body":"Above, we glossed over the fact that \'static <: \'b implied that &\'static T <: &\'b T. This uses a property known as variance.\\nIt’s not always as simple as this example, though. To understand that, let’s try to extend this example a bit: fn assign<T>(input: &mut T, val: T) { *input = val;\\n} fn main() { let mut hello: &\'static str = \\"hello\\"; { let world = String::from(\\"world\\"); assign(&mut hello, &world); } println!(\\"{hello}\\"); // use after free 😿\\n} In assign, we are setting the hello reference to point to world.\\nBut then world goes out of scope, before the later use of hello in the println! This is a classic use-after-free bug! Our first instinct might be to blame the assign impl, but there’s really nothing wrong here.\\nIt shouldn’t be surprising that we might want to assign a T into a T. The problem is that we cannot assume that &mut &\'static str and &mut &\'b str are compatible.\\nThis means that &mut &\'static str cannot be a subtype of &mut &\'b str,\\neven if \'static is a subtype of \'b. Variance is the concept that Rust borrows to define relationships about subtypes through their generic parameters. NOTE: For convenience we will define a generic type F<T> so\\nthat we can easily talk about T. Hopefully this is clear in context. The type F’s variance is how the subtyping of its inputs affects the\\nsubtyping of its outputs. There are three kinds of variance in Rust. Given two\\ntypes Sub and Super, where Sub is a subtype of Super: F is covariant if F<Sub> is a subtype of F<Super> (the subtype property is passed through) F is contravariant if F<Super> is a subtype of F<Sub> (the subtype property is “inverted”) F is invariant otherwise (no subtyping relationship exists) If we remember from the above examples,\\nit was ok for us to treat &\'a T as a subtype of &\'b T if \'a <: \'b,\\ntherefore we can say that &\'a T is covariant over \'a. Also, we saw that it was not ok for us to treat &mut &\'a T as a subtype of &mut &\'b T,\\ntherefore we can say that &mut T is invariant over T Here is a table of some other generic types and their variances: ’a T U &\'a T covariant covariant &\'a mut T covariant invariant Box<T> covariant Vec<T> covariant UnsafeCell<T> invariant Cell<T> invariant fn(T) -> U contravariant covariant *const T covariant *mut T invariant Some of these can be explained simply in relation to the others: Vec<T> and all other owning pointers and collections follow the same logic as Box<T> Cell<T> and all other interior mutability types follow the same logic as UnsafeCell<T> UnsafeCell<T> having interior mutability gives it the same variance properties as &mut T *const T follows the logic of &T *mut T follows the logic of &mut T (or UnsafeCell<T>) For more types, see the “Variance” section on the reference. NOTE: the only source of contravariance in the language is the arguments to\\na function, which is why it really doesn’t come up much in practice. Invoking\\ncontravariance involves higher-order programming with function pointers that\\ntake references with specific lifetimes (as opposed to the usual “any lifetime”,\\nwhich gets into higher rank lifetimes, which work independently of subtyping). Now that we have some more formal understanding of variance,\\nlet’s go through some more examples in more detail. fn assign<T>(input: &mut T, val: T) { *input = val;\\n} fn main() { let mut hello: &\'static str = \\"hello\\"; { let world = String::from(\\"world\\"); assign(&mut hello, &world); } println!(\\"{hello}\\");\\n} And what do we get when we run this? error[E0597]: `world` does not live long enough --> src/main.rs:9:28 |\\n6 | let mut hello: &\'static str = \\"hello\\"; | ------------ type annotation requires that `world` is borrowed for `\'static`\\n...\\n9 | assign(&mut hello, &world); | ^^^^^^ borrowed value does not live long enough\\n10 | } | - `world` dropped here while still borrowed Good, it doesn’t compile! Let’s break down what’s happening here in detail. First let’s look at the assign function: #![allow(unused)] fn main() {\\nfn assign<T>(input: &mut T, val: T) { *input = val;\\n} } All it does is take a mutable reference and a value and overwrite the referent with it.\\nWhat’s important about this function is that it creates a type equality constraint. It\\nclearly says in its signature the referent and the value must be the exact same type. Meanwhile, in the caller we pass in &mut &\'static str and &\'world str. Because &mut T is invariant over T, the compiler concludes it can’t apply any subtyping\\nto the first argument, and so T must be exactly &\'static str. This is counter to the &T case: #![allow(unused)] fn main() {\\nfn debug<T: std::fmt::Debug>(a: T, b: T) { println!(\\"a = {a:?} b = {b:?}\\");\\n} } where similarly a and b must have the same type T.\\nBut since &\'a T is covariant over \'a, we are allowed to perform subtyping.\\nSo the compiler decides that &\'static str can become &\'b str if and only if &\'static str is a subtype of &\'b str, which will hold if \'static <: \'b.\\nThis is true, so the compiler is happy to continue compiling this code. As it turns out, the argument for why it’s ok for Box (and Vec, HashMap, etc.) to be covariant is pretty similar to the argument for why it’s ok for lifetimes to be covariant: as soon as you try to stuff them in something like a mutable reference, they inherit invariance and you’re prevented from doing anything bad. However Box makes it easier to focus on the by-value aspect of references that we partially glossed over. Unlike a lot of languages which allow values to be freely aliased at all times, Rust has a very strict rule: if you’re allowed to mutate or move a value, you are guaranteed to be the only one with access to it. Consider the following code: let hello: Box<&\'static str> = Box::new(\\"hello\\"); let mut world: Box<&\'b str>;\\nworld = hello; There is no problem at all with the fact that we have forgotten that hello was alive for \'static,\\nbecause as soon as we moved hello to a variable that only knew it was alive for \'b, we destroyed the only thing in the universe that remembered it lived for longer! Only one thing left to explain: function pointers. To see why fn(T) -> U should be covariant over U, consider the following signature: fn get_str() -> &\'a str; This function claims to produce a str bound by some lifetime \'a. As such, it is perfectly valid to\\nprovide a function with the following signature instead: fn get_static() -> &\'static str; So when the function is called, all it’s expecting is a &str which lives at least the lifetime of \'a,\\nit doesn’t matter if the value actually lives longer. However, the same logic does not apply to arguments. Consider trying to satisfy: fn store_ref(&\'a str); with: fn store_static(&\'static str); The first function can accept any string reference as long as it lives at least for \'a,\\nbut the second cannot accept a string reference that lives for any duration less than \'static,\\nwhich would cause a conflict.\\nCovariance doesn’t work here. But if we flip it around, it actually does\\nwork! If we need a function that can handle &\'static str, a function that can handle any reference lifetime\\nwill surely work fine. Let’s see this in practice use std::cell::RefCell;\\nthread_local! { pub static StaticVecs: RefCell<Vec<&\'static str>> = RefCell::new(Vec::new());\\n} /// saves the input given into a thread local `Vec<&\'static str>`\\nfn store(input: &\'static str) { StaticVecs.with_borrow_mut(|v| v.push(input));\\n} /// Calls the function with it\'s input (must have the same lifetime!)\\nfn demo<\'a>(input: &\'a str, f: fn(&\'a str)) { f(input);\\n} fn main() { demo(\\"hello\\", store); // \\"hello\\" is \'static. Can call `store` fine { let smuggle = String::from(\\"smuggle\\"); // `&smuggle` is not static. If we were to call `store` with `&smuggle`, // we would have pushed an invalid lifetime into the `StaticVecs`. // Therefore, `fn(&\'static str)` cannot be a subtype of `fn(&\'a str)` demo(&smuggle, store); } // use after free 😿 StaticVecs.with_borrow(|v| println!(\\"{v:?}\\"));\\n} And that’s why function types, unlike anything else in the language, are contravariant over their arguments. Now, this is all well and good for the types the standard library provides, but\\nhow is variance determined for types that you define? A struct, informally\\nspeaking, inherits the variance of its fields. If a struct MyType\\nhas a generic argument A that is used in a field a, then MyType’s variance\\nover A is exactly a’s variance over A. However if A is used in multiple fields: If all uses of A are covariant, then MyType is covariant over A If all uses of A are contravariant, then MyType is contravariant over A Otherwise, MyType is invariant over A #![allow(unused)] fn main() {\\nuse std::cell::Cell; struct MyType<\'a, \'b, A: \'a, B: \'b, C, D, E, F, G, H, In, Out, Mixed> { a: &\'a A, // covariant over \'a and A b: &\'b mut B, // covariant over \'b and invariant over B c: *const C, // covariant over C d: *mut D, // invariant over D e: E, // covariant over E f: Vec<F>, // covariant over F g: Cell<G>, // invariant over G h1: H, // would also be covariant over H except... h2: Cell<H>, // invariant over H, because invariance wins all conflicts i: fn(In) -> Out, // contravariant over In, covariant over Out k1: fn(Mixed) -> usize, // would be contravariant over Mixed except.. k2: Mixed, // invariant over Mixed, because invariance wins all conflicts\\n} }","breadcrumbs":"Ownership » Subtyping and Variance » Variance","id":"34","title":"Variance"},"35":{"body":"We have seen how lifetimes provide us some fairly simple rules for ensuring\\nthat we never read dangling references. However up to this point we have only ever\\ninteracted with the outlives relationship in an inclusive manner. That is,\\nwhen we talked about \'a: \'b, it was ok for \'a to live exactly as long as \'b. At first glance, this seems to be a meaningless distinction. Nothing ever\\ngets dropped at the same time as another, right? This is why we used the\\nfollowing desugaring of let statements: let x;\\nlet y; desugaring to: { let x; { let y; }\\n} There are some more complex situations which are not possible to desugar using\\nscopes, but the order is still defined ‒ variables are dropped in the reverse\\norder of their definition, fields of structs and tuples in order of their\\ndefinition. There are some more details about order of drop in RFC 1857. Let’s do this: let tuple = (vec![], vec![]); The left vector is dropped first. But does it mean the right one strictly\\noutlives it in the eyes of the borrow checker? The answer to this question is no. The borrow checker could track fields of tuples separately, but it would\\nstill be unable to decide what outlives what in case of vector elements, which\\nare dropped manually via pure-library code the borrow checker doesn’t\\nunderstand. So why do we care? We care because if the type system isn’t careful, it could\\naccidentally make dangling pointers. Consider the following simple program: struct Inspector<\'a>(&\'a u8); struct World<\'a> { inspector: Option<Inspector<\'a>>, days: Box<u8>,\\n} fn main() { let mut world = World { inspector: None, days: Box::new(1), }; world.inspector = Some(Inspector(&world.days));\\n} This program is totally sound and compiles today. The fact that days does not\\nstrictly outlive inspector doesn’t matter. As long as the inspector is\\nalive, so is days. However if we add a destructor, the program will no longer compile! struct Inspector<\'a>(&\'a u8); impl<\'a> Drop for Inspector<\'a> { fn drop(&mut self) { println!(\\"I was only {} days from retirement!\\", self.0); }\\n} struct World<\'a> { inspector: Option<Inspector<\'a>>, days: Box<u8>,\\n} fn main() { let mut world = World { inspector: None, days: Box::new(1), }; world.inspector = Some(Inspector(&world.days)); // Let\'s say `days` happens to get dropped first. // Then when Inspector is dropped, it will try to read free\'d memory!\\n} error[E0597]: `world.days` does not live long enough --> src/main.rs:19:38 |\\n19 | world.inspector = Some(Inspector(&world.days)); | ^^^^^^^^^^^ borrowed value does not live long enough\\n...\\n22 | } | - | | | `world.days` dropped here while still borrowed | borrow might be used here, when `world` is dropped and runs the destructor for type `World<\'_>` You can try changing the order of fields or use a tuple instead of the struct,\\nit’ll still not compile. Implementing Drop lets the Inspector execute some arbitrary code during its\\ndeath. This means it can potentially observe that types that are supposed to\\nlive as long as it does actually were destroyed first. Interestingly, only generic types need to worry about this. If they aren’t\\ngeneric, then the only lifetimes they can harbor are \'static, which will truly\\nlive forever. This is why this problem is referred to as sound generic drop.\\nSound generic drop is enforced by the drop checker. As of this writing, some\\nof the finer details of how the drop checker (also called dropck) validates\\ntypes is totally up in the air. However The Big Rule is the subtlety that we\\nhave focused on this whole section: For a generic type to soundly implement drop, its generics arguments must\\nstrictly outlive it. Obeying this rule is (usually) necessary to satisfy the borrow\\nchecker; obeying it is sufficient but not necessary to be\\nsound. That is, if your type obeys this rule then it’s definitely\\nsound to drop. The reason that it is not always necessary to satisfy the above rule\\nis that some Drop implementations will not access borrowed data even\\nthough their type gives them the capability for such access, or because we know\\nthe specific drop order and the borrowed data is still fine even if the borrow\\nchecker doesn’t know that. For example, this variant of the above Inspector example will never\\naccess borrowed data: struct Inspector<\'a>(&\'a u8, &\'static str); impl<\'a> Drop for Inspector<\'a> { fn drop(&mut self) { println!(\\"Inspector(_, {}) knows when *not* to inspect.\\", self.1); }\\n} struct World<\'a> { inspector: Option<Inspector<\'a>>, days: Box<u8>,\\n} fn main() { let mut world = World { inspector: None, days: Box::new(1), }; world.inspector = Some(Inspector(&world.days, \\"gadget\\")); // Let\'s say `days` happens to get dropped first. // Even when Inspector is dropped, its destructor will not access the // borrowed `days`.\\n} Likewise, this variant will also never access borrowed data: struct Inspector<T>(T, &\'static str); impl<T> Drop for Inspector<T> { fn drop(&mut self) { println!(\\"Inspector(_, {}) knows when *not* to inspect.\\", self.1); }\\n} struct World<T> { inspector: Option<Inspector<T>>, days: Box<u8>,\\n} fn main() { let mut world = World { inspector: None, days: Box::new(1), }; world.inspector = Some(Inspector(&world.days, \\"gadget\\")); // Let\'s say `days` happens to get dropped first. // Even when Inspector is dropped, its destructor will not access the // borrowed `days`.\\n} However, both of the above variants are rejected by the borrow\\nchecker during the analysis of fn main, saying that days does not\\nlive long enough. The reason is that the borrow checking analysis of main does not\\nknow about the internals of each Inspector’s Drop implementation. As\\nfar as the borrow checker knows while it is analyzing main, the body\\nof an inspector’s destructor might access that borrowed data. Therefore, the drop checker forces all borrowed data in a value to\\nstrictly outlive that value.","breadcrumbs":"Ownership » Drop Check » Drop Check","id":"35","title":"Drop Check"},"36":{"body":"The precise rules that govern drop checking may be less restrictive in\\nthe future. The current analysis is deliberately conservative; it forces all\\nborrowed data in a value to outlive that value, which is certainly sound. Future versions of the language may make the analysis more precise, to\\nreduce the number of cases where sound code is rejected as unsafe.\\nThis would help address cases such as the two Inspectors above that\\nknow not to inspect during destruction. In the meantime, there is an unstable attribute that one can use to\\nassert (unsafely) that a generic type’s destructor is guaranteed to\\nnot access any expired data, even if its type gives it the capability\\nto do so. That attribute is called may_dangle and was introduced in RFC 1327.\\nTo deploy it on the Inspector from above, we would write: #![feature(dropck_eyepatch)] struct Inspector<\'a>(&\'a u8, &\'static str); unsafe impl<#[may_dangle] \'a> Drop for Inspector<\'a> { fn drop(&mut self) { println!(\\"Inspector(_, {}) knows when *not* to inspect.\\", self.1); }\\n} struct World<\'a> { days: Box<u8>, inspector: Option<Inspector<\'a>>,\\n} fn main() { let mut world = World { inspector: None, days: Box::new(1), }; world.inspector = Some(Inspector(&world.days, \\"gadget\\"));\\n} Use of this attribute requires the Drop impl to be marked unsafe because the\\ncompiler is not checking the implicit assertion that no potentially expired data\\n(e.g. self.0 above) is accessed. The attribute can be applied to any number of lifetime and type parameters. In\\nthe following example, we assert that we access no data behind a reference of\\nlifetime \'b and that the only uses of T will be moves or drops, but omit\\nthe attribute from \'a and U, because we do access data with that lifetime\\nand that type: #![allow(unused)]\\n#![feature(dropck_eyepatch)] fn main() {\\nuse std::fmt::Display; struct Inspector<\'a, \'b, T, U: Display>(&\'a u8, &\'b u8, T, U); unsafe impl<\'a, #[may_dangle] \'b, #[may_dangle] T, U: Display> Drop for Inspector<\'a, \'b, T, U> { fn drop(&mut self) { println!(\\"Inspector({}, _, _, {})\\", self.0, self.3); }\\n} } It is sometimes obvious that no such access can occur, like the case above.\\nHowever, when dealing with a generic type parameter, such access can\\noccur indirectly. Examples of such indirect access are: invoking a callback, via a trait method call. (Future changes to the language, such as impl specialization, may add\\nother avenues for such indirect access.) Here is an example of invoking a callback: #![allow(unused)] fn main() {\\nstruct Inspector<T>(T, &\'static str, Box<for <\'r> fn(&\'r T) -> String>); impl<T> Drop for Inspector<T> { fn drop(&mut self) { // The `self.2` call could access a borrow e.g. if `T` is `&\'a _`. println!(\\"Inspector({}, {}) unwittingly inspects expired data.\\", (self.2)(&self.0), self.1); }\\n} } Here is an example of a trait method call: #![allow(unused)] fn main() {\\nuse std::fmt; struct Inspector<T: fmt::Display>(T, &\'static str); impl<T: fmt::Display> Drop for Inspector<T> { fn drop(&mut self) { // There is a hidden call to `<T as Display>::fmt` below, which // could access a borrow e.g. if `T` is `&\'a _` println!(\\"Inspector({}, {}) unwittingly inspects expired data.\\", self.0, self.1); }\\n} } And of course, all of these accesses could be further hidden within\\nsome other method invoked by the destructor, rather than being written\\ndirectly within it. In all of the above cases where the &\'a u8 is accessed in the\\ndestructor, adding the #[may_dangle]\\nattribute makes the type vulnerable to misuse that the borrow\\nchecker will not catch, inviting havoc. It is better to avoid adding\\nthe attribute.","breadcrumbs":"Ownership » Drop Check » An Escape Hatch","id":"36","title":"An Escape Hatch"},"37":{"body":"While the drop order of fields inside a struct is defined, relying on it is\\nfragile and subtle. When the order matters, it is better to use the ManuallyDrop wrapper.","breadcrumbs":"Ownership » Drop Check » A related side note about drop order","id":"37","title":"A related side note about drop order"},"38":{"body":"It turns out that when writing unsafe code, we generally don’t need to\\nworry at all about doing the right thing for the drop checker. However there\\nis one special case that you need to worry about, which we will look at in\\nthe next section.","breadcrumbs":"Ownership » Drop Check » Is that all about drop checker?","id":"38","title":"Is that all about drop checker?"},"39":{"body":"When working with unsafe code, we can often end up in a situation where\\ntypes or lifetimes are logically associated with a struct, but not actually\\npart of a field. This most commonly occurs with lifetimes. For instance, the Iter for &\'a [T] is (approximately) defined as follows: #![allow(unused)] fn main() {\\nstruct Iter<\'a, T: \'a> { ptr: *const T, end: *const T,\\n} } However because \'a is unused within the struct’s body, it’s unbounded. Because of the troubles this has historically caused,\\nunbounded lifetimes and types are forbidden in struct definitions.\\nTherefore we must somehow refer to these types in the body.\\nCorrectly doing this is necessary to have correct variance and drop checking. We do this using PhantomData, which is a special marker type. PhantomData\\nconsumes no space, but simulates a field of the given type for the purpose of\\nstatic analysis. This was deemed to be less error-prone than explicitly telling\\nthe type-system the kind of variance that you want, while also providing other\\nuseful things such as auto traits and the information needed by drop check. Iter logically contains a bunch of &\'a Ts, so this is exactly what we tell\\nthe PhantomData to simulate: #![allow(unused)] fn main() {\\nuse std::marker; struct Iter<\'a, T: \'a> { ptr: *const T, end: *const T, _marker: marker::PhantomData<&\'a T>,\\n} } and that’s it. The lifetime will be bounded, and your iterator will be covariant\\nover \'a and T. Everything Just Works.","breadcrumbs":"Ownership » PhantomData » PhantomData","id":"39","title":"PhantomData"},"4":{"body":"The only things that are different in Unsafe Rust are that you can: Dereference raw pointers Call unsafe functions (including C functions, compiler intrinsics, and the raw allocator) Implement unsafe traits Access or modify mutable statics Access fields of unions That’s it. The reason these operations are relegated to Unsafe is that misusing\\nany of these things will cause the ever dreaded Undefined Behavior. Invoking\\nUndefined Behavior gives the compiler full rights to do arbitrarily bad things\\nto your program. You definitely should not invoke Undefined Behavior. Unlike C, Undefined Behavior is pretty limited in scope in Rust. All the core\\nlanguage cares about is preventing the following things: Dereferencing (using the * operator on) dangling or unaligned pointers (see below) Breaking the pointer aliasing rules Calling a function with the wrong call ABI or unwinding from a function with the wrong unwind ABI. Causing a data race Executing code compiled with target features that the current thread of execution does\\nnot support Producing invalid values (either alone or as a field of a compound type such\\nas enum/ struct/array/tuple): a bool that isn’t 0 or 1 an enum with an invalid discriminant a null fn pointer a char outside the ranges [0x0, 0xD7FF] and [0xE000, 0x10FFFF] a ! (all values are invalid for this type) an integer ( i*/ u*), floating point value ( f*), or raw pointer read from uninitialized memory, or uninitialized memory in a str. a reference/ Box that is dangling, unaligned, or points to an invalid value. a wide reference, Box, or raw pointer that has invalid metadata: dyn Trait metadata is invalid if it is not a pointer to a vtable for Trait that matches the actual dynamic trait the pointer or reference points to slice metadata is invalid if the length is not a valid usize\\n(i.e., it must not be read from uninitialized memory) a type with custom invalid values that is one of those values, such as a NonNull that is null. (Requesting custom invalid values is an unstable\\nfeature, but some stable libstd types, like NonNull, make use of it.) For a more detailed explanation about “Undefined Behavior”, you may refer to the reference. “Producing” a value happens any time a value is assigned, passed to a\\nfunction/primitive operation or returned from a function/primitive operation. A reference/pointer is “dangling” if it is null or not all of the bytes it\\npoints to are part of the same allocation (so in particular they all have to be\\npart of some allocation). The span of bytes it points to is determined by the\\npointer value and the size of the pointee type. As a consequence, if the span is\\nempty, “dangling” is the same as “null”. Note that slices and strings point\\nto their entire range, so it’s important that the length metadata is never too\\nlarge (in particular, allocations and therefore slices and strings cannot be\\nbigger than isize::MAX bytes). If for some reason this is too cumbersome,\\nconsider using raw pointers. That’s it. That’s all the causes of Undefined Behavior baked into Rust. Of\\ncourse, unsafe functions and traits are free to declare arbitrary other\\nconstraints that a program must maintain to avoid Undefined Behavior. For\\ninstance, the allocator APIs declare that deallocating unallocated memory is\\nUndefined Behavior. However, violations of these constraints generally will just transitively lead to one of\\nthe above problems. Some additional constraints may also derive from compiler\\nintrinsics that make special assumptions about how code can be optimized. For instance,\\nVec and Box make use of intrinsics that require their pointers to be non-null at all times. Rust is otherwise quite permissive with respect to other dubious operations.\\nRust considers it “safe” to: Deadlock Have a race condition Leak memory Overflow integers (with the built-in operators such as + etc.) Abort the program Delete the production database For more detailed information, you may refer to the reference. However any program that actually manages to do such a thing is probably\\nincorrect. Rust provides lots of tools to make these things rare, but\\nthese problems are considered impractical to categorically prevent.","breadcrumbs":"Meet Safe and Unsafe » What Unsafe Can Do » What Unsafe Rust Can Do","id":"4","title":"What Unsafe Rust Can Do"},"40":{"body":"In the past, there used to be another thing to take into consideration. This very documentation used to say: Another important example is Vec, which is (approximately) defined as follows: #![allow(unused)] fn main() {\\nstruct Vec<T> { data: *const T, // *const for variance! len: usize, cap: usize,\\n} } Unlike the previous example, it appears that everything is exactly as we\\nwant. Every generic argument to Vec shows up in at least one field.\\nGood to go! Nope. The drop checker will generously determine that Vec<T> does not own any values\\nof type T. This will in turn make it conclude that it doesn’t need to worry\\nabout Vec dropping any T’s in its destructor for determining drop check\\nsoundness. This will in turn allow people to create unsoundness using\\nVec’s destructor. In order to tell the drop checker that we do own values of type T, and\\ntherefore may drop some T’s when we drop, we must add an extra PhantomData\\nsaying exactly that: #![allow(unused)] fn main() {\\nuse std::marker; struct Vec<T> { data: *const T, // *const for variance! len: usize, cap: usize, _owns_T: marker::PhantomData<T>,\\n} } But ever since RFC 1238, this is no longer true nor necessary. If you were to write: #![allow(unused)] fn main() {\\nstruct Vec<T> { data: *const T, // `*const` for variance! len: usize, cap: usize,\\n} #[cfg(any())]\\nimpl<T> Drop for Vec<T> { /* … */ } } then the existence of that impl<T> Drop for Vec<T> makes it so Rust will consider\\nthat that Vec<T> owns values of type T (more precisely: may use values of type T\\nin its Drop implementation), and Rust will thus not allow them to dangle should a Vec<T> be dropped. When a type already has a Drop impl, adding an extra _owns_T: PhantomData<T> field\\nis thus superfluous and accomplishes nothing, dropck-wise (it still affects variance\\nand auto-traits). (advanced edge case: if the type containing the PhantomData has no Drop impl at all,\\nbut still has drop glue (by having another field with drop glue), then the\\ndropck/ #[may_dangle] considerations mentioned herein do apply as well: a PhantomData<T>\\nfield will then require T to be droppable whenever the containing type goes out of scope). But this situation can sometimes lead to overly restrictive code. That’s why the\\nstandard library uses an unstable and unsafe attribute to opt back into the old\\n“unchecked” drop-checking behavior, that this very documentation warned about: the #[may_dangle] attribute.","breadcrumbs":"Ownership » PhantomData » Generic parameters and drop-checking","id":"40","title":"Generic parameters and drop-checking"},"41":{"body":"This section can be skipped if you are only writing your own library code; but if you are\\ncurious about what the standard library does with the actual Vec definition, you’ll notice\\nthat it still needs to use a _owns_T: PhantomData<T> field for soundness. Click here to see why Consider the following example: fn main() { let mut v: Vec<&str> = Vec::new(); let s: String = \\"Short-lived\\".into(); v.push(&s); drop(s);\\n} // <- `v` is dropped here with a classical impl<T> Drop for Vec<T> { definition, the above is denied. Indeed, in this case we have a Vec</* T = */ &\'s str> vector of \'s-lived references\\nto strings, but in the case of let s: String, it is dropped before the Vec is, and\\nthus \'s is expired by the time the Vec is dropped, and the impl<\'s> Drop for Vec<&\'s str> { is used. This means that if such Drop were to be used, it would be dealing with an expired, or dangling lifetime \'s. But this is contrary to Rust principles, where by default all\\nRust references involved in a function signature are non-dangling and valid to dereference. Hence why Rust has to conservatively deny this snippet. And yet, in the case of the real Vec, the Drop impl does not care about &\'s str, since it has no drop glue of its own: it only wants to deallocate the backing buffer. In other words, it would be nice if the above snippet was somehow accepted, by special\\ncasing Vec, or by relying on some special property of Vec: Vec could try to promise not to use the &\'s strs it holds when being dropped. This is the kind of unsafe promise that can be expressed with #[may_dangle]: unsafe impl<#[may_dangle] \'s> Drop for Vec<&\'s str> { /* … */ } or, more generally: unsafe impl<#[may_dangle] T> Drop for Vec<T> { /* … */ } is the unsafe way to opt out of this conservative assumption that Rust’s drop\\nchecker makes about type parameters of a dropped instance not being allowed to dangle. And when this is done, such as in the standard library, we need to be careful in the\\ncase where T has drop glue of its own. In this instance, imagine replacing the &\'s strs with a struct PrintOnDrop<\'s> /* = */ (&\'s str); which would have a Drop impl wherein the inner &\'s str would be dereferenced and printed to the screen. Indeed, Drop for Vec<T> {, before deallocating the backing buffer, does have to transitively\\ndrop each T item when it has drop glue; in the case of PrintOnDrop<\'s>, it means that Drop for Vec<PrintOnDrop<\'s>> has to transitively drop the PrintOnDrop<\'s>s elements before\\ndeallocating the backing buffer. So when we said that \'s #[may_dangle], it was an excessively loose statement. We’d rather want\\nto say: “ \'s may dangle provided it not be involved in some transitive drop glue”. Or, more generally,\\n“ T may dangle provided it not be involved in some transitive drop glue”. This “exception to the\\nexception” is a pervasive situation whenever we own a T. That’s why Rust’s #[may_dangle] is\\nsmart enough to know of this opt-out, and will thus be disabled when the generic parameter is held\\nin an owned fashion by the fields of the struct. Hence why the standard library ends up with: #![allow(unused)] fn main() { #[cfg(any())]\\n// we pinky-swear not to use `T` when dropping a `Vec`…\\nunsafe impl<#[may_dangle] T> Drop for Vec<T> { fn drop(&mut self) { unsafe { if mem::needs_drop::<T>() { /* … except here, that is, … */ ptr::drop_in_place::<[T]>(/* … */); } // … dealloc(/* … */) // … } }\\n} struct Vec<T> { // … except for the fact that a `Vec` owns `T` items and // may thus be dropping `T` items on drop! _owns_T: core::marker::PhantomData<T>, ptr: *const T, // `*const` for variance (but this does not express ownership of a `T` *per se*) len: usize, cap: usize,\\n} } Raw pointers that own an allocation is such a pervasive pattern that the\\nstandard library made a utility for itself called Unique<T> which: wraps a *const T for variance includes a PhantomData<T> auto-derives Send/ Sync as if T was contained marks the pointer as NonZero for the null-pointer optimization","breadcrumbs":"Ownership » PhantomData » An exception: the special case of the standard library and its unstable #[may_dangle]","id":"41","title":"An exception: the special case of the standard library and its unstable #[may_dangle]"},"42":{"body":"Here’s a table of all the wonderful ways PhantomData could be used: Phantom type variance of \'a variance of T Send/ Sync (or lack thereof) dangling \'a or T in drop glue ( e.g., #[may_dangle] Drop) PhantomData<T> - covariant inherited disallowed (“owns T”) PhantomData<&\'a T> covariant covariant Send + Sync requires T : Sync allowed PhantomData<&\'a mut T> covariant invariant inherited allowed PhantomData<*const T> - covariant !Send + !Sync allowed PhantomData<*mut T> - invariant !Send + !Sync allowed PhantomData<fn(T)> - contravariant Send + Sync allowed PhantomData<fn() -> T> - covariant Send + Sync allowed PhantomData<fn(T) -> T> - invariant Send + Sync allowed PhantomData<Cell<&\'a ()>> invariant - Send + !Sync allowed Note: opting out of the Unpin auto-trait requires the dedicated PhantomPinned type instead.","breadcrumbs":"Ownership » PhantomData » Table of PhantomData patterns","id":"42","title":"Table of PhantomData patterns"},"43":{"body":"The mutual exclusion property of mutable references can be very limiting when\\nworking with a composite structure. The borrow checker (a.k.a. borrowck)\\nunderstands some basic stuff, but will fall over pretty easily. It does\\nunderstand structs sufficiently to know that it’s possible to borrow disjoint\\nfields of a struct simultaneously. So this works today: #![allow(unused)] fn main() {\\nstruct Foo { a: i32, b: i32, c: i32,\\n} let mut x = Foo {a: 0, b: 0, c: 0};\\nlet a = &mut x.a;\\nlet b = &mut x.b;\\nlet c = &x.c;\\n*b += 1;\\nlet c2 = &x.c;\\n*a += 10;\\nprintln!(\\"{} {} {} {}\\", a, b, c, c2); } However borrowck doesn’t understand arrays or slices in any way, so this doesn’t\\nwork: #![allow(unused)] fn main() {\\nlet mut x = [1, 2, 3];\\nlet a = &mut x[0];\\nlet b = &mut x[1];\\nprintln!(\\"{} {}\\", a, b); } error[E0499]: cannot borrow `x[..]` as mutable more than once at a time --> src/lib.rs:4:18 |\\n3 | let a = &mut x[0]; | ---- first mutable borrow occurs here\\n4 | let b = &mut x[1]; | ^^^^ second mutable borrow occurs here\\n5 | println!(\\"{} {}\\", a, b);\\n6 | } | - first borrow ends here error: aborting due to previous error While it was plausible that borrowck could understand this simple case, it’s\\npretty clearly hopeless for borrowck to understand disjointness in general\\ncontainer types like a tree, especially if distinct keys actually do map\\nto the same value. In order to “teach” borrowck that what we’re doing is ok, we need to drop down\\nto unsafe code. For instance, mutable slices expose a split_at_mut function\\nthat consumes the slice and returns two mutable slices. One for everything to\\nthe left of the index, and one for everything to the right. Intuitively we know\\nthis is safe because the slices don’t overlap, and therefore alias. However\\nthe implementation requires some unsafety: #![allow(unused)] fn main() { use std::slice::from_raw_parts_mut; struct FakeSlice<T>(T); impl<T> FakeSlice<T> { fn len(&self) -> usize { unimplemented!() } fn as_mut_ptr(&mut self) -> *mut T { unimplemented!() }\\npub fn split_at_mut(&mut self, mid: usize) -> (&mut [T], &mut [T]) { let len = self.len(); let ptr = self.as_mut_ptr(); unsafe { assert!(mid <= len); (from_raw_parts_mut(ptr, mid), from_raw_parts_mut(ptr.add(mid), len - mid)) }\\n} } } This is actually a bit subtle. So as to avoid ever making two &mut’s to the\\nsame value, we explicitly construct brand-new slices through raw pointers. However more subtle is how iterators that yield mutable references work.\\nThe iterator trait is defined as follows: #![allow(unused)] fn main() {\\ntrait Iterator { type Item; fn next(&mut self) -> Option<Self::Item>;\\n} } Given this definition, Self::Item has no connection to self. This means that\\nwe can call next several times in a row, and hold onto all the results concurrently. This is perfectly fine for by-value iterators, which have\\nexactly these semantics. It’s also actually fine for shared references, as they\\nadmit arbitrarily many references to the same thing (although the iterator needs\\nto be a separate object from the thing being shared). But mutable references make this a mess. At first glance, they might seem\\ncompletely incompatible with this API, as it would produce multiple mutable\\nreferences to the same object! However it actually does work, exactly because iterators are one-shot objects.\\nEverything an IterMut yields will be yielded at most once, so we don’t\\nactually ever yield multiple mutable references to the same piece of data. Perhaps surprisingly, mutable iterators don’t require unsafe code to be\\nimplemented for many types! For instance here’s a singly linked list: fn main() {}\\ntype Link<T> = Option<Box<Node<T>>>; struct Node<T> { elem: T, next: Link<T>,\\n} pub struct LinkedList<T> { head: Link<T>,\\n} pub struct IterMut<\'a, T: \'a>(Option<&\'a mut Node<T>>); impl<T> LinkedList<T> { fn iter_mut(&mut self) -> IterMut<T> { IterMut(self.head.as_mut().map(|node| &mut **node)) }\\n} impl<\'a, T> Iterator for IterMut<\'a, T> { type Item = &\'a mut T; fn next(&mut self) -> Option<Self::Item> { self.0.take().map(|node| { self.0 = node.next.as_mut().map(|node| &mut **node); &mut node.elem }) }\\n} Here’s a mutable slice: fn main() {}\\nuse std::mem; pub struct IterMut<\'a, T: \'a>(&\'a mut[T]); impl<\'a, T> Iterator for IterMut<\'a, T> { type Item = &\'a mut T; fn next(&mut self) -> Option<Self::Item> { let slice = mem::take(&mut self.0); if slice.is_empty() { return None; } let (l, r) = slice.split_at_mut(1); self.0 = r; l.get_mut(0) }\\n} impl<\'a, T> DoubleEndedIterator for IterMut<\'a, T> { fn next_back(&mut self) -> Option<Self::Item> { let slice = mem::take(&mut self.0); if slice.is_empty() { return None; } let new_len = slice.len() - 1; let (l, r) = slice.split_at_mut(new_len); self.0 = l; r.get_mut(0) }\\n} And here’s a binary tree: fn main() {}\\nuse std::collections::VecDeque; type Link<T> = Option<Box<Node<T>>>; struct Node<T> { elem: T, left: Link<T>, right: Link<T>,\\n} pub struct Tree<T> { root: Link<T>,\\n} struct NodeIterMut<\'a, T: \'a> { elem: Option<&\'a mut T>, left: Option<&\'a mut Node<T>>, right: Option<&\'a mut Node<T>>,\\n} enum State<\'a, T: \'a> { Elem(&\'a mut T), Node(&\'a mut Node<T>),\\n} pub struct IterMut<\'a, T: \'a>(VecDeque<NodeIterMut<\'a, T>>); impl<T> Tree<T> { pub fn iter_mut(&mut self) -> IterMut<T> { let mut deque = VecDeque::new(); if let Some(root) = self.root.as_mut() { deque.push_front(root.iter_mut()); } IterMut(deque) }\\n} impl<T> Node<T> { pub fn iter_mut(&mut self) -> NodeIterMut<T> { NodeIterMut { elem: Some(&mut self.elem), left: self.left.as_deref_mut(), right: self.right.as_deref_mut(), } }\\n} impl<\'a, T> Iterator for NodeIterMut<\'a, T> { type Item = State<\'a, T>; fn next(&mut self) -> Option<Self::Item> { self.left.take().map(State::Node).or_else(|| { self.elem .take() .map(State::Elem) .or_else(|| self.right.take().map(State::Node)) }) }\\n} impl<\'a, T> DoubleEndedIterator for NodeIterMut<\'a, T> { fn next_back(&mut self) -> Option<Self::Item> { self.right.take().map(State::Node).or_else(|| { self.elem .take() .map(State::Elem) .or_else(|| self.left.take().map(State::Node)) }) }\\n} impl<\'a, T> Iterator for IterMut<\'a, T> { type Item = &\'a mut T; fn next(&mut self) -> Option<Self::Item> { loop { match self.0.front_mut().and_then(Iterator::next) { Some(State::Elem(elem)) => return Some(elem), Some(State::Node(node)) => self.0.push_front(node.iter_mut()), None => { self.0.pop_front()?; } } } }\\n} impl<\'a, T> DoubleEndedIterator for IterMut<\'a, T> { fn next_back(&mut self) -> Option<Self::Item> { loop { match self.0.back_mut().and_then(DoubleEndedIterator::next_back) { Some(State::Elem(elem)) => return Some(elem), Some(State::Node(node)) => self.0.push_back(node.iter_mut()), None => { self.0.pop_back()?; } } } }\\n} All of these are completely safe and work on stable Rust! This ultimately\\nfalls out of the simple struct case we saw before: Rust understands that you\\ncan safely split a mutable reference into subfields. We can then encode\\npermanently consuming a reference via Options (or in the case of slices,\\nreplacing with an empty slice).","breadcrumbs":"Ownership » Splitting Borrows » Splitting Borrows","id":"43","title":"Splitting Borrows"},"44":{"body":"At the end of the day, everything is just a pile of bits somewhere, and type\\nsystems are just there to help us use those bits right. There are two common\\nproblems with typing bits: needing to reinterpret those exact bits as a\\ndifferent type, and needing to change the bits to have equivalent meaning for\\na different type. Because Rust encourages encoding important properties in the\\ntype system, these problems are incredibly pervasive. As such, Rust\\nconsequently gives you several ways to solve them. First we’ll look at the ways that Safe Rust gives you to reinterpret values.\\nThe most trivial way to do this is to just destructure a value into its\\nconstituent parts and then build a new type out of them. e.g. #![allow(unused)] fn main() {\\nstruct Foo { x: u32, y: u16,\\n} struct Bar { a: u32, b: u16,\\n} fn reinterpret(foo: Foo) -> Bar { let Foo { x, y } = foo; Bar { a: x, b: y }\\n} } But this is, at best, annoying. For common conversions, Rust provides\\nmore ergonomic alternatives.","breadcrumbs":"Type Conversions » Type Conversions","id":"44","title":"Type Conversions"},"45":{"body":"Types can implicitly be coerced to change in certain contexts.\\nThese changes are generally just weakening of types, largely focused around pointers and lifetimes.\\nThey mostly exist to make Rust “just work” in more cases, and are largely harmless. For an exhaustive list of all the types of coercions, see the Coercion types section on the reference. Note that we do not perform coercions when matching traits (except for receivers, see the next page).\\nIf there is an impl for some type U and T coerces to U, that does not constitute an implementation for T.\\nFor example, the following will not type check, even though it is OK to coerce t to &T and there is an impl for &T: trait Trait {} fn foo<X: Trait>(t: X) {} impl<\'a> Trait for &\'a i32 {} fn main() { let t: &mut i32 = &mut 0; foo(t);\\n} which fails like as follows: error[E0277]: the trait bound `&mut i32: Trait` is not satisfied --> src/main.rs:9:9 |\\n3 | fn foo<X: Trait>(t: X) {} | ----- required by this bound in `foo`\\n...\\n9 | foo(t); | ^ the trait `Trait` is not implemented for `&mut i32` | = help: the following implementations were found: <&\'a i32 as Trait> = note: `Trait` is implemented for `&i32`, but not for `&mut i32`","breadcrumbs":"Type Conversions » Coercions » Coercions","id":"45","title":"Coercions"},"46":{"body":"The dot operator will perform a lot of magic to convert types.\\nIt will perform auto-referencing, auto-dereferencing, and coercion until types\\nmatch.\\nThe detailed mechanics of method lookup are defined here,\\nbut here is a brief overview that outlines the main steps. Suppose we have a function foo that has a receiver (a self, &self or &mut self parameter).\\nIf we call value.foo(), the compiler needs to determine what type Self is before\\nit can call the correct implementation of the function.\\nFor this example, we will say that value has type T. We will use fully-qualified syntax to be more clear about exactly which\\ntype we are calling a function on. First, the compiler checks if it can call T::foo(value) directly.\\nThis is called a “by value” method call. If it can’t call this function (for example, if the function has the wrong type\\nor a trait isn’t implemented for Self), then the compiler tries to add in an\\nautomatic reference.\\nThis means that the compiler tries <&T>::foo(value) and <&mut T>::foo(value).\\nThis is called an “autoref” method call. If none of these candidates worked, it dereferences T and tries again.\\nThis uses the Deref trait - if T: Deref<Target = U> then it tries again with\\ntype U instead of T.\\nIf it can’t dereference T, it can also try unsizing T.\\nThis just means that if T has a size parameter known at compile time, it “forgets”\\nit for the purpose of resolving methods.\\nFor instance, this unsizing step can convert [i32; 2] into [i32] by “forgetting”\\nthe size of the array. Here is an example of the method lookup algorithm: let array: Rc<Box<[T; 3]>> = ...;\\nlet first_entry = array[0]; How does the compiler actually compute array[0] when the array is behind so\\nmany indirections?\\nFirst, array[0] is really just syntax sugar for the Index trait -\\nthe compiler will convert array[0] into array.index(0).\\nNow, the compiler checks to see if array implements Index, so that it can call\\nthe function. Then, the compiler checks if Rc<Box<[T; 3]>> implements Index, but it\\ndoes not, and neither do &Rc<Box<[T; 3]>> or &mut Rc<Box<[T; 3]>>.\\nSince none of these worked, the compiler dereferences the Rc<Box<[T; 3]>> into Box<[T; 3]> and tries again. Box<[T; 3]>, &Box<[T; 3]>, and &mut Box<[T; 3]> do not implement Index,\\nso it dereferences again. [T; 3] and its autorefs also do not implement Index.\\nIt can’t dereference [T; 3], so the compiler unsizes it, giving [T].\\nFinally, [T] implements Index, so it can now call the actual index function. Consider the following more complicated example of the dot operator at work: #![allow(unused)] fn main() {\\nfn do_stuff<T: Clone>(value: &T) { let cloned = value.clone();\\n} } What type is cloned?\\nFirst, the compiler checks if it can call by value.\\nThe type of value is &T, and so the clone function has signature fn clone(&T) -> T.\\nIt knows that T: Clone, so the compiler finds that cloned: T. What would happen if the T: Clone restriction was removed? It would not be able\\nto call by value, since there is no implementation of Clone for T.\\nSo the compiler tries to call by autoref.\\nIn this case, the function has the signature fn clone(&&T) -> &T since Self = &T.\\nThe compiler sees that &T: Clone, and then deduces that cloned: &T. Here is another example where the autoref behavior is used to create some subtle\\neffects: #![allow(unused)] fn main() { use std::sync::Arc; #[derive(Clone)]\\nstruct Container<T>(Arc<T>); fn clone_containers<T>(foo: &Container<i32>, bar: &Container<T>) { let foo_cloned = foo.clone(); let bar_cloned = bar.clone();\\n} } What types are foo_cloned and bar_cloned?\\nWe know that Container<i32>: Clone, so the compiler calls clone by value to give foo_cloned: Container<i32>.\\nHowever, bar_cloned actually has type &Container<T>.\\nSurely this doesn’t make sense - we added #[derive(Clone)] to Container, so it\\nmust implement Clone!\\nLooking closer, the code generated by the derive macro is (roughly): impl<T> Clone for Container<T> where T: Clone { fn clone(&self) -> Self { Self(Arc::clone(&self.0)) }\\n} The derived Clone implementation is only defined where T: Clone,\\nso there is no implementation for Container<T>: Clone for a generic T.\\nThe compiler then looks to see if &Container<T> implements Clone, which it does.\\nSo it deduces that clone is called by autoref, and so bar_cloned has type &Container<T>. We can fix this by implementing Clone manually without requiring T: Clone: impl<T> Clone for Container<T> { fn clone(&self) -> Self { Self(Arc::clone(&self.0)) }\\n} Now, the type checker deduces that bar_cloned: Container<T>.","breadcrumbs":"Type Conversions » The Dot Operator » The Dot Operator","id":"46","title":"The Dot Operator"},"47":{"body":"Casts are a superset of coercions: every coercion can be explicitly invoked via a cast.\\nHowever some conversions require a cast.\\nWhile coercions are pervasive and largely harmless, these “true casts” are rare and potentially dangerous.\\nAs such, casts must be explicitly invoked using the as keyword: expr as Type. You can find an exhaustive list of all the true casts and casting semantics on the reference.","breadcrumbs":"Type Conversions » Casts » Casts","id":"47","title":"Casts"},"48":{"body":"True casts generally revolve around raw pointers and the primitive numeric types.\\nEven though they’re dangerous, these casts are infallible at runtime.\\nIf a cast triggers some subtle corner case no indication will be given that this occurred.\\nThe cast will simply succeed.\\nThat said, casts must be valid at the type level, or else they will be prevented statically.\\nFor instance, 7u8 as bool will not compile. That said, casts aren’t unsafe because they generally can’t violate memory safety on their own.\\nFor instance, converting an integer to a raw pointer can very easily lead to terrible things.\\nHowever the act of creating the pointer itself is safe, because actually using a raw pointer is already marked as unsafe.","breadcrumbs":"Type Conversions » Casts » Safety of casting","id":"48","title":"Safety of casting"},"49":{"body":"","breadcrumbs":"Type Conversions » Casts » Some notes about casting","id":"49","title":"Some notes about casting"},"5":{"body":"Rust generally only gives us the tools to talk about Unsafe Rust in a scoped and\\nbinary manner. Unfortunately, reality is significantly more complicated than\\nthat. For instance, consider the following toy function: #![allow(unused)] fn main() {\\nfn index(idx: usize, arr: &[u8]) -> Option<u8> { if idx < arr.len() { unsafe { Some(*arr.get_unchecked(idx)) } } else { None }\\n} } This function is safe and correct. We check that the index is in bounds, and if\\nit is, index into the array in an unchecked manner. We say that such a correct\\nunsafely implemented function is sound, meaning that safe code cannot cause\\nUndefined Behavior through it (which, remember, is the single fundamental\\nproperty of Safe Rust). But even in such a trivial function, the scope of the unsafe block is\\nquestionable. Consider changing the < to a <=: #![allow(unused)] fn main() {\\nfn index(idx: usize, arr: &[u8]) -> Option<u8> { if idx <= arr.len() { unsafe { Some(*arr.get_unchecked(idx)) } } else { None }\\n} } This program is now unsound, Safe Rust can cause Undefined Behavior, and yet we only modified safe code. This is the fundamental problem of safety: it’s\\nnon-local. The soundness of our unsafe operations necessarily depends on the\\nstate established by otherwise “safe” operations. Safety is modular in the sense that opting into unsafety doesn’t require you\\nto consider arbitrary other kinds of badness. For instance, doing an unchecked\\nindex into a slice doesn’t mean you suddenly need to worry about the slice being\\nnull or containing uninitialized memory. Nothing fundamentally changes. However\\nsafety isn’t modular in the sense that programs are inherently stateful and\\nyour unsafe operations may depend on arbitrary other state. This non-locality gets much worse when we incorporate actual persistent state.\\nConsider a simple implementation of Vec: use std::ptr; // Note: This definition is naive. See the chapter on implementing Vec.\\npub struct Vec<T> { ptr: *mut T, len: usize, cap: usize,\\n} // Note this implementation does not correctly handle zero-sized types.\\n// See the chapter on implementing Vec.\\nimpl<T> Vec<T> { pub fn push(&mut self, elem: T) { if self.len == self.cap { // not important for this example self.reallocate(); } unsafe { ptr::write(self.ptr.add(self.len), elem); self.len += 1; } } fn reallocate(&mut self) { }\\n} fn main() {} This code is simple enough to reasonably audit and informally verify. Now consider\\nadding the following method: fn make_room(&mut self) { // grow the capacity self.cap += 1;\\n} This code is 100% Safe Rust but it is also completely unsound. Changing the\\ncapacity violates the invariants of Vec (that cap reflects the allocated space\\nin the Vec). This is not something the rest of Vec can guard against. It has\\nto trust the capacity field because there’s no way to verify it. Because it relies on invariants of a struct field, this unsafe code\\ndoes more than pollute a whole function: it pollutes a whole module.\\nGenerally, the only bullet-proof way to limit the scope of unsafe code is at the\\nmodule boundary with privacy. However this works perfectly. The existence of make_room is not a\\nproblem for the soundness of Vec because we didn’t mark it as public. Only the\\nmodule that defines this function can call it. Also, make_room directly\\naccesses the private fields of Vec, so it can only be written in the same module\\nas Vec. It is therefore possible for us to write a completely safe abstraction that\\nrelies on complex invariants. This is critical to the relationship between\\nSafe Rust and Unsafe Rust. We have already seen that Unsafe code must trust some Safe code, but shouldn’t\\ntrust generic Safe code. Privacy is important to unsafe code for similar reasons:\\nit prevents us from having to trust all the safe code in the universe from messing\\nwith our trusted state. Safety lives!","breadcrumbs":"Meet Safe and Unsafe » Working with Unsafe » Working with Unsafe","id":"5","title":"Working with Unsafe"},"50":{"body":"Note that lengths are not adjusted when casting raw slices; *const [u16] as *const [u8] creates a slice that only includes half of the original memory.","breadcrumbs":"Type Conversions » Casts » Lengths when casting raw slices","id":"50","title":"Lengths when casting raw slices"},"51":{"body":"Casting is not transitive, that is, even if e as U1 as U2 is a valid expression, e as U2 is not necessarily so.","breadcrumbs":"Type Conversions » Casts » Transitivity","id":"51","title":"Transitivity"},"52":{"body":"Get out of our way type system! We’re going to reinterpret these bits or die\\ntrying! Even though this book is all about doing things that are unsafe, I\\nreally can’t emphasize enough that you should deeply think about finding Another Way\\nthan the operations covered in this section. This is really, truly, the most\\nhorribly unsafe thing you can do in Rust. The guardrails here are dental floss. mem::transmute<T, U> takes a value of type T and reinterprets\\nit to have type U. The only restriction is that the T and U are verified\\nto have the same size. The ways to cause Undefined Behavior with this are mind\\nboggling. First and foremost, creating an instance of any type with an invalid state\\nis going to cause arbitrary chaos that can’t really be predicted. Do not\\ntransmute 3 to bool. Even if you never do anything with the bool. Just\\ndon’t. Transmute has an overloaded return type. If you do not specify the return type\\nit may produce a surprising type to satisfy inference. Transmuting an & to &mut is Undefined Behavior. While certain usages may appear safe, note that the Rust optimizer is free to assume that a shared\\nreference won’t change through its lifetime and thus such transmutation will\\nrun afoul of those assumptions. So: Transmuting an & to &mut is always Undefined Behavior. No you can’t do it. No you’re not special. Transmuting to a reference without an explicitly provided lifetime\\nproduces an unbounded lifetime. When transmuting between different compound types, you have to make sure they\\nare laid out the same way! If layouts differ, the wrong fields are going to\\nget filled with the wrong data, which will make you unhappy and can also be\\nUndefined Behavior (see above). So how do you know if the layouts are the same? For repr(C) types and repr(transparent) types, layout is precisely defined. But for your\\nrun-of-the-mill repr(Rust), it is not. Even different instances of the same\\ngeneric type can have wildly different layout. Vec<i32> and Vec<u32> might have their fields in the same order, or they might not. The details of\\nwhat exactly is and is not guaranteed for data layout are still being worked\\nout over at the UCG WG. mem::transmute_copy<T, U> somehow manages to be even more\\nwildly unsafe than this. It copies size_of<U> bytes out of an &T and\\ninterprets them as a U. The size check that mem::transmute has is gone (as\\nit may be valid to copy out a prefix), though it is Undefined Behavior for U\\nto be larger than T. Also of course you can get all of the functionality of these functions using raw\\npointer casts or unions, but without any of the lints or other basic sanity\\nchecks. Raw pointer casts and unions do not magically avoid the above rules.","breadcrumbs":"Type Conversions » Transmutes » Transmutes","id":"52","title":"Transmutes"},"53":{"body":"All runtime-allocated memory in a Rust program begins its life as uninitialized. In this state the value of the memory is an indeterminate pile\\nof bits that may or may not even reflect a valid state for the type that is\\nsupposed to inhabit that location of memory. Attempting to interpret this memory\\nas a value of any type will cause Undefined Behavior. Do Not Do This. Rust provides mechanisms to work with uninitialized memory in checked (safe) and\\nunchecked (unsafe) ways.","breadcrumbs":"Uninitialized Memory » Working With Uninitialized Memory","id":"53","title":"Working With Uninitialized Memory"},"54":{"body":"Like C, all stack variables in Rust are uninitialized until a value is\\nexplicitly assigned to them. Unlike C, Rust statically prevents you from ever\\nreading them until you do: fn main() { let x: i32; println!(\\"{}\\", x);\\n} |\\n3 | println!(\\"{}\\", x); | ^ use of possibly uninitialized `x` This is based off of a basic branch analysis: every branch must assign a value\\nto x before it is first used. For short, we also say that “ x is init” or\\n“ x is uninit”. Interestingly, Rust doesn’t require the variable\\nto be mutable to perform a delayed initialization if every branch assigns\\nexactly once. However the analysis does not take advantage of constant analysis\\nor anything like that. So this compiles: fn main() { let x: i32; if true { x = 1; } else { x = 2; } println!(\\"{}\\", x);\\n} but this doesn’t: fn main() { let x: i32; if true { x = 1; } println!(\\"{}\\", x);\\n} |\\n6 | println!(\\"{}\\", x); | ^ use of possibly uninitialized `x` while this does: fn main() { let x: i32; if true { x = 1; println!(\\"{}\\", x); } // Don\'t care that there are branches where it\'s not initialized // since we don\'t use the value in those branches\\n} Of course, while the analysis doesn’t consider actual values, it does\\nhave a relatively sophisticated understanding of dependencies and control\\nflow. For instance, this works: #![allow(unused)] fn main() {\\nlet x: i32; loop { // Rust doesn\'t understand that this branch will be taken unconditionally, // because it relies on actual values. if true { // But it does understand that it will only be taken once because // we unconditionally break out of it. Therefore `x` doesn\'t // need to be marked as mutable. x = 0; break; }\\n}\\n// It also knows that it\'s impossible to get here without reaching the break.\\n// And therefore that `x` must be initialized here!\\nprintln!(\\"{}\\", x); } If a value is moved out of a variable, that variable becomes logically\\nuninitialized if the type of the value isn’t Copy. That is: fn main() { let x = 0; let y = Box::new(0); let z1 = x; // x is still valid because i32 is Copy let z2 = y; // y is now logically uninitialized because Box isn\'t Copy\\n} However reassigning y in this example would require y to be marked as\\nmutable, as a Safe Rust program could observe that the value of y changed: fn main() { let mut y = Box::new(0); let z = y; // y is now logically uninitialized because Box isn\'t Copy y = Box::new(1); // reinitialize y\\n} Otherwise it’s like y is a brand new variable.","breadcrumbs":"Uninitialized Memory » Checked » Checked Uninitialized Memory","id":"54","title":"Checked Uninitialized Memory"},"55":{"body":"The examples in the previous section introduce an interesting problem for Rust.\\nWe have seen that it’s possible to conditionally initialize, deinitialize, and\\nreinitialize locations of memory totally safely. For Copy types, this isn’t\\nparticularly notable since they’re just a random pile of bits. However types\\nwith destructors are a different story: Rust needs to know whether to call a\\ndestructor whenever a variable is assigned to, or a variable goes out of scope.\\nHow can it do this with conditional initialization? Note that this is not a problem that all assignments need worry about. In\\nparticular, assigning through a dereference unconditionally drops, and assigning\\nin a let unconditionally doesn’t drop: #![allow(unused)] fn main() {\\nlet mut x = Box::new(0); // let makes a fresh variable, so never need to drop\\nlet y = &mut x;\\n*y = Box::new(1); // Deref assumes the referent is initialized, so always drops } This is only a problem when overwriting a previously initialized variable or\\none of its subfields. It turns out that Rust actually tracks whether a type should be dropped or not at runtime. As a variable becomes initialized and uninitialized, a drop flag\\nfor that variable is toggled. When a variable might need to be dropped, this\\nflag is evaluated to determine if it should be dropped. Of course, it is often the case that a value’s initialization state can be\\nstatically known at every point in the program. If this is the case, then the\\ncompiler can theoretically generate more efficient code! For instance, straight-\\nline code has such static drop semantics: #![allow(unused)] fn main() {\\nlet mut x = Box::new(0); // x was uninit; just overwrite.\\nlet mut y = x; // y was uninit; just overwrite and make x uninit.\\nx = Box::new(0); // x was uninit; just overwrite.\\ny = x; // y was init; Drop y, overwrite it, and make x uninit! // y goes out of scope; y was init; Drop y! // x goes out of scope; x was uninit; do nothing. } Similarly, branched code where all branches have the same behavior with respect\\nto initialization has static drop semantics: #![allow(unused)] fn main() { let condition = true;\\nlet mut x = Box::new(0); // x was uninit; just overwrite.\\nif condition { drop(x) // x gets moved out; make x uninit.\\n} else { println!(\\"{}\\", x); drop(x) // x gets moved out; make x uninit.\\n}\\nx = Box::new(0); // x was uninit; just overwrite. // x goes out of scope; x was init; Drop x! } However code like this requires runtime information to correctly Drop: #![allow(unused)] fn main() { let condition = true;\\nlet x;\\nif condition { x = Box::new(0); // x was uninit; just overwrite. println!(\\"{}\\", x);\\n} // x goes out of scope; x might be uninit; // check the flag! } Of course, in this case it’s trivial to retrieve static drop semantics: #![allow(unused)] fn main() { let condition = true;\\nif condition { let x = Box::new(0); println!(\\"{}\\", x);\\n} } The drop flags are tracked on the stack.\\nIn old Rust versions, drop flags were stashed in a hidden field of types that implement Drop.","breadcrumbs":"Uninitialized Memory » Drop Flags » Drop Flags","id":"55","title":"Drop Flags"},"56":{"body":"One interesting exception to this rule is working with arrays. Safe Rust doesn’t\\npermit you to partially initialize an array. When you initialize an array, you\\ncan either set every value to the same thing with let x = [val; N], or you can\\nspecify each member individually with let x = [val1, val2, val3].\\nUnfortunately this is pretty rigid, especially if you need to initialize your\\narray in a more incremental or dynamic way. Unsafe Rust gives us a powerful tool to handle this problem: MaybeUninit. This type can be used to handle memory that has not been fully\\ninitialized yet. With MaybeUninit, we can initialize an array element by element as follows: #![allow(unused)] fn main() {\\nuse std::mem::{self, MaybeUninit}; // Size of the array is hard-coded but easy to change (meaning, changing just\\n// the constant is sufficient). This means we can\'t use [a, b, c] syntax to\\n// initialize the array, though, as we would have to keep that in sync\\n// with `SIZE`!\\nconst SIZE: usize = 10; let x = { // Create an uninitialized array of `MaybeUninit`. let mut x = [const { MaybeUninit::uninit() }; SIZE]; // Dropping a `MaybeUninit` does nothing. Thus using raw pointer // assignment instead of `ptr::write` does not cause the old // uninitialized value to be dropped. // Exception safety is not a concern because Box can\'t panic for i in 0..SIZE { x[i] = MaybeUninit::new(Box::new(i as u32)); } // Everything is initialized. Transmute the array to the // initialized type. unsafe { mem::transmute::<_, [Box<u32>; SIZE]>(x) }\\n}; println!(\\"{x:?}\\"); } This code proceeds in three steps: Create an array of MaybeUninit<T>. Initialize the array. The subtle aspect of this is that usually, when we use = to assign to a value that the Rust type checker considers to already be\\ninitialized (like x[i]), the old value stored on the left-hand side gets\\ndropped. This would be a disaster. However, in this case, the type of the\\nleft-hand side is MaybeUninit<Box<u32>>, and dropping that does not do\\nanything! See below for some more discussion of this drop issue. Finally, we have to change the type of our array to remove the MaybeUninit. With current stable Rust, this requires a transmute.\\nThis transmute is legal because in memory, MaybeUninit<T> looks the same as T. However, note that in general, Container<MaybeUninit<T>>> does not look\\nthe same as Container<T>! Imagine if Container was Option, and T was bool, then Option<bool> exploits that bool only has two valid values,\\nbut Option<MaybeUninit<bool>> cannot do that because the bool does not\\nhave to be initialized. So, it depends on Container whether transmuting away the MaybeUninit is\\nallowed. For arrays, it is (and eventually the standard library will\\nacknowledge that by providing appropriate methods). It’s worth spending a bit more time on the loop in the middle, and in particular\\nthe assignment operator and its interaction with drop. If we wrote something like: *x[i].as_mut_ptr() = Box::new(i as u32); // WRONG! we would actually overwrite a Box<u32>, leading to drop of uninitialized\\ndata, which would cause much sadness and pain. The correct alternative, if for some reason we cannot use MaybeUninit::new, is\\nto use the ptr module. In particular, it provides three functions that allow\\nus to assign bytes to a location in memory without dropping the old value: write, copy, and copy_nonoverlapping. ptr::write(ptr, val) takes a val and moves it into the address pointed\\nto by ptr. ptr::copy(src, dest, count) copies the bits that count T items would occupy\\nfrom src to dest. (this is equivalent to C’s memmove – note that the argument\\norder is reversed!) ptr::copy_nonoverlapping(src, dest, count) does what copy does, but a\\nlittle faster on the assumption that the two ranges of memory don’t overlap.\\n(this is equivalent to C’s memcpy – note that the argument order is reversed!) It should go without saying that these functions, if misused, will cause serious\\nhavoc or just straight up Undefined Behavior. The only requirement of these\\nfunctions themselves is that the locations you want to read and write\\nare allocated and properly aligned. However, the ways writing arbitrary bits to\\narbitrary locations of memory can break things are basically uncountable! It’s worth noting that you don’t need to worry about ptr::write-style\\nshenanigans with types which don’t implement Drop or contain Drop types,\\nbecause Rust knows not to try to drop them. This is what we relied on in the\\nabove example. However when working with uninitialized memory you need to be ever-vigilant for\\nRust trying to drop values you make like this before they’re fully initialized.\\nEvery control path through that variable’s scope must initialize the value\\nbefore it ends, if it has a destructor. This includes code panicking. MaybeUninit helps a bit\\nhere, because it does not implicitly drop its content - but all this really\\nmeans in case of a panic is that instead of a double-free of the not yet\\ninitialized parts, you end up with a memory leak of the already initialized\\nparts. Note that, to use the ptr methods, you need to first obtain a raw pointer to\\nthe data you want to initialize. It is illegal to construct a reference to\\nuninitialized data, which implies that you have to be careful when obtaining\\nsaid raw pointer: For an array of T, you can use base_ptr.add(idx) where base_ptr: *mut T\\nto compute the address of array index idx. This relies on\\nhow arrays are laid out in memory. For a struct, however, in general we do not know how it is laid out, and we\\nalso cannot use &mut base_ptr.field as that would be creating a\\nreference. So, you must carefully use the raw reference syntax. This creates\\na raw pointer to the field without creating an intermediate reference: #![allow(unused)] fn main() {\\nuse std::{ptr, mem::MaybeUninit}; struct Demo { field: bool,\\n} let mut uninit = MaybeUninit::<Demo>::uninit();\\n// `&uninit.as_mut().field` would create a reference to an uninitialized `bool`,\\n// and thus be Undefined Behavior!\\nlet f1_ptr = unsafe { &raw mut (*uninit.as_mut_ptr()).field };\\nunsafe { f1_ptr.write(true); } let init = unsafe { uninit.assume_init() }; } One last remark: when reading old Rust code, you might stumble upon the\\ndeprecated mem::uninitialized function. That function used to be the only way\\nto deal with uninitialized memory on the stack, but it turned out to be\\nimpossible to properly integrate with the rest of the language. Always use MaybeUninit instead in new code, and port old code over when you get the\\nopportunity. And that’s about it for working with uninitialized memory! Basically nothing\\nanywhere expects to be handed uninitialized memory, so if you’re going to pass\\nit around at all, be sure to be really careful.","breadcrumbs":"Uninitialized Memory » Unchecked » Unchecked Uninitialized Memory","id":"56","title":"Unchecked Uninitialized Memory"},"57":{"body":"OBRM (AKA RAII: Resource Acquisition Is Initialization) is something you’ll\\ninteract with a lot in Rust. Especially if you use the standard library. Roughly speaking the pattern is as follows: to acquire a resource, you create an\\nobject that manages it. To release the resource, you simply destroy the object,\\nand it cleans up the resource for you. The most common “resource” this pattern\\nmanages is simply memory. Box, Rc, and basically everything in std::collections is a convenience to enable correctly managing memory. This is\\nparticularly important in Rust because we have no pervasive GC to rely on for\\nmemory management. Which is the point, really: Rust is about control. However we\\nare not limited to just memory. Pretty much every other system resource like a\\nthread, file, or socket is exposed through this kind of API.","breadcrumbs":"Ownership Based Resource Management » The Perils Of Ownership Based Resource Management (OBRM)","id":"57","title":"The Perils Of Ownership Based Resource Management (OBRM)"},"58":{"body":"There is exactly one way to create an instance of a user-defined type: name it,\\nand initialize all its fields at once: #![allow(unused)] fn main() {\\nstruct Foo { a: u8, b: u32, c: bool,\\n} enum Bar { X(u32), Y(bool),\\n} struct Unit; let foo = Foo { a: 0, b: 1, c: false };\\nlet bar = Bar::X(0);\\nlet empty = Unit; } That’s it. Every other way you make an instance of a type is just calling a\\ntotally vanilla function that does some stuff and eventually bottoms out to The\\nOne True Constructor. Unlike C++, Rust does not come with a slew of built-in kinds of constructor.\\nThere are no Copy, Default, Assignment, Move, or whatever constructors. The\\nreasons for this are varied, but it largely boils down to Rust’s philosophy of being explicit. Move constructors are meaningless in Rust because we don’t enable types to\\n“care” about their location in memory. Every type must be ready for it to be\\nblindly memcopied to somewhere else in memory. This means pure on-the-stack-but-\\nstill-movable intrusive linked lists are simply not happening in Rust (safely). Assignment and copy constructors similarly don’t exist because move semantics\\nare the only semantics in Rust. At most x = y just moves the bits of y into\\nthe x variable. Rust does provide two facilities for providing C++’s copy-\\noriented semantics: Copy and Clone. Clone is our moral equivalent of a copy\\nconstructor, but it’s never implicitly invoked. You have to explicitly call clone on an element you want to be cloned. Copy is a special case of Clone\\nwhere the implementation is just “copy the bits”. Copy types are implicitly\\ncloned whenever they’re moved, but because of the definition of Copy this just\\nmeans not treating the old copy as uninitialized – a no-op. While Rust provides a Default trait for specifying the moral equivalent of a\\ndefault constructor, it’s incredibly rare for this trait to be used. This is\\nbecause variables aren’t implicitly initialized. Default is basically\\nonly useful for generic programming. In concrete contexts, a type will provide a\\nstatic new method for any kind of “default” constructor. This has no relation\\nto new in other languages and has no special meaning. It’s just a naming\\nconvention. TODO: talk about “placement new”?","breadcrumbs":"Ownership Based Resource Management » Constructors » Constructors","id":"58","title":"Constructors"},"59":{"body":"What the language does provide is full-blown automatic destructors through the Drop trait, which provides the following method: fn drop(&mut self); This method gives the type time to somehow finish what it was doing. After drop is run, Rust will recursively try to drop all of the fields\\nof self. This is a convenience feature so that you don’t have to write “destructor\\nboilerplate” to drop children. If a struct has no special logic for being\\ndropped other than dropping its children, then it means Drop doesn’t need to\\nbe implemented at all! There is no stable way to prevent this behavior in Rust 1.0. Note that taking &mut self means that even if you could suppress recursive\\nDrop, Rust will prevent you from e.g. moving fields out of self. For most types,\\nthis is totally fine. For instance, a custom implementation of Box might write Drop like this: #![feature(ptr_internals, allocator_api)] use std::alloc::{Allocator, Global, GlobalAlloc, Layout};\\nuse std::mem;\\nuse std::ptr::{drop_in_place, NonNull, Unique}; struct Box<T>{ ptr: Unique<T> } impl<T> Drop for Box<T> { fn drop(&mut self) { unsafe { drop_in_place(self.ptr.as_ptr()); let c: NonNull<T> = self.ptr.into(); Global.deallocate(c.cast(), Layout::new::<T>()) } }\\n} fn main() {} and this works fine because when Rust goes to drop the ptr field it just sees\\na Unique that has no actual Drop implementation. Similarly nothing can\\nuse-after-free the ptr because when drop exits, it becomes inaccessible. However this wouldn’t work: #![feature(allocator_api, ptr_internals)] use std::alloc::{Allocator, Global, GlobalAlloc, Layout};\\nuse std::ptr::{drop_in_place, Unique, NonNull};\\nuse std::mem; struct Box<T>{ ptr: Unique<T> } impl<T> Drop for Box<T> { fn drop(&mut self) { unsafe { drop_in_place(self.ptr.as_ptr()); let c: NonNull<T> = self.ptr.into(); Global.deallocate(c.cast(), Layout::new::<T>()); } }\\n} struct SuperBox<T> { my_box: Box<T> } impl<T> Drop for SuperBox<T> { fn drop(&mut self) { unsafe { // Hyper-optimized: deallocate the box\'s contents for it // without `drop`ing the contents let c: NonNull<T> = self.my_box.ptr.into(); Global.deallocate(c.cast::<u8>(), Layout::new::<T>()); } }\\n} fn main() {} After we deallocate the box’s ptr in SuperBox’s destructor, Rust will\\nhappily proceed to tell the box to Drop itself and everything will blow up with\\nuse-after-frees and double-frees. Note that the recursive drop behavior applies to all structs and enums\\nregardless of whether they implement Drop. Therefore something like #![allow(unused)] fn main() {\\nstruct Boxy<T> { data1: Box<T>, data2: Box<T>, info: u32,\\n} } will have the destructors of its data1 and data2 fields called whenever it “would” be\\ndropped, even though it itself doesn’t implement Drop. We say that such a type needs Drop, even though it is not itself Drop. Similarly, #![allow(unused)] fn main() {\\nenum Link { Next(Box<Link>), None,\\n} } will have its inner Box field dropped if and only if an instance stores the\\nNext variant. In general this works really nicely because you don’t need to worry about\\nadding/removing drops when you refactor your data layout. Still there’s\\ncertainly many valid use cases for needing to do trickier things with\\ndestructors. The classic safe solution to overriding recursive drop and allowing moving out\\nof Self during drop is to use an Option: #![feature(allocator_api, ptr_internals)] use std::alloc::{Allocator, GlobalAlloc, Global, Layout};\\nuse std::ptr::{drop_in_place, Unique, NonNull};\\nuse std::mem; struct Box<T>{ ptr: Unique<T> } impl<T> Drop for Box<T> { fn drop(&mut self) { unsafe { drop_in_place(self.ptr.as_ptr()); let c: NonNull<T> = self.ptr.into(); Global.deallocate(c.cast(), Layout::new::<T>()); } }\\n} struct SuperBox<T> { my_box: Option<Box<T>> } impl<T> Drop for SuperBox<T> { fn drop(&mut self) { unsafe { // Hyper-optimized: deallocate the box\'s contents for it // without `drop`ing the contents. Need to set the `box` // field as `None` to prevent Rust from trying to Drop it. let my_box = self.my_box.take().unwrap(); let c: NonNull<T> = my_box.ptr.into(); Global.deallocate(c.cast(), Layout::new::<T>()); mem::forget(my_box); } }\\n} fn main() {} However this has fairly odd semantics: you are saying that a field that should\\nalways be Some may be None, just because of what happens in the destructor. Of\\ncourse this conversely makes a lot of sense: you can call arbitrary methods on\\nself during the destructor, and this should prevent you from ever doing so after\\ndeinitializing the field. Not that it will prevent you from producing any other\\narbitrarily invalid state in there. On balance this is an ok choice. Certainly what you should reach for by default.\\nHowever, in the future we expect there to be a first-class way to announce that\\na field shouldn’t be automatically dropped.","breadcrumbs":"Ownership Based Resource Management » Destructors » Destructors","id":"59","title":"Destructors"},"6":{"body":"Low-level programming cares a lot about data layout. It’s a big deal. It also\\npervasively influences the rest of the language, so we’re going to start by\\ndigging into how data is represented in Rust. This chapter is ideally in agreement with, and rendered redundant by,\\nthe Type Layout section of the Reference. When this\\nbook was first written, the reference was in complete disrepair, and the\\nRustonomicon was attempting to serve as a partial replacement for the reference.\\nThis is no longer the case, so this whole chapter can ideally be deleted. We’ll keep this chapter around for a bit longer, but ideally you should be\\ncontributing any new facts or improvements to the Reference instead.","breadcrumbs":"Data Layout » Data Representation in Rust","id":"6","title":"Data Representation in Rust"},"60":{"body":"Ownership-based resource management is intended to simplify composition. You\\nacquire resources when you create the object, and you release the resources when\\nit gets destroyed. Since destruction is handled for you, it means you can’t\\nforget to release the resources, and it happens as soon as possible! Surely this\\nis perfect and all of our problems are solved. Everything is terrible and we have new and exotic problems to try to solve. Many people like to believe that Rust eliminates resource leaks. In practice,\\nthis is basically true. You would be surprised to see a Safe Rust program\\nleak resources in an uncontrolled way. However from a theoretical perspective this is absolutely not the case, no\\nmatter how you look at it. In the strictest sense, “leaking” is so abstract as\\nto be unpreventable. It’s quite trivial to initialize a collection at the start\\nof a program, fill it with tons of objects with destructors, and then enter an\\ninfinite event loop that never refers to it. The collection will sit around\\nuselessly, holding on to its precious resources until the program terminates (at\\nwhich point all those resources would have been reclaimed by the OS anyway). We may consider a more restricted form of leak: failing to drop a value that is\\nunreachable. Rust also doesn’t prevent this. In fact Rust has a function for\\ndoing this: mem::forget. This function consumes the value it is passed and\\nthen doesn’t run its destructor. In the past mem::forget was marked as unsafe as a sort of lint against using\\nit, since failing to call a destructor is generally not a well-behaved thing to\\ndo (though useful for some special unsafe code). However this was generally\\ndetermined to be an untenable stance to take: there are many ways to fail to\\ncall a destructor in safe code. The most famous example is creating a cycle of\\nreference-counted pointers using interior mutability. It is reasonable for safe code to assume that destructor leaks do not happen, as\\nany program that leaks destructors is probably wrong. However unsafe code\\ncannot rely on destructors to be run in order to be safe. For most types this\\ndoesn’t matter: if you leak the destructor then the type is by definition\\ninaccessible, so it doesn’t matter, right? For instance, if you leak a Box<u8>\\nthen you waste some memory but that’s hardly going to violate memory-safety. However where we must be careful with destructor leaks are proxy types. These\\nare types which manage access to a distinct object, but don’t actually own it.\\nProxy objects are quite rare. Proxy objects you’ll need to care about are even\\nrarer. However we’ll focus on three interesting examples in the standard\\nlibrary: vec::Drain Rc thread::scoped::JoinGuard","breadcrumbs":"Ownership Based Resource Management » Leaking » Leaking","id":"60","title":"Leaking"},"61":{"body":"drain is a collections API that moves data out of the container without\\nconsuming the container. This enables us to reuse the allocation of a Vec\\nafter claiming ownership over all of its contents. It produces an iterator\\n(Drain) that returns the contents of the Vec by-value. Now, consider Drain in the middle of iteration: some values have been moved out,\\nand others haven’t. This means that part of the Vec is now full of logically\\nuninitialized data! We could backshift all the elements in the Vec every time we\\nremove a value, but this would have pretty catastrophic performance\\nconsequences. Instead, we would like Drain to fix the Vec’s backing storage when it is\\ndropped. It should run itself to completion, backshift any elements that weren’t\\nremoved (drain supports subranges), and then fix Vec’s len. It’s even\\nunwinding-safe! Easy! Now consider the following: let mut vec = vec![Box::new(0); 4]; { // start draining, vec can no longer be accessed let mut drainer = vec.drain(..); // pull out two elements and immediately drop them drainer.next(); drainer.next(); // get rid of drainer, but don\'t call its destructor mem::forget(drainer);\\n} // Oops, vec[0] was dropped, we\'re reading a pointer into free\'d memory!\\nprintln!(\\"{}\\", vec[0]); This is pretty clearly Not Good. Unfortunately, we’re kind of stuck between a\\nrock and a hard place: maintaining consistent state at every step has an\\nenormous cost (and would negate any benefits of the API). Failing to maintain\\nconsistent state gives us Undefined Behavior in safe code (making the API\\nunsound). So what can we do? Well, we can pick a trivially consistent state: set the Vec’s\\nlen to be 0 when we start the iteration, and fix it up if necessary in the\\ndestructor. That way, if everything executes like normal we get the desired\\nbehavior with minimal overhead. But if someone has the audacity to\\nmem::forget us in the middle of the iteration, all that does is leak even more\\n(and possibly leave the Vec in an unexpected but otherwise consistent state).\\nSince we’ve accepted that mem::forget is safe, this is definitely safe. We call\\nleaks causing more leaks a leak amplification.","breadcrumbs":"Ownership Based Resource Management » Leaking » Drain","id":"61","title":"Drain"},"62":{"body":"Rc is an interesting case because at first glance it doesn’t appear to be a\\nproxy value at all. After all, it manages the data it points to, and dropping\\nall the Rcs for a value will drop that value. Leaking an Rc doesn’t seem like it\\nwould be particularly dangerous. It will leave the refcount permanently\\nincremented and prevent the data from being freed or dropped, but that seems\\njust like Box, right? Nope. Let’s consider a simplified implementation of Rc: struct Rc<T> { ptr: *mut RcBox<T>,\\n} struct RcBox<T> { data: T, ref_count: usize,\\n} impl<T> Rc<T> { fn new(data: T) -> Self { unsafe { // Wouldn\'t it be nice if heap::allocate worked like this? let ptr = heap::allocate::<RcBox<T>>(); ptr::write(ptr, RcBox { data, ref_count: 1, }); Rc { ptr } } } fn clone(&self) -> Self { unsafe { (*self.ptr).ref_count += 1; } Rc { ptr: self.ptr } }\\n} impl<T> Drop for Rc<T> { fn drop(&mut self) { unsafe { (*self.ptr).ref_count -= 1; if (*self.ptr).ref_count == 0 { // drop the data and then free it ptr::read(self.ptr); heap::deallocate(self.ptr); } } }\\n} This code contains an implicit and subtle assumption: ref_count can fit in a usize, because there can’t be more than usize::MAX Rcs in memory. However\\nthis itself assumes that the ref_count accurately reflects the number of Rcs\\nin memory, which we know is false with mem::forget. Using mem::forget we can\\noverflow the ref_count, and then get it down to 0 with outstanding Rcs. Then\\nwe can happily use-after-free the inner data. Bad Bad Not Good. This can be solved by just checking the ref_count and doing something. The\\nstandard library’s stance is to just abort, because your program has become\\nhorribly degenerate. Also oh my gosh it’s such a ridiculous corner case.","breadcrumbs":"Ownership Based Resource Management » Leaking » Rc","id":"62","title":"Rc"},"63":{"body":"Note: This API has already been removed from std, for more information\\nyou may refer issue #24292. This section remains here because we think this example is still\\nimportant, regardless of whether it is part of std or not. The thread::scoped API intended to allow threads to be spawned that reference\\ndata on their parent’s stack without any synchronization over that data by\\nensuring the parent joins the thread before any of the shared data goes out\\nof scope. pub fn scoped<\'a, F>(f: F) -> JoinGuard<\'a> where F: FnOnce() + Send + \'a Here f is some closure for the other thread to execute. Saying that F: Send + \'a is saying that it closes over data that lives for \'a, and it\\neither owns that data or the data was Sync (implying &data is Send). Because JoinGuard has a lifetime, it keeps all the data it closes over\\nborrowed in the parent thread. This means the JoinGuard can’t outlive\\nthe data that the other thread is working on. When the JoinGuard does get\\ndropped it blocks the parent thread, ensuring the child terminates before any\\nof the closed-over data goes out of scope in the parent. Usage looked like: let mut data = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10];\\n{ let mut guards = vec![]; for x in &mut data { // Move the mutable reference into the closure, and execute // it on a different thread. The closure has a lifetime bound // by the lifetime of the mutable reference `x` we store in it. // The guard that is returned is in turn assigned the lifetime // of the closure, so it also mutably borrows `data` as `x` did. // This means we cannot access `data` until the guard goes away. let guard = thread::scoped(move || { *x *= 2; }); // store the thread\'s guard for later guards.push(guard); } // All guards are dropped here, forcing the threads to join // (this thread blocks here until the others terminate). // Once the threads join, the borrow expires and the data becomes // accessible again in this thread.\\n}\\n// data is definitely mutated here. In principle, this totally works! Rust’s ownership system perfectly ensures it!\\n…except it relies on a destructor being called to be safe. let mut data = Box::new(0);\\n{ let guard = thread::scoped(|| { // This is at best a data race. At worst, it\'s also a use-after-free. *data += 1; }); // Because the guard is forgotten, expiring the loan without blocking this // thread. mem::forget(guard);\\n}\\n// So the Box is dropped here while the scoped thread may or may not be trying\\n// to access it. Dang. Here the destructor running was pretty fundamental to the API, and it had\\nto be scrapped in favor of a completely different design.","breadcrumbs":"Ownership Based Resource Management » Leaking » thread::scoped::JoinGuard","id":"63","title":"thread::scoped::JoinGuard"},"64":{"body":"Rust has a tiered error-handling scheme: If something might reasonably be absent, Option is used. If something goes wrong and can reasonably be handled, Result is used. If something goes wrong and cannot reasonably be handled, the thread panics. If something catastrophic happens, the program aborts. Option and Result are overwhelmingly preferred in most situations, especially\\nsince they can be promoted into a panic or abort at the API user’s discretion.\\nPanics cause the thread to halt normal execution and unwind its stack, calling\\ndestructors as if every function instantly returned. As of 1.0, Rust is of two minds when it comes to panics. In the long-long-ago,\\nRust was much more like Erlang. Like Erlang, Rust had lightweight tasks,\\nand tasks were intended to kill themselves with a panic when they reached an\\nuntenable state. Unlike an exception in Java or C++, a panic could not be\\ncaught at any time. Panics could only be caught by the owner of the task, at which\\npoint they had to be handled or that task would itself panic. Unwinding was important to this story because if a task’s\\ndestructors weren’t called, it would cause memory and other system resources to\\nleak. Since tasks were expected to die during normal execution, this would make\\nRust very poor for long-running systems! As the Rust we know today came to be, this style of programming grew out of\\nfashion in the push for less-and-less abstraction. Light-weight tasks were\\nkilled in the name of heavy-weight OS threads. Still, on stable Rust as of 1.0\\npanics can only be caught by the parent thread. This means catching a panic\\nrequires spinning up an entire OS thread! This unfortunately stands in conflict\\nto Rust’s philosophy of zero-cost abstractions. There is an API called catch_unwind that enables catching a panic\\nwithout spawning a thread. Still, we would encourage you to only do this\\nsparingly. In particular, Rust’s current unwinding implementation is heavily\\noptimized for the “doesn’t unwind” case. If a program doesn’t unwind, there\\nshould be no runtime cost for the program being ready to unwind. As a\\nconsequence, actually unwinding will be more expensive than in e.g. Java.\\nDon’t build your programs to unwind under normal circumstances. Ideally, you\\nshould only panic for programming errors or extreme problems. Rust’s unwinding strategy is not specified to be fundamentally compatible\\nwith any other language’s unwinding. As such, unwinding into Rust from another\\nlanguage, or unwinding into another language from Rust is Undefined Behavior.\\nYou must absolutely catch any panics at the FFI boundary! What you do at that\\npoint is up to you, but something must be done. If you fail to do this,\\nat best, your application will crash and burn. At worst, your application won’t\\ncrash and burn, and will proceed with completely clobbered state.","breadcrumbs":"Unwinding » Unwinding","id":"64","title":"Unwinding"},"65":{"body":"Although programs should use unwinding sparingly, there’s a lot of code that can panic. If you unwrap a None, index out of bounds, or divide by 0, your\\nprogram will panic. On debug builds, every arithmetic operation can panic\\nif it overflows. Unless you are very careful and tightly control what code runs,\\npretty much everything can unwind, and you need to be ready for it. Being ready for unwinding is often referred to as exception safety\\nin the broader programming world. In Rust, there are two levels of exception\\nsafety that one may concern themselves with: In unsafe code, we must be exception safe to the point of not violating\\nmemory safety. We’ll call this minimal exception safety. In safe code, it is good to be exception safe to the point of your program\\ndoing the right thing. We’ll call this maximal exception safety. As is the case in many places in Rust, Unsafe code must be ready to deal with\\nbad Safe code when it comes to unwinding. Code that transiently creates\\nunsound states must be careful that a panic does not cause that state to be\\nused. Generally this means ensuring that only non-panicking code is run while\\nthese states exist, or making a guard that cleans up the state in the case of\\na panic. This does not necessarily mean that the state a panic witnesses is a\\nfully coherent state. We need only guarantee that it’s a safe state. Most Unsafe code is leaf-like, and therefore fairly easy to make exception-safe.\\nIt controls all the code that runs, and most of that code can’t panic. However\\nit is not uncommon for Unsafe code to work with arrays of temporarily\\nuninitialized data while repeatedly invoking caller-provided code. Such code\\nneeds to be careful and consider exception safety.","breadcrumbs":"Unwinding » Exception Safety » Exception Safety","id":"65","title":"Exception Safety"},"66":{"body":"Vec::push_all is a temporary hack to get extending a Vec by a slice reliably\\nefficient without specialization. Here’s a simple implementation: impl<T: Clone> Vec<T> { fn push_all(&mut self, to_push: &[T]) { self.reserve(to_push.len()); unsafe { // can\'t overflow because we just reserved this self.set_len(self.len() + to_push.len()); for (i, x) in to_push.iter().enumerate() { self.ptr().add(i).write(x.clone()); } } }\\n} We bypass push in order to avoid redundant capacity and len checks on the\\nVec that we definitely know has capacity. The logic is totally correct, except\\nthere’s a subtle problem with our code: it’s not exception-safe! set_len, add, and write are all fine; clone is the panic bomb we over-looked. Clone is completely out of our control, and is totally free to panic. If it\\ndoes, our function will exit early with the length of the Vec set too large. If\\nthe Vec is looked at or dropped, uninitialized memory will be read! The fix in this case is fairly simple. If we want to guarantee that the values\\nwe did clone are dropped, we can set the len every loop iteration. If we\\njust want to guarantee that uninitialized memory can’t be observed, we can set\\nthe len after the loop.","breadcrumbs":"Unwinding » Exception Safety » Vec::push_all","id":"66","title":"Vec::push_all"},"67":{"body":"Bubbling an element up a heap is a bit more complicated than extending a Vec.\\nThe pseudocode is as follows: bubble_up(heap, index): while index != 0 && heap[index] < heap[parent(index)]: heap.swap(index, parent(index)) index = parent(index) A literal transcription of this code to Rust is totally fine, but has an annoying\\nperformance characteristic: the self element is swapped over and over again\\nuselessly. We would rather have the following: bubble_up(heap, index): let elem = heap[index] while index != 0 && elem < heap[parent(index)]: heap[index] = heap[parent(index)] index = parent(index) heap[index] = elem This code ensures that each element is copied as little as possible (it is in\\nfact necessary that elem be copied twice in general). However it now exposes\\nsome exception safety trouble! At all times, there exists two copies of one\\nvalue. If we panic in this function something will be double-dropped.\\nUnfortunately, we also don’t have full control of the code: that comparison is\\nuser-defined! Unlike Vec, the fix isn’t as easy here. One option is to break the user-defined\\ncode and the unsafe code into two separate phases: bubble_up(heap, index): let end_index = index; while end_index != 0 && heap[index] < heap[parent(end_index)]: end_index = parent(end_index) let elem = heap[index] while index != end_index: heap[index] = heap[parent(index)] index = parent(index) heap[index] = elem If the user-defined code blows up, that’s no problem anymore, because we haven’t\\nactually touched the state of the heap yet. Once we do start messing with the\\nheap, we’re working with only data and functions that we trust, so there’s no\\nconcern of panics. Perhaps you’re not happy with this design. Surely it’s cheating! And we have\\nto do the complex heap traversal twice! Alright, let’s bite the bullet. Let’s\\nintermix untrusted and unsafe code for reals. If Rust had try and finally like in Java, we could do the following: bubble_up(heap, index): let elem = heap[index] try: while index != 0 && elem < heap[parent(index)]: heap[index] = heap[parent(index)] index = parent(index) finally: heap[index] = elem The basic idea is simple: if the comparison panics, we just toss the loose\\nelement in the logically uninitialized index and bail out. Anyone who observes\\nthe heap will see a potentially inconsistent heap, but at least it won’t\\ncause any double-drops! If the algorithm terminates normally, then this\\noperation happens to coincide precisely with how we finish up regardless. Sadly, Rust has no such construct, so we’re going to need to roll our own! The\\nway to do this is to store the algorithm’s state in a separate struct with a\\ndestructor for the “finally” logic. Whether we panic or not, that destructor\\nwill run and clean up after us. struct Hole<\'a, T: \'a> { data: &\'a mut [T], /// `elt` is always `Some` from new until drop. elt: Option<T>, pos: usize,\\n} impl<\'a, T> Hole<\'a, T> { fn new(data: &\'a mut [T], pos: usize) -> Self { unsafe { let elt = ptr::read(&data[pos]); Hole { data, elt: Some(elt), pos, } } } fn pos(&self) -> usize { self.pos } fn removed(&self) -> &T { self.elt.as_ref().unwrap() } fn get(&self, index: usize) -> &T { &self.data[index] } unsafe fn move_to(&mut self, index: usize) { let index_ptr: *const _ = &self.data[index]; let hole_ptr = &mut self.data[self.pos]; ptr::copy_nonoverlapping(index_ptr, hole_ptr, 1); self.pos = index; }\\n} impl<\'a, T> Drop for Hole<\'a, T> { fn drop(&mut self) { // fill the hole again unsafe { let pos = self.pos; ptr::write(&mut self.data[pos], self.elt.take().unwrap()); } }\\n} impl<T: Ord> BinaryHeap<T> { fn sift_up(&mut self, pos: usize) { unsafe { // Take out the value at `pos` and create a hole. let mut hole = Hole::new(&mut self.data, pos); while hole.pos() != 0 { let parent = parent(hole.pos()); if hole.removed() <= hole.get(parent) { break } hole.move_to(parent); } // Hole will be unconditionally filled here; panic or not! } }\\n}","breadcrumbs":"Unwinding » Exception Safety » BinaryHeap::sift_up","id":"67","title":"BinaryHeap::sift_up"},"68":{"body":"Although all unsafe code must ensure it has minimal exception safety, not all\\ntypes ensure maximal exception safety. Even if the type does, your code may\\nascribe additional meaning to it. For instance, an integer is certainly\\nexception-safe, but has no semantics on its own. It’s possible that code that\\npanics could fail to correctly update the integer, producing an inconsistent\\nprogram state. This is usually fine, because anything that witnesses an exception is about\\nto get destroyed. For instance, if you send a Vec to another thread and that\\nthread panics, it doesn’t matter if the Vec is in a weird state. It will be\\ndropped and go away forever. However some types are especially good at smuggling\\nvalues across the panic boundary. These types may choose to explicitly poison themselves if they witness a panic.\\nPoisoning doesn’t entail anything in particular. Generally it just means\\npreventing normal usage from proceeding. The most notable example of this is the\\nstandard library’s Mutex type. A Mutex will poison itself if one of its\\nMutexGuards (the thing it returns when a lock is obtained) is dropped during a\\npanic. Any future attempts to lock the Mutex will return an Err or panic. Mutex poisons not for true safety in the sense that Rust normally cares about. It\\npoisons as a safety-guard against blindly using the data that comes out of a Mutex\\nthat has witnessed a panic while locked. The data in such a Mutex was likely in the\\nmiddle of being modified, and as such may be in an inconsistent or incomplete state.\\nIt is important to note that one cannot violate memory safety with such a type\\nif it is correctly written. After all, it must be minimally exception-safe! However if the Mutex contained, say, a BinaryHeap that does not actually have the\\nheap property, it’s unlikely that any code that uses it will do\\nwhat the author intended. As such, the program should not proceed normally.\\nStill, if you’re double-plus-sure that you can do something with the value,\\nthe Mutex exposes a method to get the lock anyway. It is safe, after all.\\nJust maybe nonsense.","breadcrumbs":"Unwinding » Poisoning » Poisoning","id":"68","title":"Poisoning"},"69":{"body":"Rust as a language doesn’t really have an opinion on how to do concurrency or\\nparallelism. The standard library exposes OS threads and blocking sys-calls\\nbecause everyone has those, and they’re uniform enough that you can provide\\nan abstraction over them in a relatively uncontroversial way. Message passing,\\ngreen threads, and async APIs are all diverse enough that any abstraction over\\nthem tends to involve trade-offs that we weren’t willing to commit to for 1.0. However the way Rust models concurrency makes it relatively easy to design your own\\nconcurrency paradigm as a library and have everyone else’s code Just Work\\nwith yours. Just require the right lifetimes and Send and Sync where appropriate\\nand you’re off to the races. Or rather, off to the… not… having… races.","breadcrumbs":"Concurrency » Concurrency and Parallelism","id":"69","title":"Concurrency and Parallelism"},"7":{"body":"First and foremost, all types have an alignment specified in bytes. The\\nalignment of a type specifies what addresses are valid to store the value at. A\\nvalue with alignment n must only be stored at an address that is a multiple of n. So alignment 2 means you must be stored at an even address, and 1 means\\nthat you can be stored anywhere. Alignment is at least 1, and always a power\\nof 2. Primitives are usually aligned to their size, although this is\\nplatform-specific behavior. For example, on x86 u64 and f64 are often\\naligned to 4 bytes (32 bits). A type’s size must always be a multiple of its alignment (Zero being a valid size\\nfor any alignment). This ensures that an array of that type may always be indexed\\nby offsetting by a multiple of its size. Note that the size and alignment of a\\ntype may not be known statically in the case of dynamically sized types. Rust gives you the following ways to lay out composite data: structs (named product types) tuples (anonymous product types) arrays (homogeneous product types) enums (named sum types – tagged unions) unions (untagged unions) An enum is said to be field-less if none of its variants have associated data. By default, composite structures have an alignment equal to the maximum\\nof their fields’ alignments. Rust will consequently insert padding where\\nnecessary to ensure that all fields are properly aligned and that the overall\\ntype’s size is a multiple of its alignment. For instance: #![allow(unused)] fn main() {\\nstruct A { a: u8, b: u32, c: u16,\\n} } will be 32-bit aligned on a target that aligns these primitives to their\\nrespective sizes. The whole struct will therefore have a size that is a multiple\\nof 32-bits. It may become: #![allow(unused)] fn main() {\\nstruct A { a: u8, _pad1: [u8; 3], // to align `b` b: u32, c: u16, _pad2: [u8; 2], // to make overall size multiple of 4\\n} } or maybe: #![allow(unused)] fn main() {\\nstruct A { b: u32, c: u16, a: u8, _pad: u8,\\n} } There is no indirection for these types; all data is stored within the struct,\\nas you would expect in C. However with the exception of arrays (which are\\ndensely packed and in-order), the layout of data is not specified by default.\\nGiven the two following struct definitions: #![allow(unused)] fn main() {\\nstruct A { a: i32, b: u64,\\n} struct B { a: i32, b: u64,\\n} } Rust does guarantee that two instances of A have their data laid out in\\nexactly the same way. However Rust does not currently guarantee that an\\ninstance of A has the same field ordering or padding as an instance of B. With A and B as written, this point would seem to be pedantic, but several other\\nfeatures of Rust make it desirable for the language to play with data layout in\\ncomplex ways. For instance, consider this struct: #![allow(unused)] fn main() {\\nstruct Foo<T, U> { count: u16, data1: T, data2: U,\\n} } Now consider the monomorphizations of Foo<u32, u16> and Foo<u16, u32>. If\\nRust lays out the fields in the order specified, we expect it to pad the\\nvalues in the struct to satisfy their alignment requirements. So if Rust\\ndidn’t reorder fields, we would expect it to produce the following: struct Foo<u16, u32> { count: u16, data1: u16, data2: u32,\\n} struct Foo<u32, u16> { count: u16, _pad1: u16, data1: u32, data2: u16, _pad2: u16,\\n} The latter case quite simply wastes space. An optimal use of space\\nrequires different monomorphizations to have different field orderings. Enums make this consideration even more complicated. Naively, an enum such as: #![allow(unused)] fn main() {\\nenum Foo { A(u32), B(u64), C(u8),\\n} } might be laid out as: #![allow(unused)] fn main() {\\nstruct FooRepr { data: u64, // this is either a u64, u32, or u8 based on `tag` tag: u8, // 0 = A, 1 = B, 2 = C\\n} } And indeed this is approximately how it would be laid out (modulo the\\nsize and position of tag). However there are several cases where such a representation is inefficient. The\\nclassic case of this is Rust’s “null pointer optimization”: an enum consisting\\nof a single outer unit variant (e.g. None) and a (potentially nested) non-\\nnullable pointer variant (e.g. Some(&T)) makes the tag unnecessary. A null\\npointer can safely be interpreted as the unit ( None) variant. The net\\nresult is that, for example, size_of::<Option<&T>>() == size_of::<&T>(). There are many types in Rust that are, or contain, non-nullable pointers such as Box<T>, Vec<T>, String, &T, and &mut T. Similarly, one can imagine\\nnested enums pooling their tags into a single discriminant, as they are by\\ndefinition known to have a limited range of valid values. In principle enums could\\nuse fairly elaborate algorithms to store bits throughout nested types with\\nforbidden values. As such it is especially desirable that\\nwe leave enum layout unspecified today.","breadcrumbs":"Data Layout » repr(Rust) » repr(Rust)","id":"7","title":"repr(Rust)"},"70":{"body":"Safe Rust guarantees an absence of data races, which are defined as: two or more threads concurrently accessing a location of memory one or more of them is a write one or more of them is unsynchronized A data race has Undefined Behavior, and is therefore impossible to perform in\\nSafe Rust. Data races are prevented mostly through Rust’s ownership system alone:\\nit’s impossible to alias a mutable reference, so it’s impossible to perform a\\ndata race. Interior mutability makes this more complicated, which is largely why\\nwe have the Send and Sync traits (see the next section for more on this). However Rust does not prevent general race conditions. This is mathematically impossible in situations where you do not control the\\nscheduler, which is true for the normal OS environment. If you do control\\npreemption, it can be possible to prevent general races - this technique is\\nused by frameworks such as RTIC. However,\\nactually having control over scheduling is a very uncommon case. For this reason, it is considered “safe” for Rust to get deadlocked or do\\nsomething nonsensical with incorrect synchronization: this is known as a general\\nrace condition or resource race. Obviously such a program isn’t very good, but\\nRust of course cannot prevent all logic errors. In any case, a race condition cannot violate memory safety in a Rust program on\\nits own. Only in conjunction with some other unsafe code can a race condition\\nactually violate memory safety. For instance, a correct program looks like this: #![allow(unused)] fn main() {\\nuse std::thread;\\nuse std::sync::atomic::{AtomicUsize, Ordering};\\nuse std::sync::Arc; let data = vec![1, 2, 3, 4];\\n// Arc so that the memory the AtomicUsize is stored in still exists for\\n// the other thread to increment, even if we completely finish executing\\n// before it. Rust won\'t compile the program without it, because of the\\n// lifetime requirements of thread::spawn!\\nlet idx = Arc::new(AtomicUsize::new(0));\\nlet other_idx = idx.clone(); // `move` captures other_idx by-value, moving it into this thread\\nthread::spawn(move || { // It\'s ok to mutate idx because this value // is an atomic, so it can\'t cause a Data Race. other_idx.fetch_add(10, Ordering::SeqCst);\\n}); // Index with the value loaded from the atomic. This is safe because we\\n// read the atomic memory only once, and then pass a copy of that value\\n// to the Vec\'s indexing implementation. This indexing will be correctly\\n// bounds checked, and there\'s no chance of the value getting changed\\n// in the middle. However our program may panic if the thread we spawned\\n// managed to increment before this ran. A race condition because correct\\n// program execution (panicking is rarely correct) depends on order of\\n// thread execution.\\nprintln!(\\"{}\\", data[idx.load(Ordering::SeqCst)]); } We can cause a race condition to violate memory safety if we instead do the bound\\ncheck in advance, and then unsafely access the data with an unchecked value: #![allow(unused)] fn main() {\\nuse std::thread;\\nuse std::sync::atomic::{AtomicUsize, Ordering};\\nuse std::sync::Arc; let data = vec![1, 2, 3, 4]; let idx = Arc::new(AtomicUsize::new(0));\\nlet other_idx = idx.clone(); // `move` captures other_idx by-value, moving it into this thread\\nthread::spawn(move || { // It\'s ok to mutate idx because this value // is an atomic, so it can\'t cause a Data Race. other_idx.fetch_add(10, Ordering::SeqCst);\\n}); if idx.load(Ordering::SeqCst) < data.len() { unsafe { // Incorrectly loading the idx after we did the bounds check. // It could have changed. This is a race condition, *and dangerous* // because we decided to do `get_unchecked`, which is `unsafe`. println!(\\"{}\\", data.get_unchecked(idx.load(Ordering::SeqCst))); }\\n} }","breadcrumbs":"Concurrency » Races » Data Races and Race Conditions","id":"70","title":"Data Races and Race Conditions"},"71":{"body":"Not everything obeys inherited mutability, though. Some types allow you to\\nhave multiple aliases of a location in memory while mutating it. Unless these types use\\nsynchronization to manage this access, they are absolutely not thread-safe. Rust\\ncaptures this through the Send and Sync traits. A type is Send if it is safe to send it to another thread. A type is Sync if it is safe to share between threads (T is Sync if and only if &T is Send). Send and Sync are fundamental to Rust’s concurrency story. As such, a\\nsubstantial amount of special tooling exists to make them work right. First and\\nforemost, they’re unsafe traits. This means that they are unsafe to\\nimplement, and other unsafe code can assume that they are correctly\\nimplemented. Since they’re marker traits (they have no associated items like\\nmethods), correctly implemented simply means that they have the intrinsic\\nproperties an implementor should have. Incorrectly implementing Send or Sync can\\ncause Undefined Behavior. Send and Sync are also automatically derived traits. This means that, unlike\\nevery other trait, if a type is composed entirely of Send or Sync types, then it\\nis Send or Sync. Almost all primitives are Send and Sync, and as a consequence\\npretty much all types you’ll ever interact with are Send and Sync. Major exceptions include: raw pointers are neither Send nor Sync (because they have no safety guards). UnsafeCell isn’t Sync (and therefore Cell and RefCell aren’t). Rc isn’t Send or Sync (because the refcount is shared and unsynchronized). Rc and UnsafeCell are very fundamentally not thread-safe: they enable\\nunsynchronized shared mutable state. However raw pointers are, strictly\\nspeaking, marked as thread-unsafe as more of a lint. Doing anything useful\\nwith a raw pointer requires dereferencing it, which is already unsafe. In that\\nsense, one could argue that it would be “fine” for them to be marked as thread\\nsafe. However it’s important that they aren’t thread-safe to prevent types that\\ncontain them from being automatically marked as thread-safe. These types have\\nnon-trivial untracked ownership, and it’s unlikely that their author was\\nnecessarily thinking hard about thread safety. In the case of Rc, we have a nice\\nexample of a type that contains a *mut that is definitely not thread-safe. Types that aren’t automatically derived can simply implement them if desired: #![allow(unused)] fn main() {\\nstruct MyBox(*mut u8); unsafe impl Send for MyBox {}\\nunsafe impl Sync for MyBox {} } In the incredibly rare case that a type is inappropriately automatically\\nderived to be Send or Sync, then one can also unimplement Send and Sync: #![allow(unused)]\\n#![feature(negative_impls)] fn main() {\\n// I have some magic semantics for some synchronization primitive!\\nstruct SpecialThreadToken(u8); impl !Send for SpecialThreadToken {}\\nimpl !Sync for SpecialThreadToken {} } Note that in and of itself it is impossible to incorrectly derive Send and\\nSync. Only types that are ascribed special meaning by other unsafe code can\\npossibly cause trouble by being incorrectly Send or Sync. Most uses of raw pointers should be encapsulated behind a sufficient abstraction\\nthat Send and Sync can be derived. For instance all of Rust’s standard\\ncollections are Send and Sync (when they contain Send and Sync types) in spite\\nof their pervasive use of raw pointers to manage allocations and complex ownership.\\nSimilarly, most iterators into these collections are Send and Sync because they\\nlargely behave like an & or &mut into the collection.","breadcrumbs":"Concurrency » Send and Sync » Send and Sync","id":"71","title":"Send and Sync"},"72":{"body":"Box is implemented as its own special intrinsic type by the\\ncompiler for various reasons, but we can implement something\\nwith similar-ish behavior ourselves to see an example of when it is sound to\\nimplement Send and Sync. Let’s call it a Carton. We start by writing code to take a value allocated on the stack and transfer it\\nto the heap. #![allow(unused)] fn main() { pub mod libc { pub use ::std::os::raw::{c_int, c_void}; #[allow(non_camel_case_types)] pub type size_t = usize; unsafe extern \\"C\\" { pub fn posix_memalign(memptr: *mut *mut c_void, align: size_t, size: size_t) -> c_int; } }\\nuse std::{ mem::{align_of, size_of}, ptr, cmp::max,\\n}; struct Carton<T>(ptr::NonNull<T>); impl<T> Carton<T> { pub fn new(value: T) -> Self { // Allocate enough memory on the heap to store one T. assert_ne!(size_of::<T>(), 0, \\"Zero-sized types are out of the scope of this example\\"); let mut memptr: *mut T = ptr::null_mut(); unsafe { let ret = libc::posix_memalign( (&mut memptr as *mut *mut T).cast(), max(align_of::<T>(), size_of::<usize>()), size_of::<T>() ); assert_eq!(ret, 0, \\"Failed to allocate or invalid alignment\\"); }; // NonNull is just a wrapper that enforces that the pointer isn\'t null. let ptr = { // Safety: memptr is dereferenceable because we created it from a // reference and have exclusive access. ptr::NonNull::new(memptr) .expect(\\"Guaranteed non-null if posix_memalign returns 0\\") }; // Move value from the stack to the location we allocated on the heap. unsafe { // Safety: If non-null, posix_memalign gives us a ptr that is valid // for writes and properly aligned. ptr.as_ptr().write(value); } Self(ptr) }\\n} } This isn’t very useful, because once our users give us a value they have no way\\nto access it. Box implements Deref and DerefMut so that you can access the inner value. Let’s do\\nthat. #![allow(unused)] fn main() {\\nuse std::ops::{Deref, DerefMut}; struct Carton<T>(std::ptr::NonNull<T>); impl<T> Deref for Carton<T> { type Target = T; fn deref(&self) -> &Self::Target { unsafe { // Safety: The pointer is aligned, initialized, and dereferenceable // by the logic in [`Self::new`]. We require readers to borrow the // Carton, and the lifetime of the return value is elided to the // lifetime of the input. This means the borrow checker will // enforce that no one can mutate the contents of the Carton until // the reference returned is dropped. self.0.as_ref() } }\\n} impl<T> DerefMut for Carton<T> { fn deref_mut(&mut self) -> &mut Self::Target { unsafe { // Safety: The pointer is aligned, initialized, and dereferenceable // by the logic in [`Self::new`]. We require writers to mutably // borrow the Carton, and the lifetime of the return value is // elided to the lifetime of the input. This means the borrow // checker will enforce that no one else can access the contents // of the Carton until the mutable reference returned is dropped. self.0.as_mut() } }\\n} } Finally, let’s think about whether our Carton is Send and Sync. Something can\\nsafely be Send unless it shares mutable state with something else without\\nenforcing exclusive access to it. Each Carton has a unique pointer, so\\nwe’re good. #![allow(unused)] fn main() { struct Carton<T>(std::ptr::NonNull<T>);\\n// Safety: No one besides us has the raw pointer, so we can safely transfer the\\n// Carton to another thread if T can be safely transferred.\\nunsafe impl<T> Send for Carton<T> where T: Send {} } What about Sync? For Carton to be Sync we have to enforce that you can’t\\nwrite to something stored in a &Carton while that same something could be read\\nor written to from another &Carton. Since you need an &mut Carton to\\nwrite to the pointer, and the borrow checker enforces that mutable\\nreferences must be exclusive, there are no soundness issues making Carton\\nsync either. #![allow(unused)] fn main() { struct Carton<T>(std::ptr::NonNull<T>);\\n// Safety: Since there exists a public way to go from a `&Carton<T>` to a `&T`\\n// in an unsynchronized fashion (such as `Deref`), then `Carton<T>` can\'t be\\n// `Sync` if `T` isn\'t.\\n// Conversely, `Carton` itself does not use any interior mutability whatsoever:\\n// all the mutations are performed through an exclusive reference (`&mut`). This\\n// means it suffices that `T` be `Sync` for `Carton<T>` to be `Sync`:\\nunsafe impl<T> Sync for Carton<T> where T: Sync {} } When we assert our type is Send and Sync we usually need to enforce that every\\ncontained type is Send and Sync. When writing custom types that behave like\\nstandard library types we can assert that we have the same requirements.\\nFor example, the following code asserts that a Carton is Send if the same\\nsort of Box would be Send, which in this case is the same as saying T is Send. #![allow(unused)] fn main() { struct Carton<T>(std::ptr::NonNull<T>);\\nunsafe impl<T> Send for Carton<T> where Box<T>: Send {} } Right now Carton<T> has a memory leak, as it never frees the memory it allocates.\\nOnce we fix that we have a new requirement we have to ensure we meet to be Send:\\nwe need to know free can be called on a pointer that was yielded by an\\nallocation done on another thread. We can check this is true in the docs for libc::free. #![allow(unused)] fn main() { struct Carton<T>(std::ptr::NonNull<T>); mod libc { pub use ::std::os::raw::c_void; unsafe extern \\"C\\" { pub fn free(p: *mut c_void); } }\\nimpl<T> Drop for Carton<T> { fn drop(&mut self) { unsafe { libc::free(self.0.as_ptr().cast()); } }\\n} } A nice example where this does not happen is with a MutexGuard: notice how it is not Send. The implementation of MutexGuard uses libraries that require you to ensure you\\ndon’t try to free a lock that you acquired in a different thread. If you were\\nable to Send a MutexGuard to another thread the destructor would run in the\\nthread you sent it to, violating the requirement. MutexGuard can still be Sync\\nbecause all you can send to another thread is an &MutexGuard and dropping a\\nreference does nothing. TODO: better explain what can or can’t be Send or Sync. Sufficient to appeal\\nonly to data races?","breadcrumbs":"Concurrency » Send and Sync » Example","id":"72","title":"Example"},"73":{"body":"Rust pretty blatantly just inherits the memory model for atomics from C++20. This is not\\ndue to this model being particularly excellent or easy to understand. Indeed,\\nthis model is quite complex and known to have several flaws.\\nRather, it is a pragmatic concession to the fact that everyone is pretty bad\\nat modeling atomics. At the very least, we can benefit from existing tooling and\\nresearch around the C/C++ memory model.\\n(You’ll often see this model referred to as “C/C++11” or just “C11”. C just copies\\nthe C++ memory model; and C++11 was the first version of the model but it has\\nreceived some bugfixes since then.) Trying to fully explain the model in this book is fairly hopeless. It’s defined\\nin terms of madness-inducing causality graphs that require a full book to\\nproperly understand in a practical way. If you want all the nitty-gritty\\ndetails, you should check out the C++ specification.\\nStill, we’ll try to cover the basics and some of the problems Rust developers\\nface. The C++ memory model is fundamentally about trying to bridge the gap between the\\nsemantics we want, the optimizations compilers want, and the inconsistent chaos\\nour hardware wants. We would like to just write programs and have them do\\nexactly what we said but, you know, fast. Wouldn’t that be great?","breadcrumbs":"Concurrency » Atomics » Atomics","id":"73","title":"Atomics"},"74":{"body":"Compilers fundamentally want to be able to do all sorts of complicated\\ntransformations to reduce data dependencies and eliminate dead code. In\\nparticular, they may radically change the actual order of events, or make events\\nnever occur! If we write something like: x = 1;\\ny = 3;\\nx = 2; The compiler may conclude that it would be best if your program did: x = 2;\\ny = 3; This has inverted the order of events and completely eliminated one event.\\nFrom a single-threaded perspective this is completely unobservable: after all\\nthe statements have executed we are in exactly the same state. But if our\\nprogram is multi-threaded, we may have been relying on x to actually be\\nassigned to 1 before y was assigned. We would like the compiler to be\\nable to make these kinds of optimizations, because they can seriously improve\\nperformance. On the other hand, we’d also like to be able to depend on our\\nprogram doing the thing we said.","breadcrumbs":"Concurrency » Atomics » Compiler Reordering","id":"74","title":"Compiler Reordering"},"75":{"body":"On the other hand, even if the compiler totally understood what we wanted and\\nrespected our wishes, our hardware might instead get us in trouble. Trouble\\ncomes from CPUs in the form of memory hierarchies. There is indeed a global\\nshared memory space somewhere in your hardware, but from the perspective of each\\nCPU core it is so very far away and so very slow. Each CPU would rather work\\nwith its local cache of the data and only go through all the anguish of\\ntalking to shared memory only when it doesn’t actually have that memory in\\ncache. After all, that’s the whole point of the cache, right? If every read from the\\ncache had to run back to shared memory to double check that it hadn’t changed,\\nwhat would the point be? The end result is that the hardware doesn’t guarantee\\nthat events that occur in some order on one thread, occur in the same\\norder on another thread. To guarantee this, we must issue special instructions\\nto the CPU telling it to be a bit less smart. For instance, say we convince the compiler to emit this logic: initial state: x = 0, y = 1 THREAD 1 THREAD 2\\ny = 3; if x == 1 {\\nx = 1; y *= 2; } Ideally this program has 2 possible final states: y = 3: (thread 2 did the check before thread 1 completed) y = 6: (thread 2 did the check after thread 1 completed) However there’s a third potential state that the hardware enables: y = 2: (thread 2 saw x = 1, but not y = 3, and then overwrote y = 3) It’s worth noting that different kinds of CPU provide different guarantees. It\\nis common to separate hardware into two categories: strongly-ordered and weakly-ordered.\\nMost notably x86/64 provides strong ordering guarantees, while ARM\\nprovides weak ordering guarantees. This has two consequences for concurrent\\nprogramming: Asking for stronger guarantees on strongly-ordered hardware may be cheap or\\neven free because they already provide strong guarantees unconditionally.\\nWeaker guarantees may only yield performance wins on weakly-ordered hardware. Asking for guarantees that are too weak on strongly-ordered hardware is\\nmore likely to happen to work, even though your program is strictly\\nincorrect. If possible, concurrent algorithms should be tested on\\nweakly-ordered hardware.","breadcrumbs":"Concurrency » Atomics » Hardware Reordering","id":"75","title":"Hardware Reordering"},"76":{"body":"The C++ memory model attempts to bridge the gap by allowing us to talk about the causality of our program. Generally, this is by establishing a happens\\nbefore relationship between parts of the program and the threads that are\\nrunning them. This gives the hardware and compiler room to optimize the program\\nmore aggressively where a strict happens-before relationship isn’t established,\\nbut forces them to be more careful where one is established. The way we\\ncommunicate these relationships are through data accesses and atomic\\naccesses. Data accesses are the bread-and-butter of the programming world. They are\\nfundamentally unsynchronized and compilers are free to aggressively optimize\\nthem. In particular, data accesses are free to be reordered by the compiler on\\nthe assumption that the program is single-threaded. The hardware is also free to\\npropagate the changes made in data accesses to other threads as lazily and\\ninconsistently as it wants. Most critically, data accesses are how data races\\nhappen. Data accesses are very friendly to the hardware and compiler, but as\\nwe’ve seen they offer awful semantics to try to write synchronized code with.\\nActually, that’s too weak. It is literally impossible to write correct synchronized code using only data\\naccesses. Atomic accesses are how we tell the hardware and compiler that our program is\\nmulti-threaded. Each atomic access can be marked with an ordering that\\nspecifies what kind of relationship it establishes with other accesses. In\\npractice, this boils down to telling the compiler and hardware certain things\\nthey can’t do. For the compiler, this largely revolves around re-ordering of\\ninstructions. For the hardware, this largely revolves around how writes are\\npropagated to other threads. The set of orderings Rust exposes are: Sequentially Consistent (SeqCst) Release Acquire Relaxed (Note: We explicitly do not expose the C++ consume ordering) TODO: negative reasoning vs positive reasoning? TODO: “can’t forget to\\nsynchronize”","breadcrumbs":"Concurrency » Atomics » Data Accesses","id":"76","title":"Data Accesses"},"77":{"body":"Sequentially Consistent is the most powerful of all, implying the restrictions\\nof all other orderings. Intuitively, a sequentially consistent operation\\ncannot be reordered: all accesses on one thread that happen before and after a\\nSeqCst access stay before and after it. A data-race-free program that uses\\nonly sequentially consistent atomics and data accesses has the very nice\\nproperty that there is a single global execution of the program’s instructions\\nthat all threads agree on. This execution is also particularly nice to reason\\nabout: it’s just an interleaving of each thread’s individual executions. This\\ndoes not hold if you start using the weaker atomic orderings. The relative developer-friendliness of sequential consistency doesn’t come for\\nfree. Even on strongly-ordered platforms sequential consistency involves\\nemitting memory fences. In practice, sequential consistency is rarely necessary for program correctness.\\nHowever sequential consistency is definitely the right choice if you’re not\\nconfident about the other memory orders. Having your program run a bit slower\\nthan it needs to is certainly better than it running incorrectly! It’s also\\nmechanically trivial to downgrade atomic operations to have a weaker\\nconsistency later on. Just change SeqCst to Relaxed and you’re done! Of\\ncourse, proving that this transformation is correct is a whole other matter.","breadcrumbs":"Concurrency » Atomics » Sequentially Consistent","id":"77","title":"Sequentially Consistent"},"78":{"body":"Acquire and Release are largely intended to be paired. Their names hint at their\\nuse case: they’re perfectly suited for acquiring and releasing locks, and\\nensuring that critical sections don’t overlap. Intuitively, an acquire access ensures that every access after it stays after\\nit. However operations that occur before an acquire are free to be reordered to\\noccur after it. Similarly, a release access ensures that every access before it\\nstays before it. However operations that occur after a release are free to be\\nreordered to occur before it. When thread A releases a location in memory and then thread B subsequently\\nacquires the same location in memory, causality is established. Every write\\n(including non-atomic and relaxed atomic writes) that happened before A’s\\nrelease will be observed by B after its acquisition. However no causality is\\nestablished with any other threads. Similarly, no causality is established\\nif A and B access different locations in memory. Basic use of release-acquire is therefore simple: you acquire a location of\\nmemory to begin the critical section, and then release that location to end it.\\nFor instance, a simple spinlock might look like: use std::sync::Arc;\\nuse std::sync::atomic::{AtomicBool, Ordering};\\nuse std::thread; fn main() { let lock = Arc::new(AtomicBool::new(false)); // value answers \\"am I locked?\\" // ... distribute lock to threads somehow ... // Try to acquire the lock by setting it to true while lock.compare_exchange(false, true, Ordering::Acquire, Ordering::Relaxed).is_err() { } // broke out of the loop, so we successfully acquired the lock! // ... scary data accesses ... // ok we\'re done, release the lock lock.store(false, Ordering::Release);\\n} On strongly-ordered platforms most accesses have release or acquire semantics,\\nmaking release and acquire often totally free. This is not the case on\\nweakly-ordered platforms.","breadcrumbs":"Concurrency » Atomics » Acquire-Release","id":"78","title":"Acquire-Release"},"79":{"body":"Relaxed accesses are the absolute weakest. They can be freely re-ordered and\\nprovide no happens-before relationship. Still, relaxed operations are still\\natomic. That is, they don’t count as data accesses and any read-modify-write\\noperations done to them occur atomically. Relaxed operations are appropriate for\\nthings that you definitely want to happen, but don’t particularly otherwise care\\nabout. For instance, incrementing a counter can be safely done by multiple\\nthreads using a relaxed fetch_add if you’re not using the counter to\\nsynchronize any other accesses. There’s rarely a benefit in making an operation relaxed on strongly-ordered\\nplatforms, since they usually provide release-acquire semantics anyway. However\\nrelaxed operations can be cheaper on weakly-ordered platforms.","breadcrumbs":"Concurrency » Atomics » Relaxed","id":"79","title":"Relaxed"},"8":{"body":"Most of the time, we expect types to have a statically known and positive size.\\nThis isn’t always the case in Rust.","breadcrumbs":"Data Layout » Exotically Sized Types » Exotically Sized Types","id":"8","title":"Exotically Sized Types"},"80":{"body":"To bring everything together, we’re going to write std::Vec from scratch.\\nWe will limit ourselves to stable Rust. In particular we won’t use any\\nintrinsics that could make our code a little bit nicer or efficient because\\nintrinsics are permanently unstable. Although many intrinsics do become\\nstabilized elsewhere ( std::ptr and std::mem consist of many intrinsics). Ultimately this means our implementation may not take advantage of all\\npossible optimizations, though it will be by no means naive. We will\\ndefinitely get into the weeds over nitty-gritty details, even\\nwhen the problem doesn’t really merit it. You wanted advanced. We’re gonna go advanced.","breadcrumbs":"Implementing Vec » Example: Implementing Vec","id":"80","title":"Example: Implementing Vec"},"81":{"body":"First off, we need to come up with the struct layout. A Vec has three parts:\\na pointer to the allocation, the size of the allocation, and the number of\\nelements that have been initialized. Naively, this means we just want this design: pub struct Vec<T> { ptr: *mut T, cap: usize, len: usize,\\n} And indeed this would compile. Unfortunately, it would be too strict. The\\ncompiler will give us too strict variance. So a &Vec<&\'static str>\\ncouldn’t be used where a &Vec<&\'a str> was expected. See the chapter\\non ownership and lifetimes for all the details on variance. As we saw in the ownership chapter, the standard library uses Unique<T> in place of *mut T when it has a raw pointer to an allocation that it owns. Unique is unstable,\\nso we’d like to not use it if possible, though. As a recap, Unique is a wrapper around a raw pointer that declares that: We are covariant over T We may own a value of type T (this is not relevant for our example here, but see the chapter on PhantomData on why the real std::vec::Vec<T> needs this) We are Send/Sync if T is Send/Sync Our pointer is never null (so Option<Vec<T>> is null-pointer-optimized) We can implement all of the above requirements in stable Rust. To do this, instead\\nof using Unique<T> we will use NonNull<T>, another wrapper around a\\nraw pointer, which gives us two of the above properties, namely it is covariant\\nover T and is declared to never be null. By implementing Send/Sync if T is,\\nwe get the same results as using Unique<T>: use std::ptr::NonNull; pub struct Vec<T> { ptr: NonNull<T>, cap: usize, len: usize,\\n} unsafe impl<T: Send> Send for Vec<T> {}\\nunsafe impl<T: Sync> Sync for Vec<T> {} fn main() {}","breadcrumbs":"Implementing Vec » Layout » Layout","id":"81","title":"Layout"},"82":{"body":"Using NonNull throws a wrench in an important feature of Vec (and indeed all of\\nthe std collections): creating an empty Vec doesn’t actually allocate at all. This\\nis not the same as allocating a zero-sized memory block, which is not allowed by\\nthe global allocator (it results in undefined behavior!). So if we can’t allocate,\\nbut also can’t put a null pointer in ptr, what do we do in Vec::new? Well, we\\njust put some other garbage in there! This is perfectly fine because we already have cap == 0 as our sentinel for no\\nallocation. We don’t even need to handle it specially in almost any code because\\nwe usually need to check if cap > len or len > 0 anyway. The recommended\\nRust value to put here is mem::align_of::<T>(). NonNull provides a convenience\\nfor this: NonNull::dangling(). There are quite a few places where we’ll\\nwant to use dangling because there’s no real allocation to talk about but null would make the compiler do bad things. So: use std::mem; impl<T> Vec<T> { pub fn new() -> Self { assert!(mem::size_of::<T>() != 0, \\"We\'re not ready to handle ZSTs\\"); Vec { ptr: NonNull::dangling(), len: 0, cap: 0, } }\\n} fn main() {} I slipped in that assert there because zero-sized types will require some\\nspecial handling throughout our code, and I want to defer the issue for now.\\nWithout this assert, some of our early drafts will do some Very Bad Things. Next we need to figure out what to actually do when we do want space. For that,\\nwe use the global allocation functions alloc, realloc,\\nand dealloc which are available in stable Rust in std::alloc. These functions are expected to become deprecated in\\nfavor of the methods of std::alloc::Global after this type is stabilized. We’ll also need a way to handle out-of-memory (OOM) conditions. The standard\\nlibrary provides a function alloc::handle_alloc_error,\\nwhich will abort the program in a platform-specific manner.\\nThe reason we abort and don’t panic is because unwinding can cause allocations\\nto happen, and that seems like a bad thing to do when your allocator just came\\nback with “hey I don’t have any more memory”. Of course, this is a bit silly since most platforms don’t actually run out of\\nmemory in a conventional way. Your operating system will probably kill the\\napplication by another means if you legitimately start using up all the memory.\\nThe most likely way we’ll trigger OOM is by just asking for ludicrous quantities\\nof memory at once (e.g. half the theoretical address space). As such it’s probably fine to panic and nothing bad will happen. Still, we’re trying to be\\nlike the standard library as much as possible, so we’ll just kill the whole\\nprogram. Okay, now we can write growing. Roughly, we want to have this logic: if cap == 0: allocate() cap = 1\\nelse: reallocate() cap *= 2 But Rust’s only supported allocator API is so low level that we’ll need to do a\\nfair bit of extra work. We also need to guard against some special\\nconditions that can occur with really large allocations or empty allocations. In particular, ptr::offset will cause us a lot of trouble, because it has\\nthe semantics of LLVM’s GEP inbounds instruction. If you’re fortunate enough to\\nnot have dealt with this instruction, here’s the basic story with GEP: alias\\nanalysis, alias analysis, alias analysis. It’s super important to an optimizing\\ncompiler to be able to reason about data dependencies and aliasing. As a simple example, consider the following fragment of code: *x *= 7;\\n*y *= 3; If the compiler can prove that x and y point to different locations in\\nmemory, the two operations can in theory be executed in parallel (by e.g.\\nloading them into different registers and working on them independently).\\nHowever the compiler can’t do this in general because if x and y point to\\nthe same location in memory, the operations need to be done to the same value,\\nand they can’t just be merged afterwards. When you use GEP inbounds, you are specifically telling LLVM that the offsets\\nyou’re about to do are within the bounds of a single “allocated” entity. The\\nultimate payoff being that LLVM can assume that if two pointers are known to\\npoint to two disjoint objects, all the offsets of those pointers are also\\nknown to not alias (because you won’t just end up in some random place in\\nmemory). LLVM is heavily optimized to work with GEP offsets, and inbounds\\noffsets are the best of all, so it’s important that we use them as much as\\npossible. So that’s what GEP’s about, how can it cause us trouble? The first problem is that we index into arrays with unsigned integers, but\\nGEP (and as a consequence ptr::offset) takes a signed integer. This means\\nthat half of the seemingly valid indices into an array will overflow GEP and\\nactually go in the wrong direction! As such we must limit all allocations to isize::MAX elements. This actually means we only need to worry about\\nbyte-sized objects, because e.g. > isize::MAX u16s will truly exhaust all of\\nthe system’s memory. However in order to avoid subtle corner cases where someone\\nreinterprets some array of < isize::MAX objects as bytes, std limits all\\nallocations to isize::MAX bytes. On all 64-bit targets that Rust currently supports we’re artificially limited\\nto significantly less than all 64 bits of the address space (modern x64\\nplatforms only expose 48-bit addressing), so we can rely on just running out of\\nmemory first. However on 32-bit targets, particularly those with extensions to\\nuse more of the address space (PAE x86 or x32), it’s theoretically possible to\\nsuccessfully allocate more than isize::MAX bytes of memory. However since this is a tutorial, we’re not going to be particularly optimal\\nhere, and just unconditionally check, rather than use clever platform-specific cfgs. The other corner-case we need to worry about is empty allocations. There will\\nbe two kinds of empty allocations we need to worry about: cap = 0 for all T,\\nand cap > 0 for zero-sized types. These cases are tricky because they come\\ndown to what LLVM means by “allocated”. LLVM’s notion of an\\nallocation is significantly more abstract than how we usually use it. Because\\nLLVM needs to work with different languages’ semantics and custom allocators,\\nit can’t really intimately understand allocation. Instead, the main idea behind\\nallocation is “doesn’t overlap with other stuff”. That is, heap allocations,\\nstack allocations, and globals don’t randomly overlap. Yep, it’s about alias\\nanalysis. As such, Rust can technically play a bit fast and loose with the notion of\\nan allocation as long as it’s consistent. Getting back to the empty allocation case, there are a couple of places where\\nwe want to offset by 0 as a consequence of generic code. The question is then:\\nis it consistent to do so? For zero-sized types, we have concluded that it is\\nindeed consistent to do a GEP inbounds offset by an arbitrary number of\\nelements. This is a runtime no-op because every element takes up no space,\\nand it’s fine to pretend that there’s infinite zero-sized types allocated\\nat 0x01. No allocator will ever allocate that address, because they won’t\\nallocate 0x00 and they generally allocate to some minimal alignment higher\\nthan a byte. Also generally the whole first page of memory is\\nprotected from being allocated anyway (a whole 4k, on many platforms). However what about for positive-sized types? That one’s a bit trickier. In\\nprinciple, you can argue that offsetting by 0 gives LLVM no information: either\\nthere’s an element before the address or after it, but it can’t know which.\\nHowever we’ve chosen to conservatively assume that it may do bad things. As\\nsuch we will guard against this case explicitly. Phew Ok with all the nonsense out of the way, let’s actually allocate some memory: use std::alloc::{self, Layout}; impl<T> Vec<T> { fn grow(&mut self) { let (new_cap, new_layout) = if self.cap == 0 { (1, Layout::array::<T>(1)) } else { // This can\'t overflow since self.cap <= isize::MAX. let new_cap = 2 * self.cap; (new_cap, Layout::array::<T>(new_cap)) }; // `Layout::array` checks that the number of bytes allocated is // in 1..=isize::MAX and will error otherwise. An allocation of // 0 bytes isn\'t possible thanks to the above condition. let new_layout = new_layout.expect(\\"Allocation too large\\"); let new_ptr = if self.cap == 0 { unsafe { alloc::alloc(new_layout) } } else { let old_layout = Layout::array::<T>(self.cap).unwrap(); let old_ptr = self.ptr.as_ptr() as *mut u8; unsafe { alloc::realloc(old_ptr, old_layout, new_layout.size()) } }; // If allocation fails, `new_ptr` will be null, in which case we abort. self.ptr = match NonNull::new(new_ptr as *mut T) { Some(p) => p, None => alloc::handle_alloc_error(new_layout), }; self.cap = new_cap; }\\n} fn main() {}","breadcrumbs":"Implementing Vec » Allocating » Allocating Memory","id":"82","title":"Allocating Memory"},"83":{"body":"Alright. We can initialize. We can allocate. Let’s actually implement some\\nfunctionality! Let’s start with push. All it needs to do is check if we’re\\nfull to grow, unconditionally write to the next index, and then increment our\\nlength. To do the write we have to be careful not to evaluate the memory we want to write\\nto. At worst, it’s truly uninitialized memory from the allocator. At best it’s the\\nbits of some old value we popped off. Either way, we can’t just index to the memory\\nand dereference it, because that will evaluate the memory as a valid instance of\\nT. Worse, foo[idx] = x will try to call drop on the old value of foo[idx]! The correct way to do this is with ptr::write, which just blindly overwrites the\\ntarget address with the bits of the value we provide. No evaluation involved. For push, if the old len (before push was called) is 0, then we want to write\\nto the 0th index. So we should offset by the old len. pub fn push(&mut self, elem: T) { if self.len == self.cap { self.grow(); } unsafe { ptr::write(self.ptr.as_ptr().add(self.len), elem); } // Can\'t fail, we\'ll OOM first. self.len += 1;\\n} Easy! How about pop? Although this time the index we want to access is\\ninitialized, Rust won’t just let us dereference the location of memory to move\\nthe value out, because that would leave the memory uninitialized! For this we\\nneed ptr::read, which just copies out the bits from the target address and\\ninterprets it as a value of type T. This will leave the memory at this address\\nlogically uninitialized, even though there is in fact a perfectly good instance\\nof T there. For pop, if the old len is 1, for example, we want to read out of the 0th\\nindex. So we should offset by the new len. pub fn pop(&mut self) -> Option<T> { if self.len == 0 { None } else { self.len -= 1; unsafe { Some(ptr::read(self.ptr.as_ptr().add(self.len))) } }\\n}","breadcrumbs":"Implementing Vec » Push and Pop » Push and Pop","id":"83","title":"Push and Pop"},"84":{"body":"Next we should implement Drop so that we don’t massively leak tons of resources.\\nThe easiest way is to just call pop until it yields None, and then deallocate\\nour buffer. Note that calling pop is unneeded if T: !Drop. In theory we can\\nask Rust if T needs_drop and omit the calls to pop. However in practice\\nLLVM is really good at removing simple side-effect free code like this, so I\\nwouldn’t bother unless you notice it’s not being stripped (in this case it is). We must not call alloc::dealloc when self.cap == 0, as in this case we\\nhaven’t actually allocated any memory. impl<T> Drop for Vec<T> { fn drop(&mut self) { if self.cap != 0 { while let Some(_) = self.pop() { } let layout = Layout::array::<T>(self.cap).unwrap(); unsafe { alloc::dealloc(self.ptr.as_ptr() as *mut u8, layout); } } }\\n}","breadcrumbs":"Implementing Vec » Deallocating » Deallocating","id":"84","title":"Deallocating"},"85":{"body":"Alright! We’ve got a decent minimal stack implemented. We can push, we can\\npop, and we can clean up after ourselves. However there’s a whole mess of\\nfunctionality we’d reasonably want. In particular, we have a proper array, but\\nnone of the slice functionality. That’s actually pretty easy to solve: we can\\nimplement Deref<Target=[T]>. This will magically make our Vec coerce to, and\\nbehave like, a slice in all sorts of conditions. All we need is slice::from_raw_parts. It will correctly handle empty slices\\nfor us. Later once we set up zero-sized type support it will also Just Work\\nfor those too. use std::ops::Deref; impl<T> Deref for Vec<T> { type Target = [T]; fn deref(&self) -> &[T] { unsafe { std::slice::from_raw_parts(self.ptr.as_ptr(), self.len) } }\\n} And let’s do DerefMut too: use std::ops::DerefMut; impl<T> DerefMut for Vec<T> { fn deref_mut(&mut self) -> &mut [T] { unsafe { std::slice::from_raw_parts_mut(self.ptr.as_ptr(), self.len) } }\\n} Now we have len, first, last, indexing, slicing, sorting, iter, iter_mut, and all other sorts of bells and whistles provided by slice. Sweet!","breadcrumbs":"Implementing Vec » Deref » Deref","id":"85","title":"Deref"},"86":{"body":"Something not provided by slice is insert and remove, so let’s do those\\nnext. Insert needs to shift all the elements at the target index to the right by one.\\nTo do this we need to use ptr::copy, which is our version of C’s memmove.\\nThis copies some chunk of memory from one location to another, correctly\\nhandling the case where the source and destination overlap (which will\\ndefinitely happen here). If we insert at index i, we want to shift the [i .. len] to [i+1 .. len+1]\\nusing the old len. pub fn insert(&mut self, index: usize, elem: T) { // Note: `<=` because it\'s valid to insert after everything // which would be equivalent to push. assert!(index <= self.len, \\"index out of bounds\\"); if self.len == self.cap { self.grow(); } unsafe { // ptr::copy(src, dest, len): \\"copy from src to dest len elems\\" ptr::copy( self.ptr.as_ptr().add(index), self.ptr.as_ptr().add(index + 1), self.len - index, ); ptr::write(self.ptr.as_ptr().add(index), elem); } self.len += 1;\\n} Remove behaves in the opposite manner. We need to shift all the elements from [i+1 .. len + 1] to [i .. len] using the new len. pub fn remove(&mut self, index: usize) -> T { // Note: `<` because it\'s *not* valid to remove after everything assert!(index < self.len, \\"index out of bounds\\"); unsafe { self.len -= 1; let result = ptr::read(self.ptr.as_ptr().add(index)); ptr::copy( self.ptr.as_ptr().add(index + 1), self.ptr.as_ptr().add(index), self.len - index, ); result }\\n}","breadcrumbs":"Implementing Vec » Insert and Remove » Insert and Remove","id":"86","title":"Insert and Remove"},"87":{"body":"Let’s move on to writing iterators. iter and iter_mut have already been\\nwritten for us thanks to The Magic of Deref. However there’s two interesting\\niterators that Vec provides that slices can’t: into_iter and drain. IntoIter consumes the Vec by-value, and can consequently yield its elements\\nby-value. In order to enable this, IntoIter needs to take control of Vec’s\\nallocation. IntoIter needs to be DoubleEnded as well, to enable reading from both ends.\\nReading from the back could just be implemented as calling pop, but reading\\nfrom the front is harder. We could call remove(0) but that would be insanely\\nexpensive. Instead we’re going to just use ptr::read to copy values out of\\neither end of the Vec without mutating the buffer at all. To do this we’re going to use a very common C idiom for array iteration. We’ll\\nmake two pointers; one that points to the start of the array, and one that\\npoints to one-element past the end. When we want an element from one end, we’ll\\nread out the value pointed to at that end and move the pointer over by one. When\\nthe two pointers are equal, we know we’re done. Note that the order of read and offset are reversed for next and next_back\\nFor next_back the pointer is always after the element it wants to read next,\\nwhile for next the pointer is always at the element it wants to read next.\\nTo see why this is, consider the case where every element but one has been\\nyielded. The array looks like this: S E\\n[X, X, X, O, X, X, X] If E pointed directly at the element it wanted to yield next, it would be\\nindistinguishable from the case where there are no more elements to yield. Although we don’t actually care about it during iteration, we also need to hold\\nonto the Vec’s allocation information in order to free it once IntoIter is\\ndropped. So we’re going to use the following struct: pub struct IntoIter<T> { buf: NonNull<T>, cap: usize, start: *const T, end: *const T,\\n} And this is what we end up with for initialization: impl<T> IntoIterator for Vec<T> { type Item = T; type IntoIter = IntoIter<T>; fn into_iter(self) -> IntoIter<T> { // Make sure not to drop Vec since that would free the buffer let vec = ManuallyDrop::new(self); // Can\'t destructure Vec since it\'s Drop let ptr = vec.ptr; let cap = vec.cap; let len = vec.len; IntoIter { buf: ptr, cap, start: ptr.as_ptr(), end: if cap == 0 { // can\'t offset off this pointer, it\'s not allocated! ptr.as_ptr() } else { unsafe { ptr.as_ptr().add(len) } }, } }\\n} Here’s iterating forward: impl<T> Iterator for IntoIter<T> { type Item = T; fn next(&mut self) -> Option<T> { if self.start == self.end { None } else { unsafe { let result = ptr::read(self.start); self.start = self.start.offset(1); Some(result) } } } fn size_hint(&self) -> (usize, Option<usize>) { let len = (self.end as usize - self.start as usize) / mem::size_of::<T>(); (len, Some(len)) }\\n} And here’s iterating backwards. impl<T> DoubleEndedIterator for IntoIter<T> { fn next_back(&mut self) -> Option<T> { if self.start == self.end { None } else { unsafe { self.end = self.end.offset(-1); Some(ptr::read(self.end)) } } }\\n} Because IntoIter takes ownership of its allocation, it needs to implement Drop\\nto free it. However it also wants to implement Drop to drop any elements it\\ncontains that weren’t yielded. impl<T> Drop for IntoIter<T> { fn drop(&mut self) { if self.cap != 0 { // drop any remaining elements for _ in &mut *self {} let layout = Layout::array::<T>(self.cap).unwrap(); unsafe { alloc::dealloc(self.buf.as_ptr() as *mut u8, layout); } } }\\n}","breadcrumbs":"Implementing Vec » IntoIter » IntoIter","id":"87","title":"IntoIter"},"88":{"body":"We’ve actually reached an interesting situation here: we’ve duplicated the logic\\nfor specifying a buffer and freeing its memory in Vec and IntoIter. Now that\\nwe’ve implemented it and identified actual logic duplication, this is a good\\ntime to perform some logic compression. We’re going to abstract out the (ptr, cap) pair and give them the logic for\\nallocating, growing, and freeing: struct RawVec<T> { ptr: NonNull<T>, cap: usize,\\n} unsafe impl<T: Send> Send for RawVec<T> {}\\nunsafe impl<T: Sync> Sync for RawVec<T> {} impl<T> RawVec<T> { fn new() -> Self { assert!(mem::size_of::<T>() != 0, \\"TODO: implement ZST support\\"); RawVec { ptr: NonNull::dangling(), cap: 0, } } fn grow(&mut self) { // This can\'t overflow because we ensure self.cap <= isize::MAX. let new_cap = if self.cap == 0 { 1 } else { 2 * self.cap }; // Layout::array checks that the number of bytes is <= usize::MAX, // but this is redundant since old_layout.size() <= isize::MAX, // so the `unwrap` should never fail. let new_layout = Layout::array::<T>(new_cap).unwrap(); // Ensure that the new allocation doesn\'t exceed `isize::MAX` bytes. assert!(new_layout.size() <= isize::MAX as usize, \\"Allocation too large\\"); let new_ptr = if self.cap == 0 { unsafe { alloc::alloc(new_layout) } } else { let old_layout = Layout::array::<T>(self.cap).unwrap(); let old_ptr = self.ptr.as_ptr() as *mut u8; unsafe { alloc::realloc(old_ptr, old_layout, new_layout.size()) } }; // If allocation fails, `new_ptr` will be null, in which case we abort. self.ptr = match NonNull::new(new_ptr as *mut T) { Some(p) => p, None => alloc::handle_alloc_error(new_layout), }; self.cap = new_cap; }\\n} impl<T> Drop for RawVec<T> { fn drop(&mut self) { if self.cap != 0 { let layout = Layout::array::<T>(self.cap).unwrap(); unsafe { alloc::dealloc(self.ptr.as_ptr() as *mut u8, layout); } } }\\n} And change Vec as follows: pub struct Vec<T> { buf: RawVec<T>, len: usize,\\n} impl<T> Vec<T> { fn ptr(&self) -> *mut T { self.buf.ptr.as_ptr() } fn cap(&self) -> usize { self.buf.cap } pub fn new() -> Self { Vec { buf: RawVec::new(), len: 0, } } // push/pop/insert/remove largely unchanged: // * `self.ptr.as_ptr() -> self.ptr()` // * `self.cap -> self.cap()` // * `self.grow() -> self.buf.grow()`\\n} impl<T> Drop for Vec<T> { fn drop(&mut self) { while let Some(_) = self.pop() {} // deallocation is handled by RawVec }\\n} And finally we can really simplify IntoIter: pub struct IntoIter<T> { _buf: RawVec<T>, // we don\'t actually care about this. Just need it to live. start: *const T, end: *const T,\\n} // next and next_back literally unchanged since they never referred to the buf impl<T> Drop for IntoIter<T> { fn drop(&mut self) { // only need to ensure all our elements are read; // buffer will clean itself up afterwards. for _ in &mut *self {} }\\n} impl<T> IntoIterator for Vec<T> { type Item = T; type IntoIter = IntoIter<T>; fn into_iter(self) -> IntoIter<T> { // need to use ptr::read to unsafely move the buf out since it\'s // not Copy, and Vec implements Drop (so we can\'t destructure it). let buf = unsafe { ptr::read(&self.buf) }; let len = self.len; mem::forget(self); IntoIter { start: buf.ptr.as_ptr(), end: if buf.cap == 0 { // can\'t offset off of a pointer unless it\'s part of an allocation buf.ptr.as_ptr() } else { unsafe { buf.ptr.as_ptr().add(len) } }, _buf: buf, } }\\n} Much better.","breadcrumbs":"Implementing Vec » RawVec » RawVec","id":"88","title":"RawVec"},"89":{"body":"Let’s move on to Drain. Drain is largely the same as IntoIter, except that\\ninstead of consuming the Vec, it borrows the Vec and leaves its allocation\\nuntouched. For now we’ll only implement the “basic” full-range version. use std::marker::PhantomData; struct Drain<\'a, T: \'a> { // Need to bound the lifetime here, so we do it with `&\'a mut Vec<T>` // because that\'s semantically what we contain. We\'re \\"just\\" calling // `pop()` and `remove(0)`. vec: PhantomData<&\'a mut Vec<T>>, start: *const T, end: *const T,\\n} impl<\'a, T> Iterator for Drain<\'a, T> { type Item = T; fn next(&mut self) -> Option<T> { if self.start == self.end { None – wait, this is seeming familiar. Let’s do some more compression. Both\\nIntoIter and Drain have the exact same structure, let’s just factor it out. struct RawValIter<T> { start: *const T, end: *const T,\\n} impl<T> RawValIter<T> { // unsafe to construct because it has no associated lifetimes. // This is necessary to store a RawValIter in the same struct as // its actual allocation. OK since it\'s a private implementation // detail. unsafe fn new(slice: &[T]) -> Self { RawValIter { start: slice.as_ptr(), end: if slice.len() == 0 { // if `len = 0`, then this is not actually allocated memory. // Need to avoid offsetting because that will give wrong // information to LLVM via GEP. slice.as_ptr() } else { slice.as_ptr().add(slice.len()) } } }\\n} // Iterator and DoubleEndedIterator impls identical to IntoIter. And IntoIter becomes the following: pub struct IntoIter<T> { _buf: RawVec<T>, // we don\'t actually care about this. Just need it to live. iter: RawValIter<T>,\\n} impl<T> Iterator for IntoIter<T> { type Item = T; fn next(&mut self) -> Option<T> { self.iter.next() } fn size_hint(&self) -> (usize, Option<usize>) { self.iter.size_hint() }\\n} impl<T> DoubleEndedIterator for IntoIter<T> { fn next_back(&mut self) -> Option<T> { self.iter.next_back() }\\n} impl<T> Drop for IntoIter<T> { fn drop(&mut self) { for _ in &mut *self {} }\\n} impl<T> IntoIterator for Vec<T> { type Item = T; type IntoIter = IntoIter<T>; fn into_iter(self) -> IntoIter<T> { unsafe { let iter = RawValIter::new(&self); let buf = ptr::read(&self.buf); mem::forget(self); IntoIter { iter, _buf: buf, } } }\\n} Note that I’ve left a few quirks in this design to make upgrading Drain to work\\nwith arbitrary subranges a bit easier. In particular we could have RawValIter\\ndrain itself on drop, but that won’t work right for a more complex Drain.\\nWe also take a slice to simplify Drain initialization. Alright, now Drain is really easy: use std::marker::PhantomData; pub struct Drain<\'a, T: \'a> { vec: PhantomData<&\'a mut Vec<T>>, iter: RawValIter<T>,\\n} impl<\'a, T> Iterator for Drain<\'a, T> { type Item = T; fn next(&mut self) -> Option<T> { self.iter.next() } fn size_hint(&self) -> (usize, Option<usize>) { self.iter.size_hint() }\\n} impl<\'a, T> DoubleEndedIterator for Drain<\'a, T> { fn next_back(&mut self) -> Option<T> { self.iter.next_back() }\\n} impl<\'a, T> Drop for Drain<\'a, T> { fn drop(&mut self) { for _ in &mut *self {} }\\n} impl<T> Vec<T> { pub fn drain(&mut self) -> Drain<T> { let iter = unsafe { RawValIter::new(&self) }; // this is a mem::forget safety thing. If Drain is forgotten, we just // leak the whole Vec\'s contents. Also we need to do this *eventually* // anyway, so why not do it now? self.len = 0; Drain { iter, vec: PhantomData, } }\\n} For more details on the mem::forget problem, see the section on leaks.","breadcrumbs":"Implementing Vec » Drain » Drain","id":"89","title":"Drain"},"9":{"body":"Rust supports Dynamically Sized Types (DSTs): types without a statically\\nknown size or alignment. On the surface, this is a bit nonsensical: Rust must\\nknow the size and alignment of something in order to correctly work with it! In\\nthis regard, DSTs are not normal types. Since they lack a statically known\\nsize, these types can only exist behind a pointer. Any pointer to a\\nDST consequently becomes a wide pointer consisting of the pointer and the\\ninformation that “completes” them (more on this below). There are two major DSTs exposed by the language: trait objects: dyn MyTrait slices: [T], str, and others A trait object represents some type that implements the traits it specifies.\\nThe exact original type is erased in favor of runtime reflection\\nwith a vtable containing all the information necessary to use the type.\\nThe information that completes a trait object pointer is the vtable pointer.\\nThe runtime size of the pointee can be dynamically requested from the vtable. A slice is simply a view into some contiguous storage – typically an array or Vec. The information that completes a slice pointer is just the number of elements\\nit points to. The runtime size of the pointee is just the statically known size\\nof an element multiplied by the number of elements. Structs can actually store a single DST directly as their last field, but this\\nmakes them a DST as well: #![allow(unused)] fn main() {\\n// Can\'t be stored on the stack directly\\nstruct MySuperSlice { info: u32, data: [u8],\\n} } Unfortunately, such a type is largely useless without a way to construct it. Currently the\\nonly properly supported way to create a custom DST is by making your type generic\\nand performing an unsizing coercion: struct MySuperSliceable<T: ?Sized> { info: u32, data: T,\\n} fn main() { let sized: MySuperSliceable<[u8; 8]> = MySuperSliceable { info: 17, data: [0; 8], }; let dynamic: &MySuperSliceable<[u8]> = &sized; // prints: \\"17 [0, 0, 0, 0, 0, 0, 0, 0]\\" println!(\\"{} {:?}\\", dynamic.info, &dynamic.data);\\n} (Yes, custom DSTs are a largely half-baked feature for now.)","breadcrumbs":"Data Layout » Exotically Sized Types » Dynamically Sized Types (DSTs)","id":"9","title":"Dynamically Sized Types (DSTs)"},"90":{"body":"It’s time. We’re going to fight the specter that is zero-sized types. Safe Rust never needs to care about this, but Vec is very intensive on raw pointers and\\nraw allocations, which are exactly the two things that care about\\nzero-sized types. We need to be careful of two things: The raw allocator API has undefined behavior if you pass in 0 for an\\nallocation size. raw pointer offsets are no-ops for zero-sized types, which will break our\\nC-style pointer iterator. Thankfully we abstracted out pointer-iterators and allocating handling into RawValIter and RawVec respectively. How mysteriously convenient.","breadcrumbs":"Implementing Vec » Handling Zero-Sized Types » Handling Zero-Sized Types","id":"90","title":"Handling Zero-Sized Types"},"91":{"body":"So if the allocator API doesn’t support zero-sized allocations, what on earth\\ndo we store as our allocation? NonNull::dangling() of course! Almost every operation\\nwith a ZST is a no-op since ZSTs have exactly one value, and therefore no state needs\\nto be considered to store or load them. This actually extends to ptr::read and ptr::write: they won’t actually look at the pointer at all. As such we never need\\nto change the pointer. Note however that our previous reliance on running out of memory before overflow is\\nno longer valid with zero-sized types. We must explicitly guard against capacity\\noverflow for zero-sized types. Due to our current architecture, all this means is writing 3 guards, one in each\\nmethod of RawVec. impl<T> RawVec<T> { fn new() -> Self { // This branch should be stripped at compile time. let cap = if mem::size_of::<T>() == 0 { usize::MAX } else { 0 }; // `NonNull::dangling()` doubles as \\"unallocated\\" and \\"zero-sized allocation\\" RawVec { ptr: NonNull::dangling(), cap, } } fn grow(&mut self) { // since we set the capacity to usize::MAX when T has size 0, // getting to here necessarily means the Vec is overfull. assert!(mem::size_of::<T>() != 0, \\"capacity overflow\\"); let (new_cap, new_layout) = if self.cap == 0 { (1, Layout::array::<T>(1).unwrap()) } else { // This can\'t overflow because we ensure self.cap <= isize::MAX. let new_cap = 2 * self.cap; // `Layout::array` checks that the number of bytes is <= usize::MAX, // but this is redundant since old_layout.size() <= isize::MAX, // so the `unwrap` should never fail. let new_layout = Layout::array::<T>(new_cap).unwrap(); (new_cap, new_layout) }; // Ensure that the new allocation doesn\'t exceed `isize::MAX` bytes. assert!(new_layout.size() <= isize::MAX as usize, \\"Allocation too large\\"); let new_ptr = if self.cap == 0 { unsafe { alloc::alloc(new_layout) } } else { let old_layout = Layout::array::<T>(self.cap).unwrap(); let old_ptr = self.ptr.as_ptr() as *mut u8; unsafe { alloc::realloc(old_ptr, old_layout, new_layout.size()) } }; // If allocation fails, `new_ptr` will be null, in which case we abort. self.ptr = match NonNull::new(new_ptr as *mut T) { Some(p) => p, None => alloc::handle_alloc_error(new_layout), }; self.cap = new_cap; }\\n} impl<T> Drop for RawVec<T> { fn drop(&mut self) { let elem_size = mem::size_of::<T>(); if self.cap != 0 && elem_size != 0 { unsafe { alloc::dealloc( self.ptr.as_ptr() as *mut u8, Layout::array::<T>(self.cap).unwrap(), ); } } }\\n} That’s it. We support pushing and popping zero-sized types now. Our iterators\\n(that aren’t provided by slice Deref) are still busted, though.","breadcrumbs":"Implementing Vec » Handling Zero-Sized Types » Allocating Zero-Sized Types","id":"91","title":"Allocating Zero-Sized Types"},"92":{"body":"Zero-sized offsets are no-ops. This means that our current design will always\\ninitialize start and end as the same value, and our iterators will yield\\nnothing. The current solution to this is to cast the pointers to integers,\\nincrement, and then cast them back: impl<T> RawValIter<T> { unsafe fn new(slice: &[T]) -> Self { RawValIter { start: slice.as_ptr(), end: if mem::size_of::<T>() == 0 { ((slice.as_ptr() as usize) + slice.len()) as *const _ } else if slice.len() == 0 { slice.as_ptr() } else { slice.as_ptr().add(slice.len()) }, } }\\n} Now we have a different bug. Instead of our iterators not running at all, our\\niterators now run forever. We need to do the same trick in our iterator impls.\\nAlso, our size_hint computation code will divide by 0 for ZSTs. Since we’ll\\nbasically be treating the two pointers as if they point to bytes, we’ll just\\nmap size 0 to divide by 1. Here’s what next will be: fn next(&mut self) -> Option<T> { if self.start == self.end { None } else { unsafe { let result = ptr::read(self.start); self.start = if mem::size_of::<T>() == 0 { (self.start as usize + 1) as *const _ } else { self.start.offset(1) }; Some(result) } }\\n} Do you see the “bug”? No one else did! The original author only noticed the\\nproblem when linking to this page years later. This code is kind of dubious\\nbecause abusing the iterator pointers to be counters makes them unaligned!\\nOur one job when using ZSTs is to keep pointers aligned! forehead slap Raw pointers don’t need to be aligned at all times, so the basic trick of\\nusing pointers as counters is fine, but they should definitely be aligned\\nwhen passed to ptr::read! This is possibly needless pedantry\\nbecause ptr::read is a noop for a ZST, but let’s be a little more\\nresponsible and read from NonNull::dangling on the ZST path. (Alternatively you could call read_unaligned on the ZST path. Either is fine,\\nbecause either way we’re making up a value from nothing and it all compiles\\nto doing nothing.) impl<T> Iterator for RawValIter<T> { type Item = T; fn next(&mut self) -> Option<T> { if self.start == self.end { None } else { unsafe { if mem::size_of::<T>() == 0 { self.start = (self.start as usize + 1) as *const _; Some(ptr::read(NonNull::<T>::dangling().as_ptr())) } else { let old_ptr = self.start; self.start = self.start.offset(1); Some(ptr::read(old_ptr)) } } } } fn size_hint(&self) -> (usize, Option<usize>) { let elem_size = mem::size_of::<T>(); let len = (self.end as usize - self.start as usize) / if elem_size == 0 { 1 } else { elem_size }; (len, Some(len)) }\\n} impl<T> DoubleEndedIterator for RawValIter<T> { fn next_back(&mut self) -> Option<T> { if self.start == self.end { None } else { unsafe { if mem::size_of::<T>() == 0 { self.end = (self.end as usize - 1) as *const _; Some(ptr::read(NonNull::<T>::dangling().as_ptr())) } else { self.end = self.end.offset(-1); Some(ptr::read(self.end)) } } } }\\n} And that’s it. Iteration works! One last thing we need to consider is that when our vector is dropped, it deallocates the memory that was allocated while it was alive. With ZSTs, we didn’t allocate any memory; in fact, we never do. So, right now, our code has unsoundness: we’re still trying to deallocate a NonNull::dangling() pointer that we use to simulate the ZST in our vector. This means we’d cause undefined behavior if we tried to deallocate something we never allocated (obviously, and for good reasons). To fix this, in our RawVec’s Drop trait, we’re going to tweak it to ensure we only deallocate types that are sized. impl<T> Drop for RawVec<T> { fn drop(&mut self) { println!(\\"RawVec<T> Drop called, deallocating memory\\"); if self.cap != 0 && std::mem::size_of::<T>() > 0 { let layout = std::alloc::Layout::array::<T>(self.cap).unwrap(); unsafe { std::alloc::dealloc(self.ptr.as_ptr() as *mut _, layout); } } }\\n}","breadcrumbs":"Implementing Vec » Handling Zero-Sized Types » Iterating Zero-Sized Types","id":"92","title":"Iterating Zero-Sized Types"},"93":{"body":"use std::alloc::{self, Layout};\\nuse std::marker::PhantomData;\\nuse std::mem;\\nuse std::ops::{Deref, DerefMut};\\nuse std::ptr::{self, NonNull}; struct RawVec<T> { ptr: NonNull<T>, cap: usize,\\n} unsafe impl<T: Send> Send for RawVec<T> {}\\nunsafe impl<T: Sync> Sync for RawVec<T> {} impl<T> RawVec<T> { fn new() -> Self { // !0 is usize::MAX. This branch should be stripped at compile time. let cap = if mem::size_of::<T>() == 0 { !0 } else { 0 }; // `NonNull::dangling()` doubles as \\"unallocated\\" and \\"zero-sized allocation\\" RawVec { ptr: NonNull::dangling(), cap, } } fn grow(&mut self) { // since we set the capacity to usize::MAX when T has size 0, // getting to here necessarily means the Vec is overfull. assert!(mem::size_of::<T>() != 0, \\"capacity overflow\\"); let (new_cap, new_layout) = if self.cap == 0 { (1, Layout::array::<T>(1)) } else { // This can\'t overflow since self.cap <= isize::MAX. let new_cap = 2 * self.cap; (new_cap, Layout::array::<T>(new_cap)) }; // `Layout::array` checks that the number of bytes allocated is // in 1..=isize::MAX and will error otherwise. An allocation of // 0 bytes isn\'t possible thanks to the above condition. let new_layout = new_layout.expect(\\"Allocation too large\\"); let new_ptr = if self.cap == 0 { unsafe { alloc::alloc(new_layout) } } else { let old_layout = Layout::array::<T>(self.cap).unwrap(); let old_ptr = self.ptr.as_ptr() as *mut u8; unsafe { alloc::realloc(old_ptr, old_layout, new_layout.size()) } }; // If allocation fails, `new_ptr` will be null, in which case we abort. self.ptr = match NonNull::new(new_ptr as *mut T) { Some(p) => p, None => alloc::handle_alloc_error(new_layout), }; self.cap = new_cap; }\\n} impl<T> Drop for RawVec<T> { fn drop(&mut self) { let elem_size = mem::size_of::<T>(); if self.cap != 0 && elem_size != 0 { unsafe { alloc::dealloc( self.ptr.as_ptr() as *mut u8, Layout::array::<T>(self.cap).unwrap(), ); } } }\\n} pub struct Vec<T> { buf: RawVec<T>, len: usize,\\n} impl<T> Vec<T> { fn ptr(&self) -> *mut T { self.buf.ptr.as_ptr() } fn cap(&self) -> usize { self.buf.cap } pub fn new() -> Self { Vec { buf: RawVec::new(), len: 0, } } pub fn push(&mut self, elem: T) { if self.len == self.cap() { self.buf.grow(); } unsafe { ptr::write(self.ptr().add(self.len), elem); } // Can\'t overflow, we\'ll OOM first. self.len += 1; } pub fn pop(&mut self) -> Option<T> { if self.len == 0 { None } else { self.len -= 1; unsafe { Some(ptr::read(self.ptr().add(self.len))) } } } pub fn insert(&mut self, index: usize, elem: T) { assert!(index <= self.len, \\"index out of bounds\\"); if self.len == self.cap() { self.buf.grow(); } unsafe { ptr::copy( self.ptr().add(index), self.ptr().add(index + 1), self.len - index, ); ptr::write(self.ptr().add(index), elem); } self.len += 1; } pub fn remove(&mut self, index: usize) -> T { assert!(index < self.len, \\"index out of bounds\\"); self.len -= 1; unsafe { let result = ptr::read(self.ptr().add(index)); ptr::copy( self.ptr().add(index + 1), self.ptr().add(index), self.len - index, ); result } } pub fn drain(&mut self) -> Drain<T> { let iter = unsafe { RawValIter::new(&self) }; // this is a mem::forget safety thing. If Drain is forgotten, we just // leak the whole Vec\'s contents. Also we need to do this *eventually* // anyway, so why not do it now? self.len = 0; Drain { iter, vec: PhantomData, } }\\n} impl<T> Drop for Vec<T> { fn drop(&mut self) { while let Some(_) = self.pop() {} // deallocation is handled by RawVec }\\n} impl<T> Deref for Vec<T> { type Target = [T]; fn deref(&self) -> &[T] { unsafe { std::slice::from_raw_parts(self.ptr(), self.len) } }\\n} impl<T> DerefMut for Vec<T> { fn deref_mut(&mut self) -> &mut [T] { unsafe { std::slice::from_raw_parts_mut(self.ptr(), self.len) } }\\n} impl<T> IntoIterator for Vec<T> { type Item = T; type IntoIter = IntoIter<T>; fn into_iter(self) -> IntoIter<T> { let (iter, buf) = unsafe { (RawValIter::new(&self), ptr::read(&self.buf)) }; mem::forget(self); IntoIter { iter, _buf: buf, } }\\n} struct RawValIter<T> { start: *const T, end: *const T,\\n} impl<T> RawValIter<T> { unsafe fn new(slice: &[T]) -> Self { RawValIter { start: slice.as_ptr(), end: if mem::size_of::<T>() == 0 { ((slice.as_ptr() as usize) + slice.len()) as *const _ } else if slice.len() == 0 { slice.as_ptr() } else { slice.as_ptr().add(slice.len()) }, } }\\n} impl<T> Iterator for RawValIter<T> { type Item = T; fn next(&mut self) -> Option<T> { if self.start == self.end { None } else { unsafe { if mem::size_of::<T>() == 0 { self.start = (self.start as usize + 1) as *const _; Some(ptr::read(NonNull::<T>::dangling().as_ptr())) } else { let old_ptr = self.start; self.start = self.start.offset(1); Some(ptr::read(old_ptr)) } } } } fn size_hint(&self) -> (usize, Option<usize>) { let elem_size = mem::size_of::<T>(); let len = (self.end as usize - self.start as usize) / if elem_size == 0 { 1 } else { elem_size }; (len, Some(len)) }\\n} impl<T> DoubleEndedIterator for RawValIter<T> { fn next_back(&mut self) -> Option<T> { if self.start == self.end { None } else { unsafe { if mem::size_of::<T>() == 0 { self.end = (self.end as usize - 1) as *const _; Some(ptr::read(NonNull::<T>::dangling().as_ptr())) } else { self.end = self.end.offset(-1); Some(ptr::read(self.end)) } } } }\\n} pub struct IntoIter<T> { _buf: RawVec<T>, // we don\'t actually care about this. Just need it to live. iter: RawValIter<T>,\\n} impl<T> Iterator for IntoIter<T> { type Item = T; fn next(&mut self) -> Option<T> { self.iter.next() } fn size_hint(&self) -> (usize, Option<usize>) { self.iter.size_hint() }\\n} impl<T> DoubleEndedIterator for IntoIter<T> { fn next_back(&mut self) -> Option<T> { self.iter.next_back() }\\n} impl<T> Drop for IntoIter<T> { fn drop(&mut self) { for _ in &mut *self {} }\\n} pub struct Drain<\'a, T: \'a> { vec: PhantomData<&\'a mut Vec<T>>, iter: RawValIter<T>,\\n} impl<\'a, T> Iterator for Drain<\'a, T> { type Item = T; fn next(&mut self) -> Option<T> { self.iter.next() } fn size_hint(&self) -> (usize, Option<usize>) { self.iter.size_hint() }\\n} impl<\'a, T> DoubleEndedIterator for Drain<\'a, T> { fn next_back(&mut self) -> Option<T> { self.iter.next_back() }\\n} impl<\'a, T> Drop for Drain<\'a, T> { fn drop(&mut self) { // pre-drain the iter for _ in &mut *self {} }\\n} fn main() { tests::create_push_pop(); tests::iter_test(); tests::test_drain(); tests::test_zst(); println!(\\"All tests finished OK\\"); } mod tests { use super::*; pub fn create_push_pop() { let mut v = Vec::new(); v.push(1); assert_eq!(1, v.len()); assert_eq!(1, v[0]); for i in v.iter_mut() { *i += 1; } v.insert(0, 5); let x = v.pop(); assert_eq!(Some(2), x); assert_eq!(1, v.len()); v.push(10); let x = v.remove(0); assert_eq!(5, x); assert_eq!(1, v.len()); } pub fn iter_test() { let mut v = Vec::new(); for i in 0..10 { v.push(Box::new(i)) } let mut iter = v.into_iter(); let first = iter.next().unwrap(); let last = iter.next_back().unwrap(); drop(iter); assert_eq!(0, *first); assert_eq!(9, *last); } pub fn test_drain() { let mut v = Vec::new(); for i in 0..10 { v.push(Box::new(i)) } { let mut drain = v.drain(); let first = drain.next().unwrap(); let last = drain.next_back().unwrap(); assert_eq!(0, *first); assert_eq!(9, *last); } assert_eq!(0, v.len()); v.push(Box::new(1)); assert_eq!(1, *v.pop().unwrap()); } pub fn test_zst() { let mut v = Vec::new(); for _i in 0..10 { v.push(()) } let mut count = 0; for _ in v.into_iter() { count += 1 } assert_eq!(10, count); } }","breadcrumbs":"Implementing Vec » Final Code » The Final Code","id":"93","title":"The Final Code"},"94":{"body":"Knowing the theory is all fine and good, but the best way to understand\\nsomething is to use it. To better understand atomics and interior mutability,\\nwe’ll be implementing versions of the standard library’s Arc and Mutex types. TODO: Write Mutex chapters.","breadcrumbs":"Implementing Arc and Mutex » Implementing Arc and Mutex","id":"94","title":"Implementing Arc and Mutex"},"95":{"body":"In this section, we’ll be implementing a simpler version of std::sync::Arc.\\nSimilarly to the implementation of Vec we made earlier, we won’t be\\ntaking advantage of as many optimizations, intrinsics, or unstable code as the\\nstandard library may. This implementation is loosely based on the standard library’s implementation\\n(technically taken from alloc::sync in 1.49, as that’s where it’s actually\\nimplemented), but it will not support weak references at the moment as they\\nmake the implementation slightly more complex. Please note that this section is very work-in-progress at the moment.","breadcrumbs":"Implementing Arc and Mutex » Arc » Implementing Arc","id":"95","title":"Implementing Arc"},"96":{"body":"Let’s start by making the layout for our implementation of Arc. An Arc<T> provides thread-safe shared ownership of a value of type T,\\nallocated in the heap. Sharing implies immutability in Rust, so we don’t need to\\ndesign anything that manages access to that value, right? Although interior\\nmutability types like Mutex allow Arc’s users to create shared mutability, Arc\\nitself doesn’t need to concern itself with these issues. However there is one place where Arc needs to concern itself with mutation:\\ndestruction. When all the owners of the Arc go away, we need to be able to drop its contents and free its allocation. So we need a way for an owner to\\nknow if it’s the last owner, and the simplest way to do that is with a count\\nof the owners – Reference Counting. Unfortunately, this reference count is inherently shared mutable state, so Arc does need to think about synchronization. We could use a Mutex for this, but\\nthat’s overkill. Instead, we’ll use atomics. And since everyone already needs a\\npointer to the T’s allocation, we might as well put the reference count in that\\nsame allocation. Naively, it would look something like this: #![allow(unused)] fn main() {\\nuse std::sync::atomic; pub struct Arc<T> { ptr: *mut ArcInner<T>,\\n} pub struct ArcInner<T> { rc: atomic::AtomicUsize, data: T,\\n} } This would compile, however it would be incorrect. First of all, the compiler\\nwill give us too strict variance. For example, an Arc<&\'static str> couldn’t\\nbe used where an Arc<&\'a str> was expected. More importantly, it will give\\nincorrect ownership information to the drop checker, as it will assume we don’t\\nown any values of type T. As this is a structure providing shared ownership of\\na value, at some point there will be an instance of this structure that entirely\\nowns its data. See the chapter on ownership and lifetimes for\\nall the details on variance and drop check. To fix the first problem, we can use NonNull<T>. Note that NonNull<T> is a\\nwrapper around a raw pointer that declares that: We are covariant over T Our pointer is never null To fix the second problem, we can include a PhantomData marker containing an ArcInner<T>. This will tell the drop checker that we have some notion of\\nownership of a value of ArcInner<T> (which itself contains some T). With these changes we get our final structure: #![allow(unused)] fn main() {\\nuse std::marker::PhantomData;\\nuse std::ptr::NonNull;\\nuse std::sync::atomic::AtomicUsize; pub struct Arc<T> { ptr: NonNull<ArcInner<T>>, phantom: PhantomData<ArcInner<T>>,\\n} pub struct ArcInner<T> { rc: AtomicUsize, data: T,\\n} }","breadcrumbs":"Implementing Arc and Mutex » Arc » Layout » Layout","id":"96","title":"Layout"},"97":{"body":"Now that we’ve decided the layout for our implementation of Arc, let’s create\\nsome basic code.","breadcrumbs":"Implementing Arc and Mutex » Arc » Base Code » Base Code","id":"97","title":"Base Code"},"98":{"body":"We’ll first need a way to construct an Arc<T>. This is pretty simple, as we just need to box the ArcInner<T> and get a NonNull<T> pointer to it. impl<T> Arc<T> { pub fn new(data: T) -> Arc<T> { // We start the reference count at 1, as that first reference is the // current pointer. let boxed = Box::new(ArcInner { rc: AtomicUsize::new(1), data, }); Arc { // It is okay to call `.unwrap()` here as we get a pointer from // `Box::into_raw` which is guaranteed to not be null. ptr: NonNull::new(Box::into_raw(boxed)).unwrap(), phantom: PhantomData, } }\\n}","breadcrumbs":"Implementing Arc and Mutex » Arc » Base Code » Constructing the Arc","id":"98","title":"Constructing the Arc"},"99":{"body":"Since we’re building a concurrency primitive, we’ll need to be able to send it\\nacross threads. Thus, we can implement the Send and Sync marker traits. For\\nmore information on these, see the section on Send and Sync. This is okay because: You can only get a mutable reference to the value inside an Arc if and only\\nif it is the only Arc referencing that data (which only happens in Drop) We use atomics for the shared mutable reference counting unsafe impl<T: Sync + Send> Send for Arc<T> {}\\nunsafe impl<T: Sync + Send> Sync for Arc<T> {} We need to have the bound T: Sync + Send because if we did not provide those\\nbounds, it would be possible to share values that are thread-unsafe across a\\nthread boundary via an Arc, which could possibly cause data races or\\nunsoundness. For example, if those bounds were not present, Arc<Rc<u32>> would be Sync or Send, meaning that you could clone the Rc out of the Arc to send it across\\na thread (without creating an entirely new Rc), which would create data races\\nas Rc is not thread-safe.","breadcrumbs":"Implementing Arc and Mutex » Arc » Base Code » Send and Sync","id":"99","title":"Send and Sync"}},"length":136,"save":true},"fields":["title","body","breadcrumbs"],"index":{"body":{"root":{"0":{".":{".":{"1":{"0":{"df":1,"docs":{"93":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"2":{".":{"0":{"df":1,"docs":{"108":{"tf":1.0}}},"1":{"4":{"6":{"df":1,"docs":{"133":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":37,"docs":{"10":{"tf":1.0},"111":{"tf":3.872983346207417},"115":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"123":{"tf":1.0},"129":{"tf":1.4142135623730951},"130":{"tf":1.0},"134":{"tf":1.0},"16":{"tf":1.0},"23":{"tf":2.0},"24":{"tf":1.0},"25":{"tf":1.0},"31":{"tf":1.7320508075688772},"4":{"tf":1.0},"43":{"tf":1.7320508075688772},"45":{"tf":1.0},"54":{"tf":1.4142135623730951},"58":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"65":{"tf":1.0},"67":{"tf":2.23606797749979},"7":{"tf":1.0},"72":{"tf":1.7320508075688772},"75":{"tf":1.0},"82":{"tf":3.605551275463989},"83":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951},"88":{"tf":2.6457513110645907},"89":{"tf":1.7320508075688772},"9":{"tf":3.0},"90":{"tf":1.0},"91":{"tf":2.8284271247461903},"92":{"tf":3.1622776601683795},"93":{"tf":4.47213595499958}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"83":{"tf":1.4142135623730951}}}},"x":{"0":{"0":{"df":1,"docs":{"82":{"tf":1.0}}},"1":{"df":1,"docs":{"82":{"tf":1.0}}},"d":{"df":1,"docs":{"111":{"tf":1.0}}},"df":1,"docs":{"4":{"tf":1.0}}},"1":{"0":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"4":{"tf":1.0}}}}}}},"df":0,"docs":{}},"a":{"b":{"a":{"d":{"1":{"d":{"df":0,"docs":{},"e":{"a":{"df":1,"docs":{"22":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"d":{"0":{"df":1,"docs":{"111":{"tf":1.0}}},"7":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"0":{"0":{"0":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"1":{".":{".":{"=":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"x":{"df":2,"docs":{"82":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"0":{"df":3,"docs":{"59":{"tf":1.0},"64":{"tf":1.4142135623730951},"69":{"tf":1.0}}},"2":{"9":{".":{"2":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"9":{"df":1,"docs":{"95":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"0":{"df":2,"docs":{"110":{"tf":1.0},"5":{"tf":1.0}}},"df":7,"docs":{"22":{"tf":3.0},"28":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"43":{"tf":1.0},"56":{"tf":1.0},"63":{"tf":1.0}}},"1":{"df":2,"docs":{"27":{"tf":1.0},"28":{"tf":1.0}}},"2":{"3":{"8":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"27":{"tf":1.0},"28":{"tf":1.0}}},"3":{"2":{"7":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"27":{"tf":1.0},"28":{"tf":1.0}}},"4":{"df":1,"docs":{"28":{"tf":1.0}}},"5":{"df":1,"docs":{"28":{"tf":1.0}}},"7":{"5":{"8":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"9":{"tf":1.4142135623730951}}},"8":{"5":{"7":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"df":1,"docs":{"35":{"tf":1.0}}},"df":28,"docs":{"102":{"tf":1.0},"104":{"tf":1.7320508075688772},"105":{"tf":1.4142135623730951},"116":{"tf":1.0},"117":{"tf":1.0},"130":{"tf":1.0},"22":{"tf":2.449489742783178},"31":{"tf":1.7320508075688772},"4":{"tf":1.0},"43":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"54":{"tf":1.7320508075688772},"58":{"tf":1.0},"62":{"tf":1.7320508075688772},"63":{"tf":1.4142135623730951},"67":{"tf":1.0},"7":{"tf":1.7320508075688772},"74":{"tf":1.4142135623730951},"75":{"tf":2.6457513110645907},"82":{"tf":1.4142135623730951},"83":{"tf":1.7320508075688772},"86":{"tf":2.23606797749979},"87":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":2.449489742783178},"93":{"tf":3.605551275463989},"98":{"tf":1.0}}},"2":{"0":{"1":{"8":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"2":{"1":{"df":1,"docs":{"131":{"tf":1.0}}},"4":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"124":{"tf":1.0},"22":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"35":{"tf":1.0}}},"4":{"2":{"9":{"2":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"4":{"5":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":20,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":3.0},"25":{"tf":1.4142135623730951},"26":{"tf":2.0},"27":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0},"54":{"tf":1.0},"63":{"tf":1.4142135623730951},"7":{"tf":2.0},"70":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"75":{"tf":2.6457513110645907},"82":{"tf":1.4142135623730951},"88":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0}}},"3":{"0":{"df":1,"docs":{"124":{"tf":1.0}}},"2":{"df":2,"docs":{"7":{"tf":1.7320508075688772},"82":{"tf":1.0}}},"df":15,"docs":{"19":{"tf":1.0},"25":{"tf":1.4142135623730951},"26":{"tf":2.0},"43":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":3.3166247903554},"52":{"tf":1.0},"54":{"tf":1.0},"63":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"75":{"tf":2.0},"82":{"tf":1.0},"91":{"tf":1.0}}},"4":{"0":{"df":1,"docs":{"124":{"tf":1.0}}},"8":{"df":1,"docs":{"82":{"tf":1.0}}},"df":7,"docs":{"25":{"tf":1.0},"28":{"tf":1.0},"43":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"7":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951}},"k":{"df":1,"docs":{"82":{"tf":1.0}}}},"5":{"0":{"df":1,"docs":{"124":{"tf":1.0}}},"df":6,"docs":{"117":{"tf":1.0},"128":{"tf":1.0},"22":{"tf":2.449489742783178},"43":{"tf":1.0},"63":{"tf":1.0},"93":{"tf":1.0}}},"6":{"4":{"df":2,"docs":{"103":{"tf":1.0},"82":{"tf":1.4142135623730951}}},"df":5,"docs":{"34":{"tf":1.0},"43":{"tf":1.0},"54":{"tf":1.0},"63":{"tf":1.0},"75":{"tf":1.0}}},"7":{"df":3,"docs":{"117":{"tf":1.4142135623730951},"63":{"tf":1.0},"82":{"tf":1.0}},"u":{"8":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}}},"8":{"df":2,"docs":{"63":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"9":{"9":{"df":1,"docs":{"33":{"tf":1.0}}},"df":5,"docs":{"103":{"tf":1.0},"28":{"tf":1.0},"34":{"tf":1.0},"45":{"tf":1.0},"63":{"tf":1.0}}},"_":{"0":{"df":1,"docs":{"135":{"tf":1.4142135623730951}}},"_":{"_":{"_":{"_":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"e":{"a":{"b":{"df":0,"docs":{},"i":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"134":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"v":{"df":1,"docs":{"134":{"tf":1.0}}}}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":3,"docs":{"88":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"131":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":9,"docs":{"111":{"tf":1.0},"135":{"tf":1.0},"36":{"tf":2.0},"67":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.4142135623730951},"92":{"tf":2.23606797749979},"93":{"tf":2.449489742783178}},"i":{"df":1,"docs":{"93":{"tf":1.0}}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"131":{"tf":1.4142135623730951},"39":{"tf":1.0}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"t":{"df":2,"docs":{"40":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"p":{"a":{"d":{"1":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}},"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"134":{"tf":1.0}}}}},"df":0,"docs":{}}}},"a":{"(":{"df":0,"docs":{},"u":{"3":{"2":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},".":{"df":0,"docs":{},"k":{".":{"a":{"df":2,"docs":{"2":{"tf":1.0},"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},">":{"(":{"&":{"\'":{"a":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"&":{"\'":{"a":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"v":{"df":0,"docs":{},"e":{"c":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"<":{"\'":{"a":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"p":{"c":{"df":1,"docs":{"122":{"tf":1.0}}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"i":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"122":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":9,"docs":{"110":{"tf":1.0},"122":{"tf":2.449489742783178},"125":{"tf":1.4142135623730951},"126":{"tf":2.8284271247461903},"129":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":2.0},"16":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":13,"docs":{"103":{"tf":1.0},"126":{"tf":1.4142135623730951},"129":{"tf":1.0},"130":{"tf":1.4142135623730951},"20":{"tf":1.0},"4":{"tf":1.0},"43":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.4142135623730951},"82":{"tf":1.7320508075688772},"88":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0}}}},"v":{"df":13,"docs":{"111":{"tf":1.0},"125":{"tf":1.0},"33":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"35":{"tf":1.7320508075688772},"36":{"tf":2.23606797749979},"4":{"tf":1.0},"41":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"56":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.0},"93":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"118":{"tf":1.0},"60":{"tf":1.0},"64":{"tf":1.0},"71":{"tf":1.0},"79":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":10,"docs":{"1":{"tf":1.0},"2":{"tf":1.0},"5":{"tf":1.0},"60":{"tf":1.0},"64":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"71":{"tf":1.0},"82":{"tf":1.0},"88":{"tf":1.0},"90":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"92":{"tf":1.0}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":9,"docs":{"119":{"tf":1.0},"12":{"tf":1.0},"124":{"tf":1.0},"19":{"tf":1.7320508075688772},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"41":{"tf":1.0},"61":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":25,"docs":{"103":{"tf":1.4142135623730951},"104":{"tf":1.7320508075688772},"105":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.0},"121":{"tf":1.4142135623730951},"16":{"tf":1.0},"22":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":2.6457513110645907},"36":{"tf":3.4641016151377544},"4":{"tf":1.4142135623730951},"5":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.7320508075688772},"70":{"tf":1.4142135623730951},"71":{"tf":1.0},"72":{"tf":2.23606797749979},"76":{"tf":3.4641016151377544},"77":{"tf":1.7320508075688772},"78":{"tf":2.6457513110645907},"79":{"tf":1.7320508075688772},"83":{"tf":1.0},"96":{"tf":1.0}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"131":{"tf":1.0},"35":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"40":{"tf":1.0}}}}}}}},"r":{"d":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"103":{"tf":1.0},"12":{"tf":1.0},"2":{"tf":1.0},"62":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":4,"docs":{"104":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.0},"124":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":7,"docs":{"104":{"tf":2.23606797749979},"57":{"tf":1.0},"60":{"tf":1.0},"72":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":3.4641016151377544},"79":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"57":{"tf":1.0},"78":{"tf":1.0}}}}}}}},"t":{"df":2,"docs":{"3":{"tf":1.0},"48":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":41,"docs":{"11":{"tf":2.23606797749979},"15":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.4142135623730951},"41":{"tf":1.0},"43":{"tf":2.23606797749979},"46":{"tf":1.7320508075688772},"48":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.4142135623730951},"55":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"64":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"75":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":2.449489742783178},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.7320508075688772},"89":{"tf":1.7320508075688772},"9":{"tf":1.0},"91":{"tf":1.4142135623730951},"93":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"d":{"df":12,"docs":{"103":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"111":{"tf":1.0},"114":{"tf":1.0},"12":{"tf":1.0},"131":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"46":{"tf":1.0},"66":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"59":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"t":{"df":3,"docs":{"15":{"tf":1.0},"4":{"tf":1.0},"68":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"134":{"tf":1.4142135623730951}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":6,"docs":{"118":{"tf":1.0},"36":{"tf":1.0},"56":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772},"82":{"tf":2.449489742783178},"83":{"tf":1.7320508075688772}}}}}}},"df":6,"docs":{"105":{"tf":1.0},"16":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"40":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"114":{"tf":1.0}}}}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"50":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":3,"docs":{"40":{"tf":1.0},"70":{"tf":1.0},"80":{"tf":1.4142135623730951}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":4,"docs":{"125":{"tf":1.0},"54":{"tf":1.0},"80":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"120":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}}}}}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"22":{"tf":1.4142135623730951},"34":{"tf":1.0},"40":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"52":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"116":{"tf":1.0},"82":{"tf":1.0},"88":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"23":{"tf":1.0},"46":{"tf":2.0},"63":{"tf":1.0},"67":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"t":{"df":9,"docs":{"11":{"tf":1.4142135623730951},"110":{"tf":1.0},"123":{"tf":1.0},"3":{"tf":2.449489742783178},"5":{"tf":1.0},"60":{"tf":1.0},"68":{"tf":1.0},"82":{"tf":1.4142135623730951},"91":{"tf":1.0}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"23":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951}}}}}}},"o":{"df":1,"docs":{"64":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"2":{"tf":1.0},"77":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}}}}}}},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"30":{"tf":1.0},"35":{"tf":1.0}}}},"k":{"a":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{}},"l":{"a":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":4,"docs":{"46":{"tf":1.0},"67":{"tf":1.0},"7":{"tf":1.0},"75":{"tf":1.0}},"’":{"df":1,"docs":{"67":{"tf":1.0}}}}}}}}}},"i":{"a":{"df":6,"docs":{"21":{"tf":1.0},"22":{"tf":2.23606797749979},"27":{"tf":1.0},"43":{"tf":1.0},"70":{"tf":1.0},"82":{"tf":2.23606797749979}},"s":{"df":10,"docs":{"123":{"tf":1.0},"20":{"tf":2.449489742783178},"21":{"tf":1.4142135623730951},"22":{"tf":3.1622776601683795},"25":{"tf":1.4142135623730951},"26":{"tf":1.0},"34":{"tf":1.0},"4":{"tf":1.0},"71":{"tf":1.0},"82":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":10,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":2.0},"18":{"tf":1.0},"56":{"tf":1.0},"7":{"tf":4.242640687119285},"72":{"tf":2.23606797749979},"82":{"tf":1.0},"9":{"tf":1.4142135623730951},"92":{"tf":1.7320508075688772}}}},"v":{"df":6,"docs":{"100":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.7320508075688772},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"92":{"tf":1.0}}}},"l":{"df":0,"docs":{},"o":{"c":{":":{":":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"82":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"87":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"84":{"tf":1.0},"88":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":3,"docs":{"84":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"82":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":1,"docs":{"82":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"(":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":4,"docs":{"82":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"95":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"59":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":24,"docs":{"10":{"tf":1.7320508075688772},"111":{"tf":1.7320508075688772},"123":{"tf":1.0},"3":{"tf":1.4142135623730951},"4":{"tf":2.23606797749979},"41":{"tf":1.0},"5":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.0},"61":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":2.449489742783178},"81":{"tf":1.7320508075688772},"82":{"tf":6.324555320336759},"83":{"tf":1.4142135623730951},"84":{"tf":1.0},"87":{"tf":2.0},"88":{"tf":2.23606797749979},"89":{"tf":1.7320508075688772},"90":{"tf":2.0},"91":{"tf":2.8284271247461903},"92":{"tf":1.7320508075688772},"93":{"tf":2.0},"96":{"tf":2.0}}},"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"134":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"c":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"72":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"122":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":37,"docs":{"10":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"11":{"tf":1.4142135623730951},"120":{"tf":1.0},"124":{"tf":1.0},"129":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":1.4142135623730951},"22":{"tf":1.7320508075688772},"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":2.0},"28":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":1.7320508075688772},"36":{"tf":1.7320508075688772},"39":{"tf":1.4142135623730951},"40":{"tf":1.7320508075688772},"41":{"tf":1.0},"43":{"tf":2.0},"44":{"tf":1.0},"46":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"54":{"tf":1.0},"55":{"tf":2.23606797749979},"56":{"tf":1.4142135623730951},"58":{"tf":1.0},"59":{"tf":1.4142135623730951},"7":{"tf":2.6457513110645907},"70":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"72":{"tf":2.449489742783178},"9":{"tf":1.0},"96":{"tf":1.4142135623730951}}}}}}},"df":25,"docs":{"10":{"tf":1.0},"117":{"tf":1.0},"120":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.4142135623730951},"19":{"tf":1.0},"22":{"tf":1.7320508075688772},"23":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.4142135623730951},"30":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.7320508075688772},"40":{"tf":1.4142135623730951},"41":{"tf":1.0},"42":{"tf":2.8284271247461903},"56":{"tf":1.4142135623730951},"59":{"tf":1.0},"63":{"tf":1.0},"71":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.0},"96":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"4":{"tf":1.0},"70":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":11,"docs":{"24":{"tf":1.0},"40":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0},"56":{"tf":1.4142135623730951},"63":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":1.0},"82":{"tf":1.0},"87":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":8,"docs":{"101":{"tf":1.0},"103":{"tf":1.0},"105":{"tf":1.0},"24":{"tf":1.0},"67":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"89":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"121":{"tf":1.0}},"n":{"df":7,"docs":{"121":{"tf":1.0},"13":{"tf":1.4142135623730951},"133":{"tf":1.0},"31":{"tf":1.0},"44":{"tf":1.0},"56":{"tf":1.0},"92":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":9,"docs":{"19":{"tf":1.0},"43":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.0},"80":{"tf":1.0},"83":{"tf":1.0},"87":{"tf":1.0},"96":{"tf":1.0}}}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":16,"docs":{"126":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.4142135623730951},"23":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"67":{"tf":1.0},"7":{"tf":1.7320508075688772},"8":{"tf":1.0},"87":{"tf":1.4142135623730951},"92":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"131":{"tf":1.0},"71":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":1,"docs":{"11":{"tf":1.0}},"i":{"df":8,"docs":{"10":{"tf":1.0},"19":{"tf":1.4142135623730951},"22":{"tf":2.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"39":{"tf":1.0},"54":{"tf":2.0},"82":{"tf":2.0}}}},"z":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"d":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"125":{"tf":1.0},"14":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"75":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"23":{"tf":1.0},"34":{"tf":1.0}}},"u":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{}}},"y":{"df":2,"docs":{"44":{"tf":1.0},"67":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":3,"docs":{"23":{"tf":1.0},"24":{"tf":1.0},"7":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":17,"docs":{"103":{"tf":1.0},"120":{"tf":1.0},"2":{"tf":1.4142135623730951},"3":{"tf":1.7320508075688772},"33":{"tf":1.0},"35":{"tf":1.0},"40":{"tf":1.7320508075688772},"46":{"tf":1.0},"52":{"tf":1.0},"64":{"tf":1.4142135623730951},"68":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":2.23606797749979},"75":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"86":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"35":{"tf":1.0},"78":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"11":{"tf":1.0},"67":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"131":{"tf":1.0},"67":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":9,"docs":{"10":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":1.4142135623730951},"52":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0},"68":{"tf":1.4142135623730951},"71":{"tf":1.0},"96":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":7,"docs":{"2":{"tf":1.0},"60":{"tf":1.0},"68":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.4142135623730951},"89":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"29":{"tf":1.0},"56":{"tf":1.0},"7":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"i":{"df":19,"docs":{"1":{"tf":1.0},"11":{"tf":1.4142135623730951},"110":{"tf":1.0},"111":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"135":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"4":{"tf":1.0},"43":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.7320508075688772},"63":{"tf":1.7320508075688772},"64":{"tf":1.4142135623730951},"69":{"tf":1.0},"82":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"23":{"tf":1.0}}}}}}}}},"p":{"df":1,"docs":{"135":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"72":{"tf":1.0}}},"r":{"df":5,"docs":{"135":{"tf":1.0},"29":{"tf":1.0},"40":{"tf":1.0},"52":{"tf":1.0},"62":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"c":{"df":5,"docs":{"135":{"tf":2.449489742783178},"14":{"tf":1.0},"2":{"tf":1.0},"64":{"tf":1.4142135623730951},"82":{"tf":1.0}}},"df":12,"docs":{"122":{"tf":1.0},"123":{"tf":1.4142135623730951},"125":{"tf":1.0},"135":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":1.4142135623730951},"36":{"tf":1.0},"40":{"tf":1.0},"59":{"tf":1.0}}},"y":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"125":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":6,"docs":{"1":{"tf":1.0},"122":{"tf":1.0},"126":{"tf":1.0},"56":{"tf":1.0},"69":{"tf":1.0},"79":{"tf":1.0}}}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":3,"docs":{"39":{"tf":1.0},"40":{"tf":1.0},"7":{"tf":1.0}}}}}}}}},"r":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":10,"docs":{"103":{"tf":1.0},"3":{"tf":1.4142135623730951},"35":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.4142135623730951},"52":{"tf":1.0},"56":{"tf":1.4142135623730951},"59":{"tf":1.0},"82":{"tf":1.0},"89":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"4":{"tf":1.0},"43":{"tf":1.0},"59":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"c":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"c":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"78":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"0":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"<":{"&":{"\'":{"a":{"df":1,"docs":{"96":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"96":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"c":{"<":{"df":0,"docs":{},"u":{"3":{"2":{"df":1,"docs":{"99":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":8,"docs":{"101":{"tf":1.0},"102":{"tf":2.23606797749979},"103":{"tf":1.4142135623730951},"104":{"tf":1.0},"105":{"tf":3.0},"96":{"tf":1.7320508075688772},"98":{"tf":1.7320508075688772},"99":{"tf":1.4142135623730951}}}},"df":13,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":2.8284271247461903},"104":{"tf":1.4142135623730951},"105":{"tf":1.0},"70":{"tf":1.0},"94":{"tf":1.4142135623730951},"95":{"tf":1.0},"96":{"tf":2.23606797749979},"97":{"tf":1.0},"98":{"tf":1.4142135623730951},"99":{"tf":2.0}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"122":{"tf":1.0},"17":{"tf":1.0},"91":{"tf":1.0}}}}}},"df":0,"docs":{}}},"v":{"df":1,"docs":{"119":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":4,"docs":{"100":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.7320508075688772},"105":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"<":{"df":0,"docs":{},"t":{"df":5,"docs":{"101":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"96":{"tf":2.23606797749979},"98":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"’":{"df":1,"docs":{"96":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":10,"docs":{"110":{"tf":1.0},"14":{"tf":1.4142135623730951},"22":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":1.0},"35":{"tf":1.0},"48":{"tf":1.0},"58":{"tf":1.0},"71":{"tf":1.7320508075688772},"91":{"tf":1.0}}}}}},"g":{"df":2,"docs":{"131":{"tf":2.0},"29":{"tf":1.4142135623730951}},"s":{"<":{"\'":{"a":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":2,"docs":{"71":{"tf":1.0},"82":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":10,"docs":{"110":{"tf":1.4142135623730951},"124":{"tf":1.4142135623730951},"129":{"tf":1.0},"131":{"tf":1.0},"22":{"tf":1.0},"29":{"tf":1.0},"34":{"tf":2.6457513110645907},"35":{"tf":1.0},"40":{"tf":1.0},"56":{"tf":1.4142135623730951}}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}}}}}},"m":{"df":2,"docs":{"17":{"tf":1.0},"75":{"tf":1.0}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":14,"docs":{"10":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.0},"34":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"56":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"96":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}}}}},"a":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"(":{"0":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"[":{"0":{"df":1,"docs":{"46":{"tf":2.0}}},"df":0,"docs":{}},"df":12,"docs":{"10":{"tf":1.0},"18":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":2.0},"5":{"tf":1.0},"56":{"tf":4.0},"65":{"tf":1.0},"7":{"tf":1.7320508075688772},"82":{"tf":1.7320508075688772},"85":{"tf":1.0},"87":{"tf":1.7320508075688772},"9":{"tf":1.0}}}},"df":1,"docs":{"5":{"tf":1.4142135623730951}}},"t":{"df":1,"docs":{"1":{"tf":1.0}},"i":{"df":0,"docs":{},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"109":{"tf":1.0},"119":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"82":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"s":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"100":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":2,"docs":{"19":{"tf":1.0},"24":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},":":{":":{"<":{"\'":{"d":{">":{"(":{"&":{"\'":{"d":{"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"<":{"\'":{"a":{">":{"(":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"24":{"tf":1.4142135623730951}}}}}},"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":2,"docs":{"68":{"tf":1.0},"71":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"k":{"df":4,"docs":{"16":{"tf":1.0},"75":{"tf":1.4142135623730951},"82":{"tf":1.0},"84":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"34":{"tf":1.0},"56":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"!":{"(":{"!":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"d":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"&":{"d":{"df":1,"docs":{"111":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":2,"docs":{"86":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"129":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{":":{":":{"<":{"df":0,"docs":{},"t":{"df":4,"docs":{"82":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"d":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"s":{"df":2,"docs":{"88":{"tf":1.0},"91":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"(":{"&":{"c":{"df":1,"docs":{"111":{"tf":1.0}}},"d":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"111":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"d":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"&":{"c":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"c":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"!":{"(":{"0":{"df":1,"docs":{"93":{"tf":1.7320508075688772}}},"1":{"0":{"df":1,"docs":{"93":{"tf":1.0}}},"6":{"df":1,"docs":{"16":{"tf":1.0}}},"df":1,"docs":{"93":{"tf":2.23606797749979}}},"5":{"df":1,"docs":{"93":{"tf":1.0}}},"8":{"df":1,"docs":{"16":{"tf":1.0}}},"9":{"df":1,"docs":{"93":{"tf":1.4142135623730951}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"2":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"!":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{":":{":":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"129":{"tf":1.0}}}}}}}},"df":1,"docs":{"129":{"tf":1.0}}}}}}}}}},"df":3,"docs":{"36":{"tf":1.7320508075688772},"72":{"tf":1.7320508075688772},"82":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"t":{">":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.7320508075688772}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":10,"docs":{"22":{"tf":1.0},"29":{"tf":1.4142135623730951},"34":{"tf":2.0},"4":{"tf":1.0},"54":{"tf":1.7320508075688772},"55":{"tf":2.0},"56":{"tf":2.0},"58":{"tf":1.4142135623730951},"63":{"tf":1.0},"74":{"tf":1.4142135623730951}}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":5,"docs":{"100":{"tf":1.0},"39":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"89":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":18,"docs":{"1":{"tf":1.7320508075688772},"103":{"tf":1.0},"110":{"tf":1.0},"114":{"tf":1.0},"123":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":1.0},"71":{"tf":1.0},"82":{"tf":1.4142135623730951},"96":{"tf":1.0}},"p":{"df":0,"docs":{},"t":{"df":11,"docs":{"103":{"tf":1.0},"123":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.0},"62":{"tf":1.0},"76":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"n":{"c":{"df":1,"docs":{"69":{"tf":1.0}},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"118":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":12,"docs":{"103":{"tf":2.8284271247461903},"104":{"tf":1.4142135623730951},"105":{"tf":1.0},"70":{"tf":2.0},"73":{"tf":1.7320508075688772},"76":{"tf":1.7320508075688772},"77":{"tf":1.7320508075688772},"78":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951},"94":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.0}},"i":{"c":{":":{":":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"96":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{":":{":":{"a":{"c":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"104":{"tf":1.4142135623730951},"105":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":4,"docs":{"103":{"tf":1.0},"105":{"tf":1.4142135623730951},"70":{"tf":1.0},"96":{"tf":1.0}},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"1":{"df":3,"docs":{"102":{"tf":1.0},"105":{"tf":1.0},"98":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":5,"docs":{"134":{"tf":1.0},"53":{"tf":1.0},"6":{"tf":1.0},"68":{"tf":1.0},"76":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":8,"docs":{"110":{"tf":1.0},"114":{"tf":1.0},"119":{"tf":1.4142135623730951},"123":{"tf":1.0},"134":{"tf":1.0},"135":{"tf":1.0},"36":{"tf":2.6457513110645907},"40":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"u":{"d":{"a":{"c":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"2":{"tf":1.0},"5":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"2":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0},"92":{"tf":1.0}}}}},"o":{"df":5,"docs":{"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"46":{"tf":1.4142135623730951}},"m":{"a":{"df":0,"docs":{},"t":{"df":5,"docs":{"3":{"tf":1.7320508075688772},"33":{"tf":1.0},"46":{"tf":1.0},"59":{"tf":1.4142135623730951},"71":{"tf":2.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"46":{"tf":2.23606797749979}}}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"119":{"tf":1.4142135623730951},"123":{"tf":1.0},"134":{"tf":1.0},"82":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"36":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"i":{"d":{"df":12,"docs":{"17":{"tf":1.0},"19":{"tf":1.0},"22":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"36":{"tf":1.0},"4":{"tf":1.0},"43":{"tf":1.0},"52":{"tf":1.0},"66":{"tf":1.0},"82":{"tf":1.0},"89":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.0}}},"y":{"df":6,"docs":{"19":{"tf":1.0},"56":{"tf":1.0},"63":{"tf":1.0},"68":{"tf":1.0},"75":{"tf":1.0},"96":{"tf":1.0}}}},"df":3,"docs":{"1":{"tf":1.0},"23":{"tf":1.0},"76":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"121":{"tf":1.0}}}}}}},"’":{"df":2,"docs":{"34":{"tf":1.0},"78":{"tf":1.0}}}},"b":{"(":{"df":0,"docs":{},"u":{"6":{"4":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"a":{"c":{"df":0,"docs":{},"k":{"df":12,"docs":{"1":{"tf":1.0},"116":{"tf":1.4142135623730951},"19":{"tf":1.0},"28":{"tf":1.0},"33":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.7320508075688772},"61":{"tf":1.0},"75":{"tf":1.0},"82":{"tf":1.4142135623730951},"87":{"tf":1.0},"92":{"tf":1.0}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"87":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"d":{"df":10,"docs":{"103":{"tf":1.0},"131":{"tf":1.0},"25":{"tf":1.0},"34":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"62":{"tf":1.4142135623730951},"65":{"tf":1.0},"73":{"tf":1.0},"82":{"tf":2.23606797749979}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"67":{"tf":1.0}}}},"k":{"df":0,"docs":{},"e":{"df":2,"docs":{"4":{"tf":1.0},"9":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"3":{"tf":1.0},"59":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"r":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"131":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"f":{"3":{"2":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"131":{"tf":1.0}}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"131":{"tf":1.0}}},"df":0,"docs":{}}}}},".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{}},":":{":":{"df":0,"docs":{},"x":{"(":{"0":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"46":{"tf":2.23606797749979}}}}}},"df":0,"docs":{}},"df":6,"docs":{"119":{"tf":1.4142135623730951},"131":{"tf":2.449489742783178},"22":{"tf":1.0},"44":{"tf":1.7320508075688772},"46":{"tf":1.0},"58":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{".":{"a":{"d":{"d":{"(":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"56":{"tf":1.0}}}}}},"df":8,"docs":{"11":{"tf":1.0},"3":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.0},"7":{"tf":1.0},"95":{"tf":1.0},"97":{"tf":1.0}}},"i":{"c":{"df":24,"docs":{"1":{"tf":1.4142135623730951},"10":{"tf":1.0},"103":{"tf":1.4142135623730951},"104":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"123":{"tf":1.0},"24":{"tf":1.0},"3":{"tf":1.4142135623730951},"31":{"tf":1.0},"43":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"67":{"tf":1.0},"73":{"tf":1.0},"78":{"tf":1.0},"82":{"tf":1.0},"89":{"tf":1.0},"92":{"tf":1.4142135623730951},"97":{"tf":1.0}}},"df":0,"docs":{}}},"z":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":20,"docs":{"104":{"tf":1.0},"111":{"tf":1.0},"128":{"tf":1.7320508075688772},"23":{"tf":3.4641016151377544},"24":{"tf":2.0},"25":{"tf":2.6457513110645907},"27":{"tf":1.0},"29":{"tf":1.4142135623730951},"31":{"tf":2.23606797749979},"32":{"tf":1.7320508075688772},"33":{"tf":1.7320508075688772},"34":{"tf":4.898979485566356},"35":{"tf":1.4142135623730951},"36":{"tf":2.23606797749979},"43":{"tf":3.0},"44":{"tf":1.4142135623730951},"56":{"tf":1.0},"58":{"tf":1.4142135623730951},"7":{"tf":3.1622776601683795},"78":{"tf":1.7320508075688772}},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":16,"docs":{"103":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.4142135623730951},"29":{"tf":1.0},"30":{"tf":1.4142135623730951},"34":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"59":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"7":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.0}}}}},"df":22,"docs":{"103":{"tf":1.4142135623730951},"131":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"26":{"tf":1.0},"36":{"tf":1.0},"41":{"tf":1.4142135623730951},"43":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.4142135623730951},"73":{"tf":1.0},"82":{"tf":1.4142135623730951},"84":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":25,"docs":{"103":{"tf":1.0},"104":{"tf":2.6457513110645907},"19":{"tf":1.0},"22":{"tf":1.7320508075688772},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"26":{"tf":1.0},"28":{"tf":1.0},"34":{"tf":1.0},"41":{"tf":1.7320508075688772},"43":{"tf":1.0},"46":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.4142135623730951},"77":{"tf":1.4142135623730951},"78":{"tf":2.23606797749979},"79":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"91":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"53":{"tf":1.0},"78":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":8,"docs":{"119":{"tf":1.0},"12":{"tf":1.0},"3":{"tf":1.7320508075688772},"60":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":30,"docs":{"10":{"tf":1.0},"103":{"tf":1.0},"11":{"tf":2.23606797749979},"125":{"tf":1.0},"126":{"tf":1.4142135623730951},"131":{"tf":1.4142135623730951},"135":{"tf":2.0},"14":{"tf":2.0},"17":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":2.23606797749979},"32":{"tf":1.0},"4":{"tf":2.8284271247461903},"40":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.4142135623730951},"52":{"tf":2.23606797749979},"53":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"64":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"82":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":7,"docs":{"122":{"tf":1.0},"3":{"tf":1.0},"36":{"tf":1.0},"46":{"tf":1.0},"71":{"tf":1.0},"82":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"60":{"tf":1.0}}}}},"l":{"df":1,"docs":{"85":{"tf":1.0}}},"o":{"df":0,"docs":{},"w":{"df":9,"docs":{"103":{"tf":1.0},"114":{"tf":1.0},"133":{"tf":1.4142135623730951},"135":{"tf":1.0},"23":{"tf":1.0},"36":{"tf":1.0},"4":{"tf":1.0},"56":{"tf":1.0},"9":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"132":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"2":{"tf":1.0},"3":{"tf":1.0},"61":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"118":{"tf":1.0},"72":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":8,"docs":{"14":{"tf":1.0},"44":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"74":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"94":{"tf":1.0}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":8,"docs":{"1":{"tf":1.0},"131":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"72":{"tf":1.0},"77":{"tf":1.0},"88":{"tf":1.0},"94":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":10,"docs":{"131":{"tf":1.0},"15":{"tf":1.0},"3":{"tf":2.23606797749979},"32":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.0},"61":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"g":{"df":4,"docs":{"25":{"tf":1.0},"30":{"tf":1.0},"35":{"tf":1.0},"6":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"19":{"tf":1.0},"22":{"tf":1.0},"4":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"103":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":7,"docs":{"119":{"tf":1.0},"132":{"tf":1.0},"134":{"tf":1.0},"135":{"tf":1.0},"14":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0}}},"y":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"p":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"67":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"d":{"df":3,"docs":{"100":{"tf":1.0},"107":{"tf":1.0},"110":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"df":0,"docs":{}},"t":{"df":24,"docs":{"103":{"tf":1.0},"131":{"tf":1.0},"2":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"31":{"tf":1.0},"34":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":2.23606797749979},"52":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":2.0},"58":{"tf":1.4142135623730951},"6":{"tf":1.0},"67":{"tf":1.0},"7":{"tf":2.0},"75":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":2.8284271247461903},"83":{"tf":1.7320508075688772},"89":{"tf":1.0},"9":{"tf":1.0}},"e":{"df":1,"docs":{"67":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"34":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"73":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"58":{"tf":1.0},"68":{"tf":1.0},"83":{"tf":1.0}}}}},"df":0,"docs":{}}},"o":{"c":{"df":0,"docs":{},"k":{"df":12,"docs":{"110":{"tf":1.4142135623730951},"111":{"tf":1.4142135623730951},"119":{"tf":1.4142135623730951},"120":{"tf":2.23606797749979},"121":{"tf":1.0},"122":{"tf":1.4142135623730951},"128":{"tf":1.4142135623730951},"3":{"tf":1.0},"5":{"tf":1.0},"63":{"tf":1.7320508075688772},"69":{"tf":1.0},"82":{"tf":1.0}}}},"df":0,"docs":{},"w":{"df":4,"docs":{"24":{"tf":1.0},"27":{"tf":1.0},"59":{"tf":1.0},"67":{"tf":1.0}},"n":{"df":1,"docs":{"59":{"tf":1.0}}}}}},"o":{"d":{"df":0,"docs":{},"i":{"df":4,"docs":{"23":{"tf":1.0},"31":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"52":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"3":{"tf":1.0},"58":{"tf":1.0},"76":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"59":{"tf":1.0}}}}}}}},"m":{"b":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"k":{"df":8,"docs":{"0":{"tf":1.0},"1":{"tf":2.6457513110645907},"109":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"52":{"tf":1.0},"6":{"tf":1.0},"73":{"tf":1.4142135623730951}}},"l":{"df":7,"docs":{"111":{"tf":1.0},"26":{"tf":1.0},"4":{"tf":1.0},"48":{"tf":1.0},"52":{"tf":1.4142135623730951},"56":{"tf":2.23606797749979},"58":{"tf":1.0}}},"n":{"df":1,"docs":{"19":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"104":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"43":{"tf":2.23606797749979}}}},"df":15,"docs":{"123":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":3.0},"27":{"tf":2.449489742783178},"28":{"tf":3.0},"32":{"tf":1.0},"34":{"tf":2.0},"35":{"tf":4.358898943540674},"36":{"tf":2.0},"43":{"tf":2.6457513110645907},"63":{"tf":1.7320508075688772},"72":{"tf":2.23606797749979},"89":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"h":{"df":7,"docs":{"119":{"tf":1.0},"121":{"tf":1.0},"125":{"tf":1.0},"2":{"tf":1.0},"35":{"tf":1.0},"87":{"tf":1.0},"89":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"84":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"24":{"tf":1.0},"58":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":12,"docs":{"119":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":2.0},"129":{"tf":1.0},"14":{"tf":2.0},"23":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.4142135623730951},"5":{"tf":1.0},"64":{"tf":1.0},"68":{"tf":1.0},"99":{"tf":1.0}}}}},"df":15,"docs":{"3":{"tf":1.4142135623730951},"30":{"tf":2.449489742783178},"31":{"tf":2.0},"34":{"tf":1.0},"39":{"tf":1.0},"45":{"tf":1.4142135623730951},"5":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":1.0},"70":{"tf":1.7320508075688772},"82":{"tf":1.0},"86":{"tf":1.4142135623730951},"89":{"tf":1.0},"93":{"tf":1.4142135623730951},"99":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"x":{"\'":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}},":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"104":{"tf":1.4142135623730951},"105":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"104":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"df":3,"docs":{"102":{"tf":1.0},"105":{"tf":1.0},"98":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"\\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}},"0":{"df":3,"docs":{"54":{"tf":1.4142135623730951},"55":{"tf":2.6457513110645907},"63":{"tf":1.0}}},"1":{"df":4,"docs":{"35":{"tf":2.0},"36":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0}}},"5":{"df":1,"docs":{"128":{"tf":1.0}}},"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":3,"docs":{"102":{"tf":1.0},"105":{"tf":1.0},"98":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":1,"docs":{"56":{"tf":1.0}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"<":{"&":{"\'":{"b":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"[":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":2.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}},"t":{"df":6,"docs":{"123":{"tf":1.0},"125":{"tf":1.0},"34":{"tf":1.4142135623730951},"59":{"tf":3.0},"7":{"tf":1.0},"72":{"tf":1.0}}},"u":{"3":{"2":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"8":{"df":3,"docs":{"35":{"tf":2.0},"36":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":17,"docs":{"102":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"123":{"tf":1.0},"125":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":1.4142135623730951},"4":{"tf":1.7320508075688772},"54":{"tf":1.4142135623730951},"56":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":2.0},"62":{"tf":1.0},"63":{"tf":1.0},"72":{"tf":1.7320508075688772},"98":{"tf":1.4142135623730951}},"y":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}},"df":0,"docs":{}},"’":{"df":1,"docs":{"59":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":6,"docs":{"22":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"54":{"tf":2.449489742783178},"55":{"tf":1.4142135623730951},"91":{"tf":1.0},"93":{"tf":1.0}}}},"d":{"df":2,"docs":{"43":{"tf":1.0},"54":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":7,"docs":{"123":{"tf":1.0},"34":{"tf":1.0},"4":{"tf":1.0},"54":{"tf":1.7320508075688772},"56":{"tf":1.0},"67":{"tf":1.4142135623730951},"90":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}}}}}},"df":0,"docs":{}},"i":{"d":{"df":0,"docs":{},"g":{"df":3,"docs":{"14":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"46":{"tf":1.0}}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"80":{"tf":1.0}}}}},"o":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"65":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"78":{"tf":1.0}},"n":{"df":1,"docs":{"3":{"tf":1.7320508075688772}}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"3":{"tf":3.3166247903554}},"’":{"df":1,"docs":{"3":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"u":{"b":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"67":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"67":{"tf":2.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{".":{"c":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"88":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{")":{".":{"a":{"d":{"d":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"88":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"88":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":4,"docs":{"87":{"tf":1.4142135623730951},"88":{"tf":2.449489742783178},"89":{"tf":1.4142135623730951},"93":{"tf":2.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"110":{"tf":1.0},"111":{"tf":1.7320508075688772},"41":{"tf":1.7320508075688772},"84":{"tf":1.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951}}}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"<":{"\'":{"_":{"df":1,"docs":{"29":{"tf":1.0}}},"a":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"g":{"df":3,"docs":{"19":{"tf":1.0},"34":{"tf":1.0},"92":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"73":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":2,"docs":{"131":{"tf":1.0},"3":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"l":{"d":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"109":{"tf":2.0}}}},"df":12,"docs":{"109":{"tf":2.23606797749979},"114":{"tf":1.0},"119":{"tf":1.4142135623730951},"132":{"tf":1.0},"133":{"tf":1.0},"134":{"tf":1.7320508075688772},"135":{"tf":1.4142135623730951},"3":{"tf":1.0},"44":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":4,"docs":{"19":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0},"58":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"5":{"tf":1.0},"67":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"103":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"119":{"tf":1.0}}}}},"df":0,"docs":{},"n":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"91":{"tf":1.0}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"3":{"tf":1.0},"66":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":12,"docs":{"110":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":1.0},"4":{"tf":1.7320508075688772},"52":{"tf":1.0},"56":{"tf":1.0},"7":{"tf":1.4142135623730951},"82":{"tf":2.6457513110645907},"88":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951},"92":{"tf":1.0},"93":{"tf":1.4142135623730951}}}}}},"c":{"(":{"df":0,"docs":{},"u":{"8":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}},"+":{"+":{"1":{"1":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}},"2":{"0":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"’":{"df":2,"docs":{"126":{"tf":1.0},"58":{"tf":1.0}}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"h":{"df":1,"docs":{"107":{"tf":1.0}}}},"/":{"c":{"+":{"+":{"1":{"1":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"119":{"tf":1.4142135623730951},"73":{"tf":1.0}}},"df":0,"docs":{}},"1":{"1":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}},"2":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}},"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"134":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"110":{"tf":2.0},"111":{"tf":3.1622776601683795},"125":{"tf":3.1622776601683795},"134":{"tf":1.7320508075688772},"72":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"131":{"tf":1.0},"72":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"18":{"tf":1.0},"22":{"tf":1.4142135623730951},"75":{"tf":2.0}},"e":{"d":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.7320508075688772}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"<":{"\'":{"a":{">":{"(":{"&":{"\'":{"a":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{".":{"c":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":1,"docs":{"115":{"tf":1.4142135623730951}}}}}}},"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"116":{"tf":1.0}}}},"df":0,"docs":{}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"(":{"&":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"7":{"df":1,"docs":{"116":{"tf":1.0}}},"a":{"df":1,"docs":{"116":{"tf":1.0}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"_":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":5,"docs":{"116":{"tf":2.8284271247461903},"117":{"tf":2.8284271247461903},"118":{"tf":3.4641016151377544},"125":{"tf":1.7320508075688772},"36":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":54,"docs":{"100":{"tf":1.4142135623730951},"102":{"tf":1.0},"105":{"tf":1.0},"107":{"tf":1.0},"110":{"tf":1.7320508075688772},"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.4142135623730951},"114":{"tf":1.7320508075688772},"115":{"tf":1.4142135623730951},"116":{"tf":2.449489742783178},"117":{"tf":1.7320508075688772},"118":{"tf":1.4142135623730951},"12":{"tf":1.0},"120":{"tf":1.4142135623730951},"122":{"tf":2.23606797749979},"125":{"tf":1.7320508075688772},"127":{"tf":1.4142135623730951},"128":{"tf":1.0},"129":{"tf":1.0},"131":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.4142135623730951},"22":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"34":{"tf":2.0},"35":{"tf":1.0},"36":{"tf":2.23606797749979},"4":{"tf":1.7320508075688772},"41":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":4.0},"5":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"63":{"tf":1.0},"64":{"tf":1.7320508075688772},"65":{"tf":1.4142135623730951},"69":{"tf":1.0},"72":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":2.0},"87":{"tf":1.4142135623730951},"89":{"tf":1.0},"92":{"tf":1.4142135623730951},"98":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"116":{"tf":1.0},"34":{"tf":1.0},"65":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"e":{"df":2,"docs":{"64":{"tf":1.0},"82":{"tf":1.0}}}},"n":{"\'":{"df":0,"docs":{},"t":{"df":11,"docs":{"56":{"tf":1.4142135623730951},"66":{"tf":1.0},"70":{"tf":1.4142135623730951},"72":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.7320508075688772},"9":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.4142135623730951}}}},"d":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":21,"docs":{"104":{"tf":1.0},"123":{"tf":1.0},"131":{"tf":1.0},"22":{"tf":1.7320508075688772},"24":{"tf":1.0},"3":{"tf":2.449489742783178},"31":{"tf":1.0},"34":{"tf":1.0},"46":{"tf":1.7320508075688772},"48":{"tf":1.0},"52":{"tf":1.7320508075688772},"60":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"72":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"82":{"tf":2.449489742783178},"83":{"tf":1.0},"87":{"tf":1.0}}}}},"p":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"88":{"tf":1.0},"93":{"tf":1.0}}}}}}},"df":0,"docs":{}},"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"35":{"tf":1.0},"36":{"tf":1.0}}}},"c":{"df":5,"docs":{"111":{"tf":1.7320508075688772},"5":{"tf":1.7320508075688772},"66":{"tf":1.4142135623730951},"91":{"tf":1.7320508075688772},"93":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":9,"docs":{"40":{"tf":1.7320508075688772},"41":{"tf":1.0},"5":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"82":{"tf":2.8284271247461903},"87":{"tf":2.0},"88":{"tf":1.7320508075688772},"91":{"tf":1.4142135623730951},"93":{"tf":1.7320508075688772}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"70":{"tf":1.4142135623730951},"71":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":26,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"121":{"tf":1.0},"2":{"tf":1.7320508075688772},"22":{"tf":1.4142135623730951},"27":{"tf":1.0},"3":{"tf":1.7320508075688772},"31":{"tf":1.0},"35":{"tf":1.7320508075688772},"4":{"tf":1.0},"41":{"tf":1.4142135623730951},"54":{"tf":1.0},"56":{"tf":1.4142135623730951},"58":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.4142135623730951},"65":{"tf":1.7320508075688772},"68":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.7320508075688772},"93":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"56":{"tf":1.0}}}}}}}},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":4,"docs":{"108":{"tf":1.0},"109":{"tf":1.0},"114":{"tf":1.0},"133":{"tf":1.0}}}}}}},"df":3,"docs":{"109":{"tf":1.0},"114":{"tf":1.0},"135":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"df":0,"docs":{},"t":{">":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"d":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":2.23606797749979}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"72":{"tf":3.3166247903554}}}},"df":1,"docs":{"72":{"tf":3.872983346207417}}}}}},"s":{"df":0,"docs":{},"e":{"df":49,"docs":{"103":{"tf":1.0},"11":{"tf":1.4142135623730951},"110":{"tf":1.0},"112":{"tf":1.0},"118":{"tf":1.0},"119":{"tf":1.7320508075688772},"125":{"tf":1.4142135623730951},"17":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":2.0},"38":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":2.6457513110645907},"43":{"tf":1.7320508075688772},"45":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0},"55":{"tf":1.7320508075688772},"56":{"tf":1.4142135623730951},"58":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":1.4142135623730951},"64":{"tf":1.0},"65":{"tf":1.4142135623730951},"66":{"tf":1.0},"7":{"tf":2.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"72":{"tf":1.0},"78":{"tf":1.4142135623730951},"8":{"tf":1.0},"82":{"tf":2.449489742783178},"84":{"tf":1.4142135623730951},"86":{"tf":1.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0}}},"t":{"df":7,"docs":{"47":{"tf":2.8284271247461903},"48":{"tf":2.6457513110645907},"49":{"tf":1.0},"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"92":{"tf":1.4142135623730951}}}},"t":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":2,"docs":{"61":{"tf":1.0},"64":{"tf":1.0}}}}}}}}},"c":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"126":{"tf":1.0},"127":{"tf":1.0},"130":{"tf":2.0},"64":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":6,"docs":{"126":{"tf":1.4142135623730951},"128":{"tf":1.0},"130":{"tf":1.4142135623730951},"19":{"tf":1.0},"36":{"tf":1.0},"64":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.0}},"i":{"df":1,"docs":{"75":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.7320508075688772}}}}},"s":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"73":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.7320508075688772}}}},"df":25,"docs":{"103":{"tf":1.0},"126":{"tf":1.7320508075688772},"16":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":1.7320508075688772},"30":{"tf":1.0},"34":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"53":{"tf":1.0},"56":{"tf":1.7320508075688772},"61":{"tf":1.0},"64":{"tf":1.4142135623730951},"65":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.7320508075688772},"71":{"tf":1.4142135623730951},"82":{"tf":1.7320508075688772},"92":{"tf":1.0},"99":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}}}},"b":{"(":{"7":{"df":1,"docs":{"116":{"tf":1.0}}},"c":{"b":{"_":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":2,"docs":{"116":{"tf":1.4142135623730951},"117":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"115":{"tf":1.0},"14":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"122":{"tf":1.0}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":2,"docs":{"114":{"tf":1.0},"135":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":44,"docs":{"107":{"tf":1.4142135623730951},"108":{"tf":1.0},"110":{"tf":2.0},"111":{"tf":2.0},"113":{"tf":1.4142135623730951},"114":{"tf":2.0},"115":{"tf":2.0},"116":{"tf":2.449489742783178},"117":{"tf":2.6457513110645907},"118":{"tf":2.0},"122":{"tf":2.23606797749979},"123":{"tf":2.0},"124":{"tf":1.0},"125":{"tf":3.7416573867739413},"126":{"tf":1.0},"127":{"tf":2.23606797749979},"128":{"tf":3.0},"129":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":2.23606797749979},"134":{"tf":1.0},"14":{"tf":4.0},"16":{"tf":1.7320508075688772},"19":{"tf":2.0},"2":{"tf":2.6457513110645907},"23":{"tf":2.23606797749979},"24":{"tf":1.0},"25":{"tf":1.7320508075688772},"27":{"tf":2.0},"31":{"tf":1.0},"34":{"tf":2.0},"4":{"tf":1.4142135623730951},"43":{"tf":2.0},"54":{"tf":1.4142135623730951},"56":{"tf":1.0},"58":{"tf":1.7320508075688772},"59":{"tf":2.23606797749979},"64":{"tf":1.0},"7":{"tf":2.23606797749979},"72":{"tf":1.4142135623730951},"73":{"tf":2.0},"76":{"tf":1.4142135623730951},"87":{"tf":1.0},"90":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"<":{"df":0,"docs":{},"g":{"df":1,"docs":{"34":{"tf":1.0}}},"h":{"df":1,"docs":{"34":{"tf":1.0}}},"t":{"df":1,"docs":{"34":{"tf":1.4142135623730951}}}},"df":1,"docs":{"71":{"tf":1.0}}}},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"125":{"tf":1.4142135623730951},"14":{"tf":1.0},"18":{"tf":1.0},"45":{"tf":1.0},"52":{"tf":1.0},"76":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"36":{"tf":1.0},"59":{"tf":1.4142135623730951},"68":{"tf":1.0},"77":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"g":{"(":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"df":1,"docs":{"122":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"i":{"df":2,"docs":{"40":{"tf":1.0},"41":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"_":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"135":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"125":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"(":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"_":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"135":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"134":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"111":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"134":{"tf":1.0}}}}}}},"df":1,"docs":{"82":{"tf":1.0}}}},"h":{"a":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"3":{"tf":1.0},"70":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":19,"docs":{"122":{"tf":1.0},"19":{"tf":1.0},"26":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.4142135623730951},"5":{"tf":1.7320508075688772},"52":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.7320508075688772},"70":{"tf":1.4142135623730951},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.0},"96":{"tf":1.0}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"118":{"tf":1.0}}}}}},"o":{"df":2,"docs":{"52":{"tf":1.0},"73":{"tf":1.0}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":8,"docs":{"21":{"tf":1.0},"23":{"tf":1.0},"33":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"6":{"tf":1.7320508075688772},"81":{"tf":1.7320508075688772},"94":{"tf":1.0},"96":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"75":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"79":{"tf":1.0}}}}},"t":{"df":1,"docs":{"67":{"tf":1.0}}}},"c":{"df":0,"docs":{},"k":{"df":29,"docs":{"0":{"tf":1.0},"103":{"tf":1.0},"110":{"tf":1.0},"115":{"tf":1.0},"123":{"tf":1.0},"3":{"tf":2.449489742783178},"35":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"40":{"tf":1.7320508075688772},"45":{"tf":1.0},"46":{"tf":2.0},"5":{"tf":1.0},"52":{"tf":1.4142135623730951},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"62":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.7320508075688772},"72":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.7320508075688772},"82":{"tf":1.7320508075688772},"83":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":11,"docs":{"23":{"tf":1.0},"35":{"tf":3.1622776601683795},"36":{"tf":1.0},"38":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"41":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0},"56":{"tf":1.0},"72":{"tf":1.7320508075688772},"96":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"63":{"tf":1.0}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"p":{"df":1,"docs":{"17":{"tf":1.0}}}},"o":{"df":0,"docs":{},"i":{"c":{"df":5,"docs":{"10":{"tf":1.0},"3":{"tf":1.4142135623730951},"31":{"tf":1.0},"59":{"tf":1.0},"77":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"111":{"tf":1.0},"68":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"14":{"tf":1.0},"82":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":2,"docs":{"3":{"tf":1.0},"86":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"34":{"tf":1.0},"61":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"59":{"tf":1.0}},"i":{"c":{"df":5,"docs":{"118":{"tf":1.0},"34":{"tf":1.0},"41":{"tf":1.0},"59":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":5,"docs":{"57":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}},"r":{"df":3,"docs":{"24":{"tf":1.0},"34":{"tf":1.0},"46":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":6,"docs":{"19":{"tf":1.0},"24":{"tf":1.0},"27":{"tf":1.0},"34":{"tf":1.0},"43":{"tf":1.0},"61":{"tf":1.0}}}}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"82":{"tf":1.0}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{}},"o":{".":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"31":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"64":{"tf":1.0}}}}},"df":0,"docs":{}},"df":1,"docs":{"31":{"tf":1.7320508075688772}},"n":{"df":0,"docs":{},"e":{"(":{"&":{"&":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":4,"docs":{"103":{"tf":1.0},"105":{"tf":1.0},"46":{"tf":1.4142135623730951},"62":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}},">":{"(":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"46":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"<":{"df":0,"docs":{},"t":{">":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":8,"docs":{"101":{"tf":1.0},"103":{"tf":2.6457513110645907},"105":{"tf":1.0},"28":{"tf":1.0},"46":{"tf":4.69041575982343},"58":{"tf":2.449489742783178},"66":{"tf":2.0},"99":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"14":{"tf":1.0},"63":{"tf":1.7320508075688772}},"r":{"df":1,"docs":{"46":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"3":{"tf":1.0},"31":{"tf":1.7320508075688772},"63":{"tf":2.0}},"e":{"<":{"df":0,"docs":{},"f":{"df":1,"docs":{"31":{"tf":2.449489742783178}}}},"df":0,"docs":{}}}}}}},"m":{"df":0,"docs":{},"p":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"df":0,"docs":{}},":":{":":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"25":{"tf":1.0},"27":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"df":67,"docs":{"1":{"tf":1.4142135623730951},"10":{"tf":1.7320508075688772},"100":{"tf":1.0},"102":{"tf":1.4142135623730951},"103":{"tf":2.23606797749979},"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"107":{"tf":1.0},"11":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.4142135623730951},"114":{"tf":1.4142135623730951},"115":{"tf":1.0},"116":{"tf":2.0},"117":{"tf":1.7320508075688772},"119":{"tf":1.7320508075688772},"122":{"tf":1.0},"123":{"tf":1.0},"125":{"tf":1.4142135623730951},"130":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":2.0},"2":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"23":{"tf":2.0},"27":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":3.0},"30":{"tf":1.0},"31":{"tf":1.7320508075688772},"33":{"tf":2.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"36":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.4142135623730951},"46":{"tf":1.0},"5":{"tf":3.3166247903554},"55":{"tf":2.0},"56":{"tf":2.449489742783178},"60":{"tf":2.0},"61":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":3.7416573867739413},"66":{"tf":1.0},"67":{"tf":2.6457513110645907},"68":{"tf":2.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951},"74":{"tf":1.0},"76":{"tf":1.4142135623730951},"80":{"tf":1.0},"82":{"tf":2.0},"84":{"tf":1.0},"92":{"tf":1.7320508075688772},"93":{"tf":1.0},"95":{"tf":1.0},"97":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":2,"docs":{"45":{"tf":1.7320508075688772},"85":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"45":{"tf":2.0},"46":{"tf":1.0},"47":{"tf":1.7320508075688772},"9":{"tf":1.0}}}}}},"df":0,"docs":{}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"65":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"23":{"tf":1.4142135623730951},"67":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":6,"docs":{"19":{"tf":1.4142135623730951},"34":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"71":{"tf":1.7320508075688772},"82":{"tf":1.0}}}},"df":0,"docs":{}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"1":{"tf":1.0},"2":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":12,"docs":{"126":{"tf":1.0},"2":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"58":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}}},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"105":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":11,"docs":{"10":{"tf":1.0},"119":{"tf":1.0},"125":{"tf":1.0},"2":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"44":{"tf":1.4142135623730951},"57":{"tf":1.0},"75":{"tf":1.0},"87":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"17":{"tf":1.0},"39":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"df":2,"docs":{"11":{"tf":1.0},"76":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"r":{"df":1,"docs":{"3":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"3":{"tf":1.0},"67":{"tf":1.4142135623730951}}}}}}},"t":{"df":6,"docs":{"123":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"34":{"tf":1.0},"64":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":51,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"110":{"tf":1.7320508075688772},"113":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.4142135623730951},"119":{"tf":1.4142135623730951},"120":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":1.0},"129":{"tf":1.0},"131":{"tf":1.4142135623730951},"133":{"tf":1.0},"134":{"tf":2.0},"135":{"tf":1.0},"14":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"19":{"tf":2.23606797749979},"22":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":2.6457513110645907},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"30":{"tf":1.0},"33":{"tf":1.4142135623730951},"34":{"tf":2.23606797749979},"35":{"tf":1.7320508075688772},"36":{"tf":1.0},"4":{"tf":2.0},"46":{"tf":4.123105625617661},"48":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":2.0},"75":{"tf":1.4142135623730951},"76":{"tf":2.6457513110645907},"81":{"tf":1.4142135623730951},"82":{"tf":2.0},"91":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}}},"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"134":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":16,"docs":{"19":{"tf":1.0},"2":{"tf":1.0},"23":{"tf":1.0},"3":{"tf":1.0},"33":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"6":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0},"74":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"9":{"tf":1.7320508075688772}}},"x":{"df":10,"docs":{"111":{"tf":1.0},"23":{"tf":1.4142135623730951},"35":{"tf":1.0},"5":{"tf":1.0},"67":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0},"89":{"tf":1.0},"95":{"tf":1.0}}}},"i":{"c":{"df":9,"docs":{"118":{"tf":1.0},"19":{"tf":1.7320508075688772},"33":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"67":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"74":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"3":{"tf":1.4142135623730951},"71":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"43":{"tf":1.0},"60":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"4":{"tf":1.0},"52":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"(":{"&":{"d":{"df":1,"docs":{"111":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}}}},"df":4,"docs":{"110":{"tf":1.4142135623730951},"111":{"tf":2.0},"88":{"tf":1.0},"89":{"tf":1.0}},"e":{"d":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"110":{"tf":2.0},"111":{"tf":2.449489742783178}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"107":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"19":{"tf":1.0},"24":{"tf":1.0},"46":{"tf":1.0},"56":{"tf":1.0},"92":{"tf":1.0}},"e":{"(":{"&":{"df":0,"docs":{},"x":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.7320508075688772}}}}}}}},"df":0,"docs":{}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":3,"docs":{"111":{"tf":1.0},"14":{"tf":1.4142135623730951},"34":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":6,"docs":{"15":{"tf":1.0},"22":{"tf":1.0},"56":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.0},"96":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"73":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":4,"docs":{"34":{"tf":1.0},"40":{"tf":1.0},"74":{"tf":1.0},"82":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":9,"docs":{"1":{"tf":1.0},"18":{"tf":1.0},"21":{"tf":1.0},"43":{"tf":1.0},"69":{"tf":2.0},"70":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":1.4142135623730951},"99":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":7,"docs":{"26":{"tf":1.0},"4":{"tf":1.0},"55":{"tf":2.6457513110645907},"70":{"tf":2.8284271247461903},"82":{"tf":1.7320508075688772},"85":{"tf":1.0},"93":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"55":{"tf":1.0}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"11":{"tf":1.0},"77":{"tf":1.0}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"34":{"tf":1.7320508075688772},"64":{"tf":1.0}}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":12,"docs":{"10":{"tf":1.0},"19":{"tf":1.0},"4":{"tf":1.0},"44":{"tf":1.0},"61":{"tf":1.0},"64":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":1.0},"82":{"tf":1.4142135623730951},"87":{"tf":1.0},"9":{"tf":1.0}}}},"r":{"df":0,"docs":{},"v":{"df":5,"docs":{"28":{"tf":1.0},"32":{"tf":1.0},"36":{"tf":1.0},"41":{"tf":1.4142135623730951},"82":{"tf":1.0}}}}},"i":{"d":{"df":25,"docs":{"1":{"tf":1.4142135623730951},"15":{"tf":1.0},"19":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"24":{"tf":1.0},"26":{"tf":1.0},"34":{"tf":1.7320508075688772},"35":{"tf":1.0},"4":{"tf":1.7320508075688772},"40":{"tf":1.0},"41":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":2.23606797749979},"54":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"62":{"tf":1.0},"65":{"tf":1.0},"7":{"tf":1.4142135623730951},"70":{"tf":1.0},"82":{"tf":1.0},"87":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"1":{"tf":1.0},"22":{"tf":1.0},"3":{"tf":1.0},"40":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":8,"docs":{"3":{"tf":1.0},"61":{"tf":2.0},"7":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":3.0},"80":{"tf":1.0},"82":{"tf":1.7320508075688772},"9":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"22":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0}}}}},"df":20,"docs":{"11":{"tf":1.4142135623730951},"110":{"tf":2.0},"111":{"tf":2.8284271247461903},"120":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.4142135623730951},"134":{"tf":1.4142135623730951},"30":{"tf":1.0},"34":{"tf":1.7320508075688772},"39":{"tf":2.0},"40":{"tf":2.449489742783178},"41":{"tf":1.7320508075688772},"50":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"67":{"tf":1.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951},"89":{"tf":2.0},"92":{"tf":2.0},"93":{"tf":2.23606797749979}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":1,"docs":{"44":{"tf":1.0}},"t":{"df":1,"docs":{"45":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"122":{"tf":1.4142135623730951},"34":{"tf":1.0},"4":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"125":{"tf":1.0}}}}}}},"df":10,"docs":{"1":{"tf":1.0},"103":{"tf":1.0},"11":{"tf":1.4142135623730951},"14":{"tf":1.0},"43":{"tf":1.0},"56":{"tf":1.0},"67":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.0},"98":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"131":{"tf":1.0},"58":{"tf":3.0}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"m":{"df":9,"docs":{"11":{"tf":1.0},"14":{"tf":1.0},"39":{"tf":1.0},"43":{"tf":1.4142135623730951},"60":{"tf":1.0},"61":{"tf":1.0},"76":{"tf":1.0},"87":{"tf":1.0},"89":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":28,"docs":{"1":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"123":{"tf":1.0},"125":{"tf":1.7320508075688772},"135":{"tf":1.0},"2":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"33":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.4142135623730951},"41":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"56":{"tf":1.7320508075688772},"61":{"tf":1.4142135623730951},"62":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.7320508075688772},"72":{"tf":1.0},"87":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.0},"96":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"46":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"m":{"a":{"df":0,"docs":{},"y":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{">":{"(":{"a":{"df":0,"docs":{},"r":{"c":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"46":{"tf":2.8284271247461903},"56":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"104":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":10,"docs":{"1":{"tf":1.0},"104":{"tf":1.0},"131":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":2.0},"61":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951},"89":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":7,"docs":{"10":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"45":{"tf":1.0},"58":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":2,"docs":{"111":{"tf":1.0},"9":{"tf":1.0}}}},"n":{"df":0,"docs":{},"u":{"df":2,"docs":{"14":{"tf":1.0},"34":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"24":{"tf":1.0},"3":{"tf":3.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"14":{"tf":1.0},"41":{"tf":1.0}}}},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"34":{"tf":3.0},"42":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{},"v":{"df":1,"docs":{"125":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":12,"docs":{"118":{"tf":1.0},"14":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"65":{"tf":1.4142135623730951},"66":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.7320508075688772},"87":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":6,"docs":{"2":{"tf":1.0},"34":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"82":{"tf":1.0},"90":{"tf":1.0}}},"t":{"df":5,"docs":{"114":{"tf":1.4142135623730951},"116":{"tf":1.0},"122":{"tf":2.23606797749979},"58":{"tf":1.0},"82":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":7,"docs":{"125":{"tf":1.0},"126":{"tf":1.0},"3":{"tf":1.0},"44":{"tf":1.4142135623730951},"47":{"tf":1.0},"59":{"tf":1.0},"72":{"tf":1.0}}},"t":{"df":4,"docs":{"104":{"tf":1.0},"11":{"tf":1.0},"46":{"tf":1.7320508075688772},"48":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"26":{"tf":1.0},"75":{"tf":1.0}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"i":{"df":13,"docs":{"119":{"tf":1.0},"52":{"tf":1.4142135623730951},"54":{"tf":2.0},"55":{"tf":1.0},"56":{"tf":1.7320508075688772},"58":{"tf":3.1622776601683795},"67":{"tf":1.7320508075688772},"70":{"tf":1.0},"73":{"tf":1.0},"83":{"tf":1.0},"86":{"tf":1.4142135623730951},"87":{"tf":1.0},"88":{"tf":1.0}}},"y":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{":":{":":{"df":0,"docs":{},"{":{"c":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"134":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"135":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"s":{":":{":":{"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"134":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"<":{"(":{"*":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"131":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"131":{"tf":1.4142135623730951}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{":":{":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":2,"docs":{"134":{"tf":1.0},"135":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"134":{"tf":1.0}}}}}}}}}},"df":3,"docs":{"134":{"tf":1.0},"4":{"tf":1.0},"75":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"119":{"tf":1.0}}},"df":0,"docs":{}}}}}},"n":{"df":1,"docs":{"23":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"26":{"tf":1.0},"33":{"tf":1.0},"48":{"tf":1.0},"62":{"tf":1.0},"82":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":19,"docs":{"1":{"tf":1.0},"110":{"tf":1.4142135623730951},"116":{"tf":1.0},"125":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.0},"3":{"tf":1.0},"39":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.4142135623730951},"56":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.7320508075688772},"76":{"tf":1.0},"77":{"tf":1.4142135623730951},"83":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":13,"docs":{"101":{"tf":1.0},"110":{"tf":1.0},"3":{"tf":2.0},"39":{"tf":1.0},"5":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.0},"68":{"tf":1.4142135623730951},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"85":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"125":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"23":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"133":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":1,"docs":{"1":{"tf":1.0}}}},"t":{"df":2,"docs":{"61":{"tf":1.0},"64":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"n":{"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":3,"docs":{"22":{"tf":1.0},"81":{"tf":1.0},"96":{"tf":1.0}}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"t":{"df":12,"docs":{"102":{"tf":1.0},"103":{"tf":3.0},"104":{"tf":2.449489742783178},"105":{"tf":1.0},"56":{"tf":1.7320508075688772},"60":{"tf":1.0},"7":{"tf":1.7320508075688772},"79":{"tf":1.0},"93":{"tf":1.7320508075688772},"96":{"tf":2.0},"98":{"tf":1.0},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"34":{"tf":1.0},"79":{"tf":1.4142135623730951},"92":{"tf":1.4142135623730951}}}}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"82":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":15,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.0},"30":{"tf":1.0},"36":{"tf":1.0},"4":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.4142135623730951},"59":{"tf":1.0},"70":{"tf":1.0},"77":{"tf":1.0},"82":{"tf":1.0},"91":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":5,"docs":{"34":{"tf":4.795831523312719},"39":{"tf":1.0},"42":{"tf":2.449489742783178},"81":{"tf":1.4142135623730951},"96":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"110":{"tf":1.0},"14":{"tf":1.0},"26":{"tf":1.0},"52":{"tf":1.0},"73":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"u":{"df":1,"docs":{"75":{"tf":2.23606797749979}}}},"r":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"e":{"df":10,"docs":{"108":{"tf":1.0},"114":{"tf":1.7320508075688772},"115":{"tf":1.0},"119":{"tf":1.7320508075688772},"123":{"tf":1.0},"132":{"tf":1.4142135623730951},"133":{"tf":2.0},"134":{"tf":2.0},"135":{"tf":3.0},"15":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"123":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":31,"docs":{"1":{"tf":1.0},"104":{"tf":1.0},"109":{"tf":1.0},"111":{"tf":1.0},"115":{"tf":1.0},"117":{"tf":1.0},"119":{"tf":1.0},"123":{"tf":1.0},"131":{"tf":1.7320508075688772},"16":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"34":{"tf":1.0},"40":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":2.449489742783178},"57":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.4142135623730951},"65":{"tf":1.0},"67":{"tf":1.0},"72":{"tf":1.0},"82":{"tf":1.0},"9":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0},"99":{"tf":1.4142135623730951}},"e":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":4,"docs":{"133":{"tf":1.0},"5":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"126":{"tf":1.4142135623730951},"23":{"tf":1.0}}}}},"t":{"0":{".":{"df":0,"docs":{},"o":{"df":1,"docs":{"134":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"\\"":{"[":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"121":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"123":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"2":{"tf":1.0},"4":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":2,"docs":{"10":{"tf":1.0},"41":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":20,"docs":{"102":{"tf":1.0},"105":{"tf":1.0},"107":{"tf":1.0},"111":{"tf":1.0},"116":{"tf":1.0},"118":{"tf":1.0},"119":{"tf":1.0},"122":{"tf":1.0},"131":{"tf":1.0},"14":{"tf":1.0},"36":{"tf":1.0},"4":{"tf":1.0},"56":{"tf":1.0},"64":{"tf":1.0},"7":{"tf":1.0},"82":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.4142135623730951},"98":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":7,"docs":{"10":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.4142135623730951},"59":{"tf":1.0},"72":{"tf":1.0},"82":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}}},"y":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}},"’":{"df":4,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"56":{"tf":1.4142135623730951},"86":{"tf":1.0}}}},"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"2":{"tf":1.0},"63":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"47":{"tf":1.0},"48":{"tf":1.0},"62":{"tf":1.0},"70":{"tf":1.0}}}},"l":{"df":11,"docs":{"110":{"tf":1.0},"19":{"tf":1.4142135623730951},"2":{"tf":1.0},"26":{"tf":1.0},"30":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"4":{"tf":2.0},"40":{"tf":1.0},"41":{"tf":2.23606797749979},"42":{"tf":1.0},"82":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"1":{"tf":1.0}}}},"t":{"a":{".":{"0":{"df":1,"docs":{"31":{"tf":2.0}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"d":{"(":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"(":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"70":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"(":{"4":{"df":3,"docs":{"19":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":2.23606797749979}}},"5":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"1":{"df":2,"docs":{"59":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772}}},"2":{"df":2,"docs":{"59":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772}}},"[":{"0":{"df":3,"docs":{"19":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.7320508075688772}}},"3":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"(":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"b":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}},"df":45,"docs":{"101":{"tf":1.4142135623730951},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":4.0},"105":{"tf":2.0},"116":{"tf":1.0},"118":{"tf":1.4142135623730951},"125":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"16":{"tf":1.0},"19":{"tf":2.0},"24":{"tf":2.0},"25":{"tf":3.1622776601683795},"26":{"tf":2.0},"31":{"tf":2.449489742783178},"35":{"tf":2.449489742783178},"36":{"tf":2.6457513110645907},"4":{"tf":1.0},"40":{"tf":1.7320508075688772},"43":{"tf":1.0},"52":{"tf":1.4142135623730951},"56":{"tf":1.7320508075688772},"59":{"tf":1.0},"6":{"tf":1.7320508075688772},"61":{"tf":1.4142135623730951},"62":{"tf":2.449489742783178},"63":{"tf":4.358898943540674},"65":{"tf":1.0},"67":{"tf":1.7320508075688772},"68":{"tf":1.4142135623730951},"7":{"tf":2.6457513110645907},"70":{"tf":3.1622776601683795},"72":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":3.0},"77":{"tf":1.4142135623730951},"78":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.0},"9":{"tf":1.7320508075688772},"96":{"tf":1.7320508075688772},"98":{"tf":1.0},"99":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"y":{"df":4,"docs":{"25":{"tf":1.0},"35":{"tf":4.123105625617661},"36":{"tf":1.4142135623730951},"44":{"tf":1.0}}}},"df":5,"docs":{"111":{"tf":2.0},"24":{"tf":1.0},"27":{"tf":1.0},"31":{"tf":1.0},"34":{"tf":2.0}},"e":{"a":{"d":{"df":2,"docs":{"22":{"tf":1.0},"74":{"tf":1.0}},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"4":{"tf":1.0},"70":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":10,"docs":{"1":{"tf":1.0},"121":{"tf":1.4142135623730951},"132":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"36":{"tf":1.0},"41":{"tf":1.0},"56":{"tf":1.0},"6":{"tf":1.0},"65":{"tf":1.0}},"l":{"df":0,"docs":{},"o":{"c":{"df":8,"docs":{"4":{"tf":1.0},"41":{"tf":2.0},"59":{"tf":1.7320508075688772},"82":{"tf":1.0},"84":{"tf":1.4142135623730951},"88":{"tf":1.0},"92":{"tf":2.23606797749979},"93":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"82":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"35":{"tf":1.0}}}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":2,"docs":{"32":{"tf":1.4142135623730951},"33":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"<":{"\'":{"a":{">":{"(":{"a":{"df":2,"docs":{"32":{"tf":1.0},"33":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":2,"docs":{"32":{"tf":1.0},"65":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"85":{"tf":1.0}}}}},"i":{"d":{"df":5,"docs":{"103":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.0},"70":{"tf":1.0},"97":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}},"l":{"a":{"df":0,"docs":{},"r":{"df":13,"docs":{"11":{"tf":1.4142135623730951},"110":{"tf":1.4142135623730951},"119":{"tf":1.0},"12":{"tf":1.0},"121":{"tf":1.4142135623730951},"124":{"tf":1.0},"133":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0},"3":{"tf":2.449489742783178},"4":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"96":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"111":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"104":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"103":{"tf":1.4142135623730951},"104":{"tf":1.7320508075688772}}}}}}}}},"d":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"u":{"c":{"df":1,"docs":{"46":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"39":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":13,"docs":{"109":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"125":{"tf":1.0},"13":{"tf":1.0},"133":{"tf":1.7320508075688772},"14":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"41":{"tf":1.0},"58":{"tf":2.23606797749979},"59":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"3":{"tf":2.0}}},"df":0,"docs":{}},"r":{"df":1,"docs":{"82":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":28,"docs":{"114":{"tf":1.0},"116":{"tf":1.0},"12":{"tf":1.0},"122":{"tf":1.0},"125":{"tf":1.0},"134":{"tf":1.4142135623730951},"135":{"tf":1.0},"14":{"tf":1.4142135623730951},"16":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.4142135623730951},"24":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":1.0},"33":{"tf":2.8284271247461903},"34":{"tf":1.7320508075688772},"35":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.4142135623730951},"5":{"tf":1.0},"52":{"tf":1.0},"58":{"tf":1.0},"67":{"tf":1.7320508075688772},"70":{"tf":1.0},"73":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":25,"docs":{"108":{"tf":1.0},"123":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.7320508075688772},"22":{"tf":1.0},"29":{"tf":1.4142135623730951},"33":{"tf":1.0},"35":{"tf":1.7320508075688772},"39":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":1.4142135623730951},"43":{"tf":1.0},"5":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":1.4142135623730951},"71":{"tf":1.0},"77":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"92":{"tf":1.0}}}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"103":{"tf":1.0},"62":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"55":{"tf":1.0},"59":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"54":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":4,"docs":{"104":{"tf":2.8284271247461903},"105":{"tf":1.0},"4":{"tf":1.0},"6":{"tf":1.0}}}},"i":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"25":{"tf":1.0},"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"(":{"\\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}},"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"<":{"\'":{"a":{">":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"56":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"41":{"tf":1.4142135623730951}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}}}},"s":{"df":1,"docs":{"7":{"tf":1.0}}},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":13,"docs":{"108":{"tf":1.0},"119":{"tf":2.449489742783178},"126":{"tf":1.0},"133":{"tf":1.4142135623730951},"135":{"tf":1.4142135623730951},"22":{"tf":1.0},"3":{"tf":1.0},"5":{"tf":1.4142135623730951},"54":{"tf":1.0},"56":{"tf":1.0},"70":{"tf":1.0},"74":{"tf":1.4142135623730951},"82":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":1,"docs":{"36":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":2,"docs":{"56":{"tf":1.0},"82":{"tf":1.0}}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"43":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":6,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"105":{"tf":1.0},"72":{"tf":1.0},"85":{"tf":1.0},"93":{"tf":1.0}}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"=":{"[":{"df":0,"docs":{},"t":{"df":1,"docs":{"85":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"46":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"72":{"tf":1.0},"85":{"tf":1.0},"93":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":10,"docs":{"101":{"tf":1.7320508075688772},"102":{"tf":1.0},"105":{"tf":1.0},"46":{"tf":1.0},"55":{"tf":1.0},"72":{"tf":1.7320508075688772},"85":{"tf":1.4142135623730951},"87":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":1.0},"46":{"tf":2.23606797749979},"55":{"tf":1.0},"83":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"c":{"df":8,"docs":{"11":{"tf":1.0},"120":{"tf":1.0},"30":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":1.0},"46":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"72":{"tf":1.7320508075688772},"85":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"118":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"v":{"df":6,"docs":{"3":{"tf":1.7320508075688772},"30":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":1.0},"46":{"tf":1.4142135623730951},"71":{"tf":2.23606797749979}},"e":{"(":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}}}}},"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":2,"docs":{"26":{"tf":1.0},"27":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"b":{"df":4,"docs":{"1":{"tf":1.7320508075688772},"103":{"tf":1.0},"104":{"tf":1.0},"23":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":12,"docs":{"118":{"tf":1.0},"15":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.7320508075688772},"63":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"81":{"tf":1.0},"89":{"tf":1.0},"92":{"tf":1.0},"96":{"tf":1.0}}}},"r":{"df":7,"docs":{"117":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"61":{"tf":1.0},"7":{"tf":1.4142135623730951},"71":{"tf":1.0}}}},"t":{"df":2,"docs":{"56":{"tf":1.7320508075688772},"86":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"86":{"tf":1.0}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":7,"docs":{"101":{"tf":1.0},"118":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.0},"68":{"tf":1.0}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"36":{"tf":1.0},"60":{"tf":1.0},"96":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":18,"docs":{"1":{"tf":1.0},"104":{"tf":1.0},"112":{"tf":1.7320508075688772},"118":{"tf":1.0},"127":{"tf":1.0},"26":{"tf":2.0},"35":{"tf":2.23606797749979},"36":{"tf":1.7320508075688772},"40":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"56":{"tf":1.0},"59":{"tf":2.8284271247461903},"60":{"tf":3.0},"61":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"64":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"72":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"44":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"r":{"df":5,"docs":{"23":{"tf":1.7320508075688772},"24":{"tf":1.0},"27":{"tf":1.0},"31":{"tf":1.4142135623730951},"35":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":20,"docs":{"1":{"tf":1.4142135623730951},"11":{"tf":1.0},"111":{"tf":1.0},"131":{"tf":1.7320508075688772},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":2.449489742783178},"21":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"46":{"tf":1.0},"52":{"tf":1.0},"73":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"89":{"tf":1.4142135623730951},"96":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"34":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.4142135623730951},"46":{"tf":1.0},"55":{"tf":1.0},"60":{"tf":1.0}}}}}}}},"v":{"df":2,"docs":{"135":{"tf":1.4142135623730951},"20":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":7,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"132":{"tf":1.0},"135":{"tf":1.0},"2":{"tf":1.0},"73":{"tf":1.0},"77":{"tf":1.0}}}}}}}},"i":{"d":{"df":0,"docs":{},"n":{"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":3,"docs":{"5":{"tf":1.0},"7":{"tf":1.0},"92":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":2,"docs":{"52":{"tf":1.0},"64":{"tf":1.0}}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":20,"docs":{"104":{"tf":1.0},"119":{"tf":1.0},"131":{"tf":1.0},"135":{"tf":1.7320508075688772},"14":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"2":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.0},"4":{"tf":1.0},"44":{"tf":1.4142135623730951},"52":{"tf":2.0},"55":{"tf":1.0},"63":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"72":{"tf":1.0},"75":{"tf":1.4142135623730951},"78":{"tf":1.0},"82":{"tf":1.7320508075688772},"92":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"119":{"tf":1.0},"3":{"tf":1.0}}}}}}}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"g":{"df":2,"docs":{"1":{"tf":1.4142135623730951},"6":{"tf":1.0}}},"p":{"df":1,"docs":{"23":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"118":{"tf":1.0},"125":{"tf":1.0},"82":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":13,"docs":{"107":{"tf":1.0},"119":{"tf":1.0},"123":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0},"3":{"tf":1.0},"36":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"87":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"133":{"tf":1.4142135623730951},"41":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"1":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"42":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}},"c":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"10":{"tf":1.0},"135":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"125":{"tf":1.0},"16":{"tf":1.4142135623730951},"4":{"tf":1.0},"7":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":5,"docs":{"114":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"3":{"tf":1.0},"56":{"tf":1.0}}}}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"43":{"tf":1.4142135623730951},"82":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{">":{"(":{"&":{"\'":{"a":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"26":{"tf":1.0},"29":{"tf":1.0},"35":{"tf":1.0},"43":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"119":{"tf":1.4142135623730951},"78":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"23":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"69":{"tf":1.0}}}}},"i":{"d":{"df":2,"docs":{"65":{"tf":1.0},"92":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"(":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"<":{"\'":{"b":{">":{"(":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"31":{"tf":1.7320508075688772}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"c":{"df":2,"docs":{"135":{"tf":1.0},"72":{"tf":1.0}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":9,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"104":{"tf":1.0},"107":{"tf":1.0},"130":{"tf":1.0},"132":{"tf":1.0},"15":{"tf":1.0},"3":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951}}}}}}}},"df":16,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.0},"34":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.0},"92":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"\'":{"df":0,"docs":{},"t":{"df":4,"docs":{"11":{"tf":1.0},"54":{"tf":1.4142135623730951},"88":{"tf":1.0},"91":{"tf":1.0}}}},"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":31,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.7320508075688772},"134":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"26":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":2.0},"35":{"tf":1.7320508075688772},"40":{"tf":1.0},"43":{"tf":1.4142135623730951},"46":{"tf":1.0},"5":{"tf":1.4142135623730951},"54":{"tf":1.7320508075688772},"55":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":2.0},"62":{"tf":1.4142135623730951},"64":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"69":{"tf":1.0},"75":{"tf":1.4142135623730951},"77":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.4142135623730951},"91":{"tf":1.0},"96":{"tf":1.0}}}}}}},"n":{"\'":{"df":0,"docs":{},"t":{"df":8,"docs":{"103":{"tf":1.0},"105":{"tf":1.0},"25":{"tf":1.0},"54":{"tf":1.4142135623730951},"61":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":8,"docs":{"41":{"tf":1.0},"64":{"tf":1.0},"72":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.4142135623730951},"82":{"tf":1.0},"87":{"tf":1.0}}},"’":{"df":0,"docs":{},"t":{"df":27,"docs":{"1":{"tf":1.0},"103":{"tf":1.0},"130":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.7320508075688772},"23":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"38":{"tf":1.0},"43":{"tf":1.7320508075688772},"52":{"tf":1.0},"56":{"tf":1.7320508075688772},"58":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"60":{"tf":1.0},"64":{"tf":1.0},"67":{"tf":1.0},"72":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.4142135623730951},"82":{"tf":2.23606797749979},"84":{"tf":1.0},"87":{"tf":1.0},"92":{"tf":1.0},"96":{"tf":1.4142135623730951}}}}},"t":{"df":1,"docs":{"46":{"tf":1.7320508075688772}}},"u":{"b":{"df":0,"docs":{},"l":{"df":8,"docs":{"22":{"tf":1.7320508075688772},"56":{"tf":1.0},"59":{"tf":1.0},"67":{"tf":1.4142135623730951},"68":{"tf":1.0},"75":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0}},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"87":{"tf":1.0}},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"43":{"tf":1.7320508075688772},"87":{"tf":1.0},"89":{"tf":1.7320508075688772},"92":{"tf":1.0},"93":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"n":{"df":9,"docs":{"117":{"tf":1.0},"19":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":1.0},"43":{"tf":1.0},"58":{"tf":1.0},"62":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"a":{"d":{"df":2,"docs":{"33":{"tf":1.4142135623730951},"77":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"82":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"89":{"tf":1.0},"93":{"tf":1.0}}}}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"<":{"\'":{"a":{"df":2,"docs":{"89":{"tf":2.449489742783178},"93":{"tf":2.0}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":2,"docs":{"89":{"tf":1.0},"93":{"tf":1.0}}}},"df":4,"docs":{"61":{"tf":2.6457513110645907},"87":{"tf":1.0},"89":{"tf":3.3166247903554},"93":{"tf":2.0}},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}}},"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"p":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":17,"docs":{"104":{"tf":1.0},"105":{"tf":1.0},"26":{"tf":1.0},"35":{"tf":1.7320508075688772},"36":{"tf":2.0},"41":{"tf":1.0},"59":{"tf":2.449489742783178},"62":{"tf":1.0},"67":{"tf":1.0},"72":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.7320508075688772},"89":{"tf":1.4142135623730951},"91":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":2.0}}}}}},"df":1,"docs":{"41":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"x":{"df":2,"docs":{"26":{"tf":1.0},"55":{"tf":1.4142135623730951}}}},"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"59":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"`":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}},"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"35":{"tf":1.0},"40":{"tf":1.4142135623730951}}}},"df":37,"docs":{"103":{"tf":1.7320508075688772},"104":{"tf":3.0},"105":{"tf":1.0},"112":{"tf":1.0},"128":{"tf":1.0},"26":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":5.291502622129181},"36":{"tf":2.6457513110645907},"37":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"40":{"tf":4.0},"41":{"tf":5.0990195135927845},"42":{"tf":1.4142135623730951},"43":{"tf":1.0},"55":{"tf":4.358898943540674},"56":{"tf":3.605551275463989},"59":{"tf":5.477225575051661},"60":{"tf":1.0},"61":{"tf":1.7320508075688772},"62":{"tf":2.23606797749979},"63":{"tf":1.7320508075688772},"66":{"tf":1.4142135623730951},"67":{"tf":2.0},"68":{"tf":1.4142135623730951},"72":{"tf":2.0},"83":{"tf":1.0},"84":{"tf":1.7320508075688772},"87":{"tf":2.8284271247461903},"88":{"tf":2.0},"89":{"tf":1.7320508075688772},"91":{"tf":1.0},"92":{"tf":2.0},"93":{"tf":2.0},"96":{"tf":2.0},"99":{"tf":1.0}},"p":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"t":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"111":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"(":{"d":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"111":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":3,"docs":{"111":{"tf":1.7320508075688772},"14":{"tf":1.0},"9":{"tf":3.0}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"111":{"tf":2.23606797749979}}}}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"14":{"tf":1.0}}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":2,"docs":{"4":{"tf":1.0},"92":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":7,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"20":{"tf":1.0},"27":{"tf":1.0},"43":{"tf":1.0},"73":{"tf":1.0},"91":{"tf":1.0}}},"m":{"b":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"1":{"tf":1.0},"88":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":6,"docs":{"35":{"tf":1.4142135623730951},"36":{"tf":1.0},"59":{"tf":1.4142135623730951},"64":{"tf":1.0},"68":{"tf":1.0},"87":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"119":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"135":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"a":{"df":0,"docs":{},"m":{"df":5,"docs":{"119":{"tf":2.0},"4":{"tf":1.0},"56":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":2.0}},"i":{"c":{".":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":2,"docs":{"4":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":10,"docs":{"126":{"tf":1.0},"135":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.7320508075688772},"42":{"tf":1.0},"44":{"tf":1.0},"59":{"tf":1.0},"64":{"tf":1.0},"7":{"tf":1.4142135623730951},"82":{"tf":1.7320508075688772}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":16,"docs":{"18":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"26":{"tf":1.0},"29":{"tf":1.0},"33":{"tf":1.0},"35":{"tf":1.0},"41":{"tf":1.0},"56":{"tf":1.0},"67":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.4142135623730951},"76":{"tf":1.0},"77":{"tf":1.0},"91":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"66":{"tf":1.0},"82":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"24":{"tf":1.0},"95":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"31":{"tf":1.0},"91":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":11,"docs":{"113":{"tf":1.0},"3":{"tf":1.0},"56":{"tf":1.0},"61":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"73":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"89":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"23":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":1.0},"89":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"109":{"tf":1.0},"30":{"tf":1.4142135623730951},"84":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"135":{"tf":1.0},"34":{"tf":1.0},"43":{"tf":1.0},"48":{"tf":1.0}}}}}}},"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"40":{"tf":1.0}}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"109":{"tf":1.0}}}}},"df":3,"docs":{"34":{"tf":2.0},"51":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":6,"docs":{"15":{"tf":1.0},"16":{"tf":1.7320508075688772},"17":{"tf":1.0},"26":{"tf":1.0},"46":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"i":{"df":4,"docs":{"19":{"tf":1.0},"55":{"tf":1.0},"66":{"tf":1.0},"80":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"h":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"134":{"tf":1.4142135623730951}}}}}}}}},"df":1,"docs":{"101":{"tf":1.0}}},"l":{"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"14":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"(":{"&":{"\'":{"a":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"s":{"df":3,"docs":{"91":{"tf":1.4142135623730951},"92":{"tf":1.7320508075688772},"93":{"tf":2.23606797749979}}}},"df":6,"docs":{"43":{"tf":2.0},"5":{"tf":1.4142135623730951},"67":{"tf":3.0},"83":{"tf":1.4142135623730951},"86":{"tf":1.7320508075688772},"93":{"tf":2.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":15,"docs":{"111":{"tf":1.4142135623730951},"16":{"tf":1.0},"18":{"tf":1.0},"35":{"tf":1.0},"41":{"tf":1.0},"56":{"tf":1.4142135623730951},"58":{"tf":1.0},"61":{"tf":1.7320508075688772},"67":{"tf":2.0},"81":{"tf":1.0},"82":{"tf":2.0},"86":{"tf":1.4142135623730951},"87":{"tf":3.1622776601683795},"88":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}}}},"i":{"d":{"df":3,"docs":{"29":{"tf":4.0},"30":{"tf":1.0},"72":{"tf":1.4142135623730951}}},"df":0,"docs":{},"g":{"df":1,"docs":{"125":{"tf":1.4142135623730951}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"22":{"tf":2.23606797749979},"60":{"tf":1.0},"74":{"tf":1.4142135623730951}}}}},"s":{"df":3,"docs":{"23":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"80":{"tf":1.0}}}}}},"’":{"df":1,"docs":{"69":{"tf":1.0}}}}},"t":{"df":1,"docs":{"67":{"tf":2.0}}}},"m":{"b":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"135":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"17":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.0}}}},"p":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"i":{"df":13,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":2.6457513110645907},"111":{"tf":1.0},"125":{"tf":1.0},"131":{"tf":1.7320508075688772},"134":{"tf":1.0},"14":{"tf":1.0},"2":{"tf":1.0},"4":{"tf":1.0},"43":{"tf":1.0},"58":{"tf":1.0},"82":{"tf":2.23606797749979},"85":{"tf":1.0}}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":9,"docs":{"11":{"tf":1.0},"18":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0},"64":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":1.0},"87":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"71":{"tf":1.0}}}}}}},"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"43":{"tf":1.0},"44":{"tf":1.0}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"126":{"tf":1.0},"31":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"2":{"tf":1.0},"44":{"tf":1.0},"64":{"tf":1.0}}}},"df":0,"docs":{}}}}},"d":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"67":{"tf":2.0}}}}},"df":0,"docs":{}}}},"df":17,"docs":{"118":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":2.0},"30":{"tf":1.0},"39":{"tf":1.7320508075688772},"41":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"56":{"tf":1.4142135623730951},"75":{"tf":1.0},"78":{"tf":1.0},"82":{"tf":1.0},"87":{"tf":2.8284271247461903},"88":{"tf":1.4142135623730951},"89":{"tf":1.7320508075688772},"92":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"c":{"df":4,"docs":{"104":{"tf":1.0},"23":{"tf":1.0},"35":{"tf":1.0},"72":{"tf":2.6457513110645907}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"61":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":11,"docs":{"104":{"tf":1.0},"2":{"tf":1.0},"23":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.7320508075688772},"41":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.0},"69":{"tf":1.4142135623730951},"72":{"tf":1.0},"82":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":17,"docs":{"131":{"tf":1.0},"134":{"tf":1.0},"14":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.7320508075688772},"35":{"tf":1.0},"63":{"tf":1.7320508075688772},"65":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951},"78":{"tf":1.7320508075688772},"88":{"tf":1.7320508075688772},"91":{"tf":1.4142135623730951},"92":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"68":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"126":{"tf":1.0},"31":{"tf":1.0},"60":{"tf":1.0}}}},"i":{"df":0,"docs":{},"r":{"df":9,"docs":{"110":{"tf":1.0},"122":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0},"4":{"tf":1.0},"64":{"tf":1.0},"71":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.0}}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"82":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"134":{"tf":1.7320508075688772}}}}},"u":{"df":0,"docs":{},"m":{"df":12,"docs":{"11":{"tf":1.7320508075688772},"123":{"tf":1.0},"125":{"tf":1.0},"131":{"tf":1.4142135623730951},"14":{"tf":2.449489742783178},"15":{"tf":1.4142135623730951},"16":{"tf":3.7416573867739413},"4":{"tf":1.4142135623730951},"43":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.4142135623730951},"7":{"tf":3.0}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"109":{"tf":1.0},"70":{"tf":1.0}}}}}}}},"q":{"df":1,"docs":{"28":{"tf":1.0}},"u":{"a":{"df":0,"docs":{},"l":{"df":5,"docs":{"104":{"tf":1.0},"111":{"tf":1.0},"34":{"tf":1.0},"7":{"tf":1.0},"87":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":7,"docs":{"11":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":1.0},"44":{"tf":1.0},"56":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"86":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"29":{"tf":1.0},"3":{"tf":1.0},"44":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"r":{"(":{"_":{"df":1,"docs":{"130":{"tf":1.0}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":2,"docs":{"11":{"tf":1.7320508075688772},"68":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"[":{"df":0,"docs":{},"e":{"0":{"2":{"7":{"7":{"df":1,"docs":{"45":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"0":{"8":{"df":1,"docs":{"32":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"2":{"5":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}},"9":{"9":{"df":2,"docs":{"28":{"tf":1.0},"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"0":{"2":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"9":{"7":{"df":2,"docs":{"34":{"tf":1.0},"35":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":15,"docs":{"133":{"tf":1.0},"134":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":1.0},"20":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.4142135623730951},"32":{"tf":1.0},"39":{"tf":1.0},"43":{"tf":1.4142135623730951},"64":{"tf":1.4142135623730951},"70":{"tf":1.0},"82":{"tf":1.0},"93":{"tf":1.0}}}}}},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"19":{"tf":1.7320508075688772},"36":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":10,"docs":{"11":{"tf":1.0},"112":{"tf":1.0},"118":{"tf":1.0},"30":{"tf":1.0},"43":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"64":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":3,"docs":{"5":{"tf":1.0},"76":{"tf":2.0},"78":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"c":{"df":2,"docs":{"34":{"tf":1.0},"4":{"tf":1.0}}},"df":0,"docs":{}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":2,"docs":{"55":{"tf":1.0},"83":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":30,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"17":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"26":{"tf":1.4142135623730951},"3":{"tf":1.7320508075688772},"31":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":2.0},"36":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":2.0},"53":{"tf":1.0},"59":{"tf":1.7320508075688772},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"68":{"tf":1.0},"7":{"tf":1.4142135623730951},"70":{"tf":1.0},"75":{"tf":1.7320508075688772},"77":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}},"t":{"df":3,"docs":{"60":{"tf":1.0},"74":{"tf":2.0},"75":{"tf":1.0}},"u":{"df":6,"docs":{"19":{"tf":1.0},"28":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"3":{"tf":1.0},"69":{"tf":1.4142135623730951},"73":{"tf":1.0},"96":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":18,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"110":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.4142135623730951},"39":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.7320508075688772},"44":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"65":{"tf":1.0},"71":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.4142135623730951}}}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":6,"docs":{"111":{"tf":1.0},"27":{"tf":1.0},"34":{"tf":1.0},"44":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":20,"docs":{"125":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.4142135623730951},"29":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"46":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0},"7":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":50,"docs":{"10":{"tf":1.0},"108":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"110":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.4142135623730951},"117":{"tf":1.0},"118":{"tf":1.0},"119":{"tf":1.0},"122":{"tf":1.4142135623730951},"125":{"tf":1.0},"127":{"tf":1.4142135623730951},"131":{"tf":1.0},"133":{"tf":1.0},"134":{"tf":1.0},"135":{"tf":1.0},"15":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":2.23606797749979},"24":{"tf":1.7320508075688772},"25":{"tf":1.4142135623730951},"26":{"tf":1.7320508075688772},"27":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"34":{"tf":2.0},"35":{"tf":1.4142135623730951},"36":{"tf":2.0},"40":{"tf":1.4142135623730951},"41":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":2.23606797749979},"5":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.4142135623730951},"63":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.4142135623730951},"71":{"tf":1.0},"72":{"tf":2.23606797749979},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"88":{"tf":1.0},"91":{"tf":1.0}},"l":{"df":1,"docs":{"73":{"tf":1.0}}},"p":{"df":0,"docs":{},"t":{"df":17,"docs":{"1":{"tf":1.4142135623730951},"126":{"tf":2.23606797749979},"128":{"tf":1.7320508075688772},"16":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"41":{"tf":2.23606797749979},"45":{"tf":1.0},"56":{"tf":1.4142135623730951},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":3.0},"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"68":{"tf":2.23606797749979},"7":{"tf":1.0},"71":{"tf":1.0},"89":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"41":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":3,"docs":{"3":{"tf":1.0},"43":{"tf":1.0},"72":{"tf":2.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":15,"docs":{"118":{"tf":1.4142135623730951},"133":{"tf":1.0},"134":{"tf":1.7320508075688772},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"35":{"tf":1.0},"4":{"tf":1.4142135623730951},"61":{"tf":1.0},"63":{"tf":1.4142135623730951},"64":{"tf":1.4142135623730951},"70":{"tf":1.7320508075688772},"74":{"tf":1.0},"77":{"tf":1.7320508075688772},"82":{"tf":1.0}}}}},"df":0,"docs":{}},"h":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"1":{"tf":1.4142135623730951},"14":{"tf":1.0},"45":{"tf":1.0},"47":{"tf":1.0},"82":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":19,"docs":{"1":{"tf":1.7320508075688772},"104":{"tf":1.0},"11":{"tf":1.4142135623730951},"19":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.7320508075688772},"34":{"tf":1.0},"40":{"tf":1.0},"45":{"tf":1.0},"5":{"tf":1.0},"58":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"9":{"tf":1.0}}}},"t":{"df":2,"docs":{"59":{"tf":1.0},"66":{"tf":1.0}}}},"o":{"df":0,"docs":{},"t":{"df":3,"docs":{"14":{"tf":1.0},"60":{"tf":1.0},"8":{"tf":1.0}}}},"p":{"a":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"24":{"tf":1.0},"29":{"tf":2.449489742783178}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\\"":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"72":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":16,"docs":{"111":{"tf":1.0},"126":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"27":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"34":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"64":{"tf":1.0},"7":{"tf":1.7320508075688772},"8":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":2,"docs":{"64":{"tf":1.0},"87":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"r":{"df":3,"docs":{"36":{"tf":2.0},"41":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"1":{"tf":1.0},"104":{"tf":1.0},"25":{"tf":1.0},"34":{"tf":1.4142135623730951},"72":{"tf":1.0},"73":{"tf":1.0}}}},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"122":{"tf":1.0}}}}}}},"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"16":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"58":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":14,"docs":{"14":{"tf":1.0},"16":{"tf":1.0},"23":{"tf":1.4142135623730951},"31":{"tf":1.0},"39":{"tf":1.0},"43":{"tf":1.0},"47":{"tf":1.4142135623730951},"52":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0},"68":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.0},"91":{"tf":1.0}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"16":{"tf":1.0},"56":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"121":{"tf":1.0}}}},"s":{"df":12,"docs":{"110":{"tf":1.0},"111":{"tf":1.0},"122":{"tf":1.0},"2":{"tf":1.0},"43":{"tf":1.0},"57":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"76":{"tf":1.4142135623730951},"82":{"tf":1.0},"9":{"tf":1.0}}}},"r":{"df":1,"docs":{"47":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"1":{"tf":1.0},"31":{"tf":1.0},"41":{"tf":1.4142135623730951},"51":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":6,"docs":{"110":{"tf":1.0},"27":{"tf":1.0},"34":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"91":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"82":{"tf":1.0}}},"t":{"df":1,"docs":{"23":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":23,"docs":{"110":{"tf":2.0},"114":{"tf":1.4142135623730951},"115":{"tf":1.0},"116":{"tf":2.449489742783178},"117":{"tf":1.7320508075688772},"118":{"tf":1.4142135623730951},"119":{"tf":1.0},"12":{"tf":1.4142135623730951},"121":{"tf":1.7320508075688772},"122":{"tf":1.7320508075688772},"124":{"tf":1.0},"125":{"tf":1.7320508075688772},"127":{"tf":1.0},"128":{"tf":1.4142135623730951},"129":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.7320508075688772},"133":{"tf":1.4142135623730951},"134":{"tf":1.7320508075688772},"135":{"tf":1.4142135623730951},"14":{"tf":1.0},"16":{"tf":1.0},"72":{"tf":1.4142135623730951}}}}},"l":{"df":0,"docs":{},"i":{"b":{"df":2,"docs":{"116":{"tf":1.0},"117":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"a":{"df":5,"docs":{"125":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"40":{"tf":1.4142135623730951},"82":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":4,"docs":{"10":{"tf":1.0},"17":{"tf":1.0},"23":{"tf":1.0},"64":{"tf":1.0}}}}}}},"y":{"df":1,"docs":{"35":{"tf":1.0}}}},"f":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}},"t":{"df":1,"docs":{"125":{"tf":1.0}}}}}},")":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"125":{"tf":1.0}}}}}},"df":0,"docs":{}},"1":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"56":{"tf":1.0}}}}}},"df":0,"docs":{}},"3":{"2":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}},"6":{"4":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"b":{"df":1,"docs":{"34":{"tf":1.4142135623730951}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.4142135623730951}}}}}}},"t":{"df":1,"docs":{"34":{"tf":1.0}}}},">":{"(":{"df":0,"docs":{},"f":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"e":{"df":3,"docs":{"24":{"tf":1.0},"27":{"tf":1.0},"73":{"tf":1.0}}},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"125":{"tf":1.0},"58":{"tf":1.0}}}},"t":{"df":14,"docs":{"11":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"41":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0},"67":{"tf":1.0},"73":{"tf":1.0},"83":{"tf":1.0},"92":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"21":{"tf":1.0},"89":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":14,"docs":{"26":{"tf":2.0},"28":{"tf":1.0},"30":{"tf":1.0},"45":{"tf":1.0},"60":{"tf":1.7320508075688772},"61":{"tf":1.0},"64":{"tf":1.0},"68":{"tf":1.0},"72":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951},"93":{"tf":1.0}}},"r":{"df":1,"docs":{"82":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":11,"docs":{"113":{"tf":1.0},"125":{"tf":1.0},"14":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"35":{"tf":1.0},"59":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":1.0},"73":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"t":{">":{"(":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"l":{"df":4,"docs":{"110":{"tf":1.0},"19":{"tf":1.0},"28":{"tf":1.0},"43":{"tf":1.4142135623730951}}},"s":{"df":6,"docs":{"103":{"tf":1.0},"133":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.0},"58":{"tf":1.0},"62":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"89":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"60":{"tf":1.0}}}}},"r":{"df":3,"docs":{"103":{"tf":1.0},"35":{"tf":1.0},"75":{"tf":1.0}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"41":{"tf":1.0},"64":{"tf":1.0},"72":{"tf":1.0}}}}}},"t":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"122":{"tf":1.0}}}},"df":0,"docs":{}},"df":2,"docs":{"73":{"tf":1.0},"82":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.0},"3":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"63":{"tf":1.0},"82":{"tf":1.0},"9":{"tf":1.0}}}}}},"df":4,"docs":{"31":{"tf":3.0},"34":{"tf":2.6457513110645907},"4":{"tf":1.0},"63":{"tf":2.0}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":12,"docs":{"1":{"tf":1.0},"12":{"tf":1.0},"132":{"tf":1.0},"133":{"tf":2.0},"14":{"tf":1.0},"15":{"tf":1.0},"19":{"tf":1.0},"4":{"tf":1.4142135623730951},"59":{"tf":1.0},"7":{"tf":1.0},"82":{"tf":1.0},"9":{"tf":1.0}},"e":{"(":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"134":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"71":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"134":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"59":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"d":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":3,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"19":{"tf":1.0}}}},"n":{"c":{"df":3,"docs":{"104":{"tf":2.6457513110645907},"105":{"tf":1.0},"77":{"tf":1.0}}},"df":0,"docs":{}},"t":{"c":{"df":0,"docs":{},"h":{"_":{"a":{"d":{"d":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"b":{"df":1,"docs":{"104":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"w":{"df":6,"docs":{"100":{"tf":1.0},"113":{"tf":1.0},"119":{"tf":1.0},"26":{"tf":1.0},"82":{"tf":1.0},"89":{"tf":1.0}}}},"f":{"df":0,"docs":{},"i":{"df":9,"docs":{"1":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.7320508075688772},"131":{"tf":1.4142135623730951},"14":{"tf":2.6457513110645907},"15":{"tf":1.0},"17":{"tf":1.0},"3":{"tf":1.0},"64":{"tf":1.0}}}},"i":{"d":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":24,"docs":{"10":{"tf":1.4142135623730951},"125":{"tf":1.4142135623730951},"131":{"tf":1.4142135623730951},"14":{"tf":1.7320508075688772},"15":{"tf":2.449489742783178},"16":{"tf":1.7320508075688772},"17":{"tf":1.4142135623730951},"24":{"tf":1.0},"34":{"tf":1.7320508075688772},"35":{"tf":1.7320508075688772},"37":{"tf":1.0},"39":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"40":{"tf":2.0},"41":{"tf":1.4142135623730951},"43":{"tf":1.0},"5":{"tf":1.7320508075688772},"52":{"tf":1.4142135623730951},"55":{"tf":1.0},"56":{"tf":1.4142135623730951},"58":{"tf":1.0},"59":{"tf":3.0},"7":{"tf":2.6457513110645907},"9":{"tf":1.0}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"14":{"tf":1.4142135623730951},"16":{"tf":2.0}}}}}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"90":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"82":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{"df":4,"docs":{"109":{"tf":1.0},"115":{"tf":1.7320508075688772},"133":{"tf":1.0},"57":{"tf":1.0}}},"l":{"df":3,"docs":{"52":{"tf":1.0},"60":{"tf":1.0},"67":{"tf":1.4142135623730951}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":13,"docs":{"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"11":{"tf":1.0},"115":{"tf":1.0},"119":{"tf":1.7320508075688772},"46":{"tf":1.0},"56":{"tf":1.0},"67":{"tf":1.7320508075688772},"72":{"tf":1.0},"75":{"tf":1.0},"88":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}}}},"d":{"df":6,"docs":{"115":{"tf":1.0},"20":{"tf":1.0},"24":{"tf":1.4142135623730951},"46":{"tf":1.0},"47":{"tf":1.0},"52":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":11,"docs":{"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"43":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0},"82":{"tf":1.7320508075688772},"92":{"tf":1.4142135623730951},"94":{"tf":1.0}},"r":{"df":1,"docs":{"35":{"tf":1.0}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":4,"docs":{"59":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.0},"93":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"46":{"tf":1.0}}}}}}}},"df":32,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"109":{"tf":1.0},"114":{"tf":1.0},"21":{"tf":1.0},"24":{"tf":1.0},"28":{"tf":1.7320508075688772},"34":{"tf":2.0},"35":{"tf":2.449489742783178},"43":{"tf":1.7320508075688772},"44":{"tf":1.0},"46":{"tf":1.7320508075688772},"52":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0},"62":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.7320508075688772},"83":{"tf":1.0},"85":{"tf":1.0},"93":{"tf":2.23606797749979},"96":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951}}}}},"t":{"df":3,"docs":{"16":{"tf":1.0},"33":{"tf":1.0},"62":{"tf":1.0}}},"x":{"df":9,"docs":{"28":{"tf":1.0},"31":{"tf":1.0},"46":{"tf":1.0},"61":{"tf":1.7320508075688772},"66":{"tf":1.0},"67":{"tf":1.0},"72":{"tf":1.0},"92":{"tf":1.0},"96":{"tf":1.4142135623730951}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"114":{"tf":1.0},"14":{"tf":1.0},"55":{"tf":2.449489742783178}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"119":{"tf":1.4142135623730951}}}}},"w":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"df":1,"docs":{"125":{"tf":1.0}},"p":{"df":1,"docs":{"34":{"tf":1.0}}}},"o":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"52":{"tf":1.0}}}},"w":{"df":1,"docs":{"54":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"t":{":":{":":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{">":{"(":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"135":{"tf":1.0}}}}}}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"135":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"(":{"&":{"\'":{"a":{"df":2,"docs":{"31":{"tf":1.7320508075688772},"34":{"tf":1.4142135623730951}}},"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"(":{"df":0,"docs":{},"u":{"8":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":1,"docs":{"135":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"*":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":1.0}}}}}},"a":{"df":1,"docs":{"31":{"tf":1.0}}},"c":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"125":{"tf":2.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"116":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":1,"docs":{"34":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"34":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"125":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{}}}}}}},"t":{"df":1,"docs":{"34":{"tf":1.4142135623730951}}}},"df":81,"docs":{"10":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.4142135623730951},"103":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"105":{"tf":2.23606797749979},"109":{"tf":1.0},"11":{"tf":1.4142135623730951},"110":{"tf":2.8284271247461903},"111":{"tf":4.47213595499958},"114":{"tf":1.4142135623730951},"116":{"tf":2.0},"117":{"tf":2.0},"120":{"tf":1.4142135623730951},"121":{"tf":1.4142135623730951},"122":{"tf":1.4142135623730951},"124":{"tf":2.0},"125":{"tf":2.23606797749979},"127":{"tf":1.0},"128":{"tf":1.4142135623730951},"129":{"tf":1.4142135623730951},"130":{"tf":1.4142135623730951},"131":{"tf":2.449489742783178},"134":{"tf":1.7320508075688772},"135":{"tf":2.23606797749979},"16":{"tf":1.0},"19":{"tf":1.7320508075688772},"22":{"tf":2.449489742783178},"23":{"tf":1.4142135623730951},"24":{"tf":2.6457513110645907},"25":{"tf":1.0},"26":{"tf":2.449489742783178},"27":{"tf":2.449489742783178},"28":{"tf":1.7320508075688772},"29":{"tf":4.47213595499958},"3":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"31":{"tf":3.605551275463989},"32":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"34":{"tf":4.0},"35":{"tf":2.8284271247461903},"36":{"tf":2.8284271247461903},"39":{"tf":1.4142135623730951},"4":{"tf":1.0},"40":{"tf":1.7320508075688772},"41":{"tf":1.7320508075688772},"43":{"tf":4.58257569495584},"44":{"tf":1.4142135623730951},"45":{"tf":1.7320508075688772},"46":{"tf":2.8284271247461903},"5":{"tf":2.8284271247461903},"54":{"tf":2.6457513110645907},"55":{"tf":2.23606797749979},"56":{"tf":1.4142135623730951},"58":{"tf":1.0},"59":{"tf":3.3166247903554},"62":{"tf":1.7320508075688772},"63":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":2.6457513110645907},"7":{"tf":2.6457513110645907},"70":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"72":{"tf":3.4641016151377544},"78":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":2.0},"83":{"tf":1.4142135623730951},"84":{"tf":1.0},"85":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951},"87":{"tf":2.23606797749979},"88":{"tf":3.0},"89":{"tf":3.4641016151377544},"9":{"tf":1.4142135623730951},"91":{"tf":1.7320508075688772},"92":{"tf":2.449489742783178},"93":{"tf":5.656854249492381},"96":{"tf":1.4142135623730951},"98":{"tf":1.0}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"29":{"tf":1.0},"63":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"c":{"df":0,"docs":{},"u":{"df":2,"docs":{"34":{"tf":1.0},"60":{"tf":1.0}},"s":{"df":2,"docs":{"35":{"tf":1.0},"45":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":41,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"11":{"tf":1.0},"110":{"tf":1.0},"114":{"tf":1.4142135623730951},"115":{"tf":1.0},"125":{"tf":1.0},"20":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.0},"34":{"tf":2.6457513110645907},"35":{"tf":1.4142135623730951},"36":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.7320508075688772},"46":{"tf":1.0},"5":{"tf":1.4142135623730951},"56":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":1.0},"67":{"tf":1.7320508075688772},"7":{"tf":1.7320508075688772},"72":{"tf":1.0},"82":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0}}}}}},"o":{"(":{"1":{"0":{"df":1,"docs":{"124":{"tf":1.0}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"131":{"tf":1.4142135623730951}}}}},"df":1,"docs":{"29":{"tf":1.0}},"f":{"3":{"2":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"131":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"df":1,"docs":{"45":{"tf":1.4142135623730951}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"131":{"tf":1.0}}},"df":0,"docs":{}}}},"x":{"df":1,"docs":{"124":{"tf":1.4142135623730951}}}},".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"a":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"a":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{":":{":":{"<":{"\'":{"c":{">":{"(":{"&":{"\'":{"c":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{":":{":":{"<":{"\'":{"d":{">":{"(":{"&":{"\'":{"d":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}},"u":{"1":{"6":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"3":{"2":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"x":{"df":1,"docs":{"45":{"tf":1.4142135623730951}}}},"[":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"83":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"46":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"df":11,"docs":{"10":{"tf":1.0},"119":{"tf":2.0},"131":{"tf":2.6457513110645907},"15":{"tf":1.0},"27":{"tf":4.123105625617661},"43":{"tf":1.4142135623730951},"44":{"tf":2.0},"45":{"tf":1.0},"46":{"tf":1.0},"58":{"tf":1.7320508075688772},"7":{"tf":1.0}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"131":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}}},"r":{"<":{"\'":{"a":{"df":1,"docs":{"31":{"tf":2.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"i":{"d":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"39":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"c":{"df":8,"docs":{"17":{"tf":1.4142135623730951},"18":{"tf":1.0},"19":{"tf":1.0},"27":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"63":{"tf":1.0},"76":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"92":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":12,"docs":{"106":{"tf":1.0},"107":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":2.23606797749979},"112":{"tf":1.0},"114":{"tf":1.0},"121":{"tf":1.7320508075688772},"122":{"tf":2.0},"123":{"tf":1.0},"124":{"tf":1.0},"126":{"tf":2.23606797749979},"3":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"52":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0}}}}}},"v":{"df":4,"docs":{"104":{"tf":1.0},"35":{"tf":1.0},"68":{"tf":1.0},"92":{"tf":1.0}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":4,"docs":{"1":{"tf":1.0},"46":{"tf":1.4142135623730951},"60":{"tf":1.0},"76":{"tf":1.0}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"34":{"tf":1.0},"63":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0}}}}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"29":{"tf":1.0},"34":{"tf":1.0}}},"t":{"df":4,"docs":{"111":{"tf":1.0},"119":{"tf":1.0},"19":{"tf":1.0},"24":{"tf":2.0}}}},"df":3,"docs":{"119":{"tf":1.0},"60":{"tf":1.0},"75":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"117":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"82":{"tf":1.0}}}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"118":{"tf":1.0},"87":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"119":{"tf":1.0},"135":{"tf":1.0},"20":{"tf":1.0},"32":{"tf":1.0},"45":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"37":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"82":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"127":{"tf":1.7320508075688772}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":2,"docs":{"119":{"tf":2.23606797749979},"70":{"tf":1.0}}}}}}}},"n":{"c":{"a":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"\'":{"d":{"df":2,"docs":{"35":{"tf":1.0},"61":{"tf":1.0}}},"df":0,"docs":{}},"(":{"df":0,"docs":{},"p":{"df":1,"docs":{"72":{"tf":1.0}}}},"d":{"df":1,"docs":{"62":{"tf":1.0}}},"df":22,"docs":{"0":{"tf":1.0},"103":{"tf":1.0},"19":{"tf":1.4142135623730951},"2":{"tf":1.0},"21":{"tf":1.0},"34":{"tf":1.7320508075688772},"4":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.7320508075688772},"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"66":{"tf":1.0},"72":{"tf":1.7320508075688772},"75":{"tf":1.0},"76":{"tf":1.7320508075688772},"77":{"tf":1.4142135623730951},"78":{"tf":1.7320508075688772},"84":{"tf":1.0},"87":{"tf":1.7320508075688772},"88":{"tf":1.4142135623730951},"96":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"22":{"tf":1.4142135623730951},"3":{"tf":1.0},"34":{"tf":1.0},"79":{"tf":1.0}}}},"z":{"df":1,"docs":{"19":{"tf":1.0}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"55":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"76":{"tf":1.0},"77":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"b":{"(":{"df":1,"docs":{"29":{"tf":1.0}}},"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{".":{"a":{"d":{"d":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"87":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":8,"docs":{"22":{"tf":1.0},"4":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":1.0},"67":{"tf":1.0},"73":{"tf":1.0},"83":{"tf":1.0},"89":{"tf":1.0}},"i":{"df":4,"docs":{"46":{"tf":1.0},"56":{"tf":1.4142135623730951},"65":{"tf":1.0},"73":{"tf":1.0}}}}},"n":{"c":{"df":1,"docs":{"31":{"tf":2.449489742783178}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}}}}}}}},"df":44,"docs":{"100":{"tf":1.0},"106":{"tf":1.0},"110":{"tf":2.449489742783178},"111":{"tf":2.23606797749979},"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":2.0},"117":{"tf":1.0},"118":{"tf":1.4142135623730951},"120":{"tf":2.23606797749979},"122":{"tf":1.4142135623730951},"123":{"tf":1.0},"124":{"tf":2.0},"125":{"tf":3.0},"126":{"tf":1.0},"127":{"tf":2.0},"128":{"tf":2.449489742783178},"134":{"tf":1.4142135623730951},"135":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"16":{"tf":1.0},"19":{"tf":1.4142135623730951},"22":{"tf":2.8284271247461903},"23":{"tf":1.4142135623730951},"24":{"tf":2.23606797749979},"29":{"tf":1.0},"3":{"tf":2.6457513110645907},"30":{"tf":2.449489742783178},"34":{"tf":3.605551275463989},"4":{"tf":2.23606797749979},"41":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":3.0},"5":{"tf":2.449489742783178},"52":{"tf":1.4142135623730951},"56":{"tf":2.23606797749979},"58":{"tf":1.0},"60":{"tf":1.4142135623730951},"64":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.4142135623730951},"82":{"tf":1.7320508075688772},"83":{"tf":1.0},"85":{"tf":1.4142135623730951}},"’":{"df":1,"docs":{"3":{"tf":1.0}}}}}}}},"d":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":8,"docs":{"3":{"tf":1.4142135623730951},"5":{"tf":1.7320508075688772},"63":{"tf":1.0},"64":{"tf":1.0},"71":{"tf":1.4142135623730951},"73":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":5,"docs":{"14":{"tf":1.0},"3":{"tf":1.0},"36":{"tf":1.7320508075688772},"59":{"tf":1.0},"68":{"tf":1.0}}}}}},"’":{"df":2,"docs":{"31":{"tf":1.0},"34":{"tf":1.0}}}},"g":{"a":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"35":{"tf":1.4142135623730951},"36":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"2":{"tf":1.0}}}},"p":{"df":2,"docs":{"73":{"tf":1.0},"76":{"tf":1.0}}},"r":{"b":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"19":{"tf":1.4142135623730951},"82":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"122":{"tf":1.0}}}}},"c":{"c":{"df":1,"docs":{"115":{"tf":1.7320508075688772}}},"df":2,"docs":{"19":{"tf":1.4142135623730951},"57":{"tf":1.0}},"’":{"d":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"34":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":33,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.0},"134":{"tf":1.0},"16":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":1.4142135623730951},"3":{"tf":1.7320508075688772},"34":{"tf":2.0},"35":{"tf":2.449489742783178},"36":{"tf":1.4142135623730951},"38":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.7320508075688772},"41":{"tf":1.7320508075688772},"43":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"5":{"tf":1.7320508075688772},"52":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.4142135623730951},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.4142135623730951},"65":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.7320508075688772},"76":{"tf":1.0},"82":{"tf":2.0},"9":{"tf":1.0}}}}},"p":{"df":2,"docs":{"82":{"tf":2.6457513110645907},"89":{"tf":1.0}},"’":{"df":1,"docs":{"82":{"tf":1.0}}}},"t":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"67":{"tf":1.0}}}}}}},"df":0,"docs":{}},"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"\'":{"df":0,"docs":{},"m":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{}},"<":{"\'":{"a":{">":{"(":{"&":{"\'":{"a":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{},"r":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"<":{"\'":{"a":{">":{"(":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"29":{"tf":1.0},"34":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":16,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"118":{"tf":1.0},"125":{"tf":1.0},"134":{"tf":1.0},"19":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.0},"5":{"tf":1.0},"55":{"tf":1.4142135623730951},"56":{"tf":1.0},"60":{"tf":1.0},"70":{"tf":1.0},"82":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0}}}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":22,"docs":{"1":{"tf":1.0},"131":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"4":{"tf":1.0},"44":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"5":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":1.0},"7":{"tf":1.0},"72":{"tf":1.4142135623730951},"76":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"96":{"tf":1.4142135623730951}},"n":{"df":11,"docs":{"10":{"tf":1.0},"118":{"tf":1.0},"135":{"tf":1.0},"27":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.4142135623730951},"39":{"tf":1.0},"43":{"tf":1.0},"48":{"tf":1.0},"7":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"c":{"df":3,"docs":{"35":{"tf":1.0},"43":{"tf":1.0},"62":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{".":{"d":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"c":{".":{"c":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{":":{"<":{"df":0,"docs":{},"u":{"8":{"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"59":{"tf":2.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":2,"docs":{"3":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}},"df":8,"docs":{"117":{"tf":1.0},"121":{"tf":2.23606797749979},"22":{"tf":1.0},"24":{"tf":1.0},"59":{"tf":1.7320508075688772},"75":{"tf":1.0},"77":{"tf":1.0},"82":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"34":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"e":{"df":4,"docs":{"119":{"tf":1.0},"40":{"tf":1.4142135623730951},"41":{"tf":2.23606797749979},"42":{"tf":1.0}}}}},"o":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":25,"docs":{"1":{"tf":1.0},"103":{"tf":1.0},"114":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"3":{"tf":1.4142135623730951},"33":{"tf":1.0},"34":{"tf":1.0},"40":{"tf":1.0},"52":{"tf":1.7320508075688772},"56":{"tf":1.4142135623730951},"6":{"tf":1.0},"60":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.0},"80":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"87":{"tf":1.7320508075688772},"88":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0},"96":{"tf":1.0}},"e":{"df":8,"docs":{"127":{"tf":1.0},"128":{"tf":1.0},"34":{"tf":1.0},"40":{"tf":1.0},"55":{"tf":2.23606797749979},"59":{"tf":1.0},"63":{"tf":1.7320508075688772},"64":{"tf":1.4142135623730951}}},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"52":{"tf":1.0}}},"n":{"a":{"df":1,"docs":{"80":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"d":{"df":16,"docs":{"2":{"tf":1.0},"23":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"40":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"88":{"tf":1.0},"92":{"tf":1.0},"94":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"62":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"27":{"tf":1.0}}}},"p":{"df":0,"docs":{},"h":{"df":2,"docs":{"135":{"tf":1.0},"73":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"121":{"tf":1.0},"2":{"tf":1.0},"73":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"69":{"tf":1.0}}}},"w":{"df":1,"docs":{"64":{"tf":1.0}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"73":{"tf":1.0},"80":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}}},"w":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"82":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":4,"docs":{"5":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0}}}}},"u":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":23,"docs":{"1":{"tf":1.0},"100":{"tf":1.0},"102":{"tf":1.0},"105":{"tf":1.0},"11":{"tf":1.0},"111":{"tf":1.4142135623730951},"112":{"tf":1.0},"118":{"tf":1.0},"123":{"tf":1.4142135623730951},"125":{"tf":1.0},"129":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.7320508075688772},"3":{"tf":1.4142135623730951},"34":{"tf":1.0},"36":{"tf":1.0},"52":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"70":{"tf":1.0},"75":{"tf":3.0},"98":{"tf":1.0}}}}}},"d":{"df":8,"docs":{"11":{"tf":1.0},"5":{"tf":1.0},"63":{"tf":2.8284271247461903},"65":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0},"82":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"52":{"tf":1.0}}}}},"df":0,"docs":{}},"s":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"14":{"tf":1.0}}}}},"i":{"d":{"df":1,"docs":{"107":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":1,"docs":{"1":{"tf":1.0}}}},"ӛ":{"_":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"h":{"1":{"df":1,"docs":{"34":{"tf":1.0}}},"2":{"df":1,"docs":{"34":{"tf":1.0}}},"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"66":{"tf":1.0}}}},"d":{"df":0,"docs":{},"n":{"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":1,"docs":{"75":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":4,"docs":{"103":{"tf":1.0},"50":{"tf":1.0},"82":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"t":{"df":2,"docs":{"135":{"tf":1.4142135623730951},"64":{"tf":1.0}}}},"n":{"d":{"df":6,"docs":{"112":{"tf":1.0},"120":{"tf":1.0},"3":{"tf":1.4142135623730951},"56":{"tf":1.7320508075688772},"74":{"tf":1.0},"75":{"tf":1.0}},"l":{"df":17,"docs":{"103":{"tf":1.0},"123":{"tf":1.0},"125":{"tf":1.0},"131":{"tf":1.4142135623730951},"27":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"5":{"tf":1.0},"56":{"tf":1.4142135623730951},"60":{"tf":1.0},"64":{"tf":2.0},"82":{"tf":2.0},"85":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"90":{"tf":1.4142135623730951},"93":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"134":{"tf":1.0}}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":29,"docs":{"103":{"tf":1.4142135623730951},"104":{"tf":2.449489742783178},"19":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.7320508075688772},"4":{"tf":1.0},"46":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.4142135623730951},"64":{"tf":1.0},"67":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.7320508075688772},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"86":{"tf":1.0},"99":{"tf":1.0}}}},"i":{"df":3,"docs":{"1":{"tf":1.0},"34":{"tf":1.0},"67":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"59":{"tf":1.0},"62":{"tf":1.0}}}}}}},"r":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}},"d":{"df":4,"docs":{"17":{"tf":1.0},"56":{"tf":1.0},"61":{"tf":1.0},"71":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"87":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"60":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":5,"docs":{"2":{"tf":1.0},"21":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":3.1622776601683795},"76":{"tf":2.449489742783178}}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"45":{"tf":1.0},"47":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"28":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"p":{"<":{"df":0,"docs":{},"k":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}}},"df":2,"docs":{"10":{"tf":1.0},"34":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":3,"docs":{"15":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":8,"docs":{"133":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":1.0},"40":{"tf":1.0},"5":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"77":{"tf":1.0}},"n":{"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":5,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"61":{"tf":1.0},"67":{"tf":1.0},"84":{"tf":1.0}}}}}},"o":{"c":{"df":2,"docs":{"36":{"tf":1.0},"56":{"tf":1.0}}},"df":0,"docs":{}}},"z":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"22":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":1,"docs":{"34":{"tf":2.0}},"e":{"a":{"d":{"df":1,"docs":{"43":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"67":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},":":{":":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{":":{":":{"<":{"df":0,"docs":{},"r":{"c":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"62":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"[":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"67":{"tf":3.3166247903554}}}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"67":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"67":{"tf":2.449489742783178}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":6,"docs":{"104":{"tf":1.0},"67":{"tf":2.449489742783178},"68":{"tf":1.0},"72":{"tf":1.7320508075688772},"82":{"tf":1.0},"96":{"tf":1.0}}},"v":{"df":0,"docs":{},"i":{"df":1,"docs":{"64":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"64":{"tf":1.0},"82":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"114":{"tf":1.0},"115":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}}}}}},"df":4,"docs":{"115":{"tf":1.0},"32":{"tf":1.7320508075688772},"33":{"tf":1.7320508075688772},"34":{"tf":4.0}}}},"p":{"df":5,"docs":{"135":{"tf":1.0},"36":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"56":{"tf":1.0}}}},"n":{"c":{"df":1,"docs":{"41":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":31,"docs":{"102":{"tf":1.0},"103":{"tf":2.0},"104":{"tf":1.0},"105":{"tf":1.7320508075688772},"125":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.4142135623730951},"26":{"tf":2.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.7320508075688772},"3":{"tf":1.0},"34":{"tf":2.23606797749979},"35":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"41":{"tf":1.7320508075688772},"43":{"tf":1.7320508075688772},"46":{"tf":2.0},"52":{"tf":1.0},"54":{"tf":1.4142135623730951},"56":{"tf":1.0},"63":{"tf":2.6457513110645907},"67":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0},"98":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.0}}}},"’":{"df":11,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"105":{"tf":1.0},"131":{"tf":1.0},"21":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.7320508075688772},"66":{"tf":1.0},"82":{"tf":1.0},"87":{"tf":1.4142135623730951},"92":{"tf":1.0}}}}},"y":{"df":1,"docs":{"82":{"tf":1.0}}}},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"122":{"tf":1.0},"36":{"tf":1.4142135623730951},"55":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"111":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"75":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"h":{"df":5,"docs":{"1":{"tf":1.0},"111":{"tf":1.0},"2":{"tf":1.0},"23":{"tf":1.0},"3":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"111":{"tf":1.0},"31":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"82":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"104":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"26":{"tf":1.0},"39":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"l":{"d":{"df":7,"docs":{"111":{"tf":1.4142135623730951},"34":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0},"60":{"tf":1.0},"77":{"tf":1.0},"87":{"tf":1.0}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"(":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"o":{"df":1,"docs":{"67":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"67":{"tf":1.0}}}}}}}},":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"<":{"\'":{"a":{"df":1,"docs":{"67":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}}}}},"df":2,"docs":{"23":{"tf":1.0},"67":{"tf":2.23606797749979}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"3":{"tf":1.0}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"34":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"43":{"tf":1.0},"73":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"52":{"tf":1.0},"62":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"135":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"135":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"t":{"b":{"df":1,"docs":{"31":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"135":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"135":{"tf":2.23606797749979}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"131":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}}}}},"i":{"+":{"1":{"df":1,"docs":{"86":{"tf":1.4142135623730951}}},"df":0,"docs":{}},".":{"df":3,"docs":{"132":{"tf":1.0},"134":{"tf":1.0},"4":{"tf":1.0}}},"3":{"2":{"df":14,"docs":{"116":{"tf":1.4142135623730951},"117":{"tf":2.0},"120":{"tf":1.4142135623730951},"121":{"tf":1.0},"124":{"tf":1.4142135623730951},"130":{"tf":1.0},"23":{"tf":2.6457513110645907},"25":{"tf":1.0},"26":{"tf":1.0},"43":{"tf":1.7320508075688772},"45":{"tf":2.6457513110645907},"46":{"tf":1.4142135623730951},"54":{"tf":2.449489742783178},"7":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"e":{"a":{"df":5,"docs":{"0":{"tf":1.0},"131":{"tf":1.0},"33":{"tf":1.4142135623730951},"67":{"tf":1.0},"82":{"tf":1.0}},"l":{"df":3,"docs":{"6":{"tf":1.7320508075688772},"64":{"tf":1.0},"75":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"89":{"tf":1.0}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"88":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":1,"docs":{"87":{"tf":1.0}}}}},"x":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"(":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":3,"docs":{"5":{"tf":1.4142135623730951},"56":{"tf":1.0},"70":{"tf":2.23606797749979}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":2,"docs":{"29":{"tf":1.4142135623730951},"56":{"tf":1.0}}}}}},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"41":{"tf":1.0},"56":{"tf":1.0},"7":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"126":{"tf":1.0},"61":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"104":{"tf":1.0},"27":{"tf":1.4142135623730951},"96":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"l":{"<":{"#":{"[":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"y":{"_":{"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":2,"docs":{"36":{"tf":1.0},"41":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"\'":{"a":{"df":7,"docs":{"35":{"tf":1.4142135623730951},"36":{"tf":1.0},"43":{"tf":2.6457513110645907},"45":{"tf":1.0},"67":{"tf":1.4142135623730951},"89":{"tf":2.0},"93":{"tf":1.7320508075688772}}},"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":1,"docs":{"31":{"tf":1.7320508075688772}}},"t":{"df":29,"docs":{"101":{"tf":1.0},"102":{"tf":2.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":2.449489742783178},"35":{"tf":1.0},"36":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"41":{"tf":1.0},"43":{"tf":2.0},"46":{"tf":1.4142135623730951},"5":{"tf":1.0},"59":{"tf":2.23606797749979},"62":{"tf":1.4142135623730951},"66":{"tf":1.0},"67":{"tf":1.0},"72":{"tf":2.6457513110645907},"81":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"84":{"tf":1.0},"85":{"tf":1.4142135623730951},"87":{"tf":2.0},"88":{"tf":2.8284271247461903},"89":{"tf":2.449489742783178},"91":{"tf":1.4142135623730951},"92":{"tf":2.0},"93":{"tf":3.872983346207417},"98":{"tf":1.0},"99":{"tf":1.4142135623730951}}}},"df":12,"docs":{"135":{"tf":1.4142135623730951},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"29":{"tf":2.0},"34":{"tf":1.0},"36":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"71":{"tf":2.0},"89":{"tf":1.0},"92":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":41,"docs":{"10":{"tf":1.4142135623730951},"101":{"tf":1.4142135623730951},"103":{"tf":2.23606797749979},"104":{"tf":1.7320508075688772},"14":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":2.449489742783178},"24":{"tf":1.0},"3":{"tf":5.196152422706632},"32":{"tf":1.4142135623730951},"35":{"tf":2.0},"4":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.4142135623730951},"45":{"tf":2.0},"46":{"tf":3.605551275463989},"5":{"tf":2.23606797749979},"55":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":2.23606797749979},"62":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":2.23606797749979},"72":{"tf":2.23606797749979},"80":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.4142135623730951},"87":{"tf":1.7320508075688772},"88":{"tf":1.7320508075688772},"89":{"tf":1.4142135623730951},"9":{"tf":1.0},"94":{"tf":1.4142135623730951},"95":{"tf":2.6457513110645907},"96":{"tf":1.0},"97":{"tf":1.0},"99":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"3":{"tf":2.0},"71":{"tf":1.0}}}}}}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"36":{"tf":1.0},"62":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"23":{"tf":1.0},"45":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.7320508075688772}}}}}}},"df":9,"docs":{"1":{"tf":1.0},"103":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.0},"34":{"tf":1.0},"56":{"tf":1.0},"63":{"tf":1.0},"77":{"tf":1.0},"96":{"tf":1.0}}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"2":{"tf":1.0},"96":{"tf":1.0}}}}}}},"df":19,"docs":{"101":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"126":{"tf":1.0},"14":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"34":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":1.4142135623730951},"57":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0},"82":{"tf":1.7320508075688772}}}},"s":{"df":1,"docs":{"28":{"tf":1.0}},"s":{"df":8,"docs":{"11":{"tf":1.0},"22":{"tf":1.4142135623730951},"30":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0},"70":{"tf":2.0},"71":{"tf":1.0},"76":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"v":{"df":4,"docs":{"104":{"tf":1.0},"17":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0}}}}}}},"n":{"a":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"59":{"tf":1.0},"60":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"71":{"tf":1.0}}}}}}}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"82":{"tf":2.0}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":19,"docs":{"1":{"tf":1.4142135623730951},"10":{"tf":1.0},"107":{"tf":1.0},"117":{"tf":1.0},"119":{"tf":1.7320508075688772},"123":{"tf":1.0},"125":{"tf":1.0},"131":{"tf":1.0},"133":{"tf":1.0},"134":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":1.0},"50":{"tf":1.0},"56":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0},"96":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"35":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"18":{"tf":1.0},"43":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"68":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"67":{"tf":1.0},"68":{"tf":1.4142135623730951},"73":{"tf":1.0},"76":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"5":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":6,"docs":{"14":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0},"70":{"tf":1.0},"75":{"tf":1.0},"96":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"70":{"tf":1.0},"71":{"tf":1.7320508075688772},"77":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"d":{"df":5,"docs":{"103":{"tf":1.7320508075688772},"2":{"tf":1.0},"44":{"tf":1.0},"58":{"tf":1.0},"71":{"tf":1.0}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":7,"docs":{"103":{"tf":1.4142135623730951},"56":{"tf":1.0},"62":{"tf":1.0},"70":{"tf":1.4142135623730951},"79":{"tf":1.0},"83":{"tf":1.0},"92":{"tf":1.0}}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":6,"docs":{"41":{"tf":1.4142135623730951},"7":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.4142135623730951}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"34":{"tf":1.0},"82":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}},"x":{"(":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{":":{":":{"<":{"\'":{"b":{">":{"(":{"&":{"\'":{"b":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"df":14,"docs":{"3":{"tf":1.4142135623730951},"43":{"tf":1.0},"46":{"tf":2.6457513110645907},"5":{"tf":1.7320508075688772},"56":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":4.123105625617661},"7":{"tf":1.0},"70":{"tf":1.7320508075688772},"82":{"tf":1.0},"83":{"tf":2.23606797749979},"85":{"tf":1.0},"86":{"tf":2.8284271247461903},"93":{"tf":2.449489742783178}}}},"i":{"c":{"df":3,"docs":{"3":{"tf":1.4142135623730951},"48":{"tf":1.0},"82":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"36":{"tf":1.4142135623730951},"46":{"tf":1.0},"7":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"87":{"tf":1.0}}}}}}}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":2,"docs":{"56":{"tf":1.0},"77":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"c":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}}}},"f":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"11":{"tf":1.0},"48":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"28":{"tf":1.0},"52":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"1":{"tf":1.0},"31":{"tf":1.0},"60":{"tf":1.0},"82":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}}}},"o":{")":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"135":{"tf":1.0}}}}},"df":0,"docs":{}},"df":2,"docs":{"59":{"tf":1.0},"9":{"tf":1.7320508075688772}},"r":{"df":0,"docs":{},"m":{"df":18,"docs":{"1":{"tf":1.0},"103":{"tf":1.0},"109":{"tf":1.0},"112":{"tf":1.0},"130":{"tf":1.0},"23":{"tf":1.0},"34":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"55":{"tf":1.0},"63":{"tf":1.0},"82":{"tf":1.0},"87":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":2.0},"96":{"tf":1.0},"99":{"tf":1.0}}}}}},"h":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"3":{"tf":1.0},"5":{"tf":1.0},"96":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"34":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"71":{"tf":1.0},"73":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"54":{"tf":1.0},"55":{"tf":1.7320508075688772},"56":{"tf":1.0}},"i":{"df":13,"docs":{"54":{"tf":1.7320508075688772},"55":{"tf":2.6457513110645907},"56":{"tf":4.0},"57":{"tf":1.0},"58":{"tf":1.4142135623730951},"60":{"tf":1.0},"72":{"tf":1.4142135623730951},"75":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":1.4142135623730951},"87":{"tf":1.0},"89":{"tf":1.0},"92":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":3,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"105":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"c":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"_":{"a":{"d":{"d":{"(":{"1":{"df":2,"docs":{"103":{"tf":1.7320508075688772},"105":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"b":{"(":{"1":{"df":2,"docs":{"104":{"tf":1.4142135623730951},"105":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":11,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":2.0},"104":{"tf":1.7320508075688772},"105":{"tf":2.0},"15":{"tf":1.0},"41":{"tf":1.0},"59":{"tf":1.0},"62":{"tf":1.0},"72":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"110":{"tf":1.0},"111":{"tf":1.0}}}}}}}}},"df":7,"docs":{"110":{"tf":1.0},"111":{"tf":1.0},"22":{"tf":5.196152422706632},"29":{"tf":3.0},"30":{"tf":1.4142135623730951},"34":{"tf":2.449489742783178},"72":{"tf":1.4142135623730951}}}}},"s":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"87":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"86":{"tf":1.0},"93":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":2,"docs":{"7":{"tf":1.0},"86":{"tf":2.23606797749979}}}}},"i":{"d":{"df":10,"docs":{"101":{"tf":1.4142135623730951},"103":{"tf":1.0},"104":{"tf":1.0},"109":{"tf":1.0},"118":{"tf":1.0},"120":{"tf":1.0},"24":{"tf":1.0},"3":{"tf":1.0},"37":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"35":{"tf":1.4142135623730951},"36":{"tf":2.0}},"o":{"df":0,"docs":{},"r":{"<":{"\'":{"a":{">":{"(":{"&":{"\'":{"a":{"df":2,"docs":{"35":{"tf":1.7320508075688772},"36":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"35":{"tf":1.4142135623730951},"36":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{">":{"(":{"df":0,"docs":{},"t":{"df":2,"docs":{"35":{"tf":1.0},"36":{"tf":1.0}}}},"df":0,"docs":{}},"df":2,"docs":{"35":{"tf":1.0},"36":{"tf":1.7320508075688772}}}},"df":2,"docs":{"35":{"tf":3.872983346207417},"36":{"tf":2.0}},"’":{"df":1,"docs":{"35":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"110":{"tf":1.0},"121":{"tf":1.0}}},"n":{"c":{"df":30,"docs":{"103":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"14":{"tf":1.0},"19":{"tf":1.0},"22":{"tf":1.0},"3":{"tf":1.7320508075688772},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"46":{"tf":1.0},"48":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"54":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"60":{"tf":1.0},"68":{"tf":1.4142135623730951},"7":{"tf":2.23606797749979},"70":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.4142135623730951},"96":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"11":{"tf":1.4142135623730951},"131":{"tf":1.4142135623730951}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"64":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":18,"docs":{"11":{"tf":1.0},"125":{"tf":1.0},"131":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"42":{"tf":1.0},"46":{"tf":1.0},"56":{"tf":1.7320508075688772},"6":{"tf":1.0},"61":{"tf":1.0},"70":{"tf":1.0},"75":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"87":{"tf":1.0},"89":{"tf":1.0},"92":{"tf":1.0},"96":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":6,"docs":{"110":{"tf":1.0},"119":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"82":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"t":{"3":{"2":{"_":{"df":0,"docs":{},"t":{"df":2,"docs":{"116":{"tf":1.0},"117":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"115":{"tf":1.0},"125":{"tf":2.6457513110645907}},"e":{"df":0,"docs":{},"g":{"df":9,"docs":{"125":{"tf":2.23606797749979},"14":{"tf":1.0},"16":{"tf":1.4142135623730951},"3":{"tf":1.7320508075688772},"4":{"tf":1.4142135623730951},"48":{"tf":1.0},"68":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"92":{"tf":1.0}},"r":{"df":3,"docs":{"119":{"tf":1.0},"2":{"tf":1.0},"56":{"tf":1.0}}}},"n":{"d":{"df":6,"docs":{"1":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"68":{"tf":1.0},"78":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":2,"docs":{"31":{"tf":1.0},"90":{"tf":1.0}}},"t":{"df":2,"docs":{"14":{"tf":1.0},"30":{"tf":1.0}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":9,"docs":{"121":{"tf":1.0},"126":{"tf":1.4142135623730951},"14":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.4142135623730951},"35":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"71":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":11,"docs":{"11":{"tf":1.0},"14":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.4142135623730951},"55":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"35":{"tf":1.0},"54":{"tf":1.0}}}}}}}}}},"f":{"a":{"c":{"df":10,"docs":{"106":{"tf":1.0},"107":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.4142135623730951},"121":{"tf":1.0},"125":{"tf":1.0},"131":{"tf":1.0},"14":{"tf":1.0},"2":{"tf":1.7320508075688772},"3":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":7,"docs":{"104":{"tf":1.0},"34":{"tf":1.4142135623730951},"60":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.0},"94":{"tf":1.0},"96":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"v":{"df":1,"docs":{"77":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"116":{"tf":1.0},"56":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"67":{"tf":1.0}}}}},"n":{"df":7,"docs":{"103":{"tf":1.0},"111":{"tf":1.0},"123":{"tf":1.0},"131":{"tf":1.0},"19":{"tf":1.0},"3":{"tf":1.4142135623730951},"35":{"tf":1.0}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"1":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.4142135623730951},"2":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":4,"docs":{"52":{"tf":1.0},"53":{"tf":1.0},"7":{"tf":1.0},"83":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"82":{"tf":1.0}}}},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"87":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":4,"docs":{"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"87":{"tf":2.8284271247461903},"88":{"tf":2.0},"89":{"tf":2.449489742783178},"93":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"<":{"df":0,"docs":{},"t":{"df":4,"docs":{"87":{"tf":2.449489742783178},"88":{"tf":2.0},"89":{"tf":2.449489742783178},"93":{"tf":2.449489742783178}}}},"df":4,"docs":{"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":6,"docs":{"134":{"tf":1.4142135623730951},"4":{"tf":1.7320508075688772},"71":{"tf":1.0},"72":{"tf":1.0},"80":{"tf":2.0},"95":{"tf":1.0}}}}},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":4,"docs":{"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"36":{"tf":1.0},"55":{"tf":1.0}},"t":{"df":1,"docs":{"107":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"58":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"33":{"tf":1.0},"43":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":10,"docs":{"111":{"tf":1.0},"125":{"tf":1.0},"16":{"tf":1.0},"23":{"tf":1.4142135623730951},"30":{"tf":1.0},"34":{"tf":1.0},"4":{"tf":3.0},"52":{"tf":1.0},"59":{"tf":1.0},"72":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"34":{"tf":4.0},"42":{"tf":2.0},"5":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"34":{"tf":1.0},"74":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}},"o":{"df":0,"docs":{},"k":{"df":10,"docs":{"116":{"tf":1.0},"118":{"tf":1.7320508075688772},"128":{"tf":1.4142135623730951},"3":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.7320508075688772},"4":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"58":{"tf":1.0},"65":{"tf":1.0}}},"l":{"df":0,"docs":{},"v":{"df":9,"docs":{"111":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"41":{"tf":1.7320508075688772},"69":{"tf":1.0},"77":{"tf":1.0},"83":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"72":{"tf":1.0}}},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"x":{"df":7,"docs":{"103":{"tf":1.7320508075688772},"105":{"tf":1.0},"4":{"tf":1.0},"82":{"tf":2.449489742783178},"88":{"tf":2.0},"91":{"tf":2.0},"93":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"n":{"\'":{"df":0,"docs":{},"t":{"df":4,"docs":{"54":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951},"82":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":17,"docs":{"1":{"tf":1.0},"110":{"tf":1.0},"22":{"tf":1.0},"3":{"tf":1.4142135623730951},"31":{"tf":1.0},"35":{"tf":1.0},"4":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":1.0},"76":{"tf":1.0},"8":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"120":{"tf":1.0}}}},"s":{"df":0,"docs":{},"u":{"df":12,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.7320508075688772},"131":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"56":{"tf":1.0},"63":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.0},"82":{"tf":1.0},"96":{"tf":1.0}}}}},"t":{"\'":{"df":8,"docs":{"34":{"tf":1.0},"54":{"tf":1.4142135623730951},"63":{"tf":1.0},"70":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951},"89":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":10,"docs":{"134":{"tf":1.0},"41":{"tf":1.7320508075688772},"43":{"tf":2.23606797749979},"56":{"tf":1.0},"71":{"tf":1.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.0},"89":{"tf":2.0},"92":{"tf":1.0},"93":{"tf":2.0}}},"r":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"<":{"\'":{"a":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"df":2,"docs":{"85":{"tf":1.0},"87":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}}}}},"df":13,"docs":{"26":{"tf":1.0},"39":{"tf":1.7320508075688772},"43":{"tf":3.3166247903554},"61":{"tf":2.0},"66":{"tf":1.0},"71":{"tf":1.0},"85":{"tf":1.0},"87":{"tf":2.8284271247461903},"89":{"tf":3.1622776601683795},"90":{"tf":1.4142135623730951},"91":{"tf":1.0},"92":{"tf":2.8284271247461903},"93":{"tf":3.3166247903554}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"d":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"<":{"\'":{"a":{"df":1,"docs":{"43":{"tf":2.8284271247461903}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}},"df":1,"docs":{"43":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":16,"docs":{"104":{"tf":1.0},"134":{"tf":1.0},"24":{"tf":1.0},"31":{"tf":1.0},"41":{"tf":1.0},"48":{"tf":1.0},"59":{"tf":1.7320508075688772},"61":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"96":{"tf":2.0}}}}}},"’":{"df":41,"docs":{"1":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"11":{"tf":1.7320508075688772},"126":{"tf":1.0},"131":{"tf":1.0},"134":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":2.0},"3":{"tf":2.0},"30":{"tf":1.0},"34":{"tf":2.0},"35":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.0},"43":{"tf":1.7320508075688772},"5":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"58":{"tf":1.7320508075688772},"6":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"73":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.4142135623730951},"82":{"tf":2.6457513110645907},"83":{"tf":1.4142135623730951},"84":{"tf":1.0},"90":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0}},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"’":{"df":0,"docs":{},"v":{"df":1,"docs":{"89":{"tf":1.0}}}}},"j":{"a":{"df":0,"docs":{},"v":{"a":{"df":2,"docs":{"64":{"tf":1.4142135623730951},"67":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"b":{"df":2,"docs":{"31":{"tf":1.0},"92":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"63":{"tf":1.7320508075688772}},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"r":{"d":{"<":{"\'":{"a":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"63":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"131":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"3":{"tf":1.0}}}}}}}}},"k":{"1":{"df":1,"docs":{"34":{"tf":1.0}}},"2":{"df":1,"docs":{"34":{"tf":1.0}}},"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"120":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"28":{"tf":2.23606797749979}},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":8,"docs":{"110":{"tf":1.0},"22":{"tf":1.4142135623730951},"25":{"tf":1.0},"3":{"tf":1.4142135623730951},"56":{"tf":1.0},"6":{"tf":1.0},"63":{"tf":1.0},"92":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":3,"docs":{"14":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"3":{"2":{"df":1,"docs":{"122":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"y":{"df":4,"docs":{"22":{"tf":1.0},"28":{"tf":1.4142135623730951},"3":{"tf":2.0},"43":{"tf":1.0}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"121":{"tf":1.0},"3":{"tf":1.4142135623730951},"47":{"tf":1.0}}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"64":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951}}}},"n":{"d":{"df":17,"docs":{"1":{"tf":1.0},"119":{"tf":2.23606797749979},"18":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"34":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.0},"5":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.4142135623730951},"61":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.0},"92":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"22":{"tf":1.0},"34":{"tf":1.0}}}},"o":{"df":0,"docs":{},"w":{"df":28,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"104":{"tf":1.4142135623730951},"105":{"tf":1.0},"11":{"tf":1.0},"131":{"tf":1.0},"19":{"tf":1.0},"22":{"tf":1.4142135623730951},"25":{"tf":1.0},"35":{"tf":2.449489742783178},"36":{"tf":1.4142135623730951},"41":{"tf":1.0},"43":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"52":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.4142135623730951},"62":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"82":{"tf":1.0},"87":{"tf":1.0},"9":{"tf":1.0},"94":{"tf":1.0},"96":{"tf":1.0}},"l":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"g":{"df":2,"docs":{"1":{"tf":1.4142135623730951},"16":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":10,"docs":{"119":{"tf":1.0},"34":{"tf":1.0},"46":{"tf":1.0},"55":{"tf":1.0},"7":{"tf":1.4142135623730951},"70":{"tf":1.0},"73":{"tf":1.0},"8":{"tf":1.0},"82":{"tf":1.4142135623730951},"9":{"tf":1.7320508075688772}}}}}}},"l":{".":{"/":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"115":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"0":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"23":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"42":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"52":{"tf":1.0},"56":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"134":{"tf":1.4142135623730951}},"u":{"a":{"df":0,"docs":{},"g":{"df":19,"docs":{"1":{"tf":2.23606797749979},"10":{"tf":1.0},"19":{"tf":1.4142135623730951},"2":{"tf":3.7416573867739413},"20":{"tf":1.0},"22":{"tf":2.23606797749979},"3":{"tf":1.4142135623730951},"34":{"tf":1.7320508075688772},"36":{"tf":1.4142135623730951},"4":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0},"64":{"tf":1.4142135623730951},"69":{"tf":1.0},"7":{"tf":1.0},"82":{"tf":1.0},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"’":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":18,"docs":{"10":{"tf":1.0},"119":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0},"45":{"tf":1.4142135623730951},"47":{"tf":1.0},"58":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"76":{"tf":1.4142135623730951},"78":{"tf":1.0},"82":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951},"89":{"tf":1.0},"9":{"tf":1.4142135623730951},"91":{"tf":1.0},"93":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"23":{"tf":1.0},"33":{"tf":1.0},"52":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":13,"docs":{"104":{"tf":1.7320508075688772},"105":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":2.6457513110645907},"56":{"tf":1.0},"85":{"tf":1.0},"9":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":2.0},"96":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"34":{"tf":1.0},"63":{"tf":1.0},"77":{"tf":1.0},"85":{"tf":1.0},"92":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"y":{"df":2,"docs":{"123":{"tf":1.0},"7":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{":":{":":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{":":{":":{"<":{"df":0,"docs":{},"t":{">":{"(":{"1":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"91":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":2,"docs":{"82":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"c":{"a":{"df":0,"docs":{},"p":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"88":{"tf":1.0},"91":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":2,"docs":{"82":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"c":{"a":{"df":0,"docs":{},"p":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":6,"docs":{"82":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":4,"docs":{"82":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{":":{":":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":2.23606797749979}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":20,"docs":{"10":{"tf":1.0},"123":{"tf":1.4142135623730951},"13":{"tf":1.0},"131":{"tf":1.0},"14":{"tf":2.23606797749979},"15":{"tf":1.7320508075688772},"16":{"tf":2.0},"52":{"tf":2.23606797749979},"59":{"tf":2.0},"6":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772},"81":{"tf":1.4142135623730951},"82":{"tf":1.0},"84":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951},"92":{"tf":1.4142135623730951},"93":{"tf":1.0},"96":{"tf":1.4142135623730951},"97":{"tf":1.0}}}}}},"z":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"76":{"tf":1.0}}}}}}},"d":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"=":{".":{"/":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"115":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"115":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":2,"docs":{"115":{"tf":1.4142135623730951},"43":{"tf":1.7320508075688772}},"e":{"a":{"d":{"df":6,"docs":{"1":{"tf":1.0},"131":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"48":{"tf":1.0},"56":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":1,"docs":{"65":{"tf":1.0}}},"k":{"df":11,"docs":{"120":{"tf":1.0},"4":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":3.1622776601683795},"61":{"tf":2.0},"62":{"tf":1.0},"64":{"tf":1.0},"72":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":1.4142135623730951},"93":{"tf":1.0}}},"v":{"df":6,"docs":{"111":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"7":{"tf":1.0},"83":{"tf":1.4142135623730951},"89":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":5,"docs":{"34":{"tf":1.0},"35":{"tf":1.0},"43":{"tf":2.0},"56":{"tf":1.4142135623730951},"89":{"tf":1.0}}}},"g":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"82":{"tf":1.0}}}}}}},"n":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"df":0,"docs":{}},"+":{"1":{"df":1,"docs":{"86":{"tf":1.0}}},"df":0,"docs":{}},"df":16,"docs":{"40":{"tf":1.7320508075688772},"41":{"tf":1.0},"43":{"tf":1.7320508075688772},"5":{"tf":1.0},"61":{"tf":1.4142135623730951},"66":{"tf":1.7320508075688772},"81":{"tf":1.4142135623730951},"82":{"tf":1.7320508075688772},"83":{"tf":2.0},"85":{"tf":1.0},"86":{"tf":2.6457513110645907},"87":{"tf":1.7320508075688772},"88":{"tf":1.7320508075688772},"89":{"tf":1.0},"92":{"tf":1.4142135623730951},"93":{"tf":2.0}},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":6,"docs":{"110":{"tf":1.0},"111":{"tf":2.0},"4":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"66":{"tf":1.0},"83":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"df":8,"docs":{"111":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.0},"39":{"tf":1.0},"64":{"tf":1.4142135623730951},"7":{"tf":1.0},"75":{"tf":1.0},"82":{"tf":1.0}}}},"t":{"\'":{"df":1,"docs":{"35":{"tf":1.7320508075688772}}},"df":3,"docs":{"2":{"tf":1.7320508075688772},"22":{"tf":1.7320508075688772},"35":{"tf":1.0}},"’":{"df":24,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"125":{"tf":1.0},"131":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"34":{"tf":2.23606797749979},"35":{"tf":1.0},"62":{"tf":1.0},"67":{"tf":1.4142135623730951},"72":{"tf":1.7320508075688772},"82":{"tf":1.0},"83":{"tf":1.4142135623730951},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"89":{"tf":1.7320508075688772},"92":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":8,"docs":{"1":{"tf":1.0},"11":{"tf":2.0},"111":{"tf":1.4142135623730951},"2":{"tf":1.7320508075688772},"48":{"tf":1.0},"6":{"tf":1.0},"65":{"tf":1.0},"82":{"tf":1.0}}}}}},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"114":{"tf":1.0}}}},"=":{"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"=":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"c":{"df":1,"docs":{"109":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"c":{":":{":":{"c":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"121":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"121":{"tf":1.0},"122":{"tf":1.0},"125":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"131":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"72":{"tf":1.0}},"e":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"0":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{")":{".":{"c":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"72":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"110":{"tf":1.0}}}},"df":0,"docs":{}}}}},"{":{"c":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"110":{"tf":1.0},"111":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"111":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":5,"docs":{"108":{"tf":2.0},"123":{"tf":1.7320508075688772},"133":{"tf":2.8284271247461903},"134":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951}}},"df":1,"docs":{"114":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"22":{"tf":1.0}}}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{".":{"a":{"df":1,"docs":{"119":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"m":{"df":1,"docs":{"123":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":31,"docs":{"1":{"tf":1.4142135623730951},"107":{"tf":1.4142135623730951},"109":{"tf":1.7320508075688772},"110":{"tf":1.7320508075688772},"111":{"tf":1.0},"112":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.7320508075688772},"117":{"tf":1.4142135623730951},"118":{"tf":2.0},"119":{"tf":4.0},"122":{"tf":1.0},"123":{"tf":1.0},"125":{"tf":1.0},"131":{"tf":1.4142135623730951},"134":{"tf":1.4142135623730951},"2":{"tf":2.0},"3":{"tf":1.7320508075688772},"34":{"tf":1.0},"35":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":2.449489742783178},"56":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.0},"69":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"95":{"tf":1.0}}},"y":{"df":0,"docs":{},"’":{"df":6,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"62":{"tf":1.0},"68":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"d":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"3":{"tf":1.0}}},"f":{"df":0,"docs":{},"e":{"df":1,"docs":{"53":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":26,"docs":{"19":{"tf":1.0},"23":{"tf":4.0},"24":{"tf":1.7320508075688772},"25":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"27":{"tf":2.23606797749979},"28":{"tf":1.7320508075688772},"29":{"tf":4.358898943540674},"30":{"tf":4.358898943540674},"31":{"tf":2.449489742783178},"32":{"tf":2.8284271247461903},"33":{"tf":2.23606797749979},"34":{"tf":3.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.7320508075688772},"39":{"tf":2.0},"41":{"tf":1.0},"45":{"tf":1.0},"52":{"tf":1.7320508075688772},"63":{"tf":2.0},"69":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":2.0},"81":{"tf":1.0},"89":{"tf":1.4142135623730951},"96":{"tf":1.0}}}}}}},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.0}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}}}}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"35":{"tf":1.0}}}}}}},"m":{"b":{"df":0,"docs":{},"o":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":10,"docs":{"1":{"tf":1.0},"24":{"tf":1.0},"27":{"tf":1.0},"4":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0},"57":{"tf":1.0},"7":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.7320508075688772}}}}},"n":{"df":0,"docs":{},"e":{"df":3,"docs":{"109":{"tf":1.0},"18":{"tf":1.0},"55":{"tf":1.0}}},"g":{"df":0,"docs":{},"u":{"a":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}}},"k":{"(":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":6,"docs":{"110":{"tf":1.4142135623730951},"116":{"tf":1.0},"117":{"tf":1.0},"119":{"tf":2.449489742783178},"121":{"tf":1.4142135623730951},"122":{"tf":1.0}}}},"df":0,"docs":{}}},"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":2.6457513110645907}}}},"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"119":{"tf":1.4142135623730951}}}},"df":12,"docs":{"109":{"tf":2.0},"110":{"tf":1.4142135623730951},"114":{"tf":1.4142135623730951},"119":{"tf":2.8284271247461903},"123":{"tf":1.0},"128":{"tf":1.0},"134":{"tf":1.0},"135":{"tf":1.0},"43":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"92":{"tf":1.0}},"e":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"r":{"df":2,"docs":{"110":{"tf":1.0},"134":{"tf":1.4142135623730951}}}}},"t":{"df":4,"docs":{"17":{"tf":1.0},"52":{"tf":1.0},"60":{"tf":1.0},"71":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":9,"docs":{"110":{"tf":1.0},"122":{"tf":1.4142135623730951},"124":{"tf":1.0},"125":{"tf":1.0},"31":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"47":{"tf":1.0},"58":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"24":{"tf":1.4142135623730951},"67":{"tf":1.0},"76":{"tf":1.0},"88":{"tf":1.0}}}},"t":{"df":0,"docs":{},"l":{"df":6,"docs":{"122":{"tf":1.0},"31":{"tf":1.0},"56":{"tf":1.0},"67":{"tf":1.0},"80":{"tf":1.0},"92":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"d":{"\\"":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"41":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":16,"docs":{"104":{"tf":1.0},"19":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.4142135623730951},"26":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":2.6457513110645907},"35":{"tf":2.449489742783178},"41":{"tf":1.0},"5":{"tf":1.0},"63":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"m":{"df":3,"docs":{"82":{"tf":2.449489742783178},"84":{"tf":1.0},"89":{"tf":1.0}},"’":{"df":1,"docs":{"82":{"tf":1.4142135623730951}}}}}},"o":{"a":{"d":{"df":6,"docs":{"10":{"tf":2.0},"104":{"tf":1.0},"17":{"tf":1.7320508075688772},"70":{"tf":1.4142135623730951},"82":{"tf":1.0},"91":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":2,"docs":{"27":{"tf":2.6457513110645907},"63":{"tf":1.0}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":6,"docs":{"22":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.0},"34":{"tf":1.0},"5":{"tf":1.4142135623730951},"75":{"tf":1.0}}},"t":{"df":13,"docs":{"22":{"tf":1.0},"30":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.7320508075688772},"58":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"78":{"tf":2.23606797749979},"82":{"tf":1.4142135623730951},"83":{"tf":1.0},"86":{"tf":1.0}}}},"df":0,"docs":{},"k":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"78":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"78":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":3,"docs":{"68":{"tf":2.0},"72":{"tf":1.0},"78":{"tf":2.6457513110645907}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"135":{"tf":1.4142135623730951}},"i":{"c":{"df":15,"docs":{"104":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":2.23606797749979},"39":{"tf":1.4142135623730951},"54":{"tf":1.7320508075688772},"59":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.4142135623730951},"70":{"tf":1.0},"72":{"tf":1.4142135623730951},"75":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":2.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"g":{"df":10,"docs":{"1":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.7320508075688772},"34":{"tf":1.7320508075688772},"35":{"tf":2.449489742783178},"64":{"tf":1.7320508075688772},"82":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":8,"docs":{"25":{"tf":1.0},"26":{"tf":1.7320508075688772},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"40":{"tf":1.0},"6":{"tf":1.4142135623730951},"61":{"tf":1.0},"91":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"k":{"df":18,"docs":{"115":{"tf":1.0},"125":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.7320508075688772},"3":{"tf":1.0},"34":{"tf":1.0},"38":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"60":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.4142135623730951},"70":{"tf":1.0},"78":{"tf":1.0},"87":{"tf":1.0},"91":{"tf":1.0},"96":{"tf":1.0}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}}}},"p":{"df":9,"docs":{"135":{"tf":1.4142135623730951},"22":{"tf":1.0},"26":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"54":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.0},"66":{"tf":1.4142135623730951},"78":{"tf":1.0}}},"s":{"df":4,"docs":{"41":{"tf":1.0},"67":{"tf":1.0},"82":{"tf":1.0},"95":{"tf":1.0}}}},"t":{"df":11,"docs":{"1":{"tf":1.0},"11":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"4":{"tf":1.0},"46":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0},"65":{"tf":1.0},"82":{"tf":1.0}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}}}},"w":{"df":4,"docs":{"104":{"tf":1.0},"2":{"tf":1.7320508075688772},"6":{"tf":1.0},"82":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"c":{"df":1,"docs":{"115":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"u":{"d":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"r":{"df":1,"docs":{"82":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"m":{"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"103":{"tf":1.0}}}}},"o":{"df":1,"docs":{"119":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"46":{"tf":1.0}}}}},"d":{"df":1,"docs":{"73":{"tf":1.0}},"e":{"df":6,"docs":{"11":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.0},"41":{"tf":1.0},"76":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"df":6,"docs":{"31":{"tf":1.7320508075688772},"46":{"tf":1.0},"52":{"tf":1.0},"71":{"tf":1.0},"85":{"tf":1.0},"87":{"tf":1.0}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"2":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"n":{"(":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"c":{"df":1,"docs":{"134":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"115":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":61,"docs":{"10":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"109":{"tf":1.0},"11":{"tf":1.4142135623730951},"110":{"tf":1.4142135623730951},"111":{"tf":2.0},"114":{"tf":1.0},"116":{"tf":1.4142135623730951},"117":{"tf":1.0},"120":{"tf":1.0},"121":{"tf":1.4142135623730951},"122":{"tf":1.0},"124":{"tf":1.4142135623730951},"125":{"tf":1.0},"129":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.4142135623730951},"134":{"tf":1.4142135623730951},"135":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":1.4142135623730951},"22":{"tf":1.7320508075688772},"23":{"tf":1.4142135623730951},"24":{"tf":1.7320508075688772},"25":{"tf":1.0},"26":{"tf":2.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.7320508075688772},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":2.449489742783178},"35":{"tf":2.6457513110645907},"36":{"tf":2.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.7320508075688772},"41":{"tf":1.4142135623730951},"43":{"tf":2.6457513110645907},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.7320508075688772},"5":{"tf":1.7320508075688772},"54":{"tf":2.6457513110645907},"55":{"tf":2.23606797749979},"56":{"tf":1.4142135623730951},"58":{"tf":1.0},"59":{"tf":2.23606797749979},"7":{"tf":2.6457513110645907},"70":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"72":{"tf":2.449489742783178},"78":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.7320508075688772},"9":{"tf":1.4142135623730951},"93":{"tf":1.0},"96":{"tf":1.4142135623730951}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"1":{"tf":1.0},"3":{"tf":2.23606797749979},"4":{"tf":1.0},"61":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"71":{"tf":1.0},"9":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"5":{"tf":1.4142135623730951}}}}}}},"df":53,"docs":{"1":{"tf":1.4142135623730951},"10":{"tf":1.0},"101":{"tf":1.0},"104":{"tf":1.0},"11":{"tf":1.0},"111":{"tf":1.7320508075688772},"114":{"tf":1.0},"116":{"tf":1.0},"123":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"18":{"tf":1.0},"19":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"25":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":2.23606797749979},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.4142135623730951},"4":{"tf":2.0},"40":{"tf":1.4142135623730951},"41":{"tf":1.0},"43":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":1.0},"52":{"tf":1.4142135623730951},"55":{"tf":2.23606797749979},"56":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.4142135623730951},"69":{"tf":1.0},"7":{"tf":2.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.4142135623730951},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.0},"85":{"tf":1.0},"87":{"tf":1.4142135623730951},"89":{"tf":1.0},"9":{"tf":1.4142135623730951},"92":{"tf":1.4142135623730951},"95":{"tf":1.0},"96":{"tf":1.0}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":12,"docs":{"123":{"tf":1.0},"14":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"4":{"tf":1.0},"52":{"tf":1.0},"57":{"tf":2.23606797749979},"60":{"tf":1.4142135623730951},"62":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"96":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"114":{"tf":1.0}}}},"i":{"df":17,"docs":{"10":{"tf":1.4142135623730951},"103":{"tf":1.0},"108":{"tf":1.0},"123":{"tf":1.0},"134":{"tf":1.0},"23":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":1.0},"43":{"tf":1.4142135623730951},"46":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.4142135623730951},"65":{"tf":1.0},"7":{"tf":1.0},"80":{"tf":1.4142135623730951},"82":{"tf":1.0},"95":{"tf":1.0}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":2,"docs":{"111":{"tf":1.0},"16":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"35":{"tf":1.0},"5":{"tf":1.4142135623730951},"82":{"tf":1.0},"86":{"tf":1.0}}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":8,"docs":{"109":{"tf":1.0},"123":{"tf":1.0},"134":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":1.0},"3":{"tf":1.0},"35":{"tf":1.0},"46":{"tf":1.0}},"l":{"df":0,"docs":{},"y":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"87":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"37":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"p":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"28":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"<":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"10":{"tf":1.7320508075688772}}}}}},"df":5,"docs":{"10":{"tf":1.0},"21":{"tf":1.0},"28":{"tf":1.7320508075688772},"43":{"tf":1.0},"92":{"tf":1.0}},"’":{"df":1,"docs":{"28":{"tf":1.0}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"11":{"tf":1.0}}}}},"k":{"df":13,"docs":{"104":{"tf":1.0},"116":{"tf":1.0},"120":{"tf":1.0},"131":{"tf":1.0},"3":{"tf":2.449489742783178},"36":{"tf":1.0},"41":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.4142135623730951},"60":{"tf":1.0},"71":{"tf":1.7320508075688772},"76":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"<":{"&":{"\'":{"a":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":6,"docs":{"131":{"tf":1.0},"3":{"tf":1.4142135623730951},"39":{"tf":1.0},"71":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"17":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"19":{"tf":1.0},"84":{"tf":1.0}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":12,"docs":{"125":{"tf":1.0},"130":{"tf":1.0},"14":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"4":{"tf":1.0},"43":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":1.0},"82":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":12,"docs":{"2":{"tf":1.7320508075688772},"20":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"26":{"tf":1.0},"3":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.0},"37":{"tf":1.0},"60":{"tf":1.7320508075688772},"68":{"tf":1.0},"77":{"tf":1.0}}}}}},"x":{"(":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{":":{":":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"65":{"tf":1.0},"68":{"tf":1.0}},"u":{"df":0,"docs":{},"m":{"df":2,"docs":{"111":{"tf":1.0},"7":{"tf":1.0}}}}}}},"y":{"_":{"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":4,"docs":{"36":{"tf":2.0},"40":{"tf":1.4142135623730951},"41":{"tf":2.0},"42":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"128":{"tf":2.23606797749979}}}}}}}},"b":{"df":3,"docs":{"2":{"tf":2.23606797749979},"68":{"tf":1.0},"7":{"tf":1.0}},"e":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{":":{":":{"<":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{">":{":":{":":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"i":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"56":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"<":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"<":{"df":0,"docs":{},"u":{"3":{"2":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}}},"df":1,"docs":{"56":{"tf":3.0}}}}}}}}}},"df":0,"docs":{}}},"df":1,"docs":{"28":{"tf":2.449489742783178}},"e":{"a":{"df":0,"docs":{},"n":{"df":39,"docs":{"1":{"tf":1.0},"104":{"tf":1.0},"119":{"tf":1.0},"122":{"tf":1.4142135623730951},"124":{"tf":1.0},"125":{"tf":1.0},"134":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"25":{"tf":1.0},"3":{"tf":2.23606797749979},"34":{"tf":1.0},"35":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"56":{"tf":1.7320508075688772},"58":{"tf":1.7320508075688772},"59":{"tf":1.4142135623730951},"60":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.4142135623730951},"64":{"tf":1.0},"65":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"71":{"tf":2.0},"72":{"tf":1.7320508075688772},"80":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":2.0},"91":{"tf":1.4142135623730951},"92":{"tf":1.4142135623730951},"93":{"tf":1.0},"99":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"35":{"tf":1.0},"58":{"tf":1.0}}}}}}}}},"t":{"df":1,"docs":{"119":{"tf":1.0}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"36":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"34":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":5,"docs":{"118":{"tf":1.4142135623730951},"126":{"tf":1.0},"46":{"tf":1.0},"53":{"tf":1.0},"77":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"2":{"tf":1.0},"72":{"tf":1.0}}}},"m":{":":{":":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{":":{":":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"82":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"d":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"y":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":1,"docs":{"59":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":3,"docs":{"88":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0}}}}}}},"df":6,"docs":{"103":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"93":{"tf":1.0}}}}}}}},"m":{"a":{"df":0,"docs":{},"y":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"s":{"_":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{":":{":":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{":":{":":{"<":{"df":0,"docs":{},"t":{"df":4,"docs":{"87":{"tf":1.0},"91":{"tf":1.4142135623730951},"92":{"tf":2.23606797749979},"93":{"tf":2.449489742783178}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"3":{"tf":1.0},"52":{"tf":1.0}},"e":{":":{":":{"<":{"_":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}}}},"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"56":{"tf":1.0}}}}}}}}},"{":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":1,"docs":{"72":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"117":{"tf":1.0},"123":{"tf":1.0},"56":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"58":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"56":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":2,"docs":{"56":{"tf":1.0},"86":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":47,"docs":{"1":{"tf":1.7320508075688772},"103":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":2.0},"123":{"tf":1.0},"131":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.4142135623730951},"2":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":2.0},"3":{"tf":2.23606797749979},"30":{"tf":1.0},"35":{"tf":1.0},"4":{"tf":2.23606797749979},"48":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.0},"53":{"tf":2.449489742783178},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":3.4641016151377544},"57":{"tf":2.0},"58":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"68":{"tf":1.0},"70":{"tf":2.449489742783178},"71":{"tf":1.0},"72":{"tf":1.7320508075688772},"73":{"tf":2.0},"75":{"tf":2.23606797749979},"76":{"tf":1.0},"77":{"tf":1.4142135623730951},"78":{"tf":2.0},"82":{"tf":3.872983346207417},"83":{"tf":2.6457513110645907},"84":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.7320508075688772}}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"72":{"tf":1.7320508075688772}}}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"82":{"tf":1.0}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"80":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"135":{"tf":1.4142135623730951},"69":{"tf":1.0}}}},"df":6,"docs":{"3":{"tf":1.0},"33":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0},"67":{"tf":1.0},"85":{"tf":1.0}},"i":{"df":1,"docs":{"125":{"tf":1.0}}}}},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"4":{"tf":2.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":12,"docs":{"29":{"tf":1.4142135623730951},"3":{"tf":1.0},"36":{"tf":1.7320508075688772},"46":{"tf":2.23606797749979},"5":{"tf":1.0},"56":{"tf":1.4142135623730951},"58":{"tf":1.0},"59":{"tf":1.7320508075688772},"68":{"tf":1.0},"71":{"tf":1.0},"82":{"tf":1.0},"91":{"tf":1.0}},"’":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}}}},"i":{"d":{"d":{"df":0,"docs":{},"l":{"df":4,"docs":{"56":{"tf":1.0},"61":{"tf":1.4142135623730951},"68":{"tf":1.0},"70":{"tf":1.0}}}},"df":1,"docs":{"43":{"tf":1.7320508075688772}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"52":{"tf":1.0}}}},"n":{"d":{"df":5,"docs":{"1":{"tf":1.0},"126":{"tf":1.0},"14":{"tf":1.0},"52":{"tf":1.0},"64":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":8,"docs":{"110":{"tf":1.0},"23":{"tf":1.0},"3":{"tf":1.0},"61":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.4142135623730951},"82":{"tf":1.0},"85":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"d":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"k":{"df":3,"docs":{"0":{"tf":1.0},"19":{"tf":1.0},"3":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"s":{"df":4,"docs":{"32":{"tf":1.0},"36":{"tf":1.0},"4":{"tf":1.0},"56":{"tf":1.0}}}}},"x":{"df":1,"docs":{"34":{"tf":2.0}}}},"o":{"d":{"df":3,"docs":{"111":{"tf":1.0},"72":{"tf":1.4142135623730951},"93":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":10,"docs":{"1":{"tf":1.4142135623730951},"11":{"tf":1.0},"110":{"tf":1.0},"119":{"tf":1.0},"12":{"tf":1.0},"20":{"tf":1.4142135623730951},"22":{"tf":1.0},"69":{"tf":1.0},"73":{"tf":3.1622776601683795},"76":{"tf":1.0}}},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"82":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":9,"docs":{"103":{"tf":1.4142135623730951},"105":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"22":{"tf":1.4142135623730951},"4":{"tf":1.0},"5":{"tf":1.0},"68":{"tf":1.0},"79":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}}},"df":5,"docs":{"111":{"tf":1.0},"123":{"tf":1.7320508075688772},"131":{"tf":1.0},"5":{"tf":2.0},"56":{"tf":1.0}},"o":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"23":{"tf":1.0},"95":{"tf":1.4142135623730951}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":2,"docs":{"10":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}}}}}},"r":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"58":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"df":57,"docs":{"1":{"tf":1.0},"103":{"tf":2.0},"109":{"tf":1.0},"11":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"115":{"tf":1.0},"118":{"tf":1.4142135623730951},"12":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"19":{"tf":1.7320508075688772},"2":{"tf":1.7320508075688772},"21":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"33":{"tf":1.7320508075688772},"34":{"tf":2.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.0},"4":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"52":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.7320508075688772},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.4142135623730951},"67":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":2.23606797749979},"71":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.4142135623730951},"82":{"tf":2.0},"87":{"tf":1.0},"89":{"tf":1.7320508075688772},"9":{"tf":1.0},"92":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"45":{"tf":1.0},"70":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"11":{"tf":1.0},"19":{"tf":1.0}}}}},"v":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"58":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":17,"docs":{"22":{"tf":1.7320508075688772},"3":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"36":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.4142135623730951},"56":{"tf":1.0},"58":{"tf":2.23606797749979},"59":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"63":{"tf":1.0},"70":{"tf":2.0},"72":{"tf":1.0},"83":{"tf":1.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.0},"89":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"v":{"c":{"df":1,"docs":{"133":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"u":{"c":{"df":0,"docs":{},"h":{"df":14,"docs":{"19":{"tf":1.4142135623730951},"2":{"tf":1.0},"22":{"tf":1.0},"25":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":1.0},"5":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"71":{"tf":1.0},"82":{"tf":1.4142135623730951},"88":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"74":{"tf":1.0},"76":{"tf":1.0}},"p":{"df":0,"docs":{},"l":{"df":7,"docs":{"26":{"tf":1.0},"29":{"tf":1.0},"34":{"tf":1.0},"43":{"tf":1.4142135623730951},"7":{"tf":2.449489742783178},"71":{"tf":1.0},"79":{"tf":1.0}},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}},"t":{"[":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}},"a":{"b":{"df":0,"docs":{},"l":{"df":18,"docs":{"121":{"tf":1.0},"123":{"tf":1.0},"20":{"tf":1.4142135623730951},"25":{"tf":1.7320508075688772},"27":{"tf":2.0},"28":{"tf":2.0},"34":{"tf":2.0},"4":{"tf":1.0},"43":{"tf":3.605551275463989},"54":{"tf":1.7320508075688772},"60":{"tf":1.0},"63":{"tf":1.7320508075688772},"70":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"72":{"tf":2.23606797749979},"94":{"tf":1.0},"96":{"tf":1.7320508075688772},"99":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"t":{"df":10,"docs":{"121":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.7320508075688772},"34":{"tf":1.0},"63":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.0},"72":{"tf":1.4142135623730951},"87":{"tf":1.0},"96":{"tf":1.0}},"e":{"_":{"a":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}},"e":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{}},"<":{"\'":{"a":{">":{"(":{"&":{"\'":{"a":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"’":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":49,"docs":{"104":{"tf":1.0},"110":{"tf":2.23606797749979},"111":{"tf":4.123105625617661},"117":{"tf":1.7320508075688772},"121":{"tf":1.7320508075688772},"125":{"tf":1.0},"131":{"tf":2.23606797749979},"135":{"tf":1.0},"14":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":2.6457513110645907},"25":{"tf":2.23606797749979},"26":{"tf":2.449489742783178},"27":{"tf":2.449489742783178},"28":{"tf":2.23606797749979},"29":{"tf":3.3166247903554},"34":{"tf":4.795831523312719},"35":{"tf":2.0},"36":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":4.898979485566356},"45":{"tf":2.23606797749979},"46":{"tf":2.0},"5":{"tf":1.0},"52":{"tf":1.4142135623730951},"54":{"tf":1.0},"55":{"tf":2.23606797749979},"56":{"tf":2.23606797749979},"59":{"tf":1.0},"61":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":2.0},"67":{"tf":2.0},"7":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":3.3166247903554},"81":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"84":{"tf":1.0},"85":{"tf":1.0},"87":{"tf":1.4142135623730951},"88":{"tf":2.23606797749979},"89":{"tf":2.23606797749979},"91":{"tf":1.7320508075688772},"92":{"tf":1.0},"93":{"tf":3.872983346207417},"96":{"tf":1.0}},"e":{"df":0,"docs":{},"x":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"104":{"tf":1.0}}}},"df":5,"docs":{"104":{"tf":1.0},"118":{"tf":1.0},"68":{"tf":2.8284271247461903},"94":{"tf":1.7320508075688772},"96":{"tf":1.4142135623730951}},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"68":{"tf":1.0},"72":{"tf":2.23606797749979}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}},"’":{"df":1,"docs":{"43":{"tf":1.0}}}}},"y":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"59":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"59":{"tf":1.7320508075688772}}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"119":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"(":{"*":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"71":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"90":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"9":{"tf":1.4142135623730951}},"e":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"<":{"[":{"df":0,"docs":{},"u":{"8":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"34":{"tf":2.0}},"e":{"<":{"\'":{"a":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"’":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}}},"n":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":8,"docs":{"19":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"96":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":14,"docs":{"109":{"tf":1.0},"114":{"tf":1.4142135623730951},"115":{"tf":1.0},"119":{"tf":1.0},"14":{"tf":1.0},"2":{"tf":1.0},"23":{"tf":1.4142135623730951},"30":{"tf":1.0},"31":{"tf":1.0},"58":{"tf":1.4142135623730951},"64":{"tf":1.0},"7":{"tf":1.4142135623730951},"78":{"tf":1.0},"81":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"119":{"tf":3.1622776601683795},"16":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":4,"docs":{"17":{"tf":1.7320508075688772},"18":{"tf":1.4142135623730951},"56":{"tf":1.0},"7":{"tf":1.4142135623730951}},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":17,"docs":{"1":{"tf":1.0},"118":{"tf":1.0},"119":{"tf":1.0},"134":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"2":{"tf":1.0},"23":{"tf":1.0},"35":{"tf":1.7320508075688772},"39":{"tf":1.0},"40":{"tf":1.0},"61":{"tf":1.0},"67":{"tf":1.0},"7":{"tf":1.0},"77":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":6,"docs":{"5":{"tf":1.0},"51":{"tf":1.0},"65":{"tf":1.0},"71":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"d":{"df":62,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"101":{"tf":1.4142135623730951},"103":{"tf":3.0},"104":{"tf":2.6457513110645907},"105":{"tf":1.4142135623730951},"108":{"tf":1.0},"11":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"119":{"tf":1.0},"121":{"tf":1.0},"123":{"tf":1.4142135623730951},"133":{"tf":1.4142135623730951},"134":{"tf":2.23606797749979},"135":{"tf":1.0},"19":{"tf":1.4142135623730951},"2":{"tf":1.7320508075688772},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.7320508075688772},"26":{"tf":1.7320508075688772},"28":{"tf":1.0},"3":{"tf":1.4142135623730951},"30":{"tf":1.0},"31":{"tf":1.0},"33":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":1.4142135623730951},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"46":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":2.0},"56":{"tf":2.0},"59":{"tf":2.23606797749979},"60":{"tf":1.0},"65":{"tf":1.7320508075688772},"67":{"tf":1.0},"72":{"tf":1.7320508075688772},"77":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":3.3166247903554},"83":{"tf":1.4142135623730951},"85":{"tf":1.0},"86":{"tf":1.7320508075688772},"87":{"tf":2.0},"88":{"tf":1.7320508075688772},"89":{"tf":2.0},"90":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951},"92":{"tf":1.7320508075688772},"93":{"tf":1.4142135623730951},"96":{"tf":2.6457513110645907},"98":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"92":{"tf":1.0}}}}}},"s":{"_":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"84":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"g":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":2,"docs":{"17":{"tf":1.0},"76":{"tf":1.0}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.0}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"15":{"tf":1.0},"7":{"tf":1.7320508075688772}}}},"t":{"df":1,"docs":{"7":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":23,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"125":{"tf":1.0},"14":{"tf":1.4142135623730951},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"22":{"tf":1.0},"3":{"tf":1.0},"35":{"tf":1.7320508075688772},"4":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0},"81":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951},"90":{"tf":1.0},"91":{"tf":1.4142135623730951},"92":{"tf":1.4142135623730951},"96":{"tf":1.0}}}}},"w":{"(":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":5,"docs":{"102":{"tf":1.0},"105":{"tf":1.0},"62":{"tf":1.0},"67":{"tf":1.0},"98":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":3,"docs":{"89":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"72":{"tf":1.0}}}}},"df":0,"docs":{}}},"<":{"\'":{"a":{">":{"(":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"c":{"a":{"df":0,"docs":{},"p":{"df":4,"docs":{"82":{"tf":2.0},"88":{"tf":1.4142135623730951},"91":{"tf":2.0},"93":{"tf":2.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\\"":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":2,"docs":{"82":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"s":{"df":4,"docs":{"82":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0}}}},"df":4,"docs":{"82":{"tf":1.4142135623730951},"88":{"tf":1.0},"91":{"tf":1.7320508075688772},"93":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"43":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":4,"docs":{"82":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}}}}}},"df":22,"docs":{"0":{"tf":1.0},"103":{"tf":1.4142135623730951},"109":{"tf":1.0},"135":{"tf":1.0},"26":{"tf":1.4142135623730951},"3":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.7320508075688772},"6":{"tf":1.0},"60":{"tf":1.0},"67":{"tf":1.0},"72":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.7320508075688772},"91":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951},"99":{"tf":1.0}}},"x":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"43":{"tf":2.23606797749979},"87":{"tf":1.0},"89":{"tf":1.7320508075688772},"92":{"tf":1.4142135623730951},"93":{"tf":1.7320508075688772}}}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"<":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"59":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"_":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"43":{"tf":1.7320508075688772},"87":{"tf":1.0},"89":{"tf":1.4142135623730951},"92":{"tf":1.0},"93":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"df":2,"docs":{"87":{"tf":1.4142135623730951},"88":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":17,"docs":{"14":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.0},"38":{"tf":1.0},"43":{"tf":1.4142135623730951},"45":{"tf":1.0},"59":{"tf":1.0},"70":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":2.23606797749979},"88":{"tf":1.0},"92":{"tf":1.0}}}}},"i":{"c":{"df":0,"docs":{},"e":{"df":7,"docs":{"31":{"tf":1.0},"41":{"tf":1.0},"59":{"tf":1.0},"62":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"77":{"tf":1.4142135623730951}},"r":{"df":1,"docs":{"80":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"134":{"tf":1.0},"15":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"73":{"tf":1.0},"80":{"tf":1.0}}}}}},"o":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"134":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"114":{"tf":1.0}}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"d":{"df":4,"docs":{"132":{"tf":1.4142135623730951},"133":{"tf":1.0},"134":{"tf":1.4142135623730951},"135":{"tf":2.449489742783178}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"(":{"&":{"\'":{"a":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":2.6457513110645907}}}},"df":1,"docs":{"43":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"<":{"\'":{"a":{"df":1,"docs":{"43":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":1,"docs":{"43":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"23":{"tf":1.0}}}}},"n":{"df":15,"docs":{"10":{"tf":1.4142135623730951},"123":{"tf":1.4142135623730951},"125":{"tf":1.4142135623730951},"126":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"19":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":1.0},"5":{"tf":1.4142135623730951},"65":{"tf":1.0},"7":{"tf":1.4142135623730951},"71":{"tf":1.0},"72":{"tf":1.4142135623730951},"78":{"tf":1.0}},"e":{"df":23,"docs":{"10":{"tf":1.0},"111":{"tf":1.0},"125":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"35":{"tf":2.0},"36":{"tf":1.0},"43":{"tf":2.0},"46":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772},"65":{"tf":1.0},"7":{"tf":1.7320508075688772},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.7320508075688772},"93":{"tf":2.0}}},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":6,"docs":{"101":{"tf":1.0},"4":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772},"72":{"tf":1.0},"82":{"tf":1.4142135623730951},"93":{"tf":1.0}},"l":{":":{":":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"104":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"100":{"tf":1.0}}}}}},"df":0,"docs":{}}},"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":5,"docs":{"82":{"tf":1.4142135623730951},"88":{"tf":1.0},"91":{"tf":1.7320508075688772},"92":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"d":{")":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":3,"docs":{"102":{"tf":1.0},"105":{"tf":1.0},"98":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":4,"docs":{"82":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"<":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"<":{"df":0,"docs":{},"t":{"df":2,"docs":{"105":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"t":{"df":9,"docs":{"100":{"tf":1.0},"104":{"tf":1.0},"59":{"tf":2.23606797749979},"81":{"tf":1.4142135623730951},"87":{"tf":1.0},"88":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.4142135623730951},"98":{"tf":1.0}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":5,"docs":{"14":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.0},"82":{"tf":1.0},"9":{"tf":1.0}}}}}},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"41":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"92":{"tf":1.0}}}},"p":{"df":0,"docs":{},"e":{"df":2,"docs":{"40":{"tf":1.0},"62":{"tf":1.0}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":12,"docs":{"103":{"tf":1.0},"119":{"tf":1.0},"124":{"tf":1.0},"132":{"tf":1.0},"134":{"tf":1.0},"14":{"tf":1.0},"61":{"tf":1.0},"64":{"tf":1.7320508075688772},"67":{"tf":1.0},"68":{"tf":1.7320508075688772},"70":{"tf":1.0},"9":{"tf":1.0}}}},"df":1,"docs":{"1":{"tf":1.0}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":6,"docs":{"122":{"tf":1.0},"126":{"tf":1.0},"2":{"tf":1.0},"55":{"tf":1.0},"68":{"tf":1.0},"75":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":43,"docs":{"1":{"tf":1.4142135623730951},"10":{"tf":1.0},"104":{"tf":1.0},"108":{"tf":1.0},"114":{"tf":1.0},"119":{"tf":1.0},"121":{"tf":1.0},"126":{"tf":1.4142135623730951},"130":{"tf":1.0},"131":{"tf":1.0},"133":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"23":{"tf":1.0},"29":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.4142135623730951},"37":{"tf":1.0},"4":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.4142135623730951},"49":{"tf":1.0},"5":{"tf":1.4142135623730951},"50":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":2.23606797749979},"59":{"tf":1.4142135623730951},"63":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.4142135623730951},"87":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0}}},"h":{"df":11,"docs":{"10":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.0},"40":{"tf":1.0},"5":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.4142135623730951},"59":{"tf":1.0},"72":{"tf":1.0},"82":{"tf":1.0},"92":{"tf":1.7320508075688772}}},"i":{"c":{"df":5,"docs":{"131":{"tf":1.0},"41":{"tf":1.0},"72":{"tf":1.0},"84":{"tf":1.0},"92":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":1,"docs":{"117":{"tf":1.0}}},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"22":{"tf":1.0},"82":{"tf":1.4142135623730951},"96":{"tf":1.0}}}}}},"w":{"df":23,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"101":{"tf":1.4142135623730951},"103":{"tf":1.7320508075688772},"104":{"tf":1.7320508075688772},"33":{"tf":1.7320508075688772},"34":{"tf":1.4142135623730951},"46":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"61":{"tf":1.7320508075688772},"67":{"tf":1.0},"7":{"tf":1.0},"72":{"tf":1.0},"82":{"tf":1.4142135623730951},"85":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.7320508075688772},"9":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.7320508075688772},"93":{"tf":1.0},"97":{"tf":1.0}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"123":{"tf":1.0}},"l":{"a":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"123":{"tf":1.4142135623730951},"125":{"tf":2.449489742783178},"14":{"tf":1.0},"7":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":18,"docs":{"10":{"tf":1.4142135623730951},"102":{"tf":1.0},"105":{"tf":1.0},"125":{"tf":2.0},"14":{"tf":1.0},"16":{"tf":1.0},"4":{"tf":2.23606797749979},"41":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.4142135623730951},"72":{"tf":1.7320508075688772},"81":{"tf":1.7320508075688772},"82":{"tf":1.7320508075688772},"88":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0},"98":{"tf":1.0}}}},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":12,"docs":{"111":{"tf":1.0},"119":{"tf":1.0},"124":{"tf":1.0},"3":{"tf":1.0},"36":{"tf":1.4142135623730951},"62":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"88":{"tf":1.0},"9":{"tf":1.4142135623730951},"91":{"tf":1.0},"93":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"48":{"tf":1.0}}}}}}},"o":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":3,"docs":{"20":{"tf":1.0},"35":{"tf":1.7320508075688772},"71":{"tf":1.0}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":10,"docs":{"104":{"tf":2.0},"117":{"tf":2.8284271247461903},"118":{"tf":1.4142135623730951},"123":{"tf":1.0},"127":{"tf":1.0},"43":{"tf":1.7320508075688772},"57":{"tf":1.4142135623730951},"60":{"tf":2.23606797749979},"82":{"tf":1.7320508075688772},"9":{"tf":1.7320508075688772}},"’":{"df":1,"docs":{"118":{"tf":1.0}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":5,"docs":{"35":{"tf":1.0},"54":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"78":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"56":{"tf":1.4142135623730951},"68":{"tf":1.0}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":3,"docs":{"10":{"tf":1.0},"23":{"tf":1.0},"36":{"tf":1.0}},"s":{"df":5,"docs":{"104":{"tf":1.0},"24":{"tf":1.4142135623730951},"26":{"tf":1.0},"70":{"tf":1.0},"92":{"tf":1.0}}}}}}}},"c":{"c":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":3,"docs":{"10":{"tf":1.7320508075688772},"2":{"tf":1.0},"56":{"tf":1.0}}}},"r":{"df":14,"docs":{"112":{"tf":1.0},"22":{"tf":1.7320508075688772},"27":{"tf":1.4142135623730951},"28":{"tf":1.7320508075688772},"29":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"39":{"tf":1.0},"43":{"tf":1.4142135623730951},"48":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.4142135623730951},"78":{"tf":2.0},"79":{"tf":1.0},"82":{"tf":1.0}}}}},"df":0,"docs":{}},"d":{"d":{"df":2,"docs":{"122":{"tf":1.0},"59":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"115":{"tf":1.0},"87":{"tf":1.0}},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"69":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":1,"docs":{"76":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":10,"docs":{"10":{"tf":1.0},"3":{"tf":1.4142135623730951},"7":{"tf":1.0},"82":{"tf":2.6457513110645907},"83":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0}}}}}}},"h":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":1,"docs":{"130":{"tf":1.0}}}}},"df":3,"docs":{"127":{"tf":1.0},"19":{"tf":1.4142135623730951},"62":{"tf":1.0}}},"k":{"(":{"0":{"df":1,"docs":{"11":{"tf":1.0}}},"_":{"df":1,"docs":{"130":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"a":{"df":0,"docs":{},"y":{"df":6,"docs":{"100":{"tf":1.0},"102":{"tf":1.0},"105":{"tf":1.0},"82":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}}},"df":14,"docs":{"11":{"tf":1.0},"135":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"34":{"tf":2.0},"35":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"59":{"tf":1.0},"70":{"tf":1.4142135623730951},"78":{"tf":1.0},"82":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0}}},"l":{"d":{"_":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"s":{"df":2,"docs":{"88":{"tf":1.0},"91":{"tf":1.0}}}},"df":4,"docs":{"82":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":5,"docs":{"82":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.4142135623730951}}}}},"r":{"c":{"df":2,"docs":{"103":{"tf":2.23606797749979},"105":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":6,"docs":{"40":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":2.23606797749979},"58":{"tf":1.0},"83":{"tf":2.23606797749979},"86":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"36":{"tf":1.0},"84":{"tf":1.0}}}}},"n":{"c":{"df":15,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"135":{"tf":1.0},"23":{"tf":1.0},"28":{"tf":1.0},"43":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"58":{"tf":1.0},"63":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.4142135623730951},"82":{"tf":1.0},"85":{"tf":1.0},"87":{"tf":1.0}}},"df":46,"docs":{"10":{"tf":1.4142135623730951},"103":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"118":{"tf":1.0},"122":{"tf":1.0},"125":{"tf":1.4142135623730951},"126":{"tf":1.7320508075688772},"131":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":2.0},"3":{"tf":2.0},"30":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.4142135623730951},"40":{"tf":1.0},"43":{"tf":1.7320508075688772},"55":{"tf":1.0},"56":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"65":{"tf":1.0},"67":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"7":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"72":{"tf":2.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"86":{"tf":1.4142135623730951},"87":{"tf":2.449489742783178},"91":{"tf":1.4142135623730951},"92":{"tf":1.7320508075688772},"96":{"tf":1.0}},"e":{"df":0,"docs":{},"’":{"df":1,"docs":{"82":{"tf":1.0}}}},"t":{"df":0,"docs":{},"o":{"df":2,"docs":{"43":{"tf":1.0},"87":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"82":{"tf":1.4142135623730951},"83":{"tf":1.0},"93":{"tf":1.0}}},"p":{"df":1,"docs":{"61":{"tf":1.0}}}},"p":{"a":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"131":{"tf":2.0}}}}},"df":7,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.0},"58":{"tf":1.0},"82":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"0":{"tf":1.0}}},"r":{"df":18,"docs":{"10":{"tf":1.0},"104":{"tf":1.4142135623730951},"120":{"tf":1.0},"126":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.4142135623730951},"4":{"tf":2.449489742783178},"46":{"tf":1.7320508075688772},"5":{"tf":1.7320508075688772},"52":{"tf":1.0},"56":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.0},"77":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"79":{"tf":2.23606797749979},"82":{"tf":1.7320508075688772},"91":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"s":{"df":1,"docs":{"34":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"86":{"tf":1.0}}}}}}},"t":{"df":4,"docs":{"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"5":{"tf":1.0}},"i":{"df":0,"docs":{},"m":{"df":21,"docs":{"1":{"tf":1.0},"11":{"tf":1.4142135623730951},"125":{"tf":2.23606797749979},"16":{"tf":1.7320508075688772},"19":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":3.3166247903554},"23":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.4142135623730951},"64":{"tf":1.0},"7":{"tf":1.4142135623730951},"73":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.7320508075688772},"95":{"tf":1.0}}},"o":{"df":0,"docs":{},"n":{"<":{"&":{"\'":{"a":{"df":1,"docs":{"43":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"56":{"tf":1.0}}}},"x":{"<":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"59":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"125":{"tf":2.0}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"<":{"\'":{"a":{"df":2,"docs":{"35":{"tf":1.7320508075688772},"36":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"m":{"a":{"df":0,"docs":{},"y":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"<":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"43":{"tf":2.8284271247461903}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"df":8,"docs":{"125":{"tf":1.0},"14":{"tf":1.0},"67":{"tf":1.0},"83":{"tf":1.0},"87":{"tf":1.4142135623730951},"89":{"tf":2.23606797749979},"92":{"tf":1.7320508075688772},"93":{"tf":2.6457513110645907}}},"u":{"8":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}},"df":0,"docs":{},"s":{"df":4,"docs":{"87":{"tf":1.0},"89":{"tf":1.4142135623730951},"92":{"tf":1.0},"93":{"tf":1.7320508075688772}}}},"v":{"df":0,"docs":{},"e":{"c":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"81":{"tf":1.0}}},"u":{"8":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":7,"docs":{"16":{"tf":1.0},"2":{"tf":1.4142135623730951},"43":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"64":{"tf":1.4142135623730951},"67":{"tf":1.0}}}}}}},"r":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}}}},"d":{"df":2,"docs":{"3":{"tf":3.3166247903554},"67":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":33,"docs":{"103":{"tf":2.449489742783178},"105":{"tf":1.7320508075688772},"109":{"tf":1.0},"121":{"tf":1.0},"133":{"tf":1.0},"14":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":2.23606797749979},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":2.449489742783178},"37":{"tf":1.7320508075688772},"40":{"tf":1.0},"43":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.4142135623730951},"60":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":2.0},"70":{"tf":1.7320508075688772},"74":{"tf":1.4142135623730951},"75":{"tf":3.1622776601683795},"76":{"tf":2.0},"77":{"tf":2.0},"78":{"tf":1.7320508075688772},"79":{"tf":1.7320508075688772},"82":{"tf":1.0},"87":{"tf":1.7320508075688772},"9":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{":":{":":{"a":{"c":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"x":{"df":2,"docs":{"103":{"tf":1.4142135623730951},"105":{"tf":1.0}},"e":{"d":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":3,"docs":{"104":{"tf":1.4142135623730951},"105":{"tf":1.0},"78":{"tf":1.0}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"23":{"tf":1.0},"24":{"tf":1.0},"31":{"tf":1.0},"50":{"tf":1.0},"9":{"tf":1.0},"92":{"tf":1.0}}}}}}},"s":{"df":4,"docs":{"60":{"tf":1.0},"64":{"tf":1.4142135623730951},"69":{"tf":1.0},"70":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"_":{"a":{"d":{"d":{"(":{"1":{"0":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":1,"docs":{"70":{"tf":2.0}}}},"df":0,"docs":{}}},"df":5,"docs":{"3":{"tf":1.0},"34":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"9":{"tf":1.0}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":15,"docs":{"1":{"tf":1.0},"104":{"tf":1.0},"128":{"tf":1.0},"15":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.0},"29":{"tf":1.0},"34":{"tf":1.4142135623730951},"4":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.0},"61":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.0},"93":{"tf":1.0}}}}},"’":{"df":1,"docs":{"2":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":3,"docs":{"72":{"tf":1.0},"80":{"tf":1.0},"85":{"tf":1.0}}}}}}},"t":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}},"df":41,"docs":{"108":{"tf":1.0},"120":{"tf":1.0},"123":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.4142135623730951},"30":{"tf":1.0},"34":{"tf":2.23606797749979},"38":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"52":{"tf":2.23606797749979},"54":{"tf":1.4142135623730951},"55":{"tf":2.8284271247461903},"56":{"tf":1.7320508075688772},"58":{"tf":1.0},"59":{"tf":1.4142135623730951},"61":{"tf":1.7320508075688772},"63":{"tf":1.4142135623730951},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.4142135623730951},"68":{"tf":1.0},"7":{"tf":2.23606797749979},"72":{"tf":1.0},"73":{"tf":1.0},"78":{"tf":1.0},"82":{"tf":2.23606797749979},"83":{"tf":1.7320508075688772},"86":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.4142135623730951},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"23":{"tf":1.0},"7":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"46":{"tf":1.0}}},"v":{"df":6,"docs":{"20":{"tf":1.0},"24":{"tf":1.7320508075688772},"26":{"tf":1.0},"35":{"tf":2.449489742783178},"36":{"tf":1.0},"63":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":9,"docs":{"109":{"tf":1.0},"111":{"tf":2.0},"119":{"tf":1.4142135623730951},"134":{"tf":1.0},"135":{"tf":1.0},"22":{"tf":4.69041575982343},"29":{"tf":2.449489742783178},"30":{"tf":1.4142135623730951},"34":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":4,"docs":{"110":{"tf":1.0},"131":{"tf":1.0},"31":{"tf":1.0},"4":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}},"df":21,"docs":{"103":{"tf":1.0},"118":{"tf":1.0},"12":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.0},"26":{"tf":1.0},"34":{"tf":5.196152422706632},"39":{"tf":1.0},"43":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":2.0},"66":{"tf":1.0},"67":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"70":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.4142135623730951},"87":{"tf":1.0},"96":{"tf":1.0}},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":10,"docs":{"103":{"tf":1.0},"16":{"tf":1.4142135623730951},"4":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"82":{"tf":1.4142135623730951},"88":{"tf":1.0},"91":{"tf":2.0},"93":{"tf":1.7320508075688772}}}}},"u":{"df":0,"docs":{},"l":{"df":2,"docs":{"91":{"tf":1.0},"93":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":2,"docs":{"10":{"tf":1.0},"61":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"96":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"p":{"df":8,"docs":{"21":{"tf":1.0},"22":{"tf":1.0},"28":{"tf":1.0},"43":{"tf":1.0},"56":{"tf":1.0},"78":{"tf":1.0},"82":{"tf":1.4142135623730951},"86":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":1,"docs":{"40":{"tf":1.0}}},"o":{"a":{"d":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"64":{"tf":1.0}}}}}}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"22":{"tf":1.0},"34":{"tf":1.0},"55":{"tf":2.8284271247461903},"56":{"tf":1.0},"83":{"tf":1.0}}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"75":{"tf":1.0}}}}}}}}},"w":{"df":0,"docs":{},"n":{"df":9,"docs":{"123":{"tf":1.0},"24":{"tf":1.0},"34":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"63":{"tf":1.0},"81":{"tf":1.0},"96":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"19":{"tf":1.0},"64":{"tf":1.0},"96":{"tf":2.0}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":13,"docs":{"112":{"tf":1.0},"19":{"tf":2.23606797749979},"32":{"tf":1.0},"41":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"87":{"tf":1.0},"96":{"tf":2.23606797749979}}}}}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"109":{"tf":1.4142135623730951}}}},"df":3,"docs":{"123":{"tf":1.0},"17":{"tf":1.7320508075688772},"7":{"tf":1.0}}}},"d":{"df":3,"docs":{"123":{"tf":1.0},"17":{"tf":1.0},"7":{"tf":1.7320508075688772}}},"df":0,"docs":{},"e":{"df":1,"docs":{"82":{"tf":1.0}}},"g":{"df":0,"docs":{},"e":{"df":4,"docs":{"131":{"tf":1.0},"45":{"tf":1.0},"82":{"tf":1.0},"92":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"56":{"tf":1.0}}},"r":{"df":2,"docs":{"78":{"tf":1.0},"88":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"c":{"!":{"(":{"\\"":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"130":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"h":{"df":1,"docs":{"127":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"(":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":1,"docs":{"135":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":1,"docs":{"135":{"tf":1.0}}}}}}},"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"=":{"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"126":{"tf":1.0},"129":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"127":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"_":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"135":{"tf":1.0}}}},"n":{"d":{"df":0,"docs":{},"l":{"df":2,"docs":{"134":{"tf":1.0},"135":{"tf":2.449489742783178}},"e":{"df":0,"docs":{},"r":{"(":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":1,"docs":{"134":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"135":{"tf":1.0}}}}}}}}}}},"df":15,"docs":{"112":{"tf":1.0},"126":{"tf":2.449489742783178},"127":{"tf":1.4142135623730951},"129":{"tf":1.0},"130":{"tf":2.0},"134":{"tf":1.4142135623730951},"135":{"tf":2.6457513110645907},"56":{"tf":1.4142135623730951},"64":{"tf":3.605551275463989},"65":{"tf":2.6457513110645907},"66":{"tf":1.4142135623730951},"67":{"tf":2.23606797749979},"68":{"tf":2.6457513110645907},"70":{"tf":1.0},"82":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":2,"docs":{"134":{"tf":1.0},"135":{"tf":1.7320508075688772}}}}}},"k":{"df":4,"docs":{"135":{"tf":2.0},"56":{"tf":1.0},"65":{"tf":1.0},"70":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}},"r":{"a":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"df":1,"docs":{"69":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"69":{"tf":1.4142135623730951},"82":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":9,"docs":{"111":{"tf":1.4142135623730951},"125":{"tf":1.0},"29":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"67":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":1,"docs":{"67":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"67":{"tf":2.23606797749979}}}}},"df":0,"docs":{}}}},"df":3,"docs":{"63":{"tf":2.0},"64":{"tf":1.0},"67":{"tf":1.0}},"’":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"t":{"df":20,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"131":{"tf":1.0},"15":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.4142135623730951},"44":{"tf":1.0},"56":{"tf":1.4142135623730951},"61":{"tf":1.0},"63":{"tf":1.0},"76":{"tf":1.0},"81":{"tf":1.0},"88":{"tf":1.0}},"i":{"a":{"df":0,"docs":{},"l":{"df":5,"docs":{"119":{"tf":1.4142135623730951},"3":{"tf":1.0},"34":{"tf":1.0},"56":{"tf":1.0},"6":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"119":{"tf":1.0}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":17,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"104":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.0},"4":{"tf":1.4142135623730951},"55":{"tf":1.0},"56":{"tf":1.4142135623730951},"64":{"tf":1.0},"68":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.0},"85":{"tf":1.0},"89":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":8,"docs":{"23":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.0},"62":{"tf":1.0},"73":{"tf":1.0},"77":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":19,"docs":{"111":{"tf":1.4142135623730951},"116":{"tf":1.0},"117":{"tf":1.0},"125":{"tf":1.0},"131":{"tf":1.0},"14":{"tf":2.0},"15":{"tf":1.0},"16":{"tf":1.0},"23":{"tf":1.4142135623730951},"3":{"tf":1.7320508075688772},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"4":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0}}},"t":{"df":4,"docs":{"3":{"tf":1.0},"40":{"tf":1.0},"60":{"tf":1.0},"87":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"109":{"tf":1.0},"23":{"tf":1.4142135623730951},"56":{"tf":1.0},"92":{"tf":1.4142135623730951}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":4,"docs":{"29":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"57":{"tf":1.4142135623730951}}}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"82":{"tf":1.0}}}}}}},"d":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"111":{"tf":2.0}}}}},"df":4,"docs":{"82":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0}},"e":{"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"92":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":5,"docs":{"1":{"tf":1.4142135623730951},"11":{"tf":1.0},"3":{"tf":1.4142135623730951},"40":{"tf":1.0},"60":{"tf":1.0}}}}},"r":{"df":1,"docs":{"41":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":9,"docs":{"131":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0},"63":{"tf":1.0},"78":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":18,"docs":{"104":{"tf":1.0},"118":{"tf":1.4142135623730951},"19":{"tf":1.0},"2":{"tf":1.7320508075688772},"22":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"34":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"54":{"tf":1.0},"61":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.4142135623730951},"72":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"88":{"tf":1.0},"9":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"43":{"tf":1.0},"67":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"57":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"n":{"df":3,"docs":{"43":{"tf":1.0},"62":{"tf":1.0},"80":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"4":{"tf":1.0}}}},"t":{"df":5,"docs":{"126":{"tf":1.4142135623730951},"127":{"tf":1.0},"14":{"tf":1.0},"32":{"tf":1.0},"56":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"119":{"tf":1.0},"60":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"s":{"df":8,"docs":{"19":{"tf":1.0},"3":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"44":{"tf":1.0},"47":{"tf":1.0},"57":{"tf":1.0},"6":{"tf":1.0},"71":{"tf":1.0}}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"<":{"&":{"\'":{"a":{"df":3,"docs":{"42":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"93":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"*":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}}}},"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"<":{"df":0,"docs":{},"t":{"df":2,"docs":{"105":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"<":{"&":{"\'":{"a":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.4142135623730951}}}},"df":1,"docs":{"42":{"tf":1.0}}}},"t":{"df":3,"docs":{"40":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"42":{"tf":1.0}}}},"df":11,"docs":{"102":{"tf":1.0},"103":{"tf":1.4142135623730951},"105":{"tf":1.4142135623730951},"39":{"tf":2.0},"40":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"81":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0},"98":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":6,"docs":{"102":{"tf":1.0},"103":{"tf":1.4142135623730951},"105":{"tf":1.7320508075688772},"42":{"tf":1.0},"96":{"tf":1.0},"98":{"tf":1.0}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"131":{"tf":1.0},"42":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"67":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"82":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":2,"docs":{"58":{"tf":1.0},"64":{"tf":1.0}}}}}}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{},"e":{"c":{"df":3,"docs":{"1":{"tf":1.0},"23":{"tf":1.4142135623730951},"43":{"tf":1.0}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"e":{"df":3,"docs":{"44":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0}}}},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":1,"docs":{"41":{"tf":1.0}}}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":11,"docs":{"1":{"tf":1.4142135623730951},"115":{"tf":1.0},"26":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"33":{"tf":1.0},"61":{"tf":1.0},"65":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.7320508075688772},"96":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":1.0}}}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":6,"docs":{"134":{"tf":1.4142135623730951},"7":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951},"82":{"tf":2.23606797749979}},"’":{"df":4,"docs":{"110":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"14":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"19":{"tf":1.0},"43":{"tf":1.0}}}},"df":0,"docs":{}}}},"y":{"df":2,"docs":{"7":{"tf":1.0},"82":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":3,"docs":{"109":{"tf":1.0},"130":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":1,"docs":{"68":{"tf":1.0}}}},"o":{"df":1,"docs":{"67":{"tf":2.6457513110645907}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":23,"docs":{"123":{"tf":1.0},"134":{"tf":2.0},"19":{"tf":1.4142135623730951},"26":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"4":{"tf":2.449489742783178},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"7":{"tf":1.0},"75":{"tf":1.4142135623730951},"82":{"tf":1.7320508075688772},"87":{"tf":2.0},"9":{"tf":1.0},"92":{"tf":1.0},"96":{"tf":1.0}},"e":{"df":2,"docs":{"4":{"tf":1.0},"9":{"tf":1.4142135623730951}},"r":{"df":47,"docs":{"10":{"tf":1.7320508075688772},"100":{"tf":1.4142135623730951},"101":{"tf":1.0},"102":{"tf":1.4142135623730951},"103":{"tf":1.0},"104":{"tf":2.0},"105":{"tf":2.0},"11":{"tf":1.4142135623730951},"110":{"tf":1.7320508075688772},"111":{"tf":1.0},"117":{"tf":1.4142135623730951},"120":{"tf":1.0},"123":{"tf":1.7320508075688772},"125":{"tf":3.0},"131":{"tf":1.4142135623730951},"14":{"tf":2.0},"16":{"tf":1.0},"19":{"tf":2.0},"2":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"3":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.7320508075688772},"35":{"tf":1.0},"4":{"tf":3.3166247903554},"41":{"tf":1.7320508075688772},"43":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":2.0},"52":{"tf":1.4142135623730951},"56":{"tf":2.0},"60":{"tf":1.0},"61":{"tf":1.0},"7":{"tf":2.0},"71":{"tf":2.23606797749979},"72":{"tf":2.6457513110645907},"81":{"tf":2.449489742783178},"82":{"tf":1.7320508075688772},"87":{"tf":2.449489742783178},"88":{"tf":1.0},"9":{"tf":2.6457513110645907},"90":{"tf":2.0},"91":{"tf":1.4142135623730951},"92":{"tf":2.6457513110645907},"96":{"tf":1.7320508075688772},"98":{"tf":1.7320508075688772}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"68":{"tf":2.449489742783178}}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}},"r":{"df":1,"docs":{"64":{"tf":1.0}}}},"p":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"83":{"tf":1.0},"93":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":6,"docs":{"83":{"tf":2.0},"84":{"tf":1.7320508075688772},"85":{"tf":1.0},"87":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}},"r":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"103":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"67":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"29":{"tf":3.0},"7":{"tf":1.0},"76":{"tf":1.0},"8":{"tf":1.0},"82":{"tf":1.0}}},"x":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"72":{"tf":1.0}}}}}}}}},"df":1,"docs":{"72":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":32,"docs":{"104":{"tf":1.4142135623730951},"11":{"tf":1.0},"110":{"tf":1.0},"116":{"tf":1.0},"118":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":2.0},"23":{"tf":1.4142135623730951},"26":{"tf":1.0},"3":{"tf":1.4142135623730951},"30":{"tf":1.0},"35":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.4142135623730951},"55":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":2.0},"92":{"tf":1.0},"93":{"tf":1.0},"99":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":7,"docs":{"10":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"47":{"tf":1.0},"67":{"tf":1.0},"7":{"tf":1.0},"75":{"tf":1.0}}}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"30":{"tf":1.0},"56":{"tf":1.0},"7":{"tf":1.0},"77":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":6,"docs":{"34":{"tf":1.4142135623730951},"60":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"60":{"tf":1.0}}}},"s":{"df":4,"docs":{"36":{"tf":1.4142135623730951},"40":{"tf":1.0},"52":{"tf":1.0},"67":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{}}},"df":1,"docs":{"93":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"70":{"tf":1.0}}}},"v":{"df":1,"docs":{"130":{"tf":1.0}}}}}}}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"123":{"tf":1.0},"17":{"tf":1.0},"64":{"tf":1.0}}}},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"52":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"109":{"tf":1.0},"3":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"3":{"tf":1.0},"99":{"tf":1.0}}}},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"25":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"23":{"tf":1.4142135623730951},"82":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":16,"docs":{"10":{"tf":1.0},"101":{"tf":1.0},"103":{"tf":1.0},"19":{"tf":1.0},"34":{"tf":1.0},"4":{"tf":1.0},"43":{"tf":1.4142135623730951},"56":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.4142135623730951},"63":{"tf":1.0},"65":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.4142135623730951},"85":{"tf":1.0},"98":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":19,"docs":{"104":{"tf":2.0},"105":{"tf":1.0},"11":{"tf":1.0},"134":{"tf":1.0},"19":{"tf":1.4142135623730951},"22":{"tf":1.0},"23":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"4":{"tf":1.4142135623730951},"48":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.0},"59":{"tf":2.23606797749979},"60":{"tf":1.0},"62":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":2.0},"71":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":8,"docs":{"122":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.4142135623730951},"27":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"55":{"tf":1.0},"91":{"tf":1.0}},"s":{"df":2,"docs":{"118":{"tf":1.0},"55":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"11":{"tf":1.0},"22":{"tf":1.0},"30":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"1":{"tf":1.7320508075688772},"48":{"tf":1.0},"7":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"99":{"tf":1.0}}}}},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":5,"docs":{"11":{"tf":1.0},"41":{"tf":1.0},"63":{"tf":1.0},"7":{"tf":1.0},"82":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"(":{"df":1,"docs":{"29":{"tf":1.0}}},"<":{"\'":{"a":{">":{"(":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":5,"docs":{"128":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"41":{"tf":1.0},"9":{"tf":1.0}},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\\"":{"a":{"df":3,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0}},"l":{"df":1,"docs":{"93":{"tf":1.0}}}},"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":1,"docs":{"109":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"114":{"tf":1.0}}}}}}},"i":{"\'":{"df":0,"docs":{},"m":{"df":2,"docs":{"116":{"tf":1.0},"117":{"tf":1.0}}}},"df":1,"docs":{"35":{"tf":1.0}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"_":{"df":2,"docs":{"35":{"tf":1.4142135623730951},"36":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"36":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"m":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"110":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"a":{"df":0,"docs":{},"w":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"92":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"121":{"tf":1.0}}}}},"{":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"34":{"tf":1.4142135623730951}}}}}}},"v":{"df":1,"docs":{"34":{"tf":1.0}}},"x":{"df":1,"docs":{"56":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":16,"docs":{"121":{"tf":1.0},"128":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.7320508075688772},"26":{"tf":2.23606797749979},"27":{"tf":1.7320508075688772},"31":{"tf":1.7320508075688772},"34":{"tf":1.0},"43":{"tf":1.7320508075688772},"54":{"tf":2.6457513110645907},"55":{"tf":1.7320508075688772},"61":{"tf":1.0},"70":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"<":{"\'":{"df":1,"docs":{"41":{"tf":1.4142135623730951}},"s":{">":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}},"v":{"a":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"t":{"df":4,"docs":{"131":{"tf":1.4142135623730951},"133":{"tf":1.0},"5":{"tf":1.0},"89":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"b":{"a":{"b":{"df":0,"docs":{},"l":{"df":9,"docs":{"103":{"tf":1.4142135623730951},"104":{"tf":1.0},"134":{"tf":1.7320508075688772},"20":{"tf":1.0},"21":{"tf":1.0},"30":{"tf":1.0},"4":{"tf":1.0},"60":{"tf":1.0},"82":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.0},"14":{"tf":1.0}}}},"df":23,"docs":{"103":{"tf":1.0},"11":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.4142135623730951},"25":{"tf":1.0},"3":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"4":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"55":{"tf":1.7320508075688772},"56":{"tf":1.0},"60":{"tf":1.4142135623730951},"64":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"73":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.0},"89":{"tf":1.0},"92":{"tf":1.0},"96":{"tf":1.4142135623730951}}}}}},"c":{"df":0,"docs":{},"e":{"df":5,"docs":{"24":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"64":{"tf":1.0},"68":{"tf":1.0}},"e":{"d":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"125":{"tf":1.0},"126":{"tf":1.4142135623730951},"129":{"tf":1.0},"130":{"tf":1.4142135623730951}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":15,"docs":{"10":{"tf":1.4142135623730951},"134":{"tf":1.0},"16":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"34":{"tf":1.0},"4":{"tf":1.4142135623730951},"43":{"tf":1.0},"52":{"tf":1.4142135623730951},"59":{"tf":1.0},"61":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.0}},"t":{"df":2,"docs":{"4":{"tf":1.0},"7":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"135":{"tf":2.0}}}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":33,"docs":{"1":{"tf":2.0},"103":{"tf":1.4142135623730951},"131":{"tf":1.0},"134":{"tf":1.4142135623730951},"14":{"tf":1.0},"19":{"tf":1.4142135623730951},"2":{"tf":2.449489742783178},"22":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":2.23606797749979},"27":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.7320508075688772},"4":{"tf":2.0},"5":{"tf":1.4142135623730951},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":2.0},"62":{"tf":1.0},"64":{"tf":2.449489742783178},"65":{"tf":2.0},"68":{"tf":1.4142135623730951},"70":{"tf":2.449489742783178},"73":{"tf":1.0},"74":{"tf":1.7320508075688772},"75":{"tf":1.7320508075688772},"76":{"tf":2.449489742783178},"77":{"tf":1.7320508075688772},"82":{"tf":1.4142135623730951}},"m":{"df":3,"docs":{"19":{"tf":1.0},"2":{"tf":1.4142135623730951},"3":{"tf":1.0}}},"’":{"df":1,"docs":{"77":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"95":{"tf":1.0}}}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"109":{"tf":1.0},"14":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":5,"docs":{"110":{"tf":1.0},"120":{"tf":1.0},"24":{"tf":1.0},"3":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"121":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"121":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":2,"docs":{"30":{"tf":1.0},"39":{"tf":1.0}}}},"o":{"df":0,"docs":{},"f":{"df":2,"docs":{"22":{"tf":1.0},"5":{"tf":1.0}}}},"p":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"119":{"tf":1.4142135623730951},"22":{"tf":1.0},"76":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"118":{"tf":1.0},"12":{"tf":1.0},"85":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":6,"docs":{"26":{"tf":1.0},"56":{"tf":1.4142135623730951},"7":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"9":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":11,"docs":{"2":{"tf":1.0},"3":{"tf":1.7320508075688772},"34":{"tf":2.0},"41":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0},"77":{"tf":1.0},"81":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"15":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"82":{"tf":1.0}}}},"df":0,"docs":{}}},"v":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":5,"docs":{"10":{"tf":1.0},"19":{"tf":1.4142135623730951},"22":{"tf":2.449489742783178},"77":{"tf":1.0},"82":{"tf":1.0}}},"i":{"d":{"df":37,"docs":{"1":{"tf":1.4142135623730951},"108":{"tf":1.0},"11":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"119":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.0},"125":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.4142135623730951},"134":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"31":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":1.4142135623730951},"44":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.4142135623730951},"58":{"tf":2.0},"59":{"tf":1.4142135623730951},"65":{"tf":1.0},"69":{"tf":1.0},"75":{"tf":2.0},"79":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"83":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"91":{"tf":1.0},"96":{"tf":1.4142135623730951},"99":{"tf":1.0}}},"df":0,"docs":{}}},"x":{"df":0,"docs":{},"i":{"df":2,"docs":{"60":{"tf":1.7320508075688772},"62":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"c":{"df":1,"docs":{"111":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"y":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"88":{"tf":1.0},"93":{"tf":1.0}}}}}}},"df":0,"docs":{}},".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{")":{".":{"a":{"d":{"d":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"87":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"72":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"87":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"86":{"tf":1.7320508075688772},"93":{"tf":1.4142135623730951}}},"y":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"df":2,"docs":{"56":{"tf":1.0},"86":{"tf":1.0}}},"df":0,"docs":{}}}},"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":0,"docs":{},"e":{":":{":":{"<":{"[":{"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"72":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.0}}}}}},"df":1,"docs":{"121":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"82":{"tf":1.4142135623730951}}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"(":{"&":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"[":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":1,"docs":{"67":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":3,"docs":{"88":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{")":{".":{"a":{"d":{"d":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"93":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{")":{".":{"a":{"d":{"d":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"86":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"62":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"87":{"tf":1.0},"92":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":5,"docs":{"83":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"56":{"tf":1.0},"62":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{")":{".":{"a":{"d":{"d":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"93":{"tf":1.0}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},".":{"a":{"d":{"d":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{")":{".":{"a":{"d":{"d":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"86":{"tf":1.0}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"83":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":3,"docs":{"56":{"tf":1.4142135623730951},"83":{"tf":1.0},"91":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}}}}}}},"df":20,"docs":{"102":{"tf":1.0},"103":{"tf":1.4142135623730951},"105":{"tf":1.7320508075688772},"120":{"tf":1.0},"39":{"tf":1.4142135623730951},"41":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0},"56":{"tf":1.7320508075688772},"59":{"tf":2.449489742783178},"62":{"tf":2.0},"72":{"tf":1.7320508075688772},"81":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951},"88":{"tf":1.7320508075688772},"91":{"tf":1.0},"93":{"tf":1.4142135623730951},"96":{"tf":1.4142135623730951},"98":{"tf":1.0}}}},"u":{"b":{"df":22,"docs":{"102":{"tf":1.0},"105":{"tf":1.7320508075688772},"111":{"tf":1.7320508075688772},"114":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":2.449489742783178},"15":{"tf":1.0},"34":{"tf":1.0},"43":{"tf":2.8284271247461903},"5":{"tf":1.4142135623730951},"63":{"tf":1.0},"72":{"tf":2.6457513110645907},"81":{"tf":1.4142135623730951},"82":{"tf":1.0},"83":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951},"87":{"tf":1.0},"88":{"tf":1.7320508075688772},"89":{"tf":1.7320508075688772},"93":{"tf":3.605551275463989},"96":{"tf":2.0},"98":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"c":{"df":4,"docs":{"131":{"tf":1.0},"15":{"tf":1.0},"5":{"tf":1.0},"72":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"134":{"tf":1.0},"61":{"tf":1.0}}}},"n":{"df":1,"docs":{"1":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"df":3,"docs":{"2":{"tf":1.0},"35":{"tf":1.0},"58":{"tf":1.0}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":6,"docs":{"14":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":1.0},"30":{"tf":1.0},"39":{"tf":1.0},"46":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"h":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"5":{"tf":1.0},"83":{"tf":1.0},"93":{"tf":1.0}}}}}},"df":0,"docs":{}},"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"88":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}},"_":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":10,"docs":{"19":{"tf":1.0},"25":{"tf":1.4142135623730951},"26":{"tf":1.0},"34":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0},"83":{"tf":2.0},"85":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0}}}},"t":{"df":3,"docs":{"125":{"tf":1.0},"82":{"tf":1.7320508075688772},"96":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"82":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"131":{"tf":1.0},"35":{"tf":1.0},"5":{"tf":1.0},"82":{"tf":1.0}}}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"11":{"tf":1.0},"30":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"103":{"tf":1.0}}}}}}}}}},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"89":{"tf":1.0}}}},"t":{"df":5,"docs":{"4":{"tf":1.0},"60":{"tf":1.4142135623730951},"7":{"tf":1.0},"73":{"tf":1.0},"82":{"tf":1.0}}}},"x":{"df":1,"docs":{"10":{"tf":1.0}}}}},"r":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"0":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"a":{"c":{"df":0,"docs":{},"e":{"df":8,"docs":{"4":{"tf":1.4142135623730951},"63":{"tf":1.0},"69":{"tf":1.4142135623730951},"70":{"tf":4.123105625617661},"72":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"99":{"tf":1.4142135623730951}}}},"d":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"74":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"i":{"df":1,"docs":{"57":{"tf":1.0}}}},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"55":{"tf":1.0},"82":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"82":{"tf":1.0}}}}}}},"df":2,"docs":{"11":{"tf":1.0},"70":{"tf":1.0}},"g":{"df":4,"docs":{"4":{"tf":1.4142135623730951},"56":{"tf":1.0},"7":{"tf":1.0},"89":{"tf":1.0}}},"k":{"df":2,"docs":{"31":{"tf":1.4142135623730951},"34":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":8,"docs":{"4":{"tf":1.0},"47":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"77":{"tf":1.0},"79":{"tf":1.0}},"r":{"df":1,"docs":{"60":{"tf":1.0}}}}},"w":{"df":23,"docs":{"11":{"tf":1.4142135623730951},"110":{"tf":1.0},"111":{"tf":1.0},"117":{"tf":1.0},"120":{"tf":1.0},"123":{"tf":1.0},"16":{"tf":1.0},"22":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"4":{"tf":2.23606797749979},"41":{"tf":1.0},"43":{"tf":1.0},"48":{"tf":1.7320508075688772},"50":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"56":{"tf":2.449489742783178},"71":{"tf":2.23606797749979},"72":{"tf":1.0},"81":{"tf":1.7320508075688772},"90":{"tf":2.0},"92":{"tf":1.0},"96":{"tf":1.0}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"89":{"tf":1.7320508075688772},"90":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"89":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"t":{"df":3,"docs":{"89":{"tf":2.0},"92":{"tf":1.7320508075688772},"93":{"tf":2.449489742783178}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"e":{"c":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"88":{"tf":1.0},"93":{"tf":1.0}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"t":{"df":5,"docs":{"88":{"tf":2.6457513110645907},"89":{"tf":1.0},"91":{"tf":1.4142135623730951},"92":{"tf":1.0},"93":{"tf":2.6457513110645907}}}},"df":4,"docs":{"88":{"tf":1.7320508075688772},"90":{"tf":1.0},"91":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}},"’":{"df":1,"docs":{"92":{"tf":1.0}}}},"df":0,"docs":{}}}}},"c":{"<":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"<":{"[":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":2.23606797749979}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.7320508075688772}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.4142135623730951}}}},"df":1,"docs":{"62":{"tf":1.0}}}}},"df":9,"docs":{"102":{"tf":1.0},"105":{"tf":1.4142135623730951},"57":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":3.1622776601683795},"71":{"tf":1.7320508075688772},"96":{"tf":1.4142135623730951},"98":{"tf":1.0},"99":{"tf":1.7320508075688772}}},"df":2,"docs":{"36":{"tf":1.0},"43":{"tf":1.7320508075688772}},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":5,"docs":{"103":{"tf":1.0},"54":{"tf":1.0},"59":{"tf":1.0},"64":{"tf":1.0},"88":{"tf":1.0}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"118":{"tf":1.0}}}}}}},"d":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"92":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":20,"docs":{"1":{"tf":1.4142135623730951},"109":{"tf":1.0},"11":{"tf":1.0},"121":{"tf":1.0},"22":{"tf":3.0},"31":{"tf":1.0},"35":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"54":{"tf":1.0},"56":{"tf":1.4142135623730951},"61":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"87":{"tf":2.6457513110645907},"88":{"tf":1.0},"92":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"72":{"tf":1.0}}}},"i":{"df":5,"docs":{"114":{"tf":1.0},"58":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.7320508075688772},"82":{"tf":1.0}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"119":{"tf":1.4142135623730951},"121":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"l":{"df":5,"docs":{"31":{"tf":1.0},"41":{"tf":1.0},"67":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"5":{"tf":1.0}}}},"z":{"df":1,"docs":{"10":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":20,"docs":{"103":{"tf":1.0},"11":{"tf":1.0},"131":{"tf":1.0},"14":{"tf":1.0},"2":{"tf":1.0},"23":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"46":{"tf":1.0},"52":{"tf":1.7320508075688772},"56":{"tf":1.4142135623730951},"57":{"tf":1.0},"59":{"tf":1.0},"69":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.4142135623730951},"84":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0}}},"o":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":2,"docs":{"19":{"tf":1.0},"82":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":21,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"135":{"tf":1.0},"2":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"27":{"tf":1.0},"3":{"tf":1.7320508075688772},"35":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"56":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"64":{"tf":1.7320508075688772},"70":{"tf":1.0},"72":{"tf":1.0},"76":{"tf":1.4142135623730951},"77":{"tf":1.0},"82":{"tf":1.4142135623730951},"85":{"tf":1.0},"92":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"54":{"tf":1.0}}}}}}}},"c":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"81":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":5,"docs":{"117":{"tf":1.0},"125":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"73":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"11":{"tf":1.0},"14":{"tf":1.0},"82":{"tf":1.0}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"59":{"tf":2.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":4,"docs":{"10":{"tf":1.0},"28":{"tf":1.0},"36":{"tf":1.0},"74":{"tf":1.0}}},"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"6":{"tf":1.0},"66":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.0}}},"df":0,"docs":{}}}},"df":5,"docs":{"105":{"tf":1.0},"11":{"tf":1.4142135623730951},"22":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0}},"f":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":2.449489742783178}}}}}}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"59":{"tf":1.0}}}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"71":{"tf":1.0}},"l":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"<":{"&":{"\'":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"62":{"tf":1.0},"71":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":50,"docs":{"1":{"tf":2.449489742783178},"10":{"tf":1.4142135623730951},"101":{"tf":1.0},"102":{"tf":1.4142135623730951},"103":{"tf":3.0},"104":{"tf":3.3166247903554},"105":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"123":{"tf":1.0},"125":{"tf":1.0},"134":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":2.6457513110645907},"20":{"tf":2.8284271247461903},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":2.8284271247461903},"24":{"tf":3.3166247903554},"25":{"tf":2.8284271247461903},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"3":{"tf":1.0},"30":{"tf":2.23606797749979},"33":{"tf":1.0},"34":{"tf":3.3166247903554},"35":{"tf":1.4142135623730951},"36":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":2.6457513110645907},"41":{"tf":1.4142135623730951},"43":{"tf":3.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"52":{"tf":1.4142135623730951},"55":{"tf":1.0},"56":{"tf":2.23606797749979},"6":{"tf":2.0},"60":{"tf":1.4142135623730951},"63":{"tf":2.0},"65":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":2.449489742783178},"73":{"tf":1.0},"88":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.7320508075688772},"98":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"c":{"df":3,"docs":{"117":{"tf":1.4142135623730951},"46":{"tf":1.0},"99":{"tf":1.0}},"e":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"5":{"tf":1.0},"53":{"tf":1.0},"62":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"g":{"a":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"14":{"tf":1.0},"30":{"tf":1.0},"9":{"tf":1.0}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":6,"docs":{"119":{"tf":1.0},"126":{"tf":1.0},"19":{"tf":1.0},"59":{"tf":1.0},"63":{"tf":1.0},"67":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"21":{"tf":1.0},"23":{"tf":1.4142135623730951},"33":{"tf":1.7320508075688772}}}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"125":{"tf":1.4142135623730951},"22":{"tf":1.7320508075688772},"82":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"(":{"_":{"df":1,"docs":{"125":{"tf":1.0}}},"c":{"b":{"df":1,"docs":{"125":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"125":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"125":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":1.0}}}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"116":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"b":{"df":1,"docs":{"116":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"116":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":1.0}}}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"117":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":1,"docs":{"116":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":3,"docs":{"23":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"df":5,"docs":{"14":{"tf":1.0},"3":{"tf":1.0},"44":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"82":{"tf":1.0}}}}}}}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"22":{"tf":1.0},"25":{"tf":1.7320508075688772},"35":{"tf":1.0},"36":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"t":{"df":4,"docs":{"33":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0},"58":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":8,"docs":{"103":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"32":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"5":{"tf":1.0},"76":{"tf":2.0},"79":{"tf":1.0}}}}}}}}}},"x":{"df":6,"docs":{"103":{"tf":1.7320508075688772},"105":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":2.6457513110645907}}}},"df":3,"docs":{"54":{"tf":1.0},"69":{"tf":1.4142135623730951},"77":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"s":{"df":9,"docs":{"104":{"tf":1.4142135623730951},"112":{"tf":1.0},"134":{"tf":1.0},"135":{"tf":2.0},"57":{"tf":1.0},"60":{"tf":1.4142135623730951},"76":{"tf":1.0},"78":{"tf":3.4641016151377544},"79":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"4":{"tf":1.0}}},"v":{"df":2,"docs":{"134":{"tf":1.0},"81":{"tf":1.0}}}},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"91":{"tf":1.0}}},"df":0,"docs":{}}},"df":16,"docs":{"104":{"tf":1.0},"131":{"tf":1.0},"15":{"tf":1.0},"22":{"tf":1.7320508075688772},"23":{"tf":1.0},"3":{"tf":2.0},"37":{"tf":1.0},"41":{"tf":1.0},"5":{"tf":1.4142135623730951},"54":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.0},"74":{"tf":1.0},"82":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"104":{"tf":1.0},"63":{"tf":1.0},"87":{"tf":1.0}}}},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"56":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":3,"docs":{"22":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"5":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"v":{"df":6,"docs":{"46":{"tf":1.0},"56":{"tf":1.0},"61":{"tf":1.4142135623730951},"63":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":2.0}},"e":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"86":{"tf":1.0},"93":{"tf":1.0}}}}}},"0":{"df":2,"docs":{"87":{"tf":1.0},"89":{"tf":1.0}}},"df":0,"docs":{}},"d":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"67":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"104":{"tf":2.0},"105":{"tf":1.0},"22":{"tf":1.4142135623730951},"7":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"65":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"l":{"a":{"c":{"df":4,"docs":{"104":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0},"6":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"116":{"tf":1.0}}}}},"r":{"(":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"n":{"df":1,"docs":{"18":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"c":{"df":7,"docs":{"123":{"tf":1.7320508075688772},"131":{"tf":1.7320508075688772},"14":{"tf":2.6457513110645907},"16":{"tf":1.7320508075688772},"17":{"tf":1.4142135623730951},"18":{"tf":1.0},"52":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":1,"docs":{"16":{"tf":2.0}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"17":{"tf":1.4142135623730951},"18":{"tf":1.0}},"e":{"d":{"(":{"1":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}},")":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"d":{"(":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"52":{"tf":1.0},"7":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"15":{"tf":1.7320508075688772},"52":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"u":{"8":{"df":1,"docs":{"16":{"tf":1.0}}},"df":2,"docs":{"14":{"tf":1.4142135623730951},"16":{"tf":2.0}}}},"df":4,"docs":{"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":6,"docs":{"11":{"tf":1.0},"117":{"tf":1.0},"125":{"tf":1.4142135623730951},"131":{"tf":1.4142135623730951},"6":{"tf":1.0},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"123":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.0}}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"3":{"tf":1.0},"4":{"tf":1.0},"9":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"r":{"df":39,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"111":{"tf":1.4142135623730951},"113":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":1.4142135623730951},"121":{"tf":1.0},"125":{"tf":1.7320508075688772},"133":{"tf":1.0},"134":{"tf":1.4142135623730951},"17":{"tf":1.0},"19":{"tf":1.0},"22":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":2.449489742783178},"31":{"tf":1.0},"33":{"tf":2.0},"34":{"tf":1.0},"36":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.4142135623730951},"55":{"tf":1.0},"56":{"tf":1.4142135623730951},"64":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.4142135623730951},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":2.449489742783178},"73":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"66":{"tf":1.0}}}}},"i":{"d":{"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":3,"docs":{"110":{"tf":1.0},"3":{"tf":1.0},"46":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":6,"docs":{"112":{"tf":1.4142135623730951},"57":{"tf":2.6457513110645907},"60":{"tf":2.8284271247461903},"64":{"tf":1.0},"70":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":8,"docs":{"117":{"tf":1.0},"118":{"tf":1.0},"25":{"tf":1.0},"4":{"tf":1.0},"55":{"tf":1.0},"7":{"tf":1.0},"75":{"tf":1.0},"90":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":2,"docs":{"3":{"tf":1.0},"92":{"tf":1.0}}}}}},"t":{"df":5,"docs":{"3":{"tf":1.0},"33":{"tf":1.0},"5":{"tf":1.0},"56":{"tf":1.0},"6":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":9,"docs":{"21":{"tf":1.0},"28":{"tf":1.0},"32":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"46":{"tf":1.0},"52":{"tf":1.0},"60":{"tf":1.0},"77":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}},"u":{"3":{"2":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":19,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"110":{"tf":1.0},"111":{"tf":1.4142135623730951},"125":{"tf":1.0},"130":{"tf":1.4142135623730951},"22":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"43":{"tf":1.0},"64":{"tf":1.4142135623730951},"7":{"tf":1.0},"75":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"86":{"tf":1.4142135623730951},"87":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.4142135623730951}}}}}},"t":{"df":1,"docs":{"72":{"tf":1.0}},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":2,"docs":{"111":{"tf":1.4142135623730951},"55":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":21,"docs":{"103":{"tf":1.0},"104":{"tf":2.0},"105":{"tf":1.0},"11":{"tf":1.4142135623730951},"115":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"125":{"tf":1.0},"19":{"tf":1.0},"24":{"tf":2.6457513110645907},"27":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.0},"4":{"tf":1.0},"43":{"tf":2.23606797749979},"52":{"tf":1.4142135623730951},"61":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"68":{"tf":1.4142135623730951},"72":{"tf":2.23606797749979}}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"61":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":3,"docs":{"35":{"tf":1.0},"56":{"tf":1.4142135623730951},"87":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":2,"docs":{"48":{"tf":1.0},"76":{"tf":1.4142135623730951}}}}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.0},"2":{"tf":1.0},"31":{"tf":1.0}}}}}}},"f":{"c":{"df":7,"docs":{"12":{"tf":1.0},"131":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0}}},"df":0,"docs":{}},"i":{"d":{"df":1,"docs":{"61":{"tf":1.0}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"62":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":20,"docs":{"103":{"tf":1.0},"24":{"tf":1.0},"3":{"tf":1.0},"35":{"tf":1.4142135623730951},"38":{"tf":1.0},"4":{"tf":1.0},"43":{"tf":2.0},"44":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.0},"86":{"tf":1.0},"89":{"tf":1.0},"92":{"tf":1.0},"96":{"tf":1.0}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"24":{"tf":1.0}}}}}}}}},"i":{"d":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"3":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"3":{"tf":1.7320508075688772}}}}},"l":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"121":{"tf":2.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"121":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"b":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"119":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":1,"docs":{"119":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"o":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"14":{"tf":1.0}}}}}}}},"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"67":{"tf":1.0}}}},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"76":{"tf":1.0}}},"t":{"df":3,"docs":{"109":{"tf":1.0},"115":{"tf":1.0},"43":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"46":{"tf":1.0},"57":{"tf":1.0},"82":{"tf":1.0}}}}}}},"w":{"df":1,"docs":{"43":{"tf":1.0}}}},"t":{"df":1,"docs":{"134":{"tf":1.0}},"i":{"c":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":13,"docs":{"123":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.0},"29":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":2.23606797749979},"36":{"tf":1.0},"4":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.0}}}},"n":{"df":23,"docs":{"104":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"125":{"tf":1.0},"26":{"tf":1.7320508075688772},"31":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"52":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.7320508075688772},"67":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"91":{"tf":1.0},"92":{"tf":1.4142135623730951}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":8,"docs":{"110":{"tf":1.0},"129":{"tf":1.0},"48":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.4142135623730951},"64":{"tf":1.0},"82":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}}},"s":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{">":{":":{"2":{":":{"2":{"0":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"_":{"2":{"0":{"1":{"8":{"_":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{")":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"3":{"2":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"116":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"117":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":2,"docs":{"116":{"tf":1.0},"117":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"134":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"c":{"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"128":{"tf":2.0}}}}}}}}}}}},"df":0,"docs":{}}},"c":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"133":{"tf":1.0},"134":{"tf":1.0}}}}}}},"df":1,"docs":{"119":{"tf":1.0}}},"df":76,"docs":{"1":{"tf":2.8284271247461903},"10":{"tf":2.23606797749979},"107":{"tf":1.0},"109":{"tf":1.0},"11":{"tf":1.7320508075688772},"110":{"tf":1.0},"113":{"tf":1.4142135623730951},"114":{"tf":2.23606797749979},"115":{"tf":1.7320508075688772},"116":{"tf":2.23606797749979},"117":{"tf":2.449489742783178},"118":{"tf":2.6457513110645907},"119":{"tf":2.0},"12":{"tf":1.4142135623730951},"122":{"tf":1.7320508075688772},"123":{"tf":1.4142135623730951},"124":{"tf":1.4142135623730951},"125":{"tf":1.4142135623730951},"126":{"tf":2.23606797749979},"127":{"tf":2.0},"128":{"tf":1.0},"13":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"16":{"tf":1.7320508075688772},"17":{"tf":1.0},"19":{"tf":2.6457513110645907},"2":{"tf":4.47213595499958},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":2.0},"23":{"tf":2.8284271247461903},"25":{"tf":2.0},"26":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"3":{"tf":5.385164807134504},"32":{"tf":1.4142135623730951},"34":{"tf":1.7320508075688772},"4":{"tf":2.6457513110645907},"40":{"tf":1.4142135623730951},"41":{"tf":1.7320508075688772},"43":{"tf":1.4142135623730951},"44":{"tf":2.0},"45":{"tf":1.0},"5":{"tf":2.6457513110645907},"52":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"54":{"tf":2.23606797749979},"55":{"tf":2.0},"56":{"tf":2.6457513110645907},"57":{"tf":1.7320508075688772},"58":{"tf":2.449489742783178},"59":{"tf":2.449489742783178},"6":{"tf":1.4142135623730951},"60":{"tf":2.0},"64":{"tf":3.0},"65":{"tf":1.4142135623730951},"67":{"tf":1.7320508075688772},"68":{"tf":1.0},"69":{"tf":1.4142135623730951},"7":{"tf":2.8284271247461903},"70":{"tf":2.6457513110645907},"71":{"tf":1.0},"73":{"tf":1.4142135623730951},"76":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":2.0},"83":{"tf":1.0},"84":{"tf":1.0},"9":{"tf":1.4142135623730951},"90":{"tf":1.0},"96":{"tf":1.0}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"1":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":2.23606797749979}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"0":{"tf":1.0},"1":{"tf":1.7320508075688772},"33":{"tf":1.0},"6":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"134":{"tf":1.0}}}},"’":{"df":20,"docs":{"110":{"tf":1.0},"111":{"tf":1.4142135623730951},"112":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":1.0},"123":{"tf":1.0},"14":{"tf":1.0},"19":{"tf":1.4142135623730951},"21":{"tf":1.0},"25":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":1.0},"41":{"tf":1.4142135623730951},"58":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.7320508075688772},"7":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"82":{"tf":1.0}}}}}}},"s":{"a":{"d":{"df":1,"docs":{"56":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"2":{"tf":1.0},"67":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"f":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":40,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"104":{"tf":1.4142135623730951},"105":{"tf":1.0},"110":{"tf":1.7320508075688772},"111":{"tf":1.7320508075688772},"123":{"tf":1.4142135623730951},"126":{"tf":1.0},"129":{"tf":1.0},"14":{"tf":1.7320508075688772},"19":{"tf":1.4142135623730951},"2":{"tf":3.605551275463989},"22":{"tf":1.0},"3":{"tf":5.0},"4":{"tf":1.0},"43":{"tf":1.7320508075688772},"44":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":3.4641016151377544},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":2.0},"61":{"tf":2.0},"63":{"tf":1.0},"65":{"tf":2.449489742783178},"66":{"tf":1.0},"68":{"tf":1.7320508075688772},"7":{"tf":1.0},"70":{"tf":2.0},"71":{"tf":2.8284271247461903},"72":{"tf":1.7320508075688772},"79":{"tf":1.0},"90":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":20,"docs":{"1":{"tf":1.7320508075688772},"11":{"tf":1.4142135623730951},"111":{"tf":1.0},"112":{"tf":1.0},"131":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"3":{"tf":2.0},"30":{"tf":1.0},"48":{"tf":1.4142135623730951},"5":{"tf":2.0},"56":{"tf":1.0},"60":{"tf":1.0},"65":{"tf":2.6457513110645907},"67":{"tf":1.0},"68":{"tf":2.23606797749979},"70":{"tf":1.7320508075688772},"71":{"tf":1.4142135623730951},"72":{"tf":2.449489742783178},"89":{"tf":1.0},"93":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"21":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":32,"docs":{"118":{"tf":1.0},"119":{"tf":1.0},"123":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.7320508075688772},"16":{"tf":1.4142135623730951},"18":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.4142135623730951},"26":{"tf":1.0},"27":{"tf":1.0},"3":{"tf":2.0},"31":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":2.6457513110645907},"35":{"tf":1.0},"4":{"tf":1.4142135623730951},"43":{"tf":2.23606797749979},"5":{"tf":1.0},"52":{"tf":2.23606797749979},"55":{"tf":1.0},"56":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951},"72":{"tf":2.0},"74":{"tf":1.0},"75":{"tf":1.0},"78":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.7320508075688772},"89":{"tf":1.7320508075688772},"92":{"tf":1.4142135623730951},"96":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":7,"docs":{"31":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.4142135623730951},"45":{"tf":1.0},"52":{"tf":1.0},"7":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"34":{"tf":1.0}}}},"w":{"df":5,"docs":{"1":{"tf":1.0},"34":{"tf":1.0},"43":{"tf":1.0},"75":{"tf":1.0},"81":{"tf":1.0}}},"y":{"df":6,"docs":{"35":{"tf":1.0},"40":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"63":{"tf":1.4142135623730951},"72":{"tf":1.0}}}},"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"78":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"d":{"<":{"\'":{"a":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":18,"docs":{"1":{"tf":1.0},"19":{"tf":1.7320508075688772},"20":{"tf":1.4142135623730951},"23":{"tf":2.6457513110645907},"24":{"tf":2.0},"25":{"tf":1.0},"26":{"tf":1.7320508075688772},"28":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"5":{"tf":1.7320508075688772},"55":{"tf":2.23606797749979},"56":{"tf":1.0},"63":{"tf":1.7320508075688772},"72":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"63":{"tf":1.0}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"80":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"41":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"109":{"tf":1.7320508075688772}}}}}}},"df":6,"docs":{"19":{"tf":1.7320508075688772},"24":{"tf":2.8284271247461903},"29":{"tf":1.4142135623730951},"30":{"tf":1.0},"41":{"tf":3.7416573867739413},"87":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"=":{"<":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"109":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":6,"docs":{"119":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":1.4142135623730951},"34":{"tf":1.0},"43":{"tf":1.0},"96":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":22,"docs":{"102":{"tf":1.0},"103":{"tf":1.4142135623730951},"132":{"tf":1.0},"14":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"27":{"tf":1.0},"31":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":1.0},"45":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"6":{"tf":1.0},"63":{"tf":1.0},"70":{"tf":1.0},"78":{"tf":1.4142135623730951},"89":{"tf":1.0},"95":{"tf":1.4142135623730951},"99":{"tf":1.0}}}}}}},"df":1,"docs":{"41":{"tf":1.0}},"e":{"df":38,"docs":{"0":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"112":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.7320508075688772},"27":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.7320508075688772},"4":{"tf":1.0},"41":{"tf":1.0},"45":{"tf":1.4142135623730951},"46":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"52":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"81":{"tf":1.4142135623730951},"87":{"tf":1.0},"89":{"tf":1.0},"92":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.0}},"m":{"df":9,"docs":{"122":{"tf":1.0},"125":{"tf":1.0},"3":{"tf":1.0},"35":{"tf":1.0},"43":{"tf":1.0},"62":{"tf":1.4142135623730951},"7":{"tf":1.0},"82":{"tf":1.0},"89":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"82":{"tf":1.0}}}}}}}},"n":{"df":4,"docs":{"35":{"tf":1.0},"5":{"tf":1.0},"55":{"tf":1.0},"76":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"122":{"tf":1.0}}}},"df":0,"docs":{}},"f":{"(":{"a":{"df":0,"docs":{},"r":{"c":{":":{":":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"0":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"72":{"tf":1.0}}}}}},".":{"0":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"72":{"tf":1.0}}}}}},"df":0,"docs":{}}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{")":{".":{"a":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"(":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{")":{".":{"a":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"_":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"_":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"(":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":3,"docs":{"35":{"tf":1.0},"36":{"tf":1.7320508075688772},"43":{"tf":2.23606797749979}}},"1":{"df":2,"docs":{"35":{"tf":1.4142135623730951},"36":{"tf":1.7320508075688772}}},"2":{")":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"0":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"36":{"tf":1.0}}},"3":{"df":1,"docs":{"36":{"tf":1.0}}},"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{".":{"c":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"88":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"88":{"tf":1.0},"93":{"tf":1.4142135623730951}}}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"88":{"tf":1.0},"93":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"c":{"a":{"df":0,"docs":{},"p":{"df":10,"docs":{"5":{"tf":1.4142135623730951},"82":{"tf":2.23606797749979},"83":{"tf":1.0},"84":{"tf":1.4142135623730951},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":2.8284271247461903},"91":{"tf":2.449489742783178},"92":{"tf":1.0},"93":{"tf":2.8284271247461903}}}},"df":0,"docs":{}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"[":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"o":{"df":1,"docs":{"67":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":1,"docs":{"67":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"43":{"tf":1.7320508075688772}}}},"t":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"n":{"d":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"87":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}}}}}}}}},"df":4,"docs":{"87":{"tf":2.0},"89":{"tf":1.0},"92":{"tf":2.6457513110645907},"93":{"tf":2.449489742783178}}},"df":0,"docs":{}}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{")":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"31":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":3,"docs":{"83":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"89":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"89":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"89":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{".":{"a":{"df":0,"docs":{},"s":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"(":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"43":{"tf":1.0}},"e":{")":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"n":{"df":8,"docs":{"43":{"tf":1.0},"5":{"tf":1.4142135623730951},"83":{"tf":2.0},"85":{"tf":1.4142135623730951},"86":{"tf":2.6457513110645907},"88":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":3.7416573867739413}}}}},"m":{"df":0,"docs":{},"y":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"59":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"59":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"o":{"df":1,"docs":{"67":{"tf":1.7320508075688772}},"p":{"df":3,"docs":{"84":{"tf":1.0},"88":{"tf":1.0},"93":{"tf":1.0}}}},"t":{"df":0,"docs":{},"r":{"(":{")":{".":{"a":{"d":{"d":{"(":{"df":0,"docs":{},"i":{")":{".":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"x":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"93":{"tf":2.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},")":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{")":{".":{"a":{"d":{"d":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"86":{"tf":2.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":4,"docs":{"82":{"tf":1.0},"88":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":6,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"105":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"59":{"tf":1.7320508075688772}}}}}}},"df":7,"docs":{"103":{"tf":1.4142135623730951},"105":{"tf":1.0},"62":{"tf":1.0},"82":{"tf":1.0},"88":{"tf":1.4142135623730951},"91":{"tf":1.0},"93":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{".":{"a":{"df":0,"docs":{},"s":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"(":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"43":{"tf":1.0}},"e":{")":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"1":{"df":3,"docs":{"87":{"tf":1.0},"92":{"tf":1.4142135623730951},"93":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":4,"docs":{"87":{"tf":2.0},"89":{"tf":1.0},"92":{"tf":3.1622776601683795},"93":{"tf":2.6457513110645907}}}}},"df":0,"docs":{}}}},":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"72":{"tf":1.4142135623730951}}}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":32,"docs":{"103":{"tf":1.4142135623730951},"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"122":{"tf":1.0},"135":{"tf":1.4142135623730951},"26":{"tf":1.0},"27":{"tf":2.6457513110645907},"29":{"tf":2.6457513110645907},"3":{"tf":1.0},"31":{"tf":1.4142135623730951},"35":{"tf":1.7320508075688772},"36":{"tf":2.0},"41":{"tf":1.0},"43":{"tf":3.7416573867739413},"46":{"tf":2.8284271247461903},"5":{"tf":1.7320508075688772},"59":{"tf":3.3166247903554},"62":{"tf":1.7320508075688772},"66":{"tf":1.0},"67":{"tf":2.23606797749979},"72":{"tf":1.7320508075688772},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.4142135623730951},"87":{"tf":2.0},"88":{"tf":2.6457513110645907},"89":{"tf":3.3166247903554},"91":{"tf":1.7320508075688772},"92":{"tf":2.23606797749979},"93":{"tf":4.69041575982343}}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":19,"docs":{"1":{"tf":1.7320508075688772},"119":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"25":{"tf":1.4142135623730951},"27":{"tf":1.0},"43":{"tf":1.0},"47":{"tf":1.0},"55":{"tf":1.7320508075688772},"58":{"tf":1.7320508075688772},"59":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.4142135623730951},"89":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"135":{"tf":1.4142135623730951}}}}}}}},"n":{"d":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"81":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}},"df":16,"docs":{"102":{"tf":1.7320508075688772},"105":{"tf":1.7320508075688772},"131":{"tf":1.4142135623730951},"3":{"tf":2.6457513110645907},"41":{"tf":1.0},"42":{"tf":2.8284271247461903},"63":{"tf":1.7320508075688772},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":4.898979485566356},"72":{"tf":4.123105625617661},"81":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951},"99":{"tf":3.1622776601683795}}},"df":0,"docs":{},"s":{"df":9,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"3":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0}}},"t":{"df":2,"docs":{"116":{"tf":1.0},"72":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"82":{"tf":1.0}}}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":6,"docs":{"2":{"tf":1.0},"3":{"tf":1.7320508075688772},"35":{"tf":1.0},"43":{"tf":1.0},"67":{"tf":1.4142135623730951},"75":{"tf":1.0}}}},"df":0,"docs":{}},"q":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"76":{"tf":1.0},"77":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"76":{"tf":1.0},"77":{"tf":2.8284271247461903}}}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"56":{"tf":1.0}},"s":{"df":1,"docs":{"74":{"tf":1.0}}}}}},"v":{"df":1,"docs":{"6":{"tf":1.0}}}},"t":{"<":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}}}},"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":19,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"103":{"tf":1.0},"109":{"tf":1.0},"111":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.0},"22":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"34":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":1.7320508075688772},"76":{"tf":1.0},"78":{"tf":1.0},"85":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"(":{"df":0,"docs":{},"n":{"df":1,"docs":{"122":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"18":{"tf":1.0},"25":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"7":{"tf":1.4142135623730951},"73":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"df":0,"docs":{}},"<":{"\'":{"a":{">":{"(":{"&":{"\'":{"a":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":15,"docs":{"114":{"tf":1.0},"123":{"tf":1.0},"18":{"tf":1.0},"20":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"52":{"tf":1.0},"63":{"tf":1.0},"71":{"tf":1.7320508075688772},"72":{"tf":1.0},"75":{"tf":1.7320508075688772},"96":{"tf":2.23606797749979},"99":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"121":{"tf":1.0}}}},"n":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":3,"docs":{"17":{"tf":1.0},"3":{"tf":1.0},"86":{"tf":1.7320508075688772}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"33":{"tf":1.7320508075688772},"41":{"tf":1.0},"54":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}},"r":{"df":2,"docs":{"32":{"tf":1.0},"33":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"43":{"tf":1.0}}},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"n":{"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":4,"docs":{"27":{"tf":1.0},"34":{"tf":1.0},"5":{"tf":1.0},"59":{"tf":1.0}}}}}},"df":0,"docs":{}}},"w":{"df":3,"docs":{"111":{"tf":1.0},"117":{"tf":1.0},"40":{"tf":1.0}},"n":{"df":2,"docs":{"133":{"tf":1.0},"135":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":8,"docs":{"114":{"tf":1.4142135623730951},"115":{"tf":1.0},"125":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.0},"37":{"tf":1.0},"56":{"tf":1.4142135623730951},"84":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":10,"docs":{"110":{"tf":1.0},"111":{"tf":1.0},"135":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"27":{"tf":1.0},"29":{"tf":1.0},"34":{"tf":1.7320508075688772},"41":{"tf":1.0},"46":{"tf":1.4142135623730951}}}}}},"df":3,"docs":{"14":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"82":{"tf":1.0}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"5":{"tf":1.0},"82":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"82":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":5,"docs":{"111":{"tf":1.0},"16":{"tf":1.0},"34":{"tf":1.0},"5":{"tf":1.0},"72":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":9,"docs":{"3":{"tf":1.0},"34":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.4142135623730951},"7":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":20,"docs":{"101":{"tf":1.0},"103":{"tf":1.0},"131":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.4142135623730951},"22":{"tf":1.0},"23":{"tf":1.7320508075688772},"26":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"78":{"tf":1.4142135623730951},"82":{"tf":1.0},"84":{"tf":1.0},"98":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"22":{"tf":1.0},"95":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"131":{"tf":1.0},"96":{"tf":1.0}}}}},"i":{"df":10,"docs":{"101":{"tf":1.0},"135":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"48":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.4142135623730951},"9":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":4,"docs":{"60":{"tf":1.0},"62":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"l":{"df":2,"docs":{"39":{"tf":1.4142135623730951},"92":{"tf":1.0}},"t":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":11,"docs":{"1":{"tf":1.0},"15":{"tf":2.0},"21":{"tf":1.0},"3":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.4142135623730951},"74":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"82":{"tf":1.0},"9":{"tf":1.0}},"i":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"60":{"tf":1.0}},"u":{"a":{"df":0,"docs":{},"t":{"df":11,"docs":{"104":{"tf":1.0},"125":{"tf":1.0},"131":{"tf":1.0},"3":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"64":{"tf":1.0},"70":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}}},"z":{"df":0,"docs":{},"e":{"]":{">":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":4,"docs":{"87":{"tf":1.0},"89":{"tf":1.4142135623730951},"92":{"tf":1.0},"93":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"92":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"f":{":":{":":{"<":{"&":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"&":{"df":0,"docs":{},"u":{"1":{"6":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"&":{"df":0,"docs":{},"u":{"1":{"6":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"&":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"t":{"df":1,"docs":{"72":{"tf":1.0}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"72":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"u":{"df":1,"docs":{"52":{"tf":1.0}}}},"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{":":{":":{"<":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"12":{"tf":1.0}}}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":1,"docs":{"72":{"tf":1.0}}}},"t":{"df":3,"docs":{"110":{"tf":3.4641016151377544},"111":{"tf":4.898979485566356},"72":{"tf":1.7320508075688772}}}},"df":23,"docs":{"10":{"tf":3.1622776601683795},"111":{"tf":1.7320508075688772},"12":{"tf":1.0},"14":{"tf":2.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"3":{"tf":1.0},"4":{"tf":1.0},"46":{"tf":1.4142135623730951},"5":{"tf":1.0},"52":{"tf":1.4142135623730951},"56":{"tf":2.0},"7":{"tf":3.3166247903554},"72":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":2.6457513110645907},"85":{"tf":1.0},"9":{"tf":3.3166247903554},"90":{"tf":2.23606797749979},"91":{"tf":2.6457513110645907},"92":{"tf":2.0},"93":{"tf":1.4142135623730951}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":2,"docs":{"1":{"tf":1.0},"41":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"92":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"58":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"e":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{")":{".":{"a":{"d":{"d":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"89":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"89":{"tf":1.4142135623730951},"92":{"tf":1.7320508075688772},"93":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"43":{"tf":1.0},"89":{"tf":1.0},"92":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"1":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"85":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"w":{"df":1,"docs":{"111":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":13,"docs":{"10":{"tf":1.0},"3":{"tf":1.7320508075688772},"4":{"tf":1.7320508075688772},"43":{"tf":3.3166247903554},"5":{"tf":1.4142135623730951},"50":{"tf":1.7320508075688772},"66":{"tf":1.0},"85":{"tf":2.23606797749979},"86":{"tf":1.0},"87":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.7320508075688772},"91":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"95":{"tf":1.0}}}}}}},"p":{"df":1,"docs":{"82":{"tf":1.0}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"3":{"tf":1.0}}}}},"w":{"df":1,"docs":{"75":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"77":{"tf":1.0}}}}}}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"41":{"tf":1.0},"75":{"tf":1.0}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":2,"docs":{"34":{"tf":1.7320508075688772},"68":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":4,"docs":{"107":{"tf":1.7320508075688772},"109":{"tf":1.4142135623730951},"110":{"tf":2.23606797749979},"111":{"tf":1.0}}},"y":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"(":{"a":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"110":{"tf":1.0},"111":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":1,"docs":{"111":{"tf":1.4142135623730951}}}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"111":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"m":{"a":{"df":0,"docs":{},"x":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"(":{"1":{"0":{"0":{"df":1,"docs":{"110":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"110":{"tf":1.4142135623730951},"111":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"r":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"111":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"111":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"110":{"tf":1.0},"111":{"tf":1.4142135623730951}}}}}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":1,"docs":{"111":{"tf":1.0}},"e":{"d":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"110":{"tf":1.0},"111":{"tf":1.4142135623730951}}}}}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":1,"docs":{"111":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"d":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"_":{"df":1,"docs":{"111":{"tf":1.0}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"110":{"tf":1.0},"111":{"tf":1.0}}}}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"111":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"100":{"tf":1.0},"26":{"tf":1.0},"41":{"tf":1.4142135623730951}}}}}}}},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"19":{"tf":1.0},"59":{"tf":1.0},"92":{"tf":1.0}}}},"v":{"df":8,"docs":{"131":{"tf":1.0},"134":{"tf":1.0},"19":{"tf":1.0},"26":{"tf":1.0},"44":{"tf":1.0},"60":{"tf":1.4142135623730951},"62":{"tf":1.0},"85":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"*":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"d":{"(":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"_":{"df":3,"docs":{"84":{"tf":1.0},"88":{"tf":1.0},"93":{"tf":1.0}}},"d":{"df":1,"docs":{"111":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"111":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}},"f":{"df":1,"docs":{"125":{"tf":1.0}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"&":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"d":{".":{"d":{"a":{"df":0,"docs":{},"y":{"df":2,"docs":{"35":{"tf":2.23606797749979},"36":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"87":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}}}}},"p":{"df":4,"docs":{"82":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0}},"t":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{":":{":":{"<":{"df":0,"docs":{},"t":{">":{":":{":":{"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{")":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"92":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"o":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"92":{"tf":1.0},"93":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"87":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{")":{".":{"a":{"d":{"d":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{")":{".":{"a":{"d":{"d":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"83":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"87":{"tf":1.0},"92":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":5,"docs":{"39":{"tf":1.0},"41":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"78":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"103":{"tf":1.0},"3":{"tf":1.0},"61":{"tf":1.0},"82":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":24,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"121":{"tf":1.0},"131":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":1.0},"5":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":2.23606797749979},"67":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":2.23606797749979},"74":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0},"92":{"tf":1.0},"94":{"tf":1.0},"96":{"tf":1.0}}},"i":{"df":0,"docs":{},"m":{"df":6,"docs":{"119":{"tf":1.0},"131":{"tf":1.0},"2":{"tf":1.4142135623730951},"26":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"24":{"tf":1.7320508075688772},"3":{"tf":1.0},"44":{"tf":1.0},"58":{"tf":1.0},"75":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"_":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":4,"docs":{"101":{"tf":1.0},"19":{"tf":1.0},"34":{"tf":1.4142135623730951},"60":{"tf":1.0}}}},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"54":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"t":{"df":5,"docs":{"3":{"tf":1.4142135623730951},"60":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0},"85":{"tf":1.7320508075688772}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":10,"docs":{"19":{"tf":1.0},"22":{"tf":1.4142135623730951},"24":{"tf":1.0},"3":{"tf":1.0},"35":{"tf":2.23606797749979},"36":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":1.0},"5":{"tf":1.7320508075688772},"72":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"14":{"tf":1.0},"35":{"tf":1.0}}}}},"df":0,"docs":{}},"r":{"c":{"df":4,"docs":{"126":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"86":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":10,"docs":{"10":{"tf":2.0},"118":{"tf":1.0},"125":{"tf":1.0},"14":{"tf":1.0},"2":{"tf":1.0},"39":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.4142135623730951},"75":{"tf":1.0},"82":{"tf":2.23606797749979}}}},"df":0,"docs":{},"n":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"64":{"tf":1.0},"65":{"tf":1.0}}}}}}}},"w":{"df":0,"docs":{},"n":{"df":4,"docs":{"118":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"70":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":4,"docs":{"11":{"tf":1.0},"34":{"tf":1.0},"57":{"tf":1.0},"71":{"tf":1.0}}}},"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":17,"docs":{"117":{"tf":1.0},"118":{"tf":1.0},"125":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":1.7320508075688772},"52":{"tf":1.0},"58":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":1.0},"66":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":1.0},"75":{"tf":1.0},"82":{"tf":1.7320508075688772}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"u":{"8":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"71":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"f":{"df":9,"docs":{"11":{"tf":1.0},"22":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"7":{"tf":1.0},"73":{"tf":1.0},"82":{"tf":1.7320508075688772}},"i":{"df":19,"docs":{"10":{"tf":1.0},"109":{"tf":1.0},"11":{"tf":1.0},"110":{"tf":1.0},"115":{"tf":1.0},"124":{"tf":1.0},"126":{"tf":1.0},"13":{"tf":1.0},"133":{"tf":1.0},"16":{"tf":1.4142135623730951},"20":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.0},"64":{"tf":1.0},"7":{"tf":2.0},"76":{"tf":1.0},"88":{"tf":1.0},"9":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"90":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}},"n":{"d":{"df":2,"docs":{"25":{"tf":1.0},"56":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"64":{"tf":1.0}},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"71":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"3":{"tf":1.0},"43":{"tf":1.4142135623730951}}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"125":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"c":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"111":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"111":{"tf":1.7320508075688772}}}}}},"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"4":{":":{"1":{"8":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"1":{"0":{":":{"1":{"6":{"df":1,"docs":{"32":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{":":{"1":{"3":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}},"5":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{":":{"3":{"8":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"7":{":":{"4":{"df":1,"docs":{"135":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{":":{"2":{"8":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"9":{"df":1,"docs":{"45":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":2,"docs":{"56":{"tf":1.0},"86":{"tf":1.0}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"111":{"tf":2.23606797749979}}}}}},"df":0,"docs":{}},"t":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"15":{"tf":1.0},"3":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.0}}}},"l":{"df":10,"docs":{"131":{"tf":1.0},"16":{"tf":1.0},"4":{"tf":1.0},"43":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"64":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}}},"c":{"df":0,"docs":{},"k":{"df":12,"docs":{"127":{"tf":1.0},"24":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"72":{"tf":1.4142135623730951},"82":{"tf":1.0},"85":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"60":{"tf":1.0},"62":{"tf":1.0}}},"d":{"a":{"df":0,"docs":{},"r":{"d":{"df":24,"docs":{"1":{"tf":1.4142135623730951},"103":{"tf":1.0},"104":{"tf":1.0},"123":{"tf":1.0},"134":{"tf":1.0},"135":{"tf":1.0},"14":{"tf":1.0},"2":{"tf":1.7320508075688772},"3":{"tf":1.7320508075688772},"34":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":2.23606797749979},"56":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"94":{"tf":1.0},"95":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":1,"docs":{"64":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":23,"docs":{"102":{"tf":1.0},"105":{"tf":1.0},"11":{"tf":1.0},"134":{"tf":1.0},"2":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"26":{"tf":1.0},"32":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"67":{"tf":1.0},"72":{"tf":1.0},"77":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"87":{"tf":1.7320508075688772},"88":{"tf":1.4142135623730951},"89":{"tf":1.7320508075688772},"92":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951},"96":{"tf":1.0},"98":{"tf":1.0}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"55":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"<":{"\'":{"a":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":18,"docs":{"116":{"tf":1.0},"121":{"tf":1.7320508075688772},"5":{"tf":2.23606797749979},"52":{"tf":1.0},"53":{"tf":1.4142135623730951},"55":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":2.0},"64":{"tf":1.4142135623730951},"65":{"tf":2.6457513110645907},"67":{"tf":1.4142135623730951},"68":{"tf":1.7320508075688772},"71":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.7320508075688772},"91":{"tf":1.0},"96":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"23":{"tf":1.0},"35":{"tf":1.0},"41":{"tf":1.0},"74":{"tf":1.0}}}}}}},"i":{"c":{"df":22,"docs":{"10":{"tf":1.0},"109":{"tf":1.0},"11":{"tf":1.0},"119":{"tf":2.8284271247461903},"121":{"tf":2.23606797749979},"23":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":2.0},"32":{"tf":1.7320508075688772},"33":{"tf":2.449489742783178},"34":{"tf":4.69041575982343},"35":{"tf":1.7320508075688772},"36":{"tf":1.7320508075688772},"39":{"tf":1.0},"4":{"tf":1.0},"48":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":2.0},"58":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.7320508075688772}},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"34":{"tf":1.4142135623730951}},"s":{".":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"v":{"df":1,"docs":{"34":{"tf":1.0}}}}},"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"v":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"y":{"df":2,"docs":{"77":{"tf":1.0},"78":{"tf":1.4142135623730951}}}},"d":{":":{":":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{":":{":":{"d":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"92":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"b":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{":":{":":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{":":{":":{"<":{"df":0,"docs":{},"t":{">":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"c":{"a":{"df":0,"docs":{},"p":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"92":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"{":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"59":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"82":{"tf":1.0},"93":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{":":{":":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"p":{":":{":":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"3":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"c":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{":":{":":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"121":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"123":{"tf":1.0}}}},"m":{"df":0,"docs":{},"t":{":":{":":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{">":{"(":{"a":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"36":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{":":{":":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":4,"docs":{"105":{"tf":1.0},"89":{"tf":1.4142135623730951},"93":{"tf":1.0},"96":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":2,"docs":{"39":{"tf":1.0},"40":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{":":{":":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"92":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"16":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"{":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"56":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":5,"docs":{"43":{"tf":1.0},"59":{"tf":1.7320508075688772},"80":{"tf":1.0},"82":{"tf":1.0},"93":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{":":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":4,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"105":{"tf":1.0},"85":{"tf":1.0}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"85":{"tf":1.0}}}}}}}}}},"df":0,"docs":{},"{":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":2,"docs":{"72":{"tf":1.0},"93":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{":":{":":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{":":{":":{"c":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"72":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"{":{"c":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{":":{":":{"c":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"130":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{":":{":":{"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"103":{"tf":1.4142135623730951},"105":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":3,"docs":{"105":{"tf":1.0},"81":{"tf":1.0},"96":{"tf":1.0}}}}}}}},"{":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":1,"docs":{"59":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"93":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":3,"docs":{"121":{"tf":1.0},"5":{"tf":1.0},"80":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"85":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"93":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"85":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"93":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"n":{"c":{":":{":":{"a":{"df":0,"docs":{},"r":{"c":{"df":4,"docs":{"46":{"tf":1.0},"70":{"tf":1.4142135623730951},"78":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"104":{"tf":1.0},"96":{"tf":1.0}},"i":{"c":{":":{":":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"96":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"103":{"tf":1.4142135623730951},"104":{"tf":1.0}}},"df":0,"docs":{}}},"{":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"c":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"105":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"c":{"df":1,"docs":{"118":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":2,"docs":{"70":{"tf":1.4142135623730951},"78":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"c":{":":{":":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"81":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"80":{"tf":1.0}}},"df":0,"docs":{}}},"{":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"122":{"tf":1.7320508075688772}}}}},"df":1,"docs":{"109":{"tf":1.4142135623730951}}},"df":7,"docs":{"109":{"tf":1.0},"132":{"tf":1.4142135623730951},"133":{"tf":1.0},"134":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"72":{"tf":1.0},"82":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"135":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":5,"docs":{"133":{"tf":1.0},"2":{"tf":1.0},"46":{"tf":1.4142135623730951},"56":{"tf":1.0},"61":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":29,"docs":{"11":{"tf":1.4142135623730951},"126":{"tf":1.0},"14":{"tf":1.7320508075688772},"16":{"tf":2.0},"19":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.4142135623730951},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":2.23606797749979},"40":{"tf":1.4142135623730951},"41":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.4142135623730951},"68":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":1.4142135623730951},"82":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"127":{"tf":1.0},"129":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"19":{"tf":1.0},"61":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}},"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"(":{"&":{"\'":{"a":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"(":{"&":{"\'":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":15,"docs":{"10":{"tf":2.23606797749979},"103":{"tf":1.0},"111":{"tf":1.0},"17":{"tf":1.0},"34":{"tf":2.0},"56":{"tf":1.0},"59":{"tf":1.0},"63":{"tf":1.4142135623730951},"67":{"tf":1.0},"7":{"tf":2.449489742783178},"70":{"tf":1.0},"72":{"tf":1.4142135623730951},"89":{"tf":1.0},"9":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951}}},"i":{"df":5,"docs":{"19":{"tf":1.0},"55":{"tf":1.0},"64":{"tf":1.0},"71":{"tf":1.0},"82":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":4,"docs":{"1":{"tf":1.0},"3":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":2,"docs":{"13":{"tf":1.0},"64":{"tf":1.0}}}}}}},"df":16,"docs":{"123":{"tf":1.0},"135":{"tf":1.0},"19":{"tf":1.0},"24":{"tf":2.6457513110645907},"29":{"tf":3.872983346207417},"30":{"tf":1.7320508075688772},"32":{"tf":2.23606797749979},"33":{"tf":3.0},"34":{"tf":5.477225575051661},"35":{"tf":1.4142135623730951},"36":{"tf":1.7320508075688772},"4":{"tf":1.0},"41":{"tf":2.8284271247461903},"81":{"tf":1.4142135623730951},"9":{"tf":1.0},"96":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"104":{"tf":1.0}}}}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"34":{"tf":1.0},"76":{"tf":1.0},"81":{"tf":1.4142135623730951},"96":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"11":{"tf":1.0},"35":{"tf":2.0},"71":{"tf":1.0},"75":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"\\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"d":{"df":3,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":10,"docs":{"123":{"tf":1.7320508075688772},"126":{"tf":1.7320508075688772},"19":{"tf":1.0},"24":{"tf":1.7320508075688772},"30":{"tf":1.0},"34":{"tf":1.4142135623730951},"36":{"tf":1.0},"4":{"tf":1.4142135623730951},"41":{"tf":1.7320508075688772},"7":{"tf":1.0}}}},"p":{"df":4,"docs":{"17":{"tf":1.0},"84":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"75":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"75":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":6,"docs":{"14":{"tf":1.0},"17":{"tf":1.0},"75":{"tf":1.7320508075688772},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0}}}}}}},"u":{"c":{"df":0,"docs":{},"t":{"/":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"4":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"15":{"tf":1.7320508075688772}}}}}}},"<":{"&":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":39,"docs":{"10":{"tf":1.4142135623730951},"105":{"tf":1.4142135623730951},"117":{"tf":1.0},"123":{"tf":1.4142135623730951},"131":{"tf":3.0},"135":{"tf":1.0},"14":{"tf":1.7320508075688772},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"31":{"tf":1.7320508075688772},"32":{"tf":1.0},"34":{"tf":1.7320508075688772},"35":{"tf":3.1622776601683795},"36":{"tf":2.23606797749979},"37":{"tf":1.0},"39":{"tf":2.0},"40":{"tf":1.7320508075688772},"41":{"tf":1.7320508075688772},"43":{"tf":3.605551275463989},"44":{"tf":1.4142135623730951},"46":{"tf":1.0},"5":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"59":{"tf":2.8284271247461903},"62":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"7":{"tf":3.872983346207417},"71":{"tf":1.4142135623730951},"72":{"tf":2.449489742783178},"81":{"tf":1.7320508075688772},"87":{"tf":1.4142135623730951},"88":{"tf":1.7320508075688772},"89":{"tf":2.23606797749979},"9":{"tf":1.7320508075688772},"93":{"tf":2.23606797749979},"96":{"tf":2.0}},"u":{"df":0,"docs":{},"r":{"df":6,"docs":{"118":{"tf":1.0},"131":{"tf":1.4142135623730951},"43":{"tf":1.0},"7":{"tf":1.0},"89":{"tf":1.0},"96":{"tf":1.7320508075688772}}}},"’":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}}},"u":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"12":{"tf":1.0},"61":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":5,"docs":{"33":{"tf":1.0},"34":{"tf":1.0},"43":{"tf":1.0},"58":{"tf":1.0},"82":{"tf":1.0}}}},"m":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":3,"docs":{"56":{"tf":1.0},"64":{"tf":1.0},"90":{"tf":1.0}}}}}},"u":{"b":{"df":2,"docs":{"33":{"tf":2.0},"34":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"43":{"tf":1.0},"55":{"tf":1.0}}},"df":0,"docs":{}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"122":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"61":{"tf":1.0},"89":{"tf":1.0}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":3,"docs":{"119":{"tf":1.0},"25":{"tf":1.0},"78":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"df":0,"docs":{},"r":{"(":{"df":1,"docs":{"29":{"tf":1.0}}},"<":{"\'":{"a":{">":{"(":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"l":{"df":11,"docs":{"11":{"tf":1.0},"25":{"tf":1.0},"33":{"tf":1.0},"37":{"tf":1.0},"43":{"tf":1.4142135623730951},"46":{"tf":1.0},"48":{"tf":1.0},"56":{"tf":1.0},"62":{"tf":1.0},"66":{"tf":1.0},"82":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"26":{"tf":1.0},"35":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"p":{"df":4,"docs":{"1":{"tf":1.0},"32":{"tf":1.7320508075688772},"33":{"tf":2.6457513110645907},"34":{"tf":4.242640687119285}}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"27":{"tf":1.0},"48":{"tf":1.0}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"78":{"tf":1.0},"82":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{},"h":{"df":32,"docs":{"11":{"tf":1.0},"135":{"tf":1.0},"14":{"tf":1.4142135623730951},"16":{"tf":1.0},"19":{"tf":1.0},"22":{"tf":1.4142135623730951},"3":{"tf":1.0},"30":{"tf":1.7320508075688772},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":2.449489742783178},"39":{"tf":1.0},"4":{"tf":2.0},"41":{"tf":1.7320508075688772},"44":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":1.4142135623730951},"52":{"tf":1.0},"55":{"tf":1.0},"59":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":2.0},"7":{"tf":2.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.0},"72":{"tf":1.0},"82":{"tf":2.0},"9":{"tf":1.0},"91":{"tf":1.0}}}},"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"72":{"tf":1.0}},"i":{"df":6,"docs":{"19":{"tf":1.0},"35":{"tf":1.0},"43":{"tf":1.0},"56":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0}}}},"df":0,"docs":{},"x":{"df":1,"docs":{"126":{"tf":1.0}}}}}},"g":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"23":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"46":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"10":{"tf":1.0},"134":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"78":{"tf":1.0}}}},"m":{"df":1,"docs":{"7":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"31":{"tf":1.0}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":2.0}}}},"df":0,"docs":{},"’":{"df":1,"docs":{"59":{"tf":1.0}}}}}},"df":5,"docs":{"111":{"tf":1.0},"33":{"tf":1.7320508075688772},"34":{"tf":1.4142135623730951},"82":{"tf":1.0},"93":{"tf":1.0}},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"40":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"47":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":10,"docs":{"10":{"tf":1.0},"122":{"tf":1.0},"4":{"tf":1.0},"61":{"tf":1.0},"82":{"tf":1.4142135623730951},"85":{"tf":1.0},"88":{"tf":1.0},"9":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951},"95":{"tf":1.0}}}},"s":{"df":6,"docs":{"11":{"tf":1.0},"125":{"tf":1.0},"31":{"tf":1.0},"35":{"tf":1.0},"46":{"tf":1.0},"53":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"16":{"tf":1.0},"59":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":9,"docs":{"18":{"tf":1.0},"34":{"tf":1.0},"46":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"87":{"tf":1.0}}},"f":{"a":{"c":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":3,"docs":{"34":{"tf":1.0},"52":{"tf":1.0},"60":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"43":{"tf":1.0}}}}}}}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"25":{"tf":1.0}}}}}}},"w":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"135":{"tf":1.0},"67":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"85":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"118":{"tf":1.0}}}},"df":0,"docs":{}}}},"y":{"df":1,"docs":{"69":{"tf":1.0}},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":3,"docs":{"110":{"tf":1.0},"114":{"tf":1.0},"134":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"n":{"c":{"df":17,"docs":{"1":{"tf":1.0},"102":{"tf":1.7320508075688772},"105":{"tf":1.7320508075688772},"131":{"tf":1.4142135623730951},"3":{"tf":2.23606797749979},"41":{"tf":1.0},"42":{"tf":3.0},"56":{"tf":1.0},"63":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":4.898979485566356},"72":{"tf":3.7416573867739413},"81":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951},"99":{"tf":2.8284271247461903}},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":10,"docs":{"103":{"tf":1.7320508075688772},"104":{"tf":1.4142135623730951},"105":{"tf":1.0},"118":{"tf":1.4142135623730951},"63":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"76":{"tf":1.7320508075688772},"79":{"tf":1.0},"96":{"tf":1.0}}}}}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":5,"docs":{"1":{"tf":1.4142135623730951},"23":{"tf":1.0},"31":{"tf":1.0},"46":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"23":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"133":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":17,"docs":{"1":{"tf":1.0},"119":{"tf":1.4142135623730951},"122":{"tf":2.0},"134":{"tf":1.0},"19":{"tf":1.4142135623730951},"2":{"tf":2.0},"25":{"tf":1.0},"27":{"tf":1.4142135623730951},"35":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":1.4142135623730951},"52":{"tf":1.0},"57":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.4142135623730951},"70":{"tf":1.0},"82":{"tf":1.0}},"’":{"df":1,"docs":{"82":{"tf":1.0}}}}}},"v":{"6":{"4":{"df":1,"docs":{"122":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{")":{".":{"c":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"(":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"46":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"<":{"\'":{"a":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},">":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"(":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"b":{"df":1,"docs":{"3":{"tf":1.0}},"l":{"df":2,"docs":{"34":{"tf":1.0},"42":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":3,"docs":{"16":{"tf":1.0},"23":{"tf":1.0},"7":{"tf":2.449489742783178}}},"k":{"df":0,"docs":{},"e":{"df":26,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"104":{"tf":1.0},"110":{"tf":1.0},"125":{"tf":1.0},"17":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.4142135623730951},"30":{"tf":1.0},"34":{"tf":1.4142135623730951},"40":{"tf":1.0},"43":{"tf":1.4142135623730951},"52":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"67":{"tf":1.0},"72":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951},"89":{"tf":1.0},"95":{"tf":1.0}},"n":{"df":4,"docs":{"2":{"tf":1.0},"3":{"tf":1.0},"54":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"k":{"df":10,"docs":{"11":{"tf":1.0},"2":{"tf":1.0},"23":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.0},"5":{"tf":1.0},"58":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.0}}},"l":{"df":1,"docs":{"24":{"tf":1.0}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{")":{".":{"a":{"df":1,"docs":{"117":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"122":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":17,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"105":{"tf":1.0},"117":{"tf":1.4142135623730951},"118":{"tf":1.0},"119":{"tf":1.7320508075688772},"133":{"tf":1.4142135623730951},"134":{"tf":1.7320508075688772},"14":{"tf":1.0},"4":{"tf":1.0},"7":{"tf":1.0},"72":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"85":{"tf":1.0},"86":{"tf":1.0},"93":{"tf":1.0}},"’":{"df":1,"docs":{"122":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"64":{"tf":2.449489742783178}},"’":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"df":44,"docs":{"100":{"tf":1.0},"101":{"tf":1.4142135623730951},"102":{"tf":1.7320508075688772},"104":{"tf":1.0},"105":{"tf":2.0},"11":{"tf":1.0},"125":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"29":{"tf":2.8284271247461903},"30":{"tf":1.4142135623730951},"34":{"tf":6.0},"36":{"tf":3.0},"39":{"tf":3.0},"40":{"tf":2.8284271247461903},"41":{"tf":3.7416573867739413},"42":{"tf":3.1622776601683795},"43":{"tf":5.5677643628300215},"45":{"tf":2.449489742783178},"46":{"tf":5.0990195135927845},"5":{"tf":1.4142135623730951},"52":{"tf":2.0},"56":{"tf":2.23606797749979},"62":{"tf":1.4142135623730951},"66":{"tf":1.0},"67":{"tf":3.0},"7":{"tf":1.7320508075688772},"71":{"tf":1.4142135623730951},"72":{"tf":3.3166247903554},"81":{"tf":2.6457513110645907},"82":{"tf":1.4142135623730951},"83":{"tf":2.0},"84":{"tf":1.4142135623730951},"85":{"tf":1.7320508075688772},"86":{"tf":1.4142135623730951},"87":{"tf":2.0},"88":{"tf":2.23606797749979},"89":{"tf":4.358898943540674},"9":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951},"92":{"tf":1.4142135623730951},"93":{"tf":4.795831523312719},"96":{"tf":2.449489742783178},"98":{"tf":1.0},"99":{"tf":1.0}},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"2":{"tf":1.0},"43":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":1,"docs":{"14":{"tf":1.0}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":3,"docs":{"26":{"tf":1.0},"82":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":2,"docs":{"1":{"tf":1.0},"70":{"tf":1.0}}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":11,"docs":{"1":{"tf":1.4142135623730951},"115":{"tf":1.0},"122":{"tf":1.0},"21":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"59":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.4142135623730951},"82":{"tf":1.0},"96":{"tf":1.0}}}},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"22":{"tf":2.23606797749979}},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"23":{"tf":1.0},"25":{"tf":1.0},"66":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"27":{"tf":1.0},"65":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"n":{"d":{"df":3,"docs":{"2":{"tf":1.0},"22":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"16":{"tf":1.0},"73":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"123":{"tf":1.4142135623730951},"60":{"tf":1.0},"63":{"tf":1.4142135623730951},"67":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"48":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"_":{"d":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"93":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"z":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"df":3,"docs":{"111":{"tf":2.23606797749979},"75":{"tf":1.0},"93":{"tf":1.4142135623730951}},"s":{":":{":":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"d":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"93":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"z":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":4,"docs":{"23":{"tf":1.0},"82":{"tf":1.0},"87":{"tf":1.0},"93":{"tf":1.0}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"90":{"tf":1.0}}}}}}}}},"t":{"\'":{"df":2,"docs":{"23":{"tf":1.0},"89":{"tf":1.0}}},"df":0,"docs":{},"’":{"df":26,"docs":{"115":{"tf":1.0},"123":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"3":{"tf":1.4142135623730951},"34":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.7320508075688772},"40":{"tf":1.0},"41":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"67":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.0},"85":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":4,"docs":{"56":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":4,"docs":{"3":{"tf":1.0},"55":{"tf":1.0},"60":{"tf":1.0},"82":{"tf":1.4142135623730951}}}},"i":{"df":3,"docs":{"82":{"tf":1.0},"84":{"tf":1.0},"94":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"\'":{"df":2,"docs":{"26":{"tf":1.0},"70":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":19,"docs":{"14":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"34":{"tf":1.7320508075688772},"35":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.4142135623730951},"59":{"tf":1.0},"65":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0},"91":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"f":{"df":1,"docs":{"42":{"tf":1.0}}}},"’":{"df":14,"docs":{"10":{"tf":1.0},"15":{"tf":1.0},"3":{"tf":1.4142135623730951},"34":{"tf":1.0},"5":{"tf":1.0},"59":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"75":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.7320508075688772},"85":{"tf":1.0},"87":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"’":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"’":{"df":0,"docs":{},"r":{"df":8,"docs":{"3":{"tf":1.0},"48":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.4142135623730951},"78":{"tf":1.0}}},"v":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"10":{"tf":1.0},"30":{"tf":1.0}},"g":{"df":33,"docs":{"108":{"tf":1.0},"113":{"tf":1.0},"118":{"tf":1.0},"12":{"tf":1.0},"131":{"tf":1.0},"19":{"tf":1.7320508075688772},"2":{"tf":1.7320508075688772},"21":{"tf":1.4142135623730951},"22":{"tf":2.23606797749979},"23":{"tf":1.0},"24":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":1.4142135623730951},"38":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":2.449489742783178},"40":{"tf":1.0},"43":{"tf":1.4142135623730951},"48":{"tf":1.0},"52":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":2.0},"89":{"tf":1.0},"90":{"tf":1.4142135623730951},"92":{"tf":1.0},"93":{"tf":1.0}}},"k":{"df":5,"docs":{"52":{"tf":1.0},"63":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"96":{"tf":1.0}}}},"r":{"d":{"df":1,"docs":{"75":{"tf":1.0}}},"df":0,"docs":{}},"s":{"\'":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"122":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":19,"docs":{"1":{"tf":1.7320508075688772},"130":{"tf":1.0},"134":{"tf":1.0},"14":{"tf":1.0},"2":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"3":{"tf":1.7320508075688772},"31":{"tf":1.0},"4":{"tf":1.0},"44":{"tf":1.4142135623730951},"52":{"tf":1.0},"54":{"tf":1.0},"60":{"tf":1.0},"69":{"tf":1.0},"82":{"tf":1.4142135623730951},"85":{"tf":1.0},"86":{"tf":1.0},"99":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":18,"docs":{"14":{"tf":1.4142135623730951},"24":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"52":{"tf":1.4142135623730951},"56":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":1.0},"91":{"tf":1.0}},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"\'":{"df":1,"docs":{"63":{"tf":1.0}}},":":{":":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"63":{"tf":1.4142135623730951}},"e":{"d":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"63":{"tf":1.0}}}}}},":":{":":{"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"60":{"tf":1.0},"63":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}}}}},"df":1,"docs":{"70":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}},"df":25,"docs":{"103":{"tf":1.4142135623730951},"104":{"tf":2.0},"110":{"tf":1.0},"118":{"tf":2.23606797749979},"135":{"tf":1.0},"21":{"tf":1.0},"3":{"tf":2.0},"34":{"tf":1.0},"4":{"tf":1.0},"57":{"tf":1.0},"63":{"tf":3.605551275463989},"64":{"tf":2.449489742783178},"68":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"70":{"tf":2.449489742783178},"71":{"tf":3.1622776601683795},"72":{"tf":2.449489742783178},"74":{"tf":1.4142135623730951},"75":{"tf":3.0},"76":{"tf":2.23606797749979},"77":{"tf":1.4142135623730951},"78":{"tf":2.0},"79":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":2.23606797749979}},"’":{"df":1,"docs":{"77":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":6,"docs":{"119":{"tf":1.0},"2":{"tf":1.0},"34":{"tf":1.0},"56":{"tf":1.4142135623730951},"60":{"tf":1.0},"81":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":22,"docs":{"10":{"tf":1.0},"104":{"tf":1.4142135623730951},"116":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.0},"3":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.7320508075688772},"43":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"33":{"tf":1.4142135623730951},"7":{"tf":1.0},"82":{"tf":1.0}}}}}}}},"w":{"df":2,"docs":{"128":{"tf":2.0},"82":{"tf":1.0}},"n":{"df":1,"docs":{"128":{"tf":1.0}}}}}},"u":{"df":6,"docs":{"103":{"tf":1.7320508075688772},"40":{"tf":1.4142135623730951},"41":{"tf":1.7320508075688772},"52":{"tf":1.0},"56":{"tf":1.4142135623730951},"99":{"tf":1.0}}}},"i":{"df":1,"docs":{"26":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"64":{"tf":1.0}}}},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"65":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"e":{"df":22,"docs":{"100":{"tf":1.0},"16":{"tf":1.0},"26":{"tf":1.4142135623730951},"28":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"4":{"tf":1.4142135623730951},"41":{"tf":1.0},"43":{"tf":1.4142135623730951},"46":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":1.0},"64":{"tf":1.0},"67":{"tf":1.0},"8":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}}}}},"o":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"125":{"tf":1.0}}}}}}},"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":1,"docs":{"66":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{">":{"(":{"&":{"\'":{"a":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"d":{"a":{"df":0,"docs":{},"y":{"df":5,"docs":{"119":{"tf":1.0},"35":{"tf":1.0},"43":{"tf":1.0},"64":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":5,"docs":{"58":{"tf":1.0},"72":{"tf":1.0},"76":{"tf":1.4142135623730951},"88":{"tf":1.0},"94":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":2,"docs":{"2":{"tf":1.0},"23":{"tf":1.0}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"1":{"tf":1.0},"133":{"tf":1.0},"80":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"55":{"tf":1.0}}}}},"n":{"df":2,"docs":{"60":{"tf":1.0},"84":{"tf":1.0}}},"o":{"df":0,"docs":{},"l":{"df":5,"docs":{"4":{"tf":1.0},"5":{"tf":1.0},"56":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0}}}},"p":{"df":2,"docs":{"26":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951}},"i":{"c":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"3":{"tf":1.0},"67":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"l":{"df":12,"docs":{"111":{"tf":1.0},"25":{"tf":1.4142135623730951},"3":{"tf":2.0},"35":{"tf":1.4142135623730951},"55":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"75":{"tf":1.0},"78":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"3":{"tf":1.0},"67":{"tf":1.0}}}},"df":0,"docs":{}},"y":{"df":1,"docs":{"5":{"tf":1.0}}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":6,"docs":{"121":{"tf":1.0},"131":{"tf":1.0},"15":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.0},"55":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"69":{"tf":1.0}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"<":{"&":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}},">":{"(":{"df":0,"docs":{},"t":{"df":1,"docs":{"45":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":20,"docs":{"101":{"tf":1.0},"112":{"tf":1.0},"29":{"tf":1.4142135623730951},"3":{"tf":5.0},"31":{"tf":2.6457513110645907},"36":{"tf":1.4142135623730951},"39":{"tf":1.0},"4":{"tf":2.23606797749979},"40":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.4142135623730951},"45":{"tf":3.1622776601683795},"46":{"tf":1.7320508075688772},"58":{"tf":1.4142135623730951},"59":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":2.23606797749979},"9":{"tf":2.0},"92":{"tf":1.0},"99":{"tf":1.0}},"’":{"df":1,"docs":{"3":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"72":{"tf":1.7320508075688772}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"74":{"tf":1.0},"77":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}}},"t":{"df":3,"docs":{"4":{"tf":1.0},"41":{"tf":2.0},"51":{"tf":1.4142135623730951}}}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":6,"docs":{"11":{"tf":1.0},"125":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"30":{"tf":1.0},"52":{"tf":2.8284271247461903},"56":{"tf":2.0}},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"15":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"67":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":4,"docs":{"16":{"tf":1.0},"34":{"tf":1.4142135623730951},"58":{"tf":1.0},"92":{"tf":1.0}}}},"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}},"df":1,"docs":{"43":{"tf":1.4142135623730951}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":4,"docs":{"1":{"tf":1.0},"14":{"tf":1.0},"18":{"tf":1.0},"92":{"tf":1.4142135623730951}},"i":{"df":1,"docs":{"82":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"59":{"tf":1.0},"82":{"tf":1.0}}}}}}},"df":28,"docs":{"108":{"tf":1.0},"11":{"tf":1.4142135623730951},"125":{"tf":1.0},"126":{"tf":1.0},"128":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"23":{"tf":1.0},"25":{"tf":1.7320508075688772},"27":{"tf":1.7320508075688772},"31":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.7320508075688772},"35":{"tf":1.4142135623730951},"41":{"tf":1.0},"46":{"tf":2.6457513110645907},"52":{"tf":1.0},"56":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"60":{"tf":1.0},"63":{"tf":1.0},"67":{"tf":1.4142135623730951},"72":{"tf":1.0},"73":{"tf":1.7320508075688772},"76":{"tf":1.0},"78":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"92":{"tf":1.4142135623730951}},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"116":{"tf":2.0},"117":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":5,"docs":{"116":{"tf":1.0},"118":{"tf":1.0},"131":{"tf":1.0},"48":{"tf":1.0},"82":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":8,"docs":{"30":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":1.0},"55":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"71":{"tf":1.0},"77":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":8,"docs":{"11":{"tf":1.0},"24":{"tf":1.0},"31":{"tf":1.0},"39":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"e":{"df":17,"docs":{"111":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"34":{"tf":1.0},"40":{"tf":1.0},"47":{"tf":1.4142135623730951},"48":{"tf":1.0},"54":{"tf":2.0},"55":{"tf":1.7320508075688772},"58":{"tf":1.0},"60":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.0},"78":{"tf":1.4142135623730951}}},"l":{"df":0,"docs":{},"i":{"df":5,"docs":{"110":{"tf":1.0},"35":{"tf":1.0},"52":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"3":{"tf":3.3166247903554},"5":{"tf":2.23606797749979},"67":{"tf":1.0}}}}}},"s":{"df":1,"docs":{"39":{"tf":1.0}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":5,"docs":{"10":{"tf":1.0},"14":{"tf":1.4142135623730951},"2":{"tf":1.0},"35":{"tf":2.0},"7":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":9,"docs":{"1":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":1.0},"34":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.4142135623730951},"55":{"tf":1.0},"56":{"tf":1.0},"63":{"tf":1.0}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"82":{"tf":1.0}}}}}}},"w":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":2,"docs":{"114":{"tf":1.0},"92":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"28":{"tf":1.0},"67":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"o":{"df":34,"docs":{"1":{"tf":1.0},"119":{"tf":1.4142135623730951},"125":{"tf":1.0},"126":{"tf":1.0},"131":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"30":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"56":{"tf":1.4142135623730951},"58":{"tf":1.0},"61":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"70":{"tf":1.0},"75":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":2.0},"87":{"tf":1.7320508075688772},"9":{"tf":1.0},"90":{"tf":1.4142135623730951},"92":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":2,"docs":{"116":{"tf":1.0},"117":{"tf":1.0}}}}},"df":68,"docs":{"1":{"tf":1.0},"10":{"tf":2.449489742783178},"101":{"tf":1.0},"102":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.4142135623730951},"11":{"tf":3.605551275463989},"110":{"tf":1.0},"114":{"tf":1.4142135623730951},"119":{"tf":1.4142135623730951},"12":{"tf":2.0},"123":{"tf":1.7320508075688772},"125":{"tf":2.449489742783178},"131":{"tf":3.1622776601683795},"14":{"tf":3.0},"15":{"tf":2.0},"16":{"tf":2.23606797749979},"17":{"tf":1.4142135623730951},"18":{"tf":1.0},"2":{"tf":1.7320508075688772},"23":{"tf":1.0},"29":{"tf":2.23606797749979},"3":{"tf":3.7416573867739413},"32":{"tf":1.4142135623730951},"33":{"tf":1.0},"34":{"tf":3.605551275463989},"35":{"tf":2.8284271247461903},"36":{"tf":2.23606797749979},"39":{"tf":2.449489742783178},"4":{"tf":2.23606797749979},"40":{"tf":2.6457513110645907},"41":{"tf":1.0},"42":{"tf":1.4142135623730951},"43":{"tf":3.0},"44":{"tf":2.6457513110645907},"45":{"tf":2.449489742783178},"46":{"tf":3.605551275463989},"47":{"tf":1.0},"48":{"tf":1.4142135623730951},"5":{"tf":1.0},"52":{"tf":3.3166247903554},"53":{"tf":1.4142135623730951},"54":{"tf":1.0},"55":{"tf":2.0},"56":{"tf":2.6457513110645907},"58":{"tf":2.449489742783178},"59":{"tf":1.7320508075688772},"6":{"tf":1.0},"60":{"tf":2.0},"68":{"tf":2.449489742783178},"7":{"tf":3.4641016151377544},"71":{"tf":3.7416573867739413},"72":{"tf":2.8284271247461903},"8":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":2.449489742783178},"83":{"tf":1.0},"85":{"tf":1.4142135623730951},"87":{"tf":1.7320508075688772},"88":{"tf":1.4142135623730951},"89":{"tf":2.23606797749979},"9":{"tf":3.1622776601683795},"90":{"tf":2.0},"91":{"tf":2.0},"92":{"tf":1.7320508075688772},"93":{"tf":2.449489742783178},"94":{"tf":1.0},"96":{"tf":1.7320508075688772}},"’":{"df":4,"docs":{"16":{"tf":1.0},"3":{"tf":1.0},"36":{"tf":1.0},"7":{"tf":1.4142135623730951}}}},"i":{"c":{"df":3,"docs":{"10":{"tf":1.0},"100":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}}},"’":{"df":2,"docs":{"40":{"tf":1.4142135623730951},"96":{"tf":1.0}}}},"u":{"1":{"6":{"df":5,"docs":{"31":{"tf":3.3166247903554},"44":{"tf":1.4142135623730951},"50":{"tf":1.0},"7":{"tf":3.4641016151377544},"82":{"tf":1.0}}},"df":1,"docs":{"51":{"tf":1.0}}},"2":{"df":1,"docs":{"51":{"tf":1.4142135623730951}}},"3":{"2":{"df":10,"docs":{"129":{"tf":1.0},"19":{"tf":1.0},"22":{"tf":2.6457513110645907},"24":{"tf":2.8284271247461903},"44":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"58":{"tf":1.0},"59":{"tf":1.0},"7":{"tf":2.8284271247461903},"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"6":{"4":{"df":1,"docs":{"7":{"tf":2.23606797749979}}},"df":0,"docs":{}},"8":{"df":21,"docs":{"10":{"tf":1.0},"110":{"tf":2.449489742783178},"111":{"tf":4.0},"122":{"tf":1.4142135623730951},"131":{"tf":1.7320508075688772},"29":{"tf":1.7320508075688772},"31":{"tf":4.58257569495584},"35":{"tf":1.7320508075688772},"36":{"tf":2.0},"5":{"tf":1.4142135623730951},"50":{"tf":1.0},"58":{"tf":1.0},"7":{"tf":2.8284271247461903},"71":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.4142135623730951},"9":{"tf":1.0},"91":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}}},"b":{"df":1,"docs":{"2":{"tf":1.0}}},"c":{"df":0,"docs":{},"g":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":7,"docs":{"34":{"tf":2.0},"36":{"tf":2.23606797749979},"4":{"tf":1.0},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"52":{"tf":2.449489742783178},"7":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":3,"docs":{"43":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.0}}}}}},"n":{")":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"107":{"tf":1.0},"35":{"tf":1.0}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"3":{"tf":1.0},"30":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":3,"docs":{"17":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"92":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"o":{"c":{"df":3,"docs":{"4":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"3":{"tf":1.0},"30":{"tf":2.8284271247461903},"39":{"tf":1.4142135623730951},"52":{"tf":1.0}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"88":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":6,"docs":{"3":{"tf":1.4142135623730951},"40":{"tf":1.0},"5":{"tf":1.4142135623730951},"53":{"tf":1.0},"56":{"tf":1.0},"70":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"65":{"tf":1.0},"70":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}}}},"df":2,"docs":{"110":{"tf":1.0},"111":{"tf":1.7320508075688772}},"e":{"d":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"110":{"tf":1.0},"111":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":6,"docs":{"54":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"67":{"tf":1.0},"75":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"60":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"69":{"tf":1.0}}}}}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":23,"docs":{"10":{"tf":1.0},"11":{"tf":2.23606797749979},"125":{"tf":1.0},"126":{"tf":1.4142135623730951},"131":{"tf":1.0},"134":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":2.0},"32":{"tf":1.0},"4":{"tf":2.8284271247461903},"5":{"tf":1.4142135623730951},"52":{"tf":2.23606797749979},"53":{"tf":1.0},"56":{"tf":1.4142135623730951},"61":{"tf":1.0},"64":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"82":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0}}}}},"r":{"df":1,"docs":{"64":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":12,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"2":{"tf":1.0},"25":{"tf":1.4142135623730951},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"43":{"tf":2.449489742783178},"54":{"tf":1.7320508075688772},"73":{"tf":1.4142135623730951},"82":{"tf":1.0},"94":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"75":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}}}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":13,"docs":{"2":{"tf":1.0},"20":{"tf":1.0},"24":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.0},"5":{"tf":1.0},"56":{"tf":1.0},"61":{"tf":1.0},"64":{"tf":1.0},"67":{"tf":1.0},"81":{"tf":1.0},"9":{"tf":1.0},"96":{"tf":1.0}}}}}}}},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"69":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"43":{"tf":1.4142135623730951},"71":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"h":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"131":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"t":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{")":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{")":{")":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":3,"docs":{"54":{"tf":1.0},"55":{"tf":3.4641016151377544},"56":{"tf":1.0}},"i":{"df":13,"docs":{"1":{"tf":1.0},"4":{"tf":1.7320508075688772},"5":{"tf":1.0},"53":{"tf":1.7320508075688772},"54":{"tf":2.6457513110645907},"55":{"tf":1.0},"56":{"tf":3.1622776601683795},"58":{"tf":1.0},"61":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"83":{"tf":1.7320508075688772}}}}}},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"15":{"tf":1.0},"4":{"tf":1.0},"52":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772}}}},"q":{"df":0,"docs":{},"u":{"df":3,"docs":{"59":{"tf":2.0},"72":{"tf":1.0},"81":{"tf":1.4142135623730951}},"e":{"<":{"df":0,"docs":{},"t":{"df":3,"docs":{"41":{"tf":1.0},"59":{"tf":1.7320508075688772},"81":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"t":{"df":2,"docs":{"58":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"34":{"tf":1.0},"5":{"tf":1.0}}}}}}},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"1":{"tf":1.0}},"n":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"1":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":9,"docs":{"1":{"tf":1.0},"17":{"tf":1.0},"21":{"tf":1.0},"33":{"tf":1.0},"65":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"84":{"tf":1.0},"88":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"k":{"df":16,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"100":{"tf":1.0},"103":{"tf":1.0},"125":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.0},"34":{"tf":1.4142135623730951},"4":{"tf":1.0},"40":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0},"64":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.4142135623730951}}}}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"10":{"tf":1.0},"109":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"b":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"74":{"tf":1.0}}}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"131":{"tf":1.4142135623730951},"42":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"11":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"131":{"tf":1.0}}}}}}}},"s":{"a":{"df":0,"docs":{},"f":{"df":62,"docs":{"1":{"tf":2.23606797749979},"10":{"tf":1.0},"100":{"tf":1.4142135623730951},"101":{"tf":1.0},"102":{"tf":1.7320508075688772},"103":{"tf":1.4142135623730951},"104":{"tf":2.0},"105":{"tf":2.449489742783178},"11":{"tf":1.0},"110":{"tf":2.23606797749979},"111":{"tf":4.0},"116":{"tf":1.4142135623730951},"117":{"tf":2.449489742783178},"118":{"tf":1.0},"120":{"tf":3.0},"121":{"tf":2.23606797749979},"122":{"tf":1.0},"124":{"tf":1.4142135623730951},"125":{"tf":2.0},"127":{"tf":1.0},"128":{"tf":1.7320508075688772},"131":{"tf":1.4142135623730951},"14":{"tf":1.0},"2":{"tf":3.4641016151377544},"3":{"tf":6.557438524302},"30":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"36":{"tf":2.23606797749979},"38":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":2.449489742783178},"40":{"tf":1.0},"41":{"tf":2.449489742783178},"43":{"tf":1.7320508075688772},"48":{"tf":1.4142135623730951},"5":{"tf":3.7416573867739413},"52":{"tf":1.7320508075688772},"53":{"tf":1.0},"56":{"tf":2.23606797749979},"59":{"tf":2.23606797749979},"60":{"tf":1.7320508075688772},"62":{"tf":1.7320508075688772},"65":{"tf":2.0},"66":{"tf":1.0},"67":{"tf":2.449489742783178},"68":{"tf":1.0},"70":{"tf":2.0},"71":{"tf":2.8284271247461903},"72":{"tf":3.1622776601683795},"81":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":1.0},"85":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951},"87":{"tf":2.0},"88":{"tf":2.8284271247461903},"89":{"tf":2.0},"91":{"tf":1.7320508075688772},"92":{"tf":2.23606797749979},"93":{"tf":4.0},"99":{"tf":1.7320508075688772}},"e":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":6,"docs":{"114":{"tf":1.0},"127":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0},"130":{"tf":1.0},"134":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":3,"docs":{"15":{"tf":1.4142135623730951},"22":{"tf":1.0},"71":{"tf":1.4142135623730951}},"l":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":2.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"3":{"tf":2.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":6,"docs":{"100":{"tf":1.0},"120":{"tf":1.4142135623730951},"2":{"tf":1.0},"3":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"82":{"tf":1.0}}}},"z":{"df":2,"docs":{"46":{"tf":1.7320508075688772},"9":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":7,"docs":{"19":{"tf":1.0},"40":{"tf":1.0},"5":{"tf":1.4142135623730951},"61":{"tf":1.0},"65":{"tf":1.0},"92":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"16":{"tf":1.0},"7":{"tf":1.0}}}}}},"df":0,"docs":{}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":12,"docs":{"131":{"tf":1.0},"133":{"tf":1.0},"134":{"tf":1.0},"15":{"tf":1.0},"31":{"tf":1.0},"36":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":1.0},"76":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"60":{"tf":1.0},"64":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":10,"docs":{"26":{"tf":1.0},"29":{"tf":1.4142135623730951},"31":{"tf":1.0},"46":{"tf":1.0},"54":{"tf":1.4142135623730951},"60":{"tf":1.0},"63":{"tf":1.4142135623730951},"67":{"tf":1.0},"72":{"tf":1.4142135623730951},"84":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"89":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"71":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":11,"docs":{"1":{"tf":1.0},"126":{"tf":3.3166247903554},"127":{"tf":2.23606797749979},"128":{"tf":2.0},"130":{"tf":1.0},"134":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"61":{"tf":1.0},"64":{"tf":3.605551275463989},"65":{"tf":2.0},"82":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}}}}}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":8,"docs":{"102":{"tf":1.0},"105":{"tf":1.0},"11":{"tf":1.0},"121":{"tf":1.0},"65":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.0},"98":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"103":{"tf":1.0},"117":{"tf":1.0},"68":{"tf":1.0}}}},"df":0,"docs":{}},"df":29,"docs":{"1":{"tf":1.0},"103":{"tf":1.4142135623730951},"104":{"tf":1.0},"109":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"24":{"tf":1.0},"27":{"tf":1.0},"3":{"tf":1.4142135623730951},"30":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.4142135623730951},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.0},"59":{"tf":1.0},"61":{"tf":1.0},"64":{"tf":1.4142135623730951},"65":{"tf":1.0},"67":{"tf":2.0},"81":{"tf":1.0},"82":{"tf":1.7320508075688772},"85":{"tf":1.4142135623730951},"87":{"tf":1.0},"88":{"tf":1.0},"92":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"a":{"d":{"df":1,"docs":{"89":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"3":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"15":{"tf":1.0},"56":{"tf":1.0}}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":5,"docs":{"116":{"tf":1.0},"32":{"tf":1.0},"52":{"tf":1.0},"63":{"tf":1.0},"68":{"tf":1.0}}}},"df":91,"docs":{"1":{"tf":1.7320508075688772},"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":2.6457513110645907},"104":{"tf":3.0},"105":{"tf":2.449489742783178},"107":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.7320508075688772},"111":{"tf":3.1622776601683795},"112":{"tf":1.0},"114":{"tf":1.0},"118":{"tf":1.4142135623730951},"119":{"tf":1.0},"121":{"tf":1.4142135623730951},"122":{"tf":2.6457513110645907},"123":{"tf":2.0},"125":{"tf":2.0},"126":{"tf":1.4142135623730951},"130":{"tf":1.4142135623730951},"131":{"tf":2.0},"133":{"tf":1.7320508075688772},"134":{"tf":2.0},"135":{"tf":2.6457513110645907},"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":1.7320508075688772},"19":{"tf":1.7320508075688772},"2":{"tf":2.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.7320508075688772},"23":{"tf":2.0},"26":{"tf":3.0},"28":{"tf":1.7320508075688772},"3":{"tf":3.3166247903554},"30":{"tf":1.0},"32":{"tf":1.7320508075688772},"33":{"tf":1.7320508075688772},"34":{"tf":3.3166247903554},"35":{"tf":2.0},"36":{"tf":2.23606797749979},"37":{"tf":1.0},"39":{"tf":1.7320508075688772},"4":{"tf":2.0},"40":{"tf":2.449489742783178},"41":{"tf":2.23606797749979},"42":{"tf":1.0},"43":{"tf":1.7320508075688772},"44":{"tf":1.0},"46":{"tf":2.0},"47":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":2.0},"56":{"tf":3.7416573867739413},"57":{"tf":1.0},"58":{"tf":1.4142135623730951},"59":{"tf":3.605551275463989},"60":{"tf":1.7320508075688772},"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"64":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"70":{"tf":2.6457513110645907},"71":{"tf":2.0},"72":{"tf":2.6457513110645907},"76":{"tf":1.0},"77":{"tf":1.4142135623730951},"78":{"tf":2.23606797749979},"79":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":2.6457513110645907},"82":{"tf":3.3166247903554},"85":{"tf":1.4142135623730951},"86":{"tf":1.7320508075688772},"87":{"tf":1.7320508075688772},"88":{"tf":1.0},"89":{"tf":1.4142135623730951},"9":{"tf":1.0},"92":{"tf":1.7320508075688772},"93":{"tf":2.449489742783178},"94":{"tf":1.0},"96":{"tf":2.8284271247461903},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"10":{"tf":1.4142135623730951},"125":{"tf":1.0},"9":{"tf":1.0}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"10":{"tf":1.7320508075688772}}}}}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"60":{"tf":1.0},"67":{"tf":1.0}}}}}}}},"r":{"df":5,"docs":{"3":{"tf":1.0},"58":{"tf":1.0},"67":{"tf":1.7320508075688772},"72":{"tf":1.0},"96":{"tf":1.0}},"’":{"df":1,"docs":{"64":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"z":{"df":22,"docs":{"103":{"tf":1.4142135623730951},"105":{"tf":1.0},"111":{"tf":2.0},"29":{"tf":2.0},"34":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":2.449489742783178},"41":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"5":{"tf":2.0},"56":{"tf":1.0},"62":{"tf":1.4142135623730951},"67":{"tf":2.449489742783178},"72":{"tf":1.0},"81":{"tf":2.0},"86":{"tf":1.4142135623730951},"87":{"tf":2.0},"88":{"tf":2.0},"89":{"tf":1.4142135623730951},"91":{"tf":1.0},"92":{"tf":2.6457513110645907},"93":{"tf":3.605551275463989}},"e":{":":{":":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"x":{"df":5,"docs":{"103":{"tf":1.4142135623730951},"62":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.7320508075688772},"93":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":12,"docs":{"100":{"tf":1.0},"104":{"tf":1.0},"2":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"56":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.0},"72":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"123":{"tf":1.0},"2":{"tf":1.0},"41":{"tf":1.0}}}}}},"v":{".":{"d":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"93":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"0":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"93":{"tf":2.0}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"93":{"tf":1.0}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"(":{"&":{"df":1,"docs":{"41":{"tf":1.0}}},"1":{"0":{"df":1,"docs":{"93":{"tf":1.0}}},"df":1,"docs":{"93":{"tf":1.0}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"1":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":1,"docs":{"93":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}},"df":1,"docs":{"93":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"(":{"0":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},":":{":":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},">":{"(":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"[":{"0":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"1":{"df":1,"docs":{"56":{"tf":1.0}}},"2":{"df":1,"docs":{"56":{"tf":1.0}}},"3":{"df":1,"docs":{"56":{"tf":1.0}}},"df":2,"docs":{"34":{"tf":2.449489742783178},"56":{"tf":1.7320508075688772}},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"d":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"111":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":30,"docs":{"100":{"tf":1.0},"104":{"tf":1.4142135623730951},"105":{"tf":1.0},"11":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"131":{"tf":1.0},"14":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"26":{"tf":1.0},"31":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"7":{"tf":1.7320508075688772},"72":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"86":{"tf":1.4142135623730951},"91":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":49,"docs":{"10":{"tf":1.7320508075688772},"103":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"11":{"tf":2.0},"116":{"tf":1.0},"117":{"tf":1.7320508075688772},"119":{"tf":1.0},"125":{"tf":1.4142135623730951},"131":{"tf":1.0},"14":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.4142135623730951},"24":{"tf":1.0},"26":{"tf":1.7320508075688772},"28":{"tf":1.7320508075688772},"3":{"tf":2.0},"34":{"tf":2.6457513110645907},"35":{"tf":1.7320508075688772},"36":{"tf":1.4142135623730951},"4":{"tf":3.1622776601683795},"40":{"tf":2.0},"43":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"46":{"tf":2.449489742783178},"52":{"tf":1.0},"53":{"tf":1.4142135623730951},"54":{"tf":2.8284271247461903},"56":{"tf":2.8284271247461903},"60":{"tf":1.4142135623730951},"61":{"tf":1.7320508075688772},"62":{"tf":1.7320508075688772},"66":{"tf":1.0},"67":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"7":{"tf":2.23606797749979},"70":{"tf":2.8284271247461903},"72":{"tf":2.449489742783178},"78":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":2.23606797749979},"87":{"tf":2.0},"91":{"tf":1.0},"92":{"tf":1.4142135623730951},"96":{"tf":2.23606797749979},"99":{"tf":1.4142135623730951}},"e":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{},"’":{"df":2,"docs":{"22":{"tf":1.0},"55":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":12,"docs":{"121":{"tf":1.4142135623730951},"124":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.7320508075688772},"28":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"54":{"tf":2.23606797749979},"55":{"tf":2.6457513110645907},"58":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"’":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"d":{"df":1,"docs":{"124":{"tf":1.7320508075688772}}},"df":0,"docs":{},"n":{"c":{"df":10,"docs":{"1":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.0},"34":{"tf":3.605551275463989},"39":{"tf":1.4142135623730951},"40":{"tf":2.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"96":{"tf":1.4142135623730951}}},"df":0,"docs":{},"t":{"df":9,"docs":{"11":{"tf":1.4142135623730951},"125":{"tf":1.4142135623730951},"126":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"35":{"tf":1.7320508075688772},"59":{"tf":1.0},"7":{"tf":2.0}}}}},"df":1,"docs":{"58":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":3,"docs":{"108":{"tf":1.0},"19":{"tf":1.0},"72":{"tf":1.0}}}}}}},"df":6,"docs":{"122":{"tf":1.0},"127":{"tf":1.0},"128":{"tf":1.0},"28":{"tf":2.23606797749979},"41":{"tf":1.4142135623730951},"93":{"tf":2.0}},"e":{"c":{"!":{"[":{"0":{"df":1,"docs":{"111":{"tf":1.0}},"x":{"d":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}}},"1":{"df":4,"docs":{"19":{"tf":1.0},"25":{"tf":1.4142135623730951},"26":{"tf":2.0},"70":{"tf":1.4142135623730951}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"0":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"\'":{"df":3,"docs":{"70":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0}}},".":{"c":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"87":{"tf":1.0}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"87":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"87":{"tf":1.0}}}}}},":":{":":{"d":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":3,"docs":{"41":{"tf":1.0},"82":{"tf":1.0},"93":{"tf":2.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"(":{"&":{"\'":{"c":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"c":{"a":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"(":{"d":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"111":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"<":{"&":{"\'":{"a":{"df":1,"docs":{"81":{"tf":1.0}}},"df":1,"docs":{"41":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"34":{"tf":1.0},"81":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"41":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":1,"docs":{"34":{"tf":1.0}}},"i":{"3":{"2":{"df":2,"docs":{"25":{"tf":1.0},"52":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"<":{"\'":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"t":{"df":14,"docs":{"34":{"tf":1.4142135623730951},"40":{"tf":2.8284271247461903},"41":{"tf":2.23606797749979},"5":{"tf":1.4142135623730951},"66":{"tf":1.0},"7":{"tf":1.0},"81":{"tf":2.0},"82":{"tf":1.4142135623730951},"84":{"tf":1.0},"85":{"tf":1.4142135623730951},"87":{"tf":1.0},"88":{"tf":2.0},"89":{"tf":2.23606797749979},"93":{"tf":2.6457513110645907}}},"u":{"3":{"2":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}},"8":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}}},"[":{"0":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":27,"docs":{"111":{"tf":1.0},"123":{"tf":1.0},"25":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.4142135623730951},"4":{"tf":1.0},"40":{"tf":1.7320508075688772},"41":{"tf":3.1622776601683795},"5":{"tf":3.0},"61":{"tf":2.6457513110645907},"63":{"tf":1.0},"66":{"tf":2.0},"67":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.7320508075688772},"85":{"tf":1.0},"87":{"tf":2.449489742783178},"88":{"tf":2.0},"89":{"tf":2.23606797749979},"9":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":2.0},"95":{"tf":1.0}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"122":{"tf":1.0}}}},"df":0,"docs":{}},"df":6,"docs":{"111":{"tf":2.23606797749979},"123":{"tf":1.0},"22":{"tf":1.0},"35":{"tf":1.4142135623730951},"41":{"tf":1.0},"92":{"tf":1.4142135623730951}}}}},"’":{"df":3,"docs":{"40":{"tf":1.0},"61":{"tf":1.7320508075688772},"87":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":21,"docs":{"22":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"40":{"tf":1.4142135623730951},"43":{"tf":1.0},"48":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.4142135623730951},"76":{"tf":1.0},"77":{"tf":1.0},"82":{"tf":1.0},"87":{"tf":1.0},"90":{"tf":1.0},"95":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":4,"docs":{"19":{"tf":1.0},"3":{"tf":1.0},"5":{"tf":1.4142135623730951},"52":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":11,"docs":{"121":{"tf":1.0},"133":{"tf":1.0},"134":{"tf":1.0},"22":{"tf":1.4142135623730951},"36":{"tf":1.0},"55":{"tf":1.0},"73":{"tf":1.0},"86":{"tf":1.0},"89":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}}}}}}}},"i":{"a":{"df":8,"docs":{"119":{"tf":1.0},"134":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"43":{"tf":1.0},"47":{"tf":1.0},"89":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"9":{"tf":1.0}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"56":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":11,"docs":{"25":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"4":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0},"60":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.7320508075688772},"72":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"104":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"i":{"d":{"df":7,"docs":{"11":{"tf":3.1622776601683795},"115":{"tf":1.0},"116":{"tf":1.4142135623730951},"117":{"tf":1.7320508075688772},"12":{"tf":1.0},"125":{"tf":1.0},"131":{"tf":2.23606797749979}}},"df":0,"docs":{}}},"s":{"df":1,"docs":{"76":{"tf":1.0}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"4":{"tf":1.0},"9":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"20":{"tf":1.0},"89":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":27,"docs":{"1":{"tf":1.4142135623730951},"109":{"tf":1.0},"131":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0},"25":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"56":{"tf":1.4142135623730951},"58":{"tf":1.0},"66":{"tf":1.4142135623730951},"73":{"tf":1.7320508075688772},"74":{"tf":1.0},"75":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":2.23606797749979},"83":{"tf":2.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"0":{"tf":1.0},"40":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"60":{"tf":1.0},"7":{"tf":1.0}}}},"y":{"df":45,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"109":{"tf":1.0},"113":{"tf":1.0},"118":{"tf":1.0},"122":{"tf":1.0},"125":{"tf":1.0},"127":{"tf":1.0},"128":{"tf":1.0},"131":{"tf":1.7320508075688772},"135":{"tf":1.0},"14":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.7320508075688772},"26":{"tf":1.0},"3":{"tf":1.7320508075688772},"30":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"52":{"tf":2.0},"53":{"tf":1.0},"56":{"tf":1.7320508075688772},"58":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772},"72":{"tf":1.4142135623730951},"73":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":2.0},"83":{"tf":1.4142135623730951},"84":{"tf":1.0},"9":{"tf":1.4142135623730951},"92":{"tf":1.0},"94":{"tf":1.0},"96":{"tf":1.4142135623730951},"98":{"tf":1.0}}}},"df":0,"docs":{},"e":{"\'":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"83":{"tf":1.0},"93":{"tf":1.0}}}},"r":{"df":6,"docs":{"103":{"tf":1.0},"105":{"tf":1.0},"61":{"tf":1.0},"78":{"tf":1.0},"82":{"tf":1.0},"89":{"tf":1.0}}}},"a":{"df":0,"docs":{},"k":{"df":3,"docs":{"75":{"tf":1.4142135623730951},"76":{"tf":1.0},"95":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"45":{"tf":1.0}}},"r":{"df":2,"docs":{"75":{"tf":1.0},"77":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"75":{"tf":1.7320508075688772},"78":{"tf":1.0},"79":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"80":{"tf":1.0}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"3":{"tf":1.0}},"t":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}}}},"r":{"d":{"df":2,"docs":{"3":{"tf":1.0},"68":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"l":{"df":14,"docs":{"1":{"tf":1.0},"11":{"tf":1.0},"114":{"tf":1.0},"2":{"tf":1.4142135623730951},"23":{"tf":1.0},"27":{"tf":1.0},"34":{"tf":1.0},"40":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"82":{"tf":1.0},"87":{"tf":1.0},"9":{"tf":1.0},"96":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":4,"docs":{"61":{"tf":1.0},"64":{"tf":1.0},"69":{"tf":1.0},"87":{"tf":1.0}}}}}}},"’":{"d":{"df":5,"docs":{"41":{"tf":1.0},"74":{"tf":1.0},"81":{"tf":1.0},"85":{"tf":1.0},"92":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":22,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"103":{"tf":2.0},"104":{"tf":1.0},"115":{"tf":1.0},"131":{"tf":1.0},"2":{"tf":1.0},"33":{"tf":1.0},"44":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0},"65":{"tf":1.4142135623730951},"73":{"tf":1.0},"82":{"tf":2.23606797749979},"87":{"tf":1.4142135623730951},"89":{"tf":1.0},"92":{"tf":1.4142135623730951},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}}},"r":{"df":23,"docs":{"100":{"tf":1.0},"103":{"tf":1.0},"119":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.0},"33":{"tf":1.0},"43":{"tf":1.0},"52":{"tf":1.0},"6":{"tf":1.0},"61":{"tf":1.0},"67":{"tf":1.4142135623730951},"72":{"tf":1.0},"80":{"tf":1.4142135623730951},"82":{"tf":1.7320508075688772},"83":{"tf":1.0},"87":{"tf":2.0},"88":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.7320508075688772},"99":{"tf":1.0}}},"v":{"df":8,"docs":{"103":{"tf":1.0},"22":{"tf":1.0},"61":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.7320508075688772},"97":{"tf":1.0}}}}},"g":{"df":1,"docs":{"52":{"tf":1.0}}},"h":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":4,"docs":{"122":{"tf":1.0},"134":{"tf":1.0},"3":{"tf":1.0},"58":{"tf":1.0}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"72":{"tf":1.0}}}}}},"’":{"df":4,"docs":{"0":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":5,"docs":{"40":{"tf":1.0},"41":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"41":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":11,"docs":{"129":{"tf":1.0},"135":{"tf":1.0},"19":{"tf":1.0},"22":{"tf":1.0},"3":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"56":{"tf":1.0},"59":{"tf":1.0},"63":{"tf":1.0},"67":{"tf":1.0},"72":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"85":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":15,"docs":{"15":{"tf":1.0},"20":{"tf":1.0},"24":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":1.4142135623730951},"35":{"tf":1.0},"5":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.0},"82":{"tf":1.7320508075688772},"85":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"24":{"tf":1.0},"3":{"tf":1.4142135623730951}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":3,"docs":{"14":{"tf":1.0},"4":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"52":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"l":{"df":1,"docs":{"69":{"tf":1.0}}}},"n":{"3":{"2":{"df":1,"docs":{"122":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"6":{"4":{"df":1,"docs":{"122":{"tf":1.0}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"122":{"tf":1.7320508075688772},"133":{"tf":1.4142135623730951}}}}},"df":2,"docs":{"34":{"tf":1.4142135623730951},"75":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"134":{"tf":1.0}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}},"h":{"df":5,"docs":{"1":{"tf":1.0},"113":{"tf":1.0},"130":{"tf":1.0},"3":{"tf":1.0},"75":{"tf":1.0}}}},"t":{"df":2,"docs":{"65":{"tf":1.0},"68":{"tf":1.7320508075688772}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":11,"docs":{"1":{"tf":1.0},"110":{"tf":1.0},"124":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"36":{"tf":1.4142135623730951},"39":{"tf":1.0},"7":{"tf":1.0},"82":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":26,"docs":{"1":{"tf":1.0},"103":{"tf":1.0},"11":{"tf":1.0},"123":{"tf":1.0},"126":{"tf":1.0},"134":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"46":{"tf":1.0},"52":{"tf":1.4142135623730951},"54":{"tf":1.0},"56":{"tf":1.7320508075688772},"59":{"tf":1.4142135623730951},"61":{"tf":1.0},"63":{"tf":1.4142135623730951},"64":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.0},"82":{"tf":1.0},"87":{"tf":1.0},"9":{"tf":1.4142135623730951},"99":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"\'":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"3":{"tf":1.0},"42":{"tf":1.0}}}}},"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":12,"docs":{"1":{"tf":1.7320508075688772},"19":{"tf":1.0},"3":{"tf":1.0},"52":{"tf":1.0},"64":{"tf":1.0},"67":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":1.0}}}}},"r":{"d":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"125":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":37,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.0},"123":{"tf":1.0},"126":{"tf":1.0},"134":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.4142135623730951},"3":{"tf":1.0},"31":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":2.0},"39":{"tf":1.4142135623730951},"43":{"tf":2.449489742783178},"45":{"tf":1.0},"46":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"52":{"tf":1.0},"53":{"tf":1.4142135623730951},"54":{"tf":1.0},"56":{"tf":1.7320508075688772},"59":{"tf":1.7320508075688772},"62":{"tf":1.0},"63":{"tf":1.4142135623730951},"65":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":1.4142135623730951},"82":{"tf":2.0},"85":{"tf":1.0},"89":{"tf":1.4142135623730951},"9":{"tf":1.0},"92":{"tf":1.0},"95":{"tf":1.0}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"109":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"l":{"d":{".":{"d":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"35":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"35":{"tf":2.23606797749979},"36":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"<":{"\'":{"_":{"df":1,"docs":{"35":{"tf":1.0}}},"a":{"df":2,"docs":{"35":{"tf":1.7320508075688772},"36":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":10,"docs":{"120":{"tf":1.0},"14":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":3.0},"33":{"tf":3.0},"34":{"tf":3.605551275463989},"35":{"tf":3.0},"36":{"tf":1.4142135623730951},"65":{"tf":1.0},"76":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"df":12,"docs":{"10":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.7320508075688772},"22":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":1.4142135623730951},"40":{"tf":1.0},"5":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"82":{"tf":1.7320508075688772}}}},"s":{"df":2,"docs":{"5":{"tf":1.0},"83":{"tf":1.0}},"t":{"df":3,"docs":{"63":{"tf":1.0},"64":{"tf":1.0},"83":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"56":{"tf":1.4142135623730951},"75":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"n":{"\'":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":5,"docs":{"11":{"tf":1.0},"22":{"tf":1.0},"59":{"tf":1.0},"73":{"tf":1.0},"84":{"tf":1.0}}}}}},"df":0,"docs":{}}},"w":{"df":1,"docs":{"23":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":7,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.0},"41":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"10":{"tf":1.0},"111":{"tf":1.0},"117":{"tf":1.0},"37":{"tf":1.0},"72":{"tf":1.0},"81":{"tf":1.4142135623730951},"96":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"82":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"135":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":41,"docs":{"1":{"tf":1.7320508075688772},"103":{"tf":1.0},"104":{"tf":1.4142135623730951},"107":{"tf":1.0},"11":{"tf":1.0},"119":{"tf":1.0},"121":{"tf":1.0},"130":{"tf":1.0},"134":{"tf":1.0},"14":{"tf":1.0},"2":{"tf":2.0},"22":{"tf":3.1622776601683795},"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.7320508075688772},"31":{"tf":1.0},"33":{"tf":1.4142135623730951},"35":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"5":{"tf":1.0},"56":{"tf":1.7320508075688772},"59":{"tf":1.4142135623730951},"66":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":2.23606797749979},"73":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.7320508075688772},"78":{"tf":1.4142135623730951},"79":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":2.0},"87":{"tf":1.0},"91":{"tf":1.0},"94":{"tf":1.0}},"l":{"df":0,"docs":{},"n":{"!":{"(":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"135":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":1,"docs":{"72":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":13,"docs":{"103":{"tf":1.0},"120":{"tf":1.0},"14":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0},"3":{"tf":1.7320508075688772},"36":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.0},"72":{"tf":1.0},"87":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":10,"docs":{"30":{"tf":1.4142135623730951},"34":{"tf":1.0},"4":{"tf":1.4142135623730951},"46":{"tf":1.0},"52":{"tf":1.4142135623730951},"56":{"tf":1.0},"60":{"tf":1.0},"64":{"tf":1.4142135623730951},"82":{"tf":1.0},"89":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"x":{"(":{"&":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"[":{"0":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"u":{"3":{"2":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},".":{"a":{"df":1,"docs":{"43":{"tf":1.0}}},"b":{"df":1,"docs":{"43":{"tf":1.0}}},"c":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"3":{"2":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}},"6":{"4":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}},"8":{"6":{"/":{"6":{"4":{"df":1,"docs":{"75":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"6":{"4":{"df":1,"docs":{"122":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":4,"docs":{"122":{"tf":1.7320508075688772},"17":{"tf":1.0},"7":{"tf":1.0},"82":{"tf":1.0}}},"df":0,"docs":{}},"<":{"\'":{"_":{"df":1,"docs":{"26":{"tf":1.0}}},"a":{">":{"(":{"&":{"\'":{"a":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"[":{"0":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}},"1":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}},"df":0,"docs":{},"i":{"]":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"56":{"tf":1.4142135623730951}}}},"df":24,"docs":{"110":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"22":{"tf":1.0},"23":{"tf":3.1622776601683795},"24":{"tf":1.7320508075688772},"25":{"tf":2.6457513110645907},"26":{"tf":4.123105625617661},"31":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"43":{"tf":1.7320508075688772},"44":{"tf":1.7320508075688772},"45":{"tf":1.4142135623730951},"54":{"tf":5.196152422706632},"55":{"tf":5.656854249492381},"56":{"tf":2.0},"58":{"tf":1.4142135623730951},"63":{"tf":2.0},"66":{"tf":1.0},"74":{"tf":2.0},"75":{"tf":2.0},"82":{"tf":1.7320508075688772},"83":{"tf":1.0},"87":{"tf":2.449489742783178},"93":{"tf":2.0}}},"y":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"58":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":9,"docs":{"23":{"tf":2.8284271247461903},"35":{"tf":1.4142135623730951},"44":{"tf":1.7320508075688772},"54":{"tf":3.4641016151377544},"55":{"tf":3.1622776601683795},"58":{"tf":1.4142135623730951},"74":{"tf":1.7320508075688772},"75":{"tf":2.8284271247461903},"82":{"tf":1.7320508075688772}},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"92":{"tf":1.0}}}},"df":1,"docs":{"9":{"tf":1.0}},"p":{"df":1,"docs":{"82":{"tf":1.0}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":6,"docs":{"43":{"tf":2.0},"72":{"tf":1.0},"75":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":2.23606797749979},"92":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"69":{"tf":1.0}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"108":{"tf":1.0},"134":{"tf":1.0}}}}}}},"’":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":7,"docs":{"108":{"tf":1.0},"2":{"tf":1.0},"41":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0}}}},"r":{"df":14,"docs":{"1":{"tf":1.0},"108":{"tf":1.0},"114":{"tf":1.0},"2":{"tf":1.4142135623730951},"3":{"tf":1.0},"34":{"tf":1.4142135623730951},"52":{"tf":1.0},"56":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"77":{"tf":1.4142135623730951},"79":{"tf":1.0},"82":{"tf":1.4142135623730951}}}}}}},"z":{"1":{"df":1,"docs":{"54":{"tf":1.0}}},"2":{"df":1,"docs":{"54":{"tf":1.0}}},"df":2,"docs":{"23":{"tf":2.449489742783178},"54":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":14,"docs":{"10":{"tf":1.7320508075688772},"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"3":{"tf":1.0},"5":{"tf":1.0},"64":{"tf":1.0},"7":{"tf":1.0},"72":{"tf":1.0},"82":{"tf":2.23606797749979},"85":{"tf":1.0},"90":{"tf":2.0},"91":{"tf":2.449489742783178},"92":{"tf":1.4142135623730951},"93":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":7,"docs":{"10":{"tf":2.449489742783178},"11":{"tf":1.0},"14":{"tf":1.0},"82":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.4142135623730951},"92":{"tf":2.6457513110645907}}}}}}},"breadcrumbs":{"root":{"0":{".":{".":{"1":{"0":{"df":1,"docs":{"93":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"2":{".":{"0":{"df":1,"docs":{"108":{"tf":1.0}}},"1":{"4":{"6":{"df":1,"docs":{"133":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":37,"docs":{"10":{"tf":1.0},"111":{"tf":3.872983346207417},"115":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"123":{"tf":1.0},"129":{"tf":1.4142135623730951},"130":{"tf":1.0},"134":{"tf":1.0},"16":{"tf":1.0},"23":{"tf":2.0},"24":{"tf":1.0},"25":{"tf":1.0},"31":{"tf":1.7320508075688772},"4":{"tf":1.0},"43":{"tf":1.7320508075688772},"45":{"tf":1.0},"54":{"tf":1.4142135623730951},"58":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"65":{"tf":1.0},"67":{"tf":2.23606797749979},"7":{"tf":1.0},"72":{"tf":1.7320508075688772},"75":{"tf":1.0},"82":{"tf":3.605551275463989},"83":{"tf":1.4142135623730951},"84":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951},"88":{"tf":2.6457513110645907},"89":{"tf":1.7320508075688772},"9":{"tf":3.0},"90":{"tf":1.0},"91":{"tf":2.8284271247461903},"92":{"tf":3.1622776601683795},"93":{"tf":4.47213595499958}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"83":{"tf":1.4142135623730951}}}},"x":{"0":{"0":{"df":1,"docs":{"82":{"tf":1.0}}},"1":{"df":1,"docs":{"82":{"tf":1.0}}},"d":{"df":1,"docs":{"111":{"tf":1.0}}},"df":1,"docs":{"4":{"tf":1.0}}},"1":{"0":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"4":{"tf":1.0}}}}}}},"df":0,"docs":{}},"a":{"b":{"a":{"d":{"1":{"d":{"df":0,"docs":{},"e":{"a":{"df":1,"docs":{"22":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"d":{"0":{"df":1,"docs":{"111":{"tf":1.0}}},"7":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"0":{"0":{"0":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"1":{".":{".":{"=":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"x":{"df":2,"docs":{"82":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"0":{"df":3,"docs":{"59":{"tf":1.0},"64":{"tf":1.4142135623730951},"69":{"tf":1.0}}},"2":{"9":{".":{"2":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"9":{"df":1,"docs":{"95":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"0":{"df":2,"docs":{"110":{"tf":1.0},"5":{"tf":1.0}}},"df":7,"docs":{"22":{"tf":3.0},"28":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"43":{"tf":1.0},"56":{"tf":1.0},"63":{"tf":1.0}}},"1":{"df":2,"docs":{"27":{"tf":1.0},"28":{"tf":1.0}}},"2":{"3":{"8":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"27":{"tf":1.0},"28":{"tf":1.0}}},"3":{"2":{"7":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"27":{"tf":1.0},"28":{"tf":1.0}}},"4":{"df":1,"docs":{"28":{"tf":1.0}}},"5":{"df":1,"docs":{"28":{"tf":1.0}}},"7":{"5":{"8":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"9":{"tf":1.4142135623730951}}},"8":{"5":{"7":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"df":1,"docs":{"35":{"tf":1.0}}},"df":28,"docs":{"102":{"tf":1.0},"104":{"tf":1.7320508075688772},"105":{"tf":1.4142135623730951},"116":{"tf":1.0},"117":{"tf":1.0},"130":{"tf":1.0},"22":{"tf":2.449489742783178},"31":{"tf":1.7320508075688772},"4":{"tf":1.0},"43":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"54":{"tf":1.7320508075688772},"58":{"tf":1.0},"62":{"tf":1.7320508075688772},"63":{"tf":1.4142135623730951},"67":{"tf":1.0},"7":{"tf":1.7320508075688772},"74":{"tf":1.4142135623730951},"75":{"tf":2.6457513110645907},"82":{"tf":1.4142135623730951},"83":{"tf":1.7320508075688772},"86":{"tf":2.23606797749979},"87":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":2.449489742783178},"93":{"tf":3.605551275463989},"98":{"tf":1.0}}},"2":{"0":{"1":{"8":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"2":{"1":{"df":1,"docs":{"131":{"tf":1.0}}},"4":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"124":{"tf":1.0},"22":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"35":{"tf":1.0}}},"4":{"2":{"9":{"2":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"4":{"5":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":20,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":3.0},"25":{"tf":1.4142135623730951},"26":{"tf":2.0},"27":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0},"54":{"tf":1.0},"63":{"tf":1.4142135623730951},"7":{"tf":2.0},"70":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"75":{"tf":2.6457513110645907},"82":{"tf":1.4142135623730951},"88":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0}}},"3":{"0":{"df":1,"docs":{"124":{"tf":1.0}}},"2":{"df":2,"docs":{"7":{"tf":1.7320508075688772},"82":{"tf":1.0}}},"df":15,"docs":{"19":{"tf":1.0},"25":{"tf":1.4142135623730951},"26":{"tf":2.0},"43":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":3.3166247903554},"52":{"tf":1.0},"54":{"tf":1.0},"63":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"75":{"tf":2.0},"82":{"tf":1.0},"91":{"tf":1.0}}},"4":{"0":{"df":1,"docs":{"124":{"tf":1.0}}},"8":{"df":1,"docs":{"82":{"tf":1.0}}},"df":7,"docs":{"25":{"tf":1.0},"28":{"tf":1.0},"43":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"7":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951}},"k":{"df":1,"docs":{"82":{"tf":1.0}}}},"5":{"0":{"df":1,"docs":{"124":{"tf":1.0}}},"df":6,"docs":{"117":{"tf":1.0},"128":{"tf":1.0},"22":{"tf":2.449489742783178},"43":{"tf":1.0},"63":{"tf":1.0},"93":{"tf":1.0}}},"6":{"4":{"df":2,"docs":{"103":{"tf":1.0},"82":{"tf":1.4142135623730951}}},"df":5,"docs":{"34":{"tf":1.0},"43":{"tf":1.0},"54":{"tf":1.0},"63":{"tf":1.0},"75":{"tf":1.0}}},"7":{"df":3,"docs":{"117":{"tf":1.4142135623730951},"63":{"tf":1.0},"82":{"tf":1.0}},"u":{"8":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}}},"8":{"df":2,"docs":{"63":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"9":{"9":{"df":1,"docs":{"33":{"tf":1.0}}},"df":5,"docs":{"103":{"tf":1.0},"28":{"tf":1.0},"34":{"tf":1.0},"45":{"tf":1.0},"63":{"tf":1.0}}},"_":{"0":{"df":1,"docs":{"135":{"tf":1.4142135623730951}}},"_":{"_":{"_":{"_":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"e":{"a":{"b":{"df":0,"docs":{},"i":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"134":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"v":{"df":1,"docs":{"134":{"tf":1.0}}}}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":3,"docs":{"88":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"131":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":9,"docs":{"111":{"tf":1.0},"135":{"tf":1.0},"36":{"tf":2.0},"67":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.4142135623730951},"92":{"tf":2.23606797749979},"93":{"tf":2.449489742783178}},"i":{"df":1,"docs":{"93":{"tf":1.0}}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"131":{"tf":1.4142135623730951},"39":{"tf":1.0}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"t":{"df":2,"docs":{"40":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"p":{"a":{"d":{"1":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}},"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"134":{"tf":1.0}}}}},"df":0,"docs":{}}}},"a":{"(":{"df":0,"docs":{},"u":{"3":{"2":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},".":{"df":0,"docs":{},"k":{".":{"a":{"df":2,"docs":{"2":{"tf":1.0},"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},">":{"(":{"&":{"\'":{"a":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"&":{"\'":{"a":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"v":{"df":0,"docs":{},"e":{"c":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"<":{"\'":{"a":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"p":{"c":{"df":1,"docs":{"122":{"tf":1.0}}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"i":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"122":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":9,"docs":{"110":{"tf":1.0},"122":{"tf":2.449489742783178},"125":{"tf":1.4142135623730951},"126":{"tf":2.8284271247461903},"129":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"15":{"tf":2.0},"16":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":13,"docs":{"103":{"tf":1.0},"126":{"tf":1.4142135623730951},"129":{"tf":1.0},"130":{"tf":1.4142135623730951},"20":{"tf":1.0},"4":{"tf":1.0},"43":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.4142135623730951},"82":{"tf":1.7320508075688772},"88":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0}}}},"v":{"df":13,"docs":{"111":{"tf":1.0},"125":{"tf":1.0},"33":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"35":{"tf":1.7320508075688772},"36":{"tf":2.23606797749979},"4":{"tf":1.0},"41":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"56":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.0},"93":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"118":{"tf":1.0},"60":{"tf":1.0},"64":{"tf":1.0},"71":{"tf":1.0},"79":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":10,"docs":{"1":{"tf":1.0},"2":{"tf":1.0},"5":{"tf":1.0},"60":{"tf":1.0},"64":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"71":{"tf":1.0},"82":{"tf":1.0},"88":{"tf":1.0},"90":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"92":{"tf":1.0}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":9,"docs":{"119":{"tf":1.0},"12":{"tf":1.0},"124":{"tf":1.0},"19":{"tf":1.7320508075688772},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"41":{"tf":1.0},"61":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":25,"docs":{"103":{"tf":1.4142135623730951},"104":{"tf":1.7320508075688772},"105":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.0},"121":{"tf":1.7320508075688772},"16":{"tf":1.0},"22":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":2.6457513110645907},"36":{"tf":3.4641016151377544},"4":{"tf":1.4142135623730951},"5":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.7320508075688772},"70":{"tf":1.4142135623730951},"71":{"tf":1.0},"72":{"tf":2.23606797749979},"76":{"tf":3.605551275463989},"77":{"tf":1.7320508075688772},"78":{"tf":2.6457513110645907},"79":{"tf":1.7320508075688772},"83":{"tf":1.0},"96":{"tf":1.0}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"131":{"tf":1.0},"35":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"40":{"tf":1.0}}}}}}}},"r":{"d":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"103":{"tf":1.0},"12":{"tf":1.0},"2":{"tf":1.0},"62":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":4,"docs":{"104":{"tf":1.0},"117":{"tf":1.0},"118":{"tf":1.0},"124":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":7,"docs":{"104":{"tf":2.23606797749979},"57":{"tf":1.0},"60":{"tf":1.0},"72":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":3.605551275463989},"79":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"57":{"tf":1.0},"78":{"tf":1.0}}}}}}}},"t":{"df":2,"docs":{"3":{"tf":1.0},"48":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":41,"docs":{"11":{"tf":2.23606797749979},"15":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.4142135623730951},"41":{"tf":1.0},"43":{"tf":2.23606797749979},"46":{"tf":1.7320508075688772},"48":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.4142135623730951},"55":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"64":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"75":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":2.449489742783178},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.7320508075688772},"89":{"tf":1.7320508075688772},"9":{"tf":1.0},"91":{"tf":1.4142135623730951},"93":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"d":{"df":12,"docs":{"103":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"111":{"tf":1.0},"114":{"tf":1.0},"12":{"tf":1.0},"131":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"46":{"tf":1.0},"66":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"59":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"t":{"df":3,"docs":{"15":{"tf":1.0},"4":{"tf":1.0},"68":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"134":{"tf":1.4142135623730951}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":6,"docs":{"118":{"tf":1.0},"36":{"tf":1.0},"56":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772},"82":{"tf":2.449489742783178},"83":{"tf":1.7320508075688772}}}}}}},"df":6,"docs":{"105":{"tf":1.0},"16":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"40":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"114":{"tf":1.0}}}}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"50":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":3,"docs":{"40":{"tf":1.0},"70":{"tf":1.0},"80":{"tf":1.4142135623730951}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":4,"docs":{"125":{"tf":1.0},"54":{"tf":1.0},"80":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"120":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}}}}}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"22":{"tf":1.4142135623730951},"34":{"tf":1.0},"40":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"52":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"116":{"tf":1.0},"82":{"tf":1.0},"88":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"23":{"tf":1.0},"46":{"tf":2.0},"63":{"tf":1.0},"67":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"t":{"df":9,"docs":{"11":{"tf":1.4142135623730951},"110":{"tf":1.0},"123":{"tf":1.0},"3":{"tf":2.449489742783178},"5":{"tf":1.0},"60":{"tf":1.0},"68":{"tf":1.0},"82":{"tf":1.4142135623730951},"91":{"tf":1.0}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"23":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951}}}}}}},"o":{"df":1,"docs":{"64":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"2":{"tf":1.0},"77":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}}}}}}},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"30":{"tf":1.0},"35":{"tf":1.0}}}},"k":{"a":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{}},"l":{"a":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":4,"docs":{"46":{"tf":1.0},"67":{"tf":1.0},"7":{"tf":1.0},"75":{"tf":1.0}},"’":{"df":1,"docs":{"67":{"tf":1.0}}}}}}}}}},"i":{"a":{"df":6,"docs":{"21":{"tf":1.0},"22":{"tf":2.23606797749979},"27":{"tf":1.0},"43":{"tf":1.0},"70":{"tf":1.0},"82":{"tf":2.23606797749979}},"s":{"df":10,"docs":{"123":{"tf":1.0},"20":{"tf":2.449489742783178},"21":{"tf":2.0},"22":{"tf":3.4641016151377544},"25":{"tf":1.7320508075688772},"26":{"tf":1.0},"34":{"tf":1.0},"4":{"tf":1.0},"71":{"tf":1.0},"82":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":10,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":2.0},"18":{"tf":1.0},"56":{"tf":1.0},"7":{"tf":4.242640687119285},"72":{"tf":2.23606797749979},"82":{"tf":1.0},"9":{"tf":1.4142135623730951},"92":{"tf":1.7320508075688772}}}},"v":{"df":6,"docs":{"100":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.7320508075688772},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"92":{"tf":1.0}}}},"l":{"df":0,"docs":{},"o":{"c":{":":{":":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"82":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"87":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"84":{"tf":1.0},"88":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":3,"docs":{"84":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"82":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":1,"docs":{"82":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"(":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":4,"docs":{"82":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"95":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"59":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":24,"docs":{"10":{"tf":1.7320508075688772},"111":{"tf":1.7320508075688772},"123":{"tf":1.0},"3":{"tf":1.4142135623730951},"4":{"tf":2.23606797749979},"41":{"tf":1.0},"5":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.0},"61":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":2.449489742783178},"81":{"tf":1.7320508075688772},"82":{"tf":6.48074069840786},"83":{"tf":1.4142135623730951},"84":{"tf":1.0},"87":{"tf":2.0},"88":{"tf":2.23606797749979},"89":{"tf":1.7320508075688772},"90":{"tf":2.0},"91":{"tf":3.0},"92":{"tf":1.7320508075688772},"93":{"tf":2.0},"96":{"tf":2.0}}},"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"134":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"c":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"72":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"122":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":37,"docs":{"10":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"11":{"tf":1.4142135623730951},"120":{"tf":1.0},"124":{"tf":1.0},"129":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":1.4142135623730951},"22":{"tf":1.7320508075688772},"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":2.0},"28":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":1.7320508075688772},"36":{"tf":1.7320508075688772},"39":{"tf":1.4142135623730951},"40":{"tf":1.7320508075688772},"41":{"tf":1.0},"43":{"tf":2.0},"44":{"tf":1.0},"46":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"54":{"tf":1.0},"55":{"tf":2.23606797749979},"56":{"tf":1.4142135623730951},"58":{"tf":1.0},"59":{"tf":1.4142135623730951},"7":{"tf":2.6457513110645907},"70":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"72":{"tf":2.449489742783178},"9":{"tf":1.0},"96":{"tf":1.4142135623730951}}}}}}},"df":25,"docs":{"10":{"tf":1.0},"117":{"tf":1.0},"120":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.4142135623730951},"19":{"tf":1.0},"22":{"tf":1.7320508075688772},"23":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.4142135623730951},"30":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.7320508075688772},"40":{"tf":1.4142135623730951},"41":{"tf":1.0},"42":{"tf":2.8284271247461903},"56":{"tf":1.4142135623730951},"59":{"tf":1.0},"63":{"tf":1.0},"71":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.0},"96":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"4":{"tf":1.0},"70":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":11,"docs":{"24":{"tf":1.0},"40":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0},"56":{"tf":1.4142135623730951},"63":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":1.0},"82":{"tf":1.0},"87":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":8,"docs":{"101":{"tf":1.0},"103":{"tf":1.0},"105":{"tf":1.0},"24":{"tf":1.0},"67":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"89":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"121":{"tf":1.0}},"n":{"df":7,"docs":{"121":{"tf":1.0},"13":{"tf":1.7320508075688772},"133":{"tf":1.0},"31":{"tf":1.0},"44":{"tf":1.0},"56":{"tf":1.0},"92":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":9,"docs":{"19":{"tf":1.0},"43":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.0},"80":{"tf":1.0},"83":{"tf":1.0},"87":{"tf":1.0},"96":{"tf":1.0}}}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":16,"docs":{"126":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.4142135623730951},"23":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"67":{"tf":1.0},"7":{"tf":1.7320508075688772},"8":{"tf":1.0},"87":{"tf":1.4142135623730951},"92":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"131":{"tf":1.0},"71":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":1,"docs":{"11":{"tf":1.0}},"i":{"df":8,"docs":{"10":{"tf":1.0},"19":{"tf":1.4142135623730951},"22":{"tf":2.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"39":{"tf":1.0},"54":{"tf":2.0},"82":{"tf":2.0}}}},"z":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"d":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"125":{"tf":1.0},"14":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"75":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"23":{"tf":1.0},"34":{"tf":1.0}}},"u":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{}}},"y":{"df":2,"docs":{"44":{"tf":1.0},"67":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":3,"docs":{"23":{"tf":1.0},"24":{"tf":1.0},"7":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":17,"docs":{"103":{"tf":1.0},"120":{"tf":1.0},"2":{"tf":1.4142135623730951},"3":{"tf":1.7320508075688772},"33":{"tf":1.0},"35":{"tf":1.0},"40":{"tf":1.7320508075688772},"46":{"tf":1.0},"52":{"tf":1.0},"64":{"tf":1.4142135623730951},"68":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":2.23606797749979},"75":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"86":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"35":{"tf":1.0},"78":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"11":{"tf":1.0},"67":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"131":{"tf":1.0},"67":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":9,"docs":{"10":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":1.4142135623730951},"52":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0},"68":{"tf":1.4142135623730951},"71":{"tf":1.0},"96":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":7,"docs":{"2":{"tf":1.0},"60":{"tf":1.0},"68":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.4142135623730951},"89":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"29":{"tf":1.0},"56":{"tf":1.0},"7":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"i":{"df":19,"docs":{"1":{"tf":1.0},"11":{"tf":1.4142135623730951},"110":{"tf":1.0},"111":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"135":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"4":{"tf":1.0},"43":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.7320508075688772},"63":{"tf":1.7320508075688772},"64":{"tf":1.4142135623730951},"69":{"tf":1.0},"82":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"23":{"tf":1.0}}}}}}}}},"p":{"df":1,"docs":{"135":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"72":{"tf":1.0}}},"r":{"df":5,"docs":{"135":{"tf":1.0},"29":{"tf":1.0},"40":{"tf":1.0},"52":{"tf":1.0},"62":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"c":{"df":5,"docs":{"135":{"tf":2.449489742783178},"14":{"tf":1.0},"2":{"tf":1.0},"64":{"tf":1.4142135623730951},"82":{"tf":1.0}}},"df":12,"docs":{"122":{"tf":1.0},"123":{"tf":1.4142135623730951},"125":{"tf":1.0},"135":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":1.4142135623730951},"36":{"tf":1.0},"40":{"tf":1.0},"59":{"tf":1.0}}},"y":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"125":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":6,"docs":{"1":{"tf":1.0},"122":{"tf":1.0},"126":{"tf":1.0},"56":{"tf":1.0},"69":{"tf":1.0},"79":{"tf":1.0}}}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":3,"docs":{"39":{"tf":1.0},"40":{"tf":1.0},"7":{"tf":1.0}}}}}}}}},"r":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":10,"docs":{"103":{"tf":1.0},"3":{"tf":1.4142135623730951},"35":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.4142135623730951},"52":{"tf":1.0},"56":{"tf":1.4142135623730951},"59":{"tf":1.0},"82":{"tf":1.0},"89":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"4":{"tf":1.0},"43":{"tf":1.0},"59":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"c":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"c":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"78":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"0":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"<":{"&":{"\'":{"a":{"df":1,"docs":{"96":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"96":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"c":{"<":{"df":0,"docs":{},"u":{"3":{"2":{"df":1,"docs":{"99":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":8,"docs":{"101":{"tf":1.0},"102":{"tf":2.23606797749979},"103":{"tf":1.4142135623730951},"104":{"tf":1.0},"105":{"tf":3.0},"96":{"tf":1.7320508075688772},"98":{"tf":1.7320508075688772},"99":{"tf":1.4142135623730951}}}},"df":13,"docs":{"100":{"tf":1.7320508075688772},"101":{"tf":1.7320508075688772},"102":{"tf":1.7320508075688772},"103":{"tf":3.1622776601683795},"104":{"tf":2.0},"105":{"tf":1.7320508075688772},"70":{"tf":1.0},"94":{"tf":2.0},"95":{"tf":2.0},"96":{"tf":2.6457513110645907},"97":{"tf":1.7320508075688772},"98":{"tf":2.23606797749979},"99":{"tf":2.449489742783178}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"122":{"tf":1.0},"17":{"tf":1.0},"91":{"tf":1.0}}}}}},"df":0,"docs":{}}},"v":{"df":1,"docs":{"119":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":4,"docs":{"100":{"tf":1.4142135623730951},"103":{"tf":1.0},"104":{"tf":1.7320508075688772},"105":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"<":{"df":0,"docs":{},"t":{"df":5,"docs":{"101":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"96":{"tf":2.23606797749979},"98":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"’":{"df":1,"docs":{"96":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":10,"docs":{"110":{"tf":1.0},"14":{"tf":1.4142135623730951},"22":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":1.0},"35":{"tf":1.0},"48":{"tf":1.0},"58":{"tf":1.0},"71":{"tf":1.7320508075688772},"91":{"tf":1.0}}}}}},"g":{"df":2,"docs":{"131":{"tf":2.0},"29":{"tf":1.4142135623730951}},"s":{"<":{"\'":{"a":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":2,"docs":{"71":{"tf":1.0},"82":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":10,"docs":{"110":{"tf":1.4142135623730951},"124":{"tf":1.4142135623730951},"129":{"tf":1.0},"131":{"tf":1.0},"22":{"tf":1.0},"29":{"tf":1.0},"34":{"tf":2.6457513110645907},"35":{"tf":1.0},"40":{"tf":1.0},"56":{"tf":1.4142135623730951}}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}}}}}},"m":{"df":2,"docs":{"17":{"tf":1.0},"75":{"tf":1.0}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":14,"docs":{"10":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.0},"34":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"56":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"96":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}}}}},"a":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"(":{"0":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"[":{"0":{"df":1,"docs":{"46":{"tf":2.0}}},"df":0,"docs":{}},"df":12,"docs":{"10":{"tf":1.0},"18":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":2.0},"5":{"tf":1.0},"56":{"tf":4.0},"65":{"tf":1.0},"7":{"tf":1.7320508075688772},"82":{"tf":1.7320508075688772},"85":{"tf":1.0},"87":{"tf":1.7320508075688772},"9":{"tf":1.0}}}},"df":1,"docs":{"5":{"tf":1.4142135623730951}}},"t":{"df":1,"docs":{"1":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"109":{"tf":1.0},"119":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"82":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"s":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"100":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":2,"docs":{"19":{"tf":1.0},"24":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},":":{":":{"<":{"\'":{"d":{">":{"(":{"&":{"\'":{"d":{"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"<":{"\'":{"a":{">":{"(":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"24":{"tf":1.4142135623730951}}}}}},"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":2,"docs":{"68":{"tf":1.0},"71":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"k":{"df":4,"docs":{"16":{"tf":1.0},"75":{"tf":1.4142135623730951},"82":{"tf":1.0},"84":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"34":{"tf":1.0},"56":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"!":{"(":{"!":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"d":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"&":{"d":{"df":1,"docs":{"111":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":2,"docs":{"86":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"129":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{":":{":":{"<":{"df":0,"docs":{},"t":{"df":4,"docs":{"82":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"d":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"s":{"df":2,"docs":{"88":{"tf":1.0},"91":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"(":{"&":{"c":{"df":1,"docs":{"111":{"tf":1.0}}},"d":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"111":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"d":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"&":{"c":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"c":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"!":{"(":{"0":{"df":1,"docs":{"93":{"tf":1.7320508075688772}}},"1":{"0":{"df":1,"docs":{"93":{"tf":1.0}}},"6":{"df":1,"docs":{"16":{"tf":1.0}}},"df":1,"docs":{"93":{"tf":2.23606797749979}}},"5":{"df":1,"docs":{"93":{"tf":1.0}}},"8":{"df":1,"docs":{"16":{"tf":1.0}}},"9":{"df":1,"docs":{"93":{"tf":1.4142135623730951}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"2":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"!":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{":":{":":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"129":{"tf":1.0}}}}}}}},"df":1,"docs":{"129":{"tf":1.0}}}}}}}}}},"df":3,"docs":{"36":{"tf":1.7320508075688772},"72":{"tf":1.7320508075688772},"82":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"t":{">":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.7320508075688772}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":10,"docs":{"22":{"tf":1.0},"29":{"tf":1.4142135623730951},"34":{"tf":2.0},"4":{"tf":1.0},"54":{"tf":1.7320508075688772},"55":{"tf":2.0},"56":{"tf":2.0},"58":{"tf":1.4142135623730951},"63":{"tf":1.0},"74":{"tf":1.4142135623730951}}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":5,"docs":{"100":{"tf":1.0},"39":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"89":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":18,"docs":{"1":{"tf":1.7320508075688772},"103":{"tf":1.0},"110":{"tf":1.0},"114":{"tf":1.0},"123":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":1.0},"71":{"tf":1.0},"82":{"tf":1.4142135623730951},"96":{"tf":1.0}},"p":{"df":0,"docs":{},"t":{"df":11,"docs":{"103":{"tf":1.0},"123":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.0},"62":{"tf":1.0},"76":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"n":{"c":{"df":1,"docs":{"69":{"tf":1.0}},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"118":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":14,"docs":{"103":{"tf":2.8284271247461903},"104":{"tf":1.4142135623730951},"105":{"tf":1.0},"70":{"tf":2.0},"73":{"tf":2.23606797749979},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":2.0},"77":{"tf":2.0},"78":{"tf":1.7320508075688772},"79":{"tf":1.7320508075688772},"94":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.0}},"i":{"c":{":":{":":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"96":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{":":{":":{"a":{"c":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"104":{"tf":1.4142135623730951},"105":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":4,"docs":{"103":{"tf":1.0},"105":{"tf":1.4142135623730951},"70":{"tf":1.0},"96":{"tf":1.0}},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"1":{"df":3,"docs":{"102":{"tf":1.0},"105":{"tf":1.0},"98":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":5,"docs":{"134":{"tf":1.0},"53":{"tf":1.0},"6":{"tf":1.0},"68":{"tf":1.0},"76":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":8,"docs":{"110":{"tf":1.0},"114":{"tf":1.0},"119":{"tf":1.4142135623730951},"123":{"tf":1.0},"134":{"tf":1.0},"135":{"tf":1.0},"36":{"tf":2.6457513110645907},"40":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"u":{"d":{"a":{"c":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"2":{"tf":1.0},"5":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"2":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0},"92":{"tf":1.0}}}}},"o":{"df":5,"docs":{"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"46":{"tf":1.4142135623730951}},"m":{"a":{"df":0,"docs":{},"t":{"df":5,"docs":{"3":{"tf":1.7320508075688772},"33":{"tf":1.0},"46":{"tf":1.0},"59":{"tf":1.4142135623730951},"71":{"tf":2.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"46":{"tf":2.23606797749979}}}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"119":{"tf":1.4142135623730951},"123":{"tf":1.0},"134":{"tf":1.0},"82":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"36":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"i":{"d":{"df":12,"docs":{"17":{"tf":1.0},"19":{"tf":1.0},"22":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"36":{"tf":1.0},"4":{"tf":1.0},"43":{"tf":1.0},"52":{"tf":1.0},"66":{"tf":1.0},"82":{"tf":1.0},"89":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.0}}},"y":{"df":6,"docs":{"19":{"tf":1.0},"56":{"tf":1.0},"63":{"tf":1.0},"68":{"tf":1.0},"75":{"tf":1.0},"96":{"tf":1.0}}}},"df":3,"docs":{"1":{"tf":1.0},"23":{"tf":1.0},"76":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"121":{"tf":1.0}}}}}}},"’":{"df":2,"docs":{"34":{"tf":1.0},"78":{"tf":1.0}}}},"b":{"(":{"df":0,"docs":{},"u":{"6":{"4":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"a":{"c":{"df":0,"docs":{},"k":{"df":12,"docs":{"1":{"tf":1.0},"116":{"tf":1.4142135623730951},"19":{"tf":1.0},"28":{"tf":1.0},"33":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.7320508075688772},"61":{"tf":1.0},"75":{"tf":1.0},"82":{"tf":1.4142135623730951},"87":{"tf":1.0},"92":{"tf":1.0}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"87":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"d":{"df":10,"docs":{"103":{"tf":1.0},"131":{"tf":1.0},"25":{"tf":1.0},"34":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"62":{"tf":1.4142135623730951},"65":{"tf":1.0},"73":{"tf":1.0},"82":{"tf":2.23606797749979}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"67":{"tf":1.0}}}},"k":{"df":0,"docs":{},"e":{"df":2,"docs":{"4":{"tf":1.0},"9":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"3":{"tf":1.0},"59":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"r":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"131":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"f":{"3":{"2":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"131":{"tf":1.0}}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"131":{"tf":1.0}}},"df":0,"docs":{}}}}},".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{}},":":{":":{"df":0,"docs":{},"x":{"(":{"0":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"46":{"tf":2.23606797749979}}}}}},"df":0,"docs":{}},"df":6,"docs":{"119":{"tf":1.4142135623730951},"131":{"tf":2.449489742783178},"22":{"tf":1.0},"44":{"tf":1.7320508075688772},"46":{"tf":1.0},"58":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{".":{"a":{"d":{"d":{"(":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"56":{"tf":1.0}}}}}},"df":18,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"11":{"tf":1.0},"3":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.7320508075688772},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"7":{"tf":1.0},"95":{"tf":1.0},"97":{"tf":1.7320508075688772},"98":{"tf":1.0},"99":{"tf":1.0}}},"i":{"c":{"df":24,"docs":{"1":{"tf":1.4142135623730951},"10":{"tf":1.0},"103":{"tf":1.4142135623730951},"104":{"tf":1.0},"116":{"tf":1.0},"119":{"tf":1.0},"123":{"tf":1.0},"24":{"tf":1.0},"3":{"tf":1.4142135623730951},"31":{"tf":1.0},"43":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"67":{"tf":1.0},"73":{"tf":1.0},"78":{"tf":1.0},"82":{"tf":1.0},"89":{"tf":1.0},"92":{"tf":1.4142135623730951},"97":{"tf":1.0}}},"df":0,"docs":{}}},"z":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":20,"docs":{"104":{"tf":1.0},"111":{"tf":1.0},"128":{"tf":1.7320508075688772},"23":{"tf":3.4641016151377544},"24":{"tf":2.0},"25":{"tf":2.6457513110645907},"27":{"tf":1.0},"29":{"tf":1.4142135623730951},"31":{"tf":2.23606797749979},"32":{"tf":1.7320508075688772},"33":{"tf":1.7320508075688772},"34":{"tf":4.898979485566356},"35":{"tf":1.4142135623730951},"36":{"tf":2.23606797749979},"43":{"tf":3.0},"44":{"tf":1.4142135623730951},"56":{"tf":1.0},"58":{"tf":1.4142135623730951},"7":{"tf":3.1622776601683795},"78":{"tf":1.7320508075688772}},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":16,"docs":{"103":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.4142135623730951},"29":{"tf":1.0},"30":{"tf":1.4142135623730951},"34":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"59":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"7":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.0}}}}},"df":22,"docs":{"103":{"tf":1.4142135623730951},"131":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"26":{"tf":1.0},"36":{"tf":1.0},"41":{"tf":1.4142135623730951},"43":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.4142135623730951},"73":{"tf":1.0},"82":{"tf":1.4142135623730951},"84":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":25,"docs":{"103":{"tf":1.0},"104":{"tf":2.6457513110645907},"19":{"tf":1.0},"22":{"tf":1.7320508075688772},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"26":{"tf":1.0},"28":{"tf":1.0},"34":{"tf":1.0},"41":{"tf":1.7320508075688772},"43":{"tf":1.0},"46":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.4142135623730951},"77":{"tf":1.4142135623730951},"78":{"tf":2.23606797749979},"79":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"91":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"53":{"tf":1.0},"78":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":8,"docs":{"119":{"tf":1.0},"12":{"tf":1.0},"3":{"tf":1.7320508075688772},"60":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":30,"docs":{"10":{"tf":1.0},"103":{"tf":1.0},"11":{"tf":2.23606797749979},"125":{"tf":1.0},"126":{"tf":1.4142135623730951},"131":{"tf":1.4142135623730951},"135":{"tf":2.0},"14":{"tf":2.0},"17":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":2.23606797749979},"32":{"tf":1.0},"4":{"tf":2.8284271247461903},"40":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.4142135623730951},"52":{"tf":2.23606797749979},"53":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"64":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"82":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":7,"docs":{"122":{"tf":1.0},"3":{"tf":1.0},"36":{"tf":1.0},"46":{"tf":1.0},"71":{"tf":1.0},"82":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"60":{"tf":1.0}}}}},"l":{"df":1,"docs":{"85":{"tf":1.0}}},"o":{"df":0,"docs":{},"w":{"df":9,"docs":{"103":{"tf":1.0},"114":{"tf":1.0},"133":{"tf":1.4142135623730951},"135":{"tf":1.0},"23":{"tf":1.0},"36":{"tf":1.0},"4":{"tf":1.0},"56":{"tf":1.0},"9":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"132":{"tf":1.7320508075688772},"133":{"tf":1.0},"134":{"tf":1.0},"135":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"2":{"tf":1.0},"3":{"tf":1.0},"61":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"118":{"tf":1.0},"72":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":8,"docs":{"14":{"tf":1.0},"44":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"74":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"94":{"tf":1.0}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":8,"docs":{"1":{"tf":1.0},"131":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"72":{"tf":1.0},"77":{"tf":1.0},"88":{"tf":1.0},"94":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":10,"docs":{"131":{"tf":1.0},"15":{"tf":1.0},"3":{"tf":2.23606797749979},"32":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.0},"61":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"g":{"df":4,"docs":{"25":{"tf":1.0},"30":{"tf":1.0},"35":{"tf":1.0},"6":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"19":{"tf":1.0},"22":{"tf":1.0},"4":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"103":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":7,"docs":{"119":{"tf":1.0},"132":{"tf":1.0},"134":{"tf":1.0},"135":{"tf":1.0},"14":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0}}},"y":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"p":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"d":{"df":3,"docs":{"100":{"tf":1.0},"107":{"tf":1.0},"110":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"df":0,"docs":{}},"t":{"df":24,"docs":{"103":{"tf":1.0},"131":{"tf":1.0},"2":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"31":{"tf":1.0},"34":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":2.23606797749979},"52":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":2.0},"58":{"tf":1.4142135623730951},"6":{"tf":1.0},"67":{"tf":1.0},"7":{"tf":2.0},"75":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":2.8284271247461903},"83":{"tf":1.7320508075688772},"89":{"tf":1.0},"9":{"tf":1.0}},"e":{"df":1,"docs":{"67":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"34":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"73":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"58":{"tf":1.0},"68":{"tf":1.0},"83":{"tf":1.0}}}}},"df":0,"docs":{}}},"o":{"c":{"df":0,"docs":{},"k":{"df":12,"docs":{"110":{"tf":1.4142135623730951},"111":{"tf":1.4142135623730951},"119":{"tf":1.4142135623730951},"120":{"tf":2.449489742783178},"121":{"tf":1.0},"122":{"tf":1.4142135623730951},"128":{"tf":1.4142135623730951},"3":{"tf":1.0},"5":{"tf":1.0},"63":{"tf":1.7320508075688772},"69":{"tf":1.0},"82":{"tf":1.0}}}},"df":0,"docs":{},"w":{"df":4,"docs":{"24":{"tf":1.0},"27":{"tf":1.0},"59":{"tf":1.0},"67":{"tf":1.0}},"n":{"df":1,"docs":{"59":{"tf":1.0}}}}}},"o":{"d":{"df":0,"docs":{},"i":{"df":4,"docs":{"23":{"tf":1.0},"31":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"52":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"3":{"tf":1.0},"58":{"tf":1.0},"76":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"59":{"tf":1.0}}}}}}}},"m":{"b":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"k":{"df":8,"docs":{"0":{"tf":1.0},"1":{"tf":2.6457513110645907},"109":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"52":{"tf":1.0},"6":{"tf":1.0},"73":{"tf":1.4142135623730951}}},"l":{"df":7,"docs":{"111":{"tf":1.0},"26":{"tf":1.0},"4":{"tf":1.0},"48":{"tf":1.0},"52":{"tf":1.4142135623730951},"56":{"tf":2.23606797749979},"58":{"tf":1.0}}},"n":{"df":1,"docs":{"19":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"104":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"43":{"tf":2.23606797749979}}}},"df":15,"docs":{"123":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":3.0},"27":{"tf":2.449489742783178},"28":{"tf":3.1622776601683795},"32":{"tf":1.0},"34":{"tf":2.0},"35":{"tf":4.358898943540674},"36":{"tf":2.0},"43":{"tf":3.0},"63":{"tf":1.7320508075688772},"72":{"tf":2.23606797749979},"89":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"h":{"df":7,"docs":{"119":{"tf":1.0},"121":{"tf":1.0},"125":{"tf":1.0},"2":{"tf":1.0},"35":{"tf":1.0},"87":{"tf":1.0},"89":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"84":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"24":{"tf":1.0},"58":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":12,"docs":{"119":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":2.0},"129":{"tf":1.4142135623730951},"14":{"tf":2.0},"23":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.4142135623730951},"5":{"tf":1.0},"64":{"tf":1.0},"68":{"tf":1.0},"99":{"tf":1.0}}}}},"df":15,"docs":{"3":{"tf":1.4142135623730951},"30":{"tf":2.449489742783178},"31":{"tf":2.449489742783178},"34":{"tf":1.0},"39":{"tf":1.0},"45":{"tf":1.4142135623730951},"5":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":1.0},"70":{"tf":1.7320508075688772},"82":{"tf":1.0},"86":{"tf":1.4142135623730951},"89":{"tf":1.0},"93":{"tf":1.4142135623730951},"99":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"x":{"\'":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}},":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"104":{"tf":1.4142135623730951},"105":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"104":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"df":3,"docs":{"102":{"tf":1.0},"105":{"tf":1.0},"98":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"\\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}},"0":{"df":3,"docs":{"54":{"tf":1.4142135623730951},"55":{"tf":2.6457513110645907},"63":{"tf":1.0}}},"1":{"df":4,"docs":{"35":{"tf":2.0},"36":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0}}},"5":{"df":1,"docs":{"128":{"tf":1.0}}},"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":3,"docs":{"102":{"tf":1.0},"105":{"tf":1.0},"98":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":1,"docs":{"56":{"tf":1.0}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"<":{"&":{"\'":{"b":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"[":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":2.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}},"t":{"df":6,"docs":{"123":{"tf":1.0},"125":{"tf":1.0},"34":{"tf":1.4142135623730951},"59":{"tf":3.0},"7":{"tf":1.0},"72":{"tf":1.0}}},"u":{"3":{"2":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"8":{"df":3,"docs":{"35":{"tf":2.0},"36":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":17,"docs":{"102":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"123":{"tf":1.0},"125":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":1.4142135623730951},"4":{"tf":1.7320508075688772},"54":{"tf":1.4142135623730951},"56":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":2.0},"62":{"tf":1.0},"63":{"tf":1.0},"72":{"tf":1.7320508075688772},"98":{"tf":1.4142135623730951}},"y":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}},"df":0,"docs":{}},"’":{"df":1,"docs":{"59":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":6,"docs":{"22":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"54":{"tf":2.449489742783178},"55":{"tf":1.4142135623730951},"91":{"tf":1.0},"93":{"tf":1.0}}}},"d":{"df":2,"docs":{"43":{"tf":1.0},"54":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":7,"docs":{"123":{"tf":1.0},"34":{"tf":1.0},"4":{"tf":1.0},"54":{"tf":1.7320508075688772},"56":{"tf":1.0},"67":{"tf":1.4142135623730951},"90":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}}}}}},"df":0,"docs":{}},"i":{"d":{"df":0,"docs":{},"g":{"df":3,"docs":{"14":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"46":{"tf":1.0}}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"80":{"tf":1.0}}}}},"o":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"65":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"78":{"tf":1.0}},"n":{"df":1,"docs":{"3":{"tf":1.7320508075688772}}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"3":{"tf":3.3166247903554}},"’":{"df":1,"docs":{"3":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"u":{"b":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"67":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"67":{"tf":2.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{".":{"c":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"88":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{")":{".":{"a":{"d":{"d":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"88":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"88":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":4,"docs":{"87":{"tf":1.4142135623730951},"88":{"tf":2.449489742783178},"89":{"tf":1.4142135623730951},"93":{"tf":2.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"110":{"tf":1.0},"111":{"tf":1.7320508075688772},"41":{"tf":1.7320508075688772},"84":{"tf":1.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951}}}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"<":{"\'":{"_":{"df":1,"docs":{"29":{"tf":1.0}}},"a":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"g":{"df":3,"docs":{"19":{"tf":1.0},"34":{"tf":1.0},"92":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"73":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":2,"docs":{"131":{"tf":1.0},"3":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"l":{"d":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"109":{"tf":2.0}}}},"df":12,"docs":{"109":{"tf":2.449489742783178},"114":{"tf":1.0},"119":{"tf":1.4142135623730951},"132":{"tf":1.0},"133":{"tf":1.0},"134":{"tf":1.7320508075688772},"135":{"tf":1.4142135623730951},"3":{"tf":1.0},"44":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":4,"docs":{"19":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0},"58":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"5":{"tf":1.0},"67":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"103":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"119":{"tf":1.0}}}}},"df":0,"docs":{},"n":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"91":{"tf":1.0}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"3":{"tf":1.0},"66":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":12,"docs":{"110":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":1.0},"4":{"tf":1.7320508075688772},"52":{"tf":1.0},"56":{"tf":1.0},"7":{"tf":1.4142135623730951},"82":{"tf":2.6457513110645907},"88":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951},"92":{"tf":1.0},"93":{"tf":1.4142135623730951}}}}}},"c":{"(":{"df":0,"docs":{},"u":{"8":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}},"+":{"+":{"1":{"1":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}},"2":{"0":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"’":{"df":2,"docs":{"126":{"tf":1.0},"58":{"tf":1.0}}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"h":{"df":1,"docs":{"107":{"tf":1.0}}}},"/":{"c":{"+":{"+":{"1":{"1":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"119":{"tf":1.4142135623730951},"73":{"tf":1.0}}},"df":0,"docs":{}},"1":{"1":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}},"2":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}},"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"134":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"110":{"tf":2.0},"111":{"tf":3.1622776601683795},"125":{"tf":3.1622776601683795},"134":{"tf":1.7320508075688772},"72":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"131":{"tf":1.0},"72":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"18":{"tf":1.0},"22":{"tf":1.4142135623730951},"75":{"tf":2.0}},"e":{"d":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.7320508075688772}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"<":{"\'":{"a":{">":{"(":{"&":{"\'":{"a":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{".":{"c":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":1,"docs":{"115":{"tf":1.4142135623730951}}}}}}},"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"116":{"tf":1.0}}}},"df":0,"docs":{}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"(":{"&":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"7":{"df":1,"docs":{"116":{"tf":1.0}}},"a":{"df":1,"docs":{"116":{"tf":1.0}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"_":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":5,"docs":{"116":{"tf":3.0},"117":{"tf":3.0},"118":{"tf":3.605551275463989},"125":{"tf":1.7320508075688772},"36":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":54,"docs":{"100":{"tf":1.4142135623730951},"102":{"tf":1.0},"105":{"tf":1.0},"107":{"tf":1.0},"110":{"tf":2.0},"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.7320508075688772},"114":{"tf":1.7320508075688772},"115":{"tf":1.4142135623730951},"116":{"tf":2.449489742783178},"117":{"tf":1.7320508075688772},"118":{"tf":1.4142135623730951},"12":{"tf":1.0},"120":{"tf":1.4142135623730951},"122":{"tf":2.449489742783178},"125":{"tf":1.7320508075688772},"127":{"tf":1.4142135623730951},"128":{"tf":1.0},"129":{"tf":1.0},"131":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.4142135623730951},"22":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"34":{"tf":2.0},"35":{"tf":1.0},"36":{"tf":2.23606797749979},"4":{"tf":1.7320508075688772},"41":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":4.0},"5":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"63":{"tf":1.0},"64":{"tf":1.7320508075688772},"65":{"tf":1.4142135623730951},"69":{"tf":1.0},"72":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":2.0},"87":{"tf":1.4142135623730951},"89":{"tf":1.0},"92":{"tf":1.4142135623730951},"98":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"116":{"tf":1.0},"34":{"tf":1.0},"65":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"e":{"df":2,"docs":{"64":{"tf":1.0},"82":{"tf":1.0}}}},"n":{"\'":{"df":0,"docs":{},"t":{"df":11,"docs":{"56":{"tf":1.4142135623730951},"66":{"tf":1.0},"70":{"tf":1.4142135623730951},"72":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.7320508075688772},"9":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.4142135623730951}}}},"d":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":21,"docs":{"104":{"tf":1.0},"123":{"tf":1.0},"131":{"tf":1.0},"22":{"tf":1.7320508075688772},"24":{"tf":1.0},"3":{"tf":2.449489742783178},"31":{"tf":1.0},"34":{"tf":1.0},"46":{"tf":1.7320508075688772},"48":{"tf":1.0},"52":{"tf":1.7320508075688772},"60":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"72":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"82":{"tf":2.449489742783178},"83":{"tf":1.0},"87":{"tf":1.0}}}}},"p":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"88":{"tf":1.0},"93":{"tf":1.0}}}}}}},"df":0,"docs":{}},"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"35":{"tf":1.0},"36":{"tf":1.0}}}},"c":{"df":5,"docs":{"111":{"tf":1.7320508075688772},"5":{"tf":1.7320508075688772},"66":{"tf":1.4142135623730951},"91":{"tf":1.7320508075688772},"93":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":9,"docs":{"40":{"tf":1.7320508075688772},"41":{"tf":1.0},"5":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"82":{"tf":2.8284271247461903},"87":{"tf":2.0},"88":{"tf":1.7320508075688772},"91":{"tf":1.4142135623730951},"93":{"tf":1.7320508075688772}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"70":{"tf":1.4142135623730951},"71":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":26,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"121":{"tf":1.0},"2":{"tf":1.7320508075688772},"22":{"tf":1.4142135623730951},"27":{"tf":1.0},"3":{"tf":1.7320508075688772},"31":{"tf":1.0},"35":{"tf":1.7320508075688772},"4":{"tf":1.0},"41":{"tf":1.4142135623730951},"54":{"tf":1.0},"56":{"tf":1.4142135623730951},"58":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.4142135623730951},"65":{"tf":1.7320508075688772},"68":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.7320508075688772},"93":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"56":{"tf":1.0}}}}}}}},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":4,"docs":{"108":{"tf":1.0},"109":{"tf":1.0},"114":{"tf":1.0},"133":{"tf":1.0}}}}}}},"df":3,"docs":{"109":{"tf":1.0},"114":{"tf":1.0},"135":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"df":0,"docs":{},"t":{">":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"d":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":2.23606797749979}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"72":{"tf":3.3166247903554}}}},"df":1,"docs":{"72":{"tf":3.872983346207417}}}}}},"s":{"df":0,"docs":{},"e":{"df":49,"docs":{"103":{"tf":1.0},"11":{"tf":1.4142135623730951},"110":{"tf":1.0},"112":{"tf":1.0},"118":{"tf":1.0},"119":{"tf":1.7320508075688772},"125":{"tf":1.4142135623730951},"17":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":2.0},"38":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":2.8284271247461903},"43":{"tf":1.7320508075688772},"45":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0},"55":{"tf":1.7320508075688772},"56":{"tf":1.4142135623730951},"58":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":1.4142135623730951},"64":{"tf":1.0},"65":{"tf":1.4142135623730951},"66":{"tf":1.0},"7":{"tf":2.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"72":{"tf":1.0},"78":{"tf":1.4142135623730951},"8":{"tf":1.0},"82":{"tf":2.449489742783178},"84":{"tf":1.4142135623730951},"86":{"tf":1.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0}}},"t":{"df":7,"docs":{"47":{"tf":3.1622776601683795},"48":{"tf":3.0},"49":{"tf":1.7320508075688772},"50":{"tf":2.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"92":{"tf":1.4142135623730951}}}},"t":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":2,"docs":{"61":{"tf":1.0},"64":{"tf":1.0}}}}}}}}},"c":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"126":{"tf":1.0},"127":{"tf":1.0},"130":{"tf":2.0},"64":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":6,"docs":{"126":{"tf":1.4142135623730951},"128":{"tf":1.0},"130":{"tf":1.7320508075688772},"19":{"tf":1.0},"36":{"tf":1.0},"64":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.0}},"i":{"df":1,"docs":{"75":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.7320508075688772}}}}},"s":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"73":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.7320508075688772}}}},"df":25,"docs":{"103":{"tf":1.0},"126":{"tf":1.7320508075688772},"16":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":1.7320508075688772},"30":{"tf":1.0},"34":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"53":{"tf":1.0},"56":{"tf":1.7320508075688772},"61":{"tf":1.0},"64":{"tf":1.4142135623730951},"65":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.7320508075688772},"71":{"tf":1.4142135623730951},"82":{"tf":1.7320508075688772},"92":{"tf":1.0},"99":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}}}},"b":{"(":{"7":{"df":1,"docs":{"116":{"tf":1.0}}},"c":{"b":{"_":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":2,"docs":{"116":{"tf":1.4142135623730951},"117":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"115":{"tf":1.0},"14":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"122":{"tf":1.0}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":2,"docs":{"114":{"tf":1.0},"135":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":44,"docs":{"107":{"tf":1.4142135623730951},"108":{"tf":1.0},"110":{"tf":2.0},"111":{"tf":2.0},"113":{"tf":1.7320508075688772},"114":{"tf":2.0},"115":{"tf":2.23606797749979},"116":{"tf":2.6457513110645907},"117":{"tf":2.6457513110645907},"118":{"tf":2.0},"122":{"tf":2.23606797749979},"123":{"tf":2.0},"124":{"tf":1.0},"125":{"tf":3.7416573867739413},"126":{"tf":1.0},"127":{"tf":2.449489742783178},"128":{"tf":3.3166247903554},"129":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":2.23606797749979},"134":{"tf":1.0},"14":{"tf":4.0},"16":{"tf":1.7320508075688772},"19":{"tf":2.0},"2":{"tf":2.6457513110645907},"23":{"tf":2.23606797749979},"24":{"tf":1.0},"25":{"tf":1.7320508075688772},"27":{"tf":2.0},"31":{"tf":1.0},"34":{"tf":2.0},"4":{"tf":1.4142135623730951},"43":{"tf":2.0},"54":{"tf":1.4142135623730951},"56":{"tf":1.0},"58":{"tf":1.7320508075688772},"59":{"tf":2.23606797749979},"64":{"tf":1.0},"7":{"tf":2.23606797749979},"72":{"tf":1.4142135623730951},"73":{"tf":2.0},"76":{"tf":1.4142135623730951},"87":{"tf":1.0},"90":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"<":{"df":0,"docs":{},"g":{"df":1,"docs":{"34":{"tf":1.0}}},"h":{"df":1,"docs":{"34":{"tf":1.0}}},"t":{"df":1,"docs":{"34":{"tf":1.4142135623730951}}}},"df":1,"docs":{"71":{"tf":1.0}}}},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"125":{"tf":1.4142135623730951},"14":{"tf":1.0},"18":{"tf":1.0},"45":{"tf":1.0},"52":{"tf":1.0},"76":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"36":{"tf":1.0},"59":{"tf":1.4142135623730951},"68":{"tf":1.0},"77":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"g":{"(":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"df":1,"docs":{"122":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"i":{"df":2,"docs":{"40":{"tf":1.0},"41":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"_":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"135":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"125":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"(":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"_":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"135":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"134":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"111":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"134":{"tf":1.0}}}}}}},"df":1,"docs":{"82":{"tf":1.0}}}},"h":{"a":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"3":{"tf":1.0},"70":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":19,"docs":{"122":{"tf":1.0},"19":{"tf":1.0},"26":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.4142135623730951},"5":{"tf":1.7320508075688772},"52":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.7320508075688772},"70":{"tf":1.4142135623730951},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.0},"96":{"tf":1.0}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"118":{"tf":1.0}}}}}},"o":{"df":2,"docs":{"52":{"tf":1.0},"73":{"tf":1.0}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":8,"docs":{"21":{"tf":1.0},"23":{"tf":1.0},"33":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"6":{"tf":1.7320508075688772},"81":{"tf":1.7320508075688772},"94":{"tf":1.0},"96":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"75":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"79":{"tf":1.0}}}}},"t":{"df":1,"docs":{"67":{"tf":1.0}}}},"c":{"df":0,"docs":{},"k":{"df":31,"docs":{"0":{"tf":1.0},"103":{"tf":1.0},"110":{"tf":1.0},"115":{"tf":1.0},"123":{"tf":1.0},"3":{"tf":2.449489742783178},"35":{"tf":2.0},"36":{"tf":1.7320508075688772},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":2.0},"45":{"tf":1.0},"46":{"tf":2.0},"5":{"tf":1.0},"52":{"tf":1.4142135623730951},"53":{"tf":1.0},"54":{"tf":1.7320508075688772},"55":{"tf":1.0},"62":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.7320508075688772},"72":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.7320508075688772},"82":{"tf":1.7320508075688772},"83":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":11,"docs":{"23":{"tf":1.0},"35":{"tf":3.1622776601683795},"36":{"tf":1.0},"38":{"tf":1.7320508075688772},"40":{"tf":1.4142135623730951},"41":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0},"56":{"tf":1.0},"72":{"tf":1.7320508075688772},"96":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"63":{"tf":1.0}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"p":{"df":1,"docs":{"17":{"tf":1.0}}}},"o":{"df":0,"docs":{},"i":{"c":{"df":5,"docs":{"10":{"tf":1.0},"3":{"tf":1.4142135623730951},"31":{"tf":1.0},"59":{"tf":1.0},"77":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"111":{"tf":1.0},"68":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"14":{"tf":1.0},"82":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":2,"docs":{"3":{"tf":1.0},"86":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"34":{"tf":1.0},"61":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"59":{"tf":1.0}},"i":{"c":{"df":5,"docs":{"118":{"tf":1.0},"34":{"tf":1.0},"41":{"tf":1.0},"59":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":5,"docs":{"57":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.0}}},"r":{"df":3,"docs":{"24":{"tf":1.0},"34":{"tf":1.0},"46":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":6,"docs":{"19":{"tf":1.0},"24":{"tf":1.0},"27":{"tf":1.0},"34":{"tf":1.0},"43":{"tf":1.0},"61":{"tf":1.0}}}}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"82":{"tf":1.0}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{}},"o":{".":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"31":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"64":{"tf":1.0}}}}},"df":0,"docs":{}},"df":1,"docs":{"31":{"tf":1.7320508075688772}},"n":{"df":0,"docs":{},"e":{"(":{"&":{"&":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":4,"docs":{"103":{"tf":1.0},"105":{"tf":1.0},"46":{"tf":1.4142135623730951},"62":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}},">":{"(":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"46":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"<":{"df":0,"docs":{},"t":{">":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":8,"docs":{"101":{"tf":1.0},"103":{"tf":3.0},"105":{"tf":1.0},"28":{"tf":1.0},"46":{"tf":4.69041575982343},"58":{"tf":2.449489742783178},"66":{"tf":2.0},"99":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"14":{"tf":1.0},"63":{"tf":1.7320508075688772}},"r":{"df":1,"docs":{"46":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"3":{"tf":1.0},"31":{"tf":1.7320508075688772},"63":{"tf":2.0}},"e":{"<":{"df":0,"docs":{},"f":{"df":1,"docs":{"31":{"tf":2.449489742783178}}}},"df":0,"docs":{}}}}}}},"m":{"df":0,"docs":{},"p":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"df":0,"docs":{}},":":{":":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"25":{"tf":1.0},"27":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"df":70,"docs":{"1":{"tf":1.4142135623730951},"10":{"tf":1.7320508075688772},"100":{"tf":1.4142135623730951},"101":{"tf":1.0},"102":{"tf":2.0},"103":{"tf":2.23606797749979},"104":{"tf":1.0},"105":{"tf":2.0},"107":{"tf":1.0},"11":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.7320508075688772},"114":{"tf":1.4142135623730951},"115":{"tf":1.0},"116":{"tf":2.23606797749979},"117":{"tf":1.7320508075688772},"119":{"tf":1.7320508075688772},"122":{"tf":1.0},"123":{"tf":1.4142135623730951},"125":{"tf":1.4142135623730951},"130":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":2.0},"2":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"23":{"tf":2.0},"27":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":3.0},"30":{"tf":1.0},"31":{"tf":1.7320508075688772},"33":{"tf":2.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"36":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.4142135623730951},"46":{"tf":1.0},"5":{"tf":3.3166247903554},"55":{"tf":2.0},"56":{"tf":2.449489742783178},"60":{"tf":2.0},"61":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":3.7416573867739413},"66":{"tf":1.0},"67":{"tf":2.6457513110645907},"68":{"tf":2.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951},"74":{"tf":1.0},"76":{"tf":1.4142135623730951},"80":{"tf":1.0},"82":{"tf":2.0},"84":{"tf":1.0},"92":{"tf":1.7320508075688772},"93":{"tf":1.7320508075688772},"95":{"tf":1.0},"97":{"tf":2.0},"98":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":2,"docs":{"45":{"tf":1.7320508075688772},"85":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"45":{"tf":2.449489742783178},"46":{"tf":1.0},"47":{"tf":1.7320508075688772},"9":{"tf":1.0}}}}}},"df":0,"docs":{}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"65":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"23":{"tf":1.4142135623730951},"67":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":6,"docs":{"19":{"tf":1.4142135623730951},"34":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"71":{"tf":1.7320508075688772},"82":{"tf":1.0}}}},"df":0,"docs":{}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"1":{"tf":1.0},"2":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":12,"docs":{"126":{"tf":1.0},"2":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"58":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}}},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"105":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":11,"docs":{"10":{"tf":1.0},"119":{"tf":1.0},"125":{"tf":1.0},"2":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"44":{"tf":1.4142135623730951},"57":{"tf":1.0},"75":{"tf":1.0},"87":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"17":{"tf":1.0},"39":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"df":2,"docs":{"11":{"tf":1.0},"76":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"r":{"df":1,"docs":{"3":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"3":{"tf":1.0},"67":{"tf":1.4142135623730951}}}}}}},"t":{"df":6,"docs":{"123":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"34":{"tf":1.0},"64":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":51,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"110":{"tf":1.7320508075688772},"113":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.4142135623730951},"119":{"tf":1.4142135623730951},"120":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":1.0},"129":{"tf":1.0},"131":{"tf":1.4142135623730951},"133":{"tf":1.0},"134":{"tf":2.0},"135":{"tf":1.0},"14":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"19":{"tf":2.23606797749979},"22":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":2.6457513110645907},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"30":{"tf":1.0},"33":{"tf":1.4142135623730951},"34":{"tf":2.23606797749979},"35":{"tf":1.7320508075688772},"36":{"tf":1.0},"4":{"tf":2.0},"46":{"tf":4.123105625617661},"48":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":2.23606797749979},"75":{"tf":1.4142135623730951},"76":{"tf":2.6457513110645907},"81":{"tf":1.4142135623730951},"82":{"tf":2.0},"91":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}}},"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"134":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":16,"docs":{"19":{"tf":1.0},"2":{"tf":1.0},"23":{"tf":1.0},"3":{"tf":1.0},"33":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"6":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0},"74":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"9":{"tf":1.7320508075688772}}},"x":{"df":10,"docs":{"111":{"tf":1.0},"23":{"tf":1.4142135623730951},"35":{"tf":1.0},"5":{"tf":1.0},"67":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0},"89":{"tf":1.0},"95":{"tf":1.0}}}},"i":{"c":{"df":9,"docs":{"118":{"tf":1.0},"19":{"tf":1.7320508075688772},"33":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"67":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"74":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"3":{"tf":1.4142135623730951},"71":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"43":{"tf":1.0},"60":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"4":{"tf":1.0},"52":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"(":{"&":{"d":{"df":1,"docs":{"111":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}}}},"df":4,"docs":{"110":{"tf":1.4142135623730951},"111":{"tf":2.0},"88":{"tf":1.0},"89":{"tf":1.0}},"e":{"d":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"110":{"tf":2.0},"111":{"tf":2.449489742783178}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"107":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"19":{"tf":1.0},"24":{"tf":1.0},"46":{"tf":1.0},"56":{"tf":1.0},"92":{"tf":1.0}},"e":{"(":{"&":{"df":0,"docs":{},"x":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.7320508075688772}}}}}}}},"df":0,"docs":{}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":3,"docs":{"111":{"tf":1.0},"14":{"tf":1.4142135623730951},"34":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":6,"docs":{"15":{"tf":1.0},"22":{"tf":1.0},"56":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.0},"96":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"73":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":4,"docs":{"34":{"tf":1.0},"40":{"tf":1.0},"74":{"tf":1.0},"82":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":16,"docs":{"1":{"tf":1.0},"18":{"tf":1.0},"21":{"tf":1.0},"43":{"tf":1.0},"69":{"tf":2.449489742783178},"70":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.7320508075688772},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"99":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":7,"docs":{"26":{"tf":1.0},"4":{"tf":1.0},"55":{"tf":2.6457513110645907},"70":{"tf":3.0},"82":{"tf":1.7320508075688772},"85":{"tf":1.0},"93":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"55":{"tf":1.0}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"11":{"tf":1.0},"77":{"tf":1.0}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"34":{"tf":1.7320508075688772},"64":{"tf":1.0}}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":12,"docs":{"10":{"tf":1.0},"19":{"tf":1.0},"4":{"tf":1.0},"44":{"tf":1.0},"61":{"tf":1.0},"64":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":1.0},"82":{"tf":1.4142135623730951},"87":{"tf":1.0},"9":{"tf":1.0}}}},"r":{"df":0,"docs":{},"v":{"df":5,"docs":{"28":{"tf":1.0},"32":{"tf":1.0},"36":{"tf":1.0},"41":{"tf":1.4142135623730951},"82":{"tf":1.0}}}}},"i":{"d":{"df":25,"docs":{"1":{"tf":1.4142135623730951},"15":{"tf":1.0},"19":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"24":{"tf":1.0},"26":{"tf":1.0},"34":{"tf":1.7320508075688772},"35":{"tf":1.0},"4":{"tf":1.7320508075688772},"40":{"tf":1.0},"41":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":2.23606797749979},"54":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"62":{"tf":1.0},"65":{"tf":1.0},"7":{"tf":1.4142135623730951},"70":{"tf":1.0},"82":{"tf":1.0},"87":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"1":{"tf":1.0},"22":{"tf":1.0},"3":{"tf":1.0},"40":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":8,"docs":{"3":{"tf":1.0},"61":{"tf":2.0},"7":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":3.1622776601683795},"80":{"tf":1.0},"82":{"tf":1.7320508075688772},"9":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"22":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0}}}}},"df":20,"docs":{"11":{"tf":1.4142135623730951},"110":{"tf":2.0},"111":{"tf":2.8284271247461903},"120":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.4142135623730951},"134":{"tf":1.4142135623730951},"30":{"tf":1.0},"34":{"tf":1.7320508075688772},"39":{"tf":2.0},"40":{"tf":2.449489742783178},"41":{"tf":1.7320508075688772},"50":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"67":{"tf":1.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951},"89":{"tf":2.0},"92":{"tf":2.0},"93":{"tf":2.23606797749979}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":1,"docs":{"44":{"tf":1.0}},"t":{"df":1,"docs":{"45":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"122":{"tf":1.4142135623730951},"34":{"tf":1.0},"4":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"125":{"tf":1.0}}}}}}},"df":10,"docs":{"1":{"tf":1.0},"103":{"tf":1.0},"11":{"tf":1.4142135623730951},"14":{"tf":1.0},"43":{"tf":1.0},"56":{"tf":1.0},"67":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.0},"98":{"tf":1.7320508075688772}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"131":{"tf":1.0},"58":{"tf":3.3166247903554}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"m":{"df":9,"docs":{"11":{"tf":1.0},"14":{"tf":1.0},"39":{"tf":1.0},"43":{"tf":1.4142135623730951},"60":{"tf":1.0},"61":{"tf":1.0},"76":{"tf":1.0},"87":{"tf":1.0},"89":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":28,"docs":{"1":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.0},"123":{"tf":1.0},"125":{"tf":1.7320508075688772},"135":{"tf":1.0},"2":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"33":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.4142135623730951},"41":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"56":{"tf":1.7320508075688772},"61":{"tf":1.4142135623730951},"62":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.7320508075688772},"72":{"tf":1.0},"87":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.0},"96":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"46":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"m":{"a":{"df":0,"docs":{},"y":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{">":{"(":{"a":{"df":0,"docs":{},"r":{"c":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"46":{"tf":2.8284271247461903},"56":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"104":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":10,"docs":{"1":{"tf":1.0},"104":{"tf":1.0},"131":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":2.0},"61":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951},"89":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":7,"docs":{"10":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"45":{"tf":1.0},"58":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":2,"docs":{"111":{"tf":1.0},"9":{"tf":1.0}}}},"n":{"df":0,"docs":{},"u":{"df":2,"docs":{"14":{"tf":1.0},"34":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"24":{"tf":1.0},"3":{"tf":3.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"14":{"tf":1.0},"41":{"tf":1.0}}}},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"34":{"tf":3.0},"42":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{},"v":{"df":1,"docs":{"125":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":12,"docs":{"118":{"tf":1.0},"14":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"65":{"tf":1.4142135623730951},"66":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.7320508075688772},"87":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":6,"docs":{"2":{"tf":1.0},"34":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"82":{"tf":1.0},"90":{"tf":1.0}}},"t":{"df":5,"docs":{"114":{"tf":1.4142135623730951},"116":{"tf":1.0},"122":{"tf":2.449489742783178},"58":{"tf":1.0},"82":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":14,"docs":{"125":{"tf":1.0},"126":{"tf":1.0},"3":{"tf":1.0},"44":{"tf":2.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"59":{"tf":1.0},"72":{"tf":1.0}}},"t":{"df":4,"docs":{"104":{"tf":1.0},"11":{"tf":1.0},"46":{"tf":1.7320508075688772},"48":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"26":{"tf":1.0},"75":{"tf":1.0}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"i":{"df":13,"docs":{"119":{"tf":1.0},"52":{"tf":1.4142135623730951},"54":{"tf":2.0},"55":{"tf":1.0},"56":{"tf":1.7320508075688772},"58":{"tf":3.1622776601683795},"67":{"tf":1.7320508075688772},"70":{"tf":1.0},"73":{"tf":1.0},"83":{"tf":1.0},"86":{"tf":1.4142135623730951},"87":{"tf":1.0},"88":{"tf":1.0}}},"y":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{":":{":":{"df":0,"docs":{},"{":{"c":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"134":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"135":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"s":{":":{":":{"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"134":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"<":{"(":{"*":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"131":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"131":{"tf":1.4142135623730951}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{":":{":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":2,"docs":{"134":{"tf":1.0},"135":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"134":{"tf":1.0}}}}}}}}}},"df":3,"docs":{"134":{"tf":1.0},"4":{"tf":1.0},"75":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"119":{"tf":1.0}}},"df":0,"docs":{}}}}}},"n":{"df":1,"docs":{"23":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"26":{"tf":1.0},"33":{"tf":1.0},"48":{"tf":1.0},"62":{"tf":1.0},"82":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":19,"docs":{"1":{"tf":1.0},"110":{"tf":1.4142135623730951},"116":{"tf":1.0},"125":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.0},"3":{"tf":1.0},"39":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.4142135623730951},"56":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.7320508075688772},"76":{"tf":1.0},"77":{"tf":1.4142135623730951},"83":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":13,"docs":{"101":{"tf":1.0},"110":{"tf":1.0},"3":{"tf":2.0},"39":{"tf":1.0},"5":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.0},"68":{"tf":1.4142135623730951},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"85":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"125":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"23":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"133":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":1,"docs":{"1":{"tf":1.0}}}},"t":{"df":2,"docs":{"61":{"tf":1.0},"64":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"n":{"df":0,"docs":{},"’":{"df":0,"docs":{},"t":{"df":3,"docs":{"22":{"tf":1.0},"81":{"tf":1.0},"96":{"tf":1.0}}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"t":{"df":12,"docs":{"102":{"tf":1.0},"103":{"tf":3.0},"104":{"tf":2.449489742783178},"105":{"tf":1.0},"56":{"tf":1.7320508075688772},"60":{"tf":1.0},"7":{"tf":1.7320508075688772},"79":{"tf":1.0},"93":{"tf":1.7320508075688772},"96":{"tf":2.0},"98":{"tf":1.0},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"34":{"tf":1.0},"79":{"tf":1.4142135623730951},"92":{"tf":1.4142135623730951}}}}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"82":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":15,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.0},"30":{"tf":1.0},"36":{"tf":1.0},"4":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.4142135623730951},"59":{"tf":1.0},"70":{"tf":1.0},"77":{"tf":1.0},"82":{"tf":1.0},"91":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":5,"docs":{"34":{"tf":4.795831523312719},"39":{"tf":1.0},"42":{"tf":2.449489742783178},"81":{"tf":1.4142135623730951},"96":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"110":{"tf":1.0},"14":{"tf":1.0},"26":{"tf":1.4142135623730951},"52":{"tf":1.0},"73":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"u":{"df":1,"docs":{"75":{"tf":2.23606797749979}}}},"r":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"e":{"df":10,"docs":{"108":{"tf":1.0},"114":{"tf":1.7320508075688772},"115":{"tf":1.0},"119":{"tf":1.7320508075688772},"123":{"tf":1.0},"132":{"tf":1.4142135623730951},"133":{"tf":2.0},"134":{"tf":2.0},"135":{"tf":3.0},"15":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"123":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":31,"docs":{"1":{"tf":1.0},"104":{"tf":1.0},"109":{"tf":1.0},"111":{"tf":1.4142135623730951},"115":{"tf":1.0},"117":{"tf":1.0},"119":{"tf":1.0},"123":{"tf":1.0},"131":{"tf":1.7320508075688772},"16":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"34":{"tf":1.0},"40":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":2.449489742783178},"57":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.4142135623730951},"65":{"tf":1.0},"67":{"tf":1.0},"72":{"tf":1.0},"82":{"tf":1.0},"9":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0},"99":{"tf":1.4142135623730951}},"e":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"93":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":4,"docs":{"133":{"tf":1.0},"5":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"126":{"tf":1.4142135623730951},"23":{"tf":1.0}}}}},"t":{"0":{".":{"df":0,"docs":{},"o":{"df":1,"docs":{"134":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"\\"":{"[":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"121":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"123":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"2":{"tf":1.0},"4":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":2,"docs":{"10":{"tf":1.0},"41":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":20,"docs":{"102":{"tf":1.0},"105":{"tf":1.0},"107":{"tf":1.0},"111":{"tf":1.0},"116":{"tf":1.0},"118":{"tf":1.0},"119":{"tf":1.0},"122":{"tf":1.0},"131":{"tf":1.0},"14":{"tf":1.0},"36":{"tf":1.0},"4":{"tf":1.0},"56":{"tf":1.0},"64":{"tf":1.0},"7":{"tf":1.0},"82":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.4142135623730951},"98":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":7,"docs":{"10":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.4142135623730951},"59":{"tf":1.0},"72":{"tf":1.0},"82":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}}},"y":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}},"’":{"df":4,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"56":{"tf":1.4142135623730951},"86":{"tf":1.0}}}},"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"2":{"tf":1.0},"63":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"47":{"tf":1.0},"48":{"tf":1.0},"62":{"tf":1.0},"70":{"tf":1.0}}}},"l":{"df":11,"docs":{"110":{"tf":1.0},"19":{"tf":1.4142135623730951},"2":{"tf":1.0},"26":{"tf":1.0},"30":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"4":{"tf":2.0},"40":{"tf":1.0},"41":{"tf":2.23606797749979},"42":{"tf":1.0},"82":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}},"t":{"a":{".":{"0":{"df":1,"docs":{"31":{"tf":2.0}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"d":{"(":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"(":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"70":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"(":{"4":{"df":3,"docs":{"19":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":2.23606797749979}}},"5":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"1":{"df":2,"docs":{"59":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772}}},"2":{"df":2,"docs":{"59":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772}}},"[":{"0":{"df":3,"docs":{"19":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.7320508075688772}}},"3":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"(":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"b":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}},"df":52,"docs":{"10":{"tf":1.0},"101":{"tf":1.4142135623730951},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":4.0},"105":{"tf":2.0},"11":{"tf":1.0},"116":{"tf":1.0},"118":{"tf":1.4142135623730951},"12":{"tf":1.0},"125":{"tf":1.0},"13":{"tf":1.4142135623730951},"14":{"tf":1.7320508075688772},"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":2.0},"24":{"tf":2.0},"25":{"tf":3.1622776601683795},"26":{"tf":2.0},"31":{"tf":2.449489742783178},"35":{"tf":2.449489742783178},"36":{"tf":2.6457513110645907},"4":{"tf":1.0},"40":{"tf":1.7320508075688772},"43":{"tf":1.0},"52":{"tf":1.4142135623730951},"56":{"tf":1.7320508075688772},"59":{"tf":1.0},"6":{"tf":2.23606797749979},"61":{"tf":1.4142135623730951},"62":{"tf":2.449489742783178},"63":{"tf":4.358898943540674},"65":{"tf":1.0},"67":{"tf":1.7320508075688772},"68":{"tf":1.4142135623730951},"7":{"tf":2.8284271247461903},"70":{"tf":3.3166247903554},"72":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":3.1622776601683795},"77":{"tf":1.4142135623730951},"78":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.0},"82":{"tf":1.0},"9":{"tf":2.0},"96":{"tf":1.7320508075688772},"98":{"tf":1.0},"99":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"y":{"df":4,"docs":{"25":{"tf":1.0},"35":{"tf":4.123105625617661},"36":{"tf":1.4142135623730951},"44":{"tf":1.0}}}},"df":5,"docs":{"111":{"tf":2.0},"24":{"tf":1.0},"27":{"tf":1.0},"31":{"tf":1.0},"34":{"tf":2.0}},"e":{"a":{"d":{"df":2,"docs":{"22":{"tf":1.0},"74":{"tf":1.0}},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"4":{"tf":1.0},"70":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":10,"docs":{"1":{"tf":1.0},"121":{"tf":1.4142135623730951},"132":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"36":{"tf":1.0},"41":{"tf":1.0},"56":{"tf":1.0},"6":{"tf":1.0},"65":{"tf":1.0}},"l":{"df":0,"docs":{},"o":{"c":{"df":8,"docs":{"4":{"tf":1.0},"41":{"tf":2.0},"59":{"tf":1.7320508075688772},"82":{"tf":1.0},"84":{"tf":2.0},"88":{"tf":1.0},"92":{"tf":2.23606797749979},"93":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"82":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"35":{"tf":1.0}}}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":2,"docs":{"32":{"tf":1.4142135623730951},"33":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"<":{"\'":{"a":{">":{"(":{"a":{"df":2,"docs":{"32":{"tf":1.0},"33":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":2,"docs":{"32":{"tf":1.0},"65":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"85":{"tf":1.0}}}}},"i":{"d":{"df":5,"docs":{"103":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.0},"70":{"tf":1.0},"97":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}},"l":{"a":{"df":0,"docs":{},"r":{"df":13,"docs":{"11":{"tf":1.4142135623730951},"110":{"tf":1.4142135623730951},"119":{"tf":1.0},"12":{"tf":1.0},"121":{"tf":1.4142135623730951},"124":{"tf":1.0},"133":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0},"3":{"tf":2.449489742783178},"4":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"96":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"111":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"104":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"103":{"tf":1.4142135623730951},"104":{"tf":1.7320508075688772}}}}}}}}},"d":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"u":{"c":{"df":1,"docs":{"46":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"39":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":13,"docs":{"109":{"tf":1.0},"122":{"tf":1.0},"123":{"tf":1.0},"125":{"tf":1.0},"13":{"tf":1.0},"133":{"tf":1.7320508075688772},"14":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"41":{"tf":1.0},"58":{"tf":2.23606797749979},"59":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"3":{"tf":2.0}}},"df":0,"docs":{}},"r":{"df":1,"docs":{"82":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":28,"docs":{"114":{"tf":1.0},"116":{"tf":1.0},"12":{"tf":1.0},"122":{"tf":1.0},"125":{"tf":1.0},"134":{"tf":1.4142135623730951},"135":{"tf":1.0},"14":{"tf":1.4142135623730951},"16":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.4142135623730951},"24":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":1.0},"33":{"tf":2.8284271247461903},"34":{"tf":1.7320508075688772},"35":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.4142135623730951},"5":{"tf":1.0},"52":{"tf":1.0},"58":{"tf":1.0},"67":{"tf":1.7320508075688772},"70":{"tf":1.0},"73":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":25,"docs":{"108":{"tf":1.0},"123":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.7320508075688772},"22":{"tf":1.0},"29":{"tf":1.4142135623730951},"33":{"tf":1.0},"35":{"tf":1.7320508075688772},"39":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":1.4142135623730951},"43":{"tf":1.0},"5":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":1.4142135623730951},"71":{"tf":1.0},"77":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"92":{"tf":1.0}}}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"103":{"tf":1.0},"62":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"55":{"tf":1.0},"59":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"54":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":4,"docs":{"104":{"tf":2.8284271247461903},"105":{"tf":1.0},"4":{"tf":1.0},"6":{"tf":1.0}}}},"i":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"25":{"tf":1.0},"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"(":{"\\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}},"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"<":{"\'":{"a":{">":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"56":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"41":{"tf":1.4142135623730951}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}}}},"s":{"df":1,"docs":{"7":{"tf":1.0}}},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":13,"docs":{"108":{"tf":1.0},"119":{"tf":2.449489742783178},"126":{"tf":1.0},"133":{"tf":1.4142135623730951},"135":{"tf":1.4142135623730951},"22":{"tf":1.0},"3":{"tf":1.0},"5":{"tf":1.4142135623730951},"54":{"tf":1.0},"56":{"tf":1.0},"70":{"tf":1.0},"74":{"tf":1.4142135623730951},"82":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":1,"docs":{"36":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":2,"docs":{"56":{"tf":1.0},"82":{"tf":