/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.devconsole;

import com.unciv.ui.screens.devconsole.CliInput;
import com.unciv.ui.screens.devconsole.ConsoleCommand;
import com.unciv.ui.screens.devconsole.ConsoleErrorException;
import com.unciv.ui.screens.devconsole.ConsoleHintException;
import com.unciv.ui.screens.devconsole.ConsoleParameterType;
import com.unciv.ui.screens.devconsole.DevConsolePopup;
import com.unciv.ui.screens.devconsole.DevConsoleResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\b\u0010\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012<\u0010\u0004\u001a8\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\u0005\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001e\u0010\u0014\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J \u0010\u0015\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011RG\u0010\u0004\u001a8\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0018"}, d2={"Lcom/unciv/ui/screens/devconsole/ConsoleAction;", "Lcom/unciv/ui/screens/devconsole/ConsoleCommand;", "format", "", "action", "Lkotlin/Function2;", "Lcom/unciv/ui/screens/devconsole/DevConsolePopup;", "Lkotlin/ParameterName;", "name", "console", "", "Lcom/unciv/ui/screens/devconsole/CliInput;", "params", "Lcom/unciv/ui/screens/devconsole/DevConsoleResponse;", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function2;)V", "getFormat", "()Ljava/lang/String;", "getAction", "()Lkotlin/jvm/functions/Function2;", "handle", "autocomplete", "validateFormat", "", "core"})
@SourceDebugExtension(value={"SMAP\nDevConsoleCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DevConsoleCommand.kt\ncom/unciv/ui/screens/devconsole/ConsoleAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,106:1\n1563#2:107\n1634#2,3:108\n1788#2,4:111\n1788#2,4:115\n*S KotlinDebug\n*F\n+ 1 DevConsoleCommand.kt\ncom/unciv/ui/screens/devconsole/ConsoleAction\n*L\n37#1:107\n37#1:108,3\n57#1:111,4\n58#1:115,4\n*E\n"})
public class ConsoleAction
implements ConsoleCommand {
    @NotNull
    private final String format;
    @NotNull
    private final Function2<DevConsolePopup, List<CliInput>, DevConsoleResponse> action;

    public ConsoleAction(@NotNull String format, @NotNull Function2<? super DevConsolePopup, ? super List<CliInput>, DevConsoleResponse> action2) {
        Intrinsics.checkNotNullParameter(format, "format");
        Intrinsics.checkNotNullParameter(action2, "action");
        this.format = format;
        this.action = action2;
    }

    @NotNull
    public final String getFormat() {
        return this.format;
    }

    @NotNull
    public final Function2<DevConsolePopup, List<CliInput>, DevConsoleResponse> getAction() {
        return this.action;
    }

    @Override
    @NotNull
    public DevConsoleResponse handle(@NotNull DevConsolePopup console, @NotNull List<CliInput> params) {
        DevConsoleResponse devConsoleResponse;
        Intrinsics.checkNotNullParameter(console, "console");
        Intrinsics.checkNotNullParameter(params, "params");
        try {
            this.validateFormat(this.format, params);
            devConsoleResponse = this.action.invoke(console, params);
        }
        catch (ConsoleHintException hintException) {
            devConsoleResponse = DevConsoleResponse.Companion.hint(hintException.getHint());
        }
        catch (ConsoleErrorException errorException) {
            devConsoleResponse = DevConsoleResponse.Companion.error(errorException.getError());
        }
        return devConsoleResponse;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public String autocomplete(@NotNull DevConsolePopup console, @NotNull List<CliInput> params) {
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(console, "console");
        Intrinsics.checkNotNullParameter(params, "params");
        Object object = new char[]{' '};
        Iterable $this$map$iv = CollectionsKt.drop(StringsKt.split$default((CharSequence)this.format, object, false, 0, 6, null), 2);
        int $i$f$map = 0;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.removeSurrounding(StringsKt.removeSurrounding(StringsKt.removeSurrounding((String)it, (CharSequence)"<", (CharSequence)">"), (CharSequence)"[", (CharSequence)"]"), (CharSequence)"\""));
        }
        List formatParams = (List)destination$iv$iv;
        if (CollectionsKt.none(formatParams)) {
            return null;
        }
        if (formatParams.size() < params.size()) {
            return null;
        }
        $i$f$map = ((Collection)formatParams).size();
        int $this$mapTo$iv$iv2 = CollectionsKt.getLastIndex(params);
        object = (0 <= $this$mapTo$iv$iv2 ? $this$mapTo$iv$iv2 < $i$f$map : false) ? TuplesKt.to(formatParams.get(CollectionsKt.getLastIndex(params)), CollectionsKt.last(params)) : TuplesKt.to(CollectionsKt.first(formatParams), null);
        String formatParam = (String)object.component1();
        CliInput lastParam = (CliInput)object.component2();
        List<CliInput> options2 = ConsoleParameterType.Companion.multiOptions(formatParam, console);
        String result2 = CliInput.Companion.getAutocompleteString$core(CliInput.Companion.orEmpty(lastParam), (Iterable<CliInput>)options2, console);
        if (lastParam != null || result2 == null) {
            return result2;
        }
        Object object2 = new char[1];
        object2[0] = 32;
        return (String)StringsKt.split$default((CharSequence)this.format, (char[])object2, false, 0, 6, null).get(1) + ' ' + result2;
    }

    private final void validateFormat(String format, List<CliInput> params) {
        int paramsSize;
        int optionalParamsAmount;
        int n;
        int requiredParamsAmount;
        int n2;
        char[] cArray = new char[]{' '};
        List allParams = StringsKt.split$default((CharSequence)format, cArray, false, 0, 6, null);
        Iterable $this$count$iv = allParams;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n2 = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default((CharSequence)it, '<', false, 2, null) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n2 = requiredParamsAmount = count$iv;
        }
        if (StringsKt.endsWith$default(format, "]...", false, 2, null)) {
            n = 999999;
        } else {
            Iterable $this$count$iv2 = allParams;
            boolean $i$f$count2 = false;
            if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv2) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((CharSequence)it, '[', false, 2, null) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = optionalParamsAmount = count$iv;
            }
        }
        int n3 = params.isEmpty() ? 0 : (paramsSize = CollectionsKt.last(params).isEmpty() ? params.size() - 1 : params.size());
        if (paramsSize < requiredParamsAmount || paramsSize > requiredParamsAmount + optionalParamsAmount) {
            throw new ConsoleHintException("Format: " + format);
        }
    }
}

