/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.victoryscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.unciv.logic.GameInfo;
import com.unciv.logic.civilization.Civilization;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.OnClickListener;
import com.unciv.ui.components.widgets.AutoScrollPane;
import com.unciv.ui.components.widgets.TabbedPager;
import com.unciv.ui.components.widgets.TranslatedSelectBox;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.victoryscreen.DataPoint;
import com.unciv.ui.screens.victoryscreen.LineChart;
import com.unciv.ui.screens.victoryscreen.RankingType;
import com.unciv.ui.screens.victoryscreen.VictoryScreen;
import com.unciv.ui.screens.victoryscreen.VictoryScreenCivGroup;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001bH\u0002J\b\u0010\u001d\u001a\u00020\u001bH\u0002J\u001c\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0 0\u001f2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J \u0010(\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/unciv/ui/screens/victoryscreen/VictoryScreenCharts;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "Lcom/unciv/ui/components/widgets/TabbedPager$IPageExtensions;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "<init>", "(Lcom/unciv/ui/screens/worldscreen/WorldScreen;)V", "gameInfo", "Lcom/unciv/logic/GameInfo;", "rankingType", "Lcom/unciv/ui/screens/victoryscreen/RankingType;", "selectedCiv", "Lcom/unciv/logic/civilization/Civilization;", "viewingCiv", "rankingTypeSelect", "Lcom/unciv/ui/components/widgets/TranslatedSelectBox;", "civButtonsTable", "civButtonsScroll", "Lcom/unciv/ui/components/widgets/AutoScrollPane;", "controlsColumn", "markerIcon", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "lineChart", "Lcom/unciv/ui/screens/victoryscreen/LineChart;", "zoomAtX", "Lkotlin/ranges/IntRange;", "update", "", "updateControls", "updateChart", "getLineChartData", "", "Lcom/unciv/ui/screens/victoryscreen/DataPoint;", "", "activated", "index", "caption", "", "pager", "Lcom/unciv/ui/components/widgets/TabbedPager;", "deactivated", "core"})
@SourceDebugExtension(value={"SMAP\nVictoryScreenCharts.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VictoryScreenCharts.kt\ncom/unciv/ui/screens/victoryscreen/VictoryScreenCharts\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,143:1\n1563#2:144\n1634#2,3:145\n1252#2,4:164\n1056#2:178\n1491#2:179\n1516#2,3:180\n1519#2,3:190\n827#2:194\n855#2,2:195\n295#2,2:197\n1011#3:148\n1045#3,3:149\n1048#3,3:159\n382#4,7:152\n463#4:162\n413#4:163\n382#4,7:183\n488#4,7:199\n504#4,7:206\n77#5:168\n97#5,2:169\n126#5:171\n153#5,3:172\n99#5,3:175\n126#5:213\n153#5,3:214\n1#6:193\n*S KotlinDebug\n*F\n+ 1 VictoryScreenCharts.kt\ncom/unciv/ui/screens/victoryscreen/VictoryScreenCharts\n*L\n28#1:144\n28#1:145,3\n112#1:164,4\n122#1:178\n122#1:179\n122#1:180,3\n122#1:190,3\n124#1:194\n124#1:195,2\n61#1:197,2\n111#1:148\n111#1:149,3\n111#1:159,3\n111#1:152,7\n112#1:162\n112#1:163\n122#1:183,7\n107#1:199,7\n108#1:206,7\n113#1:168\n113#1:169,2\n114#1:171\n114#1:172,3\n113#1:175,3\n109#1:213\n109#1:214,3\n*E\n"})
public final class VictoryScreenCharts
extends Table
implements TabbedPager.IPageExtensions {
    @NotNull
    private final GameInfo gameInfo;
    @NotNull
    private RankingType rankingType;
    @NotNull
    private Civilization selectedCiv;
    @NotNull
    private final Civilization viewingCiv;
    @NotNull
    private final TranslatedSelectBox rankingTypeSelect;
    @NotNull
    private final Table civButtonsTable;
    @NotNull
    private final AutoScrollPane civButtonsScroll;
    @NotNull
    private final Table controlsColumn;
    @NotNull
    private final Image markerIcon;
    @NotNull
    private LineChart lineChart;
    @Nullable
    private IntRange zoomAtX;

    /*
     * WARNING - void declaration
     */
    public VictoryScreenCharts(@NotNull WorldScreen worldScreen) {
        void $this$markerIcon_u24lambda_u240;
        void $this$mapTo$iv$iv;
        Image $this$map$iv;
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        super(BaseScreen.Companion.getSkin());
        this.gameInfo = worldScreen.getGameInfo();
        this.rankingType = RankingType.Score;
        this.selectedCiv = worldScreen.getSelectedCiv();
        this.viewingCiv = worldScreen.getViewingCiv();
        Iterable iterable = RankingType.getEntries();
        VictoryScreenCharts victoryScreenCharts = this;
        boolean $i$f$map22 = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RankingType rankingType = (RankingType)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getLabel());
        }
        String string = this.rankingType.name();
        Collection collection = (List)destination$iv$iv;
        victoryScreenCharts.rankingTypeSelect = new TranslatedSelectBox(collection, string);
        this.civButtonsTable = new Table();
        this.civButtonsScroll = new AutoScrollPane((Actor)this.civButtonsTable, null, 2, null);
        this.controlsColumn = new Table();
        Image $i$f$map22 = $this$map$iv = ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Star", null, 2, null);
        victoryScreenCharts = this;
        boolean bl = false;
        $this$markerIcon_u24lambda_u240.setColor(Color.GOLD);
        $this$markerIcon_u24lambda_u240.setAlign(1);
        victoryScreenCharts.markerIcon = $this$map$iv;
        this.lineChart = new LineChart(this.viewingCiv);
        this.civButtonsScroll.setScrollingDisabled(true, false);
        this.civButtonsTable.defaults().space(20.0f).fillX();
        this.controlsColumn.defaults().space(20.0f).fillX();
        this.controlsColumn.add((Actor)this.rankingTypeSelect).right().row();
        this.controlsColumn.add((Actor)this.civButtonsScroll).fillY();
        this.defaults().fill().pad(20.0f);
        this.add((Actor)this.controlsColumn);
        this.updateControls();
        this.add((Actor)this.lineChart).growX().expandY().top().padLeft(0.0f);
        OnClickListener onChartClick = new OnClickListener(null, (arg_0, arg_1, arg_2) -> VictoryScreenCharts._init_$lambda$0(this, arg_0, arg_1, arg_2), 0, 0.0f, 13, null);
        this.lineChart.addListener(onChartClick);
        ActivationExtensionsKt.onChange(this.rankingTypeSelect, arg_0 -> VictoryScreenCharts._init_$lambda$1(this, arg_0));
    }

    private final void update() {
        this.updateControls();
        this.updateChart();
    }

    private final void updateControls() {
        this.civButtonsTable.clear();
        Object object = new Comparator(){

            public final int compare(T a, T b) {
                VictoryScreen.CivWithStat it = (VictoryScreen.CivWithStat)b;
                boolean bl = false;
                Comparable comparable = it.getCiv().isDefeated() ? (Comparable)Integer.valueOf(Integer.MIN_VALUE) : (Comparable)Integer.valueOf(it.getValue());
                it = (VictoryScreen.CivWithStat)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getCiv().isDefeated() ? (Comparable)Integer.valueOf(Integer.MIN_VALUE) : (Comparable)Integer.valueOf(it.getValue()));
            }
        };
        Sequence<VictoryScreen.CivWithStat> sortedCivs = SequencesKt.sortedWith(SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.gameInfo.getCivilizations()), VictoryScreenCharts::updateControls$lambda$0), arg_0 -> VictoryScreenCharts.updateControls$lambda$1(this, arg_0)), new Comparator((Comparator)object){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    VictoryScreen.CivWithStat it = (VictoryScreen.CivWithStat)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getCiv().getCivName());
                    it = (VictoryScreen.CivWithStat)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getCiv().getCivName()));
                }
                return n;
            }
        });
        object = sortedCivs.iterator();
        while (object.hasNext()) {
            VictoryScreen.CivWithStat civEntry = (VictoryScreen.CivWithStat)object.next();
            Cell<Actor> cell = !Intrinsics.areEqual(civEntry.getCiv(), this.selectedCiv) ? this.civButtonsTable.add() : this.civButtonsTable.add((Actor)this.markerIcon).size(24.0f).right();
            VictoryScreenCivGroup button = new VictoryScreenCivGroup(civEntry, this.viewingCiv, VictoryScreenCivGroup.DefeatedPlayerStyle.REGULAR);
            button.setTouchable(Touchable.enabled);
            this.civButtonsTable.add((Actor)button).row();
            ActivationExtensionsKt.onClick(button, () -> VictoryScreenCharts.updateControls$lambda$4(this, civEntry));
        }
        this.civButtonsTable.add().padBottom(20.0f).row();
        this.civButtonsTable.pack();
        this.civButtonsScroll.layout();
    }

    private final void updateChart() {
        this.lineChart.update(this.getLineChartData(this.rankingType), this.selectedCiv);
        Scene2dExtensionsKt.packIfNeeded(this);
    }

    /*
     * WARNING - void declaration
     */
    private final List<DataPoint<Integer>> getLineChartData(RankingType rankingType) {
        void $this$filterNotTo$iv$iv;
        Iterator $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Map $this$mapTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        Iterator $this$associateByTo$iv$iv$iv;
        Map $this$mapValuesTo$iv$iv;
        Iterator it;
        Object object;
        Object value$iv$iv$iv;
        Map.Entry $this$getOrPut$iv$iv$iv;
        Object key$iv$iv$iv;
        Object element$iv$iv;
        Map $this$groupByTo$iv$iv2;
        Sequence $this$groupBy$iv2 = SequencesKt.flatMapIterable(SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.gameInfo.getCivilizations()), VictoryScreenCharts::getLineChartData$lambda$0), arg_0 -> VictoryScreenCharts.getLineChartData$lambda$1(this, rankingType, arg_0));
        boolean $i$f$groupBy = false;
        Sequence sequence = $this$groupBy$iv2;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Object object2 = $this$groupByTo$iv$iv2.iterator();
        while (object2.hasNext()) {
            Object object3;
            element$iv$iv = object2.next();
            Pair it2 = (Pair)element$iv$iv;
            boolean $i$a$-groupBy-VictoryScreenCharts$getLineChartData$dataPoints$52 = false;
            Integer key$iv$iv = ((Number)it2.getFirst()).intValue();
            Map map2 = destination$iv$iv;
            key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object3;
            Pair $i$a$-groupBy-VictoryScreenCharts$getLineChartData$dataPoints$52 = (Pair)element$iv$iv;
            object = list$iv$iv;
            boolean bl = false;
            object.add((Pair)((Pair)((Object)it)).getSecond());
        }
        Map $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv2 = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        object2 = $this$mapValuesTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        it = $this$associateByTo$iv$iv$iv.iterator();
        while (it.hasNext()) {
            void group;
            void it$iv$iv;
            Object element$iv$iv$iv = it.next();
            $this$getOrPut$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            key$iv$iv$iv = destination$iv$iv$iv;
            boolean bl = false;
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object = key$iv$iv$iv;
            boolean bl2 = false;
            Map map3 = MapsKt.toMap((Iterable)group.getValue());
            object.put(k, map3);
        }
        Map $this$flatMap$iv = destination$iv$iv$iv;
        boolean $i$f$flatMap = false;
        $this$mapValuesTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        $this$associateByTo$iv$iv$iv = $this$flatMapTo$iv$iv.entrySet().iterator();
        while ($this$associateByTo$iv$iv$iv.hasNext()) {
            Object turn = element$iv$iv = $this$associateByTo$iv$iv$iv.next();
            boolean bl = false;
            Map $this$map$iv = (Map)turn.getValue();
            boolean $i$f$map = false;
            key$iv$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator bl2 = $this$mapTo$iv$iv.entrySet().iterator();
            while (bl2.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = bl2.next();
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                Civilization civ = (Civilization)entry.getKey();
                int value = ((Number)entry.getValue()).intValue();
                collection.add(new DataPoint<Integer>((Integer)turn.getKey(), value, civ));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List<DataPoint<Integer>> dataPoints = CollectionsKt.toMutableList((List)destination$iv$iv);
        if (dataPoints.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$sortedBy$iv = dataPoints;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                DataPoint it = (DataPoint)a;
                boolean bl = false;
                Comparable comparable = (Integer)it.getX();
                it = (DataPoint)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Integer)it.getX()));
            }
        });
        boolean $i$f$groupBy2 = false;
        destination$iv$iv = $this$groupBy$iv;
        Map destination$iv$iv3 = new LinkedHashMap();
        boolean $i$f$groupByTo2 = false;
        element$iv$iv = $this$groupByTo$iv$iv.iterator();
        while (element$iv$iv.hasNext()) {
            Object object4;
            void $this$getOrPut$iv$iv$iv2;
            Object element$iv$iv2 = element$iv$iv.next();
            DataPoint it3 = (DataPoint)element$iv$iv2;
            boolean bl = false;
            Civilization key$iv$iv = it3.getCiv();
            $this$mapTo$iv$iv = destination$iv$iv3;
            Civilization key$iv$iv$iv2 = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv2 = $this$getOrPut$iv$iv$iv2.get(key$iv$iv$iv2);
            if (value$iv$iv$iv2 == null) {
                boolean bl4 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv2.put(key$iv$iv$iv2, answer$iv$iv$iv);
                object4 = answer$iv$iv$iv;
            } else {
                object4 = value$iv$iv$iv2;
            }
            List list$iv$iv = (List)object4;
            list$iv$iv.add(element$iv$iv2);
        }
        Map pointsByCiv = destination$iv$iv3;
        $this$groupByTo$iv$iv = ((Iterable)dataPoints).iterator();
        if (!$this$groupByTo$iv$iv.hasNext()) {
            throw new NoSuchElementException();
        }
        DataPoint it22 = (DataPoint)$this$groupByTo$iv$iv.next();
        boolean bl = false;
        int it22 = ((Number)it22.getX()).intValue();
        while ($this$groupByTo$iv$iv.hasNext()) {
            DataPoint it32 = (DataPoint)$this$groupByTo$iv$iv.next();
            $i$a$-maxOf-VictoryScreenCharts$getLineChartData$actualTurn$1 = false;
            int it32 = ((Number)it32.getX()).intValue();
            if (it22 >= it32) continue;
            it22 = it32;
        }
        int actualTurn = it22;
        Iterable $this$filterNot$iv = pointsByCiv.keySet();
        boolean $i$f$filterNot = false;
        Iterable it32 = $this$filterNot$iv;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv3 : $this$filterNotTo$iv$iv) {
            Civilization it4 = (Civilization)element$iv$iv3;
            boolean bl5 = false;
            if (it4.isDefeated()) continue;
            destination$iv$iv4.add(element$iv$iv3);
        }
        for (Civilization civ : (List)destination$iv$iv4) {
            Object v = pointsByCiv.get(civ);
            Intrinsics.checkNotNull(v);
            if (((Number)((DataPoint)CollectionsKt.last((List)v)).getX()).intValue() == actualTurn) continue;
            ((Collection)dataPoints).add(new DataPoint<Integer>(actualTurn, civ.getStatForRanking(rankingType), civ));
        }
        return dataPoints;
    }

    @Override
    public void activated(int index, @NotNull String caption, @NotNull TabbedPager pager) {
        Intrinsics.checkNotNullParameter(caption, "caption");
        Intrinsics.checkNotNullParameter(pager, "pager");
        pager.setScrollDisabled(true);
        this.controlsColumn.setHeight(this.getParent().getHeight());
        this.lineChart.setHeight(this.getParent().getHeight());
        this.update();
        this.civButtonsTable.invalidateHierarchy();
    }

    @Override
    public void deactivated(int index, @NotNull String caption, @NotNull TabbedPager pager) {
        Intrinsics.checkNotNullParameter(caption, "caption");
        Intrinsics.checkNotNullParameter(pager, "pager");
        pager.setScrollDisabled(false);
    }

    private static final Unit _init_$lambda$0(VictoryScreenCharts this$0, InputEvent inputEvent, float x, float f) {
        this$0.zoomAtX = this$0.zoomAtX == null ? this$0.lineChart.getTurnAt(x) : null;
        this$0.updateChart();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit _init_$lambda$1(VictoryScreenCharts this$0, ChangeListener.ChangeEvent it) {
        RankingType rankingType;
        Object v0;
        block2: {
            void $this$firstOrNull$iv;
            Iterable iterable = RankingType.getEntries();
            VictoryScreenCharts victoryScreenCharts = this$0;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RankingType it2 = (RankingType)((Object)element$iv);
                boolean bl = false;
                if (!Intrinsics.areEqual(it2.getLabel(), ((TranslatedSelectBox.TranslatedString)this$0.rankingTypeSelect.getSelected()).getValue())) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        if ((rankingType = (RankingType)v0) == null) {
            rankingType = RankingType.Score;
        }
        victoryScreenCharts.rankingType = rankingType;
        this$0.update();
        return Unit.INSTANCE;
    }

    private static final boolean updateControls$lambda$0(Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isMajorCiv();
    }

    private static final VictoryScreen.CivWithStat updateControls$lambda$1(VictoryScreenCharts this$0, Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new VictoryScreen.CivWithStat(it, this$0.rankingType);
    }

    private static final Unit updateControls$lambda$4(VictoryScreenCharts this$0, VictoryScreen.CivWithStat $civEntry) {
        this$0.selectedCiv = $civEntry.getCiv();
        this$0.update();
        return Unit.INSTANCE;
    }

    private static final boolean getLineChartData$lambda$0(Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isMajorCiv();
    }

    /*
     * Unable to fully structure code
     */
    private static final Iterable getLineChartData$lambda$1(VictoryScreenCharts this$0, RankingType $rankingType, Civilization civ) {
        Intrinsics.checkNotNullParameter(civ, "civ");
        $this$filterKeys$iv = civ.getStatsHistory();
        $i$f$filterKeys = false;
        result$iv = new LinkedHashMap<K, V>();
        for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
            it = ((Number)entry$iv.getKey()).intValue();
            $i$a$-filterKeys-VictoryScreenCharts$getLineChartData$dataPoints$2$1 = false;
            if (this$0.zoomAtX == null) ** GOTO lbl-1000
            Intrinsics.checkNotNull(this$0.zoomAtX);
            var11_15 = var10_14.getFirst();
            v0 = it <= var10_14.getLast() ? var11_15 <= it : false;
            if (v0) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = false;
            }
            if (!v1) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        $this$filterValues$iv = result$iv;
        $i$f$filterValues = false;
        result$iv = new LinkedHashMap<K, V>();
        for (Map.Entry<K, V> entry$iv : $this$filterValues$iv.entrySet()) {
            it = (Map)entry$iv.getValue();
            $i$a$-filterValues-VictoryScreenCharts$getLineChartData$dataPoints$2$2 = false;
            if (!it.containsKey((Object)$rankingType)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        $this$map$iv = result$iv;
        $i$f$map = false;
        result$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>($this$map$iv.size());
        $i$f$mapTo = false;
        for (Map.Entry<K, V> item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            var10_14 = item$iv$iv;
            var14_18 = destination$iv$iv;
            $i$a$-map-VictoryScreenCharts$getLineChartData$dataPoints$2$3 = false;
            turn = ((Number)var10_14.getKey()).intValue();
            data = (Map)var10_14.getValue();
            var14_18.add(new Pair<Integer, Pair<Civilization, V>>(turn, new Pair<Civilization, V>(civ, MapsKt.getValue(data, $rankingType))));
        }
        return (List)destination$iv$iv;
    }
}

