/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization.managers;

import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.Spy;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u001e\u001a\u00020\u0000J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010!\u001a\u00020 J\b\u0010\"\u001a\u00020\u000eH\u0007J\u0006\u0010#\u001a\u00020\u0006J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0007J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000e0(2\u0006\u0010)\u001a\u00020\u0013H\u0007J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00060+2\u0006\u0010,\u001a\u00020-H\u0007J\b\u0010.\u001a\u00020/H\u0007J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00020-0+H\u0007J\u0012\u00101\u001a\u0004\u0018\u00010\u00062\u0006\u0010,\u001a\u00020-H\u0007J\b\u00102\u001a\u00020\u0019H\u0007J\u000e\u00103\u001a\b\u0012\u0004\u0012\u00020\u00060+H\u0007J\u0006\u00104\u001a\u00020 R*\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR!\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u00065"}, d2={"Lcom/unciv/logic/civilization/managers/EspionageManager;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "<init>", "()V", "spyList", "Ljava/util/ArrayList;", "Lcom/unciv/models/Spy;", "Lkotlin/collections/ArrayList;", "getSpyList", "()Ljava/util/ArrayList;", "setSpyList", "(Ljava/util/ArrayList;)V", "erasSpyEarnedFor", "Ljava/util/LinkedHashSet;", "", "Lkotlin/collections/LinkedHashSet;", "getErasSpyEarnedFor", "()Ljava/util/LinkedHashSet;", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "getCivInfo", "()Lcom/unciv/logic/civilization/Civilization;", "setCivInfo", "(Lcom/unciv/logic/civilization/Civilization;)V", "dismissedShouldMoveSpies", "", "getDismissedShouldMoveSpies", "()Z", "setDismissedShouldMoveSpies", "(Z)V", "clone", "setTransients", "", "endTurn", "getSpyName", "addSpy", "getTilesVisibleViaSpies", "Lkotlin/sequences/Sequence;", "Lcom/unciv/logic/map/tile/Tile;", "getTechsToSteal", "", "otherCiv", "getSpiesInCity", "", "city", "Lcom/unciv/logic/city/City;", "getStartingSpyRank", "", "getCitiesWithOurSpies", "getSpyAssignedToCity", "shouldShowMoveSpies", "getIdleSpies", "removeAllSpies", "core"})
@SourceDebugExtension(value={"SMAP\nEspionageManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EspionageManager.kt\ncom/unciv/logic/civilization/managers/EspionageManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,110:1\n1634#2,3:111\n1563#2:114\n1634#2,3:115\n774#2:118\n865#2,2:119\n774#2:121\n865#2,2:122\n774#2:125\n865#2,2:126\n1617#2,9:128\n1869#2:137\n1870#2:139\n1626#2:140\n295#2,2:141\n1761#2,3:143\n774#2:148\n865#2,2:149\n1869#2,2:151\n1#3:124\n1#3:138\n1255#4,2:146\n*S KotlinDebug\n*F\n+ 1 EspionageManager.kt\ncom/unciv/logic/civilization/managers/EspionageManager\n*L\n29#1:111,3\n48#1:114\n48#1:115,3\n49#1:118\n49#1:119,2\n81#1:121\n81#1:122,2\n89#1:125\n89#1:126,2\n89#1:128,9\n89#1:137\n89#1:139\n89#1:140\n91#1:141,2\n97#1:143,3\n100#1:148\n100#1:149,2\n107#1:151,2\n89#1:138\n98#1:146,2\n*E\n"})
public final class EspionageManager
implements IsPartOfGameInfoSerialization {
    @NotNull
    private ArrayList<Spy> spyList = new ArrayList();
    @NotNull
    private final LinkedHashSet<String> erasSpyEarnedFor = new LinkedHashSet();
    public transient Civilization civInfo;
    private transient boolean dismissedShouldMoveSpies;

    @NotNull
    public final ArrayList<Spy> getSpyList() {
        return this.spyList;
    }

    public final void setSpyList(@NotNull ArrayList<Spy> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
        this.spyList = arrayList;
    }

    @NotNull
    public final LinkedHashSet<String> getErasSpyEarnedFor() {
        return this.erasSpyEarnedFor;
    }

    @NotNull
    public final Civilization getCivInfo() {
        Civilization civilization = this.civInfo;
        if (civilization != null) {
            return civilization;
        }
        Intrinsics.throwUninitializedPropertyAccessException("civInfo");
        return null;
    }

    public final void setCivInfo(@NotNull Civilization civilization) {
        Intrinsics.checkNotNullParameter(civilization, "<set-?>");
        this.civInfo = civilization;
    }

    public final boolean getDismissedShouldMoveSpies() {
        return this.dismissedShouldMoveSpies;
    }

    public final void setDismissedShouldMoveSpies(boolean bl) {
        this.dismissedShouldMoveSpies = bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final EspionageManager clone() {
        void $this$mapTo$iv;
        EspionageManager toReturn = new EspionageManager();
        Iterable iterable = this.spyList;
        Collection destination$iv = toReturn.spyList;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            Spy spy = (Spy)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(it.clone());
        }
        toReturn.erasSpyEarnedFor.addAll((Collection<String>)this.erasSpyEarnedFor);
        return toReturn;
    }

    public final void setTransients(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        this.setCivInfo(civInfo);
        Iterator<Spy> iterator2 = this.spyList.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Spy> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Spy spy;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            spy.setTransients(civInfo);
        }
    }

    public final void endTurn() {
        for (Spy spy : CollectionsKt.toList((Iterable)this.spyList)) {
            spy.endTurn();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    @NotNull
    public final String getSpyName() {
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.spyList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Spy spy = (Spy)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        HashSet usedSpyNames = CollectionsKt.toHashSet((List)destination$iv$iv);
        Iterable $this$filter$iv = this.getCivInfo().getNation().getSpyNames();
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!usedSpyNames.contains(it))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List validSpyNames = (List)destination$iv$iv2;
        String string = (String)CollectionsKt.randomOrNull(validSpyNames, Random.Default);
        if (string == null) {
            string = "Spy " + (this.spyList.size() + 1);
        }
        return string;
    }

    @NotNull
    public final Spy addSpy() {
        String spyName = this.getSpyName();
        Spy newSpy = new Spy(spyName, this.getStartingSpyRank());
        newSpy.setTransients(this.getCivInfo());
        this.spyList.add(newSpy);
        return newSpy;
    }

    @Readonly
    @NotNull
    public final Sequence<Tile> getTilesVisibleViaSpies() {
        return SequencesKt.flatMap(SequencesKt.mapNotNull(SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.spyList), EspionageManager::getTilesVisibleViaSpies$lambda$0), EspionageManager::getTilesVisibleViaSpies$lambda$1), EspionageManager::getTilesVisibleViaSpies$lambda$2);
    }

    @Readonly
    @NotNull
    public final Set<String> getTechsToSteal(@NotNull Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        Set techsToSteal = new LinkedHashSet();
        Iterator<String> iterator2 = otherCiv.getTech().getTechsResearched().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<String> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            String tech;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            if (this.getCivInfo().getTech().isResearched(tech) || !this.getCivInfo().getTech().canBeResearched(tech)) continue;
            techsToSteal.add(tech);
        }
        return techsToSteal;
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    @NotNull
    public final List<Spy> getSpiesInCity(@NotNull City city) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(city, "city");
        Iterable $this$filter$iv = this.spyList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Spy it = (Spy)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getCityOrNull(), city)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    public final int getStartingSpyRank() {
        int n;
        Sequence sequence = Civilization.getMatchingUniques$default(this.getCivInfo(), UniqueType.SpyStartingLevel, null, 2, null);
        int n2 = 1;
        int n3 = 0;
        Iterator iterator2 = sequence.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object t = iterator2.next();
            Unique unique = (Unique)t;
            n = n3;
            boolean bl = false;
            int n4 = Integer.parseInt(it.getParams().get(0));
            n3 = n + n4;
        }
        n = n3;
        return n2 + n;
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    @NotNull
    public final List<City> getCitiesWithOurSpies() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.spyList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Spy it = (Spy)element$iv$iv;
            boolean bl = false;
            if (!it.isSetUp()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            City it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Spy it = (Spy)element$iv$iv;
            boolean bl2 = false;
            if (it.getCityOrNull() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Readonly
    @Nullable
    public final Spy getSpyAssignedToCity(@NotNull City city) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(city, "city");
            Iterable $this$firstOrNull$iv = this.spyList;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Spy it = (Spy)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getCityOrNull(), city)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Readonly
    public final boolean shouldShowMoveSpies() {
        boolean bl;
        Object element$iv;
        IsPartOfGameInfoSerialization it;
        if (this.dismissedShouldMoveSpies) return false;
        Object $this$any$iv = this.spyList;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            element$iv = iterator2.next();
            it = (Spy)element$iv;
            boolean bl2 = false;
        } while (!((Spy)it).isIdle());
        boolean bl3 = true;
        if (!bl3) return false;
        $this$any$iv = this.getCivInfo().getGameInfo().getCities();
        $i$f$any = false;
        iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            element$iv = iterator2.next();
            it = (City)element$iv;
            boolean bl4 = false;
            if (this.getCivInfo().hasExplored(((City)it).getCenterTile()) && this.getSpyAssignedToCity((City)it) == null) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    @NotNull
    public final List<Spy> getIdleSpies() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.spyList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Spy it = (Spy)element$iv$iv;
            boolean bl = false;
            if (!it.isIdle()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void removeAllSpies() {
        Iterable $this$forEach$iv = this.spyList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Spy it = (Spy)element$iv;
            boolean bl = false;
            it.moveTo(null);
        }
    }

    private static final boolean getTilesVisibleViaSpies$lambda$0(Spy it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isSetUp();
    }

    private static final City getTilesVisibleViaSpies$lambda$1(Spy it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getCityOrNull();
    }

    private static final Sequence getTilesVisibleViaSpies$lambda$2(City it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getCenterTile().getTilesInDistance(1);
    }
}

