/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.actions.TemporalAction;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.NinePatchDrawable;
import com.unciv.GUI;
import com.unciv.logic.civilization.Notification;
import com.unciv.models.skins.SkinStrings;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.MayaCalendar;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.AutoScrollPane;
import com.unciv.ui.components.widgets.ColorMarkupLabel;
import com.unciv.ui.components.widgets.WrappableLabel;
import com.unciv.ui.images.IconCircleGroup;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.overviewscreen.EmpireOverviewCategories;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Pure;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0013\u0018\u0000 =2\u00020\u0001:\u0006<=>?@AB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010$\u001a\u00020\u000fH\u0014J+\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001a0/2\u0006\u00100\u001a\u00020\u000f2\u0006\u00101\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b2J&\u00103\u001a\u00020\u00172\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001a0/2\u0006\u00100\u001a\u00020\u000f2\u0006\u00101\u001a\u00020\u000fH\u0002J\b\u00104\u001a\u00020-H\u0002J\u0018\u00105\u001a\u00020-2\u0006\u00100\u001a\u00020\u000f2\u0006\u00101\u001a\u00020\u000fH\u0002J\u0010\u00106\u001a\u00020-2\u0006\u00107\u001a\u00020\u000fH\u0014J\b\u00108\u001a\u00020-H\u0002J\b\u00109\u001a\u00020-H\u0002J\u0010\u0010:\u001a\u00020-2\u0006\u0010;\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u000e\u0012\b\u0012\u00060\u001eR\u00020\u0000\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001f\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R*\u0010&\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\u00178F@FX\u0086\u000e\u00a2\u0006\u0012\u0012\u0004\b'\u0010(\u001a\u0004\b&\u0010)\"\u0004\b*\u0010+\u00a8\u0006B"}, d2={"Lcom/unciv/ui/screens/worldscreen/NotificationsScroll;", "Lcom/unciv/ui/components/widgets/AutoScrollPane;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "<init>", "(Lcom/unciv/ui/screens/worldscreen/WorldScreen;)V", "notificationsHash", "", "notificationsTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "topSpacerCell", "Lcom/badlogic/gdx/scenes/scene2d/ui/Cell;", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "bottomSpacerCell", "maxEntryWidth", "", "minCategoryLineWidth", "scrolledAwayEpsilon", "restoreButton", "Lcom/unciv/ui/screens/worldscreen/NotificationsScroll$RestoreButton;", "userSetting", "Lcom/unciv/ui/screens/worldscreen/NotificationsScroll$UserSetting;", "userSettingChanged", "", "enlargeHighlight", "clickedNotification", "Lcom/unciv/logic/civilization/Notification;", "highlightNotification", "coloredHighlight", "selectedCell", "Lcom/unciv/ui/screens/worldscreen/NotificationsScroll$ListItem;", "oneTimeNotification", "getOneTimeNotification", "()Lcom/unciv/logic/civilization/Notification;", "setOneTimeNotification", "(Lcom/unciv/logic/civilization/Notification;)V", "getMouseWheelX", "value", "isHidden", "isHidden$annotations", "()V", "()Z", "setHidden", "(Z)V", "update", "", "notifications", "", "coveredNotificationsTop", "coveredNotificationsBottom", "update$core", "updateContent", "updateLayout", "updateSpacers", "scrollX", "pixelsX", "getUserSetting", "applyUserSettingChange", "updateUserSetting", "newSetting", "UserSetting", "Companion", "CategoryHeader", "ListItem", "RestoreButton", "ButtonFlashAction", "core"})
@SourceDebugExtension(value={"SMAP\nNotificationsScroll.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationsScroll.kt\ncom/unciv/ui/screens/worldscreen/NotificationsScroll\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,623:1\n996#2:624\n1025#2,3:625\n1028#2,3:635\n382#3,7:628\n295#4,2:638\n*S KotlinDebug\n*F\n+ 1 NotificationsScroll.kt\ncom/unciv/ui/screens/worldscreen/NotificationsScroll\n*L\n270#1:624\n270#1:625,3\n270#1:635,3\n270#1:628,7\n568#1:638,2\n*E\n"})
public final class NotificationsScroll
extends AutoScrollPane {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final WorldScreen worldScreen;
    private int notificationsHash;
    @NotNull
    private Table notificationsTable;
    @Nullable
    private Cell<Actor> topSpacerCell;
    @Nullable
    private Cell<Actor> bottomSpacerCell;
    private final float maxEntryWidth;
    private final float minCategoryLineWidth;
    private final float scrolledAwayEpsilon;
    @NotNull
    private final RestoreButton restoreButton;
    private UserSetting userSetting;
    private boolean userSettingChanged;
    private boolean enlargeHighlight;
    @Nullable
    private Notification clickedNotification;
    @Nullable
    private Notification highlightNotification;
    private boolean coloredHighlight;
    @Nullable
    private Cell<ListItem> selectedCell;
    @Nullable
    private Notification oneTimeNotification;
    @Deprecated
    public static final float scaleFactor = 0.5f;
    @Deprecated
    public static final float inverseScaleFactor = 2.0f;
    @Deprecated
    public static final float maxWidthOfStage = 0.333f;
    @Deprecated
    public static final float iconSize = 30.0f;
    @Deprecated
    public static final int fontSize = 30;
    @Deprecated
    public static final float categoryTopPad = 15.0f;
    @Deprecated
    public static final float rightPadToScreenEdge = 10.0f;
    @Deprecated
    public static final float selectionExtraRightPad = 12.0f;
    @Deprecated
    public static final float listItemPad = 3.0f;
    @Deprecated
    public static final float selectedListItemPad = 15.0f;
    @Deprecated
    public static final float categoryHorizontalPad = 13.0f;
    @Deprecated
    public static final float restoreButtonSize = 42.0f;
    @Deprecated
    public static final float restoreButtonPad = 12.0f;
    @Deprecated
    public static final float restoreButtonNumbersSize = 21.0f;
    @Deprecated
    public static final int restoreButtonNumberFontSize = 13;
    @Deprecated
    public static final float restoreButtonNumbersCenter = 31.5f;

    public NotificationsScroll(@NotNull WorldScreen worldScreen) {
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        super(null, null, 2, null);
        this.worldScreen = worldScreen;
        this.notificationsTable = new Table();
        this.maxEntryWidth = this.worldScreen.getStage().getWidth() * 0.333f * 2.0f;
        this.minCategoryLineWidth = this.worldScreen.getStage().getWidth() * 0.075f;
        this.scrolledAwayEpsilon = this.maxEntryWidth * 0.3f;
        this.restoreButton = new RestoreButton();
        this.setActor(this.notificationsTable.right());
        this.setTouchable(Touchable.childrenOnly);
        this.setOverscroll(false, true);
        this.setScale(0.5f);
        this.setHeight(this.worldScreen.getStage().getHeight() * 2.0f);
    }

    @Nullable
    public final Notification getOneTimeNotification() {
        return this.oneTimeNotification;
    }

    public final void setOneTimeNotification(@Nullable Notification notification) {
        this.oneTimeNotification = notification;
    }

    @Override
    protected float getMouseWheelX() {
        return 0.0f;
    }

    public final boolean isHidden() {
        return this.getScrollX() <= this.scrolledAwayEpsilon;
    }

    public final void setHidden(boolean value) {
        this.restoreButton.unblock();
        this.setScrollX(value ? 0.0f : this.getMaxX());
    }

    public static /* synthetic */ void isHidden$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    public final void update$core(@NotNull List<Notification> notifications, float coveredNotificationsTop, float coveredNotificationsBottom) {
        float f;
        float f2;
        Intrinsics.checkNotNullParameter(notifications, "notifications");
        this.getUserSetting();
        UserSetting userSetting = this.userSetting;
        if (userSetting == null) {
            Intrinsics.throwUninitializedPropertyAccessException("userSetting");
            userSetting = null;
        }
        if (userSetting == UserSetting.Disabled) {
            this.restoreButton.setPosition(coveredNotificationsBottom);
            this.applyUserSettingChange();
            this.restoreButton.updateCount(notifications.size());
            return;
        }
        this.enlargeHighlight = GUI.INSTANCE.getSettings().getEnlargeSelectedNotification();
        if (this.isScrollingDisabledX()) {
            f2 = 0.0f;
        } else {
            UserSetting userSetting2 = this.userSetting;
            if (userSetting2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("userSetting");
                userSetting2 = null;
            }
            f2 = userSetting2.getStatic() ? 0.0f : (this.notificationsTable.hasChildren() ? this.getMaxX() - this.getScrollX() : this.getMaxX());
        }
        float previousScrollXinv = f2;
        float previousScrollY = this.getScrollY();
        this.restoreButton.block();
        boolean contentChanged = this.updateContent(notifications, coveredNotificationsTop, coveredNotificationsBottom);
        if (contentChanged) {
            this.updateLayout();
        } else {
            this.updateSpacers(coveredNotificationsTop, coveredNotificationsBottom);
        }
        this.setScrollX(this.getMaxX() - previousScrollXinv);
        NotificationsScroll notificationsScroll = this;
        if (this.selectedCell == null) {
            f = previousScrollY;
        } else {
            void it;
            Cell<ListItem> cell = this.selectedCell;
            Intrinsics.checkNotNull(cell);
            Cell<ListItem> cell2 = cell;
            NotificationsScroll notificationsScroll2 = notificationsScroll;
            boolean bl = false;
            float trueActorY = it.getActorY() + (Intrinsics.areEqual(it.getTable(), this.notificationsTable) ? 0.0f : it.getTable().getY());
            float actualBottom = (trueActorY + this.notificationsTable.getY()) * 0.5f;
            float actualTop = (trueActorY + it.getActorHeight() + this.notificationsTable.getY()) * 0.5f;
            boolean fullyVisible = actualBottom >= coveredNotificationsBottom && actualTop <= this.getStage().getHeight() - coveredNotificationsTop;
            float centeredBottom = (this.getStage().getHeight() - coveredNotificationsTop + coveredNotificationsBottom - it.getActorHeight() * 0.5f) / (float)2;
            float centeredScrollY = centeredBottom * 2.0f - trueActorY + this.getMaxY();
            float f3 = fullyVisible ? previousScrollY : centeredScrollY;
            notificationsScroll = notificationsScroll2;
            f = f3;
        }
        notificationsScroll.setScrollY(f);
        this.updateVisualScroll();
        this.applyUserSettingChange();
        UserSetting userSetting3 = this.userSetting;
        if (userSetting3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("userSetting");
            userSetting3 = null;
        }
        if (!userSetting3.getStatic()) {
            this.restoreButton.unblock();
            if (contentChanged && !this.userSettingChanged && this.isHidden()) {
                this.setHidden(false);
            }
        }
        this.setPosition(this.getStage().getWidth() - this.getWidth() * 0.5f, 0.0f);
        this.restoreButton.setPosition(coveredNotificationsBottom);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean updateContent(List<Notification> notifications, float coveredNotificationsTop, float coveredNotificationsBottom) {
        void $this$groupByTo$iv$iv;
        Iterator $this$groupBy$iv;
        Notification notification;
        this.selectedCell = null;
        if (this.oneTimeNotification == null && this.clickedNotification != null) {
            this.oneTimeNotification = this.clickedNotification;
        }
        Notification notification2 = this.oneTimeNotification;
        int newHash = ((Object)notifications).hashCode() + (notification2 != null ? notification2.hashCode() : 0) * 31;
        this.coloredHighlight = false;
        Sequence<Object> additionalNotification = null;
        additionalNotification = SequencesKt.emptySequence();
        NotificationsScroll notificationsScroll = this;
        if (this.oneTimeNotification == null) {
            notification = this.clickedNotification;
        } else {
            void $this$updateContent_u24lambda_u240;
            Notification notification3;
            Notification notification4 = this.oneTimeNotification;
            Intrinsics.checkNotNull(notification4);
            Notification notification5 = notification3 = notification4;
            NotificationsScroll notificationsScroll2 = notificationsScroll;
            boolean bl = false;
            if (!notifications.contains($this$updateContent_u24lambda_u240)) {
                additionalNotification = SequencesKt.sequenceOf($this$updateContent_u24lambda_u240);
                this.coloredHighlight = true;
            }
            this.oneTimeNotification = null;
            notificationsScroll = notificationsScroll2;
            notification = notification3;
        }
        notificationsScroll.highlightNotification = notification;
        this.clickedNotification = null;
        if (this.notificationsHash == newHash && this.highlightNotification == null) {
            return false;
        }
        this.notificationsHash = newHash;
        this.restoreButton.updateCount(notifications.size());
        this.notificationsTable.clear();
        this.notificationsTable.pack();
        if (notifications.isEmpty() && SequencesKt.none(additionalNotification)) {
            return true;
        }
        List categoryHeaders = new ArrayList();
        List itemWidths = new ArrayList();
        this.topSpacerCell = this.notificationsTable.add().height(coveredNotificationsTop * 2.0f);
        this.notificationsTable.row();
        NinePatchDrawable backgroundDrawable = SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "WorldScreen/Notification", BaseScreen.Companion.getSkinStrings().getRoundedEdgeRectangleShape(), null, 4, null);
        Sequence sequence = SequencesKt.plus(additionalNotification, (Iterable)CollectionsKt.asReversed(notifications));
        boolean $i$f$groupBy = false;
        void var12_16 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            Notification it = (Notification)element$iv$iv;
            boolean bl = false;
            Notification.NotificationCategory key$iv$iv = it.getCategory();
            Map map2 = destination$iv$iv;
            Notification.NotificationCategory key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get((Object)key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        SortedMap orderedNotifications = MapsKt.toSortedMap(destination$iv$iv);
        for (Map.Entry entry : ((Map)orderedNotifications).entrySet()) {
            Notification.NotificationCategory category = (Notification.NotificationCategory)((Object)entry.getKey());
            List categoryNotifications = (List)entry.getValue();
            CategoryHeader header = null;
            if (category == Notification.NotificationCategory.General) {
                this.notificationsTable.add().padTop(15.0f).row();
                header = null;
            } else {
                Intrinsics.checkNotNull((Object)category);
                header = new CategoryHeader(category, backgroundDrawable);
                categoryHeaders.add(header);
                this.notificationsTable.add((Actor)header).right().row();
            }
            Table notificationCategoryTable = new Table();
            NotificationsScroll.updateContent$fillNotificationCategoryTable(categoryNotifications, this, backgroundDrawable, itemWidths, notificationCategoryTable);
            this.notificationsTable.add((Actor)notificationCategoryTable).right().row();
            CategoryHeader categoryHeader = header;
            if (categoryHeader == null) continue;
            ActivationExtensionsKt.onClick(categoryHeader, () -> NotificationsScroll.updateContent$lambda$2(notificationCategoryTable, categoryNotifications, this, backgroundDrawable, itemWidths));
        }
        float newHeaderWidth = (float)CollectionsKt.averageOfFloat(itemWidths);
        for (CategoryHeader header : categoryHeaders) {
            header.increaseWidthTo(newHeaderWidth);
        }
        this.bottomSpacerCell = this.notificationsTable.add().height(coveredNotificationsBottom * 2.0f).expandY();
        this.notificationsTable.row();
        this.highlightNotification = null;
        return true;
    }

    private final void updateLayout() {
        this.setWidth(Scene2dExtensionsKt.packIfNeeded(this.notificationsTable).getWidth());
        Cell<Actor> cell = this.topSpacerCell;
        if (cell != null) {
            cell.width((float)2 * this.getWidth());
        }
        this.notificationsTable.invalidate();
        this.notificationsTable.pack();
        this.layout();
    }

    private final void updateSpacers(float coveredNotificationsTop, float coveredNotificationsBottom) {
        Cell<Actor> cell = this.topSpacerCell;
        if (cell != null) {
            cell.height(coveredNotificationsTop * 2.0f);
        }
        Cell<Actor> cell2 = this.bottomSpacerCell;
        if (cell2 != null) {
            cell2.height(coveredNotificationsBottom * 2.0f);
        }
        this.layout();
    }

    @Override
    protected void scrollX(float pixelsX) {
        super.scrollX(pixelsX);
        if (this.getMaxX() < 5.0f) {
            return;
        }
        this.restoreButton.checkScrollX(pixelsX);
    }

    private final void getUserSetting() {
        UserSetting setting;
        UserSetting userSetting;
        Object v0;
        block5: {
            String settingString = GUI.INSTANCE.getSettings().getNotificationScroll();
            Iterable $this$firstOrNull$iv = UserSetting.getEntries();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                UserSetting it = (UserSetting)((Object)element$iv);
                boolean bl = false;
                if (!Intrinsics.areEqual(it.name(), settingString)) continue;
                v0 = element$iv;
                break block5;
            }
            v0 = null;
        }
        if ((userSetting = (UserSetting)v0) == null) {
            userSetting = setting = UserSetting.Companion.default();
        }
        if (this.userSetting != null) {
            UserSetting userSetting2 = this.userSetting;
            if (userSetting2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("userSetting");
                userSetting2 = null;
            }
            if (setting == userSetting2) {
                this.userSettingChanged = false;
                return;
            }
        }
        this.userSetting = setting;
        this.userSettingChanged = true;
        this.notificationsTable.clear();
        this.notificationsHash = 0;
        this.setScrollX(0.0f);
        this.updateVisualScroll();
        this.setScrollingDisabled(false, false);
        this.setVisible(false);
    }

    private final void applyUserSettingChange() {
        UserSetting userSetting;
        if (!this.userSettingChanged) {
            return;
        }
        this.restoreButton.block();
        boolean fromPermanent = this.isScrollingDisabledX();
        UserSetting userSetting2 = this.userSetting;
        if (userSetting2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("userSetting");
            userSetting2 = null;
        }
        this.setScrollingDisabled(userSetting2.getStatic(), false);
        if (fromPermanent) {
            this.validate();
            this.setScrollX(this.getMaxX());
            this.updateVisualScroll();
        }
        if ((userSetting = this.userSetting) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("userSetting");
            userSetting = null;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[userSetting.ordinal()]) {
            case 1: {
                if (!this.isHidden()) {
                    this.setHidden(true);
                }
                this.restoreButton.show();
                break;
            }
            case 2: {
                if (this.isHidden()) {
                    this.setHidden(false);
                }
                this.restoreButton.hide();
                break;
            }
            case 3: {
                this.restoreButton.hide();
                break;
            }
            case 4: {
                this.restoreButton.show();
                return;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.setVisible(true);
    }

    private final void updateUserSetting(UserSetting newSetting) {
        block6: {
            block5: {
                UserSetting userSetting = this.userSetting;
                if (userSetting == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("userSetting");
                    userSetting = null;
                }
                if (newSetting == userSetting) break block5;
                UserSetting userSetting2 = this.userSetting;
                if (userSetting2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("userSetting");
                    userSetting2 = null;
                }
                if (!userSetting2.getStatic()) break block6;
            }
            return;
        }
        this.userSetting = newSetting;
        GUI.INSTANCE.getSettings().setNotificationScroll(newSetting.name());
    }

    private static final void updateContent$fillNotificationCategoryTable(List<Notification> categoryNotifications, NotificationsScroll this$0, NinePatchDrawable backgroundDrawable, List<Float> itemWidths, Table notificationCategoryTable) {
        for (Notification notification : categoryNotifications) {
            ListItem item = this$0.new ListItem(notification, backgroundDrawable);
            itemWidths.add(Float.valueOf(item.getItemWidth()));
            Cell<Actor> itemCell = notificationCategoryTable.add((Actor)item);
            if (Intrinsics.areEqual(notification, this$0.highlightNotification)) {
                this$0.selectedCell = itemCell;
            }
            itemCell.right().row();
        }
    }

    private static final Unit updateContent$lambda$2(Table $notificationCategoryTable, List $categoryNotifications, NotificationsScroll this$0, NinePatchDrawable $backgroundDrawable, List $itemWidths) {
        if ($notificationCategoryTable.hasChildren()) {
            $notificationCategoryTable.clear();
            $notificationCategoryTable.pack();
        } else {
            NotificationsScroll.updateContent$fillNotificationCategoryTable($categoryNotifications, this$0, $backgroundDrawable, $itemWidths, $notificationCategoryTable);
            $notificationCategoryTable.pack();
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/unciv/ui/screens/worldscreen/NotificationsScroll$ButtonFlashAction;", "Lcom/badlogic/gdx/scenes/scene2d/actions/TemporalAction;", "icon", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "<init>", "(Lcom/badlogic/gdx/scenes/scene2d/Actor;)V", "tempColor", "Lcom/badlogic/gdx/graphics/Color;", "getTempColor", "()Lcom/badlogic/gdx/graphics/Color;", "update", "", "percent", "", "core"})
    private static final class ButtonFlashAction
    extends TemporalAction {
        @NotNull
        private final Actor icon;
        @NotNull
        private final Color tempColor;

        public ButtonFlashAction(@NotNull Actor icon) {
            Intrinsics.checkNotNullParameter(icon, "icon");
            super(4.0f);
            this.icon = icon;
            this.tempColor = new Color();
        }

        @NotNull
        public final Color getTempColor() {
            return this.tempColor;
        }

        @Override
        protected void update(float percent) {
            float shift = (1.0f - MathUtils.cos(12.0f * percent * (float)Math.PI)) / 2.0f;
            this.tempColor.set(Color.WHITE).lerp(Color.RED, shift);
            this.icon.getColor().set(this.tempColor);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/unciv/ui/screens/worldscreen/NotificationsScroll$CategoryHeader;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "category", "Lcom/unciv/logic/civilization/Notification$NotificationCategory;", "Lcom/unciv/logic/civilization/NotificationCategory;", "backgroundDrawable", "Lcom/badlogic/gdx/scenes/scene2d/utils/NinePatchDrawable;", "<init>", "(Lcom/unciv/ui/screens/worldscreen/NotificationsScroll;Lcom/unciv/logic/civilization/Notification$NotificationCategory;Lcom/badlogic/gdx/scenes/scene2d/utils/NinePatchDrawable;)V", "leftLineCell", "Lcom/badlogic/gdx/scenes/scene2d/ui/Cell;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "rightLineCell", "captionWidth", "", "increaseWidthTo", "", "newWidth", "core"})
    private final class CategoryHeader
    extends Table {
        @NotNull
        private final Cell<Image> leftLineCell;
        @NotNull
        private final Cell<Image> rightLineCell;
        private final float captionWidth;

        /*
         * WARNING - void declaration
         */
        public CategoryHeader(@NotNull Notification.NotificationCategory category, NinePatchDrawable backgroundDrawable) {
            void $this$_init__u24lambda_u240;
            Table table2;
            Intrinsics.checkNotNullParameter((Object)category, "category");
            Intrinsics.checkNotNullParameter(backgroundDrawable, "backgroundDrawable");
            this.setTouchable(Touchable.enabled);
            this.add().padTop(15.0f).colspan(3).row();
            Cell<Actor> cell = this.add((Actor)ImageGetter.INSTANCE.getWhiteDot()).minHeight(2.0f).width(NotificationsScroll.this.minCategoryLineWidth);
            Intrinsics.checkNotNullExpressionValue(cell, "width(...)");
            this.leftLineCell = cell;
            Table table3 = table2 = new Table();
            CategoryHeader categoryHeader = this;
            boolean bl = false;
            $this$_init__u24lambda_u240.setBackground(backgroundDrawable);
            ColorMarkupLabel label = new ColorMarkupLabel(category.name(), ImageGetter.INSTANCE.getCHARCOAL(), null, 30, 4, null);
            $this$_init__u24lambda_u240.add((Actor)label);
            this.captionWidth = $this$_init__u24lambda_u240.getPrefWidth();
            categoryHeader.add((Actor)table2).pad(3.0f);
            float rightPad = 23.0f + (!NotificationsScroll.this.enlargeHighlight || NotificationsScroll.this.highlightNotification == null ? 0.0f : 12.0f);
            Cell<Actor> cell2 = this.add((Actor)ImageGetter.INSTANCE.getWhiteDot()).minHeight(2.0f).width(NotificationsScroll.this.minCategoryLineWidth).padRight(rightPad);
            Intrinsics.checkNotNullExpressionValue(cell2, "padRight(...)");
            this.rightLineCell = cell2;
        }

        public final void increaseWidthTo(float newWidth) {
            float lineLength = (newWidth - this.captionWidth - 6.0f) * 0.5f - 13.0f;
            if (lineLength <= NotificationsScroll.this.minCategoryLineWidth) {
                return;
            }
            this.leftLineCell.width(lineLength);
            this.rightLineCell.width(lineLength);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/unciv/ui/screens/worldscreen/NotificationsScroll$Companion;", "", "<init>", "()V", "scaleFactor", "", "inverseScaleFactor", "maxWidthOfStage", "iconSize", "fontSize", "", "categoryTopPad", "rightPadToScreenEdge", "selectionExtraRightPad", "listItemPad", "selectedListItemPad", "categoryHorizontalPad", "restoreButtonSize", "restoreButtonPad", "restoreButtonNumbersSize", "restoreButtonNumberFontSize", "restoreButtonNumbersCenter", "oneTimeNotificationColor", "Lcom/badlogic/gdx/graphics/Color;", "getOneTimeNotificationColor", "()Lcom/badlogic/gdx/graphics/Color;", "core"})
    private static final class Companion {
        private Companion() {
        }

        private final Color getOneTimeNotificationColor() {
            return BaseScreen.Companion.getSkinStrings().getUIColor("NotificationScroll/OneTimeNotificationColor", Color.valueOf("#fceea8"));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/unciv/ui/screens/worldscreen/NotificationsScroll$ListItem;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "notification", "Lcom/unciv/logic/civilization/Notification;", "backgroundDrawable", "Lcom/badlogic/gdx/scenes/scene2d/utils/NinePatchDrawable;", "<init>", "(Lcom/unciv/ui/screens/worldscreen/NotificationsScroll;Lcom/unciv/logic/civilization/Notification;Lcom/badlogic/gdx/scenes/scene2d/utils/NinePatchDrawable;)V", "itemWidth", "", "getItemWidth", "()F", "core"})
    private final class ListItem
    extends Table {
        private final float itemWidth;

        public ListItem(@NotNull Notification notification, NinePatchDrawable backgroundDrawable) {
            Cell<Actor> cell;
            Intrinsics.checkNotNullParameter(notification, "notification");
            Intrinsics.checkNotNullParameter(backgroundDrawable, "backgroundDrawable");
            boolean isSelected = notification == NotificationsScroll.this.highlightNotification;
            boolean isEnlarged = isSelected && NotificationsScroll.this.enlargeHighlight;
            int labelFontSize = isEnlarged ? 45 : 30;
            float itemIconSize = isEnlarged ? 45.0f : 30.0f;
            float topBottomPad = isEnlarged ? 15.0f : 3.0f;
            Table listItem = new Table();
            listItem.setBackground(!isSelected || !NotificationsScroll.this.coloredHighlight ? (Drawable)backgroundDrawable : (Drawable)BaseScreen.Companion.getSkinStrings().getUiBackground("WorldScreen/Notification", BaseScreen.Companion.getSkinStrings().getRoundedEdgeRectangleShape(), Companion.getOneTimeNotificationColor()));
            float maxLabelWidth = NotificationsScroll.this.maxEntryWidth - (itemIconSize + 5.0f) * (float)notification.getIcons().size() - 10.0f;
            WrappableLabel label = new WrappableLabel(notification.getText(), maxLabelWidth, ImageGetter.INSTANCE.getCHARCOAL(), labelFontSize, true);
            label.setAlignment(1);
            if (label.getPrefWidth() > maxLabelWidth * 0.5f) {
                label.setWrap(true);
                cell = listItem.add((Actor)label).maxWidth(label.optimizePrefWidth()).padRight(10.0f);
            } else {
                cell = listItem.add((Actor)label).padRight(10.0f);
            }
            notification.addNotificationIconsTo(listItem, NotificationsScroll.this.worldScreen.getGameInfo().getRuleset(), itemIconSize);
            this.itemWidth = listItem.getPrefWidth();
            this.add((Actor)listItem).pad(topBottomPad, 3.0f, topBottomPad, 10.0f);
            this.setTouchable(Touchable.enabled);
            ActivationExtensionsKt.onClick(this, () -> ListItem._init_$lambda$0(notification, NotificationsScroll.this));
        }

        public final float getItemWidth() {
            return this.itemWidth;
        }

        private static final Unit _init_$lambda$0(Notification $notification, NotificationsScroll this$0) {
            $notification.execute(this$0.worldScreen);
            this$0.clickedNotification = $notification;
            GUI.INSTANCE.setUpdateWorldOnNextRender();
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\f\u0010\u0015\u001a\u00020\u0012*\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\nJ\u0006\u0010\u0019\u001a\u00020\u0012J\u0006\u0010\u001a\u001a\u00020\u0012J\u0006\u0010\u001b\u001a\u00020\u0012J\u0006\u0010\u001c\u001a\u00020\u0012J\u000e\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0014J\u0006\u0010\u001f\u001a\u00020\u0012J\u0006\u0010 \u001a\u00020\u0012J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u0014H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/unciv/ui/screens/worldscreen/NotificationsScroll$RestoreButton;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Container;", "Lcom/unciv/ui/images/IconCircleGroup;", "<init>", "(Lcom/unciv/ui/screens/worldscreen/NotificationsScroll;)V", "blockCheck", "", "blockAct", "active", "shownCount", "", "countLabel", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "bellIcon", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "labelInnerCircle", "labelOuterCircle", "setPosition", "", "coveredNotificationsBottom", "", "centerAtNumberPosition", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "updateCount", "count", "block", "unblock", "show", "hide", "checkScrollX", "scrollX", "clicked", "flash", "act", "delta", "core"})
    public final class RestoreButton
    extends Container<IconCircleGroup> {
        private boolean blockCheck = true;
        private boolean blockAct = true;
        private boolean active;
        private int shownCount = -1;
        @NotNull
        private final Label countLabel;
        @NotNull
        private final Image bellIcon = ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Notifications", null, 2, null);
        @NotNull
        private final Image labelInnerCircle;
        @NotNull
        private final Image labelOuterCircle;

        public RestoreButton() {
            this.setActor((Actor)Scene2dExtensionsKt.surroundWithCircle$default(Scene2dExtensionsKt.surroundWithCircle$default(this.bellIcon, 37.8f, false, BaseScreen.Companion.getSkinStrings().getSkinConfig().getBaseColor(), null, 10, null), 42.0f, false, null, null, 12, null));
            this.size(42.0f);
            this.countLabel = Scene2dExtensionsKt.toLabel$default("", ImageGetter.INSTANCE.getCHARCOAL(), 13, 1, false, 8, null);
            Color color = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color, "WHITE");
            this.labelInnerCircle = ImageGetter.INSTANCE.getCircle(color, Float.valueOf(18.9f));
            this.centerAtNumberPosition(this.labelInnerCircle);
            this.labelOuterCircle = ImageGetter.INSTANCE.getCircle(ImageGetter.INSTANCE.getCHARCOAL(), Float.valueOf(21.0f));
            this.centerAtNumberPosition(this.labelOuterCircle);
            ((IconCircleGroup)this.getActor()).addActor(this.labelOuterCircle);
            ((IconCircleGroup)this.getActor()).addActor(this.labelInnerCircle);
            ((IconCircleGroup)this.getActor()).addActor(this.countLabel);
            this.setColor(this.getColor().cpy());
            this.getColor().a = 0.0f;
            ActivationExtensionsKt.onClick(this, new Function0<Unit>((Object)this){

                @Override
                public final void invoke() {
                    ((RestoreButton)this.receiver).clicked();
                }
            });
            this.pack();
        }

        public final void setPosition(float coveredNotificationsBottom) {
            this.setPosition(NotificationsScroll.this.getStage().getWidth() - 12.0f, coveredNotificationsBottom + 12.0f, 20);
        }

        private final void centerAtNumberPosition(Actor $this$centerAtNumberPosition) {
            $this$centerAtNumberPosition.setPosition(31.5f, 31.5f, 1);
        }

        public final void updateCount(int count2) {
            if (count2 == this.shownCount) {
                return;
            }
            this.shownCount = count2;
            String countText = count2 >= 100 ? "+" : (NotificationsScroll.this.worldScreen.getSelectedCiv().isLongCountDisplay() ? MayaCalendar.INSTANCE.toMayaNumerals(count2) : TranslationsKt.tr(count2));
            this.countLabel.setText(countText);
            this.countLabel.pack();
            this.centerAtNumberPosition(this.countLabel);
            if (this.active) {
                this.flash();
            }
        }

        public final void block() {
            this.blockCheck = true;
            this.blockAct = true;
        }

        public final void unblock() {
            this.blockCheck = false;
            this.blockAct = false;
        }

        public final void show() {
            this.active = true;
            this.clearActions();
            NotificationsScroll.this.updateUserSetting(UserSetting.Hidden);
            if (this.getParent() == null) {
                NotificationsScroll.this.worldScreen.getStage().getRoot().addActorAfter(NotificationsScroll.this, this);
            }
            this.blockAct = false;
            this.addAction(Actions.fadeIn(1.0f));
            UserSetting userSetting = NotificationsScroll.this.userSetting;
            if (userSetting == null) {
                Intrinsics.throwUninitializedPropertyAccessException("userSetting");
                userSetting = null;
            }
            if (userSetting == UserSetting.Disabled) {
                this.flash();
            }
        }

        public final void hide() {
            this.active = false;
            this.clearActions();
            NotificationsScroll.this.updateUserSetting(UserSetting.Visible);
            if (this.getParent() == null) {
                return;
            }
            this.blockAct = false;
            this.addAction(Actions.sequence((Action)Actions.fadeOut(0.333f), (Action)Actions.run(() -> RestoreButton.hide$lambda$0(this))));
        }

        public final void checkScrollX(float scrollX) {
            if (this.blockCheck) {
                return;
            }
            if (this.active && scrollX >= NotificationsScroll.this.scrolledAwayEpsilon * 1.2f) {
                this.hide();
            }
            if (!this.active && scrollX <= NotificationsScroll.this.scrolledAwayEpsilon) {
                this.show();
            }
        }

        public final void clicked() {
            UserSetting userSetting = NotificationsScroll.this.userSetting;
            if (userSetting == null) {
                Intrinsics.throwUninitializedPropertyAccessException("userSetting");
                userSetting = null;
            }
            if (userSetting == UserSetting.Disabled) {
                WorldScreen.openEmpireOverview$default(NotificationsScroll.this.worldScreen, EmpireOverviewCategories.Notifications, null, 2, null);
            } else {
                NotificationsScroll.this.setScrollX(NotificationsScroll.this.getMaxX());
                this.hide();
            }
        }

        public final void flash() {
            this.addAction(new ButtonFlashAction(this.bellIcon));
        }

        @Override
        public void act(float delta) {
            if (!this.blockAct) {
                super.act(delta);
            }
        }

        private static final void hide$lambda$0(RestoreButton this$0) {
            this$0.remove();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\fB\u0013\b\u0002\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\r"}, d2={"Lcom/unciv/ui/screens/worldscreen/NotificationsScroll$UserSetting;", "", "static", "", "<init>", "(Ljava/lang/String;IZ)V", "getStatic", "()Z", "Disabled", "Hidden", "Visible", "Permanent", "Companion", "core"})
    public static final class UserSetting
    extends Enum<UserSetting> {
        @NotNull
        public static final Companion Companion;
        private final boolean static;
        public static final /* enum */ UserSetting Disabled;
        public static final /* enum */ UserSetting Hidden;
        public static final /* enum */ UserSetting Visible;
        public static final /* enum */ UserSetting Permanent;
        private static final /* synthetic */ UserSetting[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private UserSetting(boolean bl) {
            this.static = bl;
        }

        /* synthetic */ UserSetting(String string, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                bl = false;
            }
            this(bl);
        }

        public final boolean getStatic() {
            return this.static;
        }

        public static UserSetting[] values() {
            return (UserSetting[])$VALUES.clone();
        }

        public static UserSetting valueOf(String value) {
            return Enum.valueOf(UserSetting.class, value);
        }

        @NotNull
        public static EnumEntries<UserSetting> getEntries() {
            return $ENTRIES;
        }

        static {
            Disabled = new UserSetting(true);
            Hidden = new UserSetting("Hidden", 1, false, 1, null);
            Visible = new UserSetting("Visible", 2, false, 1, null);
            Permanent = new UserSetting(true);
            $VALUES = userSettingArray = new UserSetting[]{UserSetting.Disabled, UserSetting.Hidden, UserSetting.Visible, UserSetting.Permanent};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/unciv/ui/screens/worldscreen/NotificationsScroll$UserSetting$Companion;", "", "<init>", "()V", "default", "Lcom/unciv/ui/screens/worldscreen/NotificationsScroll$UserSetting;", "core"})
        public static final class Companion {
            private Companion() {
            }

            @Pure
            @NotNull
            public final UserSetting default() {
                return Visible;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[UserSetting.values().length];
            try {
                nArray[UserSetting.Hidden.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UserSetting.Visible.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UserSetting.Permanent.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UserSetting.Disabled.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

