/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.automation.unit;

import com.unciv.logic.battle.AttackableTile;
import com.unciv.logic.battle.Battle;
import com.unciv.logic.battle.BattleDamage;
import com.unciv.logic.battle.CityCombatant;
import com.unciv.logic.battle.ICombatant;
import com.unciv.logic.battle.MapUnitCombatant;
import com.unciv.logic.battle.TargetHelper;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.movement.PathsToTilesWithinTurn;
import com.unciv.logic.map.mapunit.movement.UnitMovement;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.UniqueType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0005J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J \u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0003J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0003J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u000bH\u0003\u00a8\u0006\u0015"}, d2={"Lcom/unciv/logic/automation/unit/BattleHelper;", "", "<init>", "()V", "tryAttackNearbyEnemy", "", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "stayOnTile", "tryDisembarkUnitToAttackPosition", "chooseAttackTarget", "Lcom/unciv/logic/battle/AttackableTile;", "attackableEnemies", "", "getCityAttackValue", "", "attacker", "city", "Lcom/unciv/logic/city/City;", "getUnitAttackValue", "attackTile", "core"})
@SourceDebugExtension(value={"SMAP\nBattleHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BattleHelper.kt\ncom/unciv/logic/automation/unit/BattleHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,184:1\n777#2:185\n873#2,2:186\n777#2:188\n873#2,2:189\n777#2:191\n873#2,2:192\n1297#3,3:194\n1342#3,2:197\n*S KotlinDebug\n*F\n+ 1 BattleHelper.kt\ncom/unciv/logic/automation/unit/BattleHelper\n*L\n23#1:185\n23#1:186,2\n55#1:188\n55#1:189,2\n61#1:191\n61#1:192,2\n118#1:194,3\n138#1:197,2\n*E\n"})
public final class BattleHelper {
    @NotNull
    public static final BattleHelper INSTANCE = new BattleHelper();

    private BattleHelper() {
    }

    /*
     * WARNING - void declaration
     */
    public final boolean tryAttackNearbyEnemy(@NotNull MapUnit unit, boolean stayOnTile) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(unit, "unit");
        if (MapUnit.hasUnique$default(unit, UniqueType.CannotAttack, null, false, 6, null)) {
            return false;
        }
        PathsToTilesWithinTurn distanceToTiles = UnitMovement.getDistanceToTiles$default(unit.getMovement(), false, null, null, false, 15, null);
        Iterable iterable = TargetHelper.getAttackableEnemies$default(TargetHelper.INSTANCE, unit, UnitMovement.getDistanceToTiles$default(unit.getMovement(), false, null, null, false, 15, null), null, stayOnTile, 4, null);
        boolean $i$f$filter = false;
        void var7_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AttackableTile it = (AttackableTile)element$iv$iv;
            boolean bl = false;
            ICombatant defender = Battle.INSTANCE.getMapCombatantOfTile(it.getTileToAttack());
            if (!(MapUnit.hasUnique$default(unit, UniqueType.SelfDestructs, null, false, 6, null) || defender != null && BattleDamage.calculateDamageToAttacker$default(BattleDamage.INSTANCE, new MapUnitCombatant(unit), defender, null, 0.0f, 12, null) < unit.getHealth() && unit.getDamageFromTerrain(it.getTileToAttackFrom()) <= 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List attackableEnemies = (List)destination$iv$iv;
        AttackableTile enemyTileToAttack = this.chooseAttackTarget(unit, attackableEnemies);
        if (enemyTileToAttack != null) {
            if (enemyTileToAttack.getTileToAttack().getMilitaryUnit() == null && unit.getBaseUnit().isRanged() && UnitMovement.canMoveTo$default(unit.getMovement(), enemyTileToAttack.getTileToAttack(), false, false, false, 14, null) && distanceToTiles.containsKey((Object)enemyTileToAttack.getTileToAttack())) {
                UnitMovement.moveToTile$default(unit.getMovement(), enemyTileToAttack.getTileToAttack(), false, 2, null);
            } else {
                Battle.INSTANCE.moveAndAttack(new MapUnitCombatant(unit), enemyTileToAttack);
            }
        }
        return !unit.hasMovement();
    }

    public static /* synthetic */ boolean tryAttackNearbyEnemy$default(BattleHelper battleHelper, MapUnit mapUnit, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return battleHelper.tryAttackNearbyEnemy(mapUnit, bl);
    }

    public final boolean tryDisembarkUnitToAttackPosition(@NotNull MapUnit unit) {
        AttackableTile it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(unit, "unit");
        if (!(unit.getBaseUnit().isMelee() && unit.getBaseUnit().isLandUnit() && unit.isEmbarked())) {
            return false;
        }
        PathsToTilesWithinTurn unitDistanceToTiles = UnitMovement.getDistanceToTiles$default(unit.getMovement(), false, null, null, false, 15, null);
        Iterable iterable = TargetHelper.getAttackableEnemies$default(TargetHelper.INSTANCE, unit, unitDistanceToTiles, null, false, 12, null);
        boolean $i$f$filter = false;
        void var6_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (AttackableTile)element$iv$iv;
            boolean bl = false;
            ICombatant iCombatant = new MapUnitCombatant(unit);
            ICombatant iCombatant2 = Battle.INSTANCE.getMapCombatantOfTile(it.getTileToAttack());
            Intrinsics.checkNotNull(iCombatant2);
            boolean bl2 = BattleDamage.calculateDamageToAttacker$default(BattleDamage.INSTANCE, iCombatant, iCombatant2, null, 0.0f, 12, null) < unit.getHealth();
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (AttackableTile)element$iv$iv;
            boolean bl = false;
            if (!it.getTileToAttackFrom().isLand()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List attackableEnemiesNextTurn = (List)destination$iv$iv;
        AttackableTile enemyTileToAttackNextTurn = this.chooseAttackTarget(unit, attackableEnemiesNextTurn);
        if (enemyTileToAttackNextTurn != null) {
            UnitMovement.moveToTile$default(unit.getMovement(), enemyTileToAttackNextTurn.getTileToAttackFrom(), false, 2, null);
            return true;
        }
        return false;
    }

    @Readonly
    private final AttackableTile chooseAttackTarget(MapUnit unit, List<AttackableTile> attackableEnemies) {
        int highestAttackValue = 0;
        AttackableTile attackTile = null;
        for (AttackableTile attackableEnemy : attackableEnemies) {
            int tempAttackValue;
            int n;
            if (attackableEnemy.getTileToAttack().isCityCenter()) {
                City city = attackableEnemy.getTileToAttack().getCity();
                Intrinsics.checkNotNull(city);
                n = this.getCityAttackValue(unit, city);
            } else {
                n = this.getUnitAttackValue(unit, attackableEnemy);
            }
            if ((tempAttackValue = n) <= highestAttackValue) continue;
            highestAttackValue = tempAttackValue;
            attackTile = attackableEnemy;
        }
        return highestAttackValue > 30 ? attackTile : null;
    }

    @Readonly
    private final int getCityAttackValue(MapUnit attacker, City city) {
        boolean canCaptureCity;
        MapUnitCombatant attackerUnit = new MapUnitCombatant(attacker);
        CityCombatant cityUnit = new CityCombatant(city);
        boolean bl = canCaptureCity = attacker.getBaseUnit().isMelee() && !MapUnit.hasUnique$default(attacker, UniqueType.CannotCaptureCities, null, false, 6, null);
        if (city.getHealth() == 1) {
            return canCaptureCity ? 10000 : 0;
        }
        if (canCaptureCity && city.getHealth() <= RangesKt.coerceAtLeast(BattleDamage.calculateDamageToDefender$default(BattleDamage.INSTANCE, attackerUnit, cityUnit, null, 0.0f, 12, null), 1)) {
            return 10000;
        }
        if (attacker.getBaseUnit().isMelee()) {
            int battleDamage = BattleDamage.calculateDamageToAttacker$default(BattleDamage.INSTANCE, attackerUnit, cityUnit, null, 0.0f, 12, null);
            if (attacker.getHealth() - battleDamage * 2 <= 0 && !MapUnit.hasUnique$default(attacker, UniqueType.SelfDestructs, null, false, 6, null)) {
                Sequence<Tile> $this$count$iv = city.getCenterTile().getTilesInDistance(3);
                boolean $i$f$count = false;
                int count$iv = 0;
                Iterator<Tile> iterator2 = $this$count$iv.iterator();
                while (iterator2.hasNext()) {
                    Tile element$iv;
                    Tile it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    MapUnit mapUnit = it.getMilitaryUnit();
                    if (!Intrinsics.areEqual(mapUnit != null ? mapUnit.getCiv() : null, attacker.getCiv()) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                int friendlyUnitsAroundCity = count$iv;
                if (friendlyUnitsAroundCity < 5) {
                    double attackerHealthModifier = 1.0 + 1.0 / (double)friendlyUnitsAroundCity;
                    if ((double)attacker.getHealth() - (double)battleDamage * attackerHealthModifier <= 0.0) {
                        return 0;
                    }
                }
            }
        }
        int attackValue = 0;
        attackValue = 100;
        if (attacker.getBaseUnit().isProbablySiegeUnit()) {
            attackValue += 100;
        } else if (attacker.getBaseUnit().isRanged()) {
            attackValue += 10;
        }
        attackValue -= (city.getHealth() - 60) / 2;
        Civilization defendingCityCiv = city.getCiv();
        Sequence<Tile> $this$forEach$iv = city.getCenterTile().getTilesInDistance(2);
        boolean $i$f$forEach = false;
        Iterator<Tile> iterator3 = $this$forEach$iv.iterator();
        while (iterator3.hasNext()) {
            Tile element$iv;
            Tile it = element$iv = iterator3.next();
            boolean bl3 = false;
            if (it.getMilitaryUnit() == null) continue;
            MapUnit mapUnit = it.getMilitaryUnit();
            Intrinsics.checkNotNull(mapUnit);
            if (mapUnit.getCiv().isAtWarWith(attacker.getCiv())) {
                attackValue -= 5;
            }
            MapUnit mapUnit2 = it.getMilitaryUnit();
            Intrinsics.checkNotNull(mapUnit2);
            if (!mapUnit2.getCiv().isAtWarWith(defendingCityCiv)) continue;
            attackValue += 15;
        }
        return attackValue;
    }

    @Readonly
    private final int getUnitAttackValue(MapUnit attacker, AttackableTile attackTile) {
        int attackValue = Integer.MIN_VALUE;
        MapUnit militaryUnit = attackTile.getTileToAttack().getMilitaryUnit();
        MapUnit civilianUnit = attackTile.getTileToAttack().getCivilianUnit();
        if (militaryUnit != null) {
            attackValue = 200 - militaryUnit.getHealth() + BattleDamage.calculateDamageToDefender$default(BattleDamage.INSTANCE, new MapUnitCombatant(attacker), new MapUnitCombatant(militaryUnit), null, 0.0f, 12, null);
        } else if (civilianUnit != null) {
            attackValue = 50;
            if (attacker.getBaseUnit().isMelee() || attacker.getMovement().canReachInCurrentTurn(attackTile.getTileToAttack())) {
                if (civilianUnit.isGreatPerson()) {
                    attackValue += 150;
                }
                if (MapUnit.hasUnique$default(civilianUnit, UniqueType.FoundCity, GameContext.Companion.getIgnoreConditionals(), false, 4, null)) {
                    attackValue += 60;
                }
            } else if (attacker.getBaseUnit().isRanged() && !MapUnit.hasUnique$default(civilianUnit, UniqueType.Uncapturable, null, false, 6, null)) {
                return 10;
            }
        }
        return attackValue += (int)(attackTile.getMovementLeftAfterMovingToAttackTile() * (float)5);
    }
}

