/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.battle;

import com.unciv.logic.battle.AirInterception;
import com.unciv.logic.battle.Battle;
import com.unciv.logic.battle.CityCombatant;
import com.unciv.logic.battle.ICombatant;
import com.unciv.logic.battle.MapUnitCombatant;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.CivilopediaAction;
import com.unciv.logic.civilization.LocationAction;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.NotificationAction;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.DiplomaticModifiers;
import com.unciv.logic.civilization.diplomacy.DiplomaticStatus;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.RoadStatus;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.random.Random;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJP\u0010\r\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00072\u0016\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u00112\u0006\u0010\u0012\u001a\u00020\u00102\u0016\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u0011H\u0002JZ\u0010\u0014\u001a.\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u0011\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u00110\u00152\u0006\u0010\u0012\u001a\u00020\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u00172\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J(\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\tH\u0002J \u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"H\u0002J\u0014\u0010#\u001a\u00020\"*\u00020 2\u0006\u0010$\u001a\u00020%H\u0003\u00a8\u0006&"}, d2={"Lcom/unciv/logic/battle/Nuke;", "", "<init>", "()V", "mayUseNuke", "", "nuke", "Lcom/unciv/logic/battle/MapUnitCombatant;", "targetTile", "Lcom/unciv/logic/map/tile/Tile;", "NUKE", "", "attacker", "addNukeNotifications", "notifyDeclaredWarCivs", "Ljava/util/ArrayList;", "Lcom/unciv/logic/civilization/Civilization;", "Lkotlin/collections/ArrayList;", "attackingCiv", "hitCivsTerritory", "declareWarOnHitCivs", "Lkotlin/Pair;", "hitTiles", "Lkotlin/sequences/Sequence;", "doNukeExplosionForTile", "tile", "nukeStrength", "", "isGroundZero", "applyPillageAndFallout", "doNukeExplosionDamageToCity", "targetedCity", "Lcom/unciv/logic/city/City;", "damageModifierFromMissingResource", "", "getAggregateModifier", "uniqueType", "Lcom/unciv/models/ruleset/unique/UniqueType;", "core"})
public final class Nuke {
    @NotNull
    public static final Nuke INSTANCE = new Nuke();

    private Nuke() {
    }

    @Readonly
    public final boolean mayUseNuke(@NotNull MapUnitCombatant nuke, @NotNull Tile targetTile) {
        Intrinsics.checkNotNullParameter(nuke, "nuke");
        Intrinsics.checkNotNullParameter(targetTile, "targetTile");
        Civilization attackerCiv = nuke.getCivInfo();
        Tile launchTile = nuke.getTile();
        if (Intrinsics.areEqual(launchTile, targetTile)) {
            return false;
        }
        if (!targetTile.isExplored(attackerCiv)) {
            return false;
        }
        if (launchTile.aerialDistanceTo(targetTile) > nuke.getUnit().getRange()) {
            return false;
        }
        Ref.BooleanRef canNuke = new Ref.BooleanRef();
        canNuke.element = true;
        int blastRadius = nuke.getUnit().getNukeBlastRadius();
        Iterator<Tile> iterator2 = targetTile.getTilesInDistance(blastRadius).iterator();
        while (iterator2.hasNext()) {
            Tile tile = iterator2.next();
            Nuke.mayUseNuke$checkDefenderCiv(attackerCiv, canNuke, tile.getOwner());
            ICombatant iCombatant = Battle.INSTANCE.getMapCombatantOfTile(tile);
            Nuke.mayUseNuke$checkDefenderCiv(attackerCiv, canNuke, iCombatant != null ? iCombatant.getCivInfo() : null);
        }
        return canNuke.element;
    }

    public final void NUKE(@NotNull MapUnitCombatant attacker, @NotNull Tile targetTile) {
        String string;
        Pair<ArrayList<Civilization>, ArrayList<Civilization>> pair;
        Object object;
        Intrinsics.checkNotNullParameter(attacker, "attacker");
        Intrinsics.checkNotNullParameter(targetTile, "targetTile");
        Civilization attackingCiv = attacker.getCivInfo();
        Unique unique = (Unique)SequencesKt.firstOrNull(MapUnit.getMatchingUniques$default(attacker.getUnit(), UniqueType.NuclearWeapon, null, false, 6, null));
        if (unique == null || (object = unique.getParams()) == null || (pair = object.get(0)) == null) {
            return;
        }
        int nukeStrength = Integer.parseInt((String)((Object)pair));
        object = (Unique)SequencesKt.firstOrNull(MapUnit.getMatchingUniques$default(attacker.getUnit(), UniqueType.BlastRadius, null, false, 6, null));
        int blastRadius = object != null && (pair = ((Unique)object).getParams()) != null && (string = (String)pair.get(0)) != null ? Integer.parseInt(string) : 2;
        Sequence<Tile> hitTiles = targetTile.getTilesInDistance(blastRadius);
        pair = this.declareWarOnHitCivs(attackingCiv, hitTiles, attacker, targetTile);
        ArrayList<Civilization> hitCivsTerritory = pair.component1();
        ArrayList<Civilization> notifyDeclaredWarCivs = pair.component2();
        this.addNukeNotifications(targetTile, attacker, notifyDeclaredWarCivs, attackingCiv, hitCivsTerritory);
        if (attacker.isDefeated()) {
            return;
        }
        attacker.getUnit().getAttacksSinceTurnStart().add(targetTile.getPosition());
        Object object2 = hitTiles.iterator();
        while (object2.hasNext()) {
            Tile tile = object2.next();
            this.doNukeExplosionForTile(attacker, tile, nukeStrength, Intrinsics.areEqual(targetTile, tile));
        }
        if (MapUnit.hasUnique$default(attacker.getUnit(), UniqueType.SelfDestructs, null, false, 6, null)) {
            MapUnit.destroy$default(attacker.getUnit(), false, 1, null);
        }
        object2 = attackingCiv.getKnownCivs().iterator();
        while (object2.hasNext()) {
            Civilization civ = (Civilization)object2.next();
            DiplomacyManager diplomacyManager = civ.getDiplomacyManager(attackingCiv);
            Intrinsics.checkNotNull(diplomacyManager);
            diplomacyManager.setModifier(DiplomaticModifiers.UsedNuclearWeapons, -50.0f);
        }
        if (!attacker.isDefeated()) {
            object2 = attacker.getUnit();
            ((MapUnit)object2).setAttacksThisTurn(((MapUnit)object2).getAttacksThisTurn() + 1);
        }
    }

    private final void addNukeNotifications(Tile targetTile, MapUnitCombatant attacker, ArrayList<Civilization> notifyDeclaredWarCivs, Civilization attackingCiv, ArrayList<Civilization> hitCivsTerritory) {
        String[] stringArray;
        Object object = new NotificationAction[]{new LocationAction(targetTile.getPosition()), new CivilopediaAction("Units/" + attacker.getName())};
        Sequence<NotificationAction[]> nukeNotificationAction = SequencesKt.sequenceOf(object);
        if (attacker.isDefeated()) {
            Iterator<Civilization> iterator2 = notifyDeclaredWarCivs.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
            object = iterator2;
            while (object.hasNext()) {
                Object e = object.next();
                Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                Civilization defendingCiv = (Civilization)e;
                String[] stringArray2 = new String[]{defendingCiv.getCivName(), "OtherIcons/Pillage", attacker.getName()};
                attackingCiv.addNotification("After an attempted attack by our [" + attacker.getName() + "], [" + defendingCiv + "] has declared war on us!", nukeNotificationAction, Notification.NotificationCategory.Diplomacy, stringArray2);
            }
            return;
        }
        Iterator<Civilization> iterator3 = notifyDeclaredWarCivs.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator3, "iterator(...)");
        object = iterator3;
        while (object.hasNext()) {
            Object e = object.next();
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            Civilization defendingCiv = (Civilization)e;
            stringArray = new String[]{defendingCiv.getCivName(), "OtherIcons/Pillage", attacker.getName()};
            attackingCiv.addNotification("After being hit by our [" + attacker.getName() + "], [" + defendingCiv + "] has declared war on us!", nukeNotificationAction, Notification.NotificationCategory.Diplomacy, stringArray);
        }
        Iterator<Civilization> iterator4 = attackingCiv.getGameInfo().getCivilizations().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator4, "iterator(...)");
        object = iterator4;
        while (object.hasNext()) {
            Object e = object.next();
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            Civilization otherCiv = (Civilization)e;
            if (!otherCiv.isAlive() || Intrinsics.areEqual(otherCiv, attackingCiv)) continue;
            if (hitCivsTerritory.contains(otherCiv)) {
                stringArray = new String[]{attackingCiv.getCivName(), "OtherIcons/Pillage", attacker.getName()};
                otherCiv.addNotification("A(n) [" + attacker.getName() + "] from [" + attackingCiv.getCivName() + "] has exploded in our territory!", nukeNotificationAction, Notification.NotificationCategory.War, stringArray);
                continue;
            }
            if (otherCiv.knows(attackingCiv)) {
                stringArray = new String[]{attackingCiv.getCivName(), "OtherIcons/Pillage", attacker.getName()};
                otherCiv.addNotification("A(n) [" + attacker.getName() + "] has been detonated by [" + attackingCiv.getCivName() + "]!", nukeNotificationAction, Notification.NotificationCategory.War, stringArray);
                continue;
            }
            stringArray = new String[]{"OtherIcons/Pillage", attacker.getName()};
            otherCiv.addNotification("A(n) [" + attacker.getName() + "] has been detonated by [an unknown civilization]!", nukeNotificationAction, Notification.NotificationCategory.War, stringArray);
        }
    }

    private final Pair<ArrayList<Civilization>, ArrayList<Civilization>> declareWarOnHitCivs(Civilization attackingCiv, Sequence<Tile> hitTiles, MapUnitCombatant attacker, Tile targetTile) {
        ArrayList<Civilization> notifyDeclaredWarCivs = new ArrayList<Civilization>();
        ArrayList<Civilization> hitCivsTerritory = new ArrayList<Civilization>();
        Iterator<Civilization> iterator2 = SequencesKt.distinct(SequencesKt.mapNotNull(hitTiles, Nuke::declareWarOnHitCivs$lambda$0)).iterator();
        while (iterator2.hasNext()) {
            Civilization hitCiv = iterator2.next();
            hitCivsTerritory.add(hitCiv);
            Nuke.declareWarOnHitCivs$tryDeclareWar(attackingCiv, notifyDeclaredWarCivs, hitCiv);
        }
        iterator2 = SequencesKt.filter(SequencesKt.distinct(SequencesKt.map(SequencesKt.flatMap(hitTiles, Nuke::declareWarOnHitCivs$lambda$1), Nuke::declareWarOnHitCivs$lambda$2)), arg_0 -> Nuke.declareWarOnHitCivs$lambda$3(attackingCiv, arg_0)).iterator();
        while (iterator2.hasNext()) {
            Civilization civWhoseUnitWasAttacked = iterator2.next();
            Nuke.declareWarOnHitCivs$tryDeclareWar(attackingCiv, notifyDeclaredWarCivs, civWhoseUnitWasAttacked);
            if (!attacker.getUnit().getBaseUnit().isAirUnit() || attacker.isDefeated()) continue;
            AirInterception.INSTANCE.tryInterceptAirAttack$core(attacker, targetTile, civWhoseUnitWasAttacked, null);
        }
        return new Pair<ArrayList<Civilization>, ArrayList<Civilization>>(hitCivsTerritory, notifyDeclaredWarCivs);
    }

    private final void doNukeExplosionForTile(MapUnitCombatant attacker, Tile tile, int nukeStrength, boolean isGroundZero) {
        float damageModifierFromMissingResource = 1.0f;
        HashMap<String, Integer> civResources = attacker.getCivInfo().getCivResourcesByName();
        Iterator<String> iterator2 = attacker.getUnit().getResourceRequirementsPerTurn().keySet().iterator();
        while (iterator2.hasNext()) {
            String resource;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            Integer n = civResources.get(resource);
            Intrinsics.checkNotNull(n);
            if (((Number)n).intValue() >= 0 || attacker.getCivInfo().isBarbarian()) continue;
            damageModifierFromMissingResource *= 0.5f;
        }
        float buildingModifier = 1.0f;
        City city = tile.getCity();
        if (city != null && Intrinsics.areEqual(tile.getPosition().toHexCoord(), city.getLocation().toHexCoord())) {
            buildingModifier = this.getAggregateModifier(city, UniqueType.GarrisonDamageFromNukes);
            this.doNukeExplosionDamageToCity(city, nukeStrength, damageModifierFromMissingResource);
            Battle.postBattleNotifications$core$default(Battle.INSTANCE, attacker, new CityCombatant(city), city.getCenterTile(), null, null, 24, null);
            Battle.INSTANCE.destroyIfDefeated(city.getCiv(), attacker.getCivInfo(), city.getLocation().toHexCoord());
        }
        for (MapUnit unit : SequencesKt.toList(tile.getUnits())) {
            int damage = (int)((float)(isGroundZero || nukeStrength >= 2 ? 100 : (nukeStrength == 1 ? 30 + Random.Default.nextInt(40) + Random.Default.nextInt(40) : 20 + Random.Default.nextInt(30))) * buildingModifier * damageModifierFromMissingResource + Math.ulp(1.0f));
            MapUnitCombatant defender = new MapUnitCombatant(unit);
            if (unit.isCivilian()) {
                if (unit.getHealth() - damage <= 40) {
                    MapUnit.destroy$default(unit, false, 1, null);
                }
            } else {
                defender.takeDamage(damage);
            }
            Battle.postBattleNotifications$core$default(Battle.INSTANCE, attacker, defender, defender.getTile(), null, null, 24, null);
            Battle.destroyIfDefeated$default(Battle.INSTANCE, defender.getCivInfo(), attacker.getCivInfo(), null, 4, null);
        }
        if (tile.isCityCenter()) {
            return;
        }
        if (Tile.terrainHasUnique$default(tile, UniqueType.DestroyableByNukesChance, null, 2, null)) {
            for (Object object : tile.getTerrainFeatureObjects()) {
                Intrinsics.checkNotNullExpressionValue(object, "next(...)");
                Terrain terrainFeature = (Terrain)object;
                Iterator iterator3 = IHasUniques.getMatchingUniques$default(terrainFeature, UniqueType.DestroyableByNukesChance, null, 2, null).iterator();
                while (iterator3.hasNext()) {
                    Unique unique = (Unique)iterator3.next();
                    float chance = Float.parseFloat(unique.getParams().get(0)) / 100.0f;
                    if (!(chance > 0.0f && isGroundZero) && Random.Default.nextFloat() >= chance) continue;
                    tile.removeTerrainFeature(terrainFeature.getName());
                    this.applyPillageAndFallout(tile);
                }
            }
        } else if (isGroundZero || Random.Default.nextFloat() < 0.5f) {
            this.applyPillageAndFallout(tile);
        }
    }

    private final void applyPillageAndFallout(Tile tile) {
        if (tile.getUnpillagedImprovement() != null) {
            TileImprovement tileImprovement = tile.getTileImprovement();
            Intrinsics.checkNotNull(tileImprovement);
            if (!IHasUniques.hasUnique$default(tileImprovement, UniqueType.Irremovable, null, 2, null)) {
                TileImprovement tileImprovement2 = tile.getTileImprovement();
                Intrinsics.checkNotNull(tileImprovement2);
                if (IHasUniques.hasUnique$default(tileImprovement2, UniqueType.Unpillagable, null, 2, null)) {
                    tile.removeImprovement();
                } else {
                    tile.setPillaged();
                }
            }
        }
        if (tile.getUnpillagedRoad() != RoadStatus.None) {
            tile.setPillaged();
        }
        if (tile.isWater() || tile.isImpassible() || tile.getTerrainFeatures().contains("Fallout")) {
            return;
        }
        tile.addTerrainFeature("Fallout");
    }

    private final void doNukeExplosionDamageToCity(City targetedCity, int nukeStrength, float damageModifierFromMissingResource) {
        float f;
        if ((nukeStrength > 2 || nukeStrength > 1 && targetedCity.getPopulation().getPopulation() < 5) && targetedCity.canBeDestroyed(true)) {
            City.destroyCity$default(targetedCity, false, 1, null);
            return;
        }
        CityCombatant cityCombatant = new CityCombatant(targetedCity);
        cityCombatant.takeDamage((int)((float)cityCombatant.getHealth() * 0.5f * damageModifierFromMissingResource));
        float f2 = (float)targetedCity.getPopulation().getPopulation() * this.getAggregateModifier(targetedCity, UniqueType.PopulationLossFromNukes);
        switch (nukeStrength) {
            case 0: {
                f = 0.0f;
                break;
            }
            case 1: {
                f = (float)(30 + Random.Default.nextInt(20) + Random.Default.nextInt(20)) / 100.0f;
                break;
            }
            case 2: {
                f = (float)(60 + Random.Default.nextInt(10) + Random.Default.nextInt(10)) / 100.0f;
                break;
            }
            default: {
                f = 1.0f;
            }
        }
        int populationLoss = (int)(f2 * f);
        targetedCity.getPopulation().addPopulation(-populationLoss);
    }

    @Readonly
    private final float getAggregateModifier(City $this$getAggregateModifier, UniqueType uniqueType) {
        float modifier = 1.0f;
        Iterator iterator2 = City.getMatchingUniques$default($this$getAggregateModifier, uniqueType, null, false, 6, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            if (!City.matchesFilter$default($this$getAggregateModifier, unique.getParams().get(1), null, false, 6, null)) continue;
            modifier *= FormattingExtensionsKt.toPercent(unique.getParams().get(0));
        }
        return modifier;
    }

    private static final void mayUseNuke$checkDefenderCiv(Civilization attackerCiv, Ref.BooleanRef canNuke, Civilization defenderCiv) {
        if (defenderCiv == null) {
            return;
        }
        if (Intrinsics.areEqual(defenderCiv, attackerCiv) || defenderCiv.isDefeated()) {
            return;
        }
        if (defenderCiv.isBarbarian()) {
            return;
        }
        DiplomacyManager diplomacyManager = attackerCiv.getDiplomacyManager(defenderCiv);
        boolean bl = diplomacyManager != null ? diplomacyManager.canAttack() : false;
        if (bl) {
            return;
        }
        canNuke.element = false;
    }

    private static final void declareWarOnHitCivs$tryDeclareWar(Civilization $attackingCiv, ArrayList<Civilization> notifyDeclaredWarCivs, Civilization civSuffered) {
        if (!Intrinsics.areEqual(civSuffered, $attackingCiv) && civSuffered.knows($attackingCiv)) {
            DiplomacyManager diplomacyManager = civSuffered.getDiplomacyManager($attackingCiv);
            Intrinsics.checkNotNull(diplomacyManager);
            if (diplomacyManager.getDiplomaticStatus() != DiplomaticStatus.War) {
                DiplomacyManager diplomacyManager2 = $attackingCiv.getDiplomacyManager(civSuffered);
                Intrinsics.checkNotNull(diplomacyManager2);
                DiplomacyManager.declareWar$default(diplomacyManager2, null, 1, null);
                if (!notifyDeclaredWarCivs.contains(civSuffered)) {
                    notifyDeclaredWarCivs.add(civSuffered);
                }
            }
        }
    }

    private static final Civilization declareWarOnHitCivs$lambda$0(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getOwner();
    }

    private static final Sequence declareWarOnHitCivs$lambda$1(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getUnits();
    }

    private static final Civilization declareWarOnHitCivs$lambda$2(MapUnit it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getCiv();
    }

    private static final boolean declareWarOnHitCivs$lambda$3(Civilization $attackingCiv, Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return !Intrinsics.areEqual(it, $attackingCiv);
    }
}

