/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.files;

import com.badlogic.gdx.files.FileHandle;
import com.unciv.logic.GameInfo;
import com.unciv.logic.files.UncivFiles;
import com.unciv.models.metadata.GameSettings;
import com.unciv.utils.Concurrency;
import com.unciv.utils.Log;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0006\u0010\u0019\u001a\u00020\u0010J\u0006\u0010\u001a\u001a\u00020\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/unciv/logic/files/Autosaves;", "", "files", "Lcom/unciv/logic/files/UncivFiles;", "<init>", "(Lcom/unciv/logic/files/UncivFiles;)V", "getFiles", "()Lcom/unciv/logic/files/UncivFiles;", "autoSaveJob", "Lkotlinx/coroutines/Job;", "getAutoSaveJob", "()Lkotlinx/coroutines/Job;", "setAutoSaveJob", "(Lkotlinx/coroutines/Job;)V", "requestAutoSave", "gameInfo", "Lcom/unciv/logic/GameInfo;", "nextTurn", "", "requestAutoSaveUnCloned", "autoSave", "", "purgeOldAutosaves", "maxAutosavesStored", "", "loadLatestAutosave", "autosaveExists", "core"})
@SourceDebugExtension(value={"SMAP\nUncivFiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UncivFiles.kt\ncom/unciv/logic/files/Autosaves\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,561:1\n628#2:562\n1452#2,14:563\n*S KotlinDebug\n*F\n+ 1 UncivFiles.kt\ncom/unciv/logic/files/Autosaves\n*L\n528#1:562\n546#1:563,14\n*E\n"})
public final class Autosaves {
    @NotNull
    private final UncivFiles files;
    @Nullable
    private Job autoSaveJob;

    public Autosaves(@NotNull UncivFiles files) {
        Intrinsics.checkNotNullParameter(files, "files");
        this.files = files;
    }

    @NotNull
    public final UncivFiles getFiles() {
        return this.files;
    }

    @Nullable
    public final Job getAutoSaveJob() {
        return this.autoSaveJob;
    }

    public final void setAutoSaveJob(@Nullable Job job2) {
        this.autoSaveJob = job2;
    }

    @NotNull
    public final Job requestAutoSave(@NotNull GameInfo gameInfo, boolean nextTurn2) {
        Intrinsics.checkNotNullParameter(gameInfo, "gameInfo");
        return this.requestAutoSaveUnCloned(gameInfo.clone(), nextTurn2);
    }

    public static /* synthetic */ Job requestAutoSave$default(Autosaves autosaves, GameInfo gameInfo, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return autosaves.requestAutoSave(gameInfo, bl);
    }

    @NotNull
    public final Job requestAutoSaveUnCloned(@NotNull GameInfo gameInfo, boolean nextTurn2) {
        Job job2;
        Intrinsics.checkNotNullParameter(gameInfo, "gameInfo");
        this.autoSaveJob = job2 = Concurrency.run$default(Concurrency.INSTANCE, "autoSaveUnCloned", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, gameInfo, nextTurn2, null){
            int label;
            final /* synthetic */ Autosaves this$0;
            final /* synthetic */ GameInfo $gameInfo;
            final /* synthetic */ boolean $nextTurn;
            {
                this.this$0 = $receiver;
                this.$gameInfo = $gameInfo;
                this.$nextTurn = $nextTurn;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        this.this$0.autoSave(this.$gameInfo, this.$nextTurn);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
        return job2;
    }

    public static /* synthetic */ Job requestAutoSaveUnCloned$default(Autosaves autosaves, GameInfo gameInfo, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return autosaves.requestAutoSaveUnCloned(gameInfo, bl);
    }

    public final void autoSave(@NotNull GameInfo gameInfo, boolean nextTurn2) {
        Intrinsics.checkNotNullParameter(gameInfo, "gameInfo");
        GameSettings settings = this.files.getGeneralSettings();
        try {
            UncivFiles.saveGame$default(this.files, gameInfo, "Autosave", null, 4, null);
        }
        catch (OutOfMemoryError oom) {
            Log.INSTANCE.error("Ran out of memory during autosave", oom);
            return;
        }
        if (!nextTurn2) {
            return;
        }
        FileHandle newAutosaveFile = this.files.pathToFileHandle("SaveFiles").child("Autosave-" + gameInfo.getCurrentPlayer() + '-' + gameInfo.getTurns());
        this.files.getSave("Autosave").copyTo(newAutosaveFile);
        this.purgeOldAutosaves(settings.getMaxAutosavesStored());
    }

    public static /* synthetic */ void autoSave$default(Autosaves autosaves, GameInfo gameInfo, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        autosaves.autoSave(gameInfo, bl);
    }

    private final void purgeOldAutosaves(int maxAutosavesStored) {
        Sequence<FileHandle> $this$sortedByDescending$iv = SequencesKt.filter(UncivFiles.getSaves$default(this.files, false, 1, null), Autosaves::purgeOldAutosaves$lambda$0);
        boolean $i$f$sortedByDescending = false;
        List<FileHandle> oldAutoSaves = CollectionsKt.reversed(SequencesKt.asIterable(SequencesKt.drop(SequencesKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                FileHandle it = (FileHandle)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.lastModified());
                it = (FileHandle)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.lastModified());
            }
        }), maxAutosavesStored + 1)));
        for (FileHandle file : oldAutoSaves) {
            this.files.deleteSave(file);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final GameInfo loadLatestAutosave() {
        GameInfo gameInfo;
        try {
            gameInfo = this.files.loadGameByName("Autosave");
        }
        catch (Exception exception2) {
            Object t;
            void $this$maxBy$iv;
            Sequence<FileHandle> autosaves;
            Sequence<FileHandle> sequence = autosaves = SequencesKt.filter(UncivFiles.getSaves$default(this.files, false, 1, null), Autosaves::loadLatestAutosave$lambda$0);
            UncivFiles uncivFiles = this.files;
            boolean $i$f$maxByOrThrow = false;
            Iterator iterator$iv = $this$maxBy$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new NoSuchElementException();
            }
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                t = maxElem$iv;
            } else {
                FileHandle it = (FileHandle)maxElem$iv;
                boolean bl = false;
                long maxValue$iv = it.lastModified();
                do {
                    Object e$iv = iterator$iv.next();
                    FileHandle it2 = (FileHandle)e$iv;
                    $i$a$-maxByOrThrow-Autosaves$loadLatestAutosave$2 = false;
                    long v$iv = it2.lastModified();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                t = maxElem$iv;
            }
            gameInfo = uncivFiles.loadGameFromFile((FileHandle)t);
        }
        return gameInfo;
    }

    public final boolean autosaveExists() {
        return this.files.getSave("Autosave").exists();
    }

    private static final boolean purgeOldAutosaves$lambda$0(FileHandle it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String string = it.name();
        Intrinsics.checkNotNullExpressionValue(string, "name(...)");
        return StringsKt.startsWith$default(string, "Autosave", false, 2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean loadLatestAutosave$lambda$0(FileHandle it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (Intrinsics.areEqual(it.name(), "Autosave")) return false;
        String string = it.name();
        Intrinsics.checkNotNullExpressionValue(string, "name(...)");
        if (!StringsKt.startsWith$default(string, "Autosave", false, 2, null)) return false;
        return true;
    }
}

