/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map;

import com.badlogic.gdx.utils.IntIntMap;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.logic.civilization.diplomacy.RelationshipLevel;
import com.unciv.logic.map.FixedPointMovement;
import com.unciv.logic.map.HexCoord;
import com.unciv.logic.map.PathingMap;
import com.unciv.logic.map.PathingMapCache;
import com.unciv.logic.map.PrioritizedNode;
import com.unciv.logic.map.RouteNode;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.tile.Tile;
import com.unciv.utils.Log;
import com.unciv.utils.LongPriorityQueue;
import java.util.BitSet;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import yairm210.purity.annotations.InternalState;
import yairm210.purity.annotations.Readonly;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@InternalState
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0016\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000 =2\u00020\u0001:\u0001=Bm\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00110\u0010\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0003\u00a2\u0006\u0004\b-\u0010.J\u001f\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020,2\u0006\u00102\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b3\u00104J\u001f\u00105\u001a\u00020,2\u0006\u00101\u001a\u00020,2\u0006\u00102\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b6\u00107J\r\u00108\u001a\u000209H\u0000\u00a2\u0006\u0002\b:J\n\u0010;\u001a\u00020\u0004H\u0096\u0080\u0004J\b\u0010<\u001a\u00020\u0004H\u0007R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u001dX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\u00020\"X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020&X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u0006>"}, d2={"Lcom/unciv/logic/map/AStarPathfinder;", "", "debugId", "debugMapType", "", "destination", "Lcom/unciv/logic/map/tile/Tile;", "moveThroughPredicate", "Lcom/unciv/logic/map/PathingMap$Companion$MoveThroughPredicate;", "endTurnDamage", "Lcom/unciv/logic/map/PathingMap$Companion$EndTurnDamageLookup;", "cost", "Lcom/unciv/logic/map/PathingMap$Companion$TileMovementCost;", "tileRoadCost", "Lcom/unciv/logic/map/PathingMap$Companion$TileRoadCost;", "relationshipLevel", "Lkotlin/Function1;", "Lcom/unciv/logic/civilization/diplomacy/RelationshipLevel;", "cache", "Lcom/unciv/logic/map/PathingMapCache;", "timeLimitTurns", "", "tileMap", "Lcom/unciv/logic/map/TileMap;", "<init>", "(Ljava/lang/Object;Ljava/lang/String;Lcom/unciv/logic/map/tile/Tile;Lcom/unciv/logic/map/PathingMap$Companion$MoveThroughPredicate;Lcom/unciv/logic/map/PathingMap$Companion$EndTurnDamageLookup;Lcom/unciv/logic/map/PathingMap$Companion$TileMovementCost;Lcom/unciv/logic/map/PathingMap$Companion$TileRoadCost;Lkotlin/jvm/functions/Function1;Lcom/unciv/logic/map/PathingMapCache;ILcom/unciv/logic/map/TileMap;)V", "getCache$core", "()Lcom/unciv/logic/map/PathingMapCache;", "routeNodes", "", "getRouteNodes$core", "()[J", "initialBufferSize", "tilesInTodo", "Lcom/badlogic/gdx/utils/IntIntMap;", "getTilesInTodo$core", "()Lcom/badlogic/gdx/utils/IntIntMap;", "todo", "Lcom/unciv/utils/LongPriorityQueue;", "getTodo$core", "()Lcom/unciv/utils/LongPriorityQueue;", "calculateUnderestimatedMovement", "Lcom/unciv/logic/map/FixedPointMovement;", "node", "Lcom/unciv/logic/map/RouteNode;", "calculateUnderestimatedMovement-3nCi6jg", "(J)I", "neighborNeedsCalcuating", "", "currentNode", "neighborTile", "neighborNeedsCalcuating-7uXK2zo", "(JLcom/unciv/logic/map/tile/Tile;)Z", "calculateNeighborNode", "calculateNeighborNode-w5WTAnE", "(JLcom/unciv/logic/map/tile/Tile;)J", "stepUntilDestination", "", "stepUntilDestination$core", "toString", "toDebugString", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nPathingMapAStarPathfinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathingMapAStarPathfinder.kt\ncom/unciv/logic/map/AStarPathfinder\n+ 2 CollectionExtensions.kt\ncom/unciv/utils/CollectionExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,240:1\n137#2,6:241\n1#3:247\n*S KotlinDebug\n*F\n+ 1 PathingMapAStarPathfinder.kt\ncom/unciv/logic/map/AStarPathfinder\n*L\n97#1:241,6\n*E\n"})
public final class AStarPathfinder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Object debugId;
    @NotNull
    private final String debugMapType;
    @Nullable
    private final Tile destination;
    @NotNull
    private final PathingMap.Companion.MoveThroughPredicate moveThroughPredicate;
    @NotNull
    private final PathingMap.Companion.EndTurnDamageLookup endTurnDamage;
    @NotNull
    private final PathingMap.Companion.TileMovementCost cost;
    @NotNull
    private final PathingMap.Companion.TileRoadCost tileRoadCost;
    @NotNull
    private final Function1<Tile, RelationshipLevel> relationshipLevel;
    @NotNull
    private final PathingMapCache cache;
    private final int timeLimitTurns;
    @NotNull
    private final TileMap tileMap;
    @NotNull
    private final long[] routeNodes;
    private final int initialBufferSize;
    @NotNull
    private final IntIntMap tilesInTodo;
    @NotNull
    private final LongPriorityQueue todo;
    public static final float FASTEST_ROAD_COST = 0.1f;

    public AStarPathfinder(@NotNull Object debugId, @NotNull String debugMapType, @Nullable Tile destination, @NotNull PathingMap.Companion.MoveThroughPredicate moveThroughPredicate, @NotNull PathingMap.Companion.EndTurnDamageLookup endTurnDamage, @NotNull PathingMap.Companion.TileMovementCost cost, @NotNull PathingMap.Companion.TileRoadCost tileRoadCost, @NotNull Function1<? super Tile, ? extends RelationshipLevel> relationshipLevel, @NotNull PathingMapCache cache2, int timeLimitTurns, @NotNull TileMap tileMap) {
        Intrinsics.checkNotNullParameter(debugId, "debugId");
        Intrinsics.checkNotNullParameter(debugMapType, "debugMapType");
        Intrinsics.checkNotNullParameter(moveThroughPredicate, "moveThroughPredicate");
        Intrinsics.checkNotNullParameter(endTurnDamage, "endTurnDamage");
        Intrinsics.checkNotNullParameter(cost, "cost");
        Intrinsics.checkNotNullParameter(tileRoadCost, "tileRoadCost");
        Intrinsics.checkNotNullParameter(relationshipLevel, "relationshipLevel");
        Intrinsics.checkNotNullParameter(cache2, "cache");
        Intrinsics.checkNotNullParameter(tileMap, "tileMap");
        this.debugId = debugId;
        this.debugMapType = debugMapType;
        this.destination = destination;
        this.moveThroughPredicate = moveThroughPredicate;
        this.endTurnDamage = endTurnDamage;
        this.cost = cost;
        this.tileRoadCost = tileRoadCost;
        this.relationshipLevel = relationshipLevel;
        this.cache = cache2;
        this.timeLimitTurns = timeLimitTurns;
        this.tileMap = tileMap;
        this.routeNodes = this.cache.getRouteNodes$core();
        this.initialBufferSize = this.tileMap.getTileMatrix().size() + this.tileMap.getTileMatrix().get(0).size();
        this.tilesInTodo = new IntIntMap(this.initialBufferSize);
        this.todo = new LongPriorityQueue(this.initialBufferSize, null, 2, null);
        if (!(this.timeLimitTurns < 63)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        BitSet $this$forEachSetBit$iv = this.cache.getNodesNeedingNeighbors$core();
        boolean $i$f$forEachSetBit = false;
        int bit$iv = $this$forEachSetBit$iv.nextSetBit(0);
        while (bit$iv >= 0) {
            int it = bit$iv;
            boolean bl = false;
            long node = RouteNode.constructor-impl(this.routeNodes[it]);
            if (RouteNode.getInitialized-impl(node) && RouteNode.getTurns-impl(node) <= this.timeLimitTurns) {
                this.todo.add(PrioritizedNode.constructor-impl(node, this.calculateUnderestimatedMovement-3nCi6jg(node)));
                this.tilesInTodo.put(it, RouteNode.getDamagingTiles-impl(node));
            }
            bit$iv = $this$forEachSetBit$iv.nextSetBit(bit$iv + 1);
        }
    }

    @NotNull
    public final PathingMapCache getCache$core() {
        return this.cache;
    }

    @NotNull
    public final long[] getRouteNodes$core() {
        return this.routeNodes;
    }

    @NotNull
    public final IntIntMap getTilesInTodo$core() {
        return this.tilesInTodo;
    }

    @NotNull
    public final LongPriorityQueue getTodo$core() {
        return this.todo;
    }

    @Readonly
    private final int calculateUnderestimatedMovement-3nCi6jg(long node) {
        int n;
        Tile tile = RouteNode.tile-impl(node, this.tileMap);
        int movementSoFar = FixedPointMovement.plus-qwRIMkA(FixedPointMovement.Companion.fpmFromMovement-o4tN_Zo(RouteNode.getTurns-impl(node) * this.cache.getKey$core().getFullMove()), RouteNode.getMoveUsedThisTurn-uTAV3tY(node));
        Tile tile2 = this.destination;
        if (tile2 != null) {
            Tile it = tile2;
            boolean bl = false;
            n = tile.aerialDistanceTo(it);
        } else {
            n = 1;
        }
        int minRemainingTiles = n;
        int minRemainingCost = FixedPointMovement.plus-o4tN_Zo(this.tileRoadCost.invoke-o4tN_Zo(tile), (float)(minRemainingTiles - 1) * 0.1f);
        int underestimatedTotal = FixedPointMovement.plus-qwRIMkA(movementSoFar, minRemainingCost);
        return underestimatedTotal;
    }

    private final boolean neighborNeedsCalcuating-7uXK2zo(long currentNode, Tile neighborTile) {
        Tile currentTile = RouteNode.tile-impl(currentNode, this.tileMap);
        HexCoord startingPoint = this.cache.getKey$core().getStartingPoint();
        long alreadyCalculatedNode = RouteNode.constructor-impl(this.routeNodes[neighborTile.getZeroBasedIndex()]);
        if (this.cache.getAddedNeighborNodes$core().get(neighborTile.getZeroBasedIndex()) && RouteNode.getDamagingTiles-impl(alreadyCalculatedNode) <= RouteNode.getDamagingTiles-impl(currentNode)) {
            if (Intrinsics.areEqual(PathingMap.Companion.getVERBOSE_PATHFINDING_LOGS(), startingPoint) || Intrinsics.areEqual(PathingMap.Companion.getVERBOSE_PATHFINDING_LOGS(), PathingMap.Companion.getALWAYS_LOG$core())) {
                Log.INSTANCE.debug("#calculateAndQueue " + currentTile.getPosition() + " ignoring " + RouteNode.tile-impl(alreadyCalculatedNode, this.tileMap).getPosition() + " because we already calculated it, for " + this.debugMapType + ' ' + this.debugId, new Object[0]);
            }
            return false;
        }
        int todoWithDamage = this.tilesInTodo.get(neighborTile.getZeroBasedIndex(), Integer.MAX_VALUE);
        if (todoWithDamage <= RouteNode.getDamagingTiles-impl(currentNode)) {
            if (Intrinsics.areEqual(PathingMap.Companion.getVERBOSE_PATHFINDING_LOGS(), startingPoint) || Intrinsics.areEqual(PathingMap.Companion.getVERBOSE_PATHFINDING_LOGS(), PathingMap.Companion.getALWAYS_LOG$core())) {
                Log.INSTANCE.debug("#calculateAndQueue " + currentTile.getPosition() + " ignoring " + neighborTile.getPosition() + " because it's already queued, for " + this.debugMapType + ' ' + this.debugId, new Object[0]);
            }
            return false;
        }
        if (RouteNode.getInitialized-impl(alreadyCalculatedNode) && RouteNode.getDamagingTiles-impl(alreadyCalculatedNode) <= RouteNode.getDamagingTiles-impl(currentNode)) {
            if (RouteNode.getTurns-impl(alreadyCalculatedNode) < this.timeLimitTurns) {
                this.todo.add(PrioritizedNode.constructor-impl(alreadyCalculatedNode, this.calculateUnderestimatedMovement-3nCi6jg(alreadyCalculatedNode)));
            }
            this.tilesInTodo.put(neighborTile.getZeroBasedIndex(), RouteNode.getDamagingTiles-impl(alreadyCalculatedNode));
            this.cache.getNodesNeedingNeighbors$core().set(neighborTile.getZeroBasedIndex());
            if (Intrinsics.areEqual(PathingMap.Companion.getVERBOSE_PATHFINDING_LOGS(), startingPoint) || Intrinsics.areEqual(PathingMap.Companion.getVERBOSE_PATHFINDING_LOGS(), PathingMap.Companion.getALWAYS_LOG$core())) {
                Log.INSTANCE.debug("#calculateAndQueue " + currentTile.getPosition() + " queueing " + RouteNode.tile-impl(alreadyCalculatedNode, this.tileMap).getPosition() + " because another thread calculated, for " + this.debugMapType + ' ' + this.debugId, new Object[0]);
            }
            return false;
        }
        if (!this.moveThroughPredicate.invoke(neighborTile)) {
            long noPathingNode;
            this.routeNodes[neighborTile.getZeroBasedIndex()] = noPathingNode = RouteNode.Companion.noPathingNode-ZqF76PM(neighborTile);
            this.cache.getAddedNeighborNodes$core().set(neighborTile.getZeroBasedIndex());
            if (Intrinsics.areEqual(PathingMap.Companion.getVERBOSE_PATHFINDING_LOGS(), startingPoint) || Intrinsics.areEqual(PathingMap.Companion.getVERBOSE_PATHFINDING_LOGS(), PathingMap.Companion.getALWAYS_LOG$core())) {
                Log.INSTANCE.debug("#calculateAndQueue " + currentTile.getPosition() + " set " + neighborTile.getPosition() + " as noPathingNode because cannot move there, for " + this.debugMapType + ' ' + this.debugId, new Object[0]);
            }
            return false;
        }
        return true;
    }

    private final long calculateNeighborNode-w5WTAnE(long currentNode, Tile neighborTile) {
        Tile currentTile = RouteNode.tile-impl(currentNode, this.tileMap);
        HexCoord startingPoint = this.cache.getKey$core().getStartingPoint();
        int damagingTiles = RouteNode.getDamagingTiles-impl(currentNode);
        int cost = FixedPointMovement.coerceAtMost-qwRIMkA(this.cost.invoke-_zTpDcI(currentTile, neighborTile), RouteNode.Companion.getMAX_MOVE_THIS_TURN-uTAV3tY());
        int newUsedMovement = FixedPointMovement.coerceAtMost-qwRIMkA(FixedPointMovement.plus-qwRIMkA(RouteNode.getMoveUsedThisTurn-uTAV3tY(currentNode), cost), RouteNode.Companion.getMAX_MOVE_THIS_TURN-uTAV3tY());
        int fullMovement = this.cache.getKey$core().getFullMove();
        int endTurnThereDamage = RangesKt.coerceAtMost(this.endTurnDamage.invoke(neighborTile), 1);
        int newMountainMovement = FixedPointMovement.coerceAtMost-qwRIMkA(RouteNode.getEndTurnWithoutMoreDamage-impl(currentNode) && endTurnThereDamage > 0 ? cost : (!RouteNode.getEndTurnWithoutMoreDamage-impl(currentNode) && endTurnThereDamage > 0 ? FixedPointMovement.plus-qwRIMkA(RouteNode.getPbmMoveThisTurn-uTAV3tY(currentNode), cost) : FixedPointMovement.Companion.getFPM_ZERO-uTAV3tY()), RouteNode.Companion.getMAX_MOVE_THIS_TURN-uTAV3tY());
        boolean canEndTurnOrProbablyMoveAway = endTurnThereDamage == 0 || FixedPointMovement.compareTo-impl(newUsedMovement, fullMovement) < 0;
        RelationshipLevel relationship = this.relationshipLevel.invoke(neighborTile);
        long newNode = 0L;
        if (FixedPointMovement.compareTo-impl(RouteNode.getMoveUsedThisTurn-uTAV3tY(currentNode), fullMovement) < 0 && canEndTurnOrProbablyMoveAway) {
            if (Intrinsics.areEqual(PathingMap.Companion.getVERBOSE_PATHFINDING_LOGS(), startingPoint) || Intrinsics.areEqual(PathingMap.Companion.getVERBOSE_PATHFINDING_LOGS(), PathingMap.Companion.getALWAYS_LOG$core())) {
                Log.INSTANCE.debug("#calculateAndQueue " + currentTile.getPosition() + " queing " + neighborTile.getPosition() + " for same turn, for " + this.debugMapType + ' ' + this.debugId, new Object[0]);
            }
            return RouteNode.constructor-impl(neighborTile, relationship, newMountainMovement, newUsedMovement, RouteNode.getTurns-impl(currentNode), currentTile, damagingTiles);
        }
        if (RouteNode.getEndTurnWithoutMoreDamage-impl(currentNode) && canEndTurnOrProbablyMoveAway) {
            if (Intrinsics.areEqual(PathingMap.Companion.getVERBOSE_PATHFINDING_LOGS(), startingPoint) || Intrinsics.areEqual(PathingMap.Companion.getVERBOSE_PATHFINDING_LOGS(), PathingMap.Companion.getALWAYS_LOG$core())) {
                Log.INSTANCE.debug("#calculateAndQueue " + currentTile.getPosition() + " queing " + neighborTile.getPosition() + " for next turn, for " + this.debugMapType + ' ' + this.debugId, new Object[0]);
            }
            return RouteNode.constructor-impl(neighborTile, relationship, newMountainMovement, cost, RouteNode.getTurns-impl(currentNode) + 1, currentTile, damagingTiles);
        }
        if (FixedPointMovement.compareTo-impl(RouteNode.getPbmMoveThisTurn-uTAV3tY(currentNode), fullMovement) < 0) {
            if (Intrinsics.areEqual(PathingMap.Companion.getVERBOSE_PATHFINDING_LOGS(), startingPoint) || Intrinsics.areEqual(PathingMap.Companion.getVERBOSE_PATHFINDING_LOGS(), PathingMap.Companion.getALWAYS_LOG$core())) {
                Log.INSTANCE.debug("#calculateAndQueue " + currentTile.getPosition() + " queing " + neighborTile.getPosition() + " with retroactive pause before mountains, for " + this.debugMapType + ' ' + this.debugId, new Object[0]);
            }
            return RouteNode.constructor-impl(neighborTile, relationship, newMountainMovement, newMountainMovement, RouteNode.getTurns-impl(currentNode) + 1, currentTile, damagingTiles);
        }
        int newDamageTiles = RangesKt.coerceAtMost(damagingTiles + endTurnThereDamage, 3);
        if (Intrinsics.areEqual(PathingMap.Companion.getVERBOSE_PATHFINDING_LOGS(), startingPoint) || Intrinsics.areEqual(PathingMap.Companion.getVERBOSE_PATHFINDING_LOGS(), PathingMap.Companion.getALWAYS_LOG$core())) {
            Log.INSTANCE.debug("#calculateAndQueue " + currentTile.getPosition() + " queing " + neighborTile.getPosition() + " with taking damage, for " + this.debugMapType + ' ' + this.debugId, new Object[0]);
        }
        return RouteNode.constructor-impl(neighborTile, relationship, cost, cost, RouteNode.getTurns-impl(currentNode) + 1, currentTile, newDamageTiles);
    }

    public final void stepUntilDestination$core() {
        while (this.todo.isNotEmpty()) {
            long currentPrioritizedNode = PrioritizedNode.constructor-impl(this.todo.poll());
            long currentNode = RouteNode.constructor-impl(this.routeNodes[PrioritizedNode.getTileIdx-impl(currentPrioritizedNode)]);
            Tile currentTile = RouteNode.tile-impl(currentNode, this.tileMap);
            Iterator<Tile> iterator2 = currentTile.getNeighbors().iterator();
            while (iterator2.hasNext()) {
                long newNode;
                Tile neighborTile = iterator2.next();
                if (!this.neighborNeedsCalcuating-7uXK2zo(currentNode, neighborTile)) continue;
                this.routeNodes[neighborTile.getZeroBasedIndex()] = newNode = this.calculateNeighborNode-w5WTAnE(currentNode, neighborTile);
                if (RouteNode.getTurns-impl(newNode) < this.timeLimitTurns) {
                    this.todo.add(PrioritizedNode.constructor-impl(newNode, this.calculateUnderestimatedMovement-3nCi6jg(newNode)));
                }
                this.tilesInTodo.put(neighborTile.getZeroBasedIndex(), RouteNode.getDamagingTiles-impl(newNode));
                this.cache.getNodesNeedingNeighbors$core().set(neighborTile.getZeroBasedIndex());
            }
            this.tilesInTodo.remove(currentTile.getZeroBasedIndex(), 0);
            this.cache.getNodesNeedingNeighbors$core().clear(currentTile.getZeroBasedIndex());
            this.cache.getAddedNeighborNodes$core().set(currentTile.getZeroBasedIndex());
            if (this.destination == null || !RouteNode.getInitialized-impl(RouteNode.constructor-impl(this.routeNodes[this.destination.getZeroBasedIndex()]))) continue;
            return;
        }
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "[debugMapType=" + this.debugMapType + " debugId=" + this.debugId + ']';
    }

    @VisibleForTesting
    @NotNull
    public final String toDebugString() {
        GameInfo gameInfo = UncivGame.Companion.getCurrent().getGameInfo();
        Intrinsics.checkNotNull(gameInfo);
        return this.cache.toDebugString(gameInfo.getTileMap(), this.destination);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/unciv/logic/map/AStarPathfinder$Companion;", "", "<init>", "()V", "FASTEST_ROAD_COST", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

