/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map.tile;

import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.managers.TechManager;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.RoadStatus;
import com.unciv.logic.map.tile.Tile;
import com.unciv.logic.map.tile.TileImprovementFunctions;
import com.unciv.models.ruleset.tile.ResourceType;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import com.unciv.ui.screens.civilopediascreen.FormattedLine;
import com.unciv.utils.DebugUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a8\u0006\f"}, d2={"Lcom/unciv/logic/map/tile/TileDescription;", "", "<init>", "()V", "toMarkup", "Ljava/util/ArrayList;", "Lcom/unciv/ui/screens/civilopediascreen/FormattedLine;", "Lkotlin/collections/ArrayList;", "tile", "Lcom/unciv/logic/map/tile/Tile;", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "core"})
@SourceDebugExtension(value={"SMAP\nTileDescription.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileDescription.kt\ncom/unciv/logic/map/tile/TileDescription\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n296#2,2:92\n*S KotlinDebug\n*F\n+ 1 TileDescription.kt\ncom/unciv/logic/map/tile/TileDescription\n*L\n39#1:92,2\n*E\n"})
public final class TileDescription {
    @NotNull
    public static final TileDescription INSTANCE = new TileDescription();

    private TileDescription() {
    }

    @NotNull
    public final ArrayList<FormattedLine> toMarkup(@NotNull Tile tile, @Nullable Civilization viewingCiv) {
        float defenceBonus;
        ArrayList<FormattedLine> lineList;
        block29: {
            String string;
            block30: {
                String shownImprovement;
                TileResource resource;
                boolean isViewableToPlayer;
                block27: {
                    block28: {
                        Intrinsics.checkNotNullParameter(tile, "tile");
                        lineList = new ArrayList<FormattedLine>();
                        boolean bl = isViewableToPlayer = viewingCiv == null || DebugUtils.INSTANCE.getVISIBLE_MAP() || viewingCiv.getViewableTiles().contains(tile);
                        if (tile.isCityCenter()) {
                            City city = tile.getCity();
                            Intrinsics.checkNotNull(city);
                            City city2 = city;
                            String cityString = TranslationsKt.tr$default(city2.getName(), false, false, 3, null);
                            if (isViewableToPlayer) {
                                cityString = cityString + " (" + city2.getHealth() + ')';
                            }
                            ((Collection)lineList).add(new FormattedLine(cityString, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
                            if (DebugUtils.INSTANCE.getVISIBLE_MAP() || Intrinsics.areEqual(city2.getCiv(), viewingCiv)) {
                                ((Collection)lineList).add(city2.getCityConstructions().getProductionMarkup(tile.getRuleset()));
                            }
                        }
                        ((Collection)lineList).add(new FormattedLine(tile.getBaseTerrain(), "Terrain/" + tile.getBaseTerrain(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
                        for (String terrainFeature : tile.getTerrainFeatures()) {
                            ((Collection)lineList).add(new FormattedLine(terrainFeature, "Terrain/" + terrainFeature, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
                        }
                        resource = tile.getTileResource();
                        if (resource == null) break block27;
                        if (viewingCiv == null) break block28;
                        if (!viewingCiv.canSeeResource(resource)) break block27;
                    }
                    ((Collection)lineList).add(resource.getResourceType() == ResourceType.Strategic ? new FormattedLine('{' + tile.getResource() + "} (" + tile.getResourceAmount() + ')', "Resource/" + tile.getResource(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null) : new FormattedLine(resource.getName(), "Resource/" + resource.getName(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
                }
                if (viewingCiv != null && viewingCiv.canSeeResource(resource)) {
                    TileImprovement tileImprovement;
                    Object v4;
                    block26: {
                        Iterable $this$firstOrNull$iv = resource.getImprovements();
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            String it = (String)element$iv;
                            boolean bl = false;
                            TileImprovementFunctions tileImprovementFunctions = tile.getImprovementFunctions();
                            TileImprovement tileImprovement2 = tile.getRuleset().getTileImprovements().get(it);
                            Intrinsics.checkNotNull(tileImprovement2);
                            if (!tileImprovementFunctions.canBuildImprovement(tileImprovement2, viewingCiv.getState())) continue;
                            v4 = element$iv;
                            break block26;
                        }
                        v4 = null;
                    }
                    String resourceImprovement = v4;
                    TileImprovement tileImprovement3 = tileImprovement = (TileImprovement)((Map)tile.getRuleset().getTileImprovements()).get(resourceImprovement);
                    if ((tileImprovement3 != null ? tileImprovement3.getTechRequired() : null) != null) {
                        TechManager techManager = viewingCiv.getTech();
                        String string2 = tileImprovement.getTechRequired();
                        Intrinsics.checkNotNull(string2);
                        if (!techManager.isResearched(string2)) {
                            ((Collection)lineList).add(new FormattedLine("Requires [" + tileImprovement.getTechRequired() + ']', "Technology/" + tileImprovement.getTechRequired(), null, null, 0.0f, 0, 0, 0, 0.0f, "#FAA", false, false, false, false, 15868, null));
                        }
                    }
                }
                if (tile.getNaturalWonder() != null) {
                    Collection collection = lineList;
                    String string3 = tile.getNaturalWonder();
                    Intrinsics.checkNotNull(string3);
                    collection.add(new FormattedLine(string3, "Terrain/" + tile.getNaturalWonder(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
                }
                if (tile.getRoadStatus() != RoadStatus.None && !tile.isCityCenter()) {
                    String pillageText = tile.getRoadIsPillaged() ? " (Pillaged!)" : "";
                    ((Collection)lineList).add(new FormattedLine('[' + tile.getRoadStatus().name() + ']' + pillageText, "Improvement/" + tile.getRoadStatus().name(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
                }
                if ((shownImprovement = tile.getShownImprovement(viewingCiv)) != null) {
                    String pillageText = tile.getImprovementIsPillaged() ? " (Pillaged!)" : "";
                    ((Collection)lineList).add(new FormattedLine('[' + shownImprovement + ']' + pillageText, "Improvement/" + shownImprovement, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
                }
                if (tile.getImprovementInProgress() != null && isViewableToPlayer) {
                    String line = '{' + tile.getImprovementInProgress() + '}' + (tile.getTurnsToImprovement() > 0 ? " - " + tile.getTurnsToImprovement() + '\u23f3' : " ({Under construction})");
                    ((Collection)lineList).add(new FormattedLine(line, "Improvement/" + tile.getImprovementInProgress(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
                }
                if (tile.getCivilianUnit() != null && isViewableToPlayer) {
                    Collection collection = lineList;
                    StringBuilder stringBuilder = new StringBuilder();
                    MapUnit mapUnit = tile.getCivilianUnit();
                    Intrinsics.checkNotNull(mapUnit);
                    StringBuilder stringBuilder2 = stringBuilder.append(TranslationsKt.tr$default(mapUnit.getName(), false, false, 3, null)).append(" - ");
                    MapUnit mapUnit2 = tile.getCivilianUnit();
                    Intrinsics.checkNotNull(mapUnit2);
                    String string4 = stringBuilder2.append(TranslationsKt.tr$default(mapUnit2.getCiv().getCivName(), false, false, 3, null)).toString();
                    StringBuilder stringBuilder3 = new StringBuilder().append("Unit/");
                    MapUnit mapUnit3 = tile.getCivilianUnit();
                    Intrinsics.checkNotNull(mapUnit3);
                    collection.add(new FormattedLine(string4, stringBuilder3.append(mapUnit3.getName()).toString(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
                }
                if (tile.getMilitaryUnit() == null || !isViewableToPlayer) break block29;
                if (viewingCiv == null) break block30;
                MapUnit mapUnit = tile.getMilitaryUnit();
                Intrinsics.checkNotNull(mapUnit);
                if (mapUnit.isInvisible(viewingCiv)) break block29;
            }
            StringBuilder stringBuilder = new StringBuilder();
            MapUnit mapUnit = tile.getMilitaryUnit();
            Intrinsics.checkNotNull(mapUnit);
            StringBuilder stringBuilder4 = stringBuilder.append(TranslationsKt.tr$default(mapUnit.getName(), false, false, 3, null));
            MapUnit mapUnit4 = tile.getMilitaryUnit();
            Intrinsics.checkNotNull(mapUnit4);
            if (mapUnit4.getHealth() < 100) {
                StringBuilder stringBuilder5 = new StringBuilder().append('(');
                MapUnit mapUnit5 = tile.getMilitaryUnit();
                Intrinsics.checkNotNull(mapUnit5);
                string = stringBuilder5.append(mapUnit5.getHealth()).append(')').toString();
            } else {
                string = "";
            }
            StringBuilder stringBuilder6 = stringBuilder4.append(string).append(" - ");
            MapUnit mapUnit6 = tile.getMilitaryUnit();
            Intrinsics.checkNotNull(mapUnit6);
            String milUnitString = stringBuilder6.append(TranslationsKt.tr$default(mapUnit6.getCiv().getCivName(), false, false, 3, null)).toString();
            Collection collection = lineList;
            StringBuilder stringBuilder7 = new StringBuilder().append("Unit/");
            MapUnit mapUnit7 = tile.getMilitaryUnit();
            Intrinsics.checkNotNull(mapUnit7);
            collection.add(new FormattedLine(milUnitString, stringBuilder7.append(mapUnit7.getName()).toString(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
        }
        if (!((defenceBonus = Tile.getDefensiveBonus$default(tile, false, null, 3, null)) == 0.0f)) {
            String defencePercentString = FormattingExtensionsKt.toStringSigned((int)(defenceBonus * (float)100)) + '%';
            ((Collection)lineList).add(new FormattedLine('[' + defencePercentString + "] to unit defence", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
        }
        if (tile.isImpassible()) {
            ((Collection)lineList).add(new FormattedLine("Impassable", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
        }
        if (tile.isLand() && Tile.isAdjacentTo$default(tile, "Fresh water", null, 2, null)) {
            ((Collection)lineList).add(new FormattedLine("Fresh water", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
        }
        return lineList;
    }
}

