/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.logic.GameInfo;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.managers.ReligionManager;
import com.unciv.models.Counter;
import com.unciv.models.Religion;
import com.unciv.models.ruleset.INonPerpetualConstruction;
import com.unciv.models.ruleset.MilestoneType;
import com.unciv.models.ruleset.Policy;
import com.unciv.models.ruleset.PolicyBranch;
import com.unciv.models.ruleset.Victory;
import com.unciv.models.ruleset.unique.Countables;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.stats.Stat;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.screens.civilopediascreen.FormattedLine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0003J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0003J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0003J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u0015H\u0007J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u0015H\u0007J\u0010\u0010\"\u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020!H\u0002J\u0018\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u001c\u0010)\u001a\b\u0012\u0004\u0012\u00020$0\u000f2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010,\u001a\u00020-2\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010.\u001a\u00020/H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u00060"}, d2={"Lcom/unciv/models/ruleset/Milestone;", "", "uniqueDescription", "", "parentVictory", "Lcom/unciv/models/ruleset/Victory;", "<init>", "(Ljava/lang/String;Lcom/unciv/models/ruleset/Victory;)V", "getUniqueDescription", "()Ljava/lang/String;", "type", "Lcom/unciv/models/ruleset/MilestoneType;", "getType", "()Lcom/unciv/models/ruleset/MilestoneType;", "params", "", "getParams", "()Ljava/util/List;", "getIncompleteSpaceshipParts", "Lcom/unciv/models/Counter;", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "originalMajorCapitalsOwned", "", "civsWithPotentialCapitalsToOwn", "", "gameInfo", "Lcom/unciv/logic/GameInfo;", "getMoreCountableThanOtherCivPercent", "", "civ", "otherCiv", "getMoreCountableThanOtherCivRelevant", "", "hasBeenCompletedBy", "getMilestoneButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "text", "achieved", "getVictoryScreenButtonHeaderText", "completed", "getVictoryScreenButtons", "completionStatus", "Lcom/unciv/models/ruleset/Victory$CompletionStatus;", "getFocus", "Lcom/unciv/models/ruleset/Victory$Focus;", "getFormattedLine", "Lcom/unciv/ui/screens/civilopediascreen/FormattedLine;", "core"})
@SourceDebugExtension(value={"SMAP\nVictory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Victory.kt\ncom/unciv/models/ruleset/Milestone\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,430:1\n296#2,2:431\n1834#2,4:433\n777#2:437\n873#2,2:438\n1807#2,3:440\n777#2:443\n873#2,2:444\n1786#2,3:446\n2045#2,14:451\n777#2:465\n873#2,2:466\n1786#2,3:468\n1834#2,4:471\n1834#2,4:475\n777#2:479\n873#2,2:480\n1834#2,4:482\n1834#2,4:486\n1834#2,4:490\n777#2:494\n873#2,2:495\n777#2:502\n873#2,2:503\n1586#2:505\n1661#2,3:506\n1807#2,3:509\n1276#3,2:449\n688#3:497\n719#3,4:498\n*S KotlinDebug\n*F\n+ 1 Victory.kt\ncom/unciv/models/ruleset/Milestone\n*L\n89#1:431,2\n101#1:433,4\n110#1:437\n110#1:438,2\n144#1:440,3\n155#1:443\n155#1:444,2\n156#1:446,3\n164#1:451,14\n170#1:465\n170#1:466,2\n171#1:468,3\n210#1:471,4\n213#1:475,4\n220#1:479\n220#1:480,2\n222#1:482,4\n239#1:486,4\n245#1:490,4\n303#1:494\n303#1:495,2\n349#1:502\n349#1:503,2\n384#1:505\n384#1:506,3\n389#1:509,3\n158#1:449,2\n305#1:497\n305#1:498,4\n*E\n"})
public final class Milestone {
    @NotNull
    private final String uniqueDescription;
    @NotNull
    private final Victory parentVictory;
    @Nullable
    private final MilestoneType type;
    @NotNull
    private final List<String> params;

    /*
     * WARNING - void declaration
     */
    public Milestone(@NotNull String uniqueDescription, @NotNull Victory parentVictory) {
        Object v0;
        block1: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter(uniqueDescription, "uniqueDescription");
            Intrinsics.checkNotNullParameter(parentVictory, "parentVictory");
            this.uniqueDescription = uniqueDescription;
            this.parentVictory = parentVictory;
            Iterable iterable = MilestoneType.getEntries();
            Milestone milestone = this;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                MilestoneType it = (MilestoneType)((Object)element$iv);
                boolean bl = false;
                if (!Intrinsics.areEqual(TranslationsKt.getPlaceholderText(this.uniqueDescription), TranslationsKt.getPlaceholderText(it.getText()))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        milestone.type = v0;
        this.params = TranslationsKt.getPlaceholderParameters(this.uniqueDescription);
    }

    @NotNull
    public final String getUniqueDescription() {
        return this.uniqueDescription;
    }

    @Nullable
    public final MilestoneType getType() {
        return this.type;
    }

    @NotNull
    public final List<String> getParams() {
        return this.params;
    }

    @Readonly
    private final Counter<String> getIncompleteSpaceshipParts(Civilization civInfo) {
        Object incompleteSpaceshipParts = this.parentVictory.getRequiredSpaceshipPartsAsCounter().clone();
        ((Counter)incompleteSpaceshipParts).remove(civInfo.getVictoryManager().getCurrentsSpaceshipParts());
        return incompleteSpaceshipParts;
    }

    /*
     * Unable to fully structure code
     */
    @Readonly
    private final int originalMajorCapitalsOwned(Civilization civInfo) {
        block4: {
            block3: {
                $this$count$iv = civInfo.getCities();
                $i$f$count = false;
                if (!($this$count$iv instanceof Collection) || !((Collection)$this$count$iv).isEmpty()) break block3;
                v0 = 0;
                break block4;
            }
            count$iv = 0;
            for (T element$iv : $this$count$iv) {
                it = (City)element$iv;
                $i$a$-count-Milestone$originalMajorCapitalsOwned$1 = false;
                if (!it.isOriginalCapital() || it.getFoundingCivObject() == null) ** GOTO lbl-1000
                v1 = it.getFoundingCivObject();
                Intrinsics.checkNotNull(v1);
                if (v1.isMajorCiv()) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                if (!v2 || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            v0 = count$iv;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    private final Set<Civilization> civsWithPotentialCapitalsToOwn(GameInfo gameInfo) {
        void $this$filterTo$iv$iv;
        Set<Civilization> civsWithCapitals = SequencesKt.toSet(SequencesKt.filter(SequencesKt.map(SequencesKt.filter(gameInfo.getCities(), Milestone::civsWithPotentialCapitalsToOwn$lambda$0), Milestone::civsWithPotentialCapitalsToOwn$lambda$1), Milestone::civsWithPotentialCapitalsToOwn$lambda$2));
        Iterable $this$filter$iv = gameInfo.getCivilizations();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            if (!(it.isMajorCiv() && !it.isDefeated())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List livingCivs = (List)destination$iv$iv;
        return CollectionsKt.union((Iterable)civsWithCapitals, livingCivs);
    }

    @Readonly
    public final float getMoreCountableThanOtherCivPercent(@NotNull Civilization civ, @NotNull Civilization otherCiv) {
        int countable2;
        Intrinsics.checkNotNullParameter(civ, "civ");
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        Integer n = Countables.Companion.getCountableAmount(this.params.get(0), new GameContext(civ, null, null, null, null, null, null, null, null, null, false, 2046, null));
        int countable1 = n != null ? n : 0;
        Integer n2 = Countables.Companion.getCountableAmount(this.params.get(1), new GameContext(otherCiv, null, null, null, null, null, null, null, null, null, false, 2046, null));
        int n3 = countable2 = n2 != null ? n2 : 0;
        return countable2 <= 0 ? (countable1 > countable2 ? 100.1f : 0.0f) : (float)countable1 / (float)countable2 * 100.0f;
    }

    @Readonly
    public final boolean getMoreCountableThanOtherCivRelevant(@NotNull Civilization civ, @NotNull Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(civ, "civ");
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        return !Intrinsics.areEqual(civ, otherCiv) && otherCiv.isMajorCiv() && otherCiv.isAlive();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Readonly
    public final boolean hasBeenCompletedBy(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        MilestoneType milestoneType = this.type;
        Intrinsics.checkNotNull((Object)milestoneType);
        switch (WhenMappings.$EnumSwitchMapping$0[milestoneType.ordinal()]) {
            case 1: {
                City it;
                Iterable $this$any$iv = civInfo.getCities();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    return false;
                }
                Iterator iterator2 = $this$any$iv.iterator();
                do {
                    if (!iterator2.hasNext()) return false;
                    Object element$iv = iterator2.next();
                    it = (City)element$iv;
                    boolean bl = false;
                } while (!it.getCityConstructions().isBuilt(this.params.get(0)));
                return true;
            }
            case 2: {
                boolean bl = this.getIncompleteSpaceshipParts(civInfo).isEmpty();
                return bl;
            }
            case 3: {
                boolean bl = Intrinsics.areEqual(civInfo.getGameInfo().getAliveMajorCivs(), CollectionsKt.listOf(civInfo));
                return bl;
            }
            case 4: {
                if (this.originalMajorCapitalsOwned(civInfo) != this.civsWithPotentialCapitalsToOwn(civInfo.getGameInfo()).size()) return false;
                return true;
            }
            case 5: {
                if (civInfo.getPolicies().getCompletedBranches().size() < Integer.parseInt(this.params.get(0))) return false;
                return true;
            }
            case 6: {
                boolean bl;
                Iterator $this$filterTo$iv$iv;
                Iterable $this$filter$iv = civInfo.getGameInfo().getCivilizations();
                boolean $i$f$filter = false;
                Iterable element$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                Iterator iterator3 = $this$filterTo$iv$iv.iterator();
                while (iterator3.hasNext()) {
                    Object element$iv$iv = iterator3.next();
                    Civilization it = (Civilization)element$iv$iv;
                    boolean bl2 = false;
                    if (!this.getMoreCountableThanOtherCivRelevant(civInfo, it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List relevantCivs = (List)destination$iv$iv;
                if (((Collection)relevantCivs).isEmpty()) return false;
                boolean bl3 = true;
                if (!bl3) return false;
                Iterable $this$all$iv = relevantCivs;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    return true;
                }
                $this$filterTo$iv$iv = $this$all$iv.iterator();
                do {
                    if (!$this$filterTo$iv$iv.hasNext()) return true;
                    Object element$iv2 = $this$filterTo$iv$iv.next();
                    Civilization it = (Civilization)element$iv2;
                    boolean bl4 = false;
                    if (!(this.getMoreCountableThanOtherCivPercent(civInfo, it) > 100.0f)) return false;
                    bl = true;
                } while (bl);
                return false;
            }
            case 7: {
                City it;
                Sequence<City> $this$any$iv = civInfo.getGameInfo().getCities();
                boolean $i$f$any = false;
                Iterator<City> $i$f$all = $this$any$iv.iterator();
                do {
                    City element$iv;
                    if (!$i$f$all.hasNext()) return false;
                    it = element$iv = $i$f$all.next();
                    boolean bl = false;
                } while (!it.getCityConstructions().isBuilt(this.params.get(0)));
                return true;
            }
            case 8: {
                boolean bl = civInfo.getVictoryManager().getHasEverWonDiplomaticVote();
                return bl;
            }
            case 9: {
                Object v4;
                void $this$maxByOrNull$iv;
                if (civInfo.getGameInfo().getTurns() < civInfo.getGameInfo().getGameParameters().getMaxTurns()) return false;
                Iterable $this$any$iv = civInfo.getGameInfo().getCivilizations();
                Civilization civilization = civInfo;
                boolean $i$f$maxByOrNull = false;
                Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v4 = null;
                } else {
                    Object maxElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v4 = maxElem$iv;
                    } else {
                        Civilization it = (Civilization)maxElem$iv;
                        boolean bl = false;
                        double maxValue$iv = it.calculateTotalScore();
                        do {
                            Object e$iv = iterator$iv.next();
                            Civilization it2 = (Civilization)e$iv;
                            $i$a$-maxByOrNull-Milestone$hasBeenCompletedBy$4 = false;
                            double v$iv = it2.calculateTotalScore();
                            if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                            maxElem$iv = e$iv;
                            maxValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v4 = maxElem$iv;
                    }
                }
                if (!Intrinsics.areEqual(civilization, v4)) return false;
                return true;
            }
            case 10: {
                Religion religion;
                ReligionManager religionManager;
                void $this$filterTo$iv$iv;
                if (!civInfo.getGameInfo().isReligionEnabled()) return false;
                if (civInfo.getReligionManager().getReligion() == null) return false;
                Iterable $this$filter$iv = civInfo.getGameInfo().getCivilizations();
                boolean $i$f$filter = false;
                Iterable iterator$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Civilization it = (Civilization)element$iv$iv;
                    boolean bl = false;
                    if (!(it.isMajorCiv() && it.isAlive())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$all$iv = (List)destination$iv$iv;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    return true;
                }
                Iterator iterator4 = $this$all$iv.iterator();
                do {
                    if (!iterator4.hasNext()) return true;
                    Object element$iv = iterator4.next();
                    Civilization it = (Civilization)element$iv;
                    boolean bl = false;
                    religionManager = it.getReligionManager();
                    religion = civInfo.getReligionManager().getReligion();
                    Intrinsics.checkNotNull(religion);
                } while (religionManager.isMajorityReligionForCiv(religion));
                return false;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final TextButton getMilestoneButton(String text2, boolean achieved) {
        TextButton textButton = Scene2dExtensionsKt.toTextButton$default(text2, null, true, 1, null);
        if (achieved) {
            textButton.setColor(Color.GREEN);
        } else {
            textButton.setColor(Color.GRAY);
        }
        return textButton;
    }

    /*
     * Unable to fully structure code
     */
    @Readonly
    @NotNull
    public final String getVictoryScreenButtonHeaderText(boolean completed, @NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        v0 = this.type;
        Intrinsics.checkNotNull((Object)v0);
        switch (WhenMappings.$EnumSwitchMapping$0[v0.ordinal()]) {
            case 1: 
            case 7: 
            case 8: 
            case 9: {
                v1 = this.uniqueDescription;
                break;
            }
            case 5: {
                amountToDo = TranslationsKt.tr$default(this.params.get(0), false, false, 3, null);
                amountDone = completed != false ? amountToDo : TranslationsKt.tr(civInfo.getCompletedPolicyBranchesCount());
                v1 = '{' + this.uniqueDescription + "} (" + amountDone + '/' + amountToDo + ')';
                break;
            }
            case 4: {
                amountToDo = this.civsWithPotentialCapitalsToOwn(civInfo.getGameInfo()).size();
                v2 = amountDone = completed != false ? amountToDo : this.originalMajorCapitalsOwned(civInfo);
                if (civInfo.shouldHideCivCount()) {
                    v1 = '{' + this.uniqueDescription + "} (" + TranslationsKt.tr(amountDone) + "/?)";
                    break;
                }
                v1 = '{' + this.uniqueDescription + "} (" + TranslationsKt.tr(amountDone) + '/' + TranslationsKt.tr(amountToDo) + ')';
                break;
            }
            case 3: {
                $this$count$iv = civInfo.getGameInfo().getCivilizations();
                $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    v3 = 0;
                } else {
                    count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        it = (Civilization)element$iv;
                        $i$a$-count-Milestone$getVictoryScreenButtonHeaderText$amountToDo$1 = false;
                        if (!it.isMajorCiv() || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    v3 = count$iv;
                }
                amountToDo = v3 - 1;
                if (completed) {
                    v4 = amountToDo;
                } else {
                    $i$f$count = civInfo.getGameInfo().getAliveMajorCivs();
                    var13_45 = amountToDo;
                    $i$f$count = false;
                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                        v5 = 0;
                    } else {
                        count$iv = 0;
                        for (E element$iv : $this$count$iv) {
                            it = (Civilization)element$iv;
                            $i$a$-count-Milestone$getVictoryScreenButtonHeaderText$amountDone$1 = false;
                            if (!(Intrinsics.areEqual(it, civInfo) == false) || ++count$iv >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        v5 = count$iv;
                    }
                    var14_49 = v5;
                    v4 = amountDone = var13_45 - var14_49;
                }
                if (civInfo.shouldHideCivCount()) {
                    v1 = '{' + this.uniqueDescription + "} (" + TranslationsKt.tr(amountDone) + "/?)";
                    break;
                }
                v1 = '{' + this.uniqueDescription + "} (" + TranslationsKt.tr(amountDone) + '/' + TranslationsKt.tr(amountToDo) + ')';
                break;
            }
            case 6: {
                $this$filter$iv = civInfo.getGameInfo().getCivilizations();
                $i$f$filter = false;
                $i$f$count = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (Civilization)element$iv$iv;
                    $i$a$-filter-Milestone$getVictoryScreenButtonHeaderText$relevantCivs$1 = false;
                    if (!this.getMoreCountableThanOtherCivRelevant(civInfo, it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                relevantCivs = (List)destination$iv$iv;
                amountToDo = relevantCivs.size();
                $this$count$iv = relevantCivs;
                $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    v6 = 0;
                } else {
                    count$iv = 0;
                    for (T element$iv : $this$count$iv) {
                        it = (Civilization)element$iv;
                        $i$a$-count-Milestone$getVictoryScreenButtonHeaderText$amountDone$2 = false;
                        if (!(this.getMoreCountableThanOtherCivPercent(civInfo, it) > 100.0f) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    v6 = amountDone = count$iv;
                }
                if (civInfo.shouldHideCivCount()) {
                    v1 = '{' + this.uniqueDescription + "} (" + TranslationsKt.tr(amountDone) + "/?)";
                    break;
                }
                v1 = '{' + this.uniqueDescription + "} (" + TranslationsKt.tr(amountDone) + '/' + TranslationsKt.tr(amountToDo) + ')';
                break;
            }
            case 2: {
                completeSpaceshipParts = civInfo.getVictoryManager().getCurrentsSpaceshipParts();
                incompleteSpaceshipParts = this.parentVictory.getRequiredSpaceshipPartsAsCounter().clone();
                amountToDo = incompleteSpaceshipParts.sumValues();
                incompleteSpaceshipParts.remove(completeSpaceshipParts);
                amountDone = amountToDo - incompleteSpaceshipParts.sumValues();
                v1 = '{' + this.uniqueDescription + "} (" + TranslationsKt.tr(amountDone) + '/' + TranslationsKt.tr(amountToDo) + ')';
                break;
            }
            case 10: {
                $this$count$iv = civInfo.getGameInfo().getCivilizations();
                $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    v7 = 0;
                } else {
                    count$iv = 0;
                    for (T element$iv : $this$count$iv) {
                        it = (Civilization)element$iv;
                        $i$a$-count-Milestone$getVictoryScreenButtonHeaderText$amountToDo$2 = false;
                        if (!(it.isMajorCiv() != false && it.isAlive() != false) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    v7 = count$iv;
                }
                amountToDo = v7 - 1;
                if (!completed) ** GOTO lbl120
                v8 = amountToDo;
                ** GOTO lbl149
lbl120:
                // 1 sources

                if (civInfo.getReligionManager().getReligion() != null) ** GOTO lbl123
                v8 = 0;
                ** GOTO lbl149
lbl123:
                // 1 sources

                v9 = civInfo.getReligionManager().getReligion();
                Intrinsics.checkNotNull(v9);
                if (!v9.isPantheon()) ** GOTO lbl128
                v8 = 1;
                ** GOTO lbl149
lbl128:
                // 1 sources

                $this$count$iv = civInfo.getGameInfo().getCivilizations();
                $i$f$count = false;
                if (!($this$count$iv instanceof Collection) || !((Collection)$this$count$iv).isEmpty()) ** GOTO lbl133
                v8 = 0;
                ** GOTO lbl149
lbl133:
                // 1 sources

                count$iv = 0;
                for (T element$iv : $this$count$iv) {
                    it = (Civilization)element$iv;
                    $i$a$-count-Milestone$getVictoryScreenButtonHeaderText$amountDone$3 = false;
                    if (!it.isMajorCiv() || !it.isAlive()) ** GOTO lbl-1000
                    v10 = it.getReligionManager();
                    v11 = civInfo.getReligionManager().getReligion();
                    Intrinsics.checkNotNull(v11);
                    if (v10.isMajorityReligionForCiv(v11)) {
                        v12 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v12 = false;
                    }
                    if (!v12 || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                v8 = count$iv;
lbl149:
                // 5 sources

                amountDone = v8;
                v1 = '{' + this.uniqueDescription + "} (" + TranslationsKt.tr(amountDone) + '/' + TranslationsKt.tr(amountToDo) + ')';
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return v1;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TextButton> getVictoryScreenButtons(@NotNull Victory.CompletionStatus completionStatus, @NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter((Object)completionStatus, "completionStatus");
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        TextButton headerButton = this.getMilestoneButton(this.getVictoryScreenButtonHeaderText(completionStatus == Victory.CompletionStatus.Completed, civInfo), completionStatus == Victory.CompletionStatus.Completed);
        if (completionStatus == Victory.CompletionStatus.Completed || completionStatus == Victory.CompletionStatus.Incomplete) {
            return CollectionsKt.listOf(headerButton);
        }
        TextButton[] textButtonArray = new TextButton[]{headerButton};
        List<TextButton> buttons = CollectionsKt.mutableListOf(textButtonArray);
        MilestoneType milestoneType = this.type;
        switch (milestoneType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[milestoneType.ordinal()]) {
            case -1: 
            case 1: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 2: {
                int it;
                int n;
                int n2;
                Counter<String> completedSpaceshipParts = civInfo.getVictoryManager().getCurrentsSpaceshipParts();
                Counter<String> incompleteSpaceshipParts = this.getIncompleteSpaceshipParts(civInfo);
                for (Map.Entry part : ((Map)completedSpaceshipParts).entrySet()) {
                    Object v = part.getValue();
                    Intrinsics.checkNotNullExpressionValue(v, "<get-value>(...)");
                    n2 = ((Number)v).intValue();
                    n = 0;
                    while (n < n2) {
                        it = n++;
                        boolean bl = false;
                        Object k = part.getKey();
                        Intrinsics.checkNotNullExpressionValue(k, "<get-key>(...)");
                        buttons.add(this.getMilestoneButton((String)k, true));
                    }
                }
                for (Map.Entry part : ((Map)incompleteSpaceshipParts).entrySet()) {
                    Object v = part.getValue();
                    Intrinsics.checkNotNullExpressionValue(v, "<get-value>(...)");
                    n2 = ((Number)v).intValue();
                    n = 0;
                    while (n < n2) {
                        it = n++;
                        boolean bl = false;
                        Object k = part.getKey();
                        Intrinsics.checkNotNullExpressionValue(k, "<get-key>(...)");
                        buttons.add(this.getMilestoneButton((String)k, false));
                    }
                }
                break;
            }
            case 3: {
                boolean hideCivCount = civInfo.shouldHideCivCount();
                Iterator<Civilization> iterator2 = civInfo.getGameInfo().getCivilizations().iterator();
                Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
                Iterator<Civilization> incompleteSpaceshipParts = iterator2;
                while (incompleteSpaceshipParts.hasNext()) {
                    Civilization civ;
                    Intrinsics.checkNotNullExpressionValue(incompleteSpaceshipParts.next(), "next(...)");
                    if (Intrinsics.areEqual(civ, civInfo) || !civ.isMajorCiv() || hideCivCount && !civInfo.knows(civ)) continue;
                    String milestoneText = civInfo.knows(civ) || civ.isDefeated() ? "Destroy [" + civ.getCivName() + ']' : "Destroy [???]";
                    buttons.add(this.getMilestoneButton(milestoneText, civ.isDefeated()));
                }
                if (!hideCivCount) break;
                buttons.add(this.getMilestoneButton("Destroy ? * [???]", false));
                break;
            }
            case 4: {
                void $this$associateByTo$iv$iv;
                Iterator $this$associateBy$iv;
                void $this$filterTo$iv$iv;
                boolean hideCivCount = civInfo.shouldHideCivCount();
                Iterable $this$filter$iv = civInfo.getGameInfo().getCivilizations();
                boolean $i$f$filter22 = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Civilization it = (Civilization)element$iv$iv;
                    boolean bl = false;
                    if (!it.isMajorCiv()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List majorCivs = (List)destination$iv$iv;
                Sequence<City> $i$f$filter22 = SequencesKt.filter(civInfo.getGameInfo().getCities(), Milestone::getVictoryScreenButtons$lambda$3);
                boolean $i$f$associateBy = false;
                destination$iv$iv = $this$associateBy$iv;
                Map destination$iv$iv2 = new LinkedHashMap();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    void it;
                    City bl = (City)element$iv$iv;
                    Map map2 = destination$iv$iv2;
                    boolean bl2 = false;
                    map2.put(it.getFoundingCivObject(), element$iv$iv);
                }
                Map originalCapitals = destination$iv$iv2;
                for (Civilization civ : majorCivs) {
                    boolean bl;
                    City city = (City)originalCapitals.get(civ);
                    if (city != null) {
                        boolean isKnown = civInfo.hasExplored(city.getCenterTile());
                        if (hideCivCount && !isKnown) continue;
                        String milestoneText = isKnown ? "Capture [" + city.getName() + ']' : "Capture [???]";
                        bl = buttons.add(this.getMilestoneButton(milestoneText, Intrinsics.areEqual(city.getCiv(), civInfo)));
                        continue;
                    }
                    String milestoneText = civInfo.knows(civ) || civ.isDefeated() ? "Destroy [" + civ.getCivName() + ']' : "Destroy [???]";
                    bl = buttons.add(this.getMilestoneButton(milestoneText, civ.isDefeated()));
                }
                if (!hideCivCount) break;
                buttons.add(this.getMilestoneButton("Capture ? * [???]", false));
                break;
            }
            case 5: {
                Iterator<PolicyBranch> hideCivCount = civInfo.getGameInfo().getRuleset().getPolicyBranches().values().iterator();
                while (hideCivCount.hasNext()) {
                    PolicyBranch branch;
                    Intrinsics.checkNotNullExpressionValue(hideCivCount.next(), "next(...)");
                    String finisher = ((Policy)CollectionsKt.last((List)branch.getPolicies())).getName();
                    buttons.add(this.getMilestoneButton(finisher, civInfo.getPolicies().isAdopted(finisher)));
                }
                break;
            }
            case 6: {
                boolean hideCivCount = civInfo.shouldHideCivCount();
                Iterator<Civilization> iterator3 = civInfo.getGameInfo().getCivilizations().iterator();
                Intrinsics.checkNotNullExpressionValue(iterator3, "iterator(...)");
                Iterator<Civilization> branch = iterator3;
                while (branch.hasNext()) {
                    Civilization otherCiv;
                    Intrinsics.checkNotNullExpressionValue(branch.next(), "next(...)");
                    if (!this.getMoreCountableThanOtherCivRelevant(civInfo, otherCiv) || hideCivCount && !civInfo.knows(otherCiv)) continue;
                    String civName = civInfo.knows(otherCiv) ? otherCiv.getCivName() : "???";
                    float percent = this.getMoreCountableThanOtherCivPercent(civInfo, otherCiv);
                    String milestoneText = percent < 1.0f || percent >= 200.0f ? '[' + civName + ']' : '[' + civName + "] [" + (int)percent + "]%";
                    buttons.add(this.getMilestoneButton(milestoneText, percent > 100.0f));
                }
                if (!hideCivCount) break;
                buttons.add(this.getMilestoneButton("[???]", false));
                break;
            }
            case 10: {
                void $this$filterTo$iv$iv;
                boolean hideCivCount = civInfo.shouldHideCivCount();
                Iterable $this$filter$iv = civInfo.getGameInfo().getCivilizations();
                boolean $i$f$filter = false;
                Iterable percent = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Civilization it = (Civilization)element$iv$iv;
                    boolean bl = false;
                    if (!(it.isMajorCiv() && it.isAlive())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List majorCivs = (List)destination$iv$iv;
                Religion civReligion = civInfo.getReligionManager().getReligion();
                for (Civilization civ : majorCivs) {
                    if (hideCivCount && !civInfo.knows(civ)) continue;
                    String milestoneText = civInfo.knows(civ) ? "Majority religion of [" + civ.getCivName() + ']' : "Majority religion of [???]";
                    boolean milestoneMet = civReligion != null && (!civReligion.isPantheon() || Intrinsics.areEqual(civInfo, civ)) && civ.getReligionManager().isMajorityReligionForCiv(civReligion);
                    buttons.add(this.getMilestoneButton(milestoneText, milestoneMet));
                }
                if (!hideCivCount) break;
                buttons.add(this.getMilestoneButton("Majority religion of ? * [???]", false));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return buttons;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final Victory.Focus getFocus(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        ruleset = civInfo.getGameInfo().getRuleset();
        v0 = this.type;
        Intrinsics.checkNotNull((Object)v0);
        block0 : switch (WhenMappings.$EnumSwitchMapping$0[v0.ordinal()]) {
            case 1: {
                v1 = ruleset.getBuildings().get(this.params.get(0));
                Intrinsics.checkNotNull(v1);
                building = v1;
                if (!civInfo.getTech().isResearched(building)) {
                }
                v2 = Victory.Focus.Production;
                break;
            }
            case 7: {
                v3 = ruleset.getBuildings().get(this.params.get(0));
                Intrinsics.checkNotNull(v3);
                building = v3;
                if (!civInfo.getTech().isResearched(building)) {
                }
                v2 = Victory.Focus.Production;
                break;
            }
            case 2: {
                v4 = this.getIncompleteSpaceshipParts(civInfo).keySet();
                Intrinsics.checkNotNullExpressionValue(v4, "<get-keys>(...)");
                $this$map$iv = v4;
                $i$f$map = false;
                var6_8 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var11_15 = (String)item$iv$iv;
                    var13_17 = destination$iv$iv;
                    $i$a$-map-Milestone$getFocus$constructions$1 = false;
                    if (((Map)ruleset.getBuildings()).containsKey(it)) {
                        v5 = ruleset.getBuildings().get(it);
                        Intrinsics.checkNotNull(v5);
                        v6 = v5;
                    } else {
                        v7 = ruleset.getUnits().get(it);
                        Intrinsics.checkNotNull(v7);
                        v6 = v7;
                    }
                    var13_17.add(v6);
                }
                constructions = (List)destination$iv$iv;
                $this$any$iv = constructions;
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl51
                v8 = false;
                ** GOTO lbl58
lbl51:
                // 2 sources

                for (E element$iv : $this$any$iv) {
                    it = (IHasUniques)element$iv;
                    $i$a$-any-Milestone$getFocus$1 = false;
                    if (!(civInfo.getTech().isResearched((INonPerpetualConstruction)it) == false)) continue;
                    v8 = true;
                    ** GOTO lbl58
                }
                v8 = false;
lbl58:
                // 3 sources

                if (v8) {
                }
                v2 = Victory.Focus.Production;
                break;
            }
            case 3: 
            case 4: {
                v2 = Victory.Focus.Military;
                break;
            }
            case 5: {
                v2 = Victory.Focus.Culture;
                break;
            }
            case 6: {
                v9 = Countables.Companion.getMatching(this.params.get(0), ruleset);
                switch (v9 == null ? -1 : WhenMappings.$EnumSwitchMapping$2[v9.ordinal()]) {
                    case 1: {
                        v10 = Stat.Companion.safeValueOf(this.params.get(0));
                        switch (v10 == null ? -1 : WhenMappings.$EnumSwitchMapping$1[v10.ordinal()]) {
                            case 1: {
                                v2 = Victory.Focus.Production;
                                break block0;
                            }
                            case 2: {
                                v2 = Victory.Focus.Production;
                                break block0;
                            }
                            case 3: {
                                v2 = Victory.Focus.Gold;
                                break block0;
                            }
                            case 4: {
                                v2 = Victory.Focus.Science;
                                break block0;
                            }
                            case 5: {
                                v2 = Victory.Focus.Culture;
                                break block0;
                            }
                            case 6: {
                                v2 = Victory.Focus.Gold;
                                break block0;
                            }
                            case 7: {
                                v2 = Victory.Focus.Faith;
                                break block0;
                            }
                        }
                        v2 = Victory.Focus.Production;
                        break block0;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        v2 = Victory.Focus.Production;
                        break block0;
                    }
                    case 6: 
                    case 7: {
                        v2 = Victory.Focus.Military;
                        break block0;
                    }
                    case 8: 
                    case 9: {
                        v2 = Victory.Focus.Culture;
                        break block0;
                    }
                    case 10: 
                    case 11: {
                        v2 = Victory.Focus.Production;
                        break block0;
                    }
                }
                v2 = Victory.Focus.Score;
                break;
            }
            case 8: {
                v2 = Victory.Focus.CityStates;
                break;
            }
            case 9: {
                v2 = Victory.Focus.Score;
                break;
            }
            case 10: {
                v2 = Victory.Focus.Faith;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return v2;
    }

    @Readonly
    @NotNull
    public final FormattedLine getFormattedLine() {
        FormattedLine formattedLine;
        MilestoneType milestoneType = this.type;
        Intrinsics.checkNotNull((Object)milestoneType);
        switch (WhenMappings.$EnumSwitchMapping$0[milestoneType.ordinal()]) {
            case 1: {
                formattedLine = new FormattedLine(this.uniqueDescription, "Wonder/" + this.params.get(0), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null);
                break;
            }
            case 7: {
                formattedLine = new FormattedLine(this.uniqueDescription, "Wonder/" + this.params.get(0), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null);
                break;
            }
            case 10: {
                formattedLine = new FormattedLine(this.uniqueDescription, "Tutorials/Religion", null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null);
                break;
            }
            case 5: {
                formattedLine = new FormattedLine(this.uniqueDescription, "Policies", null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null);
                break;
            }
            default: {
                formattedLine = new FormattedLine(this.uniqueDescription, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, true, false, false, 14334, null);
            }
        }
        return formattedLine;
    }

    private static final boolean civsWithPotentialCapitalsToOwn$lambda$0(City it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isOriginalCapital();
    }

    private static final Civilization civsWithPotentialCapitalsToOwn$lambda$1(City it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Civilization civilization = it.getFoundingCivObject();
        Intrinsics.checkNotNull(civilization);
        return civilization;
    }

    private static final boolean civsWithPotentialCapitalsToOwn$lambda$2(Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isMajorCiv();
    }

    private static final boolean getVictoryScreenButtons$lambda$3(City it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isOriginalCapital();
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[MilestoneType.values().length];
            try {
                nArray[MilestoneType.BuiltBuilding.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MilestoneType.AddedSSPartsInCapital.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MilestoneType.DestroyAllPlayers.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MilestoneType.CaptureAllCapitals.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MilestoneType.CompletePolicyBranches.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MilestoneType.MoreCountableThanEachPlayer.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MilestoneType.BuildingBuiltGlobally.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MilestoneType.WinDiplomaticVote.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MilestoneType.ScoreAfterTimeOut.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MilestoneType.WorldReligion.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Stat.values().length];
            try {
                nArray[Stat.Production.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Stat.Food.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Stat.Gold.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Stat.Science.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Stat.Culture.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Stat.Happiness.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Stat.Faith.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[Countables.values().length];
            try {
                nArray[Countables.Stats.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Countables.Cities.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Countables.FilteredCities.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Countables.FilteredBuildings.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Countables.OwnedTiles.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Countables.Units.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Countables.FilteredUnits.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Countables.PolicyBranches.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Countables.FilteredPolicies.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Countables.TileResources.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Countables.TileFilterTiles.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

