/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset.tile;

import com.badlogic.gdx.graphics.Color;
import com.unciv.logic.MultiFilter;
import com.unciv.models.ruleset.Belief;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetStatsObject;
import com.unciv.models.ruleset.tile.TerrainType;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTarget;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.stats.INamed;
import com.unciv.models.stats.Stats;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.objectdescriptions.DescriptionHelpersKt;
import com.unciv.ui.screens.civilopediascreen.FormattedLine;
import com.unciv.ui.screens.civilopediascreen.ICivilopediaText;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Cache;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010<\u001a\u00020\u000bH\u0007J\u0016\u0010=\u001a\u00020\u000b2\u0006\u0010>\u001a\u00020\u00052\u0006\u0010?\u001a\u00020@J\b\u0010A\u001a\u00020BH\u0007J\b\u0010C\u001a\u00020\u0015H\u0016J\u0016\u0010D\u001a\b\u0012\u0004\u0012\u00020E0'2\u0006\u0010?\u001a\u00020@H\u0016J\u0010\u0010F\u001a\u00020!2\u0006\u0010?\u001a\u00020@H\u0016J\u0012\u0010G\u001a\u0004\u0018\u00010\u00152\u0006\u0010?\u001a\u00020@H\u0016J&\u0010L\u001a\u00020\u000b2\u0006\u0010M\u001a\u00020\u00152\n\b\u0002\u0010N\u001a\u0004\u0018\u00010O2\b\b\u0002\u0010P\u001a\u00020\u000bH\u0007J\u0010\u0010Q\u001a\u00020\u000b2\u0006\u0010M\u001a\u00020\u0015H\u0007J\u0006\u0010R\u001a\u00020SR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR!\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00150\u0014j\b\u0012\u0004\u0012\u00020\u0015`\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R(\u0010&\u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010'X\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b(\u0010\u0003\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010#\"\u0004\b/\u0010%R\u001a\u00100\u001a\u000201X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001a\u00106\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\r\"\u0004\b8\u0010\u000fR\u001a\u00109\u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010#\"\u0004\b;\u0010%R2\u0010H\u001a\u001e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u000b0Ij\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u000b`J8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\bK\u0010\u0003\u00a8\u0006T"}, d2={"Lcom/unciv/models/ruleset/tile/Terrain;", "Lcom/unciv/models/ruleset/RulesetStatsObject;", "<init>", "()V", "type", "Lcom/unciv/models/ruleset/tile/TerrainType;", "getType", "()Lcom/unciv/models/ruleset/tile/TerrainType;", "setType", "(Lcom/unciv/models/ruleset/tile/TerrainType;)V", "overrideStats", "", "getOverrideStats", "()Z", "setOverrideStats", "(Z)V", "unbuildable", "getUnbuildable", "setUnbuildable", "occursOn", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "getOccursOn", "()Ljava/util/ArrayList;", "turnsInto", "getTurnsInto", "()Ljava/lang/String;", "setTurnsInto", "(Ljava/lang/String;)V", "getUniqueTarget", "Lcom/unciv/models/ruleset/unique/UniqueTarget;", "weight", "", "getWeight", "()I", "setWeight", "(I)V", "RGB", "", "getRGB$annotations", "getRGB", "()Ljava/util/List;", "setRGB", "(Ljava/util/List;)V", "movementCost", "getMovementCost", "setMovementCost", "defenceBonus", "", "getDefenceBonus", "()F", "setDefenceBonus", "(F)V", "impassable", "getImpassable", "setImpassable", "damagePerTurn", "getDamagePerTurn", "setDamagePerTurn", "isRough", "displayAs", "asType", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "getColor", "Lcom/badlogic/gdx/graphics/Color;", "makeLink", "getCivilopediaTextLines", "Lcom/unciv/ui/screens/civilopediascreen/FormattedLine;", "getSortGroup", "getSubCategory", "cachedMatchesFilterResult", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getCachedMatchesFilterResult$annotations", "matchesFilter", "filter", "state", "Lcom/unciv/models/ruleset/unique/GameContext;", "multiFilter", "matchesSingleFilter", "setTransients", "", "core"})
@SourceDebugExtension(value={"SMAP\nTerrain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Terrain.kt\ncom/unciv/models/ruleset/tile/Terrain\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,209:1\n1807#2,2:210\n777#2:212\n873#2,2:213\n1586#2:215\n1661#2,3:216\n1809#2:219\n1915#2,2:220\n777#2:222\n873#2,2:223\n777#2:225\n873#2,2:226\n1915#2,2:228\n1807#2,2:238\n1807#2,3:240\n1809#2:243\n383#3,7:230\n383#3,7:244\n1#4:237\n*S KotlinDebug\n*F\n+ 1 Terrain.kt\ncom/unciv/models/ruleset/tile/Terrain\n*L\n60#1:210,2\n62#1:212\n62#1:213,2\n63#1:215\n63#1:216,3\n60#1:219\n101#1:220,2\n108#1:222\n108#1:223,2\n120#1:225\n120#1:226,2\n129#1:228,2\n150#1:238,2\n151#1:240,3\n150#1:243\n182#1:230,7\n178#1:244,7\n*E\n"})
public final class Terrain
extends RulesetStatsObject {
    public TerrainType type;
    private boolean overrideStats;
    private boolean unbuildable;
    @NotNull
    private final ArrayList<String> occursOn = new ArrayList();
    @Nullable
    private String turnsInto;
    private int weight = 10;
    @Nullable
    private List<Integer> RGB;
    private int movementCost = 1;
    private float defenceBonus;
    private boolean impassable;
    private transient int damagePerTurn;
    @NotNull
    private final HashMap<String, Boolean> cachedMatchesFilterResult = new HashMap();

    @NotNull
    public final TerrainType getType() {
        TerrainType terrainType = this.type;
        if (terrainType != null) {
            return terrainType;
        }
        Intrinsics.throwUninitializedPropertyAccessException("type");
        return null;
    }

    public final void setType(@NotNull TerrainType terrainType) {
        Intrinsics.checkNotNullParameter((Object)terrainType, "<set-?>");
        this.type = terrainType;
    }

    public final boolean getOverrideStats() {
        return this.overrideStats;
    }

    public final void setOverrideStats(boolean bl) {
        this.overrideStats = bl;
    }

    public final boolean getUnbuildable() {
        return this.unbuildable;
    }

    public final void setUnbuildable(boolean bl) {
        this.unbuildable = bl;
    }

    @NotNull
    public final ArrayList<String> getOccursOn() {
        return this.occursOn;
    }

    @Nullable
    public final String getTurnsInto() {
        return this.turnsInto;
    }

    public final void setTurnsInto(@Nullable String string) {
        this.turnsInto = string;
    }

    @Override
    @NotNull
    public UniqueTarget getUniqueTarget() {
        return UniqueTarget.Terrain;
    }

    public final int getWeight() {
        return this.weight;
    }

    public final void setWeight(int n) {
        this.weight = n;
    }

    @Nullable
    public final List<Integer> getRGB() {
        return this.RGB;
    }

    public final void setRGB(@Nullable List<Integer> list2) {
        this.RGB = list2;
    }

    public static /* synthetic */ void getRGB$annotations() {
    }

    public final int getMovementCost() {
        return this.movementCost;
    }

    public final void setMovementCost(int n) {
        this.movementCost = n;
    }

    public final float getDefenceBonus() {
        return this.defenceBonus;
    }

    public final void setDefenceBonus(float f) {
        this.defenceBonus = f;
    }

    public final boolean getImpassable() {
        return this.impassable;
    }

    public final void setImpassable(boolean bl) {
        this.impassable = bl;
    }

    public final int getDamagePerTurn() {
        return this.damagePerTurn;
    }

    public final void setDamagePerTurn(int n) {
        this.damagePerTurn = n;
    }

    @Readonly
    public final boolean isRough() {
        return IHasUniques.hasUnique$default(this, UniqueType.RoughTerrain, null, 2, null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean displayAs(@NotNull TerrainType asType, @NotNull Ruleset ruleset) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)asType, "asType");
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        if (this.getType() == asType) return true;
        Iterable $this$any$iv = this.occursOn;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Terrain it;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                String occursName = (String)element$iv;
                boolean bl2 = false;
                Collection<Terrain> collection = ruleset.getTerrains().values();
                Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
                Iterable iterable = collection;
                boolean $i$f$filter = false;
                void var11_11 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (Terrain)element$iv$iv;
                    boolean bl3 = false;
                    if (!(it.getType() == asType)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (Terrain)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl4 = false;
                    collection2.add(it.getName());
                }
                if (!((List)destination$iv$iv).contains(occursName)) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        Terrain terrain = (Terrain)((Map)ruleset.getTerrains()).get(this.turnsInto);
        if ((terrain != null ? terrain.getType() : null) != asType) return false;
        return true;
    }

    @Readonly
    @NotNull
    public final Color getColor() {
        if (this.RGB == null) {
            Color color = Color.GOLD.cpy();
            Intrinsics.checkNotNullExpressionValue(color, "cpy(...)");
            return color;
        }
        List<Integer> list2 = this.RGB;
        Intrinsics.checkNotNull(list2);
        return Scene2dExtensionsKt.colorFromRGB(list2);
    }

    @Override
    @NotNull
    public String makeLink() {
        return "Terrain/" + this.getName();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<FormattedLine> getCivilopediaTextLines(@NotNull Ruleset ruleset) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Iterator $this$filter$iv;
        Object element$iv2;
        Stats stats;
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        ArrayList textList = new ArrayList();
        if (this.getType() == TerrainType.NaturalWonder) {
            ((Collection)textList).add(new FormattedLine("Natural Wonder", null, null, null, 0.0f, 0, 3, 0, 0.0f, "#3A0", false, false, false, false, 15806, null));
        }
        if (!(stats = this.cloneStats()).isEmpty() || this.overrideStats) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)textList).add(new FormattedLine(stats.isEmpty() ? "No yields" : String.valueOf(stats), null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            if (this.overrideStats) {
                ((Collection)textList).add(new FormattedLine("Overrides yields from underlying terrain", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            }
        }
        if (!((Collection)this.occursOn).isEmpty() && !IHasUniques.hasUnique$default(this, UniqueType.NoNaturalGeneration, null, 2, null)) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            if (this.occursOn.size() == 1) {
                String $this$getCivilopediaTextLines_u24lambda_u240 = this.occursOn.get(0);
                boolean bl = false;
                ((Collection)textList).add(new FormattedLine("Occurs on [" + $this$getCivilopediaTextLines_u24lambda_u240 + ']', "Terrain/" + $this$getCivilopediaTextLines_u24lambda_u240, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
            } else {
                ((Collection)textList).add(new FormattedLine("Occurs on:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
                Iterable $this$forEach$iv = this.occursOn;
                boolean $i$f$forEach = false;
                for (Object element$iv2 : $this$forEach$iv) {
                    String it = (String)element$iv2;
                    boolean bl = false;
                    ((Collection)textList).add(new FormattedLine(it, "Terrain/" + it, null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null));
                }
            }
        }
        Collection<TileImprovement> collection = ruleset.getTileImprovements().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $i$f$forEach = collection;
        boolean $i$f$filter = false;
        element$iv2 = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            TileImprovement it = (TileImprovement)element$iv$iv;
            boolean bl = false;
            if (!it.getTerrainsCanBeBuiltOn().contains(this.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List improvementsThatCanBePlacedHere = (List)destination$iv$iv;
        if (!((Collection)improvementsThatCanBePlacedHere).isEmpty()) {
            ((Collection)textList).add(new FormattedLine("{Tile Improvements}:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            for (Object e : improvementsThatCanBePlacedHere) {
                Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                TileImprovement improvement = (TileImprovement)e;
                ((Collection)textList).add(new FormattedLine(improvement.getName(), improvement.makeLink(), null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null));
            }
        }
        if (this.turnsInto != null) {
            ((Collection)textList).add(new FormattedLine("Placed on [" + this.turnsInto + ']', "Terrain/" + this.turnsInto, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
        }
        Collection<TileResource> collection2 = ruleset.getTileResources().values();
        Intrinsics.checkNotNullExpressionValue(collection2, "<get-values>(...)");
        Iterable $this$filter$iv2 = collection2;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TileResource it = (TileResource)element$iv$iv;
            boolean bl = false;
            if (!it.getTerrainsCanBeFoundOn().contains(this.getName())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List resourcesFound = (List)destination$iv$iv2;
        if (!((Collection)resourcesFound).isEmpty()) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            if (resourcesFound.size() == 1) {
                TileResource $this$getCivilopediaTextLines_u24lambda_u244 = (TileResource)resourcesFound.get(0);
                boolean bl = false;
                ((Collection)textList).add(new FormattedLine("May contain [" + $this$getCivilopediaTextLines_u24lambda_u244 + ']', "Resource/" + $this$getCivilopediaTextLines_u24lambda_u244, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
            } else {
                ((Collection)textList).add(new FormattedLine("May contain:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
                Iterable $this$forEach$iv = resourcesFound;
                boolean $i$f$forEach2 = false;
                for (Object element$iv3 : $this$forEach$iv) {
                    TileResource it = (TileResource)element$iv3;
                    boolean bl = false;
                    ((Collection)textList).add(new FormattedLine(String.valueOf(it), "Resource/" + it, null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null));
                }
            }
        }
        ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
        if (this.turnsInto == null && this.displayAs(TerrainType.Land, ruleset) && !this.isRough()) {
            ((Collection)textList).add(new FormattedLine("Open terrain", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
        }
        DescriptionHelpersKt.uniquesToCivilopediaTextLines$default(this, textList, null, false, null, 12, null);
        ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
        if (this.impassable) {
            ((Collection)textList).add(new FormattedLine("Impassable", null, null, null, 0.0f, 0, 0, 0, 0.0f, "#A00", false, false, false, false, 15870, null));
        } else if (this.movementCost > 0) {
            ((Collection)textList).add(new FormattedLine("{Movement cost}: " + this.movementCost, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
        }
        if (!(this.defenceBonus == 0.0f)) {
            ((Collection)textList).add(new FormattedLine("{Defence bonus}: " + (int)(this.defenceBonus * (float)100) + '%', null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
        }
        Collection<Building> collection3 = ruleset.getBuildings().values();
        Intrinsics.checkNotNullExpressionValue(collection3, "<get-values>(...)");
        Sequence sequence = CollectionsKt.asSequence((Iterable)collection3);
        Collection<BaseUnit> collection4 = ruleset.getUnits().values();
        Intrinsics.checkNotNullExpressionValue(collection4, "<get-values>(...)");
        Sequence<FormattedLine> seeAlso = SequencesKt.plus(SequencesKt.map(SequencesKt.filter(SequencesKt.plus(sequence, CollectionsKt.asSequence((Iterable)collection4)), arg_0 -> Terrain.getCivilopediaTextLines$lambda$6(this, arg_0)), Terrain::getCivilopediaTextLines$lambda$7), Belief.Companion.getCivilopediaTextMatching(this.getName(), ruleset, false));
        if (SequencesKt.any(seeAlso)) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)textList).add(new FormattedLine("{See also}:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            CollectionsKt.addAll((Collection)textList, seeAlso);
        }
        return textList;
    }

    @Override
    public int getSortGroup(@NotNull Ruleset ruleset) {
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        return this.getType().ordinal();
    }

    @Override
    @Nullable
    public String getSubCategory(@NotNull Ruleset ruleset) {
        String string;
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        switch (WhenMappings.$EnumSwitchMapping$0[this.getType().ordinal()]) {
            case 1: {
                string = "Land";
                break;
            }
            case 2: {
                string = "Water";
                break;
            }
            case 3: {
                string = "Features";
                break;
            }
            case 4: {
                string = "Natural Wonders";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Cache
    private static /* synthetic */ void getCachedMatchesFilterResult$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    public final boolean matchesFilter(@NotNull String filter2, @Nullable GameContext state, boolean multiFilter) {
        boolean bl;
        Intrinsics.checkNotNullParameter(filter2, "filter");
        if (multiFilter) {
            bl = MultiFilter.multiFilter$default(MultiFilter.INSTANCE, filter2, arg_0 -> Terrain.matchesFilter$lambda$0(this, state, arg_0), false, 4, null);
        } else {
            Object object;
            void $this$getOrPut$iv;
            Map map2 = this.cachedMatchesFilterResult;
            String key$iv = filter2;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                Boolean answer$iv = this.matchesSingleFilter(filter2);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            bl = (Boolean)object != false || state != null && this.hasTagUnique(filter2, state) || state == null && this.hasTagUnique(filter2);
        }
        return bl;
    }

    public static /* synthetic */ boolean matchesFilter$default(Terrain terrain, String string, GameContext gameContext, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            gameContext = null;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return terrain.matchesFilter(string, gameContext, bl);
    }

    @Readonly
    public final boolean matchesSingleFilter(@NotNull String filter2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(filter2, "filter");
        switch (filter2) {
            case "all": 
            case "All": {
                bl = true;
                break;
            }
            case "Terrain": {
                bl = true;
                break;
            }
            case "Open terrain": {
                if (!this.isRough()) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case "Rough terrain": {
                bl = this.isRough();
                break;
            }
            case "Natural Wonder": {
                if (this.getType() == TerrainType.NaturalWonder) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case "Terrain Feature": {
                if (this.getType() == TerrainType.TerrainFeature) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                String string = filter2;
                bl = Intrinsics.areEqual(string, this.getName()) ? true : Intrinsics.areEqual(string, this.getType().name());
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final void setTransients() {
        int n;
        Sequence sequence = IHasUniques.getMatchingUniques$default(this, UniqueType.DamagesContainingUnits, null, 2, null);
        Terrain terrain = this;
        int n2 = 0;
        Iterator iterator2 = sequence.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object t = iterator2.next();
            Unique unique = (Unique)t;
            n = n2;
            boolean bl = false;
            int n3 = Integer.parseInt(it.getParams().get(0));
            n2 = n + n3;
        }
        terrain.damagePerTurn = n = n2;
    }

    private static final boolean getCivilopediaTextLines$lambda$6(Terrain this$0, IHasUniques construction) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter(construction, "construction");
            Iterable $this$any$iv = construction.getUniqueObjects();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block6: {
                        Unique unique = (Unique)element$iv;
                        boolean bl3 = false;
                        Iterable $this$any$iv2 = unique.getParams();
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                String it = (String)element$iv2;
                                boolean bl4 = false;
                                if (!Intrinsics.areEqual(it, this$0.getName())) continue;
                                bl2 = true;
                                break block6;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final FormattedLine getCivilopediaTextLines$lambda$7(IHasUniques it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new FormattedLine(((INamed)it).getName(), ((ICivilopediaText)((Object)it)).makeLink(), null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean matchesFilter$lambda$0(Terrain this$0, GameContext $state, String it) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter(it, "it");
        Map map2 = this$0.cachedMatchesFilterResult;
        String key$iv = it;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Boolean answer$iv = this$0.matchesSingleFilter(it);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Boolean)object != false || $state != null && this$0.hasTagUnique(it, $state) || $state == null && this$0.hasTagUnique(it);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TerrainType.values().length];
            try {
                nArray[TerrainType.Land.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TerrainType.Water.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TerrainType.TerrainFeature.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TerrainType.NaturalWonder.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

