/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset.unique.expressions;

import com.unciv.logic.GameInfo;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.unique.Countables;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.expressions.Operator;
import com.unciv.models.ruleset.unique.expressions.Tokenizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Pure;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bp\u0018\u00002\u00020\u0001:\u0006\u000b\f\r\u000e\u000f\u0010J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H'J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH'\u0082\u0001\u0005\u0011\u0012\u0013\u0014\u0015\u00a8\u0006\u0016\u00c0\u0006\u0003"}, d2={"Lcom/unciv/models/ruleset/unique/expressions/Node;", "", "eval", "", "context", "Lcom/unciv/models/ruleset/unique/GameContext;", "getErrors", "", "", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "Constant", "NumericConstant", "UnaryOperation", "BinaryOperation", "Countable", "FunctionCall", "Lcom/unciv/models/ruleset/unique/expressions/Node$BinaryOperation;", "Lcom/unciv/models/ruleset/unique/expressions/Node$Constant;", "Lcom/unciv/models/ruleset/unique/expressions/Node$Countable;", "Lcom/unciv/models/ruleset/unique/expressions/Node$FunctionCall;", "Lcom/unciv/models/ruleset/unique/expressions/Node$UnaryOperation;", "core"})
public interface Node {
    @Readonly
    public double eval(@NotNull GameContext var1);

    @Readonly
    @NotNull
    public List<String> getErrors(@NotNull Ruleset var1);

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\n\u0010\f\u001a\u00020\rH\u0096\u0080\u0004J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/unciv/models/ruleset/unique/expressions/Node$BinaryOperation;", "Lcom/unciv/models/ruleset/unique/expressions/Node;", "operator", "Lcom/unciv/models/ruleset/unique/expressions/Operator$Binary;", "left", "right", "<init>", "(Lcom/unciv/models/ruleset/unique/expressions/Operator$Binary;Lcom/unciv/models/ruleset/unique/expressions/Node;Lcom/unciv/models/ruleset/unique/expressions/Node;)V", "eval", "", "context", "Lcom/unciv/models/ruleset/unique/GameContext;", "toString", "", "getErrors", "", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "core"})
    public static final class BinaryOperation
    implements Node {
        @NotNull
        private final Operator.Binary operator;
        @NotNull
        private final Node left;
        @NotNull
        private final Node right;

        public BinaryOperation(@NotNull Operator.Binary operator, @NotNull Node left, @NotNull Node right) {
            Intrinsics.checkNotNullParameter(operator, "operator");
            Intrinsics.checkNotNullParameter(left, "left");
            Intrinsics.checkNotNullParameter(right, "right");
            this.operator = operator;
            this.left = left;
            this.right = right;
        }

        @Override
        public double eval(@NotNull GameContext context) {
            Intrinsics.checkNotNullParameter(context, "context");
            return ((Number)this.operator.getImplementation().invoke(this.left.eval(context), this.right.eval(context))).doubleValue();
        }

        @NotNull
        public String toString() {
            return "" + '(' + this.left + ' ' + this.operator + ' ' + this.right + ')';
        }

        @Override
        @NotNull
        public List<String> getErrors(@NotNull Ruleset ruleset) {
            Intrinsics.checkNotNullParameter(ruleset, "ruleset");
            List<String> leftErrors = this.left.getErrors(ruleset);
            List<String> rightErrors = this.right.getErrors(ruleset);
            return CollectionsKt.plus((Collection)leftErrors, (Iterable)rightErrors);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u00012\u00020\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f\u00c0\u0006\u0003"}, d2={"Lcom/unciv/models/ruleset/unique/expressions/Node$Constant;", "Lcom/unciv/models/ruleset/unique/expressions/Node;", "Lcom/unciv/models/ruleset/unique/expressions/Tokenizer$Token;", "value", "", "getValue", "()D", "eval", "context", "Lcom/unciv/models/ruleset/unique/GameContext;", "getErrors", "", "", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "core"})
    public static interface Constant
    extends Node,
    Tokenizer.Token {
        public double getValue();

        @Override
        default public double eval(@NotNull GameContext context) {
            Intrinsics.checkNotNullParameter(context, "context");
            return this.getValue();
        }

        @Override
        @NotNull
        default public List<String> getErrors(@NotNull Ruleset ruleset) {
            Intrinsics.checkNotNullParameter(ruleset, "ruleset");
            return CollectionsKt.emptyList();
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            @Deprecated
            public static double eval(@NotNull Constant $this, @NotNull GameContext context) {
                Intrinsics.checkNotNullParameter(context, "context");
                return $this.eval(context);
            }

            @Deprecated
            @NotNull
            public static List<String> getErrors(@NotNull Constant $this, @NotNull Ruleset ruleset) {
                Intrinsics.checkNotNullParameter(ruleset, "ruleset");
                return $this.getErrors(ruleset);
            }

            @Pure
            @Deprecated
            public static boolean canBeUnary(@NotNull Constant $this) {
                return $this.canBeUnary();
            }

            @Pure
            @Deprecated
            public static boolean canBeBinary(@NotNull Constant $this) {
                return $this.canBeBinary();
            }

            @Pure
            @Deprecated
            @NotNull
            public static Operator.Unary fetchUnaryOperator(@NotNull Constant $this) {
                return $this.fetchUnaryOperator();
            }

            @Pure
            @Deprecated
            @NotNull
            public static Operator.Binary fetchBinaryOperator(@NotNull Constant $this) {
                return $this.fetchBinaryOperator();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0003J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\n\u0010\u0012\u001a\u00020\u0004H\u0096\u0080\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/unciv/models/ruleset/unique/expressions/Node$Countable;", "Lcom/unciv/models/ruleset/unique/expressions/Node;", "Lcom/unciv/models/ruleset/unique/expressions/Tokenizer$Token;", "parameterText", "", "rulesetInvariantCountable", "Lcom/unciv/models/ruleset/unique/Countables;", "<init>", "(Ljava/lang/String;Lcom/unciv/models/ruleset/unique/Countables;)V", "eval", "", "context", "Lcom/unciv/models/ruleset/unique/GameContext;", "getCountable", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "getErrors", "", "toString", "core"})
    public static final class Countable
    implements Node,
    Tokenizer.Token {
        @NotNull
        private final String parameterText;
        @Nullable
        private final Countables rulesetInvariantCountable;

        public Countable(@NotNull String parameterText, @Nullable Countables rulesetInvariantCountable) {
            Intrinsics.checkNotNullParameter(parameterText, "parameterText");
            this.parameterText = parameterText;
            this.rulesetInvariantCountable = rulesetInvariantCountable;
        }

        @Override
        public double eval(@NotNull GameContext context) {
            Intrinsics.checkNotNullParameter(context, "context");
            Object object = context.getGameInfo();
            if (object == null || (object = ((GameInfo)object).getRuleset()) == null) {
                return 0.0;
            }
            Object ruleset = object;
            Countables countables = this.getCountable((Ruleset)ruleset);
            if (countables == null) {
                return 0.0;
            }
            Countables countable = countables;
            Integer n = countable.eval(this.parameterText, context);
            return n != null ? (double)n.intValue() : 0.0;
        }

        @Readonly
        private final Countables getCountable(Ruleset ruleset) {
            Countables countables = this.rulesetInvariantCountable;
            if (countables == null) {
                countables = Countables.Companion.getMatching(this.parameterText, ruleset);
            }
            return countables;
        }

        @Override
        @Readonly
        @NotNull
        public List<String> getErrors(@NotNull Ruleset ruleset) {
            Intrinsics.checkNotNullParameter(ruleset, "ruleset");
            if (this.getCountable(ruleset) == null) {
                return CollectionsKt.listOf("Unknown countable: " + this.parameterText);
            }
            return CollectionsKt.emptyList();
        }

        @NotNull
        public String toString() {
            return "[Countable: " + this.parameterText + ']';
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\n\u0010\u0010\u001a\u00020\rH\u0096\u0080\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/unciv/models/ruleset/unique/expressions/Node$FunctionCall;", "Lcom/unciv/models/ruleset/unique/expressions/Node;", "function", "Lcom/unciv/models/ruleset/unique/expressions/Operator$Function;", "arguments", "", "<init>", "(Lcom/unciv/models/ruleset/unique/expressions/Operator$Function;Ljava/util/List;)V", "eval", "", "context", "Lcom/unciv/models/ruleset/unique/GameContext;", "getErrors", "", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "toString", "core"})
    @SourceDebugExtension(value={"SMAP\nNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Node.kt\ncom/unciv/models/ruleset/unique/expressions/Node$FunctionCall\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n1586#2:86\n1661#2,3:87\n1391#2:90\n1480#2,5:91\n*S KotlinDebug\n*F\n+ 1 Node.kt\ncom/unciv/models/ruleset/unique/expressions/Node$FunctionCall\n*L\n73#1:86\n73#1:87,3\n79#1:90\n79#1:91,5\n*E\n"})
    public static final class FunctionCall
    implements Node {
        @NotNull
        private final Operator.Function function;
        @NotNull
        private final List<Node> arguments;

        public FunctionCall(@NotNull Operator.Function function, @NotNull List<? extends Node> arguments) {
            Intrinsics.checkNotNullParameter(function, "function");
            Intrinsics.checkNotNullParameter(arguments, "arguments");
            this.function = function;
            this.arguments = arguments;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public double eval(@NotNull GameContext context) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(context, "context");
            Iterable $this$map$iv = this.arguments;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Node node = (Node)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.eval(context));
            }
            List evaluatedArgs = (List)destination$iv$iv;
            return ((Number)this.function.getImplementation().invoke(evaluatedArgs)).doubleValue();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Readonly
        @NotNull
        public List<String> getErrors(@NotNull Ruleset ruleset) {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter(ruleset, "ruleset");
            Iterable $this$flatMap$iv = this.arguments;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Node it = (Node)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getErrors(ruleset);
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public String toString() {
            return "[FunctionCall: " + this.function.getSymbol() + '(' + CollectionsKt.joinToString$default(this.arguments, ", ", null, null, 0, null, null, 62, null) + ")]";
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\b\u001a\u00020\tH\u0096\u0080\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/unciv/models/ruleset/unique/expressions/Node$NumericConstant;", "Lcom/unciv/models/ruleset/unique/expressions/Node$Constant;", "value", "", "<init>", "(D)V", "getValue", "()D", "toString", "", "core"})
    public static final class NumericConstant
    implements Constant {
        private final double value;

        public NumericConstant(double value) {
            this.value = value;
        }

        @Override
        public double getValue() {
            return this.value;
        }

        @NotNull
        public String toString() {
            return String.valueOf(this.getValue());
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\n\u0010\u000b\u001a\u00020\fH\u0096\u0080\u0004J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/unciv/models/ruleset/unique/expressions/Node$UnaryOperation;", "Lcom/unciv/models/ruleset/unique/expressions/Node;", "operator", "Lcom/unciv/models/ruleset/unique/expressions/Operator$Unary;", "operand", "<init>", "(Lcom/unciv/models/ruleset/unique/expressions/Operator$Unary;Lcom/unciv/models/ruleset/unique/expressions/Node;)V", "eval", "", "context", "Lcom/unciv/models/ruleset/unique/GameContext;", "toString", "", "getErrors", "", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "core"})
    public static final class UnaryOperation
    implements Node {
        @NotNull
        private final Operator.Unary operator;
        @NotNull
        private final Node operand;

        public UnaryOperation(@NotNull Operator.Unary operator, @NotNull Node operand) {
            Intrinsics.checkNotNullParameter(operator, "operator");
            Intrinsics.checkNotNullParameter(operand, "operand");
            this.operator = operator;
            this.operand = operand;
        }

        @Override
        public double eval(@NotNull GameContext context) {
            Intrinsics.checkNotNullParameter(context, "context");
            return ((Number)this.operator.getImplementation().invoke(this.operand.eval(context))).doubleValue();
        }

        @NotNull
        public String toString() {
            return "" + '(' + this.operator + ' ' + this.operand + ')';
        }

        @Override
        @NotNull
        public List<String> getErrors(@NotNull Ruleset ruleset) {
            Intrinsics.checkNotNullParameter(ruleset, "ruleset");
            return this.operand.getErrors(ruleset);
        }
    }
}

