/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.skins;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Json;
import com.unciv.UncivGame;
import com.unciv.json.UncivJsonKt;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.models.skins.SkinConfig;
import com.unciv.ui.images.ImageGetter;
import com.unciv.utils.LogKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u0004:\u0001\u0010B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0014\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fJ\u0010\u0010\r\u001a\u00020\n2\b\b\u0002\u0010\u000e\u001a\u00020\u000fR*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u0001j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0003`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/unciv/models/skins/SkinCache;", "Ljava/util/HashMap;", "", "Lcom/unciv/models/skins/SkinConfig;", "Lkotlin/collections/HashMap;", "<init>", "()V", "allConfigs", "Lcom/unciv/models/skins/SkinCache$SkinAndMod;", "assembleSkinConfigs", "", "ruleSetMods", "", "loadSkinConfigs", "consoleMode", "", "SkinAndMod", "core"})
@SourceDebugExtension(value={"SMAP\nSkinCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkinCache.kt\ncom/unciv/models/skins/SkinCache\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n540#2:94\n525#2,6:95\n1642#3,10:101\n1915#3:111\n1916#3:113\n1652#3:114\n1#4:112\n*S KotlinDebug\n*F\n+ 1 SkinCache.kt\ncom/unciv/models/skins/SkinCache\n*L\n32#1:94\n32#1:95,6\n68#1:101,10\n68#1:111\n68#1:113\n68#1:114\n68#1:112\n*E\n"})
public final class SkinCache
extends HashMap<String, SkinConfig> {
    @NotNull
    public static final SkinCache INSTANCE = new SkinCache();
    @NotNull
    private static final HashMap<SkinAndMod, SkinConfig> allConfigs = new HashMap();

    private SkinCache() {
    }

    /*
     * WARNING - void declaration
     */
    public final void assembleSkinConfigs(@NotNull Set<String> ruleSetMods) {
        Intrinsics.checkNotNullParameter(ruleSetMods, "ruleSetMods");
        String[] stringArray = new String[]{""};
        List<String> mods = CollectionsKt.mutableListOf(stringArray);
        if (UncivGame.Companion.isCurrentInitialized()) {
            mods.addAll((Collection<String>)UncivGame.Companion.getCurrent().getSettings().getVisualMods());
        }
        mods.addAll((Collection<String>)ruleSetMods);
        this.clear();
        for (String mod : CollectionsKt.distinct((Iterable)mods)) {
            void $this$filterTo$iv$iv;
            Map $this$filter$iv = allConfigs;
            boolean $i$f$filter = false;
            Map map2 = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator2.next();
                boolean bl = false;
                if (!Intrinsics.areEqual(((SkinAndMod)it.getKey()).getMod(), mod)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            for (Map.Entry entry : destination$iv$iv.entrySet()) {
                SkinAndMod key = (SkinAndMod)entry.getKey();
                SkinConfig config2 = (SkinConfig)entry.getValue();
                String skin = key.getSkin();
                if (((Map)this).containsKey(skin)) {
                    Object object = this.get((Object)skin);
                    Intrinsics.checkNotNull(object);
                    ((SkinConfig)object).updateConfig(config2);
                    continue;
                }
                ((Map)this).put(skin, config2.clone());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void loadSkinConfigs(boolean consoleMode) {
        List list2;
        Object[] objectArray;
        Sequence<Object> sequence;
        allConfigs.clear();
        String skinName = "";
        if (consoleMode) {
            FileHandle[] fileHandleArray = new FileHandle("jsons/Skins").list();
            Intrinsics.checkNotNullExpressionValue(fileHandleArray, "list(...)");
            sequence = ArraysKt.asSequence((Object[])fileHandleArray);
        } else {
            sequence = SequencesKt.filter(SequencesKt.map(ImageGetter.INSTANCE.getAvailableSkins(), SkinCache::loadSkinConfigs$lambda$0), SkinCache::loadSkinConfigs$lambda$1);
        }
        Sequence<FileHandle> fileHandles = sequence;
        Iterator<FileHandle> iterator2 = fileHandles.iterator();
        while (iterator2.hasNext()) {
            FileHandle configFile = iterator2.next();
            String string = configFile.nameWithoutExtension();
            Intrinsics.checkNotNullExpressionValue(string, "nameWithoutExtension(...)");
            skinName = StringsKt.removeSuffix(string, (CharSequence)"Config");
            try {
                boolean bl;
                SkinAndMod key = new SkinAndMod(skinName, "");
                boolean bl2 = bl = !((Map)allConfigs).containsKey(key);
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                ((Map)allConfigs).put(key, UncivJsonKt.fromJsonFile(UncivJsonKt.json(), SkinConfig.class, configFile));
                objectArray = new Object[]{configFile.name()};
                LogKt.debug("SkinConfig loaded successfully: %s", objectArray);
            }
            catch (Exception ex) {
                objectArray = new Object[]{configFile.path()};
                LogKt.debug("Exception loading SkinConfig '%s':", objectArray);
                objectArray = new Object[]{ex.getLocalizedMessage()};
                LogKt.debug("  %s", objectArray);
                objectArray = new Object[]{ex.getStackTrace()[0].getFileName(), ex.getStackTrace()[0].getLineNumber()};
                LogKt.debug("  (Source file %s line %s)", objectArray);
            }
        }
        if (consoleMode) {
            FileHandle[] fileHandleArray = new FileHandle("mods").list();
            Intrinsics.checkNotNullExpressionValue(fileHandleArray, "list(...)");
            list2 = ArraysKt.toList((Object[])fileHandleArray);
        } else {
            void $this$mapNotNullTo$iv$iv;
            Collection<Ruleset> collection = RulesetCache.INSTANCE.values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Object[] $this$mapNotNull$iv = (Object[])collection;
            boolean $i$f$mapNotNull = false;
            objectArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                FileHandle it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                boolean bl = false;
                Ruleset it = (Ruleset)element$iv$iv;
                boolean bl3 = false;
                if (it.getFolderLocation() == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        }
        List modsHandles = list2;
        for (FileHandle modFolder : modsHandles) {
            FileHandle[] fileHandleArray;
            String modName = modFolder.name();
            Intrinsics.checkNotNull(modName);
            if (StringsKt.startsWith$default((CharSequence)modName, '.', false, 2, null) || !modFolder.isDirectory()) continue;
            Intrinsics.checkNotNullExpressionValue(modFolder.child("jsons/Skins").list(), "list(...)");
            for (FileHandle configFile : fileHandleArray) {
                Object[] objectArray2;
                try {
                    boolean bl;
                    String string = configFile.nameWithoutExtension();
                    Intrinsics.checkNotNullExpressionValue(string, "nameWithoutExtension(...)");
                    skinName = StringsKt.removeSuffix(string, (CharSequence)"Config");
                    SkinAndMod key = new SkinAndMod(skinName, modName);
                    boolean bl5 = bl = !((Map)allConfigs).containsKey(key);
                    if (_Assertions.ENABLED && !bl) {
                        String string3 = "Assertion failed";
                        throw new AssertionError((Object)string3);
                    }
                    Map map2 = allConfigs;
                    Json json = UncivJsonKt.json();
                    Intrinsics.checkNotNull(configFile);
                    map2.put(key, UncivJsonKt.fromJsonFile(json, SkinConfig.class, configFile));
                    objectArray2 = new Object[]{configFile.path()};
                    LogKt.debug("Skin loaded successfully: %s", objectArray2);
                }
                catch (Exception ex) {
                    objectArray2 = new Object[]{modFolder.name(), skinName};
                    LogKt.debug("Exception loading Skin '%s/jsons/Skins/%s':", objectArray2);
                    objectArray2 = new Object[]{ex.getLocalizedMessage()};
                    LogKt.debug("  %s", objectArray2);
                    objectArray2 = new Object[]{ex.getStackTrace()[0].getFileName(), ex.getStackTrace()[0].getLineNumber()};
                    LogKt.debug("  (Source file %s line %s)", objectArray2);
                }
            }
        }
        this.assembleSkinConfigs(SetsKt.emptySet());
    }

    public static /* synthetic */ void loadSkinConfigs$default(SkinCache skinCache, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        skinCache.loadSkinConfigs(bl);
    }

    private static final FileHandle loadSkinConfigs$lambda$0(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Gdx.files.internal("jsons/Skins/" + it + ".json");
    }

    private static final boolean loadSkinConfigs$lambda$1(FileHandle it) {
        return it.exists();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004J\n\u0010\u0012\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/unciv/models/skins/SkinCache$SkinAndMod;", "", "skin", "", "mod", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getSkin", "()Ljava/lang/String;", "getMod", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "core"})
    private static final class SkinAndMod {
        @NotNull
        private final String skin;
        @NotNull
        private final String mod;

        public SkinAndMod(@NotNull String skin, @NotNull String mod) {
            Intrinsics.checkNotNullParameter(skin, "skin");
            Intrinsics.checkNotNullParameter(mod, "mod");
            this.skin = skin;
            this.mod = mod;
        }

        @NotNull
        public final String getSkin() {
            return this.skin;
        }

        @NotNull
        public final String getMod() {
            return this.mod;
        }

        @NotNull
        public final String component1() {
            return this.skin;
        }

        @NotNull
        public final String component2() {
            return this.mod;
        }

        @NotNull
        public final SkinAndMod copy(@NotNull String skin, @NotNull String mod) {
            Intrinsics.checkNotNullParameter(skin, "skin");
            Intrinsics.checkNotNullParameter(mod, "mod");
            return new SkinAndMod(skin, mod);
        }

        public static /* synthetic */ SkinAndMod copy$default(SkinAndMod skinAndMod, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = skinAndMod.skin;
            }
            if ((n & 2) != 0) {
                string2 = skinAndMod.mod;
            }
            return skinAndMod.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "SkinAndMod(skin=" + this.skin + ", mod=" + this.mod + ')';
        }

        public int hashCode() {
            int result2 = this.skin.hashCode();
            result2 = result2 * 31 + this.mod.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SkinAndMod)) {
                return false;
            }
            SkinAndMod skinAndMod = (SkinAndMod)other;
            if (!Intrinsics.areEqual(this.skin, skinAndMod.skin)) {
                return false;
            }
            return Intrinsics.areEqual(this.mod, skinAndMod.mod);
        }
    }
}

