/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.skins;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.utils.NinePatchDrawable;
import com.unciv.UncivGame;
import com.unciv.models.skins.SkinCache;
import com.unciv.models.skins.SkinConfig;
import com.unciv.ui.images.ImageGetter;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00032\n\b\u0002\u0010'\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)J\u001a\u0010*\u001a\u00020)2\u0006\u0010&\u001a\u00020\u00032\n\b\u0002\u0010'\u001a\u0004\u0018\u00010)J\u0010\u0010+\u001a\u0004\u0018\u00010)2\u0006\u0010&\u001a\u00020\u0003J\u0010\u0010,\u001a\u0004\u0018\u00010)2\u0006\u0010&\u001a\u00020\u0003R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0014\u0010\u0014\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR\u0014\u0010\u0016\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000fR\u0014\u0010\u0018\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000fR\u0014\u0010\u001a\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000fR\u0014\u0010\u001c\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u000fR\u0014\u0010\u001e\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u000fR\u0014\u0010 \u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u000fR\u0014\u0010\"\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u000f\u00a8\u0006-"}, d2={"Lcom/unciv/models/skins/SkinStrings;", "", "skin", "", "<init>", "(Ljava/lang/String;)V", "skinLocation", "skinConfig", "Lcom/unciv/models/skins/SkinConfig;", "getSkinConfig", "()Lcom/unciv/models/skins/SkinConfig;", "fallbackSkinLocation", "fallbackSkinConfig", "roundedEdgeRectangleSmallShape", "getRoundedEdgeRectangleSmallShape", "()Ljava/lang/String;", "roundedTopEdgeRectangleSmallShape", "getRoundedTopEdgeRectangleSmallShape", "roundedTopEdgeRectangleSmallBorderShape", "getRoundedTopEdgeRectangleSmallBorderShape", "roundedEdgeRectangleMidShape", "getRoundedEdgeRectangleMidShape", "roundedEdgeRectangleMidBorderShape", "getRoundedEdgeRectangleMidBorderShape", "roundedEdgeRectangleShape", "getRoundedEdgeRectangleShape", "rectangleWithOutlineShape", "getRectangleWithOutlineShape", "selectBoxShape", "getSelectBoxShape", "selectBoxPressedShape", "getSelectBoxPressedShape", "checkboxShape", "getCheckboxShape", "checkboxPressedShape", "getCheckboxPressedShape", "getUiBackground", "Lcom/badlogic/gdx/scenes/scene2d/utils/NinePatchDrawable;", "path", "default", "tintColor", "Lcom/badlogic/gdx/graphics/Color;", "getUIColor", "getUIFontColor", "getUIIconColor", "core"})
@SourceDebugExtension(value={"SMAP\nSkinStrings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkinStrings.kt\ncom/unciv/models/skins/SkinStrings\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1#2:113\n*E\n"})
public final class SkinStrings {
    @NotNull
    private final String skinLocation;
    @NotNull
    private final SkinConfig skinConfig;
    @Nullable
    private final String fallbackSkinLocation;
    @Nullable
    private final SkinConfig fallbackSkinConfig;
    @NotNull
    private final String roundedEdgeRectangleSmallShape;
    @NotNull
    private final String roundedTopEdgeRectangleSmallShape;
    @NotNull
    private final String roundedTopEdgeRectangleSmallBorderShape;
    @NotNull
    private final String roundedEdgeRectangleMidShape;
    @NotNull
    private final String roundedEdgeRectangleMidBorderShape;
    @NotNull
    private final String roundedEdgeRectangleShape;
    @NotNull
    private final String rectangleWithOutlineShape;
    @NotNull
    private final String selectBoxShape;
    @NotNull
    private final String selectBoxPressedShape;
    @NotNull
    private final String checkboxShape;
    @NotNull
    private final String checkboxPressedShape;

    public SkinStrings(@NotNull String skin) {
        Intrinsics.checkNotNullParameter(skin, "skin");
        this.skinLocation = "Skins/" + skin + '/';
        SkinConfig skinConfig = (SkinConfig)SkinCache.INSTANCE.get((Object)skin);
        if (skinConfig == null) {
            skinConfig = new SkinConfig();
        }
        this.skinConfig = skinConfig;
        this.fallbackSkinLocation = this.skinConfig.getFallbackSkin() != null ? "Skins/" + this.skinConfig.getFallbackSkin() + '/' : null;
        this.fallbackSkinConfig = (SkinConfig)((Map)SkinCache.INSTANCE).get(this.skinConfig.getFallbackSkin());
        this.roundedEdgeRectangleSmallShape = "roundedEdgeRectangle-small";
        this.roundedTopEdgeRectangleSmallShape = "roundedTopEdgeRectangle-small";
        this.roundedTopEdgeRectangleSmallBorderShape = "roundedTopEdgeRectangle-small-border";
        this.roundedEdgeRectangleMidShape = "roundedEdgeRectangle-mid";
        this.roundedEdgeRectangleMidBorderShape = "roundedEdgeRectangle-mid-border";
        this.roundedEdgeRectangleShape = "roundedEdgeRectangle";
        this.rectangleWithOutlineShape = "rectangleWithOutline";
        this.selectBoxShape = "select-box";
        this.selectBoxPressedShape = "select-box-pressed";
        this.checkboxShape = "checkbox";
        this.checkboxPressedShape = "checkbox-pressed";
    }

    public /* synthetic */ SkinStrings(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = UncivGame.Companion.getCurrent().getSettings().getSkin();
        }
        this(string);
    }

    @NotNull
    public final SkinConfig getSkinConfig() {
        return this.skinConfig;
    }

    @NotNull
    public final String getRoundedEdgeRectangleSmallShape() {
        return this.roundedEdgeRectangleSmallShape;
    }

    @NotNull
    public final String getRoundedTopEdgeRectangleSmallShape() {
        return this.roundedTopEdgeRectangleSmallShape;
    }

    @NotNull
    public final String getRoundedTopEdgeRectangleSmallBorderShape() {
        return this.roundedTopEdgeRectangleSmallBorderShape;
    }

    @NotNull
    public final String getRoundedEdgeRectangleMidShape() {
        return this.roundedEdgeRectangleMidShape;
    }

    @NotNull
    public final String getRoundedEdgeRectangleMidBorderShape() {
        return this.roundedEdgeRectangleMidBorderShape;
    }

    @NotNull
    public final String getRoundedEdgeRectangleShape() {
        return this.roundedEdgeRectangleShape;
    }

    @NotNull
    public final String getRectangleWithOutlineShape() {
        return this.rectangleWithOutlineShape;
    }

    @NotNull
    public final String getSelectBoxShape() {
        return this.selectBoxShape;
    }

    @NotNull
    public final String getSelectBoxPressedShape() {
        return this.selectBoxPressedShape;
    }

    @NotNull
    public final String getCheckboxShape() {
        return this.checkboxShape;
    }

    @NotNull
    public final String getCheckboxPressedShape() {
        return this.checkboxPressedShape;
    }

    @NotNull
    public final NinePatchDrawable getUiBackground(@NotNull String path, @Nullable String string, @Nullable Color tintColor) {
        Object object;
        SkinConfig.SkinElement fallbackSkinVariant;
        String location;
        Object object2;
        SkinConfig.SkinElement skinVariant;
        Intrinsics.checkNotNullParameter(path, "path");
        String locationForDefault = this.skinLocation + string;
        String locationByName = this.skinLocation + path;
        SkinConfig.SkinElement skinElement = skinVariant = this.skinConfig.getSkinVariants().get(path);
        String locationByConfigVariant = (skinElement != null ? skinElement.getImage() : null) != null ? this.skinLocation + skinVariant.getImage() : null;
        Object object3 = skinVariant;
        if ((object3 == null || (object3 = ((SkinConfig.SkinElement)object3).getTint()) == null) && (object3 = this.skinConfig.getDefaultVariantTint()) == null) {
            object3 = tintColor;
        }
        if (object3 != null) {
            Object $this$getUiBackground_u24lambda_u240 = object3;
            boolean bl = false;
            SkinConfig.SkinElement skinElement2 = skinVariant;
            if ((skinElement2 != null ? skinElement2.getAlpha() : null) == null) {
                object2 = $this$getUiBackground_u24lambda_u240;
            } else {
                Color color;
                Color $this$getUiBackground_u24lambda_u240_u240 = color = ((Color)$this$getUiBackground_u24lambda_u240).cpy();
                boolean bl2 = false;
                $this$getUiBackground_u24lambda_u240_u240.a = skinVariant.getAlpha().floatValue();
                object2 = color;
            }
        } else {
            object2 = null;
        }
        Object tint = object2;
        String string2 = locationByConfigVariant != null && ImageGetter.INSTANCE.ninePatchImageExists(locationByConfigVariant) ? locationByConfigVariant : (ImageGetter.INSTANCE.ninePatchImageExists(locationByName) ? locationByName : (location = string != null && ImageGetter.INSTANCE.ninePatchImageExists(locationForDefault) ? locationForDefault : null));
        if (location != null) {
            return ImageGetter.INSTANCE.getNinePatch(location, (Color)tint);
        }
        String fallbackLocationForDefault = this.fallbackSkinLocation + string;
        String fallbackLocationByName = this.fallbackSkinLocation + path;
        Object object4 = this.fallbackSkinConfig;
        SkinConfig.SkinElement skinElement3 = fallbackSkinVariant = object4 != null && (object4 = ((SkinConfig)object4).getSkinVariants()) != null ? (SkinConfig.SkinElement)((HashMap)object4).get(path) : null;
        String fallbackLocationByConfigVariant = (skinElement3 != null ? skinElement3.getImage() : null) != null ? this.fallbackSkinLocation + fallbackSkinVariant.getImage() : null;
        Object object5 = fallbackSkinVariant;
        if (object5 == null || (object5 = ((SkinConfig.SkinElement)object5).getTint()) == null) {
            object5 = tintColor;
        }
        if (object5 != null) {
            Object $this$getUiBackground_u24lambda_u241 = object5;
            boolean bl = false;
            SkinConfig.SkinElement skinElement4 = fallbackSkinVariant;
            if ((skinElement4 != null ? skinElement4.getAlpha() : null) == null) {
                object = $this$getUiBackground_u24lambda_u241;
            } else {
                Color color;
                Color $this$getUiBackground_u24lambda_u241_u240 = color = ((Color)$this$getUiBackground_u24lambda_u241).cpy();
                boolean bl3 = false;
                $this$getUiBackground_u24lambda_u241_u240.a = fallbackSkinVariant.getAlpha().floatValue();
                object = color;
            }
        } else {
            object = null;
        }
        Object fallbackTint = object;
        String fallbackLocation = fallbackLocationByConfigVariant != null && ImageGetter.INSTANCE.ninePatchImageExists(fallbackLocationByConfigVariant) ? fallbackLocationByConfigVariant : (ImageGetter.INSTANCE.ninePatchImageExists(fallbackLocationByName) ? fallbackLocationByName : (string != null && ImageGetter.INSTANCE.ninePatchImageExists(fallbackLocationForDefault) ? fallbackLocationForDefault : null));
        return ImageGetter.INSTANCE.getNinePatch(fallbackLocation, (Color)fallbackTint);
    }

    public static /* synthetic */ NinePatchDrawable getUiBackground$default(SkinStrings skinStrings, String string, String string2, Color color, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            color = null;
        }
        return skinStrings.getUiBackground(string, string2, color);
    }

    @NotNull
    public final Color getUIColor(@NotNull String path, @Nullable Color color) {
        Intrinsics.checkNotNullParameter(path, "path");
        Object object = this.skinConfig.getSkinVariants().get(path);
        if ((object == null || (object = ((SkinConfig.SkinElement)object).getTint()) == null) && (object = color) == null) {
            object = this.skinConfig.getClearColor();
        }
        return object;
    }

    public static /* synthetic */ Color getUIColor$default(SkinStrings skinStrings, String string, Color color, int n, Object object) {
        if ((n & 2) != 0) {
            color = null;
        }
        return skinStrings.getUIColor(string, color);
    }

    @Nullable
    public final Color getUIFontColor(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        SkinConfig.SkinElement skinElement = this.skinConfig.getSkinVariants().get(path);
        return skinElement != null ? skinElement.getForegroundColor() : null;
    }

    @Nullable
    public final Color getUIIconColor(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        Object object = this.skinConfig.getSkinVariants().get(path);
        if (object == null || (object = ((SkinConfig.SkinElement)object).getIconColor()) == null) {
            SkinConfig.SkinElement skinElement = this.skinConfig.getSkinVariants().get(path);
            object = skinElement != null ? skinElement.getForegroundColor() : null;
        }
        return object;
    }

    public SkinStrings() {
        this(null, 1, null);
    }
}

