/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.audio;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.files.FileHandle;
import com.unciv.ui.audio.MusicController;
import com.unciv.utils.Log;
import com.unciv.utils.LogKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001*B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0012\u001a\u00020\u0013J>\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0016\b\u0002\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00182\u0016\b\u0002\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0018J\u0006\u0010\u001a\u001a\u00020\bJ\u0018\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\b2\b\b\u0002\u0010\u001d\u001a\u00020\u0003J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u001fJ\u0006\u0010!\u001a\u00020\u001fJ\u000e\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u0003J\b\u0010$\u001a\u00020\u0013H\u0002J\b\u0010%\u001a\u00020\u0013H\u0002J\u0010\u0010&\u001a\u00020\u001f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u0010\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020)H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\"\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u0007\u001a\u0004\u0018\u00010\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/unciv/ui/audio/MusicTrackController;", "", "volume", "", "initialFadeVolume", "<init>", "(FF)V", "value", "Lcom/unciv/ui/audio/MusicTrackController$State;", "state", "getState", "()Lcom/unciv/ui/audio/MusicTrackController$State;", "Lcom/badlogic/gdx/audio/Music;", "music", "getMusic", "()Lcom/badlogic/gdx/audio/Music;", "fadeStep", "fadeVolume", "clear", "", "load", "file", "Lcom/badlogic/gdx/files/FileHandle;", "onError", "Lkotlin/Function1;", "onSuccess", "timerTick", "startFade", "fade", "step", "shutdownTick", "", "isPlaying", "play", "setVolume", "newVolume", "fadeInStep", "fadeOutStep", "tryPlay", "audioExceptionHandler", "ex", "", "State", "core"})
public final class MusicTrackController {
    private float volume;
    @NotNull
    private State state;
    @Nullable
    private Music music;
    private float fadeStep;
    private float fadeVolume;

    public MusicTrackController(float volume, float initialFadeVolume) {
        this.volume = volume;
        this.state = State.None;
        this.fadeStep = MusicController.Companion.getDefaultFadingStep$core();
        this.fadeVolume = initialFadeVolume;
    }

    public /* synthetic */ MusicTrackController(float f, float f2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            f2 = 1.0f;
        }
        this(f, f2);
    }

    @NotNull
    public final State getState() {
        return this.state;
    }

    @Nullable
    public final Music getMusic() {
        return this.music;
    }

    public final void clear() {
        this.state = State.None;
        if (this.music == null) {
            return;
        }
        Music music = this.music;
        Intrinsics.checkNotNull(music);
        music.dispose();
        this.music = null;
    }

    public final void load(@NotNull FileHandle file, @Nullable Function1<? super MusicTrackController, Unit> onError, @Nullable Function1<? super MusicTrackController, Unit> onSuccess) {
        block4: {
            Intrinsics.checkNotNullParameter(file, "file");
            if (!(this.state == State.None && this.music == null)) {
                boolean $i$a$-check-MusicTrackController$load$22 = false;
                String $i$a$-check-MusicTrackController$load$22 = "MusicTrackController.load should only be called once";
                throw new IllegalStateException($i$a$-check-MusicTrackController$load$22.toString());
            }
            this.state = State.Loading;
            try {
                this.music = Gdx.audio.newMusic(file);
                if (this.state != State.Loading) {
                    this.clear();
                    break block4;
                }
                this.state = State.Idle;
                Object[] objectArray = new Object[]{file};
                LogKt.debug("Music loaded %s", objectArray);
                Function1<? super MusicTrackController, Unit> function1 = onSuccess;
                if (function1 == null) break block4;
                function1.invoke(this);
            }
            catch (Exception ex) {
                this.audioExceptionHandler(ex);
                this.state = State.Error;
                Function1<? super MusicTrackController, Unit> function1 = onError;
                if (function1 == null) break block4;
                function1.invoke(this);
            }
        }
    }

    public static /* synthetic */ void load$default(MusicTrackController musicTrackController, FileHandle fileHandle, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        if ((n & 4) != 0) {
            function12 = null;
        }
        musicTrackController.load(fileHandle, function1, function12);
    }

    @NotNull
    public final State timerTick() {
        if (this.state == State.FadeIn) {
            this.fadeInStep();
        }
        if (this.state == State.FadeOut) {
            this.fadeOutStep();
        }
        return this.state;
    }

    public final void startFade(@NotNull State fade, float step) {
        Intrinsics.checkNotNullParameter((Object)fade, "fade");
        if (!this.state.getCanPlay()) {
            return;
        }
        if (step > 0.0f) {
            this.fadeStep = step;
        }
        this.state = fade;
    }

    public static /* synthetic */ void startFade$default(MusicTrackController musicTrackController, State state, float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = 0.0f;
        }
        musicTrackController.startFade(state, f);
    }

    public final boolean shutdownTick() {
        if (!this.state.getCanPlay()) {
            this.state = State.Idle;
        }
        if (this.state == State.Idle) {
            return true;
        }
        if (this.state != State.FadeOut) {
            this.state = State.FadeOut;
            this.fadeStep = MusicController.Companion.getDefaultFadingStep$core();
        }
        return this.timerTick() == State.Idle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isPlaying() {
        if (!this.state.getCanPlay()) return false;
        Music music = this.music;
        if (music == null) return false;
        if (!music.isPlaying()) return false;
        return true;
    }

    public final boolean play() {
        if (!this.state.getCanPlay() || this.music == null) {
            this.clear();
            return false;
        }
        Music music = this.music;
        Intrinsics.checkNotNull(music);
        if (this.tryPlay(music)) {
            return true;
        }
        this.state = State.Error;
        return false;
    }

    public final void setVolume(float newVolume) {
        block0: {
            this.volume = newVolume;
            Music music = this.music;
            if (music == null) break block0;
            music.setVolume(this.volume * this.fadeVolume);
        }
    }

    private final void fadeInStep() {
        this.fadeVolume += this.fadeStep;
        if (this.fadeVolume < 1.0f && this.music != null) {
            Music music = this.music;
            Intrinsics.checkNotNull(music);
            if (music.isPlaying()) {
                Music music2 = this.music;
                Intrinsics.checkNotNull(music2);
                music2.setVolume(this.volume * this.fadeVolume);
                return;
            }
        }
        Music music = this.music;
        Intrinsics.checkNotNull(music);
        music.setVolume(this.volume);
        this.fadeVolume = 1.0f;
        this.state = State.Playing;
    }

    private final void fadeOutStep() {
        this.fadeVolume -= this.fadeStep;
        try {
            if (this.fadeVolume >= 0.001f && this.music != null) {
                Music music = this.music;
                Intrinsics.checkNotNull(music);
                if (music.isPlaying()) {
                    Music music2 = this.music;
                    Intrinsics.checkNotNull(music2);
                    music2.setVolume(this.volume * this.fadeVolume);
                    return;
                }
            }
            this.fadeVolume = 0.0f;
            Music music = this.music;
            Intrinsics.checkNotNull(music);
            music.setVolume(0.0f);
            Music music3 = this.music;
            Intrinsics.checkNotNull(music3);
            music3.pause();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.state = State.Idle;
    }

    private final boolean tryPlay(Music music) {
        boolean bl;
        try {
            music.setVolume(this.volume * this.fadeVolume);
            if (!music.isPlaying()) {
                music.play();
            }
            bl = true;
        }
        catch (Throwable ex) {
            this.audioExceptionHandler(ex);
            bl = false;
        }
        return bl;
    }

    private final void audioExceptionHandler(Throwable ex) {
        this.clear();
        Log.INSTANCE.error("Error playing music", ex);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lcom/unciv/ui/audio/MusicTrackController$State;", "", "canPlay", "", "<init>", "(Ljava/lang/String;IZ)V", "getCanPlay", "()Z", "None", "Loading", "Idle", "FadeIn", "Playing", "FadeOut", "Error", "core"})
    public static final class State
    extends Enum<State> {
        private final boolean canPlay;
        public static final /* enum */ State None = new State(false);
        public static final /* enum */ State Loading = new State(false);
        public static final /* enum */ State Idle = new State(true);
        public static final /* enum */ State FadeIn = new State(true);
        public static final /* enum */ State Playing = new State(true);
        public static final /* enum */ State FadeOut = new State(true);
        public static final /* enum */ State Error = new State(false);
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private State(boolean canPlay) {
            this.canPlay = canPlay;
        }

        public final boolean getCanPlay() {
            return this.canPlay;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.None, State.Loading, State.Idle, State.FadeIn, State.Playing, State.FadeOut, State.Error};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

