/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components;

import com.badlogic.gdx.graphics.g2d.ParticleEmitter;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.unciv.ui.components.ParticleEffectAnimation;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b&\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\f\u0010\u0006\u001a\u00020\u0005*\u00020\u0007H\u0014J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0014\u00a8\u0006\f"}, d2={"Lcom/unciv/ui/components/ParticleEffectFireworks;", "Lcom/unciv/ui/components/ParticleEffectAnimation;", "<init>", "()V", "load", "", "configure", "Lcom/unciv/ui/components/ParticleEffectAnimation$ParticleEffectData;", "onComplete", "", "effectData", "Companion", "core"})
public abstract class ParticleEffectFireworks
extends ParticleEffectAnimation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String effectsFile = "effects/fireworks.p";
    @NotNull
    private static final Vector2[] initialEndPoints;
    @NotNull
    private static final Vector2 startPoint;
    private static final float amplitudeX = 1.0f;
    private static final float offsetX = 0.0f;
    private static final float amplitudeY = 1.0f;
    private static final float offsetY = 0.5f;
    private static final float travelTime = 0.6f;
    private static final float initialDelay = 0.6f;
    private static final float amplitudeDelay = 0.25f;
    private static final int minEffects = 3;
    private static final int maxEffects = 5;

    public final void load() {
        this.load(effectsFile, "ConstructionIcons", initialEndPoints.length);
    }

    @Override
    protected void configure(@NotNull ParticleEffectAnimation.ParticleEffectData $this$configure) {
        Intrinsics.checkNotNullParameter($this$configure, "<this>");
        $this$configure.setStartPoint(startPoint);
        int n = initialEndPoints.length;
        int n2 = $this$configure.getIndex();
        $this$configure.setEndPoint((0 <= n2 ? n2 < n : false) ? initialEndPoints[$this$configure.getIndex()] : new Vector2(0.0f + 1.0f * Random.Default.nextFloat(), 0.5f + 1.0f * Random.Default.nextFloat()));
        n = initialEndPoints.length;
        n2 = $this$configure.getIndex();
        $this$configure.setDelay((0 <= n2 ? n2 < n : false) ? (float)$this$configure.getIndex() * 0.6f : Random.Default.nextFloat() * 0.25f);
        $this$configure.setTravelTime(0.6f);
        Interpolation.PowOut powOut = Interpolation.fastSlow;
        Intrinsics.checkNotNullExpressionValue(powOut, "fastSlow");
        $this$configure.setInterpolation(powOut);
        int type = Random.Default.nextInt(-1, 5);
        if (type < 0) {
            this.removeEmitters($this$configure.getEffect(), ParticleEffectFireworks::configure$lambda$0);
        } else {
            Array<ParticleEmitter> array = $this$configure.getEffect().getEmitters();
            Intrinsics.checkNotNullExpressionValue(array, "getEmitters(...)");
            Set<String> names = SetsKt.plus(SequencesKt.toSet(SequencesKt.take(SequencesKt.shuffled(SequencesKt.filter(SequencesKt.map(CollectionsKt.asSequence((Iterable)array), ParticleEffectFireworks::configure$lambda$1), ParticleEffectFireworks::configure$lambda$2)), type)), "rainbow");
            this.removeEmitters($this$configure.getEffect(), arg_0 -> ParticleEffectFireworks.configure$lambda$3(names, arg_0));
        }
        if (Random.Default.nextInt(4) > 0) {
            this.removeEmitters($this$configure.getEffect(), ParticleEffectFireworks::configure$lambda$4);
        }
    }

    @Override
    protected int onComplete(@NotNull ParticleEffectAnimation.ParticleEffectData effectData) {
        Intrinsics.checkNotNullParameter(effectData, "effectData");
        if (Random.Default.nextInt(4) > 0) {
            return 1;
        }
        if (this.activeCount() <= 3) {
            return Random.Default.nextInt(1, 3);
        }
        if (this.activeCount() >= 5) {
            return Random.Default.nextInt(0, 2);
        }
        return Random.Default.nextInt(0, 3);
    }

    private static final boolean configure$lambda$0(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return StringsKt.startsWith$default(it, "shower", false, 2, null);
    }

    private static final String configure$lambda$1(ParticleEmitter it) {
        return it.getName();
    }

    private static final boolean configure$lambda$2(String it) {
        Intrinsics.checkNotNull(it);
        return StringsKt.startsWith$default(it, "shower", false, 2, null);
    }

    private static final boolean configure$lambda$3(Set $names, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return $names.contains(it);
    }

    private static final boolean configure$lambda$4(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return StringsKt.startsWith$default(it, "dazzler", false, 2, null);
    }

    static {
        Vector2[] vector2Array = new Vector2[]{new Vector2(0.5f, 1.5f), new Vector2(0.2f, 1.0f), new Vector2(0.8f, 1.0f)};
        initialEndPoints = vector2Array;
        startPoint = new Vector2(0.5f, 0.0f);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/unciv/ui/components/ParticleEffectFireworks$Companion;", "", "<init>", "()V", "effectsFile", "", "initialEndPoints", "", "Lcom/badlogic/gdx/math/Vector2;", "[Lcom/badlogic/gdx/math/Vector2;", "startPoint", "amplitudeX", "", "offsetX", "amplitudeY", "offsetY", "travelTime", "initialDelay", "amplitudeDelay", "minEffects", "", "maxEffects", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

