/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.extensions;

import com.badlogic.gdx.math.Vector2;
import com.unciv.models.translations.TranslationsKt;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import yairm210.purity.annotations.Pure;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u0007\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0007\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0003H\u0007\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0001H\u0007\u001a&\u0010\u0004\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0003H\u0007\u001a\u001e\u0010\t\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u0003H\u0007\u001a\u0014\u0010\n\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0003H\u0007\u001a\f\u0010\u000b\u001a\u00020\u0002*\u00020\u0003H\u0007\u001a\n\u0010\f\u001a\u00020\u0002*\u00020\r\u001a\u0018\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f*\u00020\rH\u0002\u001a\n\u0010\u0012\u001a\u00020\u0002*\u00020\r\u001a\n\u0010\u0013\u001a\u00020\u0002*\u00020\u0014\u00a8\u0006\u0015"}, d2={"toPercent", "", "", "", "getConsumesAmountString", "amount", "isStockpiled", "", "available", "getCostsAmountString", "getNeedMoreAmountString", "toStringSigned", "format", "Ljava/time/Duration;", "toParts", "Ljava/util/SortedMap;", "Ljava/time/temporal/ChronoUnit;", "", "formatShort", "toPrettyString", "Lcom/badlogic/gdx/math/Vector2;", "core"})
public final class FormattingExtensionsKt {
    @Pure
    public static final float toPercent(@NotNull String $this$toPercent) {
        Intrinsics.checkNotNullParameter($this$toPercent, "<this>");
        return FormattingExtensionsKt.toPercent(Float.parseFloat($this$toPercent));
    }

    @Pure
    public static final float toPercent(int $this$toPercent) {
        return FormattingExtensionsKt.toPercent((float)$this$toPercent);
    }

    @Pure
    public static final float toPercent(float $this$toPercent) {
        return 1.0f + $this$toPercent / (float)100;
    }

    @Pure
    @NotNull
    public static final String getConsumesAmountString(@NotNull String $this$getConsumesAmountString, int amount, boolean isStockpiled, int available) {
        Intrinsics.checkNotNullParameter($this$getConsumesAmountString, "<this>");
        String uniqueString = "{Consumes [" + amount + "] [" + $this$getConsumesAmountString + "]}";
        String perTurnString = isStockpiled ? " /\u23f3" : "";
        String availableString = available >= 0 ? " ({[" + available + "] available})" : "";
        return uniqueString + perTurnString + availableString;
    }

    public static /* synthetic */ String getConsumesAmountString$default(String string, int n, boolean bl, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = -1;
        }
        return FormattingExtensionsKt.getConsumesAmountString(string, n, bl, n2);
    }

    @Pure
    @NotNull
    public static final String getCostsAmountString(@NotNull String $this$getCostsAmountString, int amount, int available) {
        Intrinsics.checkNotNullParameter($this$getCostsAmountString, "<this>");
        String uniqueString = "{Costs [" + amount + "] [" + $this$getCostsAmountString + "]}";
        String availableString = available >= 0 ? " ({[" + available + "] available})" : "";
        return uniqueString + availableString;
    }

    public static /* synthetic */ String getCostsAmountString$default(String string, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = -1;
        }
        return FormattingExtensionsKt.getCostsAmountString(string, n, n2);
    }

    @Pure
    @NotNull
    public static final String getNeedMoreAmountString(@NotNull String $this$getNeedMoreAmountString, int amount) {
        Intrinsics.checkNotNullParameter($this$getNeedMoreAmountString, "<this>");
        return "Need [" + amount + "] more [" + $this$getNeedMoreAmountString + ']';
    }

    @Readonly
    @NotNull
    public static final String toStringSigned(int $this$toStringSigned) {
        return $this$toStringSigned > 0 ? '+' + TranslationsKt.tr($this$toStringSigned) : TranslationsKt.tr($this$toStringSigned);
    }

    @NotNull
    public static final String format(@NotNull Duration $this$format) {
        Intrinsics.checkNotNullParameter($this$format, "<this>");
        StringBuilder sb = new StringBuilder();
        boolean firstPartAlreadyAdded = false;
        for (Map.Entry entry : ((Map)FormattingExtensionsKt.toParts($this$format)).entrySet()) {
            Long part;
            ChronoUnit unit = (ChronoUnit)entry.getKey();
            Long l = part = (Long)entry.getValue();
            long l2 = 0L;
            if (l != null && l == l2) continue;
            if (firstPartAlreadyAdded) {
                sb.append(", ");
            }
            StringBuilder stringBuilder = new StringBuilder().append('[');
            Intrinsics.checkNotNull(part);
            sb.append(stringBuilder.append(TranslationsKt.tr(part)).append("] ").append(unit).toString());
            firstPartAlreadyAdded = true;
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    private static final SortedMap<ChronoUnit, Long> toParts(Duration $this$toParts) {
        Map<ChronoUnit, Long> map2;
        Map<ChronoUnit, Long> $this$toParts_u24lambda_u240 = map2 = MapsKt.createMapBuilder();
        boolean bl = false;
        long secondsPart = $this$toParts.getSeconds() % (long)60;
        long minutePart = $this$toParts.toMinutes() % (long)60;
        long hourPart = $this$toParts.toHours() % (long)24;
        $this$toParts_u24lambda_u240.put(ChronoUnit.SECONDS, secondsPart);
        $this$toParts_u24lambda_u240.put(ChronoUnit.MINUTES, minutePart);
        $this$toParts_u24lambda_u240.put(ChronoUnit.HOURS, hourPart);
        $this$toParts_u24lambda_u240.put(ChronoUnit.DAYS, $this$toParts.toDays());
        return MapsKt.toSortedMap(MapsKt.build(map2), new Comparator(){

            public final int compare(T a, T b) {
                ChronoUnit it = (ChronoUnit)b;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it);
                it = (ChronoUnit)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it));
            }
        });
    }

    @NotNull
    public static final String formatShort(@NotNull Duration $this$formatShort) {
        Intrinsics.checkNotNullParameter($this$formatShort, "<this>");
        SortedMap<ChronoUnit, Long> parts = FormattingExtensionsKt.toParts($this$formatShort);
        for (Map.Entry entry : ((Map)parts).entrySet()) {
            ChronoUnit unit = (ChronoUnit)entry.getKey();
            Long part = (Long)entry.getValue();
            if (part <= 0L) continue;
            return TranslationsKt.tr$default("" + '[' + part + "] " + unit, false, false, 3, null);
        }
        return TranslationsKt.tr$default("" + '[' + parts.get(ChronoUnit.SECONDS) + "] " + ChronoUnit.SECONDS, false, false, 3, null);
    }

    @NotNull
    public static final String toPrettyString(@NotNull Vector2 $this$toPrettyString) {
        Intrinsics.checkNotNullParameter($this$toPrettyString, "<this>");
        return "" + '(' + (int)$this$toPrettyString.x + ',' + (int)$this$toPrettyString.y + ')';
    }
}

