/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.extensions;

import com.badlogic.gdx.Input;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.glutils.FileTextureData;
import com.badlogic.gdx.graphics.glutils.PixmapTextureData;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.Align;
import com.badlogic.gdx.utils.Array;
import com.unciv.models.skins.SkinStrings;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.RestorableTextButtonStyle;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.fonts.Fonts;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.images.IconCircleGroup;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Pure;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u00e2\u0001\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0002\u001a\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a \u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0007\u001a\u0016\u0010\u000e\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u0013H\u0007\u001a\u0012\u0010\u0014\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0012\u0010\u0017\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0012\u0010\u0018\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0016\u001a\u0012\u0010\u001a\u001a\u00020\u0001*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b\u001a\u0012\u0010\u001d\u001a\u00020\u0001*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b\u001a\u0012\u0010\u001e\u001a\u00020\u0001*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b\u001a\u0012\u0010\u001a\u001a\u00020\u0001*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001f\u001a\u0012\u0010\u001d\u001a\u00020\u0001*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001f\u001a\u0012\u0010\u001e\u001a\u00020\u0001*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001f\u001a0\u0010 \u001a\u00020!*\u00020\u001b2\u0006\u0010\"\u001a\u00020\u00162\b\b\u0002\u0010#\u001a\u00020\u00052\b\b\u0002\u0010$\u001a\u00020\u000b2\b\b\u0002\u0010%\u001a\u00020&\u001a\u0014\u0010'\u001a\u00020!*\u00020\u001b2\b\b\u0002\u0010$\u001a\u00020\u000b\u001a$\u0010(\u001a\u00020)*\u00020\u001b2\u0006\u0010\"\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u000b2\b\b\u0002\u0010*\u001a\u00020\u0005\u001a \u0010+\u001a\u0004\u0018\u00010\u001b*\u00020\u001b2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00050-\u001a\u001c\u0010+\u001a\u0004\u0018\u0001H.\"\u0006\b\u0000\u0010.\u0018\u0001*\u00020\u001bH\u0086\b\u00a2\u0006\u0002\u0010/\u001a\u0014\u00104\u001a\u0004\u0018\u000101*\u0002012\u0006\u00105\u001a\u000201\u001a\u001a\u0010;\u001a\u00020<*\u00020<2\u0006\u0010\"\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u000b\u001a\u0010\u0010=\u001a\u00020>2\u0006\u0010$\u001a\u00020\u000bH\u0002\u001a.\u0010?\u001a\b\u0012\u0004\u0012\u00020>0@*\u00020)2\b\b\u0002\u0010$\u001a\u00020\u000b2\b\b\u0002\u0010A\u001a\u00020\r2\b\b\u0002\u0010B\u001a\u00020\u0016\u001a$\u0010C\u001a\b\u0012\u0004\u0012\u00020>0@*\u00020)2\b\b\u0002\u0010$\u001a\u00020\u000b2\b\b\u0002\u0010D\u001a\u00020\u0016\u001a\u0012\u0010\b\u001a\u00020\u0001*\u00020)2\u0006\u0010E\u001a\u00020\u0005\u001a!\u0010F\u001a\u00020)\"\b\b\u0000\u0010.*\u00020\u001b*\u00020)2\u0006\u0010G\u001a\u0002H.\u00a2\u0006\u0002\u0010H\u001a0\u0010I\u001a\b\u0012\u0004\u0012\u0002H.0@\"\b\b\u0000\u0010.*\u00020\u001b*\b\u0012\u0004\u0012\u0002H.0@2\u0006\u0010J\u001a\u00020\u00162\u0006\u0010K\u001a\u00020\u0016\u001a$\u0010L\u001a\u00020\u0001\"\u0004\b\u0000\u0010.*\b\u0012\u0004\u0012\u0002H.0M2\f\u0010N\u001a\b\u0012\u0004\u0012\u0002H.0O\u001a\u0012\u0010P\u001a\u00020\u0001*\u00020>2\u0006\u0010\"\u001a\u00020\u0016\u001a\u001c\u0010Q\u001a\u00020\u0001*\u00020R2\u0006\u0010G\u001a\u00020\u001b2\b\b\u0002\u0010\u001e\u001a\u00020\u0005\u001a \u0010S\u001a\u00020T*\u00020&2\n\b\u0002\u0010U\u001a\u0004\u0018\u00010V2\b\b\u0002\u0010W\u001a\u00020\u0005\u001a*\u0010X\u001a\u00020<*\u00020&2\u0006\u0010Y\u001a\u00020\u00162\u0006\u0010Z\u001a\u00020\u00162\u0006\u0010[\u001a\u00020\u000b2\u0006\u0010\\\u001a\u00020\u000b\u001a<\u0010]\u001a\u00020<2\b\b\u0002\u0010\"\u001a\u00020\u00162\b\b\u0002\u0010Y\u001a\u00020\u00162\b\b\u0002\u0010[\u001a\u00020\u000b2\b\b\u0002\u0010\\\u001a\u00020\u000b2\f\u0010^\u001a\b\u0012\u0004\u0012\u00020\u00010_\u001a\u001c\u0010`\u001a\u00020<2\u0006\u0010\u001c\u001a\u00020<2\f\u0010^\u001a\b\u0012\u0004\u0012\u00020\u00010_\u001a\n\u0010a\u001a\u00020b*\u00020&\u001a\n\u0010a\u001a\u00020b*\u00020\r\u001a2\u0010a\u001a\u00020b*\u00020&2\b\b\u0002\u0010c\u001a\u00020\u000b2\b\b\u0002\u0010d\u001a\u00020\r2\b\b\u0002\u0010e\u001a\u00020\r2\b\b\u0002\u0010W\u001a\u00020\u0005\u001a,\u0010f\u001a\u00020g*\u00020&2\b\b\u0002\u0010h\u001a\u00020\u00052\u0016\b\u0002\u0010i\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010-\u001a\u0012\u0010j\u001a\u00020b*\u00020b2\u0006\u0010$\u001a\u00020\u000b\u001a\u0012\u0010k\u001a\u00020b*\u00020b2\u0006\u0010\"\u001a\u00020\r\u001a\n\u0010l\u001a\u00020m*\u00020m\u001a\n\u0010n\u001a\u00020\u0005*\u00020\u001f\u001a\u0012\u0010o\u001a\u00020<*\u00020>2\u0006\u0010\"\u001a\u00020\u0016\u001a\u0012\u0010p\u001a\u00020\u0001*\u00020<2\u0006\u0010G\u001a\u00020\u001b\u001a\n\u0010q\u001a\u00020\u0005*\u00020r\u001a\n\u0010s\u001a\u00020\u0005*\u00020r\u001a\n\u0010t\u001a\u00020\u0005*\u00020r\u001a\n\u0010u\u001a\u00020\u0005*\u00020r\u001a\u001f\u0010v\u001a\u00020\u00012\u0012\u0010w\u001a\n\u0012\u0006\b\u0001\u0012\u00020)0x\"\u00020)\u00a2\u0006\u0002\u0010y\u001a\n\u0010z\u001a\u00020{*\u00020|\u001a'\u0010}\u001a\b\u0012\u0004\u0012\u0002H.0@\"\b\b\u0000\u0010.*\u00020\u001b*\u00020~2\u0006\u0010G\u001a\u0002H.\u00a2\u0006\u0002\u0010\u007f\"(\u0010\u0006\u001a\u00020\u0005*\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\"\u0015\u00100\u001a\u000201*\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b2\u00103\"\u0015\u00106\u001a\u00020\u0016*\u0002018F\u00a2\u0006\u0006\u001a\u0004\b7\u00108\"\u0015\u00109\u001a\u00020\u0016*\u0002018F\u00a2\u0006\u0006\u001a\u0004\b:\u00108\u00a8\u0006\u0080\u0001"}, d2={"disable", "", "Lcom/badlogic/gdx/scenes/scene2d/ui/Button;", "enable", "value", "", "isEnabled", "(Lcom/badlogic/gdx/scenes/scene2d/ui/Button;)Z", "setEnabled", "(Lcom/badlogic/gdx/scenes/scene2d/ui/Button;Z)V", "colorFromHex", "Lcom/badlogic/gdx/graphics/Color;", "hexColor", "", "colorFromRGB", "r", "g", "b", "rgb", "", "darken", "t", "", "brighten", "coerceLightnessAtLeast", "minLightness", "centerX", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "parent", "centerY", "center", "Lcom/badlogic/gdx/scenes/scene2d/Stage;", "surroundWithCircle", "Lcom/unciv/ui/images/IconCircleGroup;", "size", "resizeActor", "color", "circleImageLocation", "", "surroundWithThinCircle", "addBorder", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "expandCell", "getAscendant", "predicate", "Lkotlin/Function1;", "T", "(Lcom/badlogic/gdx/scenes/scene2d/Actor;)Ljava/lang/Object;", "stageBoundingBox", "Lcom/badlogic/gdx/math/Rectangle;", "getStageBoundingBox", "(Lcom/badlogic/gdx/scenes/scene2d/Actor;)Lcom/badlogic/gdx/math/Rectangle;", "getOverlap", "other", "top", "getTop", "(Lcom/badlogic/gdx/math/Rectangle;)F", "right", "getRight", "addBorderAllowOpacity", "Lcom/badlogic/gdx/scenes/scene2d/Group;", "getSeparatorImage", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "addSeparator", "Lcom/badlogic/gdx/scenes/scene2d/ui/Cell;", "colSpan", "height", "addSeparatorVertical", "width", "enabled", "addCell", "actor", "(Lcom/badlogic/gdx/scenes/scene2d/ui/Table;Lcom/badlogic/gdx/scenes/scene2d/Actor;)Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "pad", "vertical", "horizontal", "setItems", "Lcom/badlogic/gdx/scenes/scene2d/ui/SelectBox;", "newItems", "", "setSize", "scrollTo", "Lcom/badlogic/gdx/scenes/scene2d/ui/ScrollPane;", "toTextButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "style", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton$TextButtonStyle;", "hideIcons", "toImageButton", "iconSize", "circleSize", "circleColor", "overColor", "getCloseButton", "action", "Lkotlin/Function0;", "addRoundCloseButton", "toLabel", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "fontColor", "fontSize", "alignment", "toCheckBox", "Lcom/badlogic/gdx/scenes/scene2d/ui/CheckBox;", "startsOutChecked", "changeAction", "setFontColor", "setFontSize", "packIfNeeded", "Lcom/badlogic/gdx/scenes/scene2d/ui/WidgetGroup;", "isNarrowerThan4to3", "toGroup", "addToCenter", "isShiftKeyPressed", "Lcom/badlogic/gdx/Input;", "isControlKeyPressed", "isAltKeyPressed", "areSecretKeysPressed", "equalizeColumns", "tables", "", "([Lcom/badlogic/gdx/scenes/scene2d/ui/Table;)V", "getReadonlyPixmap", "Lcom/badlogic/gdx/graphics/Pixmap;", "Lcom/badlogic/gdx/graphics/TextureData;", "addInTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Stack;", "(Lcom/badlogic/gdx/scenes/scene2d/ui/Stack;Lcom/badlogic/gdx/scenes/scene2d/Actor;)Lcom/badlogic/gdx/scenes/scene2d/ui/Cell;", "core"})
@SourceDebugExtension(value={"SMAP\nScene2dExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Scene2dExtensions.kt\ncom/unciv/ui/components/extensions/Scene2dExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,526:1\n1#2:527\n1915#3,2:528\n1661#3,3:532\n13022#4,2:530\n*S KotlinDebug\n*F\n+ 1 Scene2dExtensions.kt\ncom/unciv/ui/components/extensions/Scene2dExtensionsKt\n*L\n274#1:528,2\n489#1:532,3\n484#1:530,2\n*E\n"})
public final class Scene2dExtensionsKt {
    public static final void disable(@NotNull Button $this$disable) {
        Intrinsics.checkNotNullParameter($this$disable, "<this>");
        $this$disable.setTouchable(Touchable.disabled);
        $this$disable.setDisabled(true);
        Button.ButtonStyle oldStyle = $this$disable.getStyle();
        if (oldStyle instanceof RestorableTextButtonStyle) {
            return;
        }
        TextButton.TextButtonStyle disabledStyle = BaseScreen.Companion.getSkin().get("disabled", TextButton.TextButtonStyle.class);
        Intrinsics.checkNotNull(disabledStyle);
        Intrinsics.checkNotNull(oldStyle);
        $this$disable.setStyle(new RestorableTextButtonStyle(disabledStyle, oldStyle));
    }

    public static final void enable(@NotNull Button $this$enable) {
        Intrinsics.checkNotNullParameter($this$enable, "<this>");
        $this$enable.setTouchable(Touchable.enabled);
        Button.ButtonStyle oldStyle = $this$enable.getStyle();
        if (oldStyle instanceof RestorableTextButtonStyle) {
            $this$enable.setStyle(((RestorableTextButtonStyle)oldStyle).getRestoreStyle());
        }
        $this$enable.setDisabled(false);
    }

    public static final boolean isEnabled(@NotNull Button $this$isEnabled) {
        Intrinsics.checkNotNullParameter($this$isEnabled, "<this>");
        return $this$isEnabled.getTouchable() == Touchable.enabled;
    }

    public static final void setEnabled(@NotNull Button $this$isEnabled, boolean value) {
        Intrinsics.checkNotNullParameter($this$isEnabled, "<this>");
        if (value) {
            Scene2dExtensionsKt.enable($this$isEnabled);
        } else {
            Scene2dExtensionsKt.disable($this$isEnabled);
        }
    }

    @NotNull
    public static final Color colorFromHex(int hexColor) {
        int colorSize = 256;
        int r = hexColor / (colorSize * colorSize);
        int g = hexColor / colorSize % colorSize;
        int b = hexColor % colorSize;
        return Scene2dExtensionsKt.colorFromRGB(r, g, b);
    }

    @Pure
    @NotNull
    public static final Color colorFromRGB(int r, int g, int b) {
        return new Color((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 1.0f);
    }

    @Readonly
    @NotNull
    public static final Color colorFromRGB(@NotNull List<Integer> rgb) {
        Intrinsics.checkNotNullParameter(rgb, "rgb");
        return Scene2dExtensionsKt.colorFromRGB(((Number)rgb.get(0)).intValue(), ((Number)rgb.get(1)).intValue(), ((Number)rgb.get(2)).intValue());
    }

    @NotNull
    public static final Color darken(@NotNull Color $this$darken, float t) {
        Intrinsics.checkNotNullParameter($this$darken, "<this>");
        Color color = new Color($this$darken).lerp(Color.BLACK, t);
        Intrinsics.checkNotNullExpressionValue(color, "lerp(...)");
        return color;
    }

    @NotNull
    public static final Color brighten(@NotNull Color $this$brighten, float t) {
        Intrinsics.checkNotNullParameter($this$brighten, "<this>");
        Color it = new Color($this$brighten);
        boolean bl = false;
        float lightness = Math.max($this$brighten.r, Math.max($this$brighten.g, $this$brighten.b));
        float targetRatio = (lightness + t * (1.0f - lightness)) / lightness;
        Color color = it.mul(targetRatio);
        Intrinsics.checkNotNullExpressionValue(color, "mul(...)");
        return color;
    }

    @NotNull
    public static final Color coerceLightnessAtLeast(@NotNull Color $this$coerceLightnessAtLeast, float minLightness) {
        Color color;
        Intrinsics.checkNotNullParameter($this$coerceLightnessAtLeast, "<this>");
        float lightness = Math.max($this$coerceLightnessAtLeast.r, Math.max($this$coerceLightnessAtLeast.g, $this$coerceLightnessAtLeast.b));
        if (lightness < minLightness) {
            Color color2 = $this$coerceLightnessAtLeast.cpy().mul(minLightness / lightness);
            Intrinsics.checkNotNull(color2);
            color = color2;
        } else {
            color = $this$coerceLightnessAtLeast;
        }
        return color;
    }

    public static final void centerX(@NotNull Actor $this$centerX, @NotNull Actor parent) {
        Intrinsics.checkNotNullParameter($this$centerX, "<this>");
        Intrinsics.checkNotNullParameter(parent, "parent");
        $this$centerX.setX(parent.getWidth() / (float)2 - $this$centerX.getWidth() / (float)2);
    }

    public static final void centerY(@NotNull Actor $this$centerY, @NotNull Actor parent) {
        Intrinsics.checkNotNullParameter($this$centerY, "<this>");
        Intrinsics.checkNotNullParameter(parent, "parent");
        $this$centerY.setY(parent.getHeight() / (float)2 - $this$centerY.getHeight() / (float)2);
    }

    public static final void center(@NotNull Actor $this$center, @NotNull Actor parent) {
        Intrinsics.checkNotNullParameter($this$center, "<this>");
        Intrinsics.checkNotNullParameter(parent, "parent");
        Scene2dExtensionsKt.centerX($this$center, parent);
        Scene2dExtensionsKt.centerY($this$center, parent);
    }

    public static final void centerX(@NotNull Actor $this$centerX, @NotNull Stage parent) {
        Intrinsics.checkNotNullParameter($this$centerX, "<this>");
        Intrinsics.checkNotNullParameter(parent, "parent");
        $this$centerX.setX(parent.getWidth() / (float)2 - $this$centerX.getWidth() / (float)2);
    }

    public static final void centerY(@NotNull Actor $this$centerY, @NotNull Stage parent) {
        Intrinsics.checkNotNullParameter($this$centerY, "<this>");
        Intrinsics.checkNotNullParameter(parent, "parent");
        $this$centerY.setY(parent.getHeight() / (float)2 - $this$centerY.getHeight() / (float)2);
    }

    public static final void center(@NotNull Actor $this$center, @NotNull Stage parent) {
        Intrinsics.checkNotNullParameter($this$center, "<this>");
        Intrinsics.checkNotNullParameter(parent, "parent");
        Scene2dExtensionsKt.centerX($this$center, parent);
        Scene2dExtensionsKt.centerY($this$center, parent);
    }

    @NotNull
    public static final IconCircleGroup surroundWithCircle(@NotNull Actor $this$surroundWithCircle, float size, boolean resizeActor, @NotNull Color color, @NotNull String circleImageLocation) {
        Intrinsics.checkNotNullParameter($this$surroundWithCircle, "<this>");
        Intrinsics.checkNotNullParameter(color, "color");
        Intrinsics.checkNotNullParameter(circleImageLocation, "circleImageLocation");
        return new IconCircleGroup(size, $this$surroundWithCircle, resizeActor, color, circleImageLocation);
    }

    public static /* synthetic */ IconCircleGroup surroundWithCircle$default(Actor actor, float f, boolean bl, Color color, String string, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            Color color2 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color2, "WHITE");
            color = color2;
        }
        if ((n & 8) != 0) {
            string = "OtherIcons/Circle";
        }
        return Scene2dExtensionsKt.surroundWithCircle(actor, f, bl, color, string);
    }

    @NotNull
    public static final IconCircleGroup surroundWithThinCircle(@NotNull Actor $this$surroundWithThinCircle, @NotNull Color color) {
        Intrinsics.checkNotNullParameter($this$surroundWithThinCircle, "<this>");
        Intrinsics.checkNotNullParameter(color, "color");
        return Scene2dExtensionsKt.surroundWithCircle$default($this$surroundWithThinCircle, $this$surroundWithThinCircle.getWidth() + 2.0f, false, color, null, 8, null);
    }

    public static /* synthetic */ IconCircleGroup surroundWithThinCircle$default(Actor actor, Color color, int n, Object object) {
        if ((n & 1) != 0) {
            color = ImageGetter.INSTANCE.getCHARCOAL();
        }
        return Scene2dExtensionsKt.surroundWithThinCircle(actor, color);
    }

    @NotNull
    public static final Table addBorder(@NotNull Actor $this$addBorder, float size, @NotNull Color color, boolean expandCell) {
        Intrinsics.checkNotNullParameter($this$addBorder, "<this>");
        Intrinsics.checkNotNullParameter(color, "color");
        Table table2 = new Table();
        table2.pad(size);
        table2.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "General/Border", null, color, 2, null));
        Cell<Actor> cell = table2.add($this$addBorder);
        if (expandCell) {
            cell.expand();
        }
        cell.fill();
        table2.pack();
        return table2;
    }

    public static /* synthetic */ Table addBorder$default(Actor actor, float f, Color color, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return Scene2dExtensionsKt.addBorder(actor, f, color, bl);
    }

    @Nullable
    public static final Actor getAscendant(@NotNull Actor $this$getAscendant, @NotNull Function1<? super Actor, Boolean> predicate) {
        Intrinsics.checkNotNullParameter($this$getAscendant, "<this>");
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        for (Group curParent = $this$getAscendant.getParent(); curParent != null; curParent = curParent.getParent()) {
            if (!predicate.invoke(curParent).booleanValue()) continue;
            return curParent;
        }
        return null;
    }

    public static final /* synthetic */ <T> T getAscendant(Actor $this$getAscendant) {
        Intrinsics.checkNotNullParameter($this$getAscendant, "<this>");
        boolean $i$f$getAscendant = false;
        Intrinsics.needClassReification();
        Actor actor = Scene2dExtensionsKt.getAscendant($this$getAscendant, getAscendant.1.INSTANCE);
        Intrinsics.reifiedOperationMarker(2, "T");
        return (T)actor;
    }

    @NotNull
    public static final Rectangle getStageBoundingBox(@NotNull Actor $this$stageBoundingBox) {
        Intrinsics.checkNotNullParameter($this$stageBoundingBox, "<this>");
        Vector2 bottomLeft = $this$stageBoundingBox.localToStageCoordinates(Vector2.Zero.cpy());
        Vector2 topRight = $this$stageBoundingBox.localToStageCoordinates(new Vector2($this$stageBoundingBox.getWidth(), $this$stageBoundingBox.getHeight()));
        return new Rectangle(bottomLeft.x, bottomLeft.y, topRight.x - bottomLeft.x, topRight.y - bottomLeft.y);
    }

    @Nullable
    public static final Rectangle getOverlap(@NotNull Rectangle $this$getOverlap, @NotNull Rectangle other) {
        boolean noOverlap;
        Intrinsics.checkNotNullParameter($this$getOverlap, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        float overlapX = $this$getOverlap.x > other.x ? $this$getOverlap.x : other.x;
        float rightX = $this$getOverlap.x + $this$getOverlap.width;
        float otherRightX = other.x + other.width;
        float overlapWidth = (rightX < otherRightX ? rightX : otherRightX) - overlapX;
        float overlapY = $this$getOverlap.y > other.y ? $this$getOverlap.y : other.y;
        float topY = $this$getOverlap.y + $this$getOverlap.height;
        float otherTopY = other.y + other.height;
        float overlapHeight = (topY < otherTopY ? topY : otherTopY) - overlapY;
        boolean bl = noOverlap = overlapWidth <= 0.0f || overlapHeight <= 0.0f;
        if (noOverlap) {
            return null;
        }
        return new Rectangle(overlapX, overlapY, overlapWidth, overlapHeight);
    }

    public static final float getTop(@NotNull Rectangle $this$top) {
        Intrinsics.checkNotNullParameter($this$top, "<this>");
        return $this$top.y + $this$top.height;
    }

    public static final float getRight(@NotNull Rectangle $this$right) {
        Intrinsics.checkNotNullParameter($this$right, "<this>");
        return $this$right.x + $this$right.width;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Group addBorderAllowOpacity(@NotNull Group $this$addBorderAllowOpacity, float size, @NotNull Color color) {
        void $this$addBorderAllowOpacity_u24lambda_u245;
        Image $this$addBorderAllowOpacity_u24lambda_u244;
        Image $this$addBorderAllowOpacity_u24lambda_u242;
        Image $this$addBorderAllowOpacity_u24lambda_u241;
        Image image;
        Intrinsics.checkNotNullParameter($this$addBorderAllowOpacity, "<this>");
        Intrinsics.checkNotNullParameter(color, "color");
        Group group = $this$addBorderAllowOpacity;
        Image image2 = image = Scene2dExtensionsKt.addBorderAllowOpacity$getTopBottomBorder(color, group, size);
        Group group2 = $this$addBorderAllowOpacity;
        boolean bl = false;
        $this$addBorderAllowOpacity_u24lambda_u241.setPosition(0.0f, group.getHeight(), 10);
        group2.addActor(image);
        $this$addBorderAllowOpacity_u24lambda_u241 = image = Scene2dExtensionsKt.addBorderAllowOpacity$getTopBottomBorder(color, group, size);
        group2 = $this$addBorderAllowOpacity;
        boolean bl2 = false;
        $this$addBorderAllowOpacity_u24lambda_u242.setPosition(0.0f, 0.0f, 12);
        group2.addActor(image);
        $this$addBorderAllowOpacity_u24lambda_u242 = image = Scene2dExtensionsKt.addBorderAllowOpacity$getLeftRightBorder(color, size, group);
        group2 = $this$addBorderAllowOpacity;
        boolean bl3 = false;
        $this$addBorderAllowOpacity_u24lambda_u244.setPosition(0.0f, 0.0f, 12);
        group2.addActor(image);
        $this$addBorderAllowOpacity_u24lambda_u244 = image = Scene2dExtensionsKt.addBorderAllowOpacity$getLeftRightBorder(color, size, group);
        group2 = $this$addBorderAllowOpacity;
        boolean bl4 = false;
        $this$addBorderAllowOpacity_u24lambda_u245.setPosition(group.getWidth(), 0.0f, 20);
        group2.addActor(image);
        return group;
    }

    private static final Image getSeparatorImage(Color color) {
        return new Image(ImageGetter.INSTANCE.getWhiteDotDrawable().tint(!(color.a == 0.0f) ? color : BaseScreen.Companion.getSkin().getColor("color")));
    }

    @NotNull
    public static final Cell<Image> addSeparator(@NotNull Table $this$addSeparator, @NotNull Color color, int colSpan, float height) {
        Intrinsics.checkNotNullParameter($this$addSeparator, "<this>");
        Intrinsics.checkNotNullParameter(color, "color");
        if (!$this$addSeparator.getCells().isEmpty()) {
            Array<Cell> array = $this$addSeparator.getCells();
            Intrinsics.checkNotNullExpressionValue(array, "getCells(...)");
            if (!((Cell)CollectionsKt.last((Iterable)array)).isEndRow()) {
                $this$addSeparator.row();
            }
        }
        Image separator = Scene2dExtensionsKt.getSeparatorImage(color);
        Cell<Actor> cell = $this$addSeparator.add((Actor)separator).colspan(colSpan == 0 ? $this$addSeparator.getColumns() : colSpan).height(height).fillX();
        $this$addSeparator.row();
        Intrinsics.checkNotNull(cell);
        return cell;
    }

    public static /* synthetic */ Cell addSeparator$default(Table table2, Color color, int n, float f, int n2, Object object) {
        if ((n2 & 1) != 0) {
            Color color2 = BaseScreen.Companion.getSkin().getColor("color");
            Intrinsics.checkNotNullExpressionValue(color2, "getColor(...)");
            color = color2;
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            f = 1.0f;
        }
        return Scene2dExtensionsKt.addSeparator(table2, color, n, f);
    }

    @NotNull
    public static final Cell<Image> addSeparatorVertical(@NotNull Table $this$addSeparatorVertical, @NotNull Color color, float width) {
        Intrinsics.checkNotNullParameter($this$addSeparatorVertical, "<this>");
        Intrinsics.checkNotNullParameter(color, "color");
        Cell<Actor> cell = $this$addSeparatorVertical.add((Actor)Scene2dExtensionsKt.getSeparatorImage(color)).width(width).fillY();
        Intrinsics.checkNotNullExpressionValue(cell, "fillY(...)");
        return cell;
    }

    public static /* synthetic */ Cell addSeparatorVertical$default(Table table2, Color color, float f, int n, Object object) {
        if ((n & 1) != 0) {
            Color color2 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color2, "WHITE");
            color = color2;
        }
        if ((n & 2) != 0) {
            f = 2.0f;
        }
        return Scene2dExtensionsKt.addSeparatorVertical(table2, color, f);
    }

    public static final void setEnabled(@NotNull Table $this$setEnabled, boolean enabled) {
        Intrinsics.checkNotNullParameter($this$setEnabled, "<this>");
        $this$setEnabled.getColor().a = enabled ? 1.0f : 0.5f;
        $this$setEnabled.setTouchable(enabled ? Touchable.enabled : Touchable.disabled);
    }

    @NotNull
    public static final <T extends Actor> Table addCell(@NotNull Table $this$addCell, @NotNull T actor) {
        Intrinsics.checkNotNullParameter($this$addCell, "<this>");
        Intrinsics.checkNotNullParameter(actor, "actor");
        $this$addCell.add(actor);
        return $this$addCell;
    }

    @NotNull
    public static final <T extends Actor> Cell<T> pad(@NotNull Cell<T> $this$pad, float vertical, float horizontal) {
        Intrinsics.checkNotNullParameter($this$pad, "<this>");
        Cell<T> cell = $this$pad.pad(vertical, horizontal, vertical, horizontal);
        Intrinsics.checkNotNullExpressionValue(cell, "pad(...)");
        return cell;
    }

    public static final <T> void setItems(@NotNull SelectBox<T> $this$setItems, @NotNull Collection<? extends T> newItems) {
        Intrinsics.checkNotNullParameter($this$setItems, "<this>");
        Intrinsics.checkNotNullParameter(newItems, "newItems");
        Array array = new Array();
        Iterable $this$forEach$iv = newItems;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator2.next();
            boolean bl = false;
            array.add(it);
        }
        $this$setItems.setItems(array);
    }

    public static final void setSize(@NotNull Image $this$setSize, float size) {
        Intrinsics.checkNotNullParameter($this$setSize, "<this>");
        $this$setSize.setSize(size, size);
    }

    public static final void scrollTo(@NotNull ScrollPane $this$scrollTo, @NotNull Actor actor, boolean center) {
        Intrinsics.checkNotNullParameter($this$scrollTo, "<this>");
        Intrinsics.checkNotNullParameter(actor, "actor");
        $this$scrollTo.scrollTo(actor.getX(), actor.getY(), actor.getWidth(), actor.getHeight(), center, center);
    }

    public static /* synthetic */ void scrollTo$default(ScrollPane scrollPane, Actor actor, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        Scene2dExtensionsKt.scrollTo(scrollPane, actor, bl);
    }

    @NotNull
    public static final TextButton toTextButton(@NotNull String $this$toTextButton, @Nullable TextButton.TextButtonStyle style, boolean hideIcons) {
        Intrinsics.checkNotNullParameter($this$toTextButton, "<this>");
        String text2 = TranslationsKt.tr$default($this$toTextButton, hideIcons, false, 2, null);
        return style == null ? new TextButton(text2, BaseScreen.Companion.getSkin()) : new TextButton(text2, style);
    }

    public static /* synthetic */ TextButton toTextButton$default(String string, TextButton.TextButtonStyle textButtonStyle, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            textButtonStyle = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return Scene2dExtensionsKt.toTextButton(string, textButtonStyle, bl);
    }

    @NotNull
    public static final Group toImageButton(@NotNull String $this$toImageButton, float iconSize, float circleSize, @NotNull Color circleColor, @NotNull Color overColor) {
        Intrinsics.checkNotNullParameter($this$toImageButton, "<this>");
        Intrinsics.checkNotNullParameter(circleColor, "circleColor");
        Intrinsics.checkNotNullParameter(overColor, "overColor");
        ImageButton.ImageButtonStyle style = new ImageButton.ImageButtonStyle();
        TextureRegionDrawable image = ImageGetter.INSTANCE.getDrawable($this$toImageButton);
        style.imageUp = image;
        style.imageOver = image.tint(overColor);
        ImageButton button = new ImageButton(style);
        button.setSize(iconSize, iconSize);
        return Scene2dExtensionsKt.surroundWithCircle$default(button, circleSize, false, circleColor, null, 8, null);
    }

    @NotNull
    public static final Group getCloseButton(float size, float iconSize, @NotNull Color circleColor, @NotNull Color overColor, @NotNull Function0<Unit> action2) {
        Intrinsics.checkNotNullParameter(circleColor, "circleColor");
        Intrinsics.checkNotNullParameter(overColor, "overColor");
        Intrinsics.checkNotNullParameter(action2, "action");
        Group closeButton = Scene2dExtensionsKt.toImageButton("OtherIcons/Close", iconSize, size, circleColor, overColor);
        ActivationExtensionsKt.onActivation(closeButton, action2);
        ActivationExtensionsKt.getKeyShortcuts(closeButton).add(KeyCharAndCode.Companion.getBACK());
        return closeButton;
    }

    public static /* synthetic */ Group getCloseButton$default(float f, float f2, Color color, Color color2, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            f = 50.0f;
        }
        if ((n & 2) != 0) {
            f2 = f - 20.0f;
        }
        if ((n & 4) != 0) {
            color = BaseScreen.Companion.getSkinStrings().getSkinConfig().getBaseColor();
        }
        if ((n & 8) != 0) {
            Color color3 = Color.RED;
            Intrinsics.checkNotNullExpressionValue(color3, "RED");
            color2 = color3;
        }
        return Scene2dExtensionsKt.getCloseButton(f, f2, color, color2, function0);
    }

    @NotNull
    public static final Group addRoundCloseButton(@NotNull Group parent, @NotNull Function0<Unit> action2) {
        Intrinsics.checkNotNullParameter(parent, "parent");
        Intrinsics.checkNotNullParameter(action2, "action");
        float size = 30.0f;
        Color color = Color.CLEAR;
        Intrinsics.checkNotNullExpressionValue(color, "CLEAR");
        Color color2 = Color.RED;
        Intrinsics.checkNotNullExpressionValue(color2, "RED");
        Actor actor = Scene2dExtensionsKt.surroundWithCircle$default(Scene2dExtensionsKt.getCloseButton(size, size - 15.0f, color, color2, action2), size, false, BaseScreen.Companion.getClearColor(), null, 8, null);
        Color color3 = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue(color3, "WHITE");
        IconCircleGroup button = Scene2dExtensionsKt.surroundWithCircle$default(actor, size + 4.0f, false, color3, null, 8, null);
        parent.addActor(button);
        button.setPosition(parent.getWidth() - button.getWidth() * (float)3 / (float)4, parent.getHeight() - button.getHeight() * (float)3 / (float)4);
        return button;
    }

    @NotNull
    public static final Label toLabel(@NotNull String $this$toLabel) {
        Intrinsics.checkNotNullParameter($this$toLabel, "<this>");
        return new Label((CharSequence)TranslationsKt.tr$default($this$toLabel, false, false, 3, null), BaseScreen.Companion.getSkin());
    }

    @NotNull
    public static final Label toLabel(int $this$toLabel) {
        return Scene2dExtensionsKt.toLabel(TranslationsKt.tr($this$toLabel));
    }

    @NotNull
    public static final Label toLabel(@NotNull String $this$toLabel, @NotNull Color fontColor, int fontSize, int alignment, boolean hideIcons) {
        Label label;
        Intrinsics.checkNotNullParameter($this$toLabel, "<this>");
        Intrinsics.checkNotNullParameter(fontColor, "fontColor");
        Label.LabelStyle labelStyle = BaseScreen.Companion.getSkin().get(Label.LabelStyle.class);
        if (!Intrinsics.areEqual(fontColor, Color.WHITE) || fontSize != 18) {
            labelStyle = new Label.LabelStyle(labelStyle);
            labelStyle.fontColor = fontColor;
            if (fontSize != 18) {
                labelStyle.font = Fonts.INSTANCE.getFont();
            }
        }
        String translatedText = TranslationsKt.tr$default($this$toLabel, hideIcons, false, 2, null);
        Label $this$toLabel_u24lambda_u240 = label = new Label((CharSequence)translatedText, labelStyle);
        boolean bl = false;
        $this$toLabel_u24lambda_u240.setFontScale((float)fontSize / 100.0f);
        $this$toLabel_u24lambda_u240.setAlignment(alignment);
        return label;
    }

    public static /* synthetic */ Label toLabel$default(String string, Color color, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 1) != 0) {
            Color color2 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color2, "WHITE");
            color = color2;
        }
        if ((n3 & 2) != 0) {
            n = 18;
        }
        if ((n3 & 4) != 0) {
            n2 = 8;
        }
        if ((n3 & 8) != 0) {
            bl = false;
        }
        return Scene2dExtensionsKt.toLabel(string, color, n, n2, bl);
    }

    @NotNull
    public static final CheckBox toCheckBox(@NotNull String $this$toCheckBox, boolean startsOutChecked, @Nullable Function1<? super Boolean, Unit> changeAction) {
        CheckBox checkBox;
        Intrinsics.checkNotNullParameter($this$toCheckBox, "<this>");
        CheckBox $this$toCheckBox_u24lambda_u240 = checkBox = new CheckBox(TranslationsKt.tr$default($this$toCheckBox, false, false, 3, null), BaseScreen.Companion.getSkin());
        boolean bl = false;
        $this$toCheckBox_u24lambda_u240.setChecked(startsOutChecked);
        if (changeAction != null) {
            ActivationExtensionsKt.onChange($this$toCheckBox_u24lambda_u240, arg_0 -> Scene2dExtensionsKt.toCheckBox$lambda$0$0(changeAction, $this$toCheckBox_u24lambda_u240, arg_0));
        }
        $this$toCheckBox_u24lambda_u240.getImageCell().padRight(9.0f);
        return checkBox;
    }

    public static /* synthetic */ CheckBox toCheckBox$default(String string, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            function1 = null;
        }
        return Scene2dExtensionsKt.toCheckBox(string, bl, function1);
    }

    @NotNull
    public static final Label setFontColor(@NotNull Label $this$setFontColor, @NotNull Color color) {
        Intrinsics.checkNotNullParameter($this$setFontColor, "<this>");
        Intrinsics.checkNotNullParameter(color, "color");
        if (!Intrinsics.areEqual(color, $this$setFontColor.getStyle().fontColor)) {
            Label.LabelStyle labelStyle;
            Label.LabelStyle labelStyle2 = labelStyle = new Label.LabelStyle($this$setFontColor.getStyle());
            Label label = $this$setFontColor;
            boolean bl = false;
            $this$setFontColor_u24lambda_u240.fontColor = color;
            label.setStyle(labelStyle);
        }
        return $this$setFontColor;
    }

    @NotNull
    public static final Label setFontSize(@NotNull Label $this$setFontSize, int size) {
        Intrinsics.checkNotNullParameter($this$setFontSize, "<this>");
        $this$setFontSize.setStyle(new Label.LabelStyle($this$setFontSize.getStyle()));
        $this$setFontSize.getStyle().font = Fonts.INSTANCE.getFont();
        $this$setFontSize.setStyle($this$setFontSize.getStyle());
        $this$setFontSize.setFontScale((float)size / 100.0f);
        return $this$setFontSize;
    }

    @NotNull
    public static final WidgetGroup packIfNeeded(@NotNull WidgetGroup $this$packIfNeeded) {
        Intrinsics.checkNotNullParameter($this$packIfNeeded, "<this>");
        if ($this$packIfNeeded.needsLayout()) {
            $this$packIfNeeded.pack();
        }
        return $this$packIfNeeded;
    }

    public static final boolean isNarrowerThan4to3(@NotNull Stage $this$isNarrowerThan4to3) {
        Intrinsics.checkNotNullParameter($this$isNarrowerThan4to3, "<this>");
        return $this$isNarrowerThan4to3.getViewport().getScreenHeight() * 4 > $this$isNarrowerThan4to3.getViewport().getScreenWidth() * 3;
    }

    @NotNull
    public static final Group toGroup(@NotNull Image $this$toGroup, float size) {
        Group group;
        Intrinsics.checkNotNullParameter($this$toGroup, "<this>");
        Group $this$toGroup_u24lambda_u240 = group = new Group();
        boolean bl = false;
        $this$toGroup_u24lambda_u240.setSize(size, size);
        $this$toGroup.setSize(size, size);
        Scene2dExtensionsKt.center((Actor)$this$toGroup, $this$toGroup_u24lambda_u240);
        $this$toGroup.setOrigin(1);
        $this$toGroup_u24lambda_u240.addActor($this$toGroup);
        return group;
    }

    public static final void addToCenter(@NotNull Group $this$addToCenter, @NotNull Actor actor) {
        Intrinsics.checkNotNullParameter($this$addToCenter, "<this>");
        Intrinsics.checkNotNullParameter(actor, "actor");
        $this$addToCenter.addActor(actor);
        Scene2dExtensionsKt.center(actor, $this$addToCenter);
    }

    public static final boolean isShiftKeyPressed(@NotNull Input $this$isShiftKeyPressed) {
        Intrinsics.checkNotNullParameter($this$isShiftKeyPressed, "<this>");
        return $this$isShiftKeyPressed.isKeyPressed(59) || $this$isShiftKeyPressed.isKeyPressed(60);
    }

    public static final boolean isControlKeyPressed(@NotNull Input $this$isControlKeyPressed) {
        Intrinsics.checkNotNullParameter($this$isControlKeyPressed, "<this>");
        return $this$isControlKeyPressed.isKeyPressed(129) || $this$isControlKeyPressed.isKeyPressed(130);
    }

    public static final boolean isAltKeyPressed(@NotNull Input $this$isAltKeyPressed) {
        Intrinsics.checkNotNullParameter($this$isAltKeyPressed, "<this>");
        return $this$isAltKeyPressed.isKeyPressed(57) || $this$isAltKeyPressed.isKeyPressed(58);
    }

    public static final boolean areSecretKeysPressed(@NotNull Input $this$areSecretKeysPressed) {
        Intrinsics.checkNotNullParameter($this$areSecretKeysPressed, "<this>");
        return $this$areSecretKeysPressed.isKeyPressed(60) && ($this$areSecretKeysPressed.isKeyPressed(130) || $this$areSecretKeysPressed.isKeyPressed(58));
    }

    /*
     * WARNING - void declaration
     */
    public static final void equalizeColumns(Table ... tables) {
        Object object;
        void $this$mapTo$iv;
        boolean bl;
        int n;
        int columns;
        block14: {
            Intrinsics.checkNotNullParameter(tables, "tables");
            int n2 = tables.length;
            for (int i = 0; i < n2; ++i) {
                Table table2 = tables[i];
                Scene2dExtensionsKt.packIfNeeded(table2);
            }
            columns = ArraysKt.first(tables).getColumns();
            Table[] $this$all$iv = tables;
            boolean $i$f$all = false;
            int n3 = $this$all$iv.length;
            for (int i = 0; i < n3; ++i) {
                Table table2;
                Table it = table2 = $this$all$iv[i];
                n = 0;
                if (it.getColumns() >= columns) continue;
                bl = false;
                break block14;
            }
            bl = true;
        }
        if (!bl) {
            boolean $i$a$-check-Scene2dExtensionsKt$equalizeColumns$332 = false;
            String $i$a$-check-Scene2dExtensionsKt$equalizeColumns$332 = "IPageExtensions.equalizeColumns needs all tables to have at least the same number of columns as the first one";
            throw new IllegalStateException($i$a$-check-Scene2dExtensionsKt$equalizeColumns$332.toString());
        }
        Iterable $i$a$-check-Scene2dExtensionsKt$equalizeColumns$332 = RangesKt.until(0, columns);
        Collection destination$iv = new ArrayList(columns);
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv.iterator();
        while (iterator2.hasNext()) {
            void column;
            int item$iv;
            n = item$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv;
            boolean bl2 = false;
            object = tables;
            if (((Table[])object).length == 0) {
                throw new NoSuchElementException();
            }
            Table it232 = object[0];
            int n3 = 0;
            float it232 = it232.getColumnWidth((int)column);
            n3 = 1;
            int n4 = ArraysKt.getLastIndex(object);
            if (n3 <= n4) {
                while (true) {
                    Table it = object[n3];
                    boolean bl3 = false;
                    float f = it.getColumnWidth((int)column);
                    it232 = Math.max(it232, f);
                    if (n3 == n4) break;
                    ++n3;
                }
            }
            collection.add(Float.valueOf(it232));
        }
        ArrayList widths = (ArrayList)destination$iv;
        for (Table table3 : tables) {
            void var6_17;
            boolean bl2 = false;
            while (var6_17 < columns) {
                Cell $this$equalizeColumns_u24lambda_u243 = table3.getCells().get((int)var6_17);
                boolean bl4 = false;
                if ($this$equalizeColumns_u24lambda_u243.getActor() == null) {
                    $this$equalizeColumns_u24lambda_u243.setActor((Actor)Scene2dExtensionsKt.toLabel(""));
                } else {
                    Integer n5 = $this$equalizeColumns_u24lambda_u243.getAlign();
                    Intrinsics.checkNotNullExpressionValue(n5, "getAlign(...)");
                    if (Align.isCenterHorizontal(((Number)n5).intValue())) {
                        object = $this$equalizeColumns_u24lambda_u243.getActor();
                        if ((object instanceof Label ? (Label)object : null) != null) {
                            Label $this$equalizeColumns_u24lambda_u243_u240;
                            $this$equalizeColumns_u24lambda_u243_u240 = $this$equalizeColumns_u24lambda_u243_u240;
                            boolean bl5 = false;
                            if (!Align.isCenterHorizontal($this$equalizeColumns_u24lambda_u243_u240.getLabelAlign())) {
                                $this$equalizeColumns_u24lambda_u243_u240.setAlignment(1);
                            }
                        }
                    }
                }
                $this$equalizeColumns_u24lambda_u243.minWidth(((Number)widths.get((int)var6_17)).floatValue() - $this$equalizeColumns_u24lambda_u243.getPadLeft() - $this$equalizeColumns_u24lambda_u243.getPadRight());
                ++var6_17;
            }
            table3.invalidate();
        }
    }

    @NotNull
    public static final Pixmap getReadonlyPixmap(@NotNull TextureData $this$getReadonlyPixmap) {
        Intrinsics.checkNotNullParameter($this$getReadonlyPixmap, "<this>");
        if (!$this$getReadonlyPixmap.isPrepared()) {
            $this$getReadonlyPixmap.prepare();
        }
        if ($this$getReadonlyPixmap instanceof PixmapTextureData) {
            Pixmap pixmap = ((PixmapTextureData)$this$getReadonlyPixmap).consumePixmap();
            Intrinsics.checkNotNullExpressionValue(pixmap, "consumePixmap(...)");
            return pixmap;
        }
        if (!($this$getReadonlyPixmap instanceof FileTextureData)) {
            throw new TypeCastException("getReadonlyPixmap only works on file or pixmap based textures");
        }
        Field field2 = FileTextureData.class.getDeclaredField("pixmap");
        field2.setAccessible(true);
        Object object = field2.get($this$getReadonlyPixmap);
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type com.badlogic.gdx.graphics.Pixmap");
        return (Pixmap)object;
    }

    @NotNull
    public static final <T extends Actor> Cell<T> addInTable(@NotNull Stack $this$addInTable, @NotNull T actor) {
        Intrinsics.checkNotNullParameter($this$addInTable, "<this>");
        Intrinsics.checkNotNullParameter(actor, "actor");
        Table table2 = new Table();
        $this$addInTable.add(table2);
        Cell<T> cell = table2.add(actor).grow();
        Intrinsics.checkNotNullExpressionValue(cell, "grow(...)");
        return cell;
    }

    private static final Image addBorderAllowOpacity$getTopBottomBorder(Color $color, Group group, float $size) {
        Image image;
        Image $this$addBorderAllowOpacity_u24getTopBottomBorder_u24lambda_u240 = image = ImageGetter.INSTANCE.getDot($color);
        boolean bl = false;
        $this$addBorderAllowOpacity_u24getTopBottomBorder_u24lambda_u240.setWidth(group.getWidth());
        $this$addBorderAllowOpacity_u24getTopBottomBorder_u24lambda_u240.setHeight($size);
        return image;
    }

    private static final Image addBorderAllowOpacity$getLeftRightBorder(Color $color, float $size, Group group) {
        Image image;
        Image $this$addBorderAllowOpacity_u24getLeftRightBorder_u24lambda_u243 = image = ImageGetter.INSTANCE.getDot($color);
        boolean bl = false;
        $this$addBorderAllowOpacity_u24getLeftRightBorder_u24lambda_u243.setWidth($size);
        $this$addBorderAllowOpacity_u24getLeftRightBorder_u24lambda_u243.setHeight(group.getHeight());
        return image;
    }

    private static final Unit toCheckBox$lambda$0$0(Function1 $changeAction, CheckBox $this_apply, ChangeListener.ChangeEvent it) {
        $changeAction.invoke($this_apply.isChecked());
        return Unit.INSTANCE;
    }
}

