/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.input;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.unciv.ui.components.extensions.GdxKeyCodeFixes;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0012\u0012\u0006\u0010\b\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0006\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u000bJ\n\u0010\u0010\u001a\u00020\u0011H\u0096\u0080\u0004J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0018\u001a\u00020\u0005H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/unciv/ui/components/input/KeyCharAndCode;", "", "char", "", "code", "", "<init>", "(CI)V", "from", "(Lcom/unciv/ui/components/input/KeyCharAndCode;)V", "(C)V", "(I)V", "getChar", "()C", "getCode", "()I", "toString", "", "component1", "component2", "copy", "equals", "", "other", "hashCode", "Companion", "Serializer", "core"})
public final class KeyCharAndCode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final char char;
    private final int code;
    @NotNull
    private static final KeyCharAndCode BACK = new KeyCharAndCode(4);
    @NotNull
    private static final KeyCharAndCode ESC = new KeyCharAndCode(111);
    @NotNull
    private static final KeyCharAndCode RETURN = new KeyCharAndCode(66);
    @NotNull
    private static final KeyCharAndCode NUMPAD_ENTER = new KeyCharAndCode(160);
    @NotNull
    private static final KeyCharAndCode SPACE = new KeyCharAndCode(62);
    @NotNull
    private static final KeyCharAndCode DEL = new KeyCharAndCode(112);
    @NotNull
    private static final KeyCharAndCode TAB = new KeyCharAndCode(61);
    @NotNull
    private static final KeyCharAndCode UNKNOWN = new KeyCharAndCode(0);

    public KeyCharAndCode(char c, int code) {
        this.char = c;
        this.code = code;
    }

    public final char getChar() {
        return this.char;
    }

    public final int getCode() {
        return this.code;
    }

    private KeyCharAndCode(KeyCharAndCode from) {
        this(from.char, from.code);
    }

    public KeyCharAndCode(char c) {
        this(Companion.mapChar(c));
    }

    public KeyCharAndCode(int code) {
        this('\u0000', code);
    }

    @NotNull
    public String toString() {
        return Intrinsics.areEqual(this, UNKNOWN) ? "" : (this.char == '\u0000' ? GdxKeyCodeFixes.INSTANCE.toString(this.code) : (Intrinsics.areEqual(this, ESC) ? "ESC" : (Intrinsics.compare(this.char, 32) < 0 ? "Ctrl-" + Companion.makeChar(Companion.toCode(this.char) + 64) : "" + '\"' + this.char + '\"')));
    }

    public final char component1() {
        return this.char;
    }

    public final int component2() {
        return this.code;
    }

    @NotNull
    public final KeyCharAndCode copy(char c, int code) {
        return new KeyCharAndCode(c, code);
    }

    public static /* synthetic */ KeyCharAndCode copy$default(KeyCharAndCode keyCharAndCode, char c, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            c = keyCharAndCode.char;
        }
        if ((n2 & 2) != 0) {
            n = keyCharAndCode.code;
        }
        return keyCharAndCode.copy(c, n);
    }

    public int hashCode() {
        int result2 = Character.hashCode(this.char);
        result2 = result2 * 31 + Integer.hashCode(this.code);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KeyCharAndCode)) {
            return false;
        }
        KeyCharAndCode keyCharAndCode = (KeyCharAndCode)other;
        if (this.char != keyCharAndCode.char) {
            return false;
        }
        return this.code == keyCharAndCode.code;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\u0010\f\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0016\u001a\u00020\u0017*\u00020\u0018J\n\u0010\u0019\u001a\u00020\u0018*\u00020\u0017J\u000e\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0018J\u000e\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0017J\u000e\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0018J\u000e\u0010 \u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0018J\u000e\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020#R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007R\u0011\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007\u00a8\u0006$"}, d2={"Lcom/unciv/ui/components/input/KeyCharAndCode$Companion;", "", "<init>", "()V", "BACK", "Lcom/unciv/ui/components/input/KeyCharAndCode;", "getBACK", "()Lcom/unciv/ui/components/input/KeyCharAndCode;", "ESC", "getESC", "RETURN", "getRETURN", "NUMPAD_ENTER", "getNUMPAD_ENTER", "SPACE", "getSPACE", "DEL", "getDEL", "TAB", "getTAB", "UNKNOWN", "getUNKNOWN", "toCode", "", "", "makeChar", "ctrl", "letter", "ctrlFromCode", "keyCode", "ascii", "char", "mapChar", "parse", "text", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KeyCharAndCode getBACK() {
            return BACK;
        }

        @NotNull
        public final KeyCharAndCode getESC() {
            return ESC;
        }

        @NotNull
        public final KeyCharAndCode getRETURN() {
            return RETURN;
        }

        @NotNull
        public final KeyCharAndCode getNUMPAD_ENTER() {
            return NUMPAD_ENTER;
        }

        @NotNull
        public final KeyCharAndCode getSPACE() {
            return SPACE;
        }

        @NotNull
        public final KeyCharAndCode getDEL() {
            return DEL;
        }

        @NotNull
        public final KeyCharAndCode getTAB() {
            return TAB;
        }

        @NotNull
        public final KeyCharAndCode getUNKNOWN() {
            return UNKNOWN;
        }

        public final int toCode(char $this$toCode) {
            return $this$toCode;
        }

        public final char makeChar(int $this$makeChar) {
            if ($this$makeChar < 0 || $this$makeChar > 65535) {
                throw new IllegalArgumentException("Invalid Char code: " + $this$makeChar);
            }
            return (char)$this$makeChar;
        }

        @NotNull
        public final KeyCharAndCode ctrl(char letter) {
            return new KeyCharAndCode(this.makeChar(this.toCode(letter) & 0x1F), 0);
        }

        @NotNull
        public final KeyCharAndCode ctrlFromCode(int keyCode) {
            String name = GdxKeyCodeFixes.INSTANCE.toString(keyCode);
            if (name.length() != 1 || !Character.isLetter(name.charAt(0))) {
                return new KeyCharAndCode('\u0000', keyCode);
            }
            return this.ctrl(name.charAt(0));
        }

        @NotNull
        public final KeyCharAndCode ascii(char c) {
            return new KeyCharAndCode(Character.toLowerCase(c), 0);
        }

        @NotNull
        public final KeyCharAndCode mapChar(char c) {
            int code = GdxKeyCodeFixes.INSTANCE.valueOf(String.valueOf(Character.toUpperCase(c)));
            return code == -1 ? new KeyCharAndCode(c, 0) : new KeyCharAndCode('\u0000', code);
        }

        @NotNull
        public final KeyCharAndCode parse(@NotNull String text2) {
            int code;
            Intrinsics.checkNotNullParameter(text2, "text");
            return text2.length() == 1 && Character.isDefined(text2.charAt(0)) ? new KeyCharAndCode(text2.charAt(0)) : (text2.length() == 3 && text2.charAt(0) == '\"' && text2.charAt(2) == '\"' ? new KeyCharAndCode(text2.charAt(1)) : (text2.length() == 6 && StringsKt.startsWith$default(text2, "Ctrl-", false, 2, null) ? this.ctrl(text2.charAt(5)) : (Intrinsics.areEqual(text2, "ESC") ? this.getESC() : ((code = GdxKeyCodeFixes.INSTANCE.valueOf(text2)) == -1 ? this.getUNKNOWN() : new KeyCharAndCode(code)))));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\f\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000bH\u0016J&\u0010\f\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000bH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/unciv/ui/components/input/KeyCharAndCode$Serializer;", "Lcom/badlogic/gdx/utils/Json$Serializer;", "Lcom/unciv/ui/components/input/KeyCharAndCode;", "<init>", "()V", "write", "", "json", "Lcom/badlogic/gdx/utils/Json;", "key", "knownType", "Ljava/lang/Class;", "read", "jsonData", "Lcom/badlogic/gdx/utils/JsonValue;", "type", "core"})
    public static final class Serializer
    implements Json.Serializer<KeyCharAndCode> {
        @Override
        public void write(@NotNull Json json, @NotNull KeyCharAndCode key, @Nullable Class<?> knownType) {
            Intrinsics.checkNotNullParameter(json, "json");
            Intrinsics.checkNotNullParameter(key, "key");
            String string = key.toString();
            Intrinsics.checkNotNull(string, "null cannot be cast to non-null type kotlin.Any");
            json.writeValue((Object)string, String.class, null);
        }

        @Override
        @NotNull
        public KeyCharAndCode read(@NotNull Json json, @NotNull JsonValue jsonData, @Nullable Class<?> type) {
            Intrinsics.checkNotNullParameter(json, "json");
            Intrinsics.checkNotNullParameter(jsonData, "jsonData");
            String string = jsonData.asString();
            Intrinsics.checkNotNullExpressionValue(string, "asString(...)");
            return Companion.parse(string);
        }
    }
}

