/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.input;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.actions.RepeatAction;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.utils.Disposable;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.components.input.KeyboardBindings;
import com.unciv.ui.components.widgets.ZoomableScrollPane;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \"2\u00020\u00012\u00020\u0002:\u0001\"B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000bH\u0016J\u001a\u0010\u001c\u001a\u00020\u00062\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u000bH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u001eH\u0002J\b\u0010 \u001a\u00020\u001eH\u0002J\b\u0010!\u001a\u00020\u001eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/unciv/ui/components/input/KeyboardPanningListener;", "Lcom/badlogic/gdx/scenes/scene2d/InputListener;", "Lcom/badlogic/gdx/utils/Disposable;", "mapHolder", "Lcom/unciv/ui/components/widgets/ZoomableScrollPane;", "allowWASD", "", "<init>", "(Lcom/unciv/ui/components/widgets/ZoomableScrollPane;Z)V", "pressedKeys", "", "", "infiniteAction", "Lcom/badlogic/gdx/scenes/scene2d/actions/RepeatAction;", "keycodeUp", "keycodeLeft", "keycodeDown", "keycodeRight", "keycodeUpAlt", "keycodeLeftAlt", "keycodeDownAlt", "keycodeRightAlt", "allowedKeys", "", "keyDown", "event", "Lcom/badlogic/gdx/scenes/scene2d/InputEvent;", "keycode", "keyUp", "startLoop", "", "stopLoop", "whileKeyPressedLoop", "dispose", "Companion", "core"})
public final class KeyboardPanningListener
extends InputListener
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ZoomableScrollPane mapHolder;
    @NotNull
    private final Set<Integer> pressedKeys;
    @Nullable
    private RepeatAction infiniteAction;
    private final int keycodeUp;
    private final int keycodeLeft;
    private final int keycodeDown;
    private final int keycodeRight;
    private final int keycodeUpAlt;
    private final int keycodeLeftAlt;
    private final int keycodeDownAlt;
    private final int keycodeRightAlt;
    @NotNull
    private final Set<Integer> allowedKeys;
    public static final float deltaTime = 0.01f;

    public KeyboardPanningListener(@NotNull ZoomableScrollPane mapHolder, boolean allowWASD) {
        Set<Object> set;
        Intrinsics.checkNotNullParameter(mapHolder, "mapHolder");
        this.mapHolder = mapHolder;
        this.pressedKeys = new LinkedHashSet();
        this.keycodeUp = KeyboardBindings.Companion.get(KeyboardBinding.PanUp).getCode();
        this.keycodeLeft = KeyboardBindings.Companion.get(KeyboardBinding.PanLeft).getCode();
        this.keycodeDown = KeyboardBindings.Companion.get(KeyboardBinding.PanDown).getCode();
        this.keycodeRight = KeyboardBindings.Companion.get(KeyboardBinding.PanRight).getCode();
        this.keycodeUpAlt = KeyboardBindings.Companion.get(KeyboardBinding.PanUpAlternate).getCode();
        this.keycodeLeftAlt = KeyboardBindings.Companion.get(KeyboardBinding.PanLeftAlternate).getCode();
        this.keycodeDownAlt = KeyboardBindings.Companion.get(KeyboardBinding.PanDownAlternate).getCode();
        this.keycodeRightAlt = KeyboardBindings.Companion.get(KeyboardBinding.PanRightAlternate).getCode();
        Integer[] integerArray = new Integer[]{this.keycodeUp, this.keycodeLeft, this.keycodeDown, this.keycodeRight};
        Set<Integer> set2 = SetsKt.setOf(integerArray);
        if (allowWASD) {
            integerArray = new Integer[]{this.keycodeUpAlt, this.keycodeLeftAlt, this.keycodeDownAlt, this.keycodeRightAlt};
            set = SetsKt.setOf(integerArray);
        } else {
            set = SetsKt.emptySet();
        }
        this.allowedKeys = SetsKt.plus(set2, (Iterable)set);
    }

    @Override
    public boolean keyDown(@NotNull InputEvent event, int keycode) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getTarget() instanceof TextField) {
            return false;
        }
        if (!this.allowedKeys.contains(keycode)) {
            return false;
        }
        Input input2 = Gdx.input;
        Intrinsics.checkNotNullExpressionValue(input2, "input");
        if (Scene2dExtensionsKt.isControlKeyPressed(input2)) {
            return false;
        }
        this.pressedKeys.add(keycode);
        this.startLoop();
        return true;
    }

    @Override
    public boolean keyUp(@Nullable InputEvent event, int keycode) {
        if (!this.allowedKeys.contains(keycode)) {
            return false;
        }
        this.pressedKeys.remove(keycode);
        if (this.pressedKeys.isEmpty()) {
            this.stopLoop();
        }
        return true;
    }

    private final void startLoop() {
        if (this.infiniteAction != null) {
            return;
        }
        this.infiniteAction = Actions.forever(Actions.delay(0.01f, Actions.run(() -> KeyboardPanningListener.startLoop$lambda$0(this))));
        this.mapHolder.addAction(this.infiniteAction);
    }

    private final void stopLoop() {
        if (this.infiniteAction == null) {
            return;
        }
        RepeatAction repeatAction = this.infiniteAction;
        if (repeatAction != null) {
            repeatAction.finish();
        }
        this.mapHolder.removeAction(this.infiniteAction);
        this.infiniteAction = null;
    }

    private final void whileKeyPressedLoop() {
        float deltaX = 0.0f;
        float deltaY = 0.0f;
        for (Integer n : this.pressedKeys) {
            int keycode;
            Intrinsics.checkNotNullExpressionValue(n, "next(...)");
            int n2 = keycode = ((Number)n).intValue();
            if (n2 == this.keycodeUp || n2 == this.keycodeUpAlt) {
                deltaY -= 1.0f;
                continue;
            }
            if (n2 == this.keycodeDown || n2 == this.keycodeDownAlt) {
                deltaY += 1.0f;
                continue;
            }
            if (n2 == this.keycodeLeft || n2 == this.keycodeLeftAlt) {
                deltaX += 1.0f;
                continue;
            }
            if (n2 != this.keycodeRight && n2 != this.keycodeRightAlt) continue;
            deltaX -= 1.0f;
        }
        this.mapHolder.doKeyOrMousePanning(deltaX, deltaY);
    }

    @Override
    public void dispose() {
        this.stopLoop();
    }

    private static final void startLoop$lambda$0(KeyboardPanningListener this$0) {
        this$0.whileKeyPressedLoop();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/unciv/ui/components/input/KeyboardPanningListener$Companion;", "", "<init>", "()V", "deltaTime", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

